/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.EntityContainer;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.ui.helper.PluggableHelper;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.asap.PimCard;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Observable;
import javax.swing.SwingUtilities;

public class PimSlot
extends CardGraphic {
    private PimCard pimCard = null;
    private PimModel pimCardModel = null;

    public PimSlot(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug, Rectangle rectangle) {
        super(entityModel, abstractShelfLayout, sDebug);
        if (sDebug.on()) {
            sDebug.println("PimSlot: " + entityModel.getEqLabel() + "\tIndex: " + entityModel.getPositionInParent() + "\tNum of children: " + this.entityM.getChildren().size());
        }
        this.setBounds(rectangle);
        this.createChildren();
    }

    protected void createChildren() {
        block7: {
            try {
                List list = this.entityM.getChildren();
                if (list.size() > 0) {
                    EntityModel entityModel = (EntityModel)list.get(0);
                    if (entityModel == null) {
                        return;
                    }
                    if (entityModel instanceof PimModel) {
                        this.pimCardModel = (PimModel)entityModel;
                        this.pimCard = new PimCard(this.pimCardModel, this.parent, new SDebug("PimCard: " + this.pimCardModel.getLocation()), this.getChildBounds());
                    } else if (this.db.on()) {
                        this.db.println("Entity is NOT MfgEntityModel");
                        this.db.println("Entity is " + entityModel);
                    }
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                this.db.println("Exception while creating PIM card");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.registerForUpdates();
    }

    private void registerForUpdates() {
        if (this.entityM != null) {
            this.entityM.addObserver(this);
            if (this.pimCardModel != null) {
                this.pimCardModel.addObserver(this);
            }
            if (this.db.on()) {
                this.db.println("PimSlot: Registered parent: " + this.entityM + "\tChild: " + this.pimCardModel);
            }
        }
    }

    private void deregisterFromUpdates() {
        if (this.entityM != null) {
            this.entityM.deleteObserver(this);
            if (this.pimCardModel != null) {
                this.pimCardModel.deleteObserver(this);
            }
            if (this.db.on()) {
                this.db.println("PimSlot: Deregistered parent: " + this.entityM + "\tChild: " + this.pimCardModel);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (this.entityM == null) {
            if (this.db.on()) {
                this.db.println("update: entityM is NULL, no update");
            }
            return;
        }
        if (observable instanceof EntityModel && this.entityM != null && this.entityM.getNodeModel().isInited() && object instanceof Integer) {
            Integer n = (Integer)object;
            if (n.equals(ModelUpdateType.ADDED) && observable == this.entityM) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (this.db.on()) {
                    this.db.println("PimSlot: PIM card ADDED");
                }
            } else if (n.equals(ModelUpdateType.DELETED) && observable instanceof PimModel && (PimModel)((Object)observable) == this.pimCardModel) {
                SwingUtilities.invokeLater(new ReplaceCard());
                if (this.db.on()) {
                    this.db.println("PimSlot: PIM Card DELETED");
                }
            }
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.computeVisibleRect(this.cardPainter.getMainRectangle().getBounds());
        graphics2D.setColor(Color.gray.brighter());
        graphics2D.fill(this.cardPainter.getMainRectangle());
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.cardPainter.getMainRectangle());
        if (this.pimCard != null) {
            this.pimCard.draw(graphics2D);
        }
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            if (this.pimCard != null && this.pimCard.contains(mouseEvent.getPoint())) {
                return this.pimCard.getTooltipText(mouseEvent);
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append(this.getEqLabel());
            stringBuffer.append(" [");
            stringBuffer.append(PluggableHelper.getHierarchyNumString(((PluggableSlotModel)this.entityM).getHierarchyNums(), '-'));
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.cardPainter.getMainRectangle().setBounds(rectangle);
        super.setBounds(this.cardPainter.getMainRectangle());
    }

    protected Rectangle getChildBounds() {
        return this.getBounds();
    }

    public boolean contains(Point point) {
        return point.x >= this.getX() && point.x <= this.getX() + this.getWidth() && point.y >= this.getY() && point.y <= this.getY() + this.getHeight();
    }

    public boolean hasProvisionedCard() {
        boolean bl;
        block3: {
            bl = false;
            try {
                if (this.entityM instanceof EntityContainer) {
                    bl = this.entityM.getChildren().size() != 0;
                }
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
            }
        }
        return bl;
    }

    public void dispose() {
        this.deregisterFromUpdates();
        if (this.pimCard != null) {
            this.pimCard.dispose();
            this.pimCard = null;
        }
        super.dispose();
    }

    private class ReplaceCard
    implements Runnable {
        private ReplaceCard() {
        }

        public void run() {
            block5: {
                try {
                    PimSlot.this.deregisterFromUpdates();
                    if (PimSlot.this.pimCard != null) {
                        PimSlot.this.pimCard.dispose();
                        PimSlot.this.pimCard = null;
                    }
                    if (PimSlot.this.entityM != null) {
                        PimSlot.this.createChildren();
                    }
                }
                catch (Exception exception) {
                    if (!PimSlot.this.db.on()) break block5;
                    PimSlot.this.db.println("Error replacing PIM card: " + exception);
                    PimSlot.this.db;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (PimSlot.this.parent != null) {
                PimSlot.this.parent.repaint();
            }
        }
    }
}

