/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Node.eDbType;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.shelf.SmpDBPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.shelf.AbstractBRCNDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ConfigureNodeDialog
extends AbstractBRCNDialog {
    private static final String CONFIGURE_TITLE = "Configure Node";
    private JLabel nodeVersionLabel;
    private JTextField nodeVersionField;
    private JLabel nodeIpAddrLabel;
    private JTextField nodeIpAddrField;
    private JLabel dbVersionLabel;
    private JTextField dbVersionField;
    private JLabel dbIpAddrLabel;
    private JTextField dbIpAddrField;
    private JLabel configVersionLabel;
    private JTextField configVersionField;
    private JLabel configIpAddrLabel;
    private JTextField configIpAddrField;
    private final String configNodeMessage = "Are you sure you want to configure the node?\nThe node will reboot after the configuration is completed.\n\nOK to Continue?";
    protected static final SDebug db = new SDebug("ConfigureNodeDialog");

    public ConfigureNodeDialog(SmpDBPane smpDBPane, NodeModelDelegate nodeModelDelegate, int n) {
        super(smpDBPane, nodeModelDelegate, n, CONFIGURE_TITLE);
        this.confirmMessage = "Are you sure you want to configure the node?\nThe node will reboot after the configuration is completed.\n\nOK to Continue?";
        this.setSize(new Dimension(450, 270));
    }

    protected JPanel createOptionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(this.createDatabasePanel());
        jPanel2.add(this.createConfigureNodePanel());
        jPanel.add((Component)this.createNodePanel(), "North");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createNodePanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Current Node Configuration", 1, 2));
        this.nodeVersionLabel = new JLabel("Version:");
        this.nodeVersionLabel.setHorizontalAlignment(0);
        jPanel.add(this.nodeVersionLabel);
        this.nodeVersionField = new JTextField(this.nodeModel.getSwVersion());
        this.nodeVersionField.setEditable(false);
        jPanel.add(this.nodeVersionField);
        this.nodeIpAddrLabel = new JLabel("IP Address:");
        this.nodeIpAddrLabel.setHorizontalAlignment(0);
        jPanel.add(this.nodeIpAddrLabel);
        this.nodeIpAddrField = new JTextField();
        this.nodeIpAddrField.setEditable(false);
        jPanel.add(this.nodeIpAddrField);
        IIpConfig iIpConfig = this.nodeModel.getIpConfig();
        this.nodeIpAddrField.setText(InetUtil.makeDottedString(iIpConfig.getIpAddress()));
        return jPanel;
    }

    private JPanel createDatabasePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2, 5, 5));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Database Configuration", 1, 2));
        JCheckBox jCheckBox = new JCheckBox("Provisioning", true);
        jPanel.add((Component)this.createOptionBox(jCheckBox, false), "North");
        this.dbVersionLabel = new JLabel("Version:");
        jPanel2.add(this.dbVersionLabel);
        this.dbVersionField = new JTextField();
        this.dbVersionField.setEditable(false);
        jPanel2.add(this.dbVersionField);
        this.dbIpAddrLabel = new JLabel("IP Address:");
        jPanel2.add(this.dbIpAddrLabel);
        this.dbIpAddrField = new JTextField();
        this.dbIpAddrField.setEditable(false);
        jPanel2.add(this.dbIpAddrField);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createConfigureNodePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2, 5, 5));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), "New Node Configuration", 1, 2));
        JCheckBox jCheckBox = new JCheckBox("Provisioning", true);
        jPanel.add((Component)this.createOptionBox(jCheckBox, false), "North");
        this.configVersionLabel = new JLabel("Version:");
        jPanel2.add(this.configVersionLabel);
        this.configVersionField = new JTextField();
        this.configVersionField.setEditable(false);
        jPanel2.add(this.configVersionField);
        this.configIpAddrLabel = new JLabel("IP Address:");
        jPanel2.add(this.configIpAddrLabel);
        this.configIpAddrField = new JTextField();
        jPanel2.add(this.configIpAddrField);
        IIpConfig iIpConfig = this.nodeModel.getIpConfig();
        this.configIpAddrField.setText(InetUtil.makeDottedString(iIpConfig.getIpAddress()));
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected void showOpenDialog() {
        super.showOpenDialog();
        this.configIpAddrField.requestFocus();
    }

    protected void restoreDB() {
        this.dbModel.setConfigIpAddr(this.configIpAddrField.getText());
        super.restoreDB();
    }

    protected void setDbTypes(List list) {
        list.add(eDbType.RELEASE);
        list.add(eDbType.PROV);
    }

    protected void setGuiFields() {
        this.dbVersionField.setText(this.dbModel.getDbSwVersion());
        this.configVersionField.setText(this.dbModel.getDbSwVersion());
        this.dbIpAddrField.setText(this.dbModel.getDbIpAddress());
    }

    protected void cleanup() {
        this.nodeVersionLabel = null;
        this.nodeVersionField = null;
        this.nodeIpAddrLabel = null;
        this.nodeIpAddrField = null;
        this.dbVersionLabel = null;
        this.dbVersionField = null;
        this.dbIpAddrLabel = null;
        this.dbIpAddrField = null;
        this.configVersionLabel = null;
        this.configVersionField = null;
        this.configIpAddrLabel = null;
        this.configIpAddrField = null;
        this.removeAll();
        super.cleanup();
    }
}

