/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardPanel;
import cerent.util.gui.IconImpl;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShelfLayout
extends AbstractShelfLayout {
    private static final int SHELF_SLOT_COUNT = 14;
    private static final Font textFont = new Font("Arial", 0, 8);
    private static final Font labelFont = new Font("Arial", 0, 10);

    public ShelfLayout(NodeModelDelegate nodeModelDelegate, ShelfViewController shelfViewController, IUiToolkit iUiToolkit) {
        super(nodeModelDelegate, shelfViewController, iUiToolkit);
    }

    protected int getShelfSlotCount() {
        return 14;
    }

    protected Font getTextFont() {
        return textFont;
    }

    protected void createLabels() {
        if (this.labelsPanel == null) {
            this.labelsPanel = new JPanel(new GridLayout(1, this.cards.length, 0, 0));
            Dimension dimension = new Dimension(34, 12);
            this.labels = new JLabel[this.getShelfSlotCount()];
            for (int i = 0; i < this.cards.length; ++i) {
                JLabel jLabel = new JLabel("" + (i + 1));
                jLabel.setFont(labelFont);
                jLabel.setPreferredSize(dimension);
                jLabel.setMinimumSize(dimension);
                jLabel.setHorizontalAlignment(0);
                this.labels[i] = jLabel;
                this.labelsPanel.add(jLabel);
            }
        }
    }

    protected void createSlotsPanel() {
        this.slotsPanel = new JPanel(new FlowLayout(0, 0, 0));
        for (int i = 0; i < this.cards.length; ++i) {
            IconImpl iconImpl = null;
            iconImpl = new IconImpl(new Dimension(34, 264));
            this.cards[i] = new CardPanel(iconImpl, this);
            this.cards[i].addMouseListener(this.mouseListener);
            this.slotsPanel.add(this.cards[i]);
        }
    }

    protected void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)this.getLayout()).setConstraints(this.labelsPanel, gridBagConstraints);
        this.add(this.labelsPanel);
    }

    protected void removeLabels() {
        this.remove(this.labelsPanel);
    }

    protected void createFanPanel() {
    }

    protected void setFanPanelSize(int n) {
    }

    protected Font getTextFont(int n) {
        return textFont;
    }

    protected void addPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        ((GridBagLayout)this.getLayout()).setConstraints(this.slotsPanel, gridBagConstraints);
        this.add(this.slotsPanel);
    }
}

