/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Node.eSwUpgradeActivity;
import cerent.cms.idl.Node.eSwUpgradeState;
import cerent.cms.idl.Node.sSwUpgradeUpdate;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SwUpgradeModel;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.download.AbstractSoftMaintPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.ui.shelf.BackupRestoreDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SmpSoftwarePane
extends AbstractSoftMaintPane {
    private final String ACCEPT = "Accept...";
    private final String ACCEPT_TIP = "Accept newer software for standby TSC as working";
    private final String ACCEPT_ERROR_MSG = "NE has already accepted the new software";
    private final String FLASH_INFO = "Info...";
    private final String FLASH_INFO_TIP = "Current working and protect software flash info";
    private final int FLM_SW_NOT_ACCEPTED = 10;
    private JButton acceptButton;
    private JButton infoButton;
    private SwUpgradeModel swUpgradeModel = null;
    private static final SDebug db = new SDebug("SmpSoftwarePane");

    public SmpSoftwarePane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.dataSource.addNode((INodeModel)iModel);
    }

    protected JPanel makeButtonPanel() {
        JPanel jPanel = super.makeButtonPanel();
        JPanel jPanel2 = (JPanel)jPanel.getComponent(1);
        this.acceptButton = this.makeActionButton("Accept...");
        this.acceptButton.setToolTipText("Accept newer software for standby TSC as working");
        this.infoButton = this.makeActionButton("Info...");
        this.infoButton.setToolTipText("Current working and protect software flash info");
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.acceptButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.infoButton);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(new CSHelpButton(CSHelpConst.SmpSoftwarePane));
        return jPanel;
    }

    public void enteringPage() {
        super.enteringPage();
        this.swUpgradeModel = ((PlatformNodeModel)this.getUiModel()).getSwUpgradeModel();
        if (this.swUpgradeModel != null) {
            this.swUpgradeModel.init();
            this.swUpgradeModel.addObserver((Observer)((Object)this));
        }
        this.syncButtons();
    }

    public void leavingPage() throws Exception {
        if (this.swUpgradeModel != null) {
            this.swUpgradeModel.deleteObserver((Observer)((Object)this));
            this.swUpgradeModel = null;
        }
        super.leavingPage();
    }

    public void destroy() {
        if (this.swUpgradeModel != null) {
            this.swUpgradeModel.deleteObserver((Observer)((Object)this));
            this.swUpgradeModel = null;
        }
        super.destroy();
    }

    public void refresh() {
        this.syncButtons();
    }

    private void syncButtons() {
        if (this.swUpgradeModel.isOperationAllowed(3)) {
            this.enableComponent(this.downloadButton, this.uiModel, SecurityLevel.MAINTENANCE);
        } else {
            this.downloadButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed("Cancel")) {
            this.enableComponent(this.cancelButton, this.uiModel, SecurityLevel.MAINTENANCE);
        } else {
            this.cancelButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed(4)) {
            this.enableComponent(this.activateButton);
        } else {
            this.activateButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed(5)) {
            this.enableComponent(this.revertButton);
        } else {
            this.revertButton.setEnabled(false);
        }
        if (this.swUpgradeModel.isOperationAllowed("Accept")) {
            this.enableComponent(this.acceptButton);
        } else {
            this.acceptButton.setEnabled(false);
        }
    }

    private void displayFlashInfo() {
        sSwUpgradeUpdate sSwUpgradeUpdate2 = this.swUpgradeModel.getSwUpgradeUpdateInfo();
        String string = "TSC A Working = " + String.valueOf(sSwUpgradeUpdate2.workingSwVerTscA);
        string = string + "\nTSC A Protect = " + String.valueOf(sSwUpgradeUpdate2.protectSwVerTscA);
        string = string + "\nTSC B Working = " + String.valueOf(sSwUpgradeUpdate2.workingSwVerTscB);
        string = string + "\nTSC B Protect = " + String.valueOf(sSwUpgradeUpdate2.protectSwVerTscB);
        CerentDialog.infoDialog((Component)((Object)this), (String)string, (String)"Current Software Info");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.acceptButton) {
            this.acceptSw();
        } else if (object == this.infoButton) {
            this.displayFlashInfo();
        } else if (object == this.cancelButton) {
            sSwUpgradeUpdate sSwUpgradeUpdate2 = this.swUpgradeModel.getSwUpgradeUpdateInfo();
            if (sSwUpgradeUpdate2.swUpgradeState == eSwUpgradeState.SWUP_DOWNLOAD && sSwUpgradeUpdate2.swUpgradeActivity == eSwUpgradeActivity.SWACT_DOWNLOAD) {
                super.actionPerformed(actionEvent);
            } else {
                this.cancelSwUpgrade();
            }
        } else if (object == this.revertButton) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
            int n = this.swUpgradeModel.getSpecialRevertDisallowedReason(this.dataSource.getNodeVerInfo(nodeModelDelegate).getProtectVersion());
            if (n == 1) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SW_DOWNGRADE_WITH_SSXC);
            } else if (n == 2) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_NO_SW_DOWNGRADE);
            } else {
                BackupRestoreDialog backupRestoreDialog = new BackupRestoreDialog(this, nodeModelDelegate, 2);
                backupRestoreDialog.show();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void toggleButtons() {
    }

    public void cancelSwUpgrade() {
        block4: {
            boolean bl;
            sSwUpgradeUpdate sSwUpgradeUpdate2 = this.swUpgradeModel.getSwUpgradeUpdateInfo();
            if (sSwUpgradeUpdate2.swUpgradeState.equals(eSwUpgradeState.SWUP_ACTIVATED) && sSwUpgradeUpdate2.swUpgradeActivity.equals(eSwUpgradeActivity.SWACT_IDLE) && !(bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)"Are you sure?", (String)"Confirm Cancel"))) {
                return;
            }
            if (!(sSwUpgradeUpdate2.swUpgradeState != eSwUpgradeState.SWUP_REVERT && sSwUpgradeUpdate2.swUpgradeState != eSwUpgradeState.SWUP_ACTIVATED || sSwUpgradeUpdate2.swUpgradeActivity != eSwUpgradeActivity.SWACT_ACQUIRE || (bl = CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)(ErrorMsg.getString((EID)EMC.WID_TSC_ACQUIRING_CLOCK_SW_UPGRADE) + "\n\nAre you sure?"), (String)"Confirm Cancel")))) {
                return;
            }
            db.fine("About to invoke cancelSwUpgrade for 15600");
            try {
                this.swUpgradeModel.cancelSwUpgrade();
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SW_UPGRADE_CANCEL);
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void acceptSw() {
        block4: {
            if (db.on()) {
                db.println("About to invoke acceptSwUpgrade for 15600");
            }
            try {
                int n = this.swUpgradeModel.acceptSwUpgrade();
                if (n == 10) {
                    CerentDialog.infoDialog((Component)((Object)this), (String)"NE has already accepted the new software", (String)"Software Accepted");
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_SW_FAIL_ACCEPT_LOAD);
                if (!db.on()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

