/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvDataInterval;
import ilog.views.chart.IlvDefaultScaleConfiguration;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvScale;
import ilog.views.chart.internal.IlvPolarProjector;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.IlvSelectionUtil;
import ilog.views.chart.util.internal.IlvMathUtil;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class IlvCircularScaleConfiguration
extends IlvDefaultScaleConfiguration {
    IlvCircularScaleConfiguration() {
    }

    protected IlvScale.Steps createSteps() {
        return new IlvScale.CircularSteps(this.scale);
    }

    private IlvPolarProjector f() {
        return (IlvPolarProjector)this.scale.o();
    }

    double a(double d2) {
        return this.f().getAngleDeg(d2, this.scale.q(), this.scale.getCoordinateSystem());
    }

    Rectangle2D getAxisBounds(Rectangle2D rectangle2D) {
        if (this.scale.getAxis().getVisibleRange().isEmpty()) {
            return new Rectangle2D.Double();
        }
        return this.scale.b().getShapeBounds(this.g());
    }

    IlvAxis.Crossing a() {
        return IlvAxis.MAX_VALUE;
    }

    protected int getScaleLength() {
        Shape shape = this.g();
        if (shape instanceof Arc2D) {
            Arc2D arc2D = (Arc2D)shape;
            int n2 = arc2D.getBounds().width;
            return (int)Math.abs(IlvMathUtil.toRadians(arc2D.getAngleExtent()) / 2.0 * (double)n2);
        }
        Rectangle rectangle = this.scale.q();
        double d2 = (double)Math.min(rectangle.width, rectangle.height) / 2.0;
        double d3 = IlvMathUtil.toRadians(this.f().getRange());
        return (int)Math.abs(d3 * d2);
    }

    private Shape g() {
        return this.f().getShape(this.scale.getCrossingValue(), 2, this.scale.q(), this.scale.getCoordinateSystem());
    }

    int a(int n2, int n3, int n4) {
        double d2 = this.getScaleLength();
        double d3 = Math.sqrt(n2 * n2 + n3 * n3) + (double)n4;
        return (int)Math.max(Math.round(d2 / d3) + 1L, 2L);
    }

    int t() {
        int n2 = this.scale.getTitleOffset() + this.scale.z();
        if (this.scale.isLabelVisible()) {
            double d2 = this.scale.m().w();
            double d3 = this.scale.m().x();
            n2 += (int)Math.sqrt(d2 * d2 + d3 * d3);
        }
        return n2;
    }

    protected void drawAxis(Graphics graphics) {
        this.scale.b().draw(graphics, this.g());
    }

    public void drawSelection(Graphics graphics) {
        Rectangle2D rectangle2D = this.getAxisBounds(null);
        Shape shape = this.g();
        IlvSelectionUtil.getSelectionStyle().draw(graphics, shape);
        IlvDataInterval ilvDataInterval = this.scale.getAxis().getVisibleRange();
        double d2 = this.scale.getDualAxis().getVisibleMax();
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(5);
        ilvDoublePoints.add(ilvDataInterval.getMin(), d2);
        ilvDoublePoints.add(ilvDataInterval.getMin() + ilvDataInterval.getLength() / 4.0, d2);
        ilvDoublePoints.add(ilvDataInterval.getMiddle(), d2);
        ilvDoublePoints.add(ilvDataInterval.getMiddle() + ilvDataInterval.getLength() / 4.0, d2);
        ilvDoublePoints.add(ilvDataInterval.getMax(), d2);
        this.scale.getChart().toDisplay(ilvDoublePoints);
        IlvSelectionUtil.drawSelectionHandle(graphics, IlvGraphicUtil.toInt(ilvDoublePoints.getX(0)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(0)));
        IlvSelectionUtil.drawSelectionHandle(graphics, IlvGraphicUtil.toInt(ilvDoublePoints.getX(1)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(1)));
        IlvSelectionUtil.drawSelectionHandle(graphics, IlvGraphicUtil.toInt(ilvDoublePoints.getX(2)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(2)));
        IlvSelectionUtil.drawSelectionHandle(graphics, IlvGraphicUtil.toInt(ilvDoublePoints.getX(3)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(3)));
        IlvSelectionUtil.drawSelectionHandle(graphics, IlvGraphicUtil.toInt(ilvDoublePoints.getX(4)), IlvGraphicUtil.toInt(ilvDoublePoints.getY(4)));
        ilvDoublePoints.dispose();
    }

    public boolean contains(Point2D point2D) {
        BasicStroke basicStroke = new BasicStroke(this.t() / 2, 0, 0);
        Shape shape = basicStroke.createStrokedShape(this.g());
        return shape.contains(point2D);
    }
}

