/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.data;

import ilog.views.chart.data.IlvAbstractDataSet;
import ilog.views.chart.data.IlvDataPoints;
import ilog.views.chart.data.IlvDataSetProperty;
import ilog.views.chart.event.DataSetContentsEvent;
import ilog.views.chart.util.IlvDoubleArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class IlvDefaultDataSet
extends IlvAbstractDataSet {
    private static final int a = 32;
    private static final Double b = new Double(1.0);
    private static final String[] c = new String[0];
    private boolean d = true;
    protected IlvDoubleArray xValues;
    protected IlvDoubleArray yValues;
    protected ArrayList labels;
    IlvDefaultDataSet[] e;

    public IlvDefaultDataSet(String string) {
        this(string, true);
    }

    public IlvDefaultDataSet(String string, boolean bl) {
        this(string, 32, bl);
    }

    public IlvDefaultDataSet(String string, int n2, boolean bl) {
        this(string, bl ? new IlvDoubleArray(n2) : null, new IlvDoubleArray(n2));
    }

    public IlvDefaultDataSet(String string, double[] dArray) {
        this(string, null, dArray, true);
    }

    public IlvDefaultDataSet(String string, double[] dArray, double[] dArray2, boolean bl) {
        this(string, dArray == null ? null : new IlvDoubleArray(bl ? (double[])dArray.clone() : dArray), new IlvDoubleArray(bl ? (double[])dArray2.clone() : dArray2));
    }

    IlvDefaultDataSet(String string, IlvDoubleArray ilvDoubleArray, IlvDoubleArray ilvDoubleArray2) {
        this.setName(string);
        this.xValues = ilvDoubleArray;
        if (this.xValues == null) {
            IlvDataSetProperty.setCategory(this, b);
        }
        this.yValues = ilvDoubleArray2;
        if (this.getDataCount() > 0) {
            this.c();
        }
    }

    public final boolean isUsingXValues() {
        return this.xValues != null;
    }

    public void useXValues(boolean bl) {
        if (bl) {
            if (this.xValues == null) {
                int n2 = this.getDataCount();
                double[] dArray = new double[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = i2;
                }
                this.xValues = new IlvDoubleArray(dArray);
                IlvDataSetProperty.setCategory(this, null);
            }
        } else {
            this.xValues = null;
            IlvDataSetProperty.setCategory(this, b);
        }
    }

    public void setData(double[] dArray, double[] dArray2, int n2) {
        if (dArray != null && dArray.length < n2) {
            throw new IllegalArgumentException("xValues array too short");
        }
        if (!(dArray2 != null ? dArray2.length >= n2 : n2 == 0)) {
            throw new IllegalArgumentException("yValues array too short");
        }
        if (dArray == null) {
            this.xValues = null;
            IlvDataSetProperty.setCategory(this, b);
        } else {
            if (this.xValues == null) {
                this.xValues = new IlvDoubleArray();
            } else {
                this.xValues.reset();
            }
            this.xValues.add(dArray, n2);
            IlvDataSetProperty.setCategory(this, null);
        }
        if (this.yValues == null) {
            this.yValues = new IlvDoubleArray();
        } else {
            this.yValues.reset();
        }
        if (dArray2 != null) {
            this.yValues.add(dArray2, n2);
        }
        this.e = null;
        this.c();
        this.invalidateLimits();
        this.fireDataSetContentsEvent(new DataSetContentsEvent(this));
    }

    public int getDataCount() {
        return this.yValues.size();
    }

    public double getXData(int n2) {
        return this.xValues == null ? (double)n2 : this.xValues.get(n2);
    }

    public double getYData(int n2) {
        return this.yValues.get(n2);
    }

    public boolean isEditable() {
        return true;
    }

    public void setData(int n2, double d2, double d3) {
        int n3;
        boolean bl;
        boolean bl2 = bl = this.getXData(n2) != d2;
        if (!bl && this.getYData(n2) == d3) {
            return;
        }
        if (bl && this.e != null) {
            n3 = this.e.length;
            while (--n3 >= 0) {
                this.e[n3].dataChanged(n2, n2, 1);
            }
        } else {
            this.dataChanged(n2, n2, 1);
        }
        this.a(n2, d2, d3);
        if (bl && this.e != null) {
            n3 = this.e.length;
            while (--n3 >= 0) {
                this.e[n3].dataChanged(n2, n2, 2);
            }
        } else {
            this.dataChanged(n2, n2, 2);
        }
    }

    final void a(int n2, double d2, double d3) {
        if (this.xValues != null) {
            this.xValues.set(n2, d2);
        }
        this.yValues.set(n2, d3);
    }

    public void addData(double d2, double d3) {
        this.addData(d2, d3, null);
    }

    public void addData(double d2, double d3, String string) {
        if (this.e != null) {
            throw new UnsupportedOperationException("Cannot append data to a data set sharing its X series");
        }
        if (string != null) {
            int n2;
            if (this.labels == null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(n2 < 10 ? 10 : n2 + 1);
                for (n2 = this.getDataCount(); n2 > 0; --n2) {
                    arrayList.add(null);
                }
                this.labels = arrayList;
            } else {
                ArrayList arrayList = this.labels;
                n2 -= arrayList.size();
                while (n2 > 0) {
                    arrayList.add(null);
                    --n2;
                }
            }
        }
        if (this.xValues != null) {
            this.xValues.add(d2);
        }
        this.yValues.add(d3);
        if (string != null) {
            this.labels.add(string);
        }
        this.dataAdded(this.getDataCount() - 1);
    }

    public String getDataLabel(int n2) {
        String string = null;
        if (this.labels != null && n2 < this.labels.size()) {
            string = (String)this.labels.get(n2);
        }
        return string;
    }

    void a(IlvDataPoints ilvDataPoints, int n2, int n3) {
        double[] dArray = ilvDataPoints.getXValues();
        double[] dArray2 = ilvDataPoints.getYValues();
        int n4 = n3 - n2 + 1;
        if (this.xValues == null) {
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray[i2] = n2 + i2;
            }
        } else {
            System.arraycopy(this.xValues.data(), n2, dArray, 0, n4);
        }
        System.arraycopy(this.yValues.data(), n2, dArray2, 0, n4);
        ilvDataPoints.setSize(n4);
    }

    int a(int n2, int n3, double d2) {
        if (this.xValues == null) {
            if (d2 < (double)n2) {
                return -n2 - 1;
            }
            if (d2 > (double)n3) {
                return -n3 - 2;
            }
            int n4 = (int)Math.ceil(d2);
            if ((double)n4 == d2) {
                return n4;
            }
            return -n4 - 1;
        }
        return super.a(n2, n3, d2);
    }

    int b(int n2, int n3, double d2) {
        return super.a(n2, n3, d2);
    }

    public boolean isXValuesSorted() {
        return this.d;
    }

    private void c() {
        int n2;
        this.d = true;
        if (this.xValues != null && (n2 = this.getDataCount()) > 1) {
            double d2 = this.getXData(0);
            for (int i2 = 1; i2 < n2; ++i2) {
                double d3 = this.getXData(i2);
                if (d3 < d2) {
                    this.d = false;
                    return;
                }
                d2 = d3;
            }
        }
    }

    private void a(int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.getDataCount();
        if (n6 <= 1) {
            this.d = true;
        }
        if ((n5 = Math.max(n2 - 1, 0)) < (n4 = Math.min(n3 + 1, this.getDataCount() - 1))) {
            double d2 = this.getXData(n5);
            for (int i2 = n5 + 1; i2 <= n4; ++i2) {
                double d3 = this.getXData(i2);
                if (d3 < d2) {
                    this.d = false;
                    return;
                }
                d2 = d3;
            }
        }
    }

    protected void dataChanged(int n2, int n3, int n4) {
        if (n4 != 1 && this.d && this.xValues != null) {
            this.a(n2, n3);
        }
        super.dataChanged(n2, n3, n4);
    }

    protected void dataAdded(int n2) {
        if (this.d && this.xValues != null) {
            this.a(n2, n2);
        }
        super.dataAdded(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXData(int n2, double d2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative data index: " + n2);
        }
        if (this.xValues != null) {
            if (n2 < this.getDataCount()) {
                this.setData(n2, d2, this.getYData(n2));
            } else {
                this.startBatch();
                try {
                    int n3 = this.getDataCount();
                    do {
                        this.addData(d2, Double.NaN, this.getDataLabel(n3));
                    } while (++n3 <= n2);
                }
                finally {
                    this.endBatch();
                }
            }
        }
    }

    public double[] getXValues() {
        int n2 = this.getDataCount();
        double[] dArray = new double[n2];
        if (this.getClass() == IlvDefaultDataSet.class) {
            if (this.xValues == null) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    dArray[i2] = i2;
                }
            } else {
                System.arraycopy(this.xValues.data(), 0, dArray, 0, n2);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray[i3] = this.getXData(i3);
            }
        }
        return dArray;
    }

    public void setXValues(double[] dArray) {
        if (this.xValues != null) {
            int n2;
            int n3 = dArray.length;
            double[] dArray2 = new double[n3];
            int n4 = Math.min(this.getDataCount(), n3);
            if (this.getClass() == IlvDefaultDataSet.class) {
                System.arraycopy(this.yValues.data(), 0, dArray2, 0, n4);
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    dArray2[n2] = this.getYData(n2);
                }
            }
            for (n2 = n4; n2 < n3; ++n2) {
                dArray2[n2] = Double.NaN;
            }
            this.setData(dArray, dArray2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYData(int n2, double d2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative data index: " + n2);
        }
        if (n2 < this.getDataCount()) {
            this.setData(n2, this.getXData(n2), d2);
        } else {
            this.startBatch();
            try {
                int n3 = this.getDataCount();
                double d3 = n3 > 0 ? this.getXData(n3 - 1) : 0.0;
                do {
                    this.addData(d3, Double.NaN, this.getDataLabel(n3));
                } while (++n3 <= n2 - 1);
                this.addData(d3, d2, this.getDataLabel(n3));
            }
            finally {
                this.endBatch();
            }
        }
    }

    public double[] getYValues() {
        int n2 = this.getDataCount();
        double[] dArray = new double[n2];
        if (this.getClass() == IlvDefaultDataSet.class) {
            System.arraycopy(this.yValues.data(), 0, dArray, 0, n2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                dArray[i2] = this.getYData(i2);
            }
        }
        return dArray;
    }

    public void setYValues(double[] dArray) {
        if (this.xValues != null) {
            int n2;
            int n3 = this.xValues.size();
            double[] dArray2 = new double[n3];
            int n4 = Math.min(this.getDataCount(), n3);
            double d2 = n4 > 0 ? this.getXData(n4 - 1) : 0.0;
            if (this.getClass() == IlvDefaultDataSet.class) {
                if (this.xValues == null) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        dArray2[n2] = n2;
                    }
                } else {
                    System.arraycopy(this.xValues.data(), 0, dArray2, 0, n4);
                }
            } else {
                for (n2 = 0; n2 < n4; ++n2) {
                    dArray2[n2] = this.getXData(n2);
                }
            }
            for (n2 = n4; n2 < n3; ++n2) {
                dArray2[n2] = d2;
            }
            this.setData(dArray2, dArray, n3);
        } else {
            int n5 = dArray.length;
            this.setData(null, dArray, n5);
        }
    }

    public void setDataLabel(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative data index: " + n2);
        }
        if (string == null) {
            if (this.labels != null && n2 < this.labels.size()) {
                this.labels.set(n2, null);
                this.fireDataSetContentsEvent(new DataSetContentsEvent(this, 5, n2, n2));
            }
        } else {
            if (this.labels == null) {
                this.labels = new ArrayList(n2 < 10 ? 10 : n2 + 1);
            }
            if (n2 < this.labels.size()) {
                this.labels.set(n2, string);
            } else {
                for (int i2 = n2 - this.labels.size(); i2 > 0; --i2) {
                    this.labels.add(null);
                }
                this.labels.add(string);
            }
            this.fireDataSetContentsEvent(new DataSetContentsEvent(this, 5, n2, n2));
        }
    }

    public String[] getDataLabels() {
        if (this.labels != null) {
            return this.labels.toArray(new String[this.labels.size()]);
        }
        return c;
    }

    public void setDataLabels(String[] stringArray) {
        this.labels = stringArray == null ? null : new ArrayList<String>(Arrays.asList(stringArray));
        if (this.getDataCount() > 0) {
            this.fireDataSetContentsEvent(new DataSetContentsEvent(this, 5, 0, this.getDataCount() - 1));
        }
    }

    void a(IlvDefaultDataSet[] ilvDefaultDataSetArray) {
        this.e = ilvDefaultDataSetArray;
    }

    public static IlvDefaultDataSet[] create(double[][] dArray, int n2, String[] stringArray, String[] stringArray2) {
        Object object;
        int n3;
        IlvDefaultDataSet[] ilvDefaultDataSetArray = null;
        if (n2 == -1) {
            ilvDefaultDataSetArray = new IlvDefaultDataSet[dArray.length];
            for (n3 = 0; n3 < dArray.length; ++n3) {
                object = stringArray == null ? "" : stringArray[n3];
                ilvDefaultDataSetArray[n3] = new IlvDefaultDataSet((String)object, dArray[n3]);
            }
        } else {
            ilvDefaultDataSetArray = new IlvDefaultDataSet[dArray.length - 1];
            SerObject serObject = new SerObject();
            object = new IlvDoubleArray((double[])dArray[n2].clone());
            int n4 = 0;
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (i2 == n2) continue;
                IlvDoubleArray ilvDoubleArray = new IlvDoubleArray((double[])dArray[i2].clone());
                String string = stringArray == null ? "" : stringArray[n4];
                ilvDefaultDataSetArray[n4] = new IlvDefaultDataSet(string, (IlvDoubleArray)object, ilvDoubleArray);
                ilvDefaultDataSetArray[n4].putProperty("_Ilv_SHAREDX_PROP", serObject, false);
                ++n4;
            }
        }
        if (stringArray2 != null) {
            String[] stringArray3 = new String[stringArray2.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            stringArray2 = stringArray3;
        }
        for (n3 = 0; n3 < ilvDefaultDataSetArray.length; ++n3) {
            ilvDefaultDataSetArray[n3].setDataLabels(stringArray2);
            ilvDefaultDataSetArray[n3].a(ilvDefaultDataSetArray);
        }
        return ilvDefaultDataSetArray;
    }

    private static final class SerObject
    implements Serializable {
        private SerObject() {
        }
    }
}

