/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.datax.adapter.internal;

import ilog.views.chart.datax.adapter.partition.IlvClassifier;
import ilog.views.chart.datax.adapter.partition.IlvClusterId;
import ilog.views.chart.datax.adapter.partition.IlvPartitioner;
import ilog.views.chart.datax.adapter.partition.event.PartitionerListener;
import ilog.views.chart.datax.tree.internal.IlvTreeNodeLinks;
import javax.swing.tree.TreePath;

public class IlvPartitioningUtil {
    private static final boolean a = true;

    public static PartitioningAlgorithm createPartitioningAlgorithm(IlvPartitioner[] ilvPartitionerArray) {
        if (ilvPartitionerArray.length == 0) {
            return new NoopPartitioning();
        }
        if (ilvPartitionerArray.length == 1) {
            return new SimplePartitioning(ilvPartitionerArray[0]);
        }
        return new MultiplePartitioning(ilvPartitionerArray);
    }

    public static PartitioningAlgorithm createPartitioningAlgorithm(IlvPartitioner ilvPartitioner) {
        return new SimplePartitioning(ilvPartitioner);
    }

    public static final class ClassifyResult {
        public int _distLevel;
        public IlvPartitioner _distPartitioner;
        public IlvClassifier _classifier;
        public IlvClusterId _id;
        public TreePath _history;
    }

    static class MultiplePartitioning
    extends PartitioningAlgorithm {
        private IlvPartitioner[] a;
        private static IlvClassifier[] b = new IlvClassifier[0];
        private static TreePath[] c = new TreePath[0];

        MultiplePartitioning(IlvPartitioner[] ilvPartitionerArray) {
            this.a = ilvPartitionerArray;
        }

        public IlvTreeNodeLinks createTreeNodeData() {
            return new TreeNodeData();
        }

        public void fillRootNodeData(IlvTreeNodeLinks ilvTreeNodeLinks) {
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            treeNodeData.a = 0;
            treeNodeData.b = -1;
            treeNodeData.c = null;
            treeNodeData.d = b;
            treeNodeData.e = c;
            treeNodeData.f = null;
        }

        public void fillSubclusterNodeData(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, TreePath treePath, int n2, IlvPartitioner ilvPartitioner, IlvClassifier ilvClassifier, IlvClusterId ilvClusterId) {
            int n3;
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            treeNodeData.a = n3 = n2;
            treeNodeData.b = n3 - 1;
            treeNodeData.c = treePath;
            treeNodeData.d = b;
            treeNodeData.e = c;
            treeNodeData.f = object;
        }

        public void doClassify(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, ClassifyResult classifyResult) {
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            TreePath treePath = treeNodeData.c;
            for (int i2 = treeNodeData.a; i2 != this.a.length; ++i2) {
                IlvClassifier ilvClassifier;
                Object[] objectArray;
                Object object2;
                IlvPartitioner ilvPartitioner = this.a[i2];
                if (i2 > treeNodeData.b) {
                    assert (treeNodeData.b == i2 - 1);
                    IlvClassifier ilvClassifier2 = null;
                    object2 = null;
                    for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
                        objectArray = (IlvClassifier[])treePath2.getLastPathComponent();
                        if (objectArray.a != ilvPartitioner) continue;
                        ilvClassifier2 = objectArray.b;
                        object2 = objectArray.c;
                        break;
                    }
                    ilvClassifier = ilvPartitioner.createClassifier(treeNodeData.f, ilvClassifier2, (IlvClusterId)object2);
                    int n2 = i2 - treeNodeData.a;
                    if (n2 >= treeNodeData.d.length) {
                        objectArray = new IlvClassifier[n2 + 1];
                        System.arraycopy(treeNodeData.d, 0, objectArray, 0, treeNodeData.d.length);
                        treeNodeData.d = objectArray;
                    }
                    treeNodeData.d[n2] = ilvClassifier;
                    treeNodeData.b = i2;
                } else {
                    int n3 = i2 - treeNodeData.a;
                    IlvClassifier ilvClassifier3 = ilvClassifier = n3 < treeNodeData.d.length ? treeNodeData.d[n3] : null;
                }
                if (ilvClassifier == null) continue;
                IlvClusterId ilvClusterId = ilvClassifier.classify(object);
                if (ilvClusterId != null) {
                    object2 = new ClassifierInfo(ilvPartitioner, ilvClassifier, ilvClusterId);
                    treePath = treePath != null ? treePath.pathByAddingChild(object2) : new TreePath(object2);
                    classifyResult._distLevel = i2;
                    classifyResult._distPartitioner = ilvPartitioner;
                    classifyResult._classifier = ilvClassifier;
                    classifyResult._id = ilvClusterId;
                    classifyResult._history = treePath;
                    return;
                }
                int n4 = i2 - treeNodeData.a;
                if (n4 >= treeNodeData.e.length || treeNodeData.e[n4] == null) {
                    ClassifierInfo classifierInfo = new ClassifierInfo(ilvPartitioner, ilvClassifier, null);
                    TreePath treePath3 = treePath = treePath != null ? treePath.pathByAddingChild(classifierInfo) : new TreePath(classifierInfo);
                    if (n4 >= treeNodeData.e.length) {
                        objectArray = new TreePath[n4 + 1];
                        System.arraycopy(treeNodeData.e, 0, objectArray, 0, treeNodeData.e.length);
                        treeNodeData.e = objectArray;
                    }
                    treeNodeData.e[n4] = treePath;
                    continue;
                }
                treePath = n4 < treeNodeData.e.length ? treeNodeData.e[n4] : null;
            }
            classifyResult._id = null;
            classifyResult._history = treePath;
        }

        public void addPartitionerListener(PartitionerListener partitionerListener) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2].addPartitionerListener(partitionerListener);
            }
        }

        public void removePartitionerListener(PartitionerListener partitionerListener) {
            for (int i2 = this.a.length - 1; i2 >= 0; --i2) {
                this.a[i2].removePartitionerListener(partitionerListener);
            }
        }

        private static class ClassifierInfo {
            final IlvPartitioner a;
            final IlvClassifier b;
            IlvClusterId c;

            ClassifierInfo(IlvPartitioner ilvPartitioner, IlvClassifier ilvClassifier, IlvClusterId ilvClusterId) {
                this.a = ilvPartitioner;
                this.b = ilvClassifier;
                this.c = ilvClusterId;
            }
        }

        private static class TreeNodeData
        extends IlvTreeNodeLinks {
            int a;
            int b;
            TreePath c;
            IlvClassifier[] d;
            TreePath[] e;
            Object f;

            TreeNodeData() {
            }
        }
    }

    static class NoopPartitioning
    extends PartitioningAlgorithm {
        NoopPartitioning() {
        }

        public IlvTreeNodeLinks createTreeNodeData() {
            return new IlvTreeNodeLinks();
        }

        public void fillRootNodeData(IlvTreeNodeLinks ilvTreeNodeLinks) {
        }

        public void fillSubclusterNodeData(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, TreePath treePath, int n2, IlvPartitioner ilvPartitioner, IlvClassifier ilvClassifier, IlvClusterId ilvClusterId) {
        }

        public void doClassify(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, ClassifyResult classifyResult) {
            classifyResult._id = null;
            classifyResult._history = null;
        }

        public void addPartitionerListener(PartitionerListener partitionerListener) {
        }

        public void removePartitionerListener(PartitionerListener partitionerListener) {
        }
    }

    public static abstract class PartitioningAlgorithm {
        public abstract IlvTreeNodeLinks createTreeNodeData();

        public abstract void fillRootNodeData(IlvTreeNodeLinks var1);

        public abstract void fillSubclusterNodeData(IlvTreeNodeLinks var1, Object var2, TreePath var3, int var4, IlvPartitioner var5, IlvClassifier var6, IlvClusterId var7);

        public abstract void doClassify(IlvTreeNodeLinks var1, Object var2, ClassifyResult var3);

        public void fillUngroupedNodeData(IlvTreeNodeLinks ilvTreeNodeLinks) {
        }

        public abstract void addPartitionerListener(PartitionerListener var1);

        public abstract void removePartitionerListener(PartitionerListener var1);
    }

    static class SimplePartitioning
    extends PartitioningAlgorithm {
        private IlvPartitioner a;

        SimplePartitioning(IlvPartitioner ilvPartitioner) {
            this.a = ilvPartitioner;
        }

        public IlvTreeNodeLinks createTreeNodeData() {
            return new TreeNodeData();
        }

        public void fillRootNodeData(IlvTreeNodeLinks ilvTreeNodeLinks) {
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            treeNodeData.a = this.a.createClassifier(null, null, null);
        }

        public void fillSubclusterNodeData(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, TreePath treePath, int n2, IlvPartitioner ilvPartitioner, IlvClassifier ilvClassifier, IlvClusterId ilvClusterId) {
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            treeNodeData.a = this.a.createClassifier(object, ilvClassifier, ilvClusterId);
        }

        public void doClassify(IlvTreeNodeLinks ilvTreeNodeLinks, Object object, ClassifyResult classifyResult) {
            TreeNodeData treeNodeData = (TreeNodeData)ilvTreeNodeLinks;
            IlvClassifier ilvClassifier = treeNodeData.a;
            classifyResult._distLevel = 0;
            classifyResult._distPartitioner = this.a;
            classifyResult._classifier = ilvClassifier;
            classifyResult._id = ilvClassifier != null ? ilvClassifier.classify(object) : null;
            classifyResult._history = null;
        }

        public void addPartitionerListener(PartitionerListener partitionerListener) {
            this.a.addPartitionerListener(partitionerListener);
        }

        public void removePartitionerListener(PartitionerListener partitionerListener) {
            this.a.removePartitionerListener(partitionerListener);
        }

        private static class TreeNodeData
        extends IlvTreeNodeLinks {
            IlvClassifier a;

            TreeNodeData() {
            }
        }
    }
}

