/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.util.internal;

public final class IlvMathUtil {
    public static final double EPSILON = 1.0E-10;
    static final int a = 361;
    static final double b = 57.29577951308232;
    static final double c = Math.PI / 180;

    private IlvMathUtil() {
    }

    public static final double toDegrees(double d2) {
        return d2 * 57.29577951308232;
    }

    public static final double toRadians(double d2) {
        return d2 * (Math.PI / 180);
    }

    public static final boolean isNear0(double d2) {
        return d2 < 1.0E-10 && d2 > -1.0E-10;
    }

    public static final double clamp(double d2, double d3, double d4) {
        if (d2 > d4) {
            return d4;
        }
        if (d2 < d3) {
            return d3;
        }
        return d2;
    }

    public static final int clamp(int n2, int n3, int n4) {
        if (n2 > n4) {
            return n4;
        }
        if (n2 < n3) {
            return n3;
        }
        return n2;
    }

    public static final boolean equals(double d2, double d3, double d4) {
        return Math.abs(d3 - d2) < Math.max(Math.abs(d2), Math.abs(d3)) * d4;
    }

    static final double a(double d2, double d3) {
        return d2 < 0.0 ? Math.floor(d2 - d3) : Math.floor(d2 + d3);
    }

    public static final double cosDeg(double d2) {
        if (d2 == 0.0 || d2 == 360.0) {
            return 1.0;
        }
        if (d2 == 90.0 || d2 == 270.0) {
            return 0.0;
        }
        if (d2 == 180.0) {
            return -1.0;
        }
        return Math.cos(IlvMathUtil.toRadians(d2));
    }

    public static final double sinDeg(double d2) {
        if (d2 == 0.0 || d2 == 360.0) {
            return 0.0;
        }
        if (d2 == 90.0) {
            return 1.0;
        }
        if (d2 == 270.0) {
            return -1.0;
        }
        return Math.sin(IlvMathUtil.toRadians(d2));
    }

    public static final double mod360(double d2) {
        if (d2 >= 360.0) {
            while ((d2 -= 360.0) >= 360.0) {
            }
        } else {
            while (d2 < 0.0) {
                d2 += 360.0;
            }
        }
        return d2;
    }
}

