/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DView;
import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSetPoint;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.servlet.IlvIMapArea;
import ilog.views.chart.servlet.IlvIMapAttributes;
import ilog.views.chart.servlet.IlvIMapDefinition;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.util.internal.IlvArrayPool;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvChart3DObject
extends IlvPolyhedron {
    protected int dataIdx;
    protected IlvSingleChartRenderer renderer;

    public IlvChart3DObject(IlvChart3DScene ilvChart3DScene, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        super(ilvChart3DScene);
        this.renderer = ilvSingleChartRenderer;
        this.dataIdx = n2;
    }

    public final IlvChart3DView get3DView() {
        return ((IlvChart3DScene)this.getScene()).get3DView();
    }

    @Override
    public IlvStyle getStyle() {
        IlvStyle ilvStyle = this.getRenderer().getDisplayStyle(this.dataIdx);
        if (ilvStyle == null) {
            ilvStyle = IlvPolyhedron.a;
        }
        return ilvStyle;
    }

    public final int getDataIndex() {
        return this.dataIdx;
    }

    public final IlvSingleChartRenderer getRenderer() {
        return this.renderer;
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        return new Point(IlvGraphicUtil.toInt(ilvDisplayPoint.getXCoord()), IlvGraphicUtil.toInt(ilvDisplayPoint.getYCoord()));
    }

    public IlvDisplayPoint getDisplayPoint() {
        IlvDataSet ilvDataSet = this.renderer.getDataSource().getDataSet(0);
        return this.renderer.getDisplayPoint(ilvDataSet, this.dataIdx);
    }

    public IlvDataSetPoint getDataSetPoint() {
        IlvDataSet ilvDataSet = this.renderer.getDataSource().getDataSet(0);
        return new IlvDataSetPoint(ilvDataSet, this.dataIdx);
    }

    public final Rectangle2D getBounds2D(Rectangle2D rectangle2D) {
        IlvStyle ilvStyle = this.getStyle();
        Rectangle2D rectangle2D2 = this.getBounds(true, null).getXYBounds(rectangle2D);
        if (ilvStyle != null) {
            ilvStyle.expand(rectangle2D2);
        }
        return rectangle2D2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IlvIMapArea> getIMapAreas(IlvIMapDefinition ilvIMapDefinition, IlvIMapAttributes ilvIMapAttributes) {
        IlvChart.Area area = this.renderer.getChart().getChartArea();
        boolean bl = false;
        Rectangle rectangle = null;
        if (ilvIMapDefinition.isChartOrigin()) {
            rectangle = this.renderer.getChart().isPaintingImage() && this.renderer.getChart().getPaintContext().getBounds() != null ? (Rectangle)this.renderer.getChart().getPaintContext().getBounds().get(area) : area.getBounds();
            bl = rectangle.x != 0 || rectangle.y != 0;
        }
        ArrayList<IlvIMapArea> arrayList = new ArrayList<IlvIMapArea>(this.getFaceCount());
        Object object = IlvArrayPool.getDoubleCoordsLock();
        synchronized (object) {
            int n2 = this.getFaceCount();
            while (--n2 >= 0) {
                IlvPolyhedron.Face face = this.getFace(n2);
                if (!this.isFaceVisible(face)) continue;
                double[][] dArray = face.a();
                int n3 = face.getIndices().length + 1;
                if (bl) {
                    int n4 = n3;
                    while (--n4 >= 0) {
                        double[] dArray2 = dArray[0];
                        int n5 = n4;
                        dArray2[n5] = dArray2[n5] + (double)rectangle.x;
                        double[] dArray3 = dArray[1];
                        int n6 = n4;
                        dArray3[n6] = dArray3[n6] + (double)rectangle.y;
                    }
                }
                arrayList.add(new IlvIMapArea(dArray[0], dArray[1], n3, ilvIMapAttributes));
            }
        }
        return arrayList;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[dataset=" + this.renderer.getDataSource().getDataSet(0).getName() + ",index=" + this.dataIdx + "]" + this.b();
    }
}

