/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.io.IOException;

public class IlvPolylineLinkImage
extends IlvLinkImage {
    private IlvPoint[] a = null;

    public IlvPolylineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl);
        this.a(ilvPointArray);
    }

    public IlvPolylineLinkImage(IlvPolylineLinkImage ilvPolylineLinkImage) {
        super(ilvPolylineLinkImage);
        this.a(ilvPolylineLinkImage.a);
    }

    public IlvPolylineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        IlvPoint[] ilvPointArray = ilvInputStream.readPointArray("points");
        this.a(ilvPointArray);
    }

    private void a(IlvPoint[] ilvPointArray) {
        if (ilvPointArray == null) {
            return;
        }
        int n2 = ilvPointArray.length;
        if (n2 < 1) {
            return;
        }
        this.a = new IlvPoint[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a[i2] = new IlvPoint(ilvPointArray[i2].x, ilvPointArray[i2].y);
        }
    }

    public IlvGraphic copy() {
        return new IlvPolylineLinkImage(this);
    }

    public int getPointsCardinal() {
        return this.a == null ? 2 : this.a.length + 2;
    }

    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        int n2 = this.getPointsCardinal();
        IlvPoint[] ilvPointArray = new IlvPoint[n2];
        if (n2 > 2) {
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                for (int i2 = 1; i2 < n2 - 1; ++i2) {
                    ilvPointArray[i2] = new IlvPoint(this.a[i2 - 1]);
                }
            } else {
                for (int i3 = 1; i3 < n2 - 1; ++i3) {
                    ilvPointArray[i3] = new IlvPoint(this.a[i3 - 1]);
                    ilvTransformer.apply(ilvPointArray[i3]);
                }
            }
        }
        ilvPointArray[0] = new IlvPoint();
        ilvPointArray[n2 - 1] = new IlvPoint();
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[n2 - 1], ilvTransformer);
        return ilvPointArray;
    }

    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n2, int n3) {
        if (ilvPointArray != null && n2 + n3 > ilvPointArray.length || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Invalid Argument");
        }
        if (n3 == 0 || ilvPointArray == null) {
            this.a = null;
        } else {
            int n4 = this.getPointsCardinal() - 2;
            int n5 = Math.min(n3, n4);
            if (n4 != n3) {
                IlvPoint[] ilvPointArray2 = this.a;
                this.a = new IlvPoint[n3];
                if (ilvPointArray2 != null) {
                    System.arraycopy(ilvPointArray2, 0, this.a, 0, n5);
                }
            }
            int n6 = 0;
            for (n6 = 0; n6 < n5; ++n6) {
                this.a[n6].move(ilvPointArray[n2 + n6].x, ilvPointArray[n2 + n6].y);
            }
            while (n6 < n3) {
                this.a[n6] = new IlvPoint(ilvPointArray[n2 + n6]);
                ++n6;
            }
        }
    }

    public IlvPoint getPointAt(int n2, IlvTransformer ilvTransformer) {
        int n3 = this.getPointsCardinal() - 1;
        if (n2 == 0 || n2 == n3) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
            this.getConnectionPoints(ilvPointArray[0], ilvPointArray[1], ilvTransformer);
            return n2 == 0 ? ilvPointArray[0] : ilvPointArray[1];
        }
        if (n2 > 0 && n2 < n3) {
            IlvPoint ilvPoint = new IlvPoint(this.a[n2 - 1]);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvPoint);
            }
            return ilvPoint;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid index: " + n2 + " (" + this + " has " + this.getPointsCardinal() + " points)");
    }

    public boolean allowsPointInsertion() {
        return true;
    }

    public boolean allowsPointRemoval() {
        return this.a != null && this.a.length >= 1;
    }

    public void insertPoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative index: " + n2);
        }
        if (n2 > this.getPointsCardinal()) {
            throw new IllegalArgumentException("bad index:" + n2 + " (> number of points = " + this.getPointsCardinal() + ")");
        }
        IlvPoint[] ilvPointArray = this.a;
        int n3 = this.a == null ? 0 : ilvPointArray.length;
        int n4 = this.getPointsCardinal();
        if (n2 == 0) {
            IlvPoint ilvPoint = this.getPointAt(0, null);
            this.a = new IlvPoint[n3 + 1];
            this.a[0] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 1, n3);
            }
            this.movePoint(0, f2, f3, ilvTransformer);
        } else if (n2 == n4) {
            IlvPoint ilvPoint = this.getPointAt(n4 - 1, null);
            this.a = new IlvPoint[n3 + 1];
            this.a[n3] = ilvPoint;
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n3);
            }
            this.movePoint(n4, f2, f3, ilvTransformer);
        } else {
            this.a = new IlvPoint[n3 + 1];
            --n2;
            if (ilvPointArray != null) {
                if (n2 > 0) {
                    System.arraycopy(ilvPointArray, 0, this.a, 0, n2);
                }
                System.arraycopy(ilvPointArray, n2, this.a, n2 + 1, n3 - n2);
            }
            this.a[n2] = new IlvPoint(f2, f3);
        }
    }

    public void removePoint(int n2, IlvTransformer ilvTransformer) {
        if (n2 == 0) {
            return;
        }
        if (n2 == this.getPointsCardinal() - 1) {
            return;
        }
        if (this.a != null && --n2 >= 0 && n2 < this.a.length) {
            int n3;
            IlvPoint[] ilvPointArray = this.a;
            this.a = new IlvPoint[ilvPointArray.length - 1];
            if (n2 > 0) {
                System.arraycopy(ilvPointArray, 0, this.a, 0, n2);
            }
            if ((n3 = ilvPointArray.length - n2 - 1) > 0) {
                System.arraycopy(ilvPointArray, n2 + 1, this.a, n2, n3);
            }
        } else {
            throw new IllegalArgumentException("bad index: " + n2);
        }
    }

    public void movePoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
        if (n2 == 0 || n2 == this.getPointsCardinal() - 1) {
            super.movePoint(n2, f2, f3, ilvTransformer);
        } else {
            if (this.a == null) {
                throw new IllegalArgumentException("bad index: " + n2);
            }
            try {
                this.a[n2 - 1].move(f2, f3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("bad index: " + n2);
            }
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && this.a != null && this.getPointsCardinal() > 2) {
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvTransformer.apply(this.a[i2]);
            }
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("points", this.a);
    }
}

