/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvSpline;
import java.awt.Graphics;

public class IlvSplineSelection
extends IlvPolyPointsSelection {
    private static boolean a = true;
    private static boolean b = false;
    private static String c;
    private IlvPoint[] d;

    public IlvSplineSelection(IlvSpline ilvSpline) {
        super(ilvSpline);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        if (!b) {
            return ilvRect;
        }
        if (!a) {
            return ilvRect;
        }
        int n2 = this.getHandleCardinal();
        if (n2 == 0) {
            return ilvRect;
        }
        IlvSpline ilvSpline = this.getSpline();
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f, 2.0f);
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = ilvSpline.getPointAt(i2, ilvTransformer);
            ilvRect2.x = ilvPoint.x - 1.0f;
            ilvRect2.y = ilvPoint.y - 1.0f;
            ilvRect.add(ilvRect2);
        }
        return ilvRect;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        super.draw(graphics, ilvTransformer);
        this.drawWithoutHandles(graphics, ilvTransformer);
    }

    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getSpline().getSmoothness();
        if (!b) {
            return;
        }
        IlvSpline ilvSpline = this.getSpline();
        graphics.setColor(this.getHandlesColor());
        int n2 = this.getHandleCardinal();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = ilvSpline.getPointAt(i2, ilvTransformer);
            int n5 = (int)Math.floor(ilvPoint.x);
            int n6 = (int)Math.floor(ilvPoint.y);
            if ((i2 == 0 || n3 != n5 || n4 != n6) && i2 != 0) {
                graphics.drawLine(n5, n6, n3, n4);
            }
            n3 = n5;
            n4 = n6;
        }
    }

    public IlvPoint getHandle(int n2, IlvTransformer ilvTransformer) {
        IlvSpline ilvSpline = this.getSpline();
        if (!a) {
            return ilvSpline.getPointAt(n2, ilvTransformer);
        }
        float f2 = ilvSpline.getSmoothness();
        if (f2 == -1.0f || f2 == -2.0f) {
            return ilvSpline.getPointAt(n2, ilvTransformer);
        }
        IlvPoint[] ilvPointArray = this.d != null ? this.d : IlvGraphicUtil.GetPolyPoints(this.getSpline(), ilvTransformer);
        IlvPoint ilvPoint = this.getPolyPoints().getPointAt(n2, ilvTransformer);
        return IlvGraphicUtil.GetSmoothSplineHandleFromBend(n2, ilvPointArray, ilvPointArray.length, f2, false);
    }

    protected void beforeLoopAllHandles(IlvTransformer ilvTransformer) {
        if (!a) {
            return;
        }
        this.d = IlvGraphicUtil.GetPolyPoints(this.getSpline(), ilvTransformer);
    }

    protected void afterLoopAllHandles() {
        this.d = null;
    }

    public IlvSpline getSpline() {
        return (IlvSpline)this.getObject();
    }

    public String getDefaultInteractor() {
        return c == null ? "ilog.views.graphic.IlvSplineEdition" : c;
    }

    public static void SetDefaultInteractor(String string) {
        c = string;
    }

    public static boolean IsHandlesOnSplineMode() {
        return a;
    }

    public static void SetHandlesOnSplineMode(boolean bl) {
        a = bl;
    }

    public static boolean IsShowTangentsMode() {
        return b;
    }

    public static void SetShowTangentsMode(boolean bl) {
        b = bl;
    }
}

