/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.AnchorPointOptimization;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HGraphAlgorithm;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLink;
import ilog.views.graphlayout.hierarchical.HLinkIterator;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.internalutil.LayoutUtil;

final class CalcConnectors
extends HGraphAlgorithm {
    private AnchorPointOptimization a;
    private int b;
    private int c;
    private int d;
    private float e;
    private HNode f;
    private HSegment g;

    CalcConnectors(HGraph hGraph) {
        super.init(hGraph);
        this.a = new AnchorPointOptimization(hGraph);
        this.b = hGraph.ao();
        this.c = hGraph.ap();
        this.d = hGraph.ar();
    }

    void a() {
        super.a();
        if (this.a != null) {
            this.a.a();
        }
        this.a = null;
    }

    public void run() {
        HGraph hGraph = this.getGraph();
        int n2 = hGraph.l();
        int n3 = hGraph.m();
        float f2 = this.c().ac[12];
        switch (this.d) {
            case 99: {
                int n4 = n3 + n2 + n2 / 20;
                this.b().startStep(f2, n4, false);
                this.calcCenteredConnectors();
                break;
            }
            case 100: {
                int n5 = n3 + n2 + n2 / 20;
                this.b().startStep(f2, n5, false);
                this.calcClippedConnectors();
                break;
            }
            case 101: {
                int n6 = 2 * n2 + n2 / 20;
                this.b().startStep(f2, n6, false);
                this.calcEvenSpacedConnectors();
                break;
            }
            default: {
                throw new RuntimeException("CalcConnectors: Illegal connector style");
            }
        }
    }

    public void fixEastWestPorts() {
        HGraph hGraph = this.getGraph();
        int n2 = hGraph.l();
        float f2 = this.c().ac[19];
        this.b().startStep(f2, 2 * n2, false);
        HNodeIterator hNodeIterator = hGraph.p();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            HNode hNode2 = hNode.at();
            if (hNode2 != null) {
                this.a(hNode, hNode2);
            }
            if ((hNode2 = hNode.av()) != null) {
                this.a(hNode, hNode2);
            }
            this.b().addPoints(1);
            this.d();
        }
    }

    private void a(HNode hNode, HNode hNode2) {
        switch (this.d) {
            case 99: {
                this.b(hNode, hNode2);
                break;
            }
            case 100: {
                this.c(hNode, hNode2);
                break;
            }
            case 101: {
                this.c(hNode, hNode2);
                break;
            }
            default: {
                throw new RuntimeException("CalcConnectors: Illegal connector style");
            }
        }
    }

    public final void calcCenteredConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HLinkIterator hLinkIterator = this.getGraph().q();
        while (hLinkIterator.hasNext()) {
            this.a(hLinkIterator.next());
            this.b().addPoints(1);
            this.d();
        }
    }

    private final void a(HLink hLink) {
        this.calcCenteredConnectorsFromSide(hLink);
        this.calcCenteredConnectorsToSide(hLink);
    }

    public final void calcCenteredConnectorsFromSide(HLink hLink) {
        if (!hLink.u().aw()) {
            if (hLink.am()) {
                hLink.aq();
            } else if (!hLink.y()) {
                this.a(hLink, hLink.ae());
            }
        }
    }

    public final void calcCenteredConnectorsToSide(HLink hLink) {
        if (!hLink.v().aw()) {
            if (hLink.an()) {
                hLink.ar();
            } else if (!hLink.z()) {
                this.b(hLink, hLink.ai());
            }
        }
    }

    private final void a(HLink hLink, int n2) {
        HNode hNode;
        float f2;
        float f3;
        HSegment hSegment = hLink.o();
        HNode hNode2 = hSegment.c();
        HNode hNode3 = hSegment.d();
        int n3 = this.a(hSegment, n2);
        int n4 = 1 - n3;
        if (hSegment.ae()) {
            f3 = hNode3.d(n3);
            f2 = hNode2.d(n3);
            hNode = hNode3;
        } else {
            f3 = hNode2.d(n3);
            f2 = hNode3.d(n3);
            hNode = hNode2;
        }
        if (n2 == 1 || n2 == 0) {
            hLink.a(n3, f3);
        } else if (n2 == 3 || n2 == 2) {
            hLink.a(n3, f3 + hNode.f(n3));
        } else if (f3 > f2) {
            hLink.a(n3, f3);
        } else {
            hLink.a(n3, f3 + hNode.f(n3));
        }
        hLink.a(n4, hNode.e(n4));
    }

    private final void b(HLink hLink, int n2) {
        HNode hNode;
        float f2;
        float f3;
        HSegment hSegment = hLink.p();
        HNode hNode2 = hSegment.d();
        HNode hNode3 = hSegment.c();
        int n3 = this.a(hSegment, n2);
        int n4 = 1 - n3;
        if (hSegment.ae()) {
            f3 = hNode3.d(n3);
            f2 = hNode2.d(n3);
            hNode = hNode3;
        } else {
            f3 = hNode2.d(n3);
            f2 = hNode3.d(n3);
            hNode = hNode2;
        }
        if (n2 == 1 || n2 == 0) {
            hLink.b(n3, f3);
        } else if (n2 == 3 || n2 == 2) {
            hLink.b(n3, f3 + hNode.f(n3));
        } else if (f3 > f2) {
            hLink.b(n3, f3);
        } else {
            hLink.b(n3, f3 + hNode.f(n3));
        }
        hLink.b(n4, hNode.e(n4));
    }

    private final void b(HNode hNode, HNode hNode2) {
        if (hNode.o()) {
            return;
        }
        hNode2.a1();
        boolean bl = hNode.ak() < hNode2.ak();
        float f2 = hNode.d(this.b);
        float f3 = hNode.e(this.c);
        float f4 = hNode.d(this.c);
        float f5 = hNode.f(this.c);
        int n2 = hNode2.t(2);
        if (hNode2.t(0) > n2) {
            n2 = hNode2.t(0);
        }
        if (bl) {
            if (hNode.t(1) > n2) {
                n2 = hNode.t(1);
            }
        } else if (hNode.t(3) > n2) {
            n2 = hNode.t(3);
        }
        float[] fArray = null;
        if (n2 > 0) {
            fArray = new float[n2];
            this.a(hNode2, fArray, f4, f5, true, true);
        }
        if (bl) {
            f2 += hNode.f(this.b);
        }
        this.c(hNode2);
        HSegmentIterator hSegmentIterator = hNode2.e();
        while (hSegmentIterator.hasNext()) {
            this.b(hSegmentIterator.next(), f2, f3, fArray);
        }
        hSegmentIterator = hNode2.c();
        while (hSegmentIterator.hasNext()) {
            this.a(hSegmentIterator.next(), f2, f3, fArray);
        }
    }

    private final int a(HSegment hSegment, int n2) {
        if (n2 == 1 || n2 == 3 || n2 == -3) {
            return this.b;
        }
        if (n2 == 0 || n2 == 2 || n2 == -2) {
            return this.c;
        }
        if (hSegment.t() == 0) {
            return this.b;
        }
        return this.c;
    }

    public final void calcClippedConnectors() {
        this.calcNorthSouthPortConnectors();
        this.calcEastWestAuxPortNodeConnectors();
        HLinkIterator hLinkIterator = this.getGraph().q();
        while (hLinkIterator.hasNext()) {
            this.calcClippedConnectors(hLinkIterator.next());
            this.b().addPoints(1);
            this.d();
        }
    }

    public final void calcClippedConnectors(HLink hLink) {
        this.calcFromClippedConnector(hLink);
        this.calcToClippedConnector(hLink);
    }

    public final void calcFromClippedConnector(HLink hLink) {
        if (!hLink.u().aw()) {
            if (hLink.am()) {
                hLink.aq();
            } else if (!hLink.y()) {
                this.b(hLink);
            }
        }
    }

    public final void calcToClippedConnector(HLink hLink) {
        if (!hLink.v().aw()) {
            if (hLink.an()) {
                hLink.ar();
            } else if (!hLink.z()) {
                this.c(hLink);
            }
        }
    }

    private final void b(HLink hLink) {
        float[] fArray;
        int n2;
        HNode hNode;
        HNode hNode2;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.o();
        if (hSegment.ae()) {
            hNode2 = hSegment.d();
            hNode = hSegment.c();
        } else {
            hNode2 = hSegment.c();
            hNode = hSegment.d();
        }
        if (hNode2.ab()) {
            return;
        }
        while (hNode.ab()) {
            hSegment = hNode.f(hSegment);
            hNode = hSegment.c(hNode);
        }
        if (hSegment.c() == hNode) {
            n2 = hSegment.y();
            fArray = hSegment.i();
        } else {
            n2 = hSegment.z();
            fArray = hSegment.j();
        }
        if (n2 == -1) {
            dArray2[0] = hNode.e(0);
            dArray2[1] = hNode.e(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        dArray[0] = hNode2.e(0);
        dArray[1] = hNode2.e(1);
        dArray3[0] = hNode2.r();
        dArray3[1] = hNode2.r() + hNode2.t();
        dArray3[2] = hNode2.s();
        dArray3[3] = hNode2.s() + hNode2.u();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.a(0, (float)dArray[0]);
        hLink.a(1, (float)dArray[1]);
    }

    private final void c(HLink hLink) {
        float[] fArray;
        int n2;
        HNode hNode;
        HNode hNode2;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[4];
        HSegment hSegment = hLink.p();
        if (hSegment.ae()) {
            hNode2 = hSegment.c();
            hNode = hSegment.d();
        } else {
            hNode2 = hSegment.d();
            hNode = hSegment.c();
        }
        if (hNode2.ab()) {
            return;
        }
        while (hNode.ab()) {
            hSegment = hNode.f(hSegment);
            hNode = hSegment.c(hNode);
        }
        if (hSegment.c() == hNode) {
            n2 = hSegment.y();
            fArray = hSegment.i();
        } else {
            n2 = hSegment.z();
            fArray = hSegment.j();
        }
        if (n2 == -1) {
            dArray2[0] = hNode.e(0);
            dArray2[1] = hNode.e(1);
        } else {
            dArray2[0] = fArray[0];
            dArray2[1] = fArray[1];
        }
        dArray[0] = hNode2.e(0);
        dArray[1] = hNode2.e(1);
        dArray3[0] = hNode2.r();
        dArray3[1] = hNode2.r() + hNode2.t();
        dArray3[2] = hNode2.s();
        dArray3[3] = hNode2.s() + hNode2.u();
        LayoutUtil.Clip(dArray, dArray2, dArray3);
        hLink.b(0, (float)dArray[0]);
        hLink.b(1, (float)dArray[1]);
    }

    public final void calcEvenSpacedConnectors() {
        this.calcNorthSouthPortConnectors();
        HNodeIterator hNodeIterator = this.getGraph().p();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (hNode.aw()) {
                this.b(hNode);
            } else {
                this.a(hNode, false);
            }
            this.b().addPoints(1);
            this.d();
        }
    }

    public final void calcEastWestAuxPortNodeConnectors() {
        if (!this.getGraph().a0()) {
            return;
        }
        HNodeIterator hNodeIterator = this.getGraph().p();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!hNode.aw()) continue;
            this.b(hNode);
            this.b().addPoints(1);
            this.d();
        }
    }

    private final void a(HNode hNode, boolean bl) {
        float[] fArray;
        float f2;
        HSegment hSegment;
        if (hNode.o()) {
            return;
        }
        boolean bl2 = !hNode.aw();
        float f3 = hNode.f(this.b);
        float f4 = hNode.d(this.b);
        float f5 = this.a(hNode, f3, true, false, bl);
        HSegmentIterator hSegmentIterator = hNode.c();
        float f6 = f4 + f5;
        float f7 = hNode.d(this.c) + hNode.f(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.k() && bl2) {
                hSegment.m();
                continue;
            }
            if (hSegment.y() != -1 && !bl) continue;
            f2 = this.e * hSegment.g().r();
            fArray = hSegment.i();
            fArray[this.b] = f6 + 0.5f * f2;
            fArray[this.c] = f7;
            f6 += f5 + f2;
        }
        f5 = this.a(hNode, f3, false, true, bl);
        hSegmentIterator = hNode.e();
        f6 = f4 + f5;
        f7 = hNode.d(this.c);
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.l() && bl2) {
                hSegment.n();
                continue;
            }
            if (hSegment.z() != -1 && !bl) continue;
            f2 = this.e * hSegment.g().r();
            fArray = hSegment.j();
            fArray[this.b] = f6 + 0.5f * f2;
            fArray[this.c] = f7;
            f6 += f5 + f2;
        }
    }

    private final void c(HNode hNode, HNode hNode2) {
        float f2;
        HSegment hSegment;
        if (hNode.o()) {
            return;
        }
        hNode2.a1();
        boolean bl = hNode.ak() < hNode2.ak();
        float f3 = hNode.d(this.c);
        float f4 = hNode.f(this.c);
        float f5 = this.a(hNode2, f4, true, true, false);
        int n2 = hNode2.t(2);
        if (hNode2.t(0) > n2) {
            n2 = hNode2.t(0);
        }
        if (bl) {
            if (hNode.t(1) > n2) {
                n2 = hNode.t(1);
            }
        } else if (hNode.t(3) > n2) {
            n2 = hNode.t(3);
        }
        float[] fArray = null;
        if (n2 > 0) {
            fArray = new float[n2];
            this.a(hNode2, fArray, f3, f4, true, true);
        }
        this.c(hNode2);
        HSegmentIterator hSegmentIterator = bl ? hNode2.e() : hNode2.f();
        float f6 = f3 + f5;
        float f7 = hNode.d(this.b);
        if (bl) {
            f7 += hNode.f(this.b);
        }
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (!this.b(hSegment, f7, f6 + 0.5f * (f2 = this.e * hSegment.g().r()), fArray)) continue;
            f6 += f5 + f2;
        }
        HSegmentIterator hSegmentIterator2 = hSegmentIterator = bl ? hNode2.d() : hNode2.c();
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (!this.a(hSegment, f7, f6 + 0.5f * (f2 = this.e * hSegment.g().r()), fArray)) continue;
            f6 += f5 + f2;
        }
    }

    float a(HNode hNode, float f2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        HSegmentIterator hSegmentIterator = bl ? (bl2 ? hNode.g() : hNode.c()) : hNode.e();
        int n2 = 0;
        float f3 = 0.0f;
        boolean bl5 = bl4 = !hNode.aw();
        while (hSegmentIterator.hasNext()) {
            boolean bl6;
            int n3;
            HSegment hSegment = hSegmentIterator.next();
            if (hSegment.c() == hNode) {
                n3 = hSegment.y();
                bl6 = bl4 && hSegment.k();
            } else {
                n3 = hSegment.z();
                boolean bl7 = bl6 = bl4 && hSegment.l();
            }
            if (bl6 || n3 != -1 && !bl3) continue;
            ++n2;
            f3 += hSegment.g().r();
        }
        this.e = 1.0f;
        float f4 = (f2 - f3) / (float)(n2 + 1);
        if ((double)f4 < 0.0) {
            f4 = 0.0f;
            this.e = f2 / f3;
        }
        return f4;
    }

    private boolean a(HSegment hSegment, float f2, float f3, float[] fArray) {
        float f4;
        int n2 = hSegment.y();
        boolean bl = false;
        boolean bl2 = false;
        float f5 = hSegment.a(this.c);
        float f6 = hSegment.q();
        if (hSegment.k()) {
            hSegment.m();
            f4 = hSegment.a(this.c);
            bl = true;
        } else if (n2 == -1) {
            f4 = f3;
            bl2 = true;
        } else {
            f4 = fArray[n2];
        }
        this.a(hSegment, true, f2, f4, f6, f5, bl);
        return bl2;
    }

    private boolean b(HSegment hSegment, float f2, float f3, float[] fArray) {
        float f4;
        int n2 = hSegment.z();
        boolean bl = false;
        boolean bl2 = false;
        float f5 = hSegment.b(this.c);
        float f6 = hSegment.q();
        if (hSegment.l()) {
            hSegment.n();
            f4 = hSegment.b(this.c);
            bl = true;
        } else if (n2 == -1) {
            f4 = f3;
            bl2 = true;
        } else {
            f4 = fArray[n2];
        }
        this.a(hSegment, false, f2, f4, f6, f5, bl);
        return bl2;
    }

    private void a(HSegment hSegment, boolean bl, float f2, float f3, float f4, float f5, boolean bl2) {
        HNode hNode;
        HNode hNode2;
        float[] fArray;
        HLink hLink = hSegment.g();
        if (bl) {
            fArray = hSegment.i();
            hNode2 = hSegment.c();
        } else {
            fArray = hSegment.j();
            hNode2 = hSegment.d();
        }
        if (hLink.x()) {
            HNode hNode3 = this.a(hNode2, hSegment);
            if (!hNode3.ab() && hNode3.o() && hNode3.ae() == -1) {
                hNode3.a(this.b, f4);
            }
            hNode = hLink.a(hSegment);
            HNode hNode4 = hLink.a(hSegment);
            if (hSegment.ae() == bl) {
                HNode hNode5 = hNode;
                hNode = hNode4;
                hNode4 = hNode5;
            }
            hNode4.a(this.b, f4);
            hNode4.a(this.c, f3);
        } else {
            hNode = hLink.a(hSegment);
        }
        hNode.a(this.b, f4);
        hNode.a(this.c, f5);
        if (!bl2) {
            fArray[this.b] = f2;
            fArray[this.c] = f3;
        }
    }

    public final void calcNorthSouthPortConnectors() {
        HNodeIterator hNodeIterator = this.getGraph().p();
        while (hNodeIterator.hasNext()) {
            this.a(hNodeIterator.next());
            this.b().addPoints(1);
            this.d();
        }
    }

    private final void a(HNode hNode) {
        float[] fArray;
        int n2;
        HSegment hSegment;
        HSegmentIterator hSegmentIterator;
        float f2;
        float[] fArray2;
        if (hNode.o()) {
            return;
        }
        if (hNode.aw()) {
            return;
        }
        hNode.a1();
        float f3 = hNode.f(this.b);
        float f4 = hNode.d(this.b);
        int n3 = hNode.t(2);
        if (n3 >= 0) {
            fArray2 = new float[n3];
            this.a(hNode, fArray2, f4, f3, true, false);
            f2 = hNode.d(this.c) + hNode.f(this.c);
            hSegmentIterator = hNode.c();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n2 = hSegment.y();
                if (n2 == -1) continue;
                fArray = hSegment.i();
                fArray[this.b] = fArray2[n2];
                fArray[this.c] = f2;
            }
            fArray2 = null;
        }
        if ((n3 = hNode.t(0)) >= 0) {
            fArray2 = new float[n3];
            this.a(hNode, fArray2, f4, f3, false, true);
            f2 = hNode.d(this.c);
            hSegmentIterator = hNode.e();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                n2 = hSegment.z();
                if (n2 == -1) continue;
                fArray = hSegment.j();
                fArray[this.b] = fArray2[n2];
                fArray[this.c] = f2;
            }
            fArray2 = null;
        }
    }

    private final void b(HNode hNode) {
        hNode.a1();
        if (hNode.t(2) == 0 && hNode.t(0) == 0) {
            this.a(hNode, false);
            return;
        }
        float f2 = hNode.f(this.b);
        float f3 = hNode.d(this.b);
        float f4 = this.a(hNode, f2, true, true, true);
        HSegmentIterator hSegmentIterator = hNode.c();
        HSegmentIterator hSegmentIterator2 = hNode.e();
        float f5 = f3 + f4;
        float f6 = hNode.d(this.c);
        float f7 = f6 + hNode.f(this.c);
        while (hSegmentIterator.hasNext() || hSegmentIterator2.hasNext()) {
            float[] fArray;
            float f8;
            HSegment hSegment;
            if (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                f8 = hSegment.g().r();
                fArray = hSegment.i();
                fArray[this.b] = f5 + 0.5f * f8;
                fArray[this.c] = f7;
                f5 += f4 + f8;
            }
            if (!hSegmentIterator2.hasNext()) continue;
            hSegment = hSegmentIterator2.next();
            f8 = hSegment.g().r();
            fArray = hSegment.j();
            fArray[this.b] = f5 + 0.5f * f8;
            fArray[this.c] = f6;
            f5 += f4 + f8;
        }
    }

    private final void a(HNode hNode, float[] fArray, float f2, float f3, boolean bl, boolean bl2) {
        HSegmentIterator hSegmentIterator;
        int n2;
        int n3 = fArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            fArray[n2] = 0.0f;
        }
        HSegmentIterator hSegmentIterator2 = bl ? (bl2 ? hNode.g() : hNode.c()) : (hSegmentIterator = hNode.e());
        while (hSegmentIterator.hasNext()) {
            HSegment hSegment = hSegmentIterator.next();
            int n4 = hSegment.c() == hNode ? hSegment.y() : hSegment.z();
            if (n4 == -1) continue;
            fArray[n4] = Math.max(hSegment.g().r(), fArray[n4]);
        }
        float f4 = 0.0f;
        for (n2 = 0; n2 < fArray.length; ++n2) {
            f4 += fArray[n2];
        }
        float f5 = Float.MAX_VALUE;
        float f6 = (f3 - f4) / (float)(n3 + 1);
        if ((double)f6 < 0.0) {
            f6 = f3 / (float)(n3 + 1);
            f5 = 0.0f;
        }
        float f7 = f2 + f6;
        for (n2 = 0; n2 < n3; ++n2) {
            float f8 = fArray[n2];
            if (f8 > f5) {
                f8 = f5;
            }
            fArray[n2] = f7 + 0.5f * f8;
            f7 += f6 + f8;
        }
    }

    private void c(HNode hNode) {
        float f2;
        HSegment hSegment;
        float[] fArray = new float[2];
        this.a(hNode, fArray);
        HSegmentIterator hSegmentIterator = hNode.c();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.y() != -1) {
                bl = true;
            }
            f2 = this.a(hSegment, fArray, true);
            hSegment.e(f2);
            ++n2;
        }
        hSegmentIterator = hNode.e();
        while (hSegmentIterator.hasNext()) {
            hSegment = hSegmentIterator.next();
            if (hSegment.z() != -1) {
                bl = true;
            }
            f2 = this.a(hSegment, fArray, false);
            hSegment.e(f2);
            ++n3;
        }
        if (bl) {
            this.a.a(hNode.c(), hNode.e(), n2 + n3, true);
            this.a.run();
            this.a.a(hNode.c(), hNode.e(), n2 + n3, false);
            this.a.run();
        } else {
            hSegmentIterator = hNode.c();
            this.a.a(hSegmentIterator, n2, true);
            this.a.run();
            hSegmentIterator = hNode.e();
            this.a.a(hSegmentIterator, n3, false);
            this.a.run();
        }
    }

    private float a(HSegment hSegment, float[] fArray, boolean bl) {
        HNode hNode;
        float f2;
        int n2 = this.b;
        if (bl) {
            f2 = hSegment.a(n2);
            hNode = hSegment.c();
        } else {
            f2 = hSegment.b(n2);
            hNode = hSegment.d();
        }
        HLink hLink = hSegment.g();
        if (hLink.u().ae() == hLink.v().ae()) {
            return f2;
        }
        HNode hNode2 = this.a(hNode, hSegment);
        if (hNode2.ab()) {
            return f2;
        }
        float f3 = this.e();
        if (hLink.x() && hNode2.o() && hNode2.ae() == -1) {
            if ((hNode2 = this.a(hNode2, hNode2.f(this.g))).ab()) {
                return f2;
            }
            f3 = this.e();
        }
        if (f3 >= fArray[0] && f3 <= fArray[1]) {
            return f3;
        }
        return f2;
    }

    private final void a(HNode hNode, float[] fArray) {
        HSegment hSegment;
        HNode hNode2;
        int n2 = this.b;
        HGraph hGraph = this.getGraph();
        fArray[0] = -3.4028235E38f;
        fArray[1] = Float.MAX_VALUE;
        int n3 = hNode.ak();
        HLevel hLevel = hNode.ai();
        if (n3 > 0) {
            hNode2 = hLevel.b(n3 - 1);
            if (hNode2.aw()) {
                fArray[0] = 0.5f * (hNode2.d(n2) + hNode2.f(n2) + hNode.d(n2) + hGraph.l(n2));
            } else if (hNode2.o()) {
                if (hNode2.ab() && hNode2.p().x()) {
                    HSegment hSegment2 = hSegment = hNode2.i() > 0 ? hNode2.k() : hNode2.l();
                    while (hNode2.o() && hNode2.ab()) {
                        hSegment = hNode2.f(hSegment);
                        hNode2 = hSegment.c(hNode2);
                    }
                }
                fArray[0] = hNode2.d(n2) + hNode2.f(n2) + hGraph.l(n2);
            } else {
                fArray[0] = hNode2.d(n2) + hNode2.f(n2) + hGraph.k(n2);
            }
        }
        if (n3 < hLevel.g() - 1) {
            hNode2 = hLevel.b(n3 + 1);
            if (hNode2.aw()) {
                fArray[1] = 0.5f * (hNode.d(n2) + hNode.f(n2) + hNode2.d(n2) - hGraph.l(n2));
            } else if (hNode2.o()) {
                if (hNode2.ab() && hNode2.p().x()) {
                    HSegment hSegment3 = hSegment = hNode2.i() > 0 ? hNode2.k() : hNode2.l();
                    while (hNode2.o() && hNode2.ab()) {
                        hSegment = hNode2.f(hSegment);
                        hNode2 = hSegment.c(hNode2);
                    }
                }
                fArray[1] = hNode2.d(n2) - hGraph.l(n2);
            } else {
                fArray[1] = hNode2.d(n2) - hGraph.k(n2);
            }
        }
    }

    HNode a(HNode hNode, HSegment hSegment) {
        hNode = hSegment.c(hNode);
        while (hNode.ab() && hNode.ae() == -1) {
            hSegment = hNode.f(hSegment);
            hNode = hSegment.c(hNode);
        }
        this.f = hNode;
        this.g = hSegment;
        return hNode;
    }

    float e() {
        if (this.g.c() == this.f) {
            return this.g.a(this.b);
        }
        return this.g.b(this.b);
    }
}

