/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.prototypes;

import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.prototypes.IlvValueException;
import java.io.IOException;
import java.io.Serializable;

class IlvPersistentValue
implements IlvPersistentObject,
Serializable {
    String a;
    Object b;

    public IlvPersistentValue(String string, Object object) {
        this.a = string;
        this.b = object;
    }

    public IlvPersistentValue(IlvPersistentValue ilvPersistentValue) {
        this.a = ilvPersistentValue.a;
        this.b = ilvPersistentValue.b;
    }

    public IlvPersistentValue(IlvInputStream ilvInputStream) throws IlvReadFileException {
        Class<?> clazz;
        this.a = ilvInputStream.readString("name");
        String string = ilvInputStream.readString("type");
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IlvReadFileException("Reading persistent value");
        }
        String string2 = ilvInputStream.readString("value");
        try {
            this.b = IlvValueConverter.convert(string2, clazz);
        }
        catch (IlvValueException ilvValueException) {
            throw new IlvReadFileException(ilvValueException.getMessage());
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("name", this.a);
        ilvOutputStream.write("type", this.b.getClass().getName());
        try {
            String string = (String)IlvValueConverter.convert(this.b, String.class);
            ilvOutputStream.write("value", string);
        }
        catch (IlvValueException ilvValueException) {
            throw new IOException(ilvValueException.getMessage());
        }
    }

    public String getName() {
        return this.a;
    }

    public Object getValue() {
        return this.b;
    }

    public void setValue(Object object) {
        this.b = object;
    }
}

