/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.internal.IlvGraphicManagerFrame;
import ilog.views.io.IlvReadFileException;
import ilog.views.prototypes.IlvPrototype;
import ilog.views.prototypes.IlvPrototypeLibrary;
import ilog.views.prototypes.IlvValueConverter;
import ilog.views.prototypes.IlvValueException;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.renderer.IlvFilterSDMRenderer;
import ilog.views.sdm.renderer.IlvSDMRenderer;
import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;

public class IlvRendererUtil {
    private static Vector a = new Vector(19);
    private static Vector b = new Vector(19);
    private static Vector c;
    public static final String Blinking = "Blinking";
    public static final String Composite = "Composite";
    public static final String Animation = "Animation";
    public static final String Coloring = "Coloring";
    public static final String Decoration = "Decoration";
    public static final String ExpandCollapse40 = "ExpandCollapse40";
    public static final String SubGraph = "SubGraph";
    public static final String ExpandCollapse = "ExpandCollapse";
    public static final String HalfZooming = "HalfZooming";
    public static final String InfoBalloon = "InfoBalloon";
    public static final String Legend = "Legend";
    public static final String DrillDown = "DrillDown";
    public static final String Map = "Map";
    public static final String SwimLanes = "SwimLanes";
    public static final String Lanes = "Lanes";
    public static final String LabelLayout = "LabelLayout";
    public static final String LinkLayout = "LinkLayout";
    public static final String GraphLayout = "GraphLayout";
    public static final String Interactor = "Interactor";
    public static final String GrapherPin = "GrapherPin";
    public static final String StyleSheet = "StyleSheet";

    private IlvRendererUtil() {
    }

    public static void addRendererAlias(String string, String string2) {
        int n2 = a.indexOf(string);
        if (n2 == -1) {
            a.addElement(string);
            b.addElement(string2);
        } else {
            b.set(n2, string2);
        }
    }

    public static String getRendererClassName(String string) {
        int n2 = a.indexOf(string);
        if (n2 >= 0) {
            return (String)b.elementAt(n2);
        }
        return null;
    }

    public static String getRendererAlias(String string) {
        int n2 = b.indexOf(string);
        if (n2 >= 0) {
            return (String)a.elementAt(n2);
        }
        return null;
    }

    public static String[] getRendererAliases() {
        Object[] objectArray = new String[a.size()];
        a.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getRendererClassNames() {
        Object[] objectArray = new String[b.size()];
        b.copyInto(objectArray);
        return objectArray;
    }

    public static IlvSDMRenderer getRenderer(IlvSDMEngine ilvSDMEngine, String string) {
        Object object = ilvSDMEngine.getRenderer();
        while (object != null) {
            if (((IlvSDMRenderer)object).getAlias() != null && ((IlvSDMRenderer)object).getAlias().equals(string)) {
                return object;
            }
            object = object instanceof IlvFilterSDMRenderer ? ((IlvFilterSDMRenderer)object).getFilteredRenderer() : null;
        }
        object = ilvSDMEngine.getRenderer();
        while (object != null) {
            for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                if (clazz.getName().equals(string)) {
                    return object;
                }
                if (c.contains(clazz.getName())) break;
            }
            object = object instanceof IlvFilterSDMRenderer ? ((IlvFilterSDMRenderer)object).getFilteredRenderer() : null;
        }
        object = IlvRendererUtil.getRendererClassName(string);
        if (object != null && !((String)object).equals(string)) {
            return IlvRendererUtil.getRenderer(ilvSDMEngine, (String)object);
        }
        return null;
    }

    public static Object getGraphicProperty(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, Class clazz) {
        String[] stringArray2 = IlvRendererUtil.getPseudoClasses(ilvSDMEngine, object, stringArray);
        Object object2 = ilvSDMEngine.getRenderer().getGraphicProperty(ilvSDMEngine, object, string, stringArray2, clazz);
        return object2;
    }

    public static String getGraphicPropertyAsString(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, String string2) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToString(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static boolean getGraphicPropertyAsBoolean(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, boolean bl) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToBoolean(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static int getGraphicPropertyAsInt(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, int n2) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToInt(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static long getGraphicPropertyAsLong(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, long l2) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToLong(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return l2;
    }

    public static float getGraphicPropertyAsFloat(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, float f2) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToFloat(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return f2;
    }

    public static double getGraphicPropertyAsDouble(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, double d2) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return IlvValueConverter.convertToDouble(object2);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return d2;
    }

    public static Color getGraphicPropertyAsColor(IlvSDMEngine ilvSDMEngine, Object object, String string, String[] stringArray, Color color) {
        Object object2 = IlvRendererUtil.getGraphicProperty(ilvSDMEngine, object, string, stringArray, null);
        if (object2 != null) {
            try {
                return (Color)IlvValueConverter.convert(object2, Color.class);
            }
            catch (IlvValueException ilvValueException) {
                // empty catch block
            }
        }
        return color;
    }

    public static void updateObjectProperties(IlvSDMEngine ilvSDMEngine, Object object, String string, Object object2, String[] stringArray) {
        ilvSDMEngine.updateObjectProperties(object, string, object2, stringArray);
    }

    public static void customize(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, String[] stringArray) {
        String[] stringArray2 = IlvRendererUtil.getPseudoClasses(ilvSDMEngine, object, stringArray);
        ilvSDMEngine.getRenderer().customize(ilvSDMEngine, object, ilvGraphic, stringArray2);
    }

    public static void customize(final IlvSDMEngine ilvSDMEngine, final Object object, final String[] stringArray, boolean bl) {
        IlvGraphic ilvGraphic;
        final IlvGraphic ilvGraphic2 = ilvGraphic = ilvSDMEngine.getGraphic(object, false);
        if (ilvGraphic != null) {
            IlvManager ilvManager;
            IlvGraphic ilvGraphic3;
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            while (ilvGraphicBag != null && !(ilvGraphicBag instanceof IlvManager)) {
                if (ilvGraphicBag instanceof IlvGraphic) {
                    if (ilvGraphicBag.getGraphicBag() == null) break;
                    ilvGraphic = (IlvGraphic)((Object)ilvGraphicBag);
                    ilvGraphicBag = ilvGraphicBag.getGraphicBag();
                    continue;
                }
                if (!(ilvGraphicBag instanceof IlvGraphicManagerFrame)) continue;
                ilvGraphic3 = ((IlvGraphicManagerFrame)((Object)ilvGraphicBag)).getFrameGraphic();
                ilvGraphic = (IlvManager)ilvGraphic3.getProperty("_sdm_subgraphrender_bag");
                ilvGraphicBag = ilvGraphic.getGraphicBag();
            }
            if (ilvGraphicBag != null && !(ilvGraphicBag instanceof IlvManager) && (ilvManager = (IlvManager)(ilvGraphic3 = (IlvGraphic)((Object)ilvGraphicBag)).getProperty("_sdm_subgraphrender_bag")) != null) {
                ilvGraphicBag = ilvManager.getGraphicBag();
                ilvGraphic = ilvManager;
            }
            if (ilvGraphicBag != null) {
                ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object2) {
                        IlvRendererUtil.customize(ilvSDMEngine, object, ilvGraphic2, stringArray);
                    }
                }, null, bl);
            } else {
                IlvRendererUtil.customize(ilvSDMEngine, object, ilvGraphic, stringArray);
            }
        }
    }

    public static String[] getPseudoClasses(IlvSDMEngine ilvSDMEngine, Object object, String[] stringArray) {
        String[] stringArray2 = ilvSDMEngine.getPseudoClasses(object);
        if (stringArray2 != null && stringArray != null) {
            String[] stringArray3 = new String[stringArray2.length + stringArray.length];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray3, stringArray2.length, stringArray.length);
            return stringArray3;
        }
        if (stringArray2 != null) {
            return stringArray2;
        }
        return stringArray;
    }

    public static IlvPrototype getPrototype(String string, Class clazz) throws MalformedURLException, IlvReadFileException, IOException {
        return IlvPrototypeLibrary.getPrototype(string, clazz);
    }

    static void a(IlvLinkImage ilvLinkImage) {
        int n2;
        if (!(ilvLinkImage instanceof IlvPolicyAwareLinkImage)) {
            return;
        }
        IlvPolicyAwareLinkImage ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage;
        if (ilvPolicyAwareLinkImage.getLinkShapePolicy() == null) {
            return;
        }
        final IlvPoint[] ilvPointArray = (IlvPoint[])ilvLinkImage.getProperty("__OriginalLinkPoints");
        int n3 = n2 = ilvPointArray == null ? 0 : ilvPointArray.length;
        if (ilvLinkImage.getGraphicBag() != null) {
            ilvLinkImage.getGraphicBag().applyToObject(ilvLinkImage, new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    ((IlvLinkImage)ilvGraphic).setIntermediateLinkPoints(ilvPointArray, 0, n2);
                }
            }, null, false);
        } else {
            ilvPolicyAwareLinkImage.setIntermediateLinkPoints(ilvPointArray, 0, n2);
        }
    }

    static {
        IlvRendererUtil.addRendererAlias(Blinking, "ilog.views.sdm.renderer.IlvBlinkingRenderer");
        IlvRendererUtil.addRendererAlias(HalfZooming, "ilog.views.sdm.renderer.IlvHalfZoomingRenderer");
        IlvRendererUtil.addRendererAlias(Composite, "ilog.views.sdm.renderer.IlvCompositeRenderer");
        IlvRendererUtil.addRendererAlias(Animation, "ilog.views.sdm.renderer.animation.IlvAnimationRenderer");
        IlvRendererUtil.addRendererAlias(Coloring, "ilog.views.sdm.renderer.IlvColoringRenderer");
        IlvRendererUtil.addRendererAlias(Decoration, "ilog.views.sdm.renderer.IlvDecorationRenderer");
        IlvRendererUtil.addRendererAlias(ExpandCollapse40, "ilog.views.sdm.renderer.IlvExpandCollapseRenderer");
        IlvRendererUtil.addRendererAlias(SubGraph, "ilog.views.sdm.renderer.IlvSubGraphRenderer");
        IlvRendererUtil.addRendererAlias(ExpandCollapse, "ilog.views.sdm.renderer.IlvSubGraphRenderer");
        IlvRendererUtil.addRendererAlias(InfoBalloon, "ilog.views.sdm.renderer.IlvInfoBalloonRenderer");
        IlvRendererUtil.addRendererAlias(Legend, "ilog.views.sdm.renderer.IlvLegendRenderer");
        IlvRendererUtil.addRendererAlias(DrillDown, "ilog.views.sdm.renderer.IlvDrillDownRenderer");
        IlvRendererUtil.addRendererAlias(Map, "ilog.views.sdm.renderer.maps.IlvMapRenderer");
        IlvRendererUtil.addRendererAlias("ClipartLibrary", "ilog.views.maps.symbology.clipart.IlvClipartLibraryRenderer");
        IlvRendererUtil.addRendererAlias(SwimLanes, "ilog.views.sdm.renderer.graphlayout.IlvSwimLanesRenderer");
        IlvRendererUtil.addRendererAlias(Lanes, "ilog.views.sdm.renderer.IlvLaneRenderer");
        IlvRendererUtil.addRendererAlias(LabelLayout, "ilog.views.sdm.renderer.graphlayout.IlvLabelLayoutRenderer");
        IlvRendererUtil.addRendererAlias(LinkLayout, "ilog.views.sdm.renderer.graphlayout.IlvLinkLayoutRenderer");
        IlvRendererUtil.addRendererAlias(GraphLayout, "ilog.views.sdm.renderer.graphlayout.IlvGraphLayoutRenderer");
        IlvRendererUtil.addRendererAlias(Interactor, "ilog.views.sdm.renderer.IlvInteractorRenderer");
        IlvRendererUtil.addRendererAlias(GrapherPin, "ilog.views.sdm.renderer.IlvGrapherPinRenderer");
        IlvRendererUtil.addRendererAlias(StyleSheet, "ilog.views.sdm.renderer.IlvStyleSheetRenderer");
        c = (Vector)b.clone();
    }
}

