/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.css.parser;

import ilog.views.util.css.IlvCSSDOMImplementation;
import ilog.views.util.css.IlvCSSDocument;
import ilog.views.util.css.parser.DeclarationValue;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvCSSDeclaration;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Declaration
implements Serializable,
IlvCSSDeclaration {
    private final IlvCSSDOMImplementation a;
    public String _source = null;
    public String _loadedTarget;
    private DeclarationValue b;
    private IlvCSSDocument c;
    public int _documentLine;

    protected Declaration(IlvCSSDOMImplementation ilvCSSDOMImplementation) {
        this.a = ilvCSSDOMImplementation;
        this._documentLine = -1;
        this.b = ilvCSSDOMImplementation.getEmptyDeclarationValue();
    }

    public static Declaration copy(Declaration declaration) {
        if (declaration == null) {
            throw new IllegalArgumentException("null declaration to copy");
        }
        Declaration declaration2 = declaration.a.createDeclaration();
        declaration2._source = declaration._source;
        declaration2.b = declaration.b;
        declaration2.c = declaration.c;
        declaration2._loadedTarget = declaration._loadedTarget;
        declaration2._documentLine = declaration._documentLine;
        return declaration2;
    }

    public final IlvCSSDOMImplementation getDOMImplementation() {
        return this.a;
    }

    public IlvCSSDocument getDocument() {
        if (this.c == null) {
            throw new RuntimeException("null document for declaration " + this);
        }
        return this.c;
    }

    @Override
    public String getProperty() {
        return this._source;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String string) {
        this._source = string != null ? string.intern() : null;
    }

    public DeclarationValue getDeclarationValue() {
        return this.b;
    }

    public void setDeclarationValue(DeclarationValue declarationValue) {
        if (declarationValue == null) {
            throw new IllegalArgumentException("null DeclarationValue - use getEmptyDeclarationValue() instead");
        }
        this.b = declarationValue;
    }

    @Override
    public String getValue() {
        return this.b.getValueAsString();
    }

    public void setValue(String string) {
        String string2;
        if (string == null) {
            string = "";
        }
        if (!(string2 = this.b.getValueAsString()).equals(string)) {
            this.b = this.a.createDeclarationValue(string);
        }
    }

    @Override
    public int getLineNumber() {
        return this._documentLine;
    }

    public void setDocument(IlvCSSDocument ilvCSSDocument) {
        this.c = ilvCSSDocument;
    }

    @Override
    public URL getDocumentPath() {
        return this.c == null ? null : this.c.getURL();
    }

    public void setDocumentPath(URL uRL) {
        if (this.getDocument() == null) {
            this.c = new IlvCSSDocument();
        }
        this.c.setURL(uRL);
    }

    public void print(PrintStream printStream, int n2) {
        Rule.a(printStream, n2);
        printStream.print("{" + this._source + " -> " + this.getValue() + "} ");
    }

    @Override
    public void printCSS(PrintWriter printWriter, int n2) {
        this.printCSS(printWriter, n2, null);
    }

    public void printCSS(PrintWriter printWriter, int n2, IlvCSSDocument ilvCSSDocument) {
        Rule.a(printWriter, n2);
        String string = this.getValue();
        if (this._loadedTarget != null && this._loadedTarget.startsWith("url(") && !string.startsWith("url(")) {
            if (ilvCSSDocument == null || ilvCSSDocument.getURL() == null) {
                printWriter.println(this._source + " : \"url(" + Rule.escape(string) + ")\" ;");
            } else {
                printWriter.println(this._source + " : \"url(" + Declaration.a(string, ilvCSSDocument.getURL()) + ")\" ;");
            }
        } else {
            printWriter.println(this._source + " : \"" + Rule.escape(string) + "\" ;");
        }
    }

    public boolean equals(Object object) {
        throw new RuntimeException("Want to know where Declaration:equal is used. This is problematic and should be removed. Use isIdentical if possible.");
    }

    @Override
    public boolean isIdentical(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Declaration)) {
            return false;
        }
        Declaration declaration = (Declaration)object;
        if (!Rule.a(this._source, declaration._source)) {
            return false;
        }
        return Rule.a(this.getValue(), declaration.getValue());
    }

    public int hashCode() {
        int n2 = 0;
        if (this._source != null) {
            n2 += this._source.hashCode();
        }
        return n2 ^= this.getValue().hashCode() * 31;
    }

    private static String a(String string, URL uRL) {
        URL uRL2 = null;
        if (string == null) {
            throw new NullPointerException("content url must not be null.");
        }
        if (uRL == null) {
            throw new NullPointerException("baseURL must not be null.");
        }
        try {
            uRL2 = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("bad url." + string);
        }
        if (Declaration.a(uRL2, uRL)) {
            List<String> list = Declaration.a(uRL2.getPath());
            List<String> list2 = Declaration.a(uRL.getPath());
            String string2 = uRL2.getQuery();
            String string3 = uRL2.getRef();
            if (!uRL.getPath().endsWith("/")) {
                list2.remove(list2.size() - 1);
            }
            if (uRL2.equals(uRL)) {
                return list.get(list.size() - 1);
            }
            int n2 = Declaration.a(list, list2);
            if (n2 == 0) {
                return uRL2.toExternalForm();
            }
            if (n2 == list.size()) {
                --n2;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n3 = list2.size() - n2;
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList.add("..");
            }
            arrayList.addAll(list.subList(n2, list.size()));
            return Declaration.a(arrayList, string3, string2);
        }
        return uRL2.toExternalForm();
    }

    private static boolean a(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equals(uRL2.getHost())) {
            return false;
        }
        return uRL.getPort() == uRL2.getPort();
    }

    private static List<String> a(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2.length() == 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static int a(List<String> list, List<String> list2) {
        int n2 = Math.min(list2.size(), list.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            String string2 = list.get(i2);
            if (string2.equals(string = list2.get(i2))) continue;
            return i2;
        }
        return n2;
    }

    private static String a(List<String> list, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("/");
        }
        if (string != null) {
            stringBuffer.append('#');
            stringBuffer.append(string);
        }
        if (string2 != null) {
            stringBuffer.append('?');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static void unitTest() {
        try {
            URL uRL = new URL("http://wombat.ilog.fr/root/foo/file.css");
            String string = "http://wombat.ilog.fr/root/foo/data/image.svg";
            Declaration.a(uRL, string, "data/image.svg");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg#toto", "data/image.svg#toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg?toto", "data/image.svg?toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg#foo?toto", "data/image.svg#foo?toto");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/data/image.svg?foo#toto", "data/image.svg#toto?foo");
            Declaration.a(uRL, "http://wombat.ilog.fr:80/root/foo/data/image.svg", "http://wombat.ilog.fr:80/root/foo/data/image.svg");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/image.svg", "image.svg");
            uRL = new URL("http://wombat.ilog.fr/root/foo/");
            Declaration.a(uRL, "http://wombat.ilog.fr/root/foo/image.svg", "image.svg");
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Bad URL test", malformedURLException);
        }
    }

    private static void a(URL uRL, String string, String string2) {
        if (!string2.equals(Declaration.a(string, uRL))) {
            throw new RuntimeException("Didn't create correct relative URL " + string2);
        }
    }
}

