/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

public abstract class IlvUnit {
    public static final IlvUnit CM = new CM();
    public static final IlvUnit INCHES = new INCHES();
    public static final IlvUnit POINTS = new POINTS();
    private String a;

    IlvUnit(String string) {
        this.a = string;
    }

    public double getAs(double d2, IlvUnit ilvUnit) {
        if (ilvUnit == CM) {
            return this.a(d2);
        }
        if (ilvUnit == INCHES) {
            return this.b(d2);
        }
        if (ilvUnit == POINTS) {
            return this.c(d2);
        }
        throw new Error("unknown unit");
    }

    public String toString() {
        return this.a;
    }

    abstract double a(double var1);

    abstract double b(double var1);

    abstract double c(double var1);

    private static final class CM
    extends IlvUnit {
        CM() {
            super("Cm");
        }

        double a(double d2) {
            return d2;
        }

        double b(double d2) {
            return d2 / 2.54;
        }

        double c(double d2) {
            return d2 / 2.54 * 72.0;
        }
    }

    public static final class Dimension
    implements Cloneable {
        private double a;
        private double b;
        private IlvUnit c;

        public Dimension(IlvUnit ilvUnit) {
            this(0.0, 0.0, ilvUnit);
        }

        public Dimension(double d2, double d3, IlvUnit ilvUnit) {
            this.a = d2;
            this.b = d3;
            this.c = ilvUnit;
        }

        public IlvUnit getUnit() {
            return this.c;
        }

        public double getWidth() {
            return this.a;
        }

        public double getHeight() {
            return this.b;
        }

        public void setSize(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public double getWidthAs(IlvUnit ilvUnit) {
            return this.c.getAs(this.a, ilvUnit);
        }

        public double getHeightAs(IlvUnit ilvUnit) {
            return this.c.getAs(this.b, ilvUnit);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    private static final class INCHES
    extends IlvUnit {
        INCHES() {
            super("INCHES");
        }

        double a(double d2) {
            return d2 * 2.54;
        }

        double b(double d2) {
            return d2;
        }

        double c(double d2) {
            return d2 * 72.0;
        }
    }

    public static final class Measure
    implements Cloneable {
        private double a;
        private IlvUnit b;

        public Measure(double d2, IlvUnit ilvUnit) {
            this.a = d2;
            this.b = ilvUnit;
        }

        public IlvUnit getUnit() {
            return this.b;
        }

        public void set(double d2) {
            this.a = d2;
        }

        public double get() {
            return this.a;
        }

        public double getAs(IlvUnit ilvUnit) {
            return this.b.getAs(this.a, ilvUnit);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    private static final class POINTS
    extends IlvUnit {
        POINTS() {
            super("POINTS");
        }

        double a(double d2) {
            return d2 / 72.0 * 2.54;
        }

        double b(double d2) {
            return d2 / 72.0;
        }

        double c(double d2) {
            return d2;
        }
    }

    public static final class Point
    implements Cloneable {
        private double a;
        private double b;
        private IlvUnit c;

        public Point(IlvUnit ilvUnit) {
            this(0.0, 0.0, ilvUnit);
        }

        public Point(double d2, double d3, IlvUnit ilvUnit) {
            this.a = d2;
            this.b = d3;
            if (ilvUnit == null) {
                throw new IllegalArgumentException("unit not specified");
            }
            this.c = ilvUnit;
        }

        public IlvUnit getUnit() {
            return this.c;
        }

        public double getX() {
            return this.a;
        }

        public void setX(double d2) {
            this.a = d2;
        }

        public double getY() {
            return this.b;
        }

        public void setY(double d2) {
            this.b = d2;
        }

        public double getXAs(IlvUnit ilvUnit) {
            return this.c.getAs(this.a, ilvUnit);
        }

        public double getYAs(IlvUnit ilvUnit) {
            return this.c.getAs(this.b, ilvUnit);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    public static final class Rectangle
    implements Cloneable {
        private double a;
        private double b;
        private double c;
        private double d;
        private IlvUnit e;

        public Rectangle(double d2, double d3, double d4, double d5, IlvUnit ilvUnit) {
            this.a = d2;
            this.b = d3;
            this.c = d4;
            this.d = d5;
            this.e = ilvUnit;
        }

        public IlvUnit getUnit() {
            return this.e;
        }

        public double getX() {
            return this.a;
        }

        public void setX(double d2) {
            this.a = d2;
        }

        public double getY() {
            return this.b;
        }

        public void setY(double d2) {
            this.b = d2;
        }

        public double getWidth() {
            return this.c;
        }

        public double getHeight() {
            return this.d;
        }

        public void setSize(double d2, double d3) {
            this.c = d2;
            this.d = d3;
        }

        public double getXAs(IlvUnit ilvUnit) {
            return this.e.getAs(this.a, ilvUnit);
        }

        public double getYAs(IlvUnit ilvUnit) {
            return this.e.getAs(this.b, ilvUnit);
        }

        public double getWidthAs(IlvUnit ilvUnit) {
            return this.e.getAs(this.c, ilvUnit);
        }

        public double getHeightAs(IlvUnit ilvUnit) {
            return this.e.getAs(this.d, ilvUnit);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(this.a);
            stringBuffer.append(" ");
            stringBuffer.append(this.b);
            stringBuffer.append(" ");
            stringBuffer.append(this.c);
            stringBuffer.append(" ");
            stringBuffer.append(this.d);
            stringBuffer.append("] ");
            stringBuffer.append(this.e);
            return stringBuffer.toString();
        }
    }
}

