/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ForceToPrimaryNotAllowed;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Observable;

public abstract class AbstractLinkModel
extends Model
implements ILinkModel {
    static final SDebug defaultDebug = new SDebug("LinkModel");
    protected INodeModel topoHost;
    protected INodeModel src;
    protected INodeModel dst;
    protected int srcEntityIndex;
    protected int dstEntityIndex;
    protected short srcSlotNum;
    protected short dstSlotNum;
    protected IHoNum srcHO;
    protected IHoNum dstHO;
    protected int oldState;
    protected int newState;
    public int ltype;
    public int phyType;
    protected int phyLinkType;
    protected boolean isXcCapable;
    protected boolean isNbrXcCapable;
    public int prot;
    public int protGroup;
    public int role;
    public int cost;

    public AbstractLinkModel(INodeModel iNodeModel, int n, IHoNum iHoNum, INodeModel iNodeModel2, int n2, IHoNum iHoNum2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, int n7, int n8, int n9) {
        super(iNodeModel != null ? ((Model)iNodeModel).db.getChildDebug("LinkModel") : defaultDebug);
        this.init(iNodeModel, n, iHoNum, iNodeModel2, n2, iHoNum2, n3, n4, n5, bl, bl2, n6, n7, n8, n9);
    }

    private void init(INodeModel iNodeModel, int n, IHoNum iHoNum, INodeModel iNodeModel2, int n2, IHoNum iHoNum2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, int n7, int n8, int n9) {
        this.oldState = 1;
        this.newState = 1;
        this.topoHost = null;
        this.src = iNodeModel;
        this.dst = iNodeModel2;
        this.srcEntityIndex = n;
        this.dstEntityIndex = n2;
        this.srcSlotNum = (short)-1;
        this.dstSlotNum = (short)-1;
        this.srcHO = iHoNum;
        this.dstHO = iHoNum2;
        this.ltype = n3;
        this.phyType = n4;
        this.phyLinkType = n5;
        this.isXcCapable = bl;
        this.isNbrXcCapable = bl2;
        this.prot = n6;
        this.protGroup = n7;
        this.role = n8;
        this.cost = n9;
    }

    public void destroy() {
        super.destroy();
        this.topoHost = null;
        this.src = null;
        this.dst = null;
    }

    public INodeModel topoHost() {
        return this.topoHost;
    }

    public void setTopoHost(INodeModel iNodeModel) {
        this.topoHost = iNodeModel;
    }

    public INodeModel src() {
        return this.src;
    }

    public INodeModel dst() {
        return this.dst;
    }

    public INodeModel getNodeModel() {
        return null;
    }

    public int srcEntityIndex() {
        return this.srcEntityIndex;
    }

    public int dstEntityIndex() {
        return this.dstEntityIndex;
    }

    public IEntityModel getEndEntityModel(boolean bl) {
        if (bl) {
            return this.getEntityModel(this.src, this.srcEntityIndex);
        }
        return this.getEntityModel(this.dst, this.dstEntityIndex);
    }

    public IEntityModel getEntityModel(INodeModel iNodeModel, int n) {
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            return null;
        }
        try {
            return iEntityTableModel.getEntityModelByIndex(n);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
    }

    public abstract int srcSlotNum();

    public abstract int dstSlotNum();

    public IHoNum srcHo() {
        return this.srcHO;
    }

    public IHoNum dstHo() {
        return this.dstHO;
    }

    protected short calcSlotNum(INodeModel iNodeModel, int n) {
        block3: {
            if (iNodeModel != null && iNodeModel.getEntityTable() != null) {
                try {
                    return (short)iNodeModel.getEntityTable().getEntityModelByIndex(n).getSlot();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block3;
                    this.db.println("Can't find entity " + n + " on node " + iNodeModel.getName());
                }
            }
        }
        return -1;
    }

    public int state() {
        return 1;
    }

    public int linkType() {
        return this.ltype;
    }

    public int physicalType() {
        return this.phyType;
    }

    public int physicalLinkType() {
        return this.phyLinkType;
    }

    public boolean isXcCapable() {
        return this.isXcCapable;
    }

    public boolean isNbrXcCapable() {
        return this.isNbrXcCapable;
    }

    public void setIsXcCapable(boolean bl) {
        this.isXcCapable = bl;
    }

    public void setIsNbrXcCapable(boolean bl) {
        this.isNbrXcCapable = bl;
    }

    public int protectionType() {
        return this.prot;
    }

    public boolean isPca() {
        return this.protectionType() == 5 || this.protectionType() == 6 || this.protectionType() == 14;
    }

    public int protectionGroup() {
        return this.protGroup;
    }

    public int protectionRole() {
        return this.role;
    }

    public int cost() {
        return this.cost;
    }

    public void setCost(int n) {
        this.cost = n;
    }

    public void setProtectionRole(int n) {
        this.role = n;
    }

    public void setPhysicalType(int n) {
        this.phyType = n;
    }

    public void setPhysicalLinkType(int n) {
        this.phyLinkType = n;
    }

    public void setProtectionGroup(int n) {
        this.protGroup = n;
    }

    public void setLinkType(int n) {
        this.ltype = n;
    }

    public void setProtectionType(int n) {
        this.prot = n;
    }

    public int getSrcLinkId() {
        return -1;
    }

    public int getDstLinkId() {
        return -1;
    }

    public int getLinkDir() {
        return 0;
    }

    public void update(Observable observable, Object object) {
    }

    public abstract boolean isOnePlusOneWorkingActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation;

    public abstract boolean isOnePlusOneProtectActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation;

    public abstract short setOnePlusOneForceSwitchToWorking() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError;

    public abstract short setOnePlusOneForceSwitchToProtect() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError;

    public abstract short setOnePlusOneClear() throws InvalidProtectionOp, InternalCommError;

    public abstract boolean isOnePlusOneClear();

    public abstract boolean isOnePlusOneProtectPortIS() throws NoSuchInterface;

    public abstract boolean isOnePlusOneWorkingPortIS() throws NoSuchInterface;

    public abstract int getOnePlusOneSrcWorkingCardEntityIndex();

    public abstract int getOnePlusOneSrcProtectCardEntityIndex();

    public abstract int getOnePlusOneDstWorkingCardEntityIndex();

    public abstract int getOnePlusOneDstProtectCardEntityIndex();

    public boolean isVirtual() {
        return this.ltype == 6;
    }
}

