/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Busy;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.Model;
import cerent.util.SDebug;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Set;

public class AddNode2OnePlusOneModel
extends Model {
    private int MIN_PORTS_REQUIRED = 4;
    private static AddNode2OnePlusOneModel instance = null;
    private static final SDebug db = new SDebug("AddNode2OnePlusOneModel");

    public static final synchronized AddNode2OnePlusOneModel instance() {
        if (instance == null) {
            instance = new AddNode2OnePlusOneModel();
        }
        return instance;
    }

    public void update(Observable observable, Object object) {
    }

    public boolean isNodeValidForUpgrade(INodeModel iNodeModel, ILinkModel iLinkModel) {
        if (!iNodeModel.isInited()) {
            return false;
        }
        List list = this.getAvailablePortsForUpgrade(iNodeModel, iLinkModel);
        return list.size() >= this.MIN_PORTS_REQUIRED;
    }

    public List getAvailablePortsForUpgrade(INodeModel iNodeModel, ILinkModel iLinkModel) {
        try {
            Class[] classArray = new Class[]{IEntityModel.class, ILinkModel.class};
            Method method = AddNode2OnePlusOneModel.class.getMethod("matchedPortList", classArray);
            return iNodeModel.getAvailablePortsForUpgrade(iLinkModel, (Object)this, method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SDebug.printStackTrace((Throwable)noSuchMethodException);
            return new ArrayList();
        }
    }

    public List matchedPortList(IEntityModel iEntityModel, ILinkModel iLinkModel) {
        List list = this.getPortsMatchingLink(iEntityModel, iLinkModel);
        ArrayList<ITdmPortModel> arrayList = new ArrayList<ITdmPortModel>();
        for (int i = 0; i < list.size(); ++i) {
            ITdmPortModel iTdmPortModel = (ITdmPortModel)list.get(i);
            boolean bl = false;
            if (iTdmPortModel.getNodeModel().provides(Feature.TEST_ACCESS)) {
                bl = iTdmPortModel.hasTestAccessPoint();
            }
            if (iTdmPortModel.hasOpticalProtection() || iTdmPortModel.isSonetDccTermination() || bl || iTdmPortModel.getConnectionsList().size() != 0) continue;
            arrayList.add(iTdmPortModel);
        }
        return arrayList;
    }

    private List getPortsMatchingLink(IEntityModel iEntityModel, ILinkModel iLinkModel) {
        int n = iLinkModel.physicalType();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 28;
                break;
            }
            case 1: {
                n2 = 29;
                break;
            }
            case 2: {
                n2 = 30;
                break;
            }
            case 3: {
                n2 = 61;
            }
        }
        List list = iEntityModel.getDescendantsOfEqType(n2);
        return list;
    }

    private boolean isMrcCard(int n) {
        boolean bl = false;
        bl = n == 146 || n == 219 || n == 253 || n == 254;
        return bl;
    }

    public void createDccAndOnePlusOne(INodeModel iNodeModel, boolean bl, IEntityModel iEntityModel, IEntityModel iEntityModel2, String string, IEntityModel iEntityModel3, IEntityModel iEntityModel4, String string2, IRevertiveBehavior iRevertiveBehavior) throws Exception {
        Boolean bl2 = true;
        ITermConnectionModel iTermConnectionModel = bl ? iNodeModel.getLdccTermConnectionModel() : iNodeModel.getDccTermConnectionModel();
        iTermConnectionModel.createTermination(iEntityModel, new Serializable[]{bl2, Boolean.FALSE});
        iTermConnectionModel.createTermination(iEntityModel3, new Serializable[]{bl2, Boolean.FALSE});
        iNodeModel.getIElementModels().createOnePlusOne(iEntityModel.getEntityIndex(), iEntityModel2.getEntityIndex(), iRevertiveBehavior, false, string);
        iNodeModel.getIElementModels().createOnePlusOne(iEntityModel3.getEntityIndex(), iEntityModel4.getEntityIndex(), iRevertiveBehavior, false, string2);
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < 20; ++i) {
            Set set = iNodeModel.getNodeModel().getIElementModels().getOnePlusOneElements();
            for (IOnePlusOneModel iOnePlusOneModel : set) {
                if (iOnePlusOneModel.getWorkingEntityIndex() == iEntityModel.getEntityIndex()) {
                    bl3 = true;
                }
                if (iOnePlusOneModel.getWorkingEntityIndex() != iEntityModel3.getEntityIndex()) continue;
                bl4 = true;
            }
            if (bl3 && bl4) {
                return;
            }
            Thread.sleep(500L);
        }
        this.rollBackDccAndOnePlusOne(iNodeModel, bl, iEntityModel, iEntityModel2, iEntityModel3, iEntityModel4);
        throw new Exception("An error occurred while creating a 1+1 model.");
    }

    public void rollBackDccAndOnePlusOne(INodeModel iNodeModel, boolean bl, IEntityModel iEntityModel, IEntityModel iEntityModel2, IEntityModel iEntityModel3, IEntityModel iEntityModel4) throws Exception {
        ITermConnectionModel iTermConnectionModel = bl ? iNodeModel.getLdccTermConnectionModel() : iNodeModel.getDccTermConnectionModel();
        IOhTermModel iOhTermModel = iTermConnectionModel.getTermModel(iEntityModel.getIndex());
        IOhTermModel iOhTermModel2 = iTermConnectionModel.getTermModel(iEntityModel3.getIndex());
        iTermConnectionModel.deleteTermination(iOhTermModel);
        iTermConnectionModel.deleteTermination(iOhTermModel2);
        Set set = iNodeModel.getIElementModels().getOnePlusOneElements();
        block2: for (IOnePlusOneModel iOnePlusOneModel : set) {
            if (iOnePlusOneModel.getWorkingEntityIndex() != iEntityModel.getEntityIndex() && iOnePlusOneModel.getWorkingEntityIndex() != iEntityModel3.getEntityIndex()) continue;
            int n = 0;
            while (true) {
                try {
                    iOnePlusOneModel.delete();
                    continue block2;
                }
                catch (Busy busy) {
                    if (++n <= 5) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    throw busy;
                }
                break;
            }
        }
        ((IPortModel)iEntityModel).setAdminState(3);
        ((IPortModel)iEntityModel2).setAdminState(3);
        ((IPortModel)iEntityModel3).setAdminState(3);
        ((IPortModel)iEntityModel4).setAdminState(3);
    }

    private AddNode2OnePlusOneModel() {
        super(db);
    }
}

