/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.Busy;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrLimits;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetModelObserver;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.UObservable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;

public class ElementModels
extends NetModelObserver
implements IElementModels,
IObserver {
    public static final int CMN_NAME_LENGTH = 32;
    private IElementModels delegate;
    private INodeModel nm;
    private Set currentBlsrModels;
    private NewBlsrModelNotifier nbmn = new NewBlsrModelNotifier();
    private DeletedBlsrModelNotifier dbmn = new DeletedBlsrModelNotifier();

    public ElementModels(NodeModel nodeModel) {
        super(nodeModel.db.getChildDebug("ElementModels"));
        this.nm = nodeModel;
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    private void destroyDelegate() {
        if (this.db.on()) {
            this.db.println("destroyDelegate");
        }
        ModelIndirectObservable.instance().deleteObserver((IObservable)this.delegate, this);
        this.delegate = null;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        if (this.currentBlsrModels != null) {
            this.deleteBlsrModelObserver(this.currentBlsrModels);
            this.currentBlsrModels = null;
        }
        if (this.delegate != null) {
            this.destroyDelegate();
        }
        super.dispose();
    }

    public INodeModel getNodeModel() {
        return this.nm;
    }

    public Set getBlsrElements() {
        if (this.delegate == null) {
            return new HashSet();
        }
        return this.delegate.getBlsrElements();
    }

    public void createBlsr(IBlsrProvision iBlsrProvision, int n, String string) throws Busy, ProvisionError {
        if (this.delegate.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
            this.delegate.createBlsr(iBlsrProvision, n, string);
        } else {
            try {
                if (iBlsrProvision.getGlobalRingId() < 0 || iBlsrProvision.getGlobalRingId() > 9999) {
                    throw new ProvisionError("The ring ID must be a number between 0 and 9999.");
                }
                this.delegate.createBlsr(iBlsrProvision, n, string);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                SDebug.printStackTrace((Throwable)unsupportedOperation);
            }
        }
    }

    public Set getBlsrAvailableEntities(int n) {
        Set set = new HashSet();
        if (null != this.delegate) {
            try {
                set = this.delegate.getBlsrAvailableEntities(n);
            }
            catch (NullPointerException nullPointerException) {
                this.db.println("NullPointerException caught in ElementModels::getBlsrAvailableEntities()");
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
        return set;
    }

    public IBlsrLimits getBlsrLimits() {
        if (null != this.delegate && this.delegate.getNodeModel().provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
            return this.delegate.getBlsrLimits();
        }
        return new IBlsrLimits(){

            public short getMaxBlsr() {
                if (ElementModels.this.nm.getNeType().startsWith("15600")) {
                    return 16;
                }
                return 2;
            }

            public short getMax4FBlsr() {
                return 1;
            }

            public short getMaxNodesIn2FiberRing() {
                return 32;
            }

            public short getMaxNodesIn4FiberRing() {
                return 32;
            }

            public short getRingNameLength() {
                return 4;
            }
        };
    }

    public void setDelegate(IElementModels iElementModels) {
        boolean bl;
        boolean bl2 = bl = iElementModels != this.delegate;
        if (this.delegate != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.delegate, this);
        }
        this.delegate = iElementModels;
        ModelIndirectObservable.instance().addObserver((IObservable)this.delegate, this);
        this.currentBlsrModels = this.delegate.getBlsrElements();
        this.addBlsrModelObserver(this.currentBlsrModels);
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable == this.delegate || this.delegate != null && this.delegate.equals(iObservable)) {
            if (this.db.on) {
                this.db.println("Sending update Message " + object);
            }
            this.setChanged();
            this.notifyObservers(object);
            this.discoverBlsrChanges();
        }
        if (iObservable instanceof IBlsrModel && object.equals(ModelUpdateType.DELETED)) {
            this.discoverBlsrChanges();
        }
    }

    private synchronized void discoverBlsrChanges() {
        HashSet hashSet = this.delegate.getBlsrElements();
        HashSet hashSet2 = new HashSet(hashSet);
        if ((hashSet.removeAll(this.currentBlsrModels) || this.currentBlsrModels.size() == 0 && hashSet.size() > 0) && hashSet.size() > 0) {
            this.db.fine("Sending update Message -- found " + hashSet.size() + " new BlsrModels!");
            this.nbmn.notifyObservers(hashSet);
            this.addBlsrModelObserver(hashSet);
        }
        if ((this.currentBlsrModels.removeAll(hashSet = hashSet2) || this.currentBlsrModels.size() > 0 && hashSet.size() == 0) && this.currentBlsrModels.size() > 0) {
            this.db.fine("Sending update Message -- " + this.currentBlsrModels.size() + " BlsrModels removed!");
            this.dbmn.notifyObservers(this.currentBlsrModels);
            this.deleteBlsrModelObserver(this.currentBlsrModels);
        }
        this.currentBlsrModels = hashSet;
    }

    private void addBlsrModelObserver(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((IBlsrModel)iterator.next()).addObserver((IObserver)this);
        }
    }

    private void deleteBlsrModelObserver(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ((IBlsrModel)iterator.next()).deleteObserver((IObserver)this);
        }
    }

    public Observable getCreationBlsrNotifier() {
        return this.nbmn;
    }

    public Observable getDeletionBlsrNotifier() {
        return this.dbmn;
    }

    public boolean createOnePlusOne(int n, int n2, IRevertiveBehavior iRevertiveBehavior, boolean bl, String string) {
        return this.delegate.createOnePlusOne(n, n2, iRevertiveBehavior, bl, string);
    }

    public Set getOnePlusOneElements() {
        return this.delegate.getOnePlusOneElements();
    }

    public Set getL2OnePlusOneElements() {
        return this.delegate.getL2OnePlusOneElements();
    }

    public IElementModel getIElementModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getIElementModel(iEntityModel);
    }

    public Set getOnePlusOneCompatibleEntities(IElementModel iElementModel) {
        if (this.delegate == null) {
            return new HashSet();
        }
        return this.delegate.getOnePlusOneCompatibleEntities(iElementModel);
    }

    public static String truncateString(String string, int n) {
        return string.length() <= n ? string : string.substring(0, n);
    }

    public static String truncateString(String string) {
        return ElementModels.truncateString(string, 32);
    }

    private class DeletedBlsrModelNotifier
    extends UObservable {
        private DeletedBlsrModelNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }

    private class NewBlsrModelNotifier
    extends UObservable {
        private NewBlsrModelNotifier() {
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public void notifyObservers() {
        }
    }
}

