/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ui.ExplorerController;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExplorerTreeCard
extends DefaultMutableTreeNode
implements Observer {
    private IEntityModel entityM;
    private String name;
    private ImageIcon icon;
    private SDebug db;
    public String tooltip = null;

    public ExplorerTreeCard(String string, IEntityModel iEntityModel, SDebug sDebug) {
        this.name = string;
        this.entityM = iEntityModel;
        this.setIcon();
        this.icon = this.getIcon();
        this.db = new SDebug((KDebug)sDebug, "ExplorerTreeCard " + string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setModel(IEntityModel iEntityModel) {
        this.entityM = iEntityModel;
    }

    public boolean isLeaf() {
        return true;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon() {
        this.icon = ExplorerController.DEFAULT_CARD_ICON;
    }

    public void update(Observable observable, Object object) {
        block6: {
            try {
                final ExplorerController explorerController = ExplorerController.instance();
                final ExplorerTreeCard explorerTreeCard = this;
                if (object == ModelUpdateType.DELETED && observable instanceof IModuleModel) {
                    final IModuleModel iModuleModel = (IModuleModel)observable;
                    final int n = ((IModuleModel)observable).getSlot();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            explorerTreeCard.setName(n + " - Empty");
                            explorerTreeCard.icon = ExplorerController.DEFAULT_CARD_ICON;
                            explorerController.deleteCard(iModuleModel, explorerTreeCard);
                        }
                    });
                } else if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
                    if (observable instanceof IModuleModel && explorerController.isCardDeleted((IModuleModel)observable)) {
                        IModuleModel iModuleModel = (IModuleModel)observable;
                        int n = iModuleModel.getSlot();
                        explorerTreeCard.setName(n + " - Empty");
                        explorerTreeCard.icon = ExplorerController.DEFAULT_CARD_ICON;
                        explorerController.deleteCard(iModuleModel, explorerTreeCard);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            explorerController.refreshCard(explorerTreeCard);
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
                this.db.fine("Exception caught in ExplorerTreeCard update");
                if (!this.db.on()) break block6;
                SDebug.printStackTrace((Throwable)nullPointerException);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    public IEntityModel getEntityModel() {
        return this.entityM;
    }
}

