/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvEntityModel;
import cerent.cms.fv.net.IFvLinkModel;
import cerent.cms.fv.net.IFvNetNode;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractLinkModel;
import cerent.cms.model.Feature;
import cerent.cms.model.ForceToPrimaryNotAllowed;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.IYCableModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public class LinkModel
extends AbstractLinkModel
implements Observer,
IFvLinkModel {
    public int pcaRevertMode;
    private String blsrRingName;
    private byte blsrNodeId;
    private boolean pollRingId;
    private int srcLinkId;
    private int dstLinkId;
    private int dir;
    private static final String DEFAULT_BLSR_RING_ID = "10101";

    public LinkModel(INodeModel iNodeModel, int n, IHoNum iHoNum, INodeModel iNodeModel2, int n2, IHoNum iHoNum2, int n3, int n4, int n5, boolean bl, boolean bl2, int n6, int n7, int n8, String string, byte by, int n9, int n10, int n11, int n12, int n13) {
        super(iNodeModel, n, iHoNum, iNodeModel2, n2, iHoNum2, n3, n4, n5, bl, bl2, n8, n9, n10, n11);
        this.srcSlotNum = this.calcSlotNum(iNodeModel, n);
        this.dstSlotNum = this.calcSlotNum(iNodeModel2, n2);
        this.pcaRevertMode = n12;
        this.setBlsrRingName(string);
        this.setBlsrNodeId(by);
        this.setLinkIds(n6, n7);
        this.setLinkDir(n13);
    }

    public int blsrRingId() {
        return -1;
    }

    public String blsrRingName() {
        return this.blsrRingName.toUpperCase();
    }

    public byte blsrNodeId() {
        return this.blsrNodeId;
    }

    public int pcaRevertMode() {
        return this.pcaRevertMode;
    }

    public void setBlsrRingName(String string) {
        if (this.prot == 0 || this.prot == 4 || this.prot == 5 || this.prot == 6) {
            if (string.equals("-1") || string.equals(DEFAULT_BLSR_RING_ID)) {
                this.blsrRingName = this.getBlsrRingNameFromNode();
            } else {
                this.blsrRingName = string != null ? string : "";
                this.src.getConnectionNotifier().deleteObserver((Observer)this);
            }
        } else {
            this.blsrRingName = "";
        }
        if (this.db.on()) {
            this.db.println("setBlsrRingName: BLSR ring name set to => " + this.blsrRingName);
        }
    }

    public void setBlsrNodeId(byte by) {
        this.blsrNodeId = by;
    }

    private String getBlsrRingNameFromNode() {
        String string = null;
        if (this.prot == 0 || this.prot == 4 || this.prot == 5 || this.prot == 6) {
            if (this.src.isInited()) {
                IBlsrProvision iBlsrProvision;
                IEntityModel iEntityModel = this.getEndEntityModel(true);
                if (iEntityModel != null && iEntityModel instanceof ITdmPortModel && (iBlsrProvision = ((ITdmPortModel)iEntityModel).getBlsrProvision()) != null) {
                    if (this.src.provides(Feature.BLSR_PATRIOT_EXTENSIONS)) {
                        string = iBlsrProvision.getRingName();
                    } else {
                        try {
                            short s = iBlsrProvision.getGlobalRingId();
                            string = Integer.toString(s);
                        }
                        catch (UnsupportedOperation unsupportedOperation) {
                            this.db.println("getBlsrRingNameFromNode: caught " + (Object)((Object)unsupportedOperation) + " => ");
                            SDebug.printStackTrace((Throwable)unsupportedOperation);
                        }
                    }
                }
            } else {
                if (this.src.getConnectionNotifier() != null) {
                    this.src.getConnectionNotifier().addObserver((Observer)this);
                }
                string = this.blsrRingName;
            }
        }
        return string;
    }

    public short setBlsrForceRing() throws InvalidProtectionOp, InternalCommError {
        if (this.prot != 0 && this.prot != 4) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        try {
            ((IBlsrModel)iElementModel).setForceRing(this.srcEntityIndex);
            ((IBlsrModel)iElementModel2).setForceRing(this.dstEntityIndex);
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            throw internalCommError;
        }
    }

    public short setBlsrForceSpan() throws InvalidProtectionOp, InternalCommError {
        if (this.prot != 0 && this.prot != 4) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        try {
            ((IBlsrModel)iElementModel).setForceSpan(this.srcEntityIndex);
            ((IBlsrModel)iElementModel2).setForceSpan(this.dstEntityIndex);
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            throw internalCommError;
        }
    }

    public short setBlsrClear() throws InvalidProtectionOp, InternalCommError {
        if (this.prot != 0 && this.prot != 4) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        try {
            ((IBlsrModel)iElementModel).setClear(this.srcEntityIndex);
            ((IBlsrModel)iElementModel2).setClear(this.dstEntityIndex);
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            throw internalCommError;
        }
    }

    public int getSrcLinkId() {
        return this.srcLinkId;
    }

    public int getDstLinkId() {
        return this.dstLinkId;
    }

    private void setLinkIds(int n, int n2) {
        this.srcLinkId = n;
        this.dstLinkId = n2;
    }

    public int getLinkDir() {
        return this.dir;
    }

    private void setLinkDir(int n) {
        this.dir = n;
    }

    public boolean isBlsrClear() {
        if (this.prot != 0 && this.prot != 4) {
            return false;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return false;
        }
        return ((IBlsrModel)iElementModel).isClear(this.srcEntityIndex) && ((IBlsrModel)iElementModel2).isClear(this.dstEntityIndex);
    }

    public boolean isOnePlusOneWorkingActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.prot != 1) {
            return false;
        }
        IEntityModel iEntityModel = this.getEndEntityModel(true);
        IEntityModel iEntityModel2 = this.getEndEntityModel(false);
        if (iEntityModel == null || iEntityModel2 == null) {
            return false;
        }
        if (iEntityModel instanceof ITdmPortModel && iEntityModel2 instanceof ITdmPortModel) {
            return ((ITdmPortModel)iEntityModel).isPortActive() && ((ITdmPortModel)iEntityModel2).isPortActive();
        }
        return false;
    }

    public boolean isOnePlusOneProtectActive() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.prot != 1) {
            return false;
        }
        IEntityModel iEntityModel = this.getEntityModel(this.src, this.getOnePlusOneSrcProtectCardEntityIndex());
        IEntityModel iEntityModel2 = this.getEntityModel(this.dst, this.getOnePlusOneDstProtectCardEntityIndex());
        if (iEntityModel == null || iEntityModel2 == null) {
            if (this.db.on()) {
                this.db.println("sem or dem null");
            }
            return false;
        }
        if (iEntityModel instanceof ITdmPortModel && iEntityModel2 instanceof ITdmPortModel) {
            return ((ITdmPortModel)iEntityModel).isPortActive() && ((ITdmPortModel)iEntityModel2).isPortActive();
        }
        if (this.db.on()) {
            this.db.println("default case");
        }
        return false;
    }

    public short setOnePlusOneForceSwitchToWorking() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError {
        if (this.prot != 1) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        boolean bl = false;
        try {
            bl = ((IOnePlusOneModel)iElementModel2).isBidirectional();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return -1;
        }
        try {
            ((IOnePlusOneModel)iElementModel).setForceSwitchToWorking();
            if (!bl) {
                ((IOnePlusOneModel)iElementModel2).setForceSwitchToWorking();
            }
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            throw internalCommError;
        }
    }

    public short setOnePlusOneForceSwitchToProtect() throws InvalidProtectionOp, ForceToPrimaryNotAllowed, InternalCommError {
        if (this.prot != 1) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        boolean bl = false;
        try {
            bl = ((IOnePlusOneModel)iElementModel2).isBidirectional();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return -1;
        }
        try {
            ((IOnePlusOneModel)iElementModel).setForceSwitchToProtect();
            if (!bl) {
                ((IOnePlusOneModel)iElementModel2).setForceSwitchToProtect();
            }
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            throw internalCommError;
        }
    }

    public short setOnePlusOneClear() throws InvalidProtectionOp, InternalCommError {
        if (this.prot != 1) {
            return -1;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return -1;
        }
        boolean bl = false;
        try {
            bl = ((IOnePlusOneModel)iElementModel2).isBidirectional();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return -1;
        }
        try {
            ((IOnePlusOneModel)iElementModel).setClear();
            if (!bl) {
                ((IOnePlusOneModel)iElementModel2).setClear();
            }
            return 1;
        }
        catch (InvalidProtectionOp invalidProtectionOp) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)invalidProtectionOp);
            }
            throw invalidProtectionOp;
        }
        catch (InternalCommError internalCommError) {
            if (this.db.on) {
                SDebug.printStackTrace((Throwable)internalCommError);
            }
            throw internalCommError;
        }
    }

    public boolean isOnePlusOneClear() {
        if (this.prot != 1) {
            return false;
        }
        IElementModel iElementModel = this.getEndElementModel(true);
        IElementModel iElementModel2 = this.getEndElementModel(false);
        if (iElementModel == null || iElementModel2 == null) {
            return false;
        }
        return ((IOnePlusOneModel)iElementModel).isClear() && ((IOnePlusOneModel)iElementModel2).isClear();
    }

    public boolean isBlsrPortIS() throws NoSuchInterface {
        IEntityModel iEntityModel = this.getEndEntityModel(true);
        IEntityModel iEntityModel2 = this.getEndEntityModel(false);
        if (iEntityModel == null || iEntityModel2 == null) {
            return false;
        }
        if (iEntityModel instanceof ITdmPortModel && iEntityModel2 instanceof ITdmPortModel) {
            return this.isPortIS((ITdmPortModel)iEntityModel) && this.isPortIS((ITdmPortModel)iEntityModel2);
        }
        return false;
    }

    public boolean isOnePlusOneProtectPortIS() throws NoSuchInterface {
        IEntityModel iEntityModel = this.getEntityModel(this.src, this.getOnePlusOneSrcProtectCardEntityIndex());
        IEntityModel iEntityModel2 = this.getEntityModel(this.dst, this.getOnePlusOneDstProtectCardEntityIndex());
        if (iEntityModel != null && iEntityModel instanceof ITdmPortModel && iEntityModel2 != null && iEntityModel2 instanceof ITdmPortModel) {
            return this.isPortIS((ITdmPortModel)iEntityModel) && this.isPortIS((ITdmPortModel)iEntityModel2);
        }
        return false;
    }

    public boolean isOnePlusOneWorkingPortIS() throws NoSuchInterface {
        IEntityModel iEntityModel = this.getEntityModel(this.src, this.getOnePlusOneSrcWorkingCardEntityIndex());
        IEntityModel iEntityModel2 = this.getEntityModel(this.dst, this.getOnePlusOneDstWorkingCardEntityIndex());
        if (iEntityModel != null && iEntityModel instanceof ITdmPortModel && iEntityModel2 != null && iEntityModel2 instanceof ITdmPortModel) {
            return this.isPortIS((ITdmPortModel)iEntityModel) && this.isPortIS((ITdmPortModel)iEntityModel2);
        }
        return false;
    }

    public int getOnePlusOneSrcWorkingCardEntityIndex() {
        return this.getOnePlusOneCardEntityIndex(true, true);
    }

    public int getOnePlusOneSrcProtectCardEntityIndex() {
        return this.getOnePlusOneCardEntityIndex(true, false);
    }

    public int getOnePlusOneDstWorkingCardEntityIndex() {
        return this.getOnePlusOneCardEntityIndex(false, true);
    }

    public int getOnePlusOneDstProtectCardEntityIndex() {
        return this.getOnePlusOneCardEntityIndex(false, false);
    }

    private int getOnePlusOneCardEntityIndex(boolean bl, boolean bl2) {
        IElementModel iElementModel = this.getEndElementModel(bl);
        if (iElementModel == null) {
            return -1;
        }
        if (bl2) {
            return ((IOnePlusOneModel)iElementModel).getWorkingEntityIndex();
        }
        return ((IOnePlusOneModel)iElementModel).getProtectEntityIndex();
    }

    public int getYCableWorkingPortEntityIndex() {
        return this.getYCablePortEntityIndex(true);
    }

    public int getYCableProtectPortEntityIndex() {
        return this.getYCablePortEntityIndex(false);
    }

    private int getYCablePortEntityIndex(boolean bl) {
        IElementModel iElementModel = this.getEndElementModel(!this.isXcCapable());
        if (iElementModel == null) {
            return -1;
        }
        if (bl) {
            return ((IYCableModel)iElementModel).getWorkingEntityIndex();
        }
        return ((IYCableModel)iElementModel).getProtectEntityIndex();
    }

    public int get4FBlsrSrcProtectCardEntityIndex() {
        return this.get4FBlsrProtectCardEntityIndex(true);
    }

    public int get4FBlsrDstProtectCardEntityIndex() {
        return this.get4FBlsrProtectCardEntityIndex(false);
    }

    private int get4FBlsrProtectCardEntityIndex(boolean bl) {
        IElementModel iElementModel = this.getEndElementModel(bl);
        if (iElementModel == null) {
            return -1;
        }
        return ((IBlsrModel)iElementModel).getProtectEntityIndex(bl ? this.srcEntityIndex : this.dstEntityIndex);
    }

    public int state() {
        return this.newState();
    }

    public int oldState() {
        return this.oldState;
    }

    public int newState() {
        return this.newState;
    }

    public void oldState(int n) {
        if ((n == 1 || n == 2) && this.oldState != n) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
            this.oldState = n;
        }
    }

    public void newState(int n) {
        if (n == 1 || n == 2) {
            if (this.db.on()) {
                this.db.println("[LinkModel.newState] called");
                if (n == 1) {
                    this.db.println("[LinkModel.newState] LINK_UP");
                } else if (n == 2) {
                    this.db.println("[LinkModel.newState] LINK_DOWN");
                } else {
                    this.db.println("[LinkModel.newState] UNKNOWN STATE");
                }
            }
            this.newState = n;
        }
    }

    public int srcSlotNum() {
        if (this.srcSlotNum == -1) {
            this.srcSlotNum = this.calcSlotNum(this.src, this.srcEntityIndex);
        }
        return this.srcSlotNum;
    }

    public int dstSlotNum() {
        if (this.dstSlotNum == -1) {
            this.dstSlotNum = this.calcSlotNum(this.dst, this.dstEntityIndex);
        }
        return this.dstSlotNum;
    }

    private boolean isPortIS(ITdmPortModel iTdmPortModel) throws NoSuchInterface {
        if (Feature.provides((INodeModel)iTdmPortModel.getNodeModel(), (Feature)Feature.ENHANCED_STATE_MODEL)) {
            return iTdmPortModel.getAdminState() != 1;
        }
        if (Feature.provides((INodeModel)iTdmPortModel.getNodeModel(), (Feature)Feature.SPAN_UPGRADE)) {
            return iTdmPortModel.isPortIS();
        }
        throw new NoSuchInterface("No interface is available to retrieve the port state.");
    }

    public IElementModel getEndElementModel(boolean bl) {
        block8: {
            IEntityModel iEntityModel = this.getEndEntityModel(bl);
            if (iEntityModel != null) {
                if (iEntityModel instanceof ITdmPortModel) {
                    try {
                        return ((ITdmPortModel)iEntityModel).getElementModel();
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        if (this.db.on()) {
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                        }
                        break block8;
                    }
                }
                if (iEntityModel instanceof IDwdmPortModel) {
                    try {
                        return ((IDwdmPortModel)iEntityModel).getElementModel();
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        if (!this.db.on()) break block8;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    }
                }
            }
        }
        return null;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof INodeModel.AbstractConnectionNotifier && object == ModelUpdateType.CHANGED) {
            if (this.db.on()) {
                this.db.println("update: received CHANGED update event");
            }
            this.setBlsrRingName(this.getBlsrRingNameFromNode());
        }
    }

    public IFvNetNode destination() {
        return (NodeModel)this.dst();
    }

    public IFvNetNode source() {
        return (NodeModel)this.src();
    }

    public IFvEntityModel getTheEndEntityModel(boolean bl) {
        return this.getEndEntityModel(bl);
    }

    public int getDstEntityIndex() {
        return this.dstEntityIndex();
    }
}

