/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IfModelReflectionUtil;
import cerent.cms.model.IfModelTypeSignature;
import cerent.util.ConcurrentReaderMap;
import cerent.util.KDebug;
import cerent.util.ReflectionUtil;
import cerent.util.SDebug;
import java.util.Iterator;

public class ModelTypeSignatureMap {
    private ConcurrentReaderMap type2Signature = new ConcurrentReaderMap();
    private ConcurrentReaderMap signature2Type = new ConcurrentReaderMap();
    protected static SDebug db = new SDebug("ModelTypeSignatureMap");

    public void register(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interfaces cannot be registered.  You can only register concrete classes.");
        }
        if (this.type2Signature.get((Object)clazz) != null) {
            return;
        }
        Class[] classArray = IfModelReflectionUtil.superModels((Class)clazz);
        if (db.isFinestEnabled()) {
            this.dbg("registering cls: ", clazz, classArray);
        }
        IfModelTypeSignature ifModelTypeSignature = IfModelTypeSignature.createSignature((Class[])classArray);
        this.register(clazz, ifModelTypeSignature);
    }

    private void dbg(String string, Class clazz, Class[] classArray) {
        db.print(string + clazz.getName() + ": ");
        int n = classArray == null ? 0 : classArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Class clazz2 = classArray[i];
            if (clazz2 == null) continue;
            if (bl) {
                db.print(", ");
            }
            db.print(clazz2.getName());
            bl = true;
        }
        db.println("");
    }

    public void register(Class clazz, IfModelTypeSignature ifModelTypeSignature) {
        this.putType2SignatureWithDupCheck(clazz, ifModelTypeSignature);
    }

    private synchronized void putType2SignatureWithDupCheck(Class clazz, IfModelTypeSignature ifModelTypeSignature) {
        if (this.type2Signature.get((Object)clazz) == null) {
            this.putType2Signature(clazz, this.registerWithDupCheck(clazz, ifModelTypeSignature));
        }
    }

    private void putType2Signature(Class clazz, IfModelTypeSignature ifModelTypeSignature) {
        if (clazz == null) {
            return;
        }
        if (ifModelTypeSignature != null) {
            this.type2Signature.put((Object)clazz, (Object)ifModelTypeSignature);
            if (db.isFinestEnabled()) {
                db.finest("type 2 sign registered: " + clazz.getName() + " -> " + ifModelTypeSignature);
            }
        } else {
            this.type2Signature.put((Object)clazz, (Object)clazz);
        }
    }

    private IfModelTypeSignature registerWithDupCheck(Class clazz, IfModelTypeSignature ifModelTypeSignature) {
        if (db.isFinestEnabled()) {
            db.finest("registerWithDupCheck(" + (clazz == null ? "null" : clazz.getName()) + ", " + ifModelTypeSignature + ")");
        }
        if (clazz == null) {
            return null;
        }
        if (ReflectionUtil.isAbstractClass((Class)clazz)) {
            return null;
        }
        if (ifModelTypeSignature == null) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)new NullPointerException());
            }
            return null;
        }
        if (ifModelTypeSignature.getCardinality() == 0) {
            return null;
        }
        Class clazz2 = (Class)this.signature2Type.put((Object)ifModelTypeSignature, (Object)clazz);
        if (clazz2 != null && !clazz2.equals(ifModelTypeSignature)) {
            IfModelTypeSignature ifModelTypeSignature2 = (IfModelTypeSignature)this.type2Signature.get((Object)clazz2);
            String string = clazz.getName();
            if (db.on()) {
                db.println("warning: found existing object: " + clazz2 + " in map when registering: " + string);
            }
            this.signature2Type.put((Object)ifModelTypeSignature, (Object)clazz2);
            Class clazz3 = ifModelTypeSignature.getDupClass();
            if (clazz3 == null) {
                ifModelTypeSignature = IfModelTypeSignature.dupSignature((IfModelTypeSignature)ifModelTypeSignature, (Class)clazz);
                if (db.isFinestEnabled()) {
                    db.finest("...duping signature: " + ifModelTypeSignature + " with dup class: " + clazz.getName());
                }
                Class clazz4 = (Class)this.signature2Type.put((Object)ifModelTypeSignature, (Object)clazz);
                if (db.on()) {
                    if (clazz4 != null) {
                        db.print("failed ");
                    }
                    db.println("adding dup support for " + string + " since " + clazz2.getName() + " aren't ancestors of each other. Duplicate signature (" + ifModelTypeSignature + "/" + ifModelTypeSignature2 + ") registration has been 'duped'");
                }
            } else {
                throw new IllegalArgumentException("Neither " + string + " nor " + clazz2.getName() + " are ancestors of each other. The duplicate signature (" + ifModelTypeSignature + "/" + ifModelTypeSignature2 + ") registration cannot be performed.");
            }
        }
        if (db.isFinestEnabled()) {
            db.finest("registered: " + ifModelTypeSignature + " for cls: " + clazz);
        }
        return ifModelTypeSignature;
    }

    public Class get(IfModelTypeSignature ifModelTypeSignature) {
        return (Class)this.signature2Type.get((Object)ifModelTypeSignature);
    }

    public IfModelTypeSignature get(Class clazz) {
        Object object = this.type2Signature.get((Object)clazz);
        if (object instanceof IfModelTypeSignature) {
            return (IfModelTypeSignature)object;
        }
        return null;
    }

    public void dump(KDebug kDebug) {
        Iterator iterator = this.type2Signature.keySet().iterator();
        kDebug.println("ModelTypeSignatureMap dump for: " + ModelTypeSignatureMap.class.getClassLoader());
        kDebug.println("ModelTypeSignatureMap of total size: " + this.type2Signature.size());
        int n = 0;
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Object object = this.type2Signature.get((Object)clazz);
            if (object instanceof Class) continue;
            kDebug.println("  " + n + " " + clazz.getName() + " : " + object);
            ++n;
        }
        kDebug.println("ModelTypeSignatureMap of legit sign size: " + n);
    }
}

