/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.DetailedLog;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.EventBusServices;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class NetworkConsistencyChecker
implements IJobGroupListener {
    private JobGroup networkConsistencyJobGroup = null;
    private JobController networkConsistencyJobController = null;
    private static NetworkConsistencyChecker instance;
    private SendPDIPConsistencyHelper sendPDIPConsistencyHelper = null;
    private static final SDebug db;

    public static synchronized NetworkConsistencyChecker instance() {
        if (instance == null) {
            instance = new NetworkConsistencyChecker();
        }
        return instance;
    }

    public synchronized void checkSendPDIPConsistency(String string, boolean bl) {
        if (this.sendPDIPConsistencyHelper == null) {
            this.sendPDIPConsistencyHelper = new SendPDIPConsistencyHelper();
        }
        this.sendPDIPConsistencyHelper.toBeChecked(string, bl);
        this.startNetworkConsistencyCheck(this.sendPDIPConsistencyHelper);
    }

    public void jobGroupFinished(JobGroup jobGroup) {
        db.fine("jobGroupFinished(): " + jobGroup);
        if (jobGroup.equals(this.networkConsistencyJobGroup)) {
            this.handleNetworkConsistencyJobGroupFinished(jobGroup);
        } else {
            db.info("Unknown type of job group finished");
        }
    }

    private NetworkConsistencyChecker() {
    }

    private void startNetworkConsistencyCheck(INetworkConsistencyHelper iNetworkConsistencyHelper) {
        int n = 1;
        if (this.networkConsistencyJobController == null) {
            this.networkConsistencyJobController = JobControllerFactory.createJC((int)n);
        }
        IJobControl[] iJobControlArray = new IJobControl[n];
        for (int i = 0; i < n; ++i) {
            iJobControlArray[i] = new NetworkConsistencyWorker(iNetworkConsistencyHelper);
        }
        this.networkConsistencyJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
        this.networkConsistencyJobController.submitJob(this.networkConsistencyJobGroup);
    }

    private void handleNetworkConsistencyJobGroupFinished(JobGroup jobGroup) {
        JobStatus[] jobStatusArray;
        int n = 0;
        if (jobGroup != null && (jobStatusArray = jobGroup.getJobStatusList()) != null) {
            n = jobStatusArray.length;
        }
        db.fine("handleNetworkConsistencyJobGroupFinished(): " + n);
    }

    private void postStatusLogEntry(DetailedLog detailedLog) {
        if (detailedLog != null) {
            detailedLog.updateTime();
            EventBus.instance().notifyEvent((Object)EventBusServices.BG_STATUS_COLLECTOR, (Object)detailedLog);
        }
    }

    static {
        db = new SDebug("NetworkConsistencyChecker");
    }

    private class SendPDIPConsistencyHelper
    implements INetworkConsistencyHelper {
        private String controlName = null;
        private boolean controlSendPDIP = false;
        private String nodeName = null;
        private boolean sendPDIP = false;
        private HashMap sendPDIPLastValueCache = new HashMap();
        private HashMap sendPDIPStatusLog = null;

        SendPDIPConsistencyHelper() {
        }

        public void toBeChecked(String string, boolean bl) {
            this.nodeName = string;
            this.sendPDIP = bl;
        }

        public void checkConsistencyNow() {
            if (this.controlName == null) {
                this.setControlNode();
            }
            if (this.sendPDIPStatusLogNeedsUpdate(this.nodeName, this.sendPDIP)) {
                this.updateSendPDIPStatusLog(this.nodeName, this.sendPDIP);
            }
        }

        private synchronized void setControlNode() {
            Collection collection = Network.instance().getAllElements();
            Iterator iterator = collection.iterator();
            String string = null;
            String string2 = null;
            int n = 0;
            int n2 = 0;
            db.info("getControlNode(): over " + collection.size() + " nodes");
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                INodeModel iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel instanceof NodeModel && iNodeModel.isInited() && iNodeModel.provides(Feature.SEND_PDIP)) {
                    if (iNodeModel.getSendPDIP()) {
                        ++n;
                        if (string != null) continue;
                        string = iNodeModel.getName();
                        continue;
                    }
                    ++n2;
                    if (string2 != null) continue;
                    string2 = iNodeModel.getName();
                    continue;
                }
                if (iNodeModel != null) {
                    db.fine("setControlNode(): skipping " + iNodeModel.getName() + " of class " + iNodeModel.getClass().getName());
                    continue;
                }
                db.fine("setControlNode(): skipping null nodeModel");
            }
            if (n > n2) {
                this.controlName = string;
                this.controlSendPDIP = true;
            } else {
                this.controlName = string2;
                this.controlSendPDIP = false;
            }
        }

        private String buildCtcControlSendPDIPDescription(String string, boolean bl) {
            return "Send PDIP control node " + string + " has Send PDIP " + (bl ? "enabled" : "disabled");
        }

        private void ensureAccurateSendPDIPStatusLogExists(String string, boolean bl) {
            DetailedLog detailedLog = null;
            String string2 = this.buildCtcControlSendPDIPDescription(string, bl);
            if (this.sendPDIPStatusLog == null) {
                this.sendPDIPStatusLog = new HashMap();
                detailedLog = new DetailedLog(1, string2);
                this.sendPDIPStatusLog.put(string, detailedLog);
            } else {
                detailedLog = (DetailedLog)this.sendPDIPStatusLog.get(string);
                detailedLog.setDesc(string2);
            }
            NetworkConsistencyChecker.this.postStatusLogEntry(detailedLog);
        }

        private DetailedLog makeChildLogEntry(String string, String string2) {
            DetailedLog detailedLog = new DetailedLog(3);
            this.sendPDIPStatusLog.put(string2, detailedLog);
            DetailedLog detailedLog2 = (DetailedLog)this.sendPDIPStatusLog.get(string);
            if (detailedLog2 != null) {
                detailedLog2.addChild(detailedLog);
            } else {
                db.severe("makeChildLogEntry(): Missing control entry!");
            }
            return detailedLog;
        }

        private void processSendPDIPComparison(String string, boolean bl, String string2, boolean bl2) {
            DetailedLog detailedLog = null;
            if (this.sendPDIPStatusLog != null) {
                this.ensureAccurateSendPDIPStatusLogExists(string, bl);
                detailedLog = (DetailedLog)this.sendPDIPStatusLog.get(string2);
            }
            if (bl == bl2) {
                if (detailedLog != null) {
                    db.fine("Reporting consistency on " + string2);
                    String string3 = "Send PDIP value on " + string2 + " is now consistent with that on control node " + string;
                    detailedLog.setDesc(string3);
                    detailedLog.setType(1);
                    detailedLog.updateTime();
                    DetailedLog detailedLog2 = (DetailedLog)this.sendPDIPStatusLog.get(string);
                    NetworkConsistencyChecker.this.postStatusLogEntry(detailedLog2);
                } else {
                    db.fine("Nothing to report on " + string2);
                }
            } else {
                db.fine("Reporting inconsistency on " + string2);
                this.ensureAccurateSendPDIPStatusLogExists(string, bl);
                if (detailedLog == null) {
                    detailedLog = this.makeChildLogEntry(string, string2);
                }
                String string4 = ErrorMsg.getString((EID)NEMC.EID_SEND_PDIP_INCONSISTENT_WITH_CONTROL_PARAM_2, (Object)string2, (Object)string);
                detailedLog.setDesc(string4);
                detailedLog.setType(3);
                detailedLog.updateTime();
                DetailedLog detailedLog3 = (DetailedLog)this.sendPDIPStatusLog.get(string);
                NetworkConsistencyChecker.this.postStatusLogEntry(detailedLog3);
            }
        }

        private void processControlSendPDIPNotification(String string, boolean bl) {
            Collection collection = Network.instance().getAllElements();
            Iterator iterator = collection.iterator();
            db.info("processControlSendPDIPNotification(): controlSendPDIP: " + bl + " over " + (collection.size() - 1) + " other nodes");
            while (iterator.hasNext()) {
                INetElement iNetElement = (INetElement)iterator.next();
                INodeModel iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel instanceof NodeModel && iNodeModel.isInited() && iNodeModel.provides(Feature.SEND_PDIP) && !iNodeModel.getName().equals(string)) {
                    this.processSendPDIPComparison(string, bl, iNodeModel.getName(), iNodeModel.getSendPDIP());
                    continue;
                }
                if (iNodeModel != null) {
                    db.fine("processControlSendPDIPNotification(): skipping " + iNodeModel.getName() + " of class " + iNodeModel.getClass().getName());
                    continue;
                }
                db.fine("processControlSendPDIPNotification(): skipping null nodeModel");
            }
        }

        private boolean sendPDIPStatusLogNeedsUpdate(String string, boolean bl) {
            boolean bl2 = false;
            Boolean bl3 = this.sendPDIPLastValueCache.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
            if (bl3 == null) {
                db.fine("sendPDIPStatusLogNeedsUpdate(): true for " + string + " (null lastSendPDIP)");
                bl2 = true;
            } else if (bl3 != bl) {
                bl2 = true;
                db.fine("sendPDIPStatusLogNeedsUpdate(): true for " + string);
                if (string.equals(this.controlName)) {
                    db.fine("sendPDIPStatusLogNeedsUpdate(): clearing cache for " + string);
                    this.sendPDIPLastValueCache.clear();
                    this.sendPDIPLastValueCache.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
                }
            } else {
                db.fine("sendPDIPStatusLogNeedsUpdate(): no update needed on " + string + " " + bl);
            }
            return bl2;
        }

        private void updateSendPDIPStatusLog(String string, boolean bl) {
            db.fine("updateSendPDIPStatusLog():" + string + " " + bl);
            if (string.equals(this.controlName)) {
                this.controlSendPDIP = bl;
                this.processControlSendPDIPNotification(this.controlName, this.controlSendPDIP);
            } else {
                this.processSendPDIPComparison(this.controlName, this.controlSendPDIP, string, bl);
            }
        }
    }

    private class NetworkConsistencyWorker
    implements IJobControl {
        INetworkConsistencyHelper inch;

        public NetworkConsistencyWorker(INetworkConsistencyHelper iNetworkConsistencyHelper) {
            this.inch = iNetworkConsistencyHelper;
        }

        public JobStatus executeJob() throws Exception {
            this.inch.checkConsistencyNow();
            return new JobStatus(4);
        }

        public void abortJob() {
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static interface INetworkConsistencyHelper {
        public void checkConsistencyNow();
    }
}

