/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.IPortModel;
import cerent.util.PathTraceUtil;

public class PathTraceInfo {
    public static final int UNDEFINED_NA = -1;
    private int circuitTypeCategory;
    private IPortModel port;
    private char[] expectedString;
    private char[] receivedString;
    private char c2Byte;
    private int mode;
    private int startingNum;
    private boolean isBlsrSwitched;
    private int vcatMemberNum = 0;
    private int framingType = 0;

    public PathTraceInfo(int n, IPortModel iPortModel, char[] cArray, char[] cArray2, char c, int n2, int n3) {
        this.circuitTypeCategory = n;
        this.port = iPortModel;
        this.expectedString = cArray;
        this.receivedString = cArray2;
        this.c2Byte = c;
        this.mode = n2;
        this.startingNum = n3;
        this.isBlsrSwitched = false;
    }

    public PathTraceInfo(int n, IPortModel iPortModel, char[] cArray, char[] cArray2, char c, int n2, int n3, int n4) {
        this.circuitTypeCategory = n;
        this.port = iPortModel;
        this.expectedString = cArray;
        this.receivedString = cArray2;
        this.c2Byte = c;
        this.mode = n2;
        this.startingNum = n3;
        this.framingType = n4;
        this.isBlsrSwitched = false;
    }

    public void setBlsrSwitched(boolean bl) {
        this.isBlsrSwitched = bl;
    }

    public int getCircuitTypeCategory() {
        return this.circuitTypeCategory;
    }

    public IPortModel getPort() {
        return this.port;
    }

    public char[] getExpectedString() {
        return this.expectedString;
    }

    public char[] getReceivedString() {
        return this.receivedString;
    }

    public byte[] getExpectedStringAsByteArray() {
        if (this.expectedString == null) {
            return null;
        }
        return new String(this.expectedString).getBytes();
    }

    public byte[] getReceivedStringAsByteArray() {
        if (this.receivedString == null) {
            return null;
        }
        return new String(this.receivedString).getBytes();
    }

    public char getC2Byte() {
        return this.c2Byte;
    }

    public int getPathTraceMode() {
        return this.mode;
    }

    public int getStartingNum() {
        return this.startingNum;
    }

    public boolean isBlsrSwitched() {
        return this.isBlsrSwitched;
    }

    public String getC2ByteHexFormat() {
        return PathTraceUtil.hexFromByte(this.c2Byte);
    }

    public int getVcatMemberNum() {
        return this.vcatMemberNum;
    }

    public void setVcatMemberNum(int n) {
        this.vcatMemberNum = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Port = " + this.port);
        stringBuffer.append("\nExp = " + (this.expectedString != null ? String.valueOf(this.expectedString) : "NULL"));
        stringBuffer.append("\nRec = " + (this.receivedString != null ? String.valueOf(this.receivedString) : "NULL"));
        stringBuffer.append("\nC2  = " + this.getC2ByteHexFormat());
        stringBuffer.append("\nMode = " + this.mode);
        stringBuffer.append("\nIs BLSR Switched = " + this.isBlsrSwitched);
        stringBuffer.append("\nVCAT Member Num = " + this.vcatMemberNum + "\n");
        return stringBuffer.toString();
    }

    public int getFramingType() {
        return this.framingType;
    }
}

