/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.HoServerTrailModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.IServerTrailsManager;
import cerent.cms.model.LoServerTrailModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ServerTrailModel;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class ServerTrailsDirector
extends Model
implements Observer {
    private ServerTrailEndComparator steComparator = new ServerTrailEndComparator();
    private List<INodeModel> nodes = new ArrayList<INodeModel>();
    private static final Network network = Network.instance();
    protected ServerTrailsDirectorDebug sdb = new ServerTrailsDirectorDebug();
    private static ServerTrailsDirector instance = null;
    private static final SDebug db = new SDebug("ServerTrailsDirector");

    public static final synchronized ServerTrailsDirector instance() {
        if (instance == null) {
            instance = new ServerTrailsDirector();
        }
        return instance;
    }

    private ServerTrailsDirector() {
        super(db);
        this.updateNodeTable();
        Network.instance().getNetElementCreationNotifier().addObserver(this);
    }

    public IServerTrailEnd[] getServerTrails(INodeModel iNodeModel) {
        try {
            return iNodeModel.getServerTrailsManager().getServerTrails();
        }
        catch (Exception exception) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        db.fine("update from " + observable + " regarding " + object);
        if (observable instanceof Network.NetElementCreationNotifier) {
            INetElement iNetElement;
            INodeModel iNodeModel;
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier;
            if (object instanceof INetElement && (abstractConnectionNotifier = (iNodeModel = (iNetElement = (INetElement)object).getNodeModel()).getConnectionNotifier()) != null) {
                abstractConnectionNotifier.addObserver(this);
            }
        } else if (observable instanceof NodeModel.ConnectionNotifier) {
            NodeModel.ConnectionNotifier connectionNotifier = (NodeModel.ConnectionNotifier)((Object)observable);
            NodeModel nodeModel = connectionNotifier.getNodeModel();
            if (object == ModelUpdateType.DELETED) {
                this.deregisterNode(nodeModel, connectionNotifier);
            } else if (!this.registerNode(nodeModel)) {
                this.deregisterNode(nodeModel);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        } else if (observable instanceof IServerTrailsManager) {
            this.setChanged();
            this.notifyObservers(object);
        }
    }

    private void updateNodeTable() {
        for (INetElement iNetElement : Network.instance().getElements()) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = iNodeModel.getConnectionNotifier();
            if (abstractConnectionNotifier != null) {
                abstractConnectionNotifier.addObserver(this);
            }
            this.registerNode(iNodeModel);
        }
    }

    public synchronized ServerTrailModel getTrailModelById(IServerTrailLinkId iServerTrailLinkId) {
        ServerTrailModel serverTrailModel = null;
        Set set = this.getServerTrails();
        for (ServerTrailModel serverTrailModel2 : set) {
            if (!serverTrailModel2.getServerTrailLinkId().equals(iServerTrailLinkId)) continue;
            serverTrailModel = serverTrailModel2;
            break;
        }
        return serverTrailModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set getServerTrails() {
        TreeSet<IServerTrailEnd> treeSet = new TreeSet<IServerTrailEnd>(this.steComparator);
        List<INodeModel> list = this.nodes;
        synchronized (list) {
            for (INodeModel iNodeModel : this.nodes) {
                IServerTrailEnd[] iServerTrailEndArray = this.getServerTrails(iNodeModel);
                if (iServerTrailEndArray == null) continue;
                db.fine(iNodeModel.getName() + " returned " + iServerTrailEndArray.length + " strails.");
                treeSet.addAll(Arrays.asList(iServerTrailEndArray));
            }
        }
        return this.combineSTrailFragments(treeSet);
    }

    private Set combineSTrailFragments(TreeSet treeSet) {
        Iterator iterator;
        TreeSet<ServerTrailModel> treeSet2 = new TreeSet<ServerTrailModel>();
        if (db.on()) {
            db.println("combineSTrailFragments ---- BEFORE (" + treeSet.size() + ") ----");
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                db.println("  " + (IServerTrailEnd)iterator.next());
            }
            db.println("combineSTrailFragements ^^^^ BEFORE ^^^^");
        }
        while (treeSet.size() > 0) {
            boolean bl = false;
            IServerTrailEnd iServerTrailEnd = (IServerTrailEnd)treeSet.first();
            if (!treeSet.remove(iServerTrailEnd)) {
                db.warning("***** ERROR removing " + iServerTrailEnd + " from set! *****");
            }
            Iterator iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                IServerTrailEnd iServerTrailEnd2 = (IServerTrailEnd)iterator2.next();
                if (!iServerTrailEnd.getServerTrailLinkId().equals(iServerTrailEnd2.getServerTrailLinkId())) continue;
                iterator2.remove();
                treeSet2.add(this.combineSTrails(iServerTrailEnd, iServerTrailEnd2));
                bl = true;
                break;
            }
            if (bl) continue;
            if (db.on()) {
                db.println("Couldn't find partner for " + iServerTrailEnd);
            }
            treeSet2.add(this.combinePartialSTrails(iServerTrailEnd));
        }
        if (db.on()) {
            db.println("combineStrailFragements ---- AFTER (" + treeSet2.size() + ") ----");
            iterator = treeSet2.iterator();
            while (iterator.hasNext()) {
                db.println("  " + (ServerTrailModel)iterator.next());
            }
            db.println("combineStrailFragements ^^^^ AFTER ^^^^");
        }
        return treeSet2;
    }

    private ServerTrailModel combineSTrails(IServerTrailEnd iServerTrailEnd, IServerTrailEnd iServerTrailEnd2) {
        IServerTrailEnd iServerTrailEnd3 = null;
        IServerTrailEnd iServerTrailEnd4 = null;
        if (iServerTrailEnd.isSource()) {
            iServerTrailEnd3 = iServerTrailEnd;
            iServerTrailEnd4 = iServerTrailEnd2;
        } else {
            iServerTrailEnd3 = iServerTrailEnd2;
            iServerTrailEnd4 = iServerTrailEnd;
        }
        if (db.on()) {
            db.println(" combining " + iServerTrailEnd3);
            db.println("       and " + iServerTrailEnd4);
        }
        if (iServerTrailEnd3 instanceof IHoServerTrailEnd) {
            IHoServerTrailEnd iHoServerTrailEnd = (IHoServerTrailEnd)iServerTrailEnd3;
            IHoServerTrailEnd iHoServerTrailEnd2 = (IHoServerTrailEnd)iServerTrailEnd4;
            return new HoServerTrailModel(iHoServerTrailEnd, iHoServerTrailEnd2);
        }
        ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd3;
        ILoServerTrailEnd iLoServerTrailEnd2 = (ILoServerTrailEnd)iServerTrailEnd4;
        return new LoServerTrailModel(iLoServerTrailEnd, iLoServerTrailEnd2);
    }

    private ServerTrailModel combinePartialSTrails(IServerTrailEnd iServerTrailEnd) {
        IServerTrailEnd iServerTrailEnd2 = null;
        IServerTrailEnd iServerTrailEnd3 = null;
        if (iServerTrailEnd.isSource()) {
            iServerTrailEnd2 = iServerTrailEnd;
        } else {
            iServerTrailEnd3 = iServerTrailEnd;
        }
        if (iServerTrailEnd instanceof IHoServerTrailEnd) {
            IHoServerTrailEnd iHoServerTrailEnd = null;
            IHoServerTrailEnd iHoServerTrailEnd2 = null;
            if (iServerTrailEnd2 != null) {
                iHoServerTrailEnd = (IHoServerTrailEnd)iServerTrailEnd2;
            }
            if (iServerTrailEnd3 != null) {
                iHoServerTrailEnd2 = (IHoServerTrailEnd)iServerTrailEnd3;
            }
            return new HoServerTrailModel(iHoServerTrailEnd, iHoServerTrailEnd2);
        }
        ILoServerTrailEnd iLoServerTrailEnd = null;
        ILoServerTrailEnd iLoServerTrailEnd2 = null;
        if (iServerTrailEnd2 != null) {
            iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd2;
        }
        if (iServerTrailEnd3 != null) {
            iLoServerTrailEnd2 = (ILoServerTrailEnd)iServerTrailEnd3;
        }
        return new LoServerTrailModel(iLoServerTrailEnd, iLoServerTrailEnd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerNode(INodeModel iNodeModel) {
        boolean bl;
        block7: {
            db.fine("registerNode(" + iNodeModel + ")");
            bl = false;
            try {
                if (!iNodeModel.isInited() || !iNodeModel.provides(Feature.SERVER_TRAIL)) break block7;
                bl = true;
                List<INodeModel> list = this.nodes;
                synchronized (list) {
                    if (!this.nodes.contains(iNodeModel)) {
                        this.nodes.add(iNodeModel);
                        iNodeModel.getServerTrailsManager().addObserver((Observer)this);
                    }
                }
            }
            catch (FeatureNotSupported featureNotSupported) {
                db.println(iNodeModel.getName() + " does not support server trails.");
                SDebug.printStackTrace((Throwable)featureNotSupported);
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                db.println(iNodeModel.getName() + " is not connected.");
                SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterNode(INodeModel iNodeModel) {
        List<INodeModel> list = this.nodes;
        synchronized (list) {
            this.nodes.remove(iNodeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterNode(INodeModel iNodeModel, INodeModel.AbstractConnectionNotifier abstractConnectionNotifier) {
        db.fine("deregisterNode(" + iNodeModel + ")");
        List<INodeModel> list = this.nodes;
        synchronized (list) {
            block5: {
                abstractConnectionNotifier.deleteObserver((Observer)this);
                try {
                    iNodeModel.getServerTrailsManager().deleteObserver((Observer)this);
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    if (!db.isFineEnabled()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsCommFailException);
                }
            }
            this.nodes.remove(iNodeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INodeModel[] getKnownNodes() {
        TreeSet<INodeModel> treeSet = new TreeSet<INodeModel>(new NodeComparator());
        Object object = this.nodes;
        synchronized (object) {
            treeSet.addAll(this.nodes);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            if (((INodeModel)object.next()).isInited()) continue;
            object.remove();
        }
        return treeSet.toArray(new INodeModel[treeSet.size()]);
    }

    public static final String ipToString(IIpAddr iIpAddr) {
        byte[] byArray = iIpAddr.getAddr();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            if (bl && byArray[i] == 0) continue;
            bl = false;
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
            if (i + 1 >= byArray.length) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    public class ServerTrailsDirectorDebug
    extends SDebug {
        public ServerTrailsDirectorDebug() {
            super("ServerTrailsDirector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (ServerTrailsDirector.this.nodes != null) {
                List list = ServerTrailsDirector.this.nodes;
                synchronized (list) {
                    Iterator iterator = ServerTrailsDirector.this.nodes.iterator();
                    int n = 1;
                    while (iterator.hasNext()) {
                        INodeModel iNodeModel = (INodeModel)iterator.next();
                        byte[] byArray = null;
                        try {
                            if (iNodeModel.isInited()) {
                                byArray = iNodeModel.getIpConfig().getIpAddress().getAddr();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (byArray != null) {
                            db.println("Node [" + n + "] " + iNodeModel + " ( " + byArray[12] + "." + byArray[13] + "." + byArray[14] + "." + byArray[15] + " ) ");
                        } else {
                            db.println("Node [" + n + "] " + iNodeModel);
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public class NodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof INodeModel) {
                if (object2 instanceof INodeModel) {
                    INodeModel iNodeModel = (INodeModel)object;
                    INodeModel iNodeModel2 = (INodeModel)object2;
                    try {
                        IIpAddr iIpAddr = iNodeModel.getIpConfig().getIpAddress();
                        IIpAddr iIpAddr2 = iNodeModel2.getIpConfig().getIpAddress();
                        if (iIpAddr != null && iIpAddr2 != null) {
                            try {
                                return iIpAddr.compareTo((Object)iIpAddr2);
                            }
                            catch (ClassCastException classCastException) {
                                return -iIpAddr2.compareTo((Object)iIpAddr);
                            }
                        }
                        if (iIpAddr != null) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                        if (iNodeModel == iNodeModel2) {
                            return 0;
                        }
                        return 1;
                    }
                }
                return 1;
            }
            return -1;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof NodeComparator) {
                NodeComparator nodeComparator = (NodeComparator)object;
                bl = nodeComparator == this;
            }
            return bl;
        }
    }

    public class ServerTrailEndComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IServerTrailEnd iServerTrailEnd = (IServerTrailEnd)object;
            IServerTrailEnd iServerTrailEnd2 = (IServerTrailEnd)object2;
            if (iServerTrailEnd.getNodeModel().getName().compareTo(iServerTrailEnd2.getNodeModel().getName()) == 0) {
                return iServerTrailEnd.getServerTrailLinkId().compareTo((Object)iServerTrailEnd2.getServerTrailLinkId());
            }
            return iServerTrailEnd.getNodeModel().getName().compareTo(iServerTrailEnd2.getNodeModel().getName());
        }
    }
}

