/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IDwdmTrkLineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOptLinkModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IXPL2ModuleModel;
import cerent.cms.model.IXPLLayer2LineModel;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.List;

public class SvlanCircuitHelper {
    private static final SDebug db = new SDebug("SvlanCircuitHelper");

    public static IXPLLayer2LineModel getL2Interface(INodeModel iNodeModel, int n) throws AbstractCmsNoSuchEntityException {
        IXPLLayer2LineModel iXPLLayer2LineModel = null;
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        IPortModel iPortModel = null;
        if (iEntityTableModel != null) {
            iPortModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
            if (iNodeModel.provides(Feature.SVLAN_CKT)) {
                IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                IInterfaceModel[] iInterfaceModelArray = iInterfaceModel.getHigherLayerModelsForNet();
                if (iInterfaceModelArray.length > 0 && iInterfaceModelArray[0] != null && iInterfaceModelArray[0] instanceof IXPLLayer2LineModel) {
                    iXPLLayer2LineModel = (IXPLLayer2LineModel)iInterfaceModelArray[0];
                }
            } else {
                IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                IXPL2ModuleModel iXPL2ModuleModel = (IXPL2ModuleModel)iPortModel.getModuleModel();
                iXPLLayer2LineModel = iXPL2ModuleModel.getXPL2Layer2EtherLines(iInterfaceModel.getIndex());
            }
        }
        return iXPLLayer2LineModel;
    }

    public static boolean isNNI(INodeModel iNodeModel, int n) {
        block7: {
            IXPLLayer2LineModel iXPLLayer2LineModel = null;
            try {
                iXPLLayer2LineModel = SvlanCircuitHelper.getL2Interface(iNodeModel, n);
                if (iXPLLayer2LineModel.isNNI()) {
                    return true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db.on()) {
                    db.println("Exception checking NNI/UNI port." + (Object)((Object)noSuchInterface));
                }
            }
            catch (InvalidOperation invalidOperation) {
                if (db.on()) {
                    db.println("Exception checking NNI/UNI port." + (Object)((Object)invalidOperation));
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block7;
                db.println("Exception checking NNI/UNI port." + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        return false;
    }

    public static boolean isTrunk(INodeModel iNodeModel, int n) {
        block3: {
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                IPortModel iPortModel = null;
                IInterfaceModel iInterfaceModel = null;
                IInterfaceModel[] iInterfaceModelArray = null;
                if (iEntityTableModel != null && (iPortModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(n)) != null && (iInterfaceModel = iPortModel.getInterfaceModel()) != null && (iInterfaceModelArray = iInterfaceModel.getLowerLayerModelsForNet()) != null && iInterfaceModelArray.length > 0 && iInterfaceModelArray[0] instanceof IDwdmTrkLineModel) {
                    return true;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                db.println("Exception checking Trunk/Client port." + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        return false;
    }

    public static boolean arePortsCoLocatedForL2Ckt(INetElement iNetElement, int n, int n2, boolean bl) {
        return SvlanCircuitHelper.arePortsCoLocatedForL2Ckt(iNetElement.getNodeModel(), n, n2, bl);
    }

    public static boolean arePortsCoLocatedForL2Ckt(INodeModel iNodeModel, int n, int n2, boolean bl) {
        block10: {
            if (n == n2) {
                return true;
            }
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            if (iEntityTableModel == null) {
                if (db.on()) {
                    db.println("ERROR! ETM null for " + iNodeModel.getName());
                }
                return false;
            }
            if (iNodeModel.provides(Feature.SVLAN_CKT)) {
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IEntityModel iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n2);
                    if (iEntityModel.getModuleModel() == iEntityModel2.getModuleModel()) {
                        return true;
                    }
                    if (bl) {
                        int[] nArray = SvlanCircuitHelper.getGZTrunkPorts(iNodeModel, n);
                        int[] nArray2 = SvlanCircuitHelper.getGZTrunkPorts(iNodeModel, n2);
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = SvlanCircuitHelper.getGZConnectedTrunk(iNodeModel, nArray[i]);
                            if (n3 == 0) continue;
                            for (int j = 0; j < nArray2.length; ++j) {
                                if (n3 != nArray2[j]) continue;
                                return true;
                            }
                        }
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block10;
                    db.println("Exception checking colocated ports." + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return false;
    }

    public static int getGZConnectedTrunk(INetElement iNetElement, int n) {
        return SvlanCircuitHelper.getGZConnectedTrunk(iNetElement.getNodeModel(), n);
    }

    public static int getGZConnectedTrunk(INodeModel iNodeModel, int n) {
        int n2;
        block4: {
            IEntityTableModel iEntityTableModel;
            n2 = 0;
            if (iNodeModel != null && iNodeModel.provides(Feature.SVLAN_CKT) && (iEntityTableModel = iNodeModel.getEntityTable()) != null) {
                try {
                    IPortModel iPortModel;
                    IPortModel iPortModel2 = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
                    IInterfaceModel iInterfaceModel = iPortModel2.getInterfaceModel();
                    IInterfaceModel[] iInterfaceModelArray = iInterfaceModel.getLowerLayerModelsForNet();
                    if (iInterfaceModelArray == null || iInterfaceModelArray.length <= 0 || (iPortModel = iInterfaceModelArray[0].getPortModel()) == null) break block4;
                    IOptLinkModel[] iOptLinkModelArray = OchTrailHelper.getInternalOptLinks((IEntityModel)iPortModel);
                    for (int i = 0; i < iOptLinkModelArray.length; ++i) {
                        IOptLinkModel iOptLinkModel = iOptLinkModelArray[i];
                        if (iOptLinkModel.getFrom() != iPortModel.getEntityIndex() || !((iInterfaceModel = (iPortModel2 = (IPortModel)iEntityTableModel.getEntityModelByIndex(iOptLinkModel.getTo())).getInterfaceModel()) instanceof IDwdmTrkLineModel) || (iInterfaceModelArray = iInterfaceModel.getHigherLayerModelsForNet()) == null || iInterfaceModelArray.length <= 0) continue;
                        n2 = iInterfaceModelArray[0].getIndex();
                        break;
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return n2;
    }

    public static int getGZOtherTrunkPort(INetElement iNetElement, int n) {
        int n2;
        block4: {
            IEntityTableModel iEntityTableModel;
            n2 = 0;
            INodeModel iNodeModel = iNetElement.getNodeModel();
            if (iNodeModel != null && iNodeModel.provides(Feature.SVLAN_CKT) && (iEntityTableModel = iNodeModel.getEntityTable()) != null) {
                try {
                    List list;
                    IPortModel iPortModel;
                    IPortModel iPortModel22 = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
                    IInterfaceModel iInterfaceModel = iPortModel22.getInterfaceModel();
                    IInterfaceModel[] iInterfaceModelArray = iInterfaceModel.getLowerLayerModelsForNet();
                    if (iInterfaceModelArray == null || iInterfaceModelArray.length <= 0 || (iPortModel = iInterfaceModelArray[0].getPortModel()) == null || (list = SvlanCircuitHelper.getTrunkPorts(iNodeModel, iPortModel.getEntityIndex())) == null) break block4;
                    for (IPortModel iPortModel22 : list) {
                        if (iPortModel22.getEntityIndex() == iPortModel.getEntityIndex() || (iInterfaceModelArray = (iInterfaceModel = iPortModel22.getInterfaceModel()).getHigherLayerModelsForNet()) == null || iInterfaceModelArray.length <= 0) continue;
                        n2 = iInterfaceModelArray[0].getIndex();
                        break;
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        return n2;
    }

    public static List getTrunkPorts(INodeModel iNodeModel, int n) {
        List list;
        block3: {
            list = null;
            try {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null) {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    list = iModuleModel.getDescendantsOfEqType(123);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return list;
    }

    public static int[] getGZTrunkPorts(INetElement iNetElement, int n) {
        return SvlanCircuitHelper.getGZTrunkPorts(iNetElement.getNodeModel(), n);
    }

    public static int[] getGZTrunkPorts(INodeModel iNodeModel, int n) {
        List list;
        int[] nArray = null;
        if (iNodeModel != null && iNodeModel.provides(Feature.SVLAN_CKT) && (list = SvlanCircuitHelper.getTrunkPorts(iNodeModel, n)) != null) {
            nArray = new int[list.size()];
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IInterfaceModel iInterfaceModel = ((IPortModel)iterator.next()).getInterfaceModel();
                IInterfaceModel[] iInterfaceModelArray = iInterfaceModel.getHigherLayerModelsForNet();
                if (iInterfaceModelArray == null || iInterfaceModelArray.length <= 0) continue;
                nArray[n2++] = iInterfaceModelArray[0].getIndex();
            }
        }
        return nArray;
    }
}

