/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.Busy;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.blsr.BlsrNode;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

class BlsrProvisionAgent
implements IJobControl {
    private BlsrNode blsrNode;
    private boolean abort = false;
    private static final SDebug debug = new SDebug("BlsrProvisionAgent");

    public BlsrProvisionAgent(BlsrNode blsrNode) {
        this.blsrNode = blsrNode;
    }

    public JobStatus executeJob() throws Exception {
        JobStatus jobStatus = new JobStatus(1, (Object)this.blsrNode);
        if (!this.abort) {
            try {
                this.blsrNode.provision();
                jobStatus = new JobStatus(4, (Object)this.blsrNode);
            }
            catch (Busy busy) {
                debug.println(this.blsrNode.toString() + ": busy.  Could not provision. " + busy.toString());
                jobStatus = new JobStatus(2);
            }
            catch (ProvisionError provisionError) {
                debug.println(this.blsrNode.toString() + ": failed to provision. " + provisionError.toString());
                jobStatus = new JobStatus(2);
            }
            catch (IllegalStateException illegalStateException) {
                debug.println(this.blsrNode.toString() + ": illegal state. " + illegalStateException.toString());
                jobStatus = new JobStatus(2);
            }
            catch (Exception exception) {
                debug.println(this.blsrNode.toString() + ": failed to provision.  The node may be down." + exception.toString());
                jobStatus = new JobStatus(2);
            }
        } else {
            jobStatus = new JobStatus(3, (Object)this.blsrNode);
        }
        return jobStatus;
    }

    public void abortJob() {
        this.abort = true;
    }

    public String getName() {
        return "BlsrProvisionAgent";
    }
}

