/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.blsr;

import cerent.cms.model.Busy;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.blsr.BlsrNode;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;

class BlsrUpgradeAgent
implements IJobControl {
    private BlsrNode blsrNode;
    private IRevertiveBehavior spanReversion;
    private boolean abort = false;
    private static SDebug db = new SDebug("BlsrUpgradeAgent");

    public BlsrUpgradeAgent(BlsrNode blsrNode, IRevertiveBehavior iRevertiveBehavior) {
        this.blsrNode = blsrNode;
        this.spanReversion = iRevertiveBehavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobStatus executeJob() throws Exception {
        JobStatus jobStatus = new JobStatus(1, (Object)this.blsrNode);
        if (!this.abort) {
            try {
                try {
                    this.blsrNode.upgradeTo4Fiber(this.spanReversion);
                    jobStatus = new JobStatus(4, (Object)this.blsrNode);
                }
                catch (Busy busy) {
                    db.println(this.blsrNode.toString() + ": busy.  Could not upgrade. " + busy.toString());
                    SDebug.printStackTrace((Throwable)busy);
                    jobStatus = new JobStatus(2, (Object)this.blsrNode);
                    Object var4_3 = null;
                    this.blsrNode.clearWorkingPorts();
                }
                catch (ProvisionError provisionError) {
                    db.println(this.blsrNode.toString() + ": failed to upgrade. " + provisionError.toString());
                    SDebug.printStackTrace((Throwable)provisionError);
                    jobStatus = new JobStatus(2, (Object)this.blsrNode);
                    Object var4_4 = null;
                    this.blsrNode.clearWorkingPorts();
                }
                catch (IllegalStateException illegalStateException) {
                    db.println(this.blsrNode.toString() + ": illegal state. " + illegalStateException.toString());
                    SDebug.printStackTrace((Throwable)illegalStateException);
                    jobStatus = new JobStatus(2, (Object)this.blsrNode);
                    Object var4_5 = null;
                    this.blsrNode.clearWorkingPorts();
                }
                catch (Exception exception) {
                    db.println(this.blsrNode.toString() + ": some unexpected exception " + exception.toString());
                    SDebug.printStackTrace((Throwable)exception);
                    jobStatus = new JobStatus(2, (Object)this.blsrNode);
                    Object var4_6 = null;
                    this.blsrNode.clearWorkingPorts();
                }
                Object var4_2 = null;
                this.blsrNode.clearWorkingPorts();
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.blsrNode.clearWorkingPorts();
                throw throwable;
            }
        } else {
            jobStatus = new JobStatus(3, (Object)this.blsrNode);
        }
        return jobStatus;
    }

    public void abortJob() {
        this.abort = true;
    }

    public String getName() {
        return "BlsrUpgradeAgent";
    }
}

