/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLoModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.Model;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongPortType;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IOchCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class NetCircuitModel
extends Model {
    private static final SDebug ncmDb = new SDebug("NetCircuitModel");
    private INetCircuit myModel;
    private static int[] adminStateMap = new int[]{0, 1, 2, 3};
    private static int[] adminStatePartialMap = new int[]{9, 6, 7, 8};

    public NetCircuitModel(INetCircuit iNetCircuit) {
        super(ncmDb);
        this.myModel = iNetCircuit;
    }

    public INetCircuit getNetCircuit() {
        return this.myModel;
    }

    public void update(Observable observable, Object object) {
    }

    public INodeModel getNodeModel() {
        INetElement iNetElement;
        INodeModel iNodeModel = null;
        if (this.myModel instanceof INetCircuit && (iNetElement = this.myModel.getSrcNetElement()) != null) {
            try {
                iNodeModel = iNetElement.getNodeModel();
            }
            catch (Exception exception) {
                this.db.info("Unable to get node from circuit end");
            }
        }
        return iNodeModel;
    }

    public void init() throws Exception {
        super.init0();
    }

    public void dispose() {
        super.dispose();
        if (this.db.on()) {
            this.db.println("ERROR: Can't dispose a NetCircuitModel");
        }
    }

    public void destroy() {
        super.destroy();
        this.myModel = null;
    }

    private static IPortModel getPortModelForOnePlusOneProtect(IPortModel iPortModel) {
        IPortModel iPortModel2;
        block9: {
            iPortModel2 = null;
            if (iPortModel instanceof ITdmPortModel) {
                IElementModel iElementModel;
                block8: {
                    iElementModel = null;
                    try {
                        iElementModel = ((ITdmPortModel)iPortModel).getElementModel();
                    }
                    catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                        if (!SDebug.root.on()) break block8;
                        SDebug.root.severe("getPortModelForOnePlusOneProtect for " + iPortModel + " caught " + (Object)((Object)abstractCmsNoSuchElementException));
                        KDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    }
                }
                if (iElementModel != null && iElementModel instanceof IOnePlusOneModel) {
                    int n = ((IOnePlusOneModel)iElementModel).getProtectEntityIndex();
                    INodeModel iNodeModel = iPortModel.getNodeModel();
                    IEntityTableModel iEntityTableModel = null;
                    if (iNodeModel != null) {
                        iEntityTableModel = iNodeModel.getEntityTable();
                    }
                    if (iEntityTableModel != null) {
                        try {
                            iPortModel2 = (IPortModel)iEntityTableModel.getEntityModelByIndex(n);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!SDebug.root.on()) break block9;
                            SDebug.root.severe("getPortModelForOnePlusOneProtect for " + iPortModel + " caught " + (Object)((Object)abstractCmsNoSuchEntityException));
                            KDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            }
        }
        return iPortModel2;
    }

    public static List getEndPorts(INetCircuitEnd iNetCircuitEnd, int n, int n2) throws ObjNotFound {
        ILoNum iLoNum;
        IHoNum iHoNum;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        IEntityModel iEntityModel = iNetCircuitEnd.getEntityModel();
        IPortModel iPortModel = null;
        IModuleModel iModuleModel = null;
        boolean bl = false;
        boolean bl2 = false;
        SDebug.root.fine("getEndPorts() " + iEntityModel.getClass().getName() + " " + iEntityModel + " " + n2);
        if (iEntityModel instanceof IPortModel) {
            int n3 = iEntityModel.getEqType();
            try {
                if (iNetCircuitEnd.getNodeModel().provides(Feature.STS_OVER_MSTP_ADM) && (iHoNum = iNetCircuitEnd.getEntityModel().getModuleModel()) instanceof IDwdmModuleModel && ((IDwdmModuleModel)iHoNum).isADMCard() && n3 == 186) {
                    IDwdmPortModel iDwdmPortModel = null;
                    iDwdmPortModel = CircuitMapUtil.getClientPortModelForAdm((IPortModel)iEntityModel);
                    linkedList.add(iDwdmPortModel);
                    return linkedList;
                }
            }
            catch (ObjNotFound objNotFound) {
                KDebug.printStackTrace((Throwable)objNotFound);
            }
            iPortModel = (IPortModel)iEntityModel;
            bl = n3 == 34 || n3 == 68 || n3 == 69 && n2 == 12 || n3 == 32 && n2 == 12;
            boolean bl3 = bl2 = (n3 == 69 && n2 == 11 || n3 == 32 && n2 == 11) && iNetCircuitEnd.getNodeModel().getNeType().endsWith("310MASDH");
            if (bl) {
                iModuleModel = iPortModel.getModuleModel();
            } else if (bl2) {
                iHoNum = iNetCircuitEnd.getLoNum();
                iLoNum = iPortModel.getAncestorOfClassType(6);
                List list = iLoNum.getDescendantsOfClassType(7);
                IPortModel iPortModel2 = null;
                if (iLoNum.getEqType() == 234) {
                    iPortModel2 = (IPortModel)list.get(62 + iHoNum.getVc3OrSts1());
                } else if (iLoNum.getEqType() == 233) {
                    iPortModel2 = (IPortModel)list.get(20 + iHoNum.getVc3OrSts1());
                }
                linkedList.add(iPortModel2);
            } else {
                linkedList.add(iPortModel);
                SDebug.root.fine("NetCircuitModel.getEndPorts(): case: ordinary port model " + iPortModel);
            }
        } else if (iEntityModel instanceof IModuleModel) {
            iModuleModel = (IModuleModel)iEntityModel;
        }
        List list = null;
        if (iModuleModel != null) {
            iHoNum = iNetCircuitEnd.getHoNum();
            iLoNum = iNetCircuitEnd.getLoNum();
            list = iPortModel != null ? iModuleModel.getDescendantsOfEqType(iPortModel.getEqType()) : iModuleModel.getDescendantsOfClassType(7);
            if (Feature.delegateProvides((INodeModel)iModuleModel.getNodeModel(), (Feature)Feature.C310MA)) {
                iPortModel = iModuleModel.getPortModelForPath(iEntityModel, iLoNum, iHoNum);
            } else {
                int n4 = iModuleModel.getPortForPath(iLoNum, iHoNum);
                if (n4 > 0 && n4 <= list.size()) {
                    iPortModel = (IPortModel)list.get(n4 - 1);
                } else {
                    SDebug.root.severe("Port " + n4 + " out of range on " + iModuleModel + " for lo/ho " + iLoNum + "/" + iHoNum);
                }
            }
        }
        if (iPortModel != null && iModuleModel instanceof IModuleModel) {
            if (iNetCircuitEnd.getLoNum() == null) {
                iHoNum = iModuleModel.getNodeModel();
                if (iHoNum.provides(Feature.GET_PORTS_IN_GROUP)) {
                    if (!iHoNum.provides(Feature.EXP_PORT_NUM) && bl) {
                        SDebug.root.fine("NetCircuitModel.getEndPorts(): case: broken port group port model " + iPortModel);
                        if (list != null) {
                            linkedList.addAll(list);
                        }
                    } else {
                        SDebug.root.fine("NetCircuitModel.getEndPorts(): case: port group port model " + iPortModel);
                        if (Feature.provides((INodeModel)iHoNum, (Feature)Feature.SDH_AU3)) {
                            linkedList.addAll(iModuleModel.getPortsInGroup(iPortModel, n, n2));
                        } else {
                            linkedList.addAll(iModuleModel.getPortsInGroup(iPortModel, n2));
                        }
                    }
                } else if (bl) {
                    SDebug.root.fine("NetCircuitModel.getEndPorts(): case: legacy DS1 port model " + iPortModel);
                    if (list != null) {
                        linkedList.addAll(list);
                    }
                }
            } else {
                SDebug.root.fine("NetCircuitModel.getEndPorts(): case: lo order circuit port model from module model " + iPortModel);
                linkedList.add(iPortModel);
            }
        }
        return linkedList;
    }

    private static List getEndPorts(List list, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        for (INetCircuitEnd iNetCircuitEnd : list) {
            try {
                linkedList.addAll(NetCircuitModel.getEndPorts(iNetCircuitEnd, n, n2));
            }
            catch (ObjNotFound objNotFound) {
                if (!SDebug.root.on()) continue;
                SDebug.root.severe("getEndPorts for " + iNetCircuitEnd + " catchs " + (Object)((Object)objNotFound));
                KDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        return linkedList;
    }

    public static IPortModel[] getEndpoints(INetCircuit iNetCircuit) {
        List list = NetCircuitModel.getEndPorts(iNetCircuit.getSources(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
        list.addAll(NetCircuitModel.getEndPorts(iNetCircuit.getDrops(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize()));
        return list.toArray(new IPortModel[0]);
    }

    public static IPortModel[] getIndependentEndpoints(INetCircuit iNetCircuit, Object object) {
        LinkedList linkedList;
        TDMTerminology tDMTerminology = iNetCircuit.getSrcNetElement().getNodeModel().getTDMTerminology();
        String string = tDMTerminology.getCircuitTypeString(iNetCircuit.getCircuitTypeObj());
        boolean bl = false;
        try {
            bl = iNetCircuit.isVlanCapable();
            if (bl) {
                SDebug.root.info("VlanCapableCircuit (i.e. UnstitchedEthernet)");
            }
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            SDebug.root.severe("isVlanCapable() failure " + incorrectCircuitState);
        }
        if (iNetCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            SDebug.root.info("EthernetCircuitType (i.e. StitchedEthernet)");
            bl = true;
        }
        if (bl) {
            string = "Non-Port-Mapped Ethernet";
        }
        List<IPortModel> list = null;
        if (iNetCircuit.isMonitorCircuit()) {
            list = NetCircuitModel.getEndPorts(iNetCircuit.getSources(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
            for (IPortModel iPortModel : list) {
                String string2 = ErrorMsg.getString((EID)NEMC.EID_CANNOT_TRANSITION_STATE_ON_MONITORED_PORT);
                NetCircuitModel.addPortStateNotSetReason(string2, iPortModel, object);
            }
            list = NetCircuitModel.getEndPorts(iNetCircuit.getDrops(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
        } else if (iNetCircuit.getCircuitTypeObj().isOchccCircuitType()) {
            linkedList = iNetCircuit.getCircuitNodes();
            list = new LinkedList();
            for (INetCircuitNode iNetCircuitNode : linkedList) {
                List list2 = iNetCircuitNode.getPathList();
                for (int i = 0; i < list2.size(); ++i) {
                    if (!(list2.get(i) instanceof IOchccPathDefModel)) continue;
                    IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)list2.get(i);
                    int n = iOchccPathDefModel.getPortEntityIdx();
                    try {
                        IEntityTableModel iEntityTableModel = iNetCircuitNode.getNodeModel().getEntityTable();
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                        if (!(iEntityModel instanceof IPortModel)) continue;
                        IPortModel iPortModel = (IPortModel)iEntityModel;
                        list.add(iPortModel);
                        continue;
                    }
                    catch (Exception exception) {
                        SDebug.root.severe("Ochcc ckt: Exception getting entitymodel" + exception);
                    }
                }
            }
        } else if (iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            linkedList = iNetCircuit.getCircuitNodes();
            list = new LinkedList();
            for (INetCircuitNode iNetCircuitNode : linkedList) {
                IPortModel iPortModel;
                Object object2;
                if (iNetCircuitNode instanceof OchTrailTunnelNode) {
                    object2 = ((OchTrailTunnelNode)iNetCircuitNode).getPortModel();
                    if (object2 == null) continue;
                    list.add((IPortModel)object2);
                    continue;
                }
                if (!(iNetCircuitNode instanceof DualConnectionCircuitNode) || (iPortModel = ((OchTrailTunnelNode)(object2 = (OchTrailTunnelNode)((DualConnectionCircuitNode)iNetCircuitNode).getFstCircuitNode())).getPortModel()) == null) continue;
                list.add(iPortModel);
            }
        } else {
            list = NetCircuitModel.getEndPorts(iNetCircuit.getSources(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
            list.addAll(NetCircuitModel.getEndPorts(iNetCircuit.getDrops(), iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize()));
            if (!iNetCircuit.getXmCircuitEnds().isEmpty()) {
                linkedList = new LinkedList(iNetCircuit.getXmCircuitEnds());
                INetCircuitEnd iNetCircuitEnd = null;
                for (INetCircuitEnd iNetCircuitEnd2 : linkedList) {
                    try {
                        if (iNetCircuitEnd2.getEntityModel().getPort() % 2 != 1) continue;
                        iNetCircuitEnd = iNetCircuitEnd2;
                    }
                    catch (ObjNotFound objNotFound) {}
                }
                if (iNetCircuitEnd != null) {
                    linkedList.remove(iNetCircuitEnd);
                }
                list.addAll(NetCircuitModel.getEndPorts(linkedList, iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize()));
            }
        }
        if (list == null || list.size() == 0 || bl) {
            int n = list == null ? -1 : list.size();
            SDebug.root.info(n + " drops available on circuit type " + string + "(isEthernet=" + bl + ")");
            if (list != null) {
                list.clear();
            }
            NetCircuitModel.addPortStateNotSetReason(string + " " + "circuits do not have associated drop ports ", null, object);
        }
        return list == null ? null : list.toArray(new IPortModel[0]);
    }

    public static IPortModel[] getXmEndpoints(INetCircuit iNetCircuit, Object object) {
        LinkedList linkedList = null;
        if (!iNetCircuit.getXmCircuitEnds().isEmpty()) {
            LinkedList linkedList2 = new LinkedList(iNetCircuit.getXmCircuitEnds());
            INetCircuitEnd iNetCircuitEnd = null;
            for (INetCircuitEnd iNetCircuitEnd2 : linkedList2) {
                try {
                    if (iNetCircuitEnd2.getEntityModel().getPort() % 2 != 1) continue;
                    iNetCircuitEnd = iNetCircuitEnd2;
                }
                catch (ObjNotFound objNotFound) {}
            }
            if (iNetCircuitEnd != null) {
                linkedList2.remove(iNetCircuitEnd);
            }
            linkedList = new LinkedList();
            linkedList.addAll(NetCircuitModel.getEndPorts(linkedList2, iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize()));
        }
        return linkedList == null ? null : linkedList.toArray(new IPortModel[0]);
    }

    private static void addPortStateNotSetReason(String string, IPortModel iPortModel, ArrayList arrayList) {
        if (arrayList != null) {
            if (iPortModel != null) {
                String string2 = "";
                INodeModel iNodeModel = iPortModel.getNodeModel();
                if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                    string2 = ", Shelf " + iPortModel.getShelfId();
                }
                arrayList.add(iNodeModel.getName() + string2 + ", Slot " + iPortModel.getSlot() + ", Port " + PortHelper.getPortNumString((IPortModel)iPortModel) + ":\n" + string);
            } else {
                arrayList.add("No ports available to set: " + string);
            }
        }
    }

    private static void addPortStateNotSetReason(String string, IPortModel iPortModel, Map map) {
        if (map != null) {
            if (iPortModel != null) {
                map.put(iPortModel, string);
            } else {
                SDebug.root.severe("addPortStateNotSetReason(): no port model");
            }
        }
    }

    private static void addPortStateNotSetReason(String string, IPortModel iPortModel, Object object) {
        if (object instanceof ArrayList) {
            NetCircuitModel.addPortStateNotSetReason(string, iPortModel, (ArrayList)object);
        } else if (object instanceof Map) {
            NetCircuitModel.addPortStateNotSetReason(string, iPortModel, (Map)object);
        } else {
            SDebug.root.severe("unexpected receptacle");
        }
    }

    private static void setPortToTargetState(INetCircuit iNetCircuit, IPortModel iPortModel, int n, int n2, int n3, Object object) {
        block18: {
            try {
                if (Feature.provides((INodeModel)iPortModel.getNodeModel(), (Feature)Feature.ENHANCED_STATE_MODEL)) {
                    IPortModel iPortModel2;
                    if (!NetCircuitModel.isPortStateTransitionAlwaysAllowed(iPortModel.getAdminState(), n) && NetCircuitModel.portHasLAP(iPortModel)) {
                        NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.WID_CANNOT_TRANSITION_STATE_ON_LAP), iPortModel, object);
                        return;
                    }
                    if (!NetCircuitModel.isPortStateTransitionAlwaysAllowed(iPortModel.getAdminState(), n) && NetCircuitModel.portHasOchTrailTunnelInUse(iNetCircuit, iPortModel)) {
                        NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.WID_CANNOT_TRANSITION_STATE_ON_OCHTRAIL_TUNNEL), iPortModel, object);
                        return;
                    }
                    if (!iPortModel.maybeSetAdminState(n, n2, n3)) {
                        NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.WID_CANNOT_TRANSITION_STATE_INDIRECTLY), iPortModel, object);
                    }
                    if ((iPortModel2 = NetCircuitModel.getPortModelForOnePlusOneProtect(iPortModel)) != null && !iPortModel2.maybeSetAdminState(n, n2, n3)) {
                        NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.WID_CANNOT_TRANSITION_STATE_INDIRECTLY), iPortModel2, object);
                    }
                } else {
                    IInterfaceModel iInterfaceModel = iPortModel.getInterfaceModel();
                    if (n == 0) {
                        iInterfaceModel.setInService(true);
                    } else if (n == 1) {
                        NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_CANNOT_TRANSITION_STATE_ON_THIS_VERSION), iPortModel, object);
                    }
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                NetCircuitModel.addPortStateNotSetReason("Currently unable to determine whether the port allows indirect state manipulation: try editing directly", iPortModel, object);
            }
            catch (NoSuchInterface noSuchInterface) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_NO_SUCHINTERFACE), iPortModel, object);
            }
            catch (InvalidLoopbackProvision invalidLoopbackProvision) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_CANNOT_TRANSITION_STATE_WITH_LOOPBACK), iPortModel, object);
            }
            catch (LoopbackActive loopbackActive) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_CANNOT_TRANSITION_STATE_WITH_LOOPBACK), iPortModel, object);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_UNSUPPORTED_OPERATION), iPortModel, object);
            }
            catch (SyncProvError syncProvError) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_CANNOT_TRANSITION_STATE_WITH_SYNC), iPortModel, object);
            }
            catch (InvalidState invalidState) {
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)NEMC.EID_CHANGE_ADMIN_STATE_NOTALLOWED), iPortModel, object);
            }
            catch (ProvisionError provisionError) {
                EID eID = provisionError.getEID();
                if (eID == null) break block18;
                NetCircuitModel.addPortStateNotSetReason(ErrorMsg.getString((EID)eID), iPortModel, object);
            }
        }
    }

    private static boolean isPortStateTransitionAlwaysAllowed(int n, int n2) {
        return NetAdminState.isFormOfIS(n2) || n == 1 || n == 2;
    }

    private static boolean portHasLAP(IPortModel iPortModel) {
        return !NetCircuitManager.instance().getLAPHoEntity(iPortModel.getNodeModel(), (IEntityModel)iPortModel).isEmpty();
    }

    public static boolean portHasOchTrailTunnelInUse(INetCircuit iNetCircuit, IPortModel iPortModel) {
        IDwdmPortModel iDwdmPortModel;
        if (iPortModel instanceof IDwdmPortModel && (iDwdmPortModel = (IDwdmPortModel)iPortModel).isClientPort()) {
            return false;
        }
        iDwdmPortModel = iPortModel.getNodeModel();
        if (Feature.provides((INodeModel)iDwdmPortModel, (Feature)Feature.OCH_TRAIL_PROVISIONING)) {
            IConnectionModels iConnectionModels = iDwdmPortModel.getConnectionModels();
            IOchTrailAditModel[] iOchTrailAditModelArray = iConnectionModels.getOchTrailAditModels();
            for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
                if (iOchTrailAditModelArray[i] == null) continue;
                IOchncPathDefModel[] iOchncPathDefModelArray = null;
                try {
                    iOchncPathDefModelArray = iOchTrailAditModelArray[i].getPaths();
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!ncmDb.on()) continue;
                    ncmDb.println("Skipping disposed adit at index " + iOchTrailAditModelArray[i].getIndex() + ": " + abstractCmsObjectNotExistException.getMessage());
                    continue;
                }
                if (iOchncPathDefModelArray.length <= 0 || iOchncPathDefModelArray[0].getPortEntityIdx() != iPortModel.getEntityIndex()) continue;
                try {
                    INetCircuit iNetCircuit2;
                    OchTrailTunnelNetLink ochTrailTunnelNetLink;
                    if (!iOchTrailAditModelArray[i].inUse()) continue;
                    if (iNetCircuit == null) {
                        return true;
                    }
                    NetCircuitManager netCircuitManager = NetCircuitManager.instance();
                    INetElement iNetElement = Network.instance().findNetElem((INodeModel)iDwdmPortModel);
                    if (iNetElement != null && (ochTrailTunnelNetLink = (OchTrailTunnelNetLink)netCircuitManager.findOchTrailTunnel(iNetElement, iPortModel.getEntityIndex())) != null && (iNetCircuit2 = ochTrailTunnelNetLink.getLotCircuit()) != null) {
                        int n = NetCircuitManager.instance().getOchccsForTunnel(iNetCircuit2).length;
                        return n > 1;
                    }
                    return true;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    return false;
                }
            }
        }
        return false;
    }

    private static void setPortsToTargetState(INetCircuit iNetCircuit, IPortModel[] iPortModelArray, int n, int n2, int n3, Object object) {
        for (int i = 0; i < iPortModelArray.length; ++i) {
            NetCircuitModel.setPortToTargetState(iNetCircuit, iPortModelArray[i], n, n2, n3, object);
        }
    }

    public static boolean setAdminStateOnDropPorts(INetCircuit iNetCircuit, int n, ArrayList arrayList) {
        if (NetAdminState.circuitAllowsStateApplicationToDrops(iNetCircuit)) {
            IPortModel[] iPortModelArray = NetCircuitModel.getIndependentEndpoints(iNetCircuit, arrayList);
            NetCircuitModel.setPortsToTargetState(iNetCircuit, iPortModelArray, n, 2, iNetCircuit.getCircuitSize(), arrayList);
        } else {
            arrayList.add("Circuit type does not support setting state on drop ports.");
        }
        return arrayList.size() == 0;
    }

    public static boolean setAdminStateOnRegenTrkPorts(INetCircuit iNetCircuit, int n, ArrayList arrayList) {
        if (iNetCircuit.getCircuitTypeObj().isOchccCircuitType() || iNetCircuit.getCircuitTypeObj().isOchncType()) {
            List list = ((IOchCircuit)((Object)iNetCircuit)).getRegenTrunkEntityModels();
            if (!list.isEmpty()) {
                IPortModel[] iPortModelArray = new IPortModel[list.size()];
                list.toArray(iPortModelArray);
                NetCircuitModel.setPortsToTargetState(iNetCircuit, iPortModelArray, n, 2, iNetCircuit.getCircuitSize(), arrayList);
            }
        } else {
            arrayList.add("Circuit type does not support setting state on regen trunk ports.");
        }
        return arrayList.size() == 0;
    }

    public static boolean setAdminStateOnXmDropPorts(INetCircuit iNetCircuit, int n, ArrayList arrayList) {
        if (NetAdminState.circuitAllowsStateApplicationToDrops(iNetCircuit)) {
            IPortModel[] iPortModelArray = NetCircuitModel.getXmEndpoints(iNetCircuit, arrayList);
            if (iPortModelArray != null) {
                NetCircuitModel.setPortsToTargetState(iNetCircuit, iPortModelArray, n, 2, iNetCircuit.getCircuitSize(), arrayList);
            }
        } else {
            arrayList.add("Circuit type does not support setting state on drop ports.");
        }
        return arrayList.size() == 0;
    }

    public static boolean setUnusedPortsState(IPortModel[] iPortModelArray, int n, Map map) {
        NetCircuitModel.setPortsToTargetState(null, iPortModelArray, n, 0, 0, map);
        return map.size() == 0;
    }

    public static List getConnectionModels(INetCircuit iNetCircuit) {
        List list = iNetCircuit.getCircuitNodes();
        ArrayList<IConnectionModel> arrayList = new ArrayList<IConnectionModel>(list.size());
        for (INetCircuitNode iNetCircuitNode : list) {
            arrayList.add(iNetCircuitNode.getConn());
        }
        return arrayList;
    }

    private static String getDetailedAdminStateString(INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = NetCircuitModel.getAdminStateCount(iNetCircuitEnd, n, n2);
        if (nArray != null) {
            TDMTerminology tDMTerminology = iNetCircuitEnd.getNodeModel().getTDMTerminology();
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] <= 0) continue;
                for (int j = 0; j < i; ++j) {
                    if (nArray[j] <= 0) continue;
                    stringBuffer.append(nArray[j]).append(' ').append(tDMTerminology.getTermForAdminState(j)).append(',');
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(nArray[i]).append(' ');
                }
                stringBuffer.append(tDMTerminology.getTermForAdminState(i));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public static String getDetailedServiceStateString(INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        StringBuffer stringBuffer;
        block4: {
            if (!Feature.provides((INodeModel)iNetCircuitEnd.getNodeModel(), (Feature)Feature.EXTENDED_ESM)) {
                return NetCircuitModel.getDetailedAdminStateString(iNetCircuitEnd, n, n2);
            }
            stringBuffer = new StringBuffer();
            Map map = NetCircuitModel.getServiceStateCount(iNetCircuitEnd, n, n2);
            if (map == null) break block4;
            TDMTerminology tDMTerminology = iNetCircuitEnd.getNodeModel().getTDMTerminology();
            Iterator iterator = map.keySet().iterator();
            if (iterator.hasNext()) {
                Integer n3 = (Integer)iterator.next();
                int n4 = (Integer)map.get(n3);
                for (Integer n5 : map.keySet()) {
                    if (n5 == n3) continue;
                    int n6 = (Integer)map.get(n5);
                    stringBuffer.append(n6).append(' ').append(tDMTerminology.getTermForServiceState(n5.intValue())).append(',');
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(n4).append(' ');
                }
                stringBuffer.append(tDMTerminology.getTermForServiceState(n3.intValue()));
            }
        }
        return stringBuffer.toString();
    }

    public static int getAdminState(INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        int[] nArray = NetCircuitModel.getAdminStateCount(iNetCircuitEnd, n, n2);
        if (nArray != null) {
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] <= 0) continue;
                for (int j = i - 1; j > 0; --j) {
                    if (nArray[j] <= 0) continue;
                    return adminStatePartialMap[i];
                }
                return adminStateMap[i];
            }
            return 1;
        }
        return -1;
    }

    private static int[] getAdminStateCount(INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        try {
            IPortModel[] iPortModelArray = NetCircuitModel.getEndPorts(iNetCircuitEnd, n, n2).toArray(new IPortModel[0]);
            if (iPortModelArray.length == 0) {
                return null;
            }
            boolean bl = Feature.provides((INodeModel)iPortModelArray[0].getNodeModel(), (Feature)Feature.SPAN_UPGRADE);
            boolean bl2 = Feature.provides((INodeModel)iPortModelArray[0].getNodeModel(), (Feature)Feature.ENHANCED_STATE_MODEL);
            if (!bl2 && !bl) {
                return null;
            }
            int[] nArray = new int[]{0, 0, 0, 0};
            block9: for (int i = 0; i < iPortModelArray.length; ++i) {
                int n3 = -1;
                if (bl2) {
                    IInterfaceModel iInterfaceModel = NetCircuitModel.getDs1LineModelIfDs3XM(iPortModelArray[i], iNetCircuitEnd, n2);
                    n3 = iInterfaceModel != null ? iInterfaceModel.getAdminState() : iPortModelArray[i].getAdminState();
                } else if (bl && iPortModelArray[i] instanceof ITdmPortModel) {
                    n3 = ((ITdmPortModel)iPortModelArray[i]).isPortIS() ? 0 : 1;
                }
                switch (n3) {
                    case 0: {
                        nArray[0] = nArray[0] + 1;
                        continue block9;
                    }
                    case 1: {
                        nArray[1] = nArray[1] + 1;
                        continue block9;
                    }
                    case 2: {
                        nArray[2] = nArray[2] + 1;
                        continue block9;
                    }
                    case 3: {
                        nArray[3] = nArray[3] + 1;
                        continue block9;
                    }
                    default: {
                        return null;
                    }
                }
            }
            return nArray;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.root.severe("getAdminStateCount: catch " + (Object)((Object)noSuchInterface));
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (ObjNotFound objNotFound) {
            SDebug.root.severe("getAdminStateCount: catch " + (Object)((Object)objNotFound));
            KDebug.printStackTrace((Throwable)objNotFound);
        }
        return null;
    }

    private static Map getServiceStateCount(INetCircuitEnd iNetCircuitEnd, int n, int n2) {
        try {
            IPortModel[] iPortModelArray = NetCircuitModel.getEndPorts(iNetCircuitEnd, n, n2).toArray(new IPortModel[0]);
            if (iPortModelArray.length == 0) {
                return null;
            }
            boolean bl = Feature.provides((INodeModel)iPortModelArray[0].getNodeModel(), (Feature)Feature.SPAN_UPGRADE);
            boolean bl2 = Feature.provides((INodeModel)iPortModelArray[0].getNodeModel(), (Feature)Feature.EXTENDED_ESM);
            if (!bl2 && !bl) {
                return null;
            }
            HashMap<IInterfaceModel, Integer> hashMap = new HashMap<IInterfaceModel, Integer>();
            for (int i = 0; i < iPortModelArray.length; ++i) {
                Object object;
                int n3 = -1;
                if (bl2) {
                    object = NetCircuitModel.getDs1LineModelIfDs3XM(iPortModelArray[i], iNetCircuitEnd, n2);
                    n3 = object != null ? object.getServiceSt().getType() : iPortModelArray[i].getServiceStateType();
                } else if (bl && iPortModelArray[i] instanceof ITdmPortModel) {
                    n3 = ((ITdmPortModel)iPortModelArray[i]).isPortIS() ? 0 : 1;
                }
                if (n3 == -1) {
                    return null;
                }
                object = new Integer(n3);
                Integer n4 = (Integer)hashMap.get(object);
                n4 = n4 != null ? new Integer(n4 + 1) : new Integer(1);
                hashMap.put((IInterfaceModel)object, n4);
            }
            return hashMap;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.root.severe("getServiceStateCount: catch " + (Object)((Object)noSuchInterface));
            KDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (ObjNotFound objNotFound) {
            SDebug.root.severe("getServiceStateCount: catch " + (Object)((Object)objNotFound));
            KDebug.printStackTrace((Throwable)objNotFound);
        }
        return null;
    }

    private static IInterfaceModel getDs1LineModelIfDs3XM(IPortModel iPortModel, INetCircuitEnd iNetCircuitEnd, int n) {
        if (iNetCircuitEnd.getHoLoNum() != null) {
            ILoNum iLoNum = iNetCircuitEnd.getLoNum();
            INodeModel iNodeModel = iPortModel.getNodeModel();
            if (iLoNum != null && iPortModel.getEqType() == 33 && iNodeModel.provides(Feature.GET_LINE_INTERFACE_MODEL) && CircuitSize.getCircuitSize((int)n).isLo(iLoNum.getFramingType())) {
                try {
                    ITdmLoModel iTdmLoModel = iPortModel.getTdmLoModel(iLoNum);
                    if (iTdmLoModel != null) {
                        return iTdmLoModel.getLineInterfaceModel();
                    }
                }
                catch (WrongPortType wrongPortType) {
                    SDebug.root.severe("getDs1LineModelIfDs3XM: catch " + (Object)((Object)wrongPortType));
                    KDebug.printStackTrace((Throwable)wrongPortType);
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug.root.severe("getDs1LineModelIfDs3XM: catch " + (Object)((Object)noSuchInterface));
                    KDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
        }
        return null;
    }
}

