/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.IConnectionType;
import cerent.cms.ncp.BridgeConnection;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.InternalCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConnectionsFactory {
    private NetCircuitNode node;
    private static final SDebug db = new SDebug("ConnectionsFactory");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected ConnectionsFactory(NetCircuitNode netCircuitNode) {
        this.node = netCircuitNode;
    }

    protected List setupConnListOnCreation(int n) {
        List list = this.node.getSources();
        List list2 = this.node.getDrops();
        LinkedList linkedList = this.node.getTermSpans();
        LinkedList linkedList2 = this.node.getOrigSpans();
        LinkedList linkedList3 = this.node.getOmniSpans();
        LinkedList linkedList4 = this.node.getInSpans();
        LinkedList linkedList5 = this.node.getOutSpans();
        LinkedList linkedList6 = this.node.getBiSpans();
        LinkedList<Connection> linkedList7 = new LinkedList<Connection>();
        if (ConnectionsFactory.dbgOn()) {
            db.println("setupConnListOnCreation: deconstructing a " + EnumStrings.getString(IConnectionType.class, (int)n) + " on node " + this.node.getName());
        }
        switch (n) {
            case 0: 
            case 4: 
            case 9: {
                if (n == 0 && this.node.isOchTrailTunnelNode() && (this.node.getCircuit().getCircuitTypeObj().isOchncType() || this.node.getCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType())) {
                    if (!ConnectionsFactory.dbgOn()) break;
                    db.println("setupConnListOnCreation: avoiding OchTrailTunnelNode deconstruction");
                    break;
                }
                if (NetCircuitNodeUtil.isBridgedOneWay(n, this.node.countNumOutputs())) {
                    int n2;
                    BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                    linkedList7.add(bridgeConnection);
                    if (list.size() == 1) {
                        bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    } else if (linkedList.size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    }
                    LinkedList linkedList8 = linkedList2;
                    for (n2 = 0; n2 < linkedList8.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList8.get(n2));
                    }
                    for (n2 = 0; n2 < list2.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                    }
                    linkedList8 = linkedList3;
                    for (n2 = 0; n2 < linkedList8.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList8.get(n2));
                    }
                    break;
                }
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                linkedList7.add(onewayConnection);
                if (linkedList.size() == 1) {
                    onewayConnection.addInput((NetCircuitSpan)linkedList.get(0));
                } else if (list.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)list.get(0));
                }
                if (linkedList2.size() == 1) {
                    onewayConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    break;
                }
                if (list2.size() != 1) break;
                onewayConnection.addOutput((NetCircuitEnd)list2.get(0));
                break;
            }
            case 1: 
            case 8: 
            case 18: {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                linkedList7.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                linkedList7.add(onewayConnection2);
                if (linkedList6.size() == 2) {
                    onewayConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                    onewayConnection.addOutput((NetCircuitSpan)linkedList6.get(1));
                    onewayConnection2.addInput((NetCircuitSpan)linkedList6.get(1));
                    onewayConnection2.addOutput((NetCircuitSpan)linkedList6.get(0));
                    break;
                }
                if (list.size() == 1 && list2.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)list.get(0));
                    onewayConnection.addOutput((NetCircuitEnd)list2.get(0));
                    onewayConnection2.addInput((NetCircuitEnd)list2.get(0));
                    onewayConnection2.addOutput((NetCircuitEnd)list.get(0));
                    break;
                }
                if (linkedList6.size() != 1) break;
                onewayConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                onewayConnection2.addOutput((NetCircuitSpan)linkedList6.get(0));
                if (list.size() == 1) {
                    onewayConnection.addOutput((NetCircuitEnd)list.get(0));
                    onewayConnection2.addInput((NetCircuitEnd)list.get(0));
                }
                if (list2.size() != 1) break;
                onewayConnection.addOutput((NetCircuitEnd)list2.get(0));
                onewayConnection2.addInput((NetCircuitEnd)list2.get(0));
                break;
            }
            case 6: {
                int n3;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList7.add(bridgeConnection);
                BridgeConnection bridgeConnection2 = new BridgeConnection("bridge2");
                linkedList7.add(bridgeConnection2);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (linkedList6.size() == 2) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)linkedList6.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList6.get(1));
                    bridgeConnection2.addOutput((NetCircuitSpan)linkedList6.get(0));
                } else if (linkedList4.size() == 2) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)linkedList4.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList4.get(1));
                    bridgeConnection2.addOutput((NetCircuitSpan)linkedList4.get(0));
                } else if (linkedList4.size() == 1 && list.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)linkedList4.get(0));
                } else if (linkedList6.size() == 1 && list.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)linkedList6.get(0));
                } else if (linkedList6.size() == 0 && list.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)list.get(1));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                    bridgeConnection2.addOutput((NetCircuitEnd)list.get(0));
                } else if (linkedList4.size() == 1 && linkedList3.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)linkedList3.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)linkedList4.get(0));
                } else if (ConnectionsFactory.dbgOn()) {
                    db.println("ERROR! UPSR_DC with invalid inputs");
                }
                for (n3 = 0; n3 < linkedList5.size(); ++n3) {
                    selectorConnection.addOutput((NetCircuitSpan)linkedList5.get(n3));
                }
                for (n3 = 0; n3 < list2.size(); ++n3) {
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(n3));
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection2, selectorConnection);
                bridgeConnection2.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 7: {
                int n4;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (linkedList6.size() == 1 && list.size() == 1) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList6.get(0));
                } else if (linkedList6.size() == 1 && linkedList4.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList6.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList6.get(0));
                } else if (linkedList6.size() == 0 && list.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                } else if (ConnectionsFactory.dbgOn()) {
                    db.println("ERROR! UPSR_EN with invalid inputs");
                }
                for (n4 = 0; n4 < linkedList5.size(); ++n4) {
                    selectorConnection.addOutput((NetCircuitSpan)linkedList5.get(n4));
                }
                for (n4 = 0; n4 < list2.size(); ++n4) {
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(n4));
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 5: {
                int n5;
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (list.size() == 1 && linkedList4.size() == 1) {
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                } else if (list.size() == 0 && linkedList4.size() == 2) {
                    selectorConnection.addInput((NetCircuitSpan)linkedList4.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList4.get(1));
                } else if (list.size() == 2 && linkedList4.size() == 0) {
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                } else if (ConnectionsFactory.dbgOn()) {
                    db.println("ERROR! UPSR_DROP with invalid inputs");
                }
                for (n5 = 0; n5 < linkedList5.size(); ++n5) {
                    selectorConnection.addOutput((NetCircuitSpan)linkedList5.get(n5));
                }
                for (n5 = 0; n5 < list2.size(); ++n5) {
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(n5));
                }
                break;
            }
            case 2: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (list.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                } else if (list.size() == 1 && linkedList.size() == 1) {
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                } else if (linkedList.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(1));
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(1));
                } else if (list.size() == 1 && linkedList.size() == 0) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list.get(0));
                } else if (list.size() == 0 && linkedList.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                }
                if (list2.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitEnd)list2.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list2.get(1));
                    selectorConnection.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list2.get(1));
                }
                if (list2.size() == 1 && linkedList2.size() == 1) {
                    bridgeConnection.addOutput((NetCircuitEnd)list2.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                    break;
                }
                if (linkedList2.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList2.get(1));
                    selectorConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList2.get(1));
                    break;
                }
                if (linkedList2.size() == 1 && list2.size() == 0) {
                    bridgeConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    break;
                }
                if (linkedList2.size() != 0 || list2.size() != 1) break;
                bridgeConnection.addInput((NetCircuitEnd)list2.get(0));
                selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                break;
            }
            case 3: {
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList7.add(selectorConnection);
                SelectorConnection selectorConnection2 = new SelectorConnection("selector2");
                linkedList7.add(selectorConnection2);
                if (list.size() == 2) {
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                    selectorConnection2.addOutput((NetCircuitEnd)list.get(0));
                    selectorConnection2.addOutput((NetCircuitEnd)list.get(1));
                } else if (list.size() == 1 && linkedList.size() == 1) {
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection2.addOutput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection2.addOutput((NetCircuitEnd)list.get(0));
                } else if (linkedList.size() == 2) {
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addInput((NetCircuitSpan)linkedList.get(1));
                    selectorConnection2.addOutput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection2.addOutput((NetCircuitSpan)linkedList.get(1));
                }
                if (list2.size() == 2) {
                    selectorConnection2.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection2.addInput((NetCircuitEnd)list2.get(1));
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(1));
                    break;
                }
                if (list2.size() == 1 && linkedList2.size() == 1) {
                    selectorConnection2.addInput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection2.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                    break;
                }
                if (linkedList2.size() != 2) break;
                selectorConnection2.addInput((NetCircuitSpan)linkedList2.get(0));
                selectorConnection2.addInput((NetCircuitSpan)linkedList2.get(1));
                selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(1));
                break;
            }
            case 10: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                linkedList7.add(onewayConnection);
                if (list.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    onewayConnection.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                    if (list2.size() == 1) {
                        onewayConnection.addInput((NetCircuitEnd)list2.get(0));
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(1));
                    }
                } else if (list.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list.get(0));
                    if (linkedList3.size() == 1) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList3.get(0));
                    }
                    if (linkedList2.size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                        onewayConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                    }
                } else if (list2.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                    if (linkedList3.size() == 1) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList3.get(0));
                    }
                    if (linkedList.size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        onewayConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                    }
                } else if (linkedList2.size() == 1 && linkedList.size() == 1 && linkedList3.size() == 1) {
                    NetCircuitSpan netCircuitSpan;
                    NetCircuitSpan netCircuitSpan2;
                    NetCircuitSpan netCircuitSpan3 = (NetCircuitSpan)linkedList2.get(0);
                    NetCircuitSpan netCircuitSpan4 = (NetCircuitSpan)linkedList.get(0);
                    NetCircuitSpan netCircuitSpan5 = (NetCircuitSpan)linkedList3.get(0);
                    NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan3);
                    NetCircuitNode netCircuitNode2 = this.node.spanGetPeer(netCircuitSpan4);
                    if (netCircuitNode == null || netCircuitNode2 == null) break;
                    if (NetCircuitNodeUtil.isBlsrDriHandoff(this.node.getDriNodeType())) {
                        if (netCircuitSpan3.isLineProtected() || netCircuitSpan3.isPca()) {
                            netCircuitSpan2 = netCircuitSpan4;
                            netCircuitSpan = netCircuitSpan3;
                        } else {
                            netCircuitSpan2 = netCircuitSpan3;
                            netCircuitSpan = netCircuitSpan4;
                        }
                    } else if (NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNode.getDriNodeType())) {
                        netCircuitSpan2 = netCircuitSpan4;
                        netCircuitSpan = netCircuitSpan3;
                    } else if (NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNode2.getDriNodeType())) {
                        netCircuitSpan2 = netCircuitSpan3;
                        netCircuitSpan = netCircuitSpan4;
                    } else if (netCircuitSpan5.getNetLinkSpan().getSourceRing()) {
                        netCircuitSpan2 = netCircuitSpan4;
                        netCircuitSpan = netCircuitSpan3;
                    } else {
                        netCircuitSpan2 = netCircuitSpan3;
                        netCircuitSpan = netCircuitSpan4;
                    }
                    selectorConnection.addOutput(netCircuitSpan);
                    onewayConnection.addInput(netCircuitSpan);
                    bridgeConnection.addInput(netCircuitSpan2);
                    onewayConnection.addOutput(netCircuitSpan2);
                    bridgeConnection.addOutput(netCircuitSpan5);
                    selectorConnection.addInput(netCircuitSpan5);
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 11: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList7.add(selectorConnection);
                BridgeConnection bridgeConnection3 = new BridgeConnection("bridge2");
                linkedList7.add(bridgeConnection3);
                SelectorConnection selectorConnection3 = new SelectorConnection("selector2");
                linkedList7.add(selectorConnection3);
                if (list.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection3.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                    if (list2.size() == 2) {
                        bridgeConnection3.addInput((NetCircuitEnd)list2.get(0));
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                        bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                        selectorConnection.addInput((NetCircuitEnd)list.get(1));
                    }
                } else {
                    if (linkedList.size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection3.addOutput((NetCircuitSpan)linkedList.get(0));
                    }
                    if (linkedList3.size() == 2) {
                        if (((NetCircuitSpan)linkedList3.get(0)).getNetLinkSpan().getSourceRing()) {
                            bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                            selectorConnection.addInput((NetCircuitSpan)linkedList3.get(0));
                            bridgeConnection3.addOutput((NetCircuitSpan)linkedList3.get(1));
                            selectorConnection3.addInput((NetCircuitSpan)linkedList3.get(1));
                        } else {
                            bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(1));
                            selectorConnection.addInput((NetCircuitSpan)linkedList3.get(1));
                            bridgeConnection3.addOutput((NetCircuitSpan)linkedList3.get(0));
                            selectorConnection3.addInput((NetCircuitSpan)linkedList3.get(0));
                        }
                    }
                    if (linkedList2.size() == 1) {
                        selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                        bridgeConnection3.addInput((NetCircuitSpan)linkedList2.get(0));
                    }
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection3, selectorConnection3);
                bridgeConnection3.addOutput(internalCircuitSpan);
                selectorConnection3.addInput(internalCircuitSpan);
                break;
            }
            case 15: {
                NetCircuitSpan netCircuitSpan8;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (list.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list.get(1));
                } else if (list.size() == 1) {
                    netCircuitSpan8 = (NetCircuitSpan)linkedList.get(0);
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)list.get(0);
                    if (netCircuitSpan8.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitEnd);
                        selectorConnection.addInput(netCircuitSpan8);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan8);
                        selectorConnection.addInput(netCircuitEnd);
                    }
                } else {
                    NetCircuitSpan netCircuitSpan6 = (NetCircuitSpan)linkedList.get(0);
                    NetCircuitSpan netCircuitSpan7 = (NetCircuitSpan)linkedList.get(1);
                    if (netCircuitSpan6.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitSpan7);
                        selectorConnection.addInput(netCircuitSpan6);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan6);
                        selectorConnection.addInput(netCircuitSpan7);
                    }
                }
                List list3 = list2;
                LinkedList linkedList9 = linkedList2;
                for (NetCircuitSpan netCircuitSpan8 : linkedList9) {
                    if (!netCircuitSpan8.getBlsrDriInterConnect()) continue;
                    linkedList9.remove(netCircuitSpan8);
                    bridgeConnection.addOutput(netCircuitSpan8);
                    break;
                }
                for (NetCircuitSpan netCircuitSpan8 : linkedList9) {
                    selectorConnection.addOutput(netCircuitSpan8);
                }
                for (NetCircuitEnd netCircuitEnd : list3) {
                    selectorConnection.addOutput(netCircuitEnd);
                }
                netCircuitSpan8 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan8);
                selectorConnection.addInput(netCircuitSpan8);
                break;
            }
            case 16: {
                NetCircuitSpan netCircuitSpan11;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList7.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                linkedList7.add(onewayConnection);
                if (list.size() == 2) {
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)list.get(0);
                    NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)list.get(1);
                    bridgeConnection.addInput(netCircuitEnd);
                    onewayConnection.addOutput(netCircuitEnd);
                    selectorConnection.addInput(netCircuitEnd2);
                } else if (list.size() == 1 && linkedList.size() == 1) {
                    netCircuitSpan11 = (NetCircuitSpan)linkedList.get(0);
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)list.get(0);
                    if (netCircuitSpan11.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitEnd);
                        onewayConnection.addOutput(netCircuitEnd);
                        selectorConnection.addInput(netCircuitSpan11);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan11);
                        onewayConnection.addOutput(netCircuitSpan11);
                        selectorConnection.addInput(netCircuitEnd);
                    }
                } else if (linkedList.size() == 2) {
                    NetCircuitSpan netCircuitSpan9 = (NetCircuitSpan)linkedList.get(0);
                    NetCircuitSpan netCircuitSpan10 = (NetCircuitSpan)linkedList.get(1);
                    if (netCircuitSpan9.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitSpan10);
                        onewayConnection.addOutput(netCircuitSpan10);
                        selectorConnection.addInput(netCircuitSpan9);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan9);
                        onewayConnection.addOutput(netCircuitSpan9);
                        selectorConnection.addInput(netCircuitSpan10);
                    }
                }
                List list4 = list2;
                if (linkedList3.size() == 1) {
                    netCircuitSpan11 = (NetCircuitSpan)linkedList3.get(0);
                    onewayConnection.addInput(netCircuitSpan11);
                    bridgeConnection.addOutput(netCircuitSpan11);
                } else if (list4.size() > 1) {
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)list4.remove(1);
                    onewayConnection.addInput(netCircuitEnd);
                    bridgeConnection.addOutput(netCircuitEnd);
                }
                for (NetCircuitSpan netCircuitSpan11 : linkedList2) {
                    selectorConnection.addOutput(netCircuitSpan11);
                }
                for (NetCircuitEnd netCircuitEnd : list4) {
                    selectorConnection.addOutput(netCircuitEnd);
                }
                netCircuitSpan11 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan11);
                selectorConnection.addInput(netCircuitSpan11);
                break;
            }
            case 13: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList7.add(bridgeConnection);
                BridgeConnection bridgeConnection4 = new BridgeConnection("bridge2");
                linkedList7.add(bridgeConnection4);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList7.add(selectorConnection);
                SelectorConnection selectorConnection4 = new SelectorConnection("selector2");
                linkedList7.add(selectorConnection4);
                if (linkedList.size() == 2) {
                    if (((NetCircuitSpan)linkedList.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(1));
                        bridgeConnection4.addOutput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection.addOutput((NetCircuitSpan)linkedList.get(1));
                        selectorConnection4.addInput((NetCircuitSpan)linkedList.get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        bridgeConnection4.addOutput((NetCircuitSpan)linkedList.get(1));
                        selectorConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection4.addInput((NetCircuitSpan)linkedList.get(1));
                    }
                } else if (linkedList.size() == 1 && list.size() == 1) {
                    if (((NetCircuitSpan)linkedList.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                        bridgeConnection4.addOutput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection.addOutput((NetCircuitEnd)list.get(0));
                        selectorConnection4.addInput((NetCircuitSpan)linkedList.get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        bridgeConnection4.addOutput((NetCircuitEnd)list.get(0));
                        selectorConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection4.addInput((NetCircuitEnd)list.get(0));
                    }
                } else if (list.size() >= 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    bridgeConnection4.addOutput((NetCircuitEnd)list.get(1));
                    selectorConnection.addOutput((NetCircuitEnd)list.get(0));
                    selectorConnection4.addInput((NetCircuitEnd)list.get(1));
                }
                LinkedList linkedList10 = linkedList2;
                if (linkedList10.size() >= 2) {
                    if (((NetCircuitSpan)linkedList10.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList10.get(0));
                        bridgeConnection4.addInput((NetCircuitSpan)linkedList10.get(1));
                        selectorConnection.addInput((NetCircuitSpan)linkedList10.get(0));
                        selectorConnection4.addOutput((NetCircuitSpan)linkedList10.get(1));
                    } else {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList10.get(1));
                        bridgeConnection4.addInput((NetCircuitSpan)linkedList10.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList10.get(1));
                        selectorConnection4.addOutput((NetCircuitSpan)linkedList10.get(0));
                    }
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection4);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection4.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection4, selectorConnection);
                bridgeConnection4.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 14: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList7.add(bridgeConnection);
                BridgeConnection bridgeConnection5 = new BridgeConnection("bridge2");
                linkedList7.add(bridgeConnection5);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList7.add(selectorConnection);
                if (linkedList.size() == 2 && linkedList2.size() == 1 && linkedList3.size() == 1) {
                    if (((NetCircuitSpan)linkedList.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(1));
                        selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList.get(1));
                    }
                    bridgeConnection5.addOutput((NetCircuitSpan)linkedList.get(0));
                    bridgeConnection5.addOutput((NetCircuitSpan)linkedList.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                    bridgeConnection5.addInput((NetCircuitSpan)linkedList2.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)linkedList2.get(0));
                } else if (linkedList.size() == 1 && linkedList2.size() == 2 && linkedList3.size() == 1) {
                    if (((NetCircuitSpan)linkedList2.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList2.get(1));
                        selectorConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)linkedList2.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList2.get(1));
                    }
                    bridgeConnection5.addOutput((NetCircuitSpan)linkedList2.get(0));
                    bridgeConnection5.addOutput((NetCircuitSpan)linkedList2.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)linkedList3.get(0));
                    bridgeConnection5.addInput((NetCircuitSpan)linkedList.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                } else if (list.size() == 2 && list2.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)list.get(0));
                    bridgeConnection5.addOutput((NetCircuitEnd)list.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)list.get(1));
                    bridgeConnection5.addInput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)list2.get(0));
                    selectorConnection.addInput((NetCircuitEnd)list2.get(1));
                    bridgeConnection5.addOutput((NetCircuitEnd)list2.get(1));
                } else if (ConnectionsFactory.dbgOn()) {
                    db.println("WARNING!! unknown span combo for UPSR_BLSR_IDRI");
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            default: {
                if (!ConnectionsFactory.dbgOn()) break;
                db.println("setupConnListOnCreation: unknown connection type " + EnumStrings.getString(IConnectionType.class, (int)n));
            }
        }
        ConnectionsFactory.prettyPrintConnectionList(db, n, linkedList7, this.node.getName());
        return linkedList7;
    }

    protected List setupConnListOnDiscovery(int n) {
        NetCircuitEnd[] netCircuitEndArray;
        Object[] objectArray;
        NetCircuitEnd netCircuitEnd = null;
        int n2 = -1;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        INetElement iNetElement = this.node.getNetElement();
        if (ConnectionsFactory.dbgOn()) {
            db.println("setupConnListOnDiscovery: deconstructing a " + EnumStrings.getString(IConnectionType.class, (int)n) + " on node " + this.node.getName());
        }
        try {
            objectArray = this.node.hasDualConnections() ? ((DualConnectionCircuitNode)this.node).getPathsFromConnModelExcludeXms() : this.node.getPathsFromConnModel();
            netCircuitEndArray = new NetCircuitEnd[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                netCircuitEndArray[i] = NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, objectArray[i]);
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return linkedList;
        }
        catch (AbstractCmsCommFailException abstractCmsCommFailException) {
            return linkedList;
        }
        List list = this.node.getSources();
        List list2 = this.node.getDrops();
        List list3 = this.node.getAllSpansList();
        if (list2.size() + list.size() + list3.size() != objectArray.length) {
            if (ConnectionsFactory.dbgOn()) {
                db.println("setupConnListOnDiscovery: splicing incomplete");
            }
            return linkedList;
        }
        switch (n) {
            case 0: 
            case 9: {
                if (NetCircuitNodeUtil.isBridgedOneWay(n, this.node.countNumOutputs())) {
                    linkedList.addAll(this.setupConnListOnDiscoveryOfBridge(objectArray, netCircuitEndArray));
                    break;
                }
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                linkedList.add(onewayConnection);
                block20: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (i == 0) {
                        if (list.contains(netCircuitEnd)) {
                            onewayConnection.addInput(netCircuitEnd);
                        }
                    } else if (i == 1 && list2.contains(netCircuitEnd)) {
                        onewayConnection.addOutput(netCircuitEnd);
                    }
                    if (list3.isEmpty()) continue;
                    int n3 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan : list3) {
                        if (n3 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addInput(netCircuitSpan);
                            continue block20;
                        }
                        if (i != 1) continue block20;
                        onewayConnection.addOutput(netCircuitSpan);
                        continue block20;
                    }
                }
                break;
            }
            case 1: 
            case 8: 
            case 18: {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                linkedList.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                linkedList.add(onewayConnection2);
                block22: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addInput(list.get(n2));
                            onewayConnection2.addOutput(list.get(n2));
                            continue;
                        }
                        onewayConnection.addOutput(list.get(n2));
                        onewayConnection2.addInput(list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addInput(list2.get(n2));
                            onewayConnection2.addOutput(list2.get(n2));
                            continue;
                        }
                        onewayConnection.addOutput(list2.get(n2));
                        onewayConnection2.addInput(list2.get(n2));
                        continue;
                    }
                    int n4 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan : list3) {
                        if (n4 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addInput(netCircuitSpan);
                            onewayConnection2.addOutput(netCircuitSpan);
                            continue block22;
                        }
                        if (i != 1) continue block22;
                        onewayConnection.addOutput(netCircuitSpan);
                        onewayConnection2.addInput(netCircuitSpan);
                        continue block22;
                    }
                }
                break;
            }
            case 6: {
                NetCircuitSpan netCircuitSpan2;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList.add(bridgeConnection);
                BridgeConnection bridgeConnection2 = new BridgeConnection("bridge2");
                linkedList.add(bridgeConnection2);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block24: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput(list.get(n2));
                            bridgeConnection2.addOutput(list.get(n2));
                            continue;
                        }
                        bridgeConnection.addOutput(list.get(n2));
                        bridgeConnection2.addInput(list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(list2.get(n2));
                        continue;
                    }
                    int n5 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan2 : list3) {
                        if (n5 != netCircuitSpan2.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan2.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan2.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan2);
                            bridgeConnection2.addOutput(netCircuitSpan2);
                            continue block24;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan2);
                            bridgeConnection2.addInput(netCircuitSpan2);
                            continue block24;
                        }
                        selectorConnection.addOutput(netCircuitSpan2);
                        continue block24;
                    }
                }
                netCircuitSpan2 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan2);
                selectorConnection.addInput(netCircuitSpan2);
                netCircuitSpan2 = new InternalCircuitSpan(bridgeConnection2, selectorConnection);
                bridgeConnection2.addOutput(netCircuitSpan2);
                selectorConnection.addInput(netCircuitSpan2);
                break;
            }
            case 7: {
                NetCircuitSpan netCircuitSpan3;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block26: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput(list.get(n2));
                            continue;
                        }
                        selectorConnection.addInput(list.get(n2));
                        bridgeConnection.addOutput(list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(list2.get(n2));
                        continue;
                    }
                    int n6 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan3 : list3) {
                        if (n6 != netCircuitSpan3.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan3.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan3.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan3);
                            continue block26;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan3);
                            selectorConnection.addInput(netCircuitSpan3);
                            continue block26;
                        }
                        selectorConnection.addOutput(netCircuitSpan3);
                        continue block26;
                    }
                }
                netCircuitSpan3 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan3);
                selectorConnection.addInput(netCircuitSpan3);
                break;
            }
            case 5: {
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block28: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addInput(list.get(n2));
                            continue;
                        }
                        selectorConnection.addInput(list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(list2.get(n2));
                        continue;
                    }
                    int n7 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan : list3) {
                        if (n7 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block28;
                        }
                        if (i == 1) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block28;
                        }
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block28;
                    }
                }
                break;
            }
            case 4: {
                linkedList.addAll(this.setupConnListOnDiscoveryOfBridge(objectArray, netCircuitEndArray));
                break;
            }
            case 2: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block30: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 2) continue;
                        bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                        selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 2) continue;
                        bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n8 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan : list3) {
                        if (n8 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            selectorConnection.addInput(netCircuitSpan);
                            continue block30;
                        }
                        if (i != 2) continue block30;
                        bridgeConnection.addInput(netCircuitSpan);
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block30;
                    }
                }
                break;
            }
            case 3: {
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList.add(selectorConnection);
                SelectorConnection selectorConnection2 = new SelectorConnection("selector2");
                linkedList.add(selectorConnection2);
                block32: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                            selectorConnection2.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 2 && i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                        selectorConnection2.addOutput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            selectorConnection2.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 2 && i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                        selectorConnection2.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n9 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan : list3) {
                        if (n9 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput(netCircuitSpan);
                            selectorConnection2.addInput(netCircuitSpan);
                            continue block32;
                        }
                        if (i != 2 && i != 3) continue block32;
                        selectorConnection.addInput(netCircuitSpan);
                        selectorConnection2.addOutput(netCircuitSpan);
                        continue block32;
                    }
                }
                break;
            }
            case 10: {
                NetCircuitSpan netCircuitSpan4;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                linkedList.add(onewayConnection);
                for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            onewayConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                        onewayConnection.addInput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            onewayConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                        onewayConnection.addInput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n10 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan4 : list3) {
                        if (n10 != netCircuitSpan4.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan4.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan4.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan4);
                            onewayConnection.addOutput(netCircuitSpan4);
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan4);
                            selectorConnection.addInput(netCircuitSpan4);
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput(netCircuitSpan4);
                        onewayConnection.addInput(netCircuitSpan4);
                    }
                }
                netCircuitSpan4 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan4);
                selectorConnection.addInput(netCircuitSpan4);
                break;
            }
            case 11: {
                NetCircuitSpan netCircuitSpan5;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList.add(bridgeConnection);
                BridgeConnection bridgeConnection3 = new BridgeConnection("bridge2");
                linkedList.add(bridgeConnection3);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList.add(selectorConnection);
                SelectorConnection selectorConnection3 = new SelectorConnection("selector2");
                linkedList.add(selectorConnection3);
                for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            selectorConnection3.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection3.addInput((NetCircuitEnd)list.get(n2));
                            selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        bridgeConnection3.addOutput((NetCircuitEnd)list.get(n2));
                        selectorConnection3.addInput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            selectorConnection3.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection3.addInput((NetCircuitEnd)list2.get(n2));
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        bridgeConnection3.addOutput((NetCircuitEnd)list2.get(n2));
                        selectorConnection3.addInput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n11 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan5 : list3) {
                        if (n11 != netCircuitSpan5.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan5.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan5.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan5);
                            selectorConnection3.addOutput(netCircuitSpan5);
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan5);
                            selectorConnection.addInput(netCircuitSpan5);
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan5);
                            bridgeConnection3.addInput(netCircuitSpan5);
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection3.addInput(netCircuitSpan5);
                        bridgeConnection3.addOutput(netCircuitSpan5);
                    }
                }
                netCircuitSpan5 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan5);
                selectorConnection.addInput(netCircuitSpan5);
                netCircuitSpan5 = new InternalCircuitSpan(bridgeConnection3, selectorConnection3);
                bridgeConnection3.addOutput(netCircuitSpan5);
                selectorConnection3.addInput(netCircuitSpan5);
                break;
            }
            case 15: {
                NetCircuitSpan netCircuitSpan6;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block38: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 3) {
                            selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i < 4) continue;
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n12 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan6 : list3) {
                        if (n12 != netCircuitSpan6.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan6.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan6.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan6);
                            continue block38;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan6);
                            continue block38;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan6);
                            continue block38;
                        }
                        if (i == 3) {
                            selectorConnection.addInput(netCircuitSpan6);
                            continue block38;
                        }
                        if (i < 4) continue block38;
                        selectorConnection.addOutput(netCircuitSpan6);
                        continue block38;
                    }
                }
                netCircuitSpan6 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan6);
                selectorConnection.addInput(netCircuitSpan6);
                break;
            }
            case 16: {
                NetCircuitSpan netCircuitSpan7;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                linkedList.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                linkedList.add(onewayConnection);
                block40: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addOutput((NetCircuitEnd)list.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            onewayConnection.addInput((NetCircuitEnd)list.get(n2));
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            onewayConnection.addInput((NetCircuitEnd)list2.get(n2));
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i < 4) continue;
                        selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n13 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan7 : list3) {
                        if (n13 != netCircuitSpan7.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan7.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan7.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addOutput(netCircuitSpan7);
                            bridgeConnection.addInput(netCircuitSpan7);
                            continue block40;
                        }
                        if (i == 1) {
                            onewayConnection.addInput(netCircuitSpan7);
                            bridgeConnection.addOutput(netCircuitSpan7);
                            continue block40;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan7);
                            continue block40;
                        }
                        if (i == 3) {
                            selectorConnection.addInput(netCircuitSpan7);
                            continue block40;
                        }
                        if (i < 4) continue block40;
                        selectorConnection.addOutput(netCircuitSpan7);
                        continue block40;
                    }
                }
                netCircuitSpan7 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan7);
                selectorConnection.addInput(netCircuitSpan7);
                break;
            }
            case 13: {
                NetCircuitSpan netCircuitSpan8;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList.add(bridgeConnection);
                BridgeConnection bridgeConnection4 = new BridgeConnection("bridge2");
                linkedList.add(bridgeConnection4);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                linkedList.add(selectorConnection);
                SelectorConnection selectorConnection4 = new SelectorConnection("selector2");
                linkedList.add(selectorConnection4);
                block42: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput((NetCircuitEnd)list.get(n2));
                            selectorConnection4.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection4.addInput((NetCircuitEnd)list.get(n2));
                        bridgeConnection4.addOutput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput((NetCircuitEnd)list2.get(n2));
                            selectorConnection4.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection4.addInput((NetCircuitEnd)list2.get(n2));
                        bridgeConnection4.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n14 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan8 : list3) {
                        if (n14 != netCircuitSpan8.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan8.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan8.prettyString());
                        }
                        if (i == 0) {
                            selectorConnection.addOutput(netCircuitSpan8);
                            bridgeConnection.addInput(netCircuitSpan8);
                            continue block42;
                        }
                        if (i == 1) {
                            selectorConnection.addInput(netCircuitSpan8);
                            bridgeConnection.addOutput(netCircuitSpan8);
                            continue block42;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput(netCircuitSpan8);
                            selectorConnection4.addOutput(netCircuitSpan8);
                            continue block42;
                        }
                        if (i != 3) continue block42;
                        selectorConnection4.addInput(netCircuitSpan8);
                        bridgeConnection4.addOutput(netCircuitSpan8);
                        continue block42;
                    }
                }
                netCircuitSpan8 = new InternalCircuitSpan(bridgeConnection, selectorConnection4);
                bridgeConnection.addOutput(netCircuitSpan8);
                selectorConnection4.addInput(netCircuitSpan8);
                netCircuitSpan8 = new InternalCircuitSpan(bridgeConnection4, selectorConnection);
                bridgeConnection4.addOutput(netCircuitSpan8);
                selectorConnection.addInput(netCircuitSpan8);
                break;
            }
            case 14: {
                NetCircuitSpan netCircuitSpan9;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                linkedList.add(bridgeConnection);
                BridgeConnection bridgeConnection5 = new BridgeConnection("bridge2");
                linkedList.add(bridgeConnection5);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                linkedList.add(selectorConnection);
                block44: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (list.indexOf(netCircuitEnd) != -1) {
                        n2 = list.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection5.addOutput((NetCircuitEnd)list.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput((NetCircuitEnd)list.get(n2));
                            selectorConnection.addOutput((NetCircuitEnd)list.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list.get(n2));
                        bridgeConnection5.addOutput((NetCircuitEnd)list.get(n2));
                        continue;
                    }
                    if (list2.indexOf(netCircuitEnd) != -1) {
                        n2 = list2.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection5.addOutput((NetCircuitEnd)list2.get(n2));
                            bridgeConnection.addInput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput((NetCircuitEnd)list2.get(n2));
                            selectorConnection.addOutput((NetCircuitEnd)list2.get(n2));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)list2.get(n2));
                        bridgeConnection5.addOutput((NetCircuitEnd)list2.get(n2));
                        continue;
                    }
                    int n15 = this.node.getEntityIndexFromPathDef(objectArray[i]);
                    IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
                    for (NetCircuitSpan netCircuitSpan9 : list3) {
                        if (n15 != netCircuitSpan9.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan9.getHoNum(iNetElement))) continue;
                        if (ConnectionsFactory.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan9.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection5.addOutput(netCircuitSpan9);
                            bridgeConnection.addInput(netCircuitSpan9);
                            continue block44;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan9);
                            continue block44;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput(netCircuitSpan9);
                            selectorConnection.addOutput(netCircuitSpan9);
                            continue block44;
                        }
                        if (i != 3) continue block44;
                        selectorConnection.addInput(netCircuitSpan9);
                        bridgeConnection5.addOutput(netCircuitSpan9);
                        continue block44;
                    }
                }
                netCircuitSpan9 = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan9);
                selectorConnection.addInput(netCircuitSpan9);
                break;
            }
            default: {
                if (!ConnectionsFactory.dbgOn()) break;
                db.println("unknown connection type " + EnumStrings.getString(IConnectionType.class, (int)n));
            }
        }
        ConnectionsFactory.prettyPrintConnectionList(db, n, linkedList, this.node.getName());
        return linkedList;
    }

    private List setupConnListOnDiscoveryOfBridge(Object[] objectArray, NetCircuitEnd[] netCircuitEndArray) {
        NetCircuitEnd netCircuitEnd = null;
        int n = -1;
        INetElement iNetElement = this.node.getNetElement();
        int n2 = this.node.getConnectionType();
        LinkedList<BridgeConnection> linkedList = new LinkedList<BridgeConnection>();
        List list = this.node.getSources();
        List list2 = this.node.getDrops();
        List list3 = this.node.getAllSpansList();
        BridgeConnection bridgeConnection = new BridgeConnection("bridge");
        linkedList.add(bridgeConnection);
        for (int i = 0; i < objectArray.length; ++i) {
            netCircuitEnd = netCircuitEndArray[i];
            if (!(list.indexOf(netCircuitEnd) == -1 || bridgeConnection.isInput(netCircuitEnd) && list2.contains(netCircuitEnd))) {
                n = list.indexOf(netCircuitEnd);
                bridgeConnection.addInput(list.get(n));
                continue;
            }
            if (list2.indexOf(netCircuitEnd) != -1) {
                n = list2.indexOf(netCircuitEnd);
                bridgeConnection.addOutput(list2.get(n));
                continue;
            }
            int n3 = this.node.getEntityIndexFromPathDef(objectArray[i]);
            IHoNum iHoNum = this.node.getHoNumFromPathDef(objectArray[i]);
            for (NetCircuitSpan netCircuitSpan : list3) {
                if (n3 != netCircuitSpan.getEntityIndex(iNetElement) || !HoLoComparator.instance().isEqual(iHoNum, netCircuitSpan.getHoNum(iNetElement))) continue;
                if (ConnectionsFactory.dbgOn()) {
                    db.println("Found span for path def " + netCircuitSpan.prettyString());
                }
                if (n2 == 4 && i == 2 || (n2 == 0 || n2 == 9) && i == 0) {
                    bridgeConnection.addInput(netCircuitSpan);
                    continue;
                }
                bridgeConnection.addOutput(netCircuitSpan);
            }
        }
        return linkedList;
    }

    protected static void setupConnList(NetCircuitNode netCircuitNode, int n) {
        if (netCircuitNode.getState() == 0) {
            netCircuitNode.setupConnListOnCreation(n);
        } else if (netCircuitNode.getState() == 3) {
            if (netCircuitNode.getConnectionType() != n) {
                netCircuitNode.setupConnListOnCreation(n);
            } else {
                netCircuitNode.addRoutedOutputsToConnList(n);
            }
        }
    }

    protected List addRoutedOutputsToConnList(int n) {
        BridgeConnection[] bridgeConnectionArray = new BridgeConnection[3];
        SelectorConnection[] selectorConnectionArray = new SelectorConnection[3];
        OnewayConnection[] onewayConnectionArray = new OnewayConnection[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (ConnectionsFactory.dbgOn()) {
            db.println("addRoutedOutputsToConnList: deconstructing a " + EnumStrings.getString(IConnectionType.class, (int)n) + " on node " + this.node.getName());
        }
        LinkedList<BridgeConnection> linkedList = new LinkedList<BridgeConnection>();
        linkedList.addAll(this.node.getConnections());
        for (Connection connection : linkedList) {
            if (connection instanceof BridgeConnection) {
                bridgeConnectionArray[n2++] = (BridgeConnection)connection;
                continue;
            }
            if (connection instanceof SelectorConnection) {
                selectorConnectionArray[n3++] = (SelectorConnection)connection;
                continue;
            }
            if (!(connection instanceof OnewayConnection)) continue;
            onewayConnectionArray[n4++] = (OnewayConnection)connection;
        }
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.node.getRoutedOrigSpans());
        linkedList2.addAll(this.node.getRoutedDrops());
        switch (n) {
            case 0: 
            case 9: {
                if (n4 == 1) {
                    bridgeConnectionArray[0] = new BridgeConnection("bridge");
                    n2 = 1;
                    bridgeConnectionArray[0].addInput(onewayConnectionArray[0].getInputs().get(0));
                    bridgeConnectionArray[0].addOutput(onewayConnectionArray[0].getOutputs().get(0));
                    linkedList.remove(onewayConnectionArray[0]);
                    linkedList.add(bridgeConnectionArray[0]);
                }
                if (n2 != 1) break;
                for (int i = 0; i < linkedList2.size(); ++i) {
                    bridgeConnectionArray[0].addOutput(linkedList2.get(i));
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                if (n3 != 1) break;
                for (int i = 0; i < linkedList2.size(); ++i) {
                    selectorConnectionArray[0].addOutput(linkedList2.get(i));
                }
                break;
            }
        }
        ConnectionsFactory.prettyPrintConnectionList(db, n, linkedList, this.node.getName());
        return linkedList;
    }

    private static void removeOutputFromConnList(NetCircuitNode netCircuitNode, Object object) {
        if (ConnectionsFactory.dbgOn()) {
            db.println("removeOutputFromConnList: called for a " + EnumStrings.getString(IConnectionType.class, (int)netCircuitNode.getConnectionType()) + " on node " + netCircuitNode.getName());
        }
        LinkedList<OnewayConnection> linkedList = new LinkedList<OnewayConnection>();
        linkedList.addAll(netCircuitNode.getConnections());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            List list = connection.getOutputs();
            int n = list.size();
            if (!list.contains(object)) continue;
            connection.removeOutput(object);
            if (--n != 1 || !(connection instanceof BridgeConnection)) break;
            OnewayConnection onewayConnection = new OnewayConnection("oneway");
            onewayConnection.addInput(connection.getInputs().get(0));
            onewayConnection.addOutput(connection.getOutputs().get(0));
            iterator.remove();
            linkedList.add(onewayConnection);
            break;
        }
        ConnectionsFactory.prettyPrintConnectionList(db, netCircuitNode.getConnectionType(), linkedList, netCircuitNode.getName());
        netCircuitNode.setConnections(linkedList);
    }

    protected static void prettyPrintConnectionList(SDebug sDebug, int n, List list, String string) {
        if (!sDebug.on() && !NetCircuitManager.pkgDbgOn()) {
            return;
        }
        if (!((Object)((Object)db)).equals((Object)sDebug)) {
            sDebug.println("      node: " + string);
            sDebug.println("connection: " + EnumStrings.getString(IConnectionType.class, (int)n));
        }
        for (Object e : list) {
            if (e instanceof BridgeConnection) {
                sDebug.println(" primitive: BridgeConnection");
            } else if (e instanceof SelectorConnection) {
                sDebug.println(" primitive: SelectorConnection");
            } else if (e instanceof OnewayConnection) {
                sDebug.println(" primitive: OnewayConnection");
            }
            ((Connection)e).prettyString(sDebug);
        }
    }
}

