/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.IDataNetworkManager;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.RPRDeletedException;
import cerent.cms.ncp.RPRException;
import cerent.cms.ncp.RPRInfo;
import cerent.cms.ncp.RPRTraceDelegate;
import cerent.util.IDebugDiag;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataNetworkManager
extends CmsObservable
implements IDataNetworkManager,
IObserver {
    private static final SDebug db = new SDebug("DataNetworkManager");
    public DumpDebug dumpDb;
    private LinkedList rprInfoList = new LinkedList();
    private INetCircuit rprCkt;
    private List cktList = new ArrayList();
    private static int instanceId = 0;

    public DataNetworkManager() {
        ++instanceId;
        this.init();
    }

    protected void init() {
        this.dumpDb = new DumpDebug("RPR_" + instanceId);
    }

    public LinkedList getRprList() {
        return this.rprInfoList;
    }

    public LinkedList getRPRRing() throws RPRException {
        return this.getRPRRing(this.rprCkt);
    }

    public LinkedList getRPRRing(INetCircuit iNetCircuit) throws RPRException {
        Object object;
        this.deregister();
        if (this.rprCkt != iNetCircuit) {
            this.rprCkt = iNetCircuit;
        }
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        if (this.rprCkt == null || !this.rprCkt.isCircuitRefValid()) {
            object = this.cktList.iterator();
            boolean bl = false;
            while (!bl && object.hasNext()) {
                INetCircuit iNetCircuit2 = (INetCircuit)object.next();
                if (iNetCircuit2 == null || iNetCircuit2 == this.rprCkt || !iNetCircuit2.isCircuitRefValid()) continue;
                this.rprCkt = iNetCircuit2;
                bl = true;
            }
            if (!bl) {
                throw new RPRDeletedException("The RPR Topology has been deleted. The topology window will now be closed.");
            }
        }
        this.cktList.clear();
        object = new RPRTraceDelegate(netCircuitManager, this.rprCkt, db);
        this.rprInfoList = ((RPRTraceDelegate)object).getRPRTrace();
        ArrayList arrayList = ((RPRTraceDelegate)object).getAllCircuitsInRPR();
        this.register(arrayList);
        this.cktList.addAll(arrayList);
        return this.rprInfoList;
    }

    private void register(ArrayList arrayList) {
        for (INetCircuit iNetCircuit : arrayList) {
            iNetCircuit.addObserver(this);
        }
    }

    private void deregister() {
        for (INetCircuit iNetCircuit : this.cktList) {
            if (iNetCircuit == null) continue;
            iNetCircuit.deleteObserver(this);
        }
    }

    public synchronized void update(IObservable iObservable, Object object) {
        INetCircuit iNetCircuit = null;
        Integer n = null;
        if (iObservable instanceof INetCircuit) {
            iNetCircuit = (INetCircuit)iObservable;
        }
        if (object instanceof Integer) {
            n = (Integer)object;
        }
        if (iNetCircuit == null || n == null) {
            return;
        }
        if (db.on()) {
            db.println("Update Circuit : " + iNetCircuit.getCircuitName());
            db.println("Update type : " + n.toString());
        }
        if (n.equals(ModelUpdateType.CHANGED) || n.equals(ModelUpdateType.DELETED)) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public void dispose() {
        this.deregister();
        this.cktList.clear();
        this.rprCkt = null;
        this.rprInfoList.clear();
        this.dumpDb.dispose();
    }

    public class DumpDebug
    extends SDebug
    implements IDebugDiag {
        public DumpDebug(String string) {
            super(string);
        }

        public void dumpDiag() {
            this.dump();
        }

        public final void dump() {
            if (!db.on()) {
                db.set();
            }
            Iterator iterator = DataNetworkManager.this.rprInfoList.iterator();
            db.println("================RPR Entity Dump================");
            db.println("RPRInfo List Size : " + DataNetworkManager.this.rprInfoList.size());
            db.println("================================");
            while (iterator.hasNext()) {
                RPRInfo rPRInfo = (RPRInfo)iterator.next();
                db.println(rPRInfo.toString());
                db.println("================================");
            }
            db.println("================RPR Entity Dump================");
        }
    }
}

