/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionHasFarendLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DriNodeTypeOpt;
import cerent.cms.model.DuplicateCircuit;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoMoreEtherBandwidth;
import cerent.cms.model.NoMoreEtherCircuit;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoMoreSpanningTree;
import cerent.cms.model.NoSuchCircuit;
import cerent.cms.model.NoSuchVlan;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.SelectorAttrsOpt;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.VlanSpanningTreeViolation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.EtherP2PCircuitEnd;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.vlan.IoError;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HoCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("HoCircuitNodeOperator");
    private static final int BERT_TPGMB = 2;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public HoCircuitNodeOperator(HoCircuitNode hoCircuitNode) {
        super(hoCircuitNode);
    }

    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        ICircuitType iCircuitType = netCcatCircuit.getCircuitTypeObj();
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(iCircuitId));
        }
        try {
            if (iCircuitType.isHoCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType()) {
                this.createConnection(iCircuitId);
            } else if (iCircuitType.isEthernetCircuitType()) {
                this.createEtherConnection(iCircuitId);
            }
        }
        catch (CTCUserException cTCUserException) {
            if (HoCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "A connection cannot be created on " + this.getName() + ".";
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n" + this.getNoLoCapableHoMessage() + " on " + this.getName();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            } else if (cTCUserException instanceof InsufficientBandwidth) {
                string = string + "\nThe bandwidth is insufficient.";
            } else if (cTCUserException instanceof PathNotSupported) {
                string = string + "\nThe path is not supported.";
            } else if (cTCUserException instanceof InvalidState) {
                string = string + "\nThe administrative state is invalid.";
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (HoCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "A connection cannot be created on " + this.getName() + ".";
            string = string + "\n" + adminStateProvisioningError.getMessage();
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (HoCircuitNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError("An error occurred while creating a connection object on " + this.getName() + ".");
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, InsufficientBandwidth, NoMoreLoCapableHo, ConnectionTypeError, ObjNotFound, InvalidState, AdminStateProvisioningError {
        this.prettyPrint(arrayList.toArray(new IHoPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IHoPathDefModel[0]), "output");
        this.prettyPrint(arrayList3.toArray(new IHoPathDefModel[0]), "omni");
        IHoPathDefModel[][] iHoPathDefModelArrayArray = new IHoPathDefModel[][]{arrayList.toArray(new IHoPathDefModel[0]), arrayList2.toArray(new IHoPathDefModel[0]), arrayList3.toArray(new IHoPathDefModel[0])};
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        int[] nArray = new int[arrayList4.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList4.get(i);
        }
        boolean[] blArray = new boolean[arrayList5.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)arrayList5.get(i);
        }
        IHoConnectionModel iHoConnectionModel = this.createHoConnOnNE(iCircuitId, iHoPathDefModelArrayArray, n, n2, nArray, blArray);
        if (iHoConnectionModel == null) {
            return;
        }
        if (netCcatCircuit.getVlans().length == 0) {
            return;
        }
        for (EtherP2PCircuitEnd etherP2PCircuitEnd : ((HoCircuitNode)this.node).getP2pEtherCktEnd()) {
            boolean bl = false;
            if (HoCircuitNodeOperator.dbgOn()) {
                db.println("circuit.createWithStpEnabled() = " + netCcatCircuit.createWithStpEnabled());
            }
            if (netCcatCircuit.createWithStpEnabled()) {
                block36: {
                    try {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("creating circuit with STP enabled ");
                        }
                        etherP2PCircuitEnd.createEtherBridge(iCircuitId, netCcatCircuit.getVlans());
                        iHoConnectionModel.setStpEnabled(true);
                    }
                    catch (CTCUserException cTCUserException) {
                        bl = true;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        bl = true;
                    }
                    if (!bl) continue;
                    try {
                        this.destroyCrossConnection();
                    }
                    catch (ConnectionInTestAccess connectionInTestAccess) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConectionInTestAccess destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInTestAccess);
                        }
                    }
                    catch (ConnectionInRoll connectionInRoll) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInRoll destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInRoll);
                        }
                    }
                    catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInTopologyUpgrade destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                        }
                    }
                    catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("VcatMemberNotOutOfGroup destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                        }
                    }
                    catch (VcatMemberInvalidState vcatMemberInvalidState) {
                        if (!HoCircuitNodeOperator.dbgOn()) break block36;
                        db.println("VcatMemberInvalidState destroying a connection in createHoConnection.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                throw new CircuitProvError("VLANs cannot be created for the circuit on " + this.getName() + ".");
            }
            try {
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("attempting to disable STP");
                }
                etherP2PCircuitEnd.createEtherBridge(iCircuitId, new IVlanModel[0]);
                iHoConnectionModel.setStpEnabled(false);
            }
            catch (CTCUserException cTCUserException) {
                bl = true;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                bl = true;
            }
            if (bl) {
                block37: {
                    try {
                        this.destroyCrossConnection();
                    }
                    catch (ConnectionInTestAccess connectionInTestAccess) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConectionInTestAccess destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInTestAccess);
                        }
                    }
                    catch (ConnectionInRoll connectionInRoll) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInRoll destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInRoll);
                        }
                    }
                    catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("ConnectionInTopologyUpgrade destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                        }
                    }
                    catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("VcatMemberNotOutOfGroup destroying a connection in createHoConnection.");
                            SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                        }
                    }
                    catch (VcatMemberInvalidState vcatMemberInvalidState) {
                        if (!HoCircuitNodeOperator.dbgOn()) break block37;
                        db.println("VcatMemberInvalidState destroying a connection in createHoConnection.");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                throw new CircuitProvError("VLANs cannot be created for the circuit on " + this.getName() + ".");
            }
            etherP2PCircuitEnd.changeVlanSet(iCircuitId, netCcatCircuit.getVlans());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHoConnectionModel createHoConnOnNE(ICircuitId iCircuitId, IHoPathDefModel[][] iHoPathDefModelArray, int n, int n2, int[] nArray, boolean[] blArray) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, ConnectionTypeError, ObjNotFound, InvalidState, InsufficientBandwidth, AdminStateProvisioningError {
        IHoPathDefModel[] iHoPathDefModelArray2 = iHoPathDefModelArray[0];
        IHoPathDefModel[] iHoPathDefModelArray3 = iHoPathDefModelArray[1];
        IHoPathDefModel[] iHoPathDefModelArray4 = iHoPathDefModelArray[2];
        IHoPathDefModel[] iHoPathDefModelArray5 = null;
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        int n3 = this.node.getConnectionType();
        String string = this.node.getConnName();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("createHoConnOnNE:connType=" + EnumStrings.getString(IConnectionType.class, (int)n3) + " numIn: " + n + " numOut: " + n2 + " numOmni: " + iHoPathDefModelArray4.length + " (" + this.getName() + ")");
        }
        if (!this.node.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.node.getAdminState()) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("The node " + this.getName() + " does not support the circuit state " + NetCircuitNode.translateAdminState(this.node.getAdminState()) + ". Use the circuit state " + NetCircuitNode.translateAdminState(0) + " instead.");
        }
        IHoConnectionModel iHoConnectionModel = null;
        INetElement iNetElement = this.node.getNetElement();
        IHoUpsrAttributes iHoUpsrAttributes = this.node.getUpsrAttributes();
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.node.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(string);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        connCreateAttrs.setSelectorAttrsOpt(null);
        DriNodeTypeOpt driNodeTypeOpt = new DriNodeTypeOpt(this.node.driNodeType);
        connCreateAttrs.setDriNodeTypeOpt(driNodeTypeOpt);
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            block65: {
                block80: {
                    block79: {
                        block78: {
                            block77: {
                                block76: {
                                    block73: {
                                        block74: {
                                            block66: {
                                                block75: {
                                                    block72: {
                                                        block71: {
                                                            block70: {
                                                                block69: {
                                                                    block68: {
                                                                        block67: {
                                                                            NetCircuitSpan netCircuitSpan;
                                                                            if (n3 != 0) break block67;
                                                                            int n4 = 1 + iHoPathDefModelArray3.length + iHoPathDefModelArray4.length;
                                                                            iHoPathDefModelArray5 = new IHoPathDefModel[n4];
                                                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                            if (iHoPathDefModelArray3.length == 2 && (netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[1])) != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                                                                IHoPathDefModel iHoPathDefModel = iHoPathDefModelArray3[1];
                                                                                iHoPathDefModelArray3[1] = iHoPathDefModelArray3[0];
                                                                                iHoPathDefModelArray3[0] = iHoPathDefModel;
                                                                            }
                                                                            System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 1, iHoPathDefModelArray3.length);
                                                                            System.arraycopy(iHoPathDefModelArray4, 0, iHoPathDefModelArray5, iHoPathDefModelArray3.length + 1, iHoPathDefModelArray4.length);
                                                                            break block65;
                                                                        }
                                                                        if (n3 != 9) break block68;
                                                                        int n5 = 1 + iHoPathDefModelArray3.length;
                                                                        iHoPathDefModelArray5 = new IHoPathDefModel[n5];
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                        System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 1, iHoPathDefModelArray3.length);
                                                                        break block65;
                                                                    }
                                                                    if (n3 != 1) break block69;
                                                                    iHoPathDefModelArray5 = new IHoPathDefModel[2];
                                                                    if (iHoPathDefModelArray4.length == 2) {
                                                                        if (HoCircuitNodeOperator.dbgOn()) {
                                                                            db.println("DRI circuit: invoking createTwoWay");
                                                                        }
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray4[0];
                                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                                                        break block65;
                                                                    } else {
                                                                        if (HoCircuitNodeOperator.dbgOn()) {
                                                                            db.println("InputPathWidth=" + iHoPathDefModelArray2[0].getPathWidth() + ", OutputPathWidth=" + iHoPathDefModelArray3[0].getPathWidth() + " (" + this.getName() + ")");
                                                                        }
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                                                                    }
                                                                    break block65;
                                                                }
                                                                if (n3 != 2) break block70;
                                                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                                selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                                iHoPathDefModelArray5 = new IHoPathDefModel[3];
                                                                MemberPrefs memberPrefs = netCcatCircuit.getMemberPrefs();
                                                                if (memberPrefs.isBlsrDriNode(iNetElement)) {
                                                                    if (iHoPathDefModelArray2.length == 2) {
                                                                        this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray2);
                                                                    } else if (iHoPathDefModelArray3.length == 2) {
                                                                        this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray3);
                                                                    }
                                                                }
                                                                if (n == 2) {
                                                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray2[1];
                                                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                                                    break block65;
                                                                } else {
                                                                    if (n2 != 2) {
                                                                        if (!HoCircuitNodeOperator.dbgOn()) return null;
                                                                        db.println("Warning! createHoConnection: bad UPSR case");
                                                                        return null;
                                                                    }
                                                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                                                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                                                }
                                                                break block65;
                                                            }
                                                            if (n3 != 4) break block71;
                                                            iHoPathDefModelArray5 = new IHoPathDefModel[]{iHoPathDefModelArray3[0], iHoPathDefModelArray3[1], iHoPathDefModelArray2[0]};
                                                            break block65;
                                                        }
                                                        if (n3 != 3) break block72;
                                                        SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                        selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                                        connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                        iHoPathDefModelArray5 = new IHoPathDefModel[]{iHoPathDefModelArray2[0], iHoPathDefModelArray2[1], iHoPathDefModelArray3[0], iHoPathDefModelArray3[1]};
                                                        break block65;
                                                    }
                                                    if (n3 != 6) break block73;
                                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                    MemberPrefs memberPrefs = netCcatCircuit.getMemberPrefs();
                                                    if (memberPrefs.isBlsrDriNode(iNetElement)) {
                                                        if (iHoPathDefModelArray2.length == 2) {
                                                            this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray2);
                                                        } else if (iHoPathDefModelArray3.length == 2) {
                                                            this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray3);
                                                        }
                                                    }
                                                    int n6 = 2 + iHoPathDefModelArray3.length;
                                                    iHoPathDefModelArray5 = new IHoPathDefModel[n6];
                                                    if (iHoPathDefModelArray4.length <= 0) break block74;
                                                    if (iHoPathDefModelArray4.length != 2) break block75;
                                                    if (blArray[1] && !blArray[0]) {
                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                                        System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 2, iHoPathDefModelArray3.length);
                                                        break block66;
                                                    } else if (blArray[0] && !blArray[1]) {
                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                                        System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 2, iHoPathDefModelArray3.length);
                                                        break block66;
                                                    } else {
                                                        if (!HoCircuitNodeOperator.dbgOn()) return null;
                                                        db.println("Error: Both omnispans cannot be in the source ring");
                                                        return null;
                                                    }
                                                }
                                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                                System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 2, iHoPathDefModelArray3.length);
                                            }
                                            if (HoCircuitNodeOperator.dbgOn()) {
                                                db.println("Unidir DRI circuit: UPSR_DC");
                                            }
                                            break block65;
                                        }
                                        if (nArray.length == 2 && nArray[0] > nArray[1]) {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray2[0];
                                            System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 2, iHoPathDefModelArray3.length);
                                            break block65;
                                        } else {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray2[1];
                                            System.arraycopy(iHoPathDefModelArray3, 0, iHoPathDefModelArray5, 2, iHoPathDefModelArray3.length);
                                        }
                                        break block65;
                                    }
                                    if (n3 != 10) break block76;
                                    if (HoCircuitNodeOperator.dbgOn()) {
                                        db.println("createUpsrDri(), omniSize=" + iHoPathDefModelArray4.length + " inSize=" + iHoPathDefModelArray2.length + " outSize=" + iHoPathDefModelArray3.length);
                                    }
                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                    iHoPathDefModelArray5 = new IHoPathDefModel[3];
                                    MemberPrefs memberPrefs = netCcatCircuit.getMemberPrefs();
                                    if (memberPrefs.isBlsrDriNode(iNetElement)) {
                                        NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                            break block65;
                                        } else {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                        }
                                        break block65;
                                    } else if (!blArray[0]) {
                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                        break block65;
                                    } else {
                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    }
                                    break block65;
                                }
                                if (n3 != 11) break block77;
                                if (HoCircuitNodeOperator.dbgOn()) {
                                    db.println("invoking createUpsrIdri()");
                                }
                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                iHoPathDefModelArray5 = new IHoPathDefModel[4];
                                if (blArray[1] && !blArray[0]) {
                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    iHoPathDefModelArray5[3] = iHoPathDefModelArray4[0];
                                    break block65;
                                } else if (blArray[0] && !blArray[1]) {
                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    iHoPathDefModelArray5[3] = iHoPathDefModelArray4[1];
                                    break block65;
                                } else {
                                    if (!HoCircuitNodeOperator.dbgOn()) return null;
                                    db.println("Error: Both omnispans cannot be in the source ring");
                                    return null;
                                }
                            }
                            if (n3 != 13) break block78;
                            if (HoCircuitNodeOperator.dbgOn()) {
                                db.println("creating BLSR_IDRI connection");
                            }
                            SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                            selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                            connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                            iHoPathDefModelArray5 = new IHoPathDefModel[4];
                            NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                            if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                                iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                            } else {
                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                            }
                            netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[1]);
                            if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                                iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                break block65;
                            } else {
                                iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                                iHoPathDefModelArray5[2] = iHoPathDefModelArray3[1];
                            }
                            break block65;
                        }
                        if (n3 != 15) break block79;
                        if (HoCircuitNodeOperator.dbgOn()) {
                            db.println("creating BLSR_DC connection");
                        }
                        SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                        selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                        connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                        iHoPathDefModelArray5 = new IHoPathDefModel[4];
                        NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                        if (netCircuitSpan == null && HoCircuitNodeOperator.dbgOn()) {
                            db.println("null span ");
                        }
                        if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                        }
                        netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                        if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[1];
                            break block65;
                        } else {
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        }
                        break block65;
                    }
                    if (n3 != 14) break block80;
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("creating UPSR_BLSR_IDRI connection");
                    }
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iHoPathDefModelArray5 = new IHoPathDefModel[4];
                    if (iHoPathDefModelArray2.length == 2) {
                        NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                            break block65;
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                        }
                        break block65;
                    } else {
                        NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[1];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray3[0];
                            break block65;
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray3[1];
                        }
                    }
                    break block65;
                }
                if (n3 != 16) {
                    if (!HoCircuitNodeOperator.dbgOn()) return null;
                    db.println("Circuit Node: createHoConnection Unknown connection type " + n3);
                    return null;
                }
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("creating UPSR_BLSR_DC connection");
                }
                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                selectorAttrsOpt.setHoUpsrAttributes(iHoUpsrAttributes);
                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                iHoPathDefModelArray5 = new IHoPathDefModel[4];
                if (iHoPathDefModelArray2.length == 2) {
                    NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                    } else {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                    }
                } else {
                    NetCircuitSpan netCircuitSpan = this.node.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[1];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray3[0];
                    } else {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray3[1];
                    }
                }
            }
            this.prettyPrint(iHoPathDefModelArray5, "path");
            iHoConnectionModel = iConnectionModels.createHoConnection(iCircuitId, n3, iHoPathDefModelArray5, (IConnCreateAttrs)connCreateAttrs);
            if (iHoConnectionModel == null) return iHoConnectionModel;
            this.node.setConn((IConnectionModel)iHoConnectionModel);
            if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) return iHoConnectionModel;
            this.node.registerNullCircuitConnection(iNetElement, iHoConnectionModel);
            return iHoConnectionModel;
        }
    }

    private void createEtherConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, CTCUserException, NoMoreLoCapableHo, NoMoreEtherBandwidth, InsufficientBandwidth, AdminStateProvisioningError {
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("createEtherConnection");
        }
        if (this.node.getAdminState() != 0) {
            throw new AdminStateProvisioningError("Stitched Ethernet circuits do not support the circuit state " + NetCircuitNode.translateAdminState(this.node.getAdminState()) + ".  Use the circuit state " + NetCircuitNode.translateAdminState(0) + " instead.");
        }
        if (this.node.getNodeDrop() == null) {
            this.createConnection(iCircuitId);
            return;
        }
        INetElement iNetElement = this.node.getNetElement();
        int n = 0;
        short s = this.node.getPathWidth();
        IHoConnectionModel iHoConnectionModel = null;
        IHoPathDefModel[] iHoPathDefModelArray = new IHoPathDefModel[this.node.getBiSpans().size()];
        for (NetCircuitSpan netCircuitSpan : this.node.getBiSpans()) {
            iHoPathDefModelArray[n++] = (IHoPathDefModel)netCircuitSpan.getPathDef(iNetElement, s);
        }
        if (n > 2) {
            if (HoCircuitNodeOperator.dbgOn()) {
                db.println("Warning! createEtherConnection: spans > 2");
            }
            throw new CircuitProvError("There is an invalid number of circuit spans on " + this.getName() + ".");
        }
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("Creating ether stitch at Node " + this.getName() + " number of spans = " + n);
        }
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("createEtherConnection:: pathWidth " + s);
        }
        if (n == 0) {
            iHoConnectionModel = iConnectionModels.ftgCreateEtherStitch(iCircuitId, s);
        } else if (n == 1) {
            iHoConnectionModel = iConnectionModels.createEtherStitchEnd(iCircuitId, iHoPathDefModelArray[0]);
        } else if (n == 2) {
            iHoConnectionModel = iConnectionModels.createEtherStitchThrough(iCircuitId, iHoPathDefModelArray[0], iHoPathDefModelArray[1]);
        }
        this.node.setConn((IConnectionModel)iHoConnectionModel);
        boolean bl = false;
        try {
            ((HoCircuitEnd)this.node.getNodeDrop()).createEtherBridge(iCircuitId, this.getCircuit().getVlans());
        }
        catch (CTCUserException cTCUserException) {
            bl = true;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
        }
        if (bl) {
            block27: {
                try {
                    this.destroyCrossConnection();
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (!HoCircuitNodeOperator.dbgOn()) break block27;
                    db.println("VcatMemberInvalidState destroying a connection in createEtherConnection.");
                    SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                }
            }
            throw new CircuitProvError("The VLANs for the circuit on " + this.getName() + " cannot be created.");
        }
    }

    protected void modifyConnection() throws CircuitProvError {
        super.modifyConnection();
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        NetCircuitEnd netCircuitEnd = this.node.getNodeDrop();
        if (this.node.getConnectionType() == 8 && netCircuitEnd != null && netCircuitEnd.getStage() == 2) {
            boolean bl = false;
            try {
                ((HoCircuitEnd)netCircuitEnd).createEtherBridge(iCircuitId, netCcatCircuit.getVlans());
            }
            catch (CTCUserException cTCUserException) {
                bl = true;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                bl = true;
            }
            if (bl) {
                block7: {
                    try {
                        this.deleteNodeDrop(netCircuitEnd);
                    }
                    catch (DeletionError deletionError) {
                        if (!HoCircuitNodeOperator.dbgOn()) break block7;
                        db.println("unable to reverse, circuit state may be incorrect due to " + deletionError.getMessage());
                    }
                }
                this.node.setState(2);
                throw new CircuitProvError("VLANs cannot be assigned to the circuit on " + this.getName() + ".");
            }
            netCircuitEnd.setStage(3);
        }
    }

    protected boolean hasMonitor() {
        IHoConnectionModel iHoConnectionModel;
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("hasMonitor at " + this.getName());
        }
        if (!this.node.hasConnection()) {
            return false;
        }
        return !this.node.getNetElement().getNodeModel().provides(Feature.NO_MONITORS) && this.node.getNetElement().getNodeModel().provides(Feature.CONN_HAS_MONITOR) && (iHoConnectionModel = (IHoConnectionModel)this.node.getConn()) != null && iHoConnectionModel.hasMonitor();
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        super.destroySanityCheck();
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("destroy sanity check at " + this.getName());
        }
        if (!this.node.hasConnection()) {
            return;
        }
        if (!this.node.getNetElement().getNodeModel().provides(Feature.NO_MONITORS) && this.node.getNetElement().getNodeModel().provides(Feature.CONN_HAS_MONITOR) && ((IHoConnectionModel)this.node.getConn()).hasMonitor()) {
            String string = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because one or more " + "monitor circuits are present. " + "Delete the monitor circuits and try again.";
            throw new SanityCheckFailed(string);
        }
        ICircuitId iCircuitId = this.node.getCircuitId();
        if (this.getConn() != null && (this.node.getConnTypeFromConnModel() == 8 || ((IHoConnectionModel)this.getConn()).isUnstitchedEthernet())) {
            if (this.node.isNodeDrop()) {
                ((EtherNodeDropCircuitEnd)this.node.getNodeDrop()).destroySanityCheck(iCircuitId);
            } else if (((HoCircuitNode)this.node).hasP2pEtherCktEnd()) {
                for (HoCircuitEnd hoCircuitEnd : ((HoCircuitNode)this.node).getP2pEtherCktEnd()) {
                    ((EtherP2PCircuitEnd)hoCircuitEnd).destroySanityCheck(iCircuitId);
                }
            }
        }
        if (((HoCircuitNode)this.node).hasYCircuits) {
            throw new SanityCheckFailed("A tunnel or aggregation circuit is in use.");
        }
        if (this.node.getNetElement().getNodeModel().provides(Feature.BERT)) {
            LinkedList linkedList = (LinkedList)this.node.getSources();
            LinkedList linkedList2 = (LinkedList)this.node.getDrops();
            linkedList.addAll(linkedList2);
            for (INetCircuitEnd iNetCircuitEnd : linkedList) {
                Object object;
                IPortModel iPortModel;
                IInterfaceModel iInterfaceModel;
                List list;
                block54: {
                    Object object2;
                    Object object3;
                    IPortModel iPortModel2;
                    IModuleModel iModuleModel;
                    block47: {
                        IHoNum iHoNum;
                        block46: {
                            iHoNum = iNetCircuitEnd.getHoNum();
                            iModuleModel = null;
                            try {
                                iModuleModel = iNetCircuitEnd.getEntityModel().getModuleModel();
                            }
                            catch (Exception exception) {
                                if (!HoCircuitNodeOperator.dbgOn()) break block46;
                                db.println("Exception while retrieving the Module Model ");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        iPortModel2 = null;
                        if (iModuleModel != null) {
                            try {
                                iPortModel2 = iModuleModel.getPortModelForPath((IEntityModel)iModuleModel, null, iHoNum);
                            }
                            catch (Exception exception) {
                                if (!HoCircuitNodeOperator.dbgOn()) break block47;
                                db.println("Exception while retrieving the Port Model from Path ");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                    }
                    int[] nArray = null;
                    if (iPortModel2 != null) {
                        nArray = iPortModel2.getPortNum();
                    }
                    if (iModuleModel != null && iModuleModel.getEqType() == 218) {
                        block48: {
                            list = null;
                            try {
                                list = ((IHoConnectionModel)this.node.getConn()).getPortModels();
                            }
                            catch (Exception exception) {
                                if (!HoCircuitNodeOperator.dbgOn()) break block48;
                                db.println("Exception while retrieving the Port Models ");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        if (list == null) continue;
                        object3 = list.iterator();
                        while (object3.hasNext()) {
                            int n;
                            block50: {
                                block49: {
                                    iInterfaceModel = null;
                                    iPortModel = (IPortModel)object3.next();
                                    int[] nArray2 = iPortModel.getPortNum();
                                    if ((nArray[0] != 1 || nArray2[0] < 1 || nArray2[0] > 28) && (nArray[0] != 29 || nArray2[0] < 29 || nArray2[0] > 56)) continue;
                                    try {
                                        iInterfaceModel = iPortModel.getInterfaceModel();
                                    }
                                    catch (Exception exception) {
                                        if (!HoCircuitNodeOperator.dbgOn()) break block49;
                                        db.println("Exception while retrieving the Interface Model ");
                                        SDebug.printStackTrace((Throwable)exception);
                                    }
                                }
                                if (!(iInterfaceModel instanceof IDs123LineModel)) continue;
                                object = (IDs123LineModel)iInterfaceModel;
                                n = 0;
                                try {
                                    if (object != null) {
                                        n = object.getBERTMode();
                                    }
                                }
                                catch (Exception exception) {
                                    if (!HoCircuitNodeOperator.dbgOn()) break block50;
                                    db.println("Exception while retrieving the BERT Mode :");
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (n != 2) continue;
                            object2 = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because  " + "BERT is enabled.\n";
                            throw new SanityCheckFailed((String)object2);
                        }
                        continue;
                    }
                    if (iModuleModel != null && iModuleModel.getEqType() == 145) {
                        block51: {
                            list = null;
                            object3 = null;
                            try {
                                list = (IHoConnectionModel)this.node.getConn();
                                object3 = list.getPortModels();
                            }
                            catch (Exception exception) {
                                if (!HoCircuitNodeOperator.dbgOn()) break block51;
                                db.println("Exception while retrieving the Port Models from HO Model ");
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        if (object3 == null) continue;
                        iInterfaceModel = object3.iterator();
                        while (iInterfaceModel.hasNext()) {
                            block52: {
                                iPortModel = (IPortModel)iInterfaceModel.next();
                                IInterfaceModel iInterfaceModel2 = null;
                                object = null;
                                try {
                                    iInterfaceModel2 = iPortModel.getInterfaceModel();
                                    object = iInterfaceModel2.getHigherLayerModelsForNet();
                                }
                                catch (Exception exception) {
                                    if (!HoCircuitNodeOperator.dbgOn()) break block52;
                                    db.println("Exception while retrieving the Higher Layer Models ");
                                    SDebug.printStackTrace((Throwable)exception);
                                }
                            }
                            if (object == null) continue;
                            for (int i = 0; i < ((IInterfaceModel[])object).length; ++i) {
                                int n;
                                block53: {
                                    if (!(object[i] instanceof IDs123LineModel)) continue;
                                    object2 = (IDs123LineModel)object[i];
                                    n = 0;
                                    try {
                                        if (object2 != null) {
                                            n = object2.getBERTMode();
                                        }
                                    }
                                    catch (Exception exception) {
                                        if (!HoCircuitNodeOperator.dbgOn()) break block53;
                                        db.println("Exception while getting the BERT mode");
                                        SDebug.printStackTrace((Throwable)exception);
                                    }
                                }
                                if (n != 2) continue;
                                String string = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because  " + "BERT is enabled .\n";
                                throw new SanityCheckFailed(string);
                            }
                        }
                        continue;
                    }
                    if (iModuleModel == null || iModuleModel.getEqType() != 233 && iModuleModel.getEqType() != 234) continue;
                    list = null;
                    object3 = (IHoConnectionModel)this.node.getConn();
                    try {
                        if (object3 != null) {
                            list = object3.getPortModels();
                        }
                    }
                    catch (Exception exception) {
                        if (!db.on()) break block54;
                        SDebug.printStackTrace((Throwable)exception);
                    }
                }
                if (list == null) continue;
                iInterfaceModel = list.iterator();
                while (iInterfaceModel.hasNext()) {
                    int n;
                    block56: {
                        block55: {
                            iPortModel = null;
                            try {
                                IPortModel iPortModel3 = (IPortModel)iInterfaceModel.next();
                                if (iPortModel3.getInterfaceModel() instanceof IDs123LineModel) {
                                    iPortModel = (IDs123LineModel)iPortModel3.getInterfaceModel();
                                }
                            }
                            catch (Exception exception) {
                                if (!HoCircuitNodeOperator.dbgOn()) break block55;
                                SDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        n = 0;
                        try {
                            if (iPortModel != null) {
                                n = iPortModel.getBERTMode();
                            }
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block56;
                            SDebug.printStackTrace((Throwable)exception);
                        }
                    }
                    if (n != 2) continue;
                    object = "The circuit " + this.node.getCircuit().getCircuitName() + " cannot be deleted because  " + "BERT is enabled .\n";
                    throw new SanityCheckFailed((String)object);
                }
            }
        }
    }

    protected void destroyConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, DeletionError, InvalidPath, WrongInterfaceType, ConnectionHasFarendLoopback {
        try {
            this.destroyEtherBridgeCkt();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw new DeletionError(sanityCheckFailed.getMessage());
        }
        super.destroyConnection();
    }

    private void destroyEtherBridgeCkt() throws SanityCheckFailed {
        ICircuitId iCircuitId = this.node.getCircuitId();
        if (this.getConn() == null) {
            return;
        }
        try {
            if (this.node.getConnTypeFromConnModel() != 8 && !((IHoConnectionModel)this.getConn()).isUnstitchedEthernet()) {
                return;
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        NetCircuitEnd netCircuitEnd = this.node.getNodeDrop();
        if (netCircuitEnd != null) {
            ((HoCircuitEnd)netCircuitEnd).destroyEtherBridge(iCircuitId);
        }
        for (EtherP2PCircuitEnd etherP2PCircuitEnd : ((HoCircuitNode)this.node).getP2pEtherCktEnd()) {
            etherP2PCircuitEnd.destroyEtherBridge(iCircuitId);
        }
    }

    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState, ConnectionHasFarendLoopback {
        if (bl) {
            ((IHoConnectionModel)this.getConn()).localDestroy(true);
        } else {
            ((IHoConnectionModel)this.getConn()).localDestroy();
        }
    }

    protected void deleteNodeDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError {
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("deleteNodeDrop at Node " + this.getName());
        }
        if (this.node.getBiSpans().size() == 1) {
            block30: {
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("Busy exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTestAccess exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInRoll exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (ConnectionHasFarendLoopback connectionHasFarendLoopback) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("ConnectionHasFarendLoopback destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)connectionHasFarendLoopback);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("VcatMemberInvalidState exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("InvalidPath exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)invalidPath);
                    }
                }
                catch (WrongInterfaceType wrongInterfaceType) {
                    if (!HoCircuitNodeOperator.dbgOn()) break block30;
                    db.println("WrongInterfaceType exception occured in deleteNodeDrop()");
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
            }
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.node.getBiSpans().getFirst();
            if (this.node.findRoutingDir(netCircuitSpan) == eSpanDirection.TERMINATING) {
                netCircuitSpan.setDstState(0);
            } else {
                netCircuitSpan.setSrcState(0);
            }
            NetCircuitNode netCircuitNode = this.node.spanGetPeer(netCircuitSpan);
            netCircuitNode.getOperator().deleteBiSpan(netCircuitSpan);
            this.node.removeSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        } else if (this.node.getBiSpans().size() == 2) {
            try {
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("changing the intended type to 2 way");
                }
                this.node.setConnTypeInConnModel(1);
                this.node.setConnectionType(1);
            }
            catch (CTCUserException cTCUserException) {
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("Unable to change intended type");
                }
            }
        } else if (HoCircuitNodeOperator.dbgOn()) {
            db.println("deleteNodeDrop: invalid conn. type");
        }
        this.node.removeDrop((NetCircuitEnd)iNetCircuitEnd);
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (HoCircuitNodeOperator.dbgOn()) {
            db.println("Deleting drop: ckt. node: " + this.getName());
        }
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        ICircuitId iCircuitId = this.node.getCircuitId();
        if (netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType() && ((NetCircuitEnd)iNetCircuitEnd).isNodeDrop() || ((NetCircuitEnd)iNetCircuitEnd).isEtherP2PCircuitEnd()) {
            ((HoCircuitEnd)iNetCircuitEnd).destroyEtherBridge(iCircuitId);
        }
        if (netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType() && ((NetCircuitEnd)iNetCircuitEnd).isNodeDrop()) {
            this.deleteNodeDrop(iNetCircuitEnd);
            return;
        }
        super.deleteDrop(iNetCircuitEnd);
    }

    protected void sanityCheckVlan(int n) throws SanityCheckFailed {
        short s = this.node.getPathWidth();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        if (this.node.getConnectionType() != n && (n == 8 || ((HoCircuitNode)this.node).hasP2pEtherCktEnd())) {
            IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
            if (n == 8 && s > iConnectionModels.getBiggestEtherpathAvailable()) {
                throw new SanityCheckFailed("The node " + this.getName() + " cannot support an " + "Ethernet connection size.");
            }
            IVlanModel[] iVlanModelArray = netCcatCircuit.getVlans();
            VlanSetManager vlanSetManager = VlanSetManager.instance();
            if (vlanSetManager != null) {
                try {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("vsm.ensureVlansExist() at " + this.getName());
                    }
                    vlanSetManager.ensureVlansExist(this.node.getNodeModel(), iVlanModelArray);
                }
                catch (IoError ioError) {
                    if (HoCircuitNodeOperator.dbgOn()) {
                        db.println("IO error ensuring VLAN set on " + this.getName());
                    }
                    throw new SanityCheckFailed("CTC is unable to ensure that VLANs exist for the circuit on " + this.getName() + ".");
                }
            }
            IEtherBridgeModel iEtherBridgeModel = this.node.getNodeModel().getEtherBridgeModel();
            Throwable throwable = null;
            if (n == 8) {
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("bridge.createCircuitTest() at node " + this.getName());
                }
                try {
                    boolean bl = iEtherBridgeModel.createCircuitTest(iVlanModelArray);
                    if (!bl) {
                        throwable = new VlanSpanningTreeViolation("");
                    }
                }
                catch (NoMoreEtherCircuit noMoreEtherCircuit) {
                    throwable = noMoreEtherCircuit;
                }
                catch (NoMoreSpanningTree noMoreSpanningTree) {
                    throwable = noMoreSpanningTree;
                }
                catch (NoSuchVlan noSuchVlan) {
                    throwable = noSuchVlan;
                }
                catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
                    throwable = vlanSpanningTreeViolation;
                }
                catch (DuplicateCircuit duplicateCircuit) {
                    throwable = duplicateCircuit;
                }
            } else if (((HoCircuitNode)this.node).hasP2pEtherCktEnd()) {
                if (HoCircuitNodeOperator.dbgOn()) {
                    db.println("bridge.createPointToPointCircuitTest() at node " + this.getName());
                }
                try {
                    boolean bl;
                    if (netCcatCircuit.createWithStpEnabled()) {
                        db.println("STP is Enabled");
                        bl = iEtherBridgeModel.createPointToPointCircuitTest(iVlanModelArray);
                    } else {
                        db.println("STP is Disabled");
                        bl = iEtherBridgeModel.createPointToPointCircuitTest(new IVlanModel[0]);
                    }
                    if (!bl) {
                        throwable = new VlanSpanningTreeViolation("");
                    }
                }
                catch (NoSuchVlan noSuchVlan) {
                    throwable = noSuchVlan;
                }
                catch (NoMoreSpanningTree noMoreSpanningTree) {
                    throwable = noMoreSpanningTree;
                }
                catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
                    throwable = vlanSpanningTreeViolation;
                }
                catch (NoSuchCircuit noSuchCircuit) {
                    throwable = noSuchCircuit;
                }
            }
            if (throwable != null) {
                if (throwable instanceof VlanSpanningTreeViolation) {
                    throw new VlanStpSanityCheckFailed(this.node.getNodeModel());
                }
                throw new SanityCheckFailed("The circuit sanity check failed on the node " + this.getName() + ".\n" + "Either the spanning tree limit has been reached" + "\n" + "or one of the circuit VLANs does not exist on " + this.getName() + ".");
            }
        }
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)iPathDefModel;
        int n = iHoPathDefModel.getPool().getEntityIndex();
        short s = 0;
        if (this.node.getNodeModel().provides(Feature.VCAT)) {
            s = iHoPathDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + HoPathDefModel.physicalHo(iHoPathDefModel) + "::" + s;
    }

    protected String prettyString(IHoPathDefModel iHoPathDefModel) {
        int n = iHoPathDefModel.getPool().getEntityIndex();
        IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
        short s = 0;
        if (iHoPathDefModel.getNodeModel().provides(Feature.VCAT)) {
            s = iHoPathDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + iHoNum + "::null::" + s;
    }

    protected void prettyPrint(IHoPathDefModel[] iHoPathDefModelArray, String string) {
        for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
            if (!HoCircuitNodeOperator.dbgOn()) continue;
            db.println(string + " HoPath #" + i + " " + this.prettyString(iHoPathDefModelArray[i]));
        }
    }
}

