/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface INetCircuit
extends IObservable {
    public boolean tl1Compatible();

    public int getState();

    public int getAdminState();

    public void setAdminState(int var1) throws IncorrectCircuitState, AdminStateProvisioningError;

    public int getServiceState();

    public int getProtType();

    public int getVcatRoutingPref();

    public int getDropPathProtection();

    public boolean dropsArePathFullyProtected();

    public boolean isBidirectional();

    public boolean isPca();

    public boolean hasBlsrDri();

    public boolean isCircuitProtected();

    public boolean isNonRevertivePca();

    public boolean isDri();

    public boolean isMonitorCircuit();

    public boolean supportsISTU();

    public IVlanModel[] getVlans();

    public NetVlanInfo[] getNetVlans();

    public ICircuitId getCircuitId();

    public ICircuitId getPreviousCircuitId();

    public boolean hasNullCircuitId();

    public String getCircuitName();

    public int getCircuitDir();

    public INetLink getLotLink();

    public INetLink getReverseLotLink();

    public INetLink getLapLink();

    public INetLink getReverseLapLink();

    public int getCircuitType();

    public void setCircuitType(int var1);

    public int getCircuitOptChannel();

    public int getCircuitOptDirection();

    public ICircuitType getCircuitTypeObj();

    public int getCircuitSize();

    public ICircuitSize getCircuitSizeObj();

    public INetCircuitEnd getPrimarySource();

    public INetCircuitEnd getSecondarySource();

    public List getSources();

    public List getDrops();

    public LinkedList getRequiredSpans();

    public void prettyPrint(SDebug var1);

    public void prettyPrintDeconstruction(SDebug var1);

    public void addSource(INetCircuitEnd var1) throws SanityCheckFailed;

    public void addDrop(INetCircuitEnd var1, RoutePrefs var2) throws AllocFailed, ObjNotFound, CircuitDropOutstanding, SanityCheckFailed, IncorrectCircuitState;

    public void routeDrop(INetCircuitEnd var1, RoutePrefs var2) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException;

    public void routeDrop(INetCircuitEnd var1, INetCircuitEnd var2, RoutePrefs var3) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException;

    public void deleteDrop(INetCircuitEnd var1) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    public void deleteDrop(INetCircuitDropInfo var1) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    public List getCircuitSpans();

    public LinkedList getCircuitCosts();

    public List getActiveCircuitSpans();

    public List getRoutedCircuitSpans();

    public INetElement getSrcNetElement();

    public INetCircuitNode getSrcCircuitNode();

    public List getCircuitNodes();

    public List getEtherCircuitNodes() throws IncorrectCircuitState;

    public List getEtherAddDropCircuitNodes() throws IncorrectCircuitState;

    public boolean doesCircuitUseNetElem(INetElement var1);

    public List getCircuitNodeFromNE(INetElement var1);

    public NetCircuitNode getCircuitNodeFromCktEnd(INetCircuitEnd var1);

    public boolean doesCircuitUseNetLink(INetLink var1);

    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink var1);

    public void addCircuitSpan(INetLinkSpan var1) throws NoRoute;

    public void deleteCircuitSpan(INetLinkSpan var1);

    public void circuitDeleteCheck() throws IncorrectCircuitState;

    public void destroySanityCheck() throws SanityCheckFailed;

    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError;

    public void rename(String var1) throws CircuitProvError;

    public LinkedList sanityCheckSRGs() throws SanityCheckFailed;

    public void sanityCheckManualRouting() throws SanityCheckFailed;

    public void sanityCheck() throws SanityCheckFailed;

    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException;

    public boolean isVlanCapable() throws IncorrectCircuitState;

    public boolean mustDisableStp() throws IncorrectCircuitState;

    public List getAvailDropPorts(INodeModel var1, CircuitCreatInfo var2, boolean var3);

    public int validateML2CircuitSize() throws CircuitProvError;

    public List getAvailDropPoints(INodeModel var1, IEntityModel var2);

    public void addNetElement(INetElement var1, RoutePrefs var2) throws IncorrectCircuitState;

    public void deleteNetElement(INetElement var1) throws CannotDeleteLastDrop, IncorrectCircuitState, ObjNotFound, DeletionError, SanityCheckFailed;

    public void routeNetElement(INetElement var1, RoutePrefs var2) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException;

    public void routeNetElement(INetElement var1, INetElement var2, RoutePrefs var3) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException;

    public void assignVlanSet(IVlanModel[] var1) throws IncorrectCircuitState, SanityCheckFailed;

    public void assignVlanSet(NetVlanInfo[] var1) throws IncorrectCircuitState, SanityCheckFailed;

    public boolean isCircuitRefValid();

    public void createWithStpEnabled(boolean var1);

    public boolean isStpEnabled();

    public boolean hasLoopback();

    public boolean hasMonitor();

    public boolean hasMxpn();

    public boolean hasMxpnOnIntermediateNEs();

    public boolean hasXcLoopback();

    public boolean supportsMonitorCircuits();

    public void setUpsrSelectorAttributes(IRevertiveBehavior var1, short var2, short var3, boolean var4);

    public IHoUpsrAttributes getUpsrAttributes();

    public short getSla();

    public INetCircuit useLAP();

    public int getCircuitSpanNum();

    public boolean needRoute(INetCircuitEnd var1);

    public List getLoTunnelNodes();

    public ILoNum getLoOverHo();

    public void setState(int var1);

    public void setDeletionFailureState();

    public List getXmCircuitEnds();

    public void setXmCircuitEnds(INetCircuitEnd[] var1);

    public void setXmCircuitEnds(IEntityModel[] var1);

    public boolean isMemberOfVcat();

    public boolean isOpenEndedVcatCircuit();

    public void setMemberPrefs(MemberPrefs var1);

    public void setCircuitName(String var1);

    public int getMemberNumber();

    public void setMemberNumber(int var1);

    public int getMemberStatus(INetCircuitEnd var1);

    public void setMemberStatus(INetCircuitEnd var1, int var2) throws CTCUserException;

    public INetVcatGroup getForwardVcatGroup();

    public INetVcatGroup getReverseVcatGroup();

    public INetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd var1);

    public int getConfiguredForwardMemberSize();

    public int getConfiguredReverseMemberSize();

    public String getFullCircuitName();

    public boolean isMemberInGroup();

    public boolean isSplitRoutingAllowed();

    public boolean isDiag();

    public boolean isUpsr1wayTl1();

    public boolean upsrBerThresholdsSettable();

    public boolean useLink(INetLink var1);

    public boolean isYCircuit();

    public boolean validateBLSRTimeSlots(Map<INetLink, Integer> var1) throws SanityCheckFailed;

    public boolean isCircuitNodeInVersionUp();

    public boolean isOverlayRing();

    public void setOverlayRing(boolean var1);

    public void addOpenVcatDrops(INetCircuitEnd[] var1, RoutePrefs var2) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState;

    public void deleteOpenVcatDrops(INetCircuitEnd[] var1) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    public void routeDrop(INetCircuitEnd[] var1, RoutePrefs var2) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException;

    public void routeDrop(INetCircuitEnd[] var1, INetCircuitEnd[] var2, RoutePrefs var3) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException;

    public void setMemberNumberOvcat(int var1);

    public List getOpenVcatDrops();

    public void addWrongConnObj(Object var1);

    public boolean memberOfBackHaulCircuit(INetCircuit var1);

    public boolean backHaulVcatCircuit(INetCircuit var1);

    public List getTimeSlotViolations();
}

