/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPmStat;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.LoAditModelSimulator;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;

public class LoConnModelSimulator
extends CmsObservable
implements ILoConnectionModel,
IObserver {
    private IHoConnectionModel hoConn;
    private LoCircuitNode node;
    private ILoNum loNum;

    public LoConnModelSimulator(IHoConnectionModel iHoConnectionModel, LoCircuitNode loCircuitNode) {
        this.hoConn = iHoConnectionModel;
        this.node = loCircuitNode;
        this.loNum = (ILoNum)((LoCcatCircuit)loCircuitNode.getCircuit()).getILoNum();
        this.addHoConnectionObserver();
    }

    public void addHoConnectionObserver() {
        if (this.hoConn != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)this.hoConn, this);
        }
    }

    public void update(IObservable iObservable, Object object) {
        this._update(iObservable, object);
    }

    public void update(Observable observable, Object object) {
        this._update((IObservable)observable, object);
    }

    protected void _update(IObservable iObservable, Object object) {
        int n = (Integer)object;
        if (((Integer)object).equals(ModelUpdateType.DELETED)) {
            this.dispose();
            this.setChanged();
            this.notifyObservers(ModelUpdateType.DELETED);
        } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public List getPortModels() {
        return null;
    }

    public HashMap getDs1s() {
        return null;
    }

    public Object writeReplace() throws ObjectStreamException {
        return null;
    }

    public ILoDefModel[] getActivePaths() {
        LinkedList<LoDefModel> linkedList = new LinkedList<LoDefModel>();
        IHoPathDefModel[] iHoPathDefModelArray = this.hoConn.getActivePaths();
        int n = iHoPathDefModelArray.length;
        boolean bl = false;
        for (IHoPathDefModel iHoPathDefModel : Arrays.asList(iHoPathDefModelArray)) {
            LoAditModelSimulator loAditModelSimulator = new LoAditModelSimulator(iHoPathDefModel, this.hoConn);
            linkedList.add(new LoDefModel(this.node.getNodeModel(), loAditModelSimulator, this.loNum, this.loNum.getLoPathWidth(), 0, iHoPathDefModel.getPool().getEntityIndex()));
        }
        return linkedList.toArray(new ILoDefModel[linkedList.size()]);
    }

    public ICircuitId getCircuitId() {
        return this.hoConn.getCircuitId();
    }

    public void setCircuitId(ICircuitId iCircuitId) {
    }

    public int getConnectionType() {
        return this.hoConn.getConnectionType();
    }

    public ILoDefModel[] getPaths() {
        LinkedList<LoDefModel> linkedList = new LinkedList<LoDefModel>();
        IHoPathDefModel[] iHoPathDefModelArray = this.hoConn.getPaths();
        for (IHoPathDefModel iHoPathDefModel : Arrays.asList(iHoPathDefModelArray)) {
            LoAditModelSimulator loAditModelSimulator = new LoAditModelSimulator(iHoPathDefModel, this.hoConn);
            linkedList.add(new LoDefModel(this.node.getNodeModel(), loAditModelSimulator, this.loNum, this.loNum.getLoPathWidth(), 0, iHoPathDefModel.getPool().getEntityIndex()));
        }
        return linkedList.toArray(new ILoDefModel[linkedList.size()]);
    }

    public int getProtectionOp() {
        return this.hoConn.getProtectionOp();
    }

    public int getReverseProtectionOp() {
        return this.hoConn.getReverseProtectionOp();
    }

    public IRevertiveBehavior getUpsrReversion() {
        return this.hoConn.getUpsrReversion();
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
    }

    public boolean getUpsrSwitchOnPdiP() throws ConnectionTypeError {
        return this.hoConn.getUpsrSwitchOnPdiP();
    }

    public void addOutput(ILoDefModel iLoDefModel) throws InvalidPath, PathInUse, ConnectionTypeError, PathNotSupported, CTCUserException {
        throw new ConnectionTypeError("An output cannot be added to the Y cross-connection.");
    }

    public void changeIntendedType(int n) throws ConnectionTypeError, ConnectionInRoll, ConnectionInTestAccess, ConnectionInLoopback, ConnectionInTopologyUpgrade {
        throw new ConnectionTypeError("The intended type cannot be set on the Y cross-connection.");
    }

    public void localDestroy() throws Busy {
    }

    public void localDestroy(boolean bl) throws Busy, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState {
    }

    public void removeOutput(ILoDefModel iLoDefModel) throws InvalidPath, DeleteInstead, ConnectionTypeError {
        throw new ConnectionTypeError("The output cannot be removed from the Y cross-connection.");
    }

    public void setReverseProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
    }

    public int getSwitchCount(int n, short s) {
        return this.hoConn.getSwitchCount(n, s);
    }

    public IEntityModel[] getPathEntities() {
        return null;
    }

    public int getDriNodeType() {
        return this.hoConn.getDriNodeType();
    }

    public void setDriNodeType(int n) throws ConnectionTypeError {
        throw new ConnectionTypeError("The DRI node type cannot be set on the Y cross-connection.");
    }

    public int getIndex() {
        return 0;
    }

    public boolean inRoll() {
        return this.hoConn.inRoll();
    }

    public boolean isBlsrDri() {
        return this.hoConn.isBlsrDri();
    }

    public INodeModel getNodeModel() {
        return this.hoConn.getNodeModel();
    }

    public void dispose() {
    }

    public boolean hasLoopback() {
        return this.hoConn.hasLoopback();
    }

    public boolean hasXcLoopback() throws AbstractCmsNoSuchEntityException, InvalidPath {
        return this.hoConn.hasXcLoopback();
    }

    public boolean validateNewAdminState(int n) throws AbstractCmsIOException {
        return this.hoConn.validateNewAdminState(n);
    }

    public int getAdminState() throws AbstractCmsIOException {
        return this.hoConn.getAdminState();
    }

    public String getConnectionName() {
        String string = new String("Unknown");
        return string;
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
    }

    public int getServiceState() throws AbstractCmsIOException {
        return this.hoConn.getServiceState();
    }

    public void setAdminState(int n) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
    }

    public boolean hasTestAccess() {
        return false;
    }

    public boolean inConnectionConversion() {
        return this.hoConn.inConnectionConversion();
    }

    public IConnectionConversionModel createConnectionConversionModel(List list, int n, ICircuitId iCircuitId, List list2, int n2, IConnCreateAttrs iConnCreateAttrs, int n3, boolean bl, boolean bl2) throws NoSuchConnection, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, PathInUse {
        return null;
    }

    public IConnectionConversionModel getConnectionConversionModel() {
        return null;
    }

    public void destroy() {
    }

    public String getImplementationClassName() {
        return new String("LoConnModelSimulator");
    }

    public IRevertiveBehavior getReverseUpsrReversion() throws ConnectionTypeError {
        return this.hoConn.getReverseUpsrReversion();
    }

    public void setReverseUpsrReversion(IRevertiveBehavior iRevertiveBehavior) throws ConnectionTypeError {
        throw new ConnectionTypeError("The revertive behavior for the second selector cannot be set on the Y cross-connection.");
    }

    public void setUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError {
        throw new ConnectionTypeError("PDI-P cannot be set on the Y cross-connection.");
    }

    public boolean getReverseUpsrSwitchOnPdiP() throws ConnectionTypeError, InvalidPath {
        return this.hoConn.getReverseUpsrSwitchOnPdiP();
    }

    public void setReverseUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError, InvalidPath {
        throw new ConnectionTypeError("PDI-P cannot be set for the second selector on the Y cross-connection.");
    }

    public short getUpsrSfBerLevel() {
        return this.hoConn.getUpsrSfBerLevel();
    }

    public void setUpsrSfBerLevel(short s) {
    }

    public short getUpsrSdBerLevel() {
        return this.hoConn.getUpsrBerLevel();
    }

    public void setUpsrSdBerLevel(short s) {
    }

    public void setReverseUpsrSdBerLevel(short s) throws ConnectionTypeError {
        throw new ConnectionTypeError("The SD BER level of the second selector cannot be set on the Y cross-connection.");
    }

    public void setReverseUpsrSfBerLevel(short s) throws ConnectionTypeError {
        throw new ConnectionTypeError("The SF BER level of the second selector cannot be set on the Y cross-connection.");
    }

    public short getReverseUpsrSdBerLevel() throws ConnectionTypeError {
        return this.hoConn.getReverseUpsrSdBerLevel();
    }

    public short getReverseUpsrSfBerLevel() throws ConnectionTypeError {
        return this.hoConn.getReverseUpsrSfBerLevel();
    }

    public List getPathList() {
        return null;
    }

    public List getActivePathList() {
        LinkedList<LoDefModel> linkedList = new LinkedList<LoDefModel>();
        IHoPathDefModel[] iHoPathDefModelArray = this.hoConn.getPaths();
        int n = iHoPathDefModelArray.length;
        boolean bl = false;
        for (IHoPathDefModel iHoPathDefModel : Arrays.asList(iHoPathDefModelArray)) {
            LoAditModelSimulator loAditModelSimulator = new LoAditModelSimulator(iHoPathDefModel, this.hoConn);
            linkedList.add(new LoDefModel(this.node.getNodeModel(), loAditModelSimulator, this.loNum, this.loNum.getLoPathWidth(), 0, iHoPathDefModel.getPool().getEntityIndex()));
        }
        return linkedList;
    }

    public void setProtectionOp(int n) throws InvalidProtectionOp, InternalCommError, ConnectionInLoopback, ConnectionTypeError, ConnectionInTestAccess {
        throw new ConnectionTypeError("The protection operation cannot be set on the Y cross-connection.");
    }

    public int getHoldoffTime() {
        return this.hoConn.getHoldoffTime();
    }

    public int getReverseHoldoffTime() {
        return this.hoConn.getReverseHoldoffTime();
    }

    public void setHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        throw new ConnectionTypeError("The holdoff time cannot be set on the Y cross-connection.");
    }

    public void setReverseHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        throw new ConnectionTypeError("The holdoff time for the second selector cannot be set on the Y cross-connection.");
    }

    public IPmStat getSwitchCountStat(int n, short s) {
        return this.hoConn.getSwitchCountStat(n, s);
    }

    public IPmStat getReverseSwitchCountStat(int n, short s) {
        return this.hoConn.getReverseSwitchCountStat(n, s);
    }

    public int getReverseSwitchCount(int n, short s) {
        return this.hoConn.getReverseSwitchCount(n, s);
    }

    public boolean getSwitchCountValidity(int n, short s) {
        return this.hoConn.getSwitchCountValidity(n, s);
    }

    public boolean getReverseSwitchCountValidity(int n, short s) {
        return this.hoConn.getReverseSwitchCountValidity(n, s);
    }

    public void clearSwitchCountStat(int n) {
    }

    public IHoConnectionModel getHoConn() {
        return this.hoConn;
    }

    public boolean hasMonitor() {
        return false;
    }
}

