/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelNodeOperator;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.IHoNum;
import cerent.util.SDebug;

public class LoTunnelNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("LoTunnelNode");
    private ILoAditModel loAdit;
    private boolean lotReuseLoAdit;
    private LoTunnelNodeOperator operator;

    public LoTunnelNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        super(iNetElement, hoCcatCircuit);
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.operator = new LoTunnelNodeOperator(this);
        this.lotReuseLoAdit = false;
    }

    public LoTunnelNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, hoCcatCircuit, object);
        hoCcatCircuit.setChanged();
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.operator = new LoTunnelNodeOperator(this);
        this.lotReuseLoAdit = false;
    }

    protected boolean hasAggregation() {
        return true;
    }

    protected boolean updateNumberOfPaths() {
        this.numberOfPaths = 1;
        return false;
    }

    protected void sanityCheckConnModel() {
        if (this.loAdit != null) {
            this.loAdit.inUse();
        }
    }

    protected void handleTl1LoAditDeletion() {
        int n;
        int n2 = n = this.circuit.getCircuitType();
        if (this.dbgOn()) {
            db.println("loAditModel TCCU:  DELETED for cktType" + n + " at node" + this.getName());
        }
        if (!this.circuit.circuitInfoActive()) {
            ITdmProtocolType iTdmProtocolType = this.getNetElement().getTdmProtocolTypeObj();
            if (this.circuit.getCircuitTypeObj().isLAPCircuitType()) {
                n2 = iTdmProtocolType.getHoCircuitType();
                NetCircuitManager.instance().removeCircuitIfLAP(this.circuit);
                this.circuit.setCircuitType(n2);
            } else if (this.circuit.getCircuitTypeObj().isTunnelCircuitType()) {
                n2 = iTdmProtocolType.getAggCircuitType();
                this.circuit.setCircuitType(n2);
                NetCircuitManager.instance().insertCircuitIfLAP(this.circuit);
            }
        }
    }

    protected int getConnTypeFromConnModel() {
        if (this.loAdit != null) {
            return 1;
        }
        return 22;
    }

    protected Object[] getPathsFromConnModel() {
        return new Object[0];
    }

    protected Object[] getConnectionPathDefs() {
        Object[] objectArray = new Object[]{};
        if (this.loAdit != null) {
            objectArray = new Object[]{this.loAdit.getHo()};
        }
        return objectArray;
    }

    protected Object[] getActivePathsFromConnModel() {
        return new Object[0];
    }

    protected int getProtectionOpFromConnModel() {
        return this.protectionOp;
    }

    protected int getReverseProtectionOpFromConnModel() {
        return this.reverseProtectionOp;
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        this.numberOfPaths = 1;
        IHoPathDefModel iHoPathDefModel = this.loAdit.getHo();
        this.integratePath(iHoPathDefModel, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
    }

    protected int findConnType() {
        int n;
        int n2 = this.countNumInputs();
        int n3 = n2 + (n = this.countNumOutputs());
        if (n3 == 0 && !this.onXm()) {
            return 22;
        }
        if (n3 > 1) {
            return 22;
        }
        return 1;
    }

    protected boolean onXm() {
        if (!this.circuit.getXmCircuitEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId()) {
            return true;
        }
        if (this.getConn() != null) {
            IHoPathDefModel iHoPathDefModel = ((ILoAditModel)this.getConn()).getHo();
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), iHoPathDefModel);
            if (netCircuitEnd.onXm()) {
                return true;
            }
        }
        return false;
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        if (this.biSpans.size() != 1 && !this.onXm()) {
            if (this.dbgOn()) {
                db.println("Warning! getTunnelEntityIndex: biSpans size != 1 and not on XM");
            }
            throw new SanityCheckFailed("Invalid Tunnel end at " + this.getName());
        }
        if (this.biSpans.size() == 1) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            if (this.getNetElement() == netCircuitSpan.getLink().getSrc()) {
                return netCircuitSpan.getLink().getSrcEntityIndex();
            }
            return netCircuitSpan.getLink().getDstEntityIndex();
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
        return netCircuitEnd.getEntityIndex();
    }

    public IHoNum getLotHo() throws SanityCheckFailed {
        if (this.biSpans.size() != 1 && !this.onXm()) {
            if (this.dbgOn()) {
                db.println("Warning! getLoTunnelHo: biSpans size != 1 and not on XM");
            }
            throw new SanityCheckFailed("Invalid Tunnel end at " + this.getName() + ". Unable to get HO number");
        }
        if (this.biSpans.size() == 1) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            return netCircuitSpan.getHoNum(this.getNetElement());
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.circuit.getXmCircuitEnds().get(1);
        return netCircuitEnd.getHoNum();
    }

    protected void lotReuseLoAdit(boolean bl) {
        if (this.nodeDrop != null) {
            this.lotReuseLoAdit = bl;
            if (this.dbgOn()) {
                db.println("lotReuseLoAdit= " + (bl ? "true" : "false") + " at " + this.getName());
            }
            return;
        }
    }

    protected boolean getLotReuseLoAdit() {
        return this.lotReuseLoAdit;
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        return null;
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.loAdit != null) {
            this.loAdit.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
        }
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.loAdit != null) {
            return this.loAdit.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected boolean isAnyChangeInUpsrSelector() {
        return false;
    }

    protected boolean completeCheck() {
        return this.totalSpans() == 1 && this.biSpans.size() == 1;
    }

    public IConnectionModel getConn() {
        return this.loAdit;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.loAdit = (ILoAditModel)iConnectionModel;
    }

    protected void addRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.biSpans.isEmpty()) {
            this.addSpan(netCircuitSpan, eSpanDirection2);
            if (this.getState() != 0) {
                this.setState(3);
            }
        } else {
            boolean bl = false;
            if (this.circuit.srcCircuitNode.equals(this)) {
                bl = true;
            }
            NetCircuitNode netCircuitNode = NetCircuitNodeFactory.createCircuitNode(this.getNetElement(), (NetCcatCircuit)this.getCircuit());
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            netCircuitNode.insertDrop(this.getNodeDrop());
            NetCircuitNodeFactory.createDualConnectionCircuitNode((NetCircuitNode)this, netCircuitNode);
            if (bl) {
                this.circuit.setSrcCircuitNode();
            }
        }
    }

    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }
}

