/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.LinkedList;

public class LoTunnelNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("LoTunnelNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public LoTunnelNodeOperator(LoTunnelNode loTunnelNode) {
        super(loTunnelNode);
    }

    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        if (LoTunnelNodeOperator.dbgOn()) {
            db.println("createConnection: connection type " + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + " ckt Id: " + Integer.toHexString(iCircuitId.getNodeId()) + ":" + iCircuitId.getUniquePart().getUniqueId() + " at Node " + this.getName());
        }
        try {
            this.createLOTConnection(iCircuitId);
        }
        catch (CTCUserException cTCUserException) {
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "An LO connection could not be created on " + this.getName() + ".";
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n" + this.getNoLoCapableHoMessage() + " on " + this.getName();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "A connection could not be created on " + this.getName() + ".";
            string = string + "\nThe administrative state is invalid.";
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError("An error occurred while creating a connection object on " + this.getName() + ".");
        }
    }

    protected void createLOTConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, AdminStateProvisioningError {
        ILoAditModel iLoAditModel;
        NetCircuitSpan netCircuitSpan = null;
        if (!this.node.getBiSpans().isEmpty()) {
            netCircuitSpan = (NetCircuitSpan)this.node.getBiSpans().getFirst();
        }
        if (netCircuitSpan == null && !this.node.onXm()) {
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("createTunnelConnection: null span and not on ds3Xm");
            }
            throw new CircuitProvError("An invalid tunnel/aggregation exists on " + this.getName() + ".");
        }
        if (LoTunnelNodeOperator.dbgOn()) {
            db.println("Creating Tunnel/Aggregation end at " + this.getName());
        }
        if (!((LoTunnelNode)this.node).getLotReuseLoAdit()) {
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("Creating new LoAdit");
            }
            if (netCircuitSpan != null) {
                iLoAditModel = this.createLoAditOnNE(netCircuitSpan, iCircuitId);
                if (this.node.getBiSpans().size() == 2) {
                    NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)this.node.getBiSpans().getLast();
                }
            } else {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getCircuit().getXmCircuitEnds().get(1);
                iLoAditModel = this.createLoAditOnNE(netCircuitEnd);
            }
        } else {
            iLoAditModel = netCircuitSpan.getLoAdit(this.node.getNetElement());
            if (iLoAditModel == null) {
                if (LoTunnelNodeOperator.dbgOn()) {
                    db.println("createTunnelConnection: null loAdit");
                }
                throw new CircuitProvError("An invalid tunnel exists on " + this.getName() + ".");
            }
            if (LoTunnelNodeOperator.dbgOn()) {
                db.println("Setting circuitId on LoAdit");
            }
            iLoAditModel.setCircuitId(iCircuitId);
        }
        if (iLoAditModel != null) {
            this.node.setConn((IConnectionModel)iLoAditModel);
        }
    }

    protected ILoAditModel createLoAditOnNE(NetCircuitSpan netCircuitSpan, ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, AdminStateProvisioningError {
        INetElement iNetElement = this.node.getNetElement();
        if (!iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.node.getAdminState()) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("The node " + this.getName() + " does not support the circuit state " + NetCircuitNode.translateAdminState(this.node.getAdminState()) + ". Use the circuit state " + NetCircuitNode.translateAdminState(0) + " instead.");
        }
        ILoAditModel iLoAditModel = netCircuitSpan.createLoAdit(iNetElement, iCircuitId);
        return iLoAditModel;
    }

    protected ILoAditModel createLoAditOnNE(NetCircuitEnd netCircuitEnd) throws PathInUse, InvalidPath, NoMoreLoCapableHo {
        ILoAditModel iLoAditModel = netCircuitEnd.createLoAdit(this.getCircuit().getCircuitId());
        return iLoAditModel;
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        super.destroySanityCheck();
        if (this.getConn() == null) {
            return;
        }
        if (!this.node.hasConnection()) {
            return;
        }
        if (((ILoAditModel)this.getConn()).inUse()) {
            throw new SanityCheckFailed("A tunnel or aggregation circuit is in use.");
        }
    }

    protected void deleteNodeDrop() {
        if (LoTunnelNodeOperator.dbgOn()) {
            db.println("Warning! cannot delete node drop for Tunnel");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void destroyCrossConnection() {
        if (this.getConn() != null) {
            if (!((LoTunnelNode)this.node).getLotReuseLoAdit()) {
                if (LoTunnelNodeOperator.dbgOn()) {
                    LoTunnelNodeOperator.db.println("destroySonetConnection(" + this.getName() + "): destroy VtAdit");
                }
                try {
                    ((ILoAditModel)this.getConn()).localDestroy();
                }
                catch (Busy var1_1) {
                    if (LoTunnelNodeOperator.dbgOn()) {
                        LoTunnelNodeOperator.db.println("Unable to delete LO Adit for LoTunnel - xBusy");
                    }
                    return;
                }
                catch (AbstractCmsObjectNotExistException var1_2) {
                    if (!LoTunnelNodeOperator.dbgOn()) ** GOTO lbl20
                    LoTunnelNodeOperator.db.println("loAdit already deleted");
                }
            } else {
                if (LoTunnelNodeOperator.dbgOn()) {
                    LoTunnelNodeOperator.db.println("destroySonetConnection(" + this.getName() + "): clear circuitId on LoAdit");
                }
                var1_3 = new CircuitId(this.node.getNodeModel().getNodeId(), 0);
                ((ILoAditModel)this.getConn()).setCircuitId((ICircuitId)var1_3);
            }
        }
lbl20:
        // 6 sources

        this.node.clearConnectionPathEnds();
    }

    protected void cleanupLoAdits() {
        if (LoTunnelNodeOperator.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        int n = 0;
        LinkedList linkedList = this.node.getInSpans();
        while (n < 3) {
            for (Object object : linkedList) {
                ((NetCircuitSpan)object).cleanupLoAdit(this.node.getNetElement());
            }
            linkedList = ++n == 1 ? this.node.getOutSpans() : this.node.getBiSpans();
        }
        if (this.node.onXm()) {
            Object object;
            object = (NetCircuitEnd)this.getCircuit().getXmCircuitEnds().get(1);
            ((NetCircuitEnd)object).cleanupLoAdit();
        }
    }

    protected void modifyConnection() throws CircuitProvError {
    }
}

