/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.HoUpsrAttributes;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetServiceState;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionsFactory;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitOperation;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitSpan;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuitOperator;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitOperator;
import cerent.cms.ncp.NetCircuitPathMarker;
import cerent.cms.ncp.NetCircuitRollOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.NodeRoutingDirection;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.Spt;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.vlan.NetVlanInfo;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetCcatCircuit
extends NetCircuit {
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    protected NetCircuitNode srcCircuitNode = null;
    protected NetCircuitNode secSrcCircuitNode = null;
    private Map cktNodeList;
    private Map cktSpanList;
    protected MemberPrefs memberPrefs;
    protected NetCcatCircuitOperator operator = new NetCcatCircuitOperator(this);
    private NetCircuitRollOperator rollOperator;
    protected IRevertiveBehavior upsrReversion;
    protected short upsrSfBerLevel;
    protected short upsrSdBerLevel;
    protected boolean upsrSwitchOnPdip;
    private NetCircuitPathMarker marker = new NetCircuitPathMarker(this);
    private boolean go_return_routing;
    protected boolean inCircuitMerge = false;
    private NetVcatGroup vcatGroup;
    private Map memberStatusMap;
    private List prevDropList;
    private boolean isInGroup = false;
    protected IHoLoNum memberSrcHoLo;
    protected IHoLoNum memberDropHoLo;
    protected IHoLoNum memberSecSrcHoLo;
    protected IHoLoNum memberSecDropHoLo;
    private boolean isDri = false;
    protected boolean driConfigurationError = false;
    Map preservedConnPathEnds = null;
    private static int[][] bidirTable = new int[][]{{1, 1, 1, 1, 1}, {1, 1, 1, 1, 2}, {1, 2, 1, 1, 1}, {1, 2, 1, 1, 2}, {1, 2, 1, 2, 2}, {1, 2, 1, 2, 3}, {2, 1, 1, 1, 1}, {2, 1, 1, 1, 2}, {2, 1, 2, 1, 2}, {2, 1, 2, 1, 3}, {2, 2, 1, 1, 1}, {2, 2, 1, 1, 2}, {2, 2, 1, 2, 2}, {2, 2, 1, 2, 3}, {2, 2, 2, 1, 2}, {2, 2, 2, 1, 3}, {2, 2, 2, 2, 2}};
    private static final SDebug db = new SDebug("NetCcatCircuit");

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.cktNodeList = Collections.synchronizedMap(new TreeMap(new NetElemComparator()));
        this.cktSpanList = Collections.synchronizedMap(new TreeMap(new NetLinkComparator()));
        this.go_return_routing = circuitCreatInfo.getTrafficDir();
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        this(circuitCreatInfo);
        this.setCktOperation(1);
        this.addSources(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
    }

    protected void addSources(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd2 = null;
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        if (iNetCircuitEnd != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd);
            this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            this.insertSource(netCircuitEnd);
            try {
                iNetElement = netCircuitEnd.getNetElement();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("i/o exception in NetCcatCircuit/findNetElem");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                iNetElement = null;
            }
        }
        if (iNetCircuitEnd2 != null) {
            netCircuitEnd2 = NetCircuitEndFactory.createCircuitEnd(circuitCreatInfo.type(), iNetCircuitEnd2);
            this.circuitInfo.setSecSrcPoint(netCircuitEnd2.getCircuitEnd());
            this.insertSource(netCircuitEnd2);
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("Warning: unable to find Net Element in NetCcatCircuit()");
            }
            return;
        }
        this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        if (netCircuitEnd != null) {
            this.srcCircuitNode.addSource(netCircuitEnd);
            this.insertCktNode(this.srcCircuitNode);
        }
        if (netCircuitEnd2 == null) {
            return;
        }
        if (netCircuitEnd2.getNodeId() != netCircuitEnd.getNodeId()) {
            iNetElement2 = netCircuitEnd2.getNetElement();
            this.secSrcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement2, this);
            this.secSrcCircuitNode.addSource(netCircuitEnd2);
            this.insertCktNode(this.secSrcCircuitNode);
        } else {
            this.srcCircuitNode.addSource(netCircuitEnd2);
        }
    }

    protected NetCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        this(circuitCreatInfo);
        ICircuitId iCircuitId = NetCircuitNode.getConnCircuitId(object);
        if (iCircuitId == null) {
            if (this.dbgOn()) {
                db.println("Warning! Unable to get circuit ID");
            }
            return;
        }
        this.updateCircuitId(iCircuitId);
        if (this instanceof LoCcatCircuit) {
            ((LoCcatCircuit)this).isYCircuit = circuitCreatInfo.isYCircuit();
            ((LoCcatCircuit)this).loNum = circuitCreatInfo.getILoNum();
        } else if (this instanceof HoCcatCircuit) {
            ((HoCcatCircuit)this).initXmCircuitEnds();
        }
        NetCircuitNode netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this, object);
        if (netCircuitNode.getConnectionType() == 9) {
            this.circuitInfo.setMonitor(true);
        }
        this.insertCktNode(netCircuitNode);
        this.initSourcesAndDrops();
        if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) {
            this.initState(4);
        } else {
            if (this.inRoll()) {
                this.initState(8);
            } else if (this.inConversion()) {
                this.initState(11);
            } else {
                this.initState(6);
            }
            this.tl1CircuitCompleteCheck();
        }
        this.serviceState = this.deriveServiceState();
        this.setProtType();
    }

    public boolean getDri() {
        return this.isDri;
    }

    public void setDri(boolean bl) {
        this.isDri = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string) throws CircuitProvError {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            this.operator.rename(string);
        }
        this.notifyChanged();
    }

    protected void renameCircuit(String string) throws CircuitProvError {
        this.operator.renameCircuit(string);
    }

    @Override
    protected String getCircuitNameFromSrcNode() {
        String string = "";
        if (this.getCircuitTypeObj().isEthernetCircuitType()) {
            if (this.circuitInfoActive()) {
                return this.getCircuitName();
            }
            return "Unknown";
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcCircuitNode();
        if (netCircuitNode != null) {
            if (!(!netCircuitNode.isNodeDrop() || netCircuitNode instanceof DualConnectionCircuitNode && this.getCircuitTypeObj().isOchTrailTunnelCircuitType())) {
                return this.getCircuitName();
            }
            if (netCircuitNode.getNodeModel().provides(Feature.TCCU)) {
                NetCcatCircuit netCcatCircuit;
                if (netCircuitNode.getConn() != null) {
                    string = netCircuitNode.getConnName();
                } else if (this instanceof LoCcatCircuit && (netCcatCircuit = ((LoCcatCircuit)this).useLAPOnSource()) != null) {
                    NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCcatCircuit.getLoTunnelNodes().get(0);
                    NetCircuitNode netCircuitNode3 = null;
                    List list = this.getCircuitNodeFromNE(netCircuitNode2.getNetElement());
                    if (list != null) {
                        if (list.size() > 1 && this.dbgOn()) {
                            this.debug("Error !! MXPN in LAP circuit");
                        }
                        netCircuitNode3 = (NetCircuitNode)list.get(0);
                    }
                    if (netCircuitNode3 != null) {
                        string = netCircuitNode3.getConnName();
                    }
                }
            }
        }
        if (string == null || string.equals("")) {
            string = this.circuitInfoActive() ? this.getCircuitName() : "Unknown";
        }
        if (this.dbgOn()) {
            this.debug("getCircuitNameFromSrcNode() returns \"" + string + "\"");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAdminState(int n) throws IncorrectCircuitState, AdminStateProvisioningError {
        boolean bl = false;
        String string = "The circuit state could not be provisioned.";
        String string2 = "";
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit reference is invalid.");
        }
        if (this.state != 1 && this.state != 5 && this.state != 4 && this.state != 6) {
            throw new IncorrectCircuitState("The circuit is in a state that cannot be provisioned.");
        }
        String string3 = this.validateAdminState(n);
        if (string3 != null) {
            db.severe("Validate admin state failed for requested admin state" + this.translateAdminState(n));
            throw new AdminStateProvisioningError(string3);
        }
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            int n2;
            Iterator iterator = this.getCircuitNodes().iterator();
            boolean bl2 = this.isOpenEndedVcatCircuit();
            INodeModel iNodeModel = null;
            if (bl2) {
                iNodeModel = ((NetVcatTermination)this.vcatGroup.getAllVcatTerms().get(0)).getNodeModel();
            }
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                n2 = n;
                if (this.isMemberOfVcat() && n == 4) {
                    if (!bl2) {
                        if (netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                            n2 = 2;
                        }
                    } else if (this.getPrimarySource().getNodeModel() == iNodeModel) {
                        if (netCircuitNode.getNodeModel() != iNodeModel) {
                            n2 = 2;
                        }
                    } else if (netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                        n2 = 2;
                    }
                }
                try {
                    netCircuitNode.setConnAdminState(n2);
                }
                catch (AdminStateProvisioningError adminStateProvisioningError) {
                    if (this.dbgOn()) {
                        db.println("Unable to set admin state on " + netCircuitNode.getName() + ": " + adminStateProvisioningError);
                        SDebug.printStackTrace((Throwable)adminStateProvisioningError);
                    }
                    string2 = adminStateProvisioningError.getMessage();
                    break;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to set admin state on " + netCircuitNode.getName() + ": " + exception);
                    }
                    string2 = "The circuit state could not be set on the node " + netCircuitNode.getName() + ".";
                    break;
                }
            }
            if (string2.length() > 0) {
                if (this.dbgOn()) {
                    db.println("invoking revertAdminState");
                }
                try {
                    this.revertAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to revert admin state: " + exception);
                    }
                    string = string + " Reversion to the previous circuit state also failed.";
                }
                this.setChanged();
                bl = true;
            }
            if (!bl) {
                for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                    n2 = n;
                    if (this.isMemberOfVcat() && n == 4) {
                        if (!bl2) {
                            if (netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                                n2 = 2;
                            }
                        } else if (this.getPrimarySource().getNodeModel() == iNodeModel) {
                            if (netCircuitNode.getNodeModel() != iNodeModel) {
                                n2 = 2;
                            }
                        } else if (netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                            n2 = 2;
                        }
                    }
                    netCircuitNode.setAdminState(n2);
                    netCircuitNode.setState(2);
                }
            }
            this.adminState = n;
            if (this.dbgOn()) {
                this.debug("setAdminState(): new admin state is " + this.translateAdminState(this.adminState));
            }
            this.setChanged();
        }
        this.notifyChanged();
        if (bl) {
            throw new AdminStateProvisioningError(string + ":\n" + string2);
        }
    }

    private synchronized String validateAdminState(int n) throws AdminStateProvisioningError {
        Iterator iterator = this.getCircuitNodes().iterator();
        boolean bl = this.isOpenEndedVcatCircuit();
        INodeModel iNodeModel = null;
        if (bl) {
            iNodeModel = ((NetVcatTermination)this.vcatGroup.getAllVcatTerms().get(0)).getNodeModel();
        }
        while (iterator.hasNext()) {
            String string;
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            int n2 = n;
            if (this.isMemberOfVcat() && n == 4) {
                if (!bl) {
                    if (netCircuitNode.getNodeModel() != this.getPrimarySource().getNodeModel() && netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                        n2 = 2;
                    }
                } else if (this.getPrimarySource().getNodeModel() == iNodeModel) {
                    if (netCircuitNode.getNodeModel() != iNodeModel) {
                        n2 = 2;
                    }
                } else if (netCircuitNode.getNodeModel() != this.getPrimaryDrop().getNodeModel()) {
                    n2 = 2;
                }
            }
            if ((string = netCircuitNode.validateConnAdminState(n2)) == null) continue;
            return string + netCircuitNode.getName();
        }
        return null;
    }

    private void deriveAdminState() {
        int n = -1;
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            int n2 = netCircuitNode.getAdminState();
            if (NetCcatCircuit.getAdminStatePriority(n2) <= NetCcatCircuit.getAdminStatePriority(n)) continue;
            n = n2;
        }
        if (n != this.adminState) {
            if (this.dbgOn()) {
                this.debug("deriveAdminState(" + this.getCircuitName() + "): " + this.translateAdminState(this.adminState) + " --> " + this.translateAdminState(n));
            }
            this.adminState = n;
        }
    }

    public static int getAdminStatePriority(int n) {
        int n2;
        switch (n) {
            case 4: {
                n2 = 5;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case -1: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredConnection(INetElement iNetElement, Object object) {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            try {
                if (!this.isCircuitRefValid()) {
                    return;
                }
                NetCircuitNode netCircuitNode = this.getCircuitNodeFromConn(iNetElement, (IConnectionModel)object);
                if (netCircuitNode != null && netCircuitNode.deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing connection delete event for " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    }
                    this.disposeConnection(netCircuitNode, false);
                }
                if ((netCircuitNode = this.getCircuitNodeFromConn(iNetElement, (IConnectionModel)object)) == null) {
                    Object object2;
                    List list = this.getCircuitNodeFromNE(iNetElement);
                    if (list != null) {
                        object2 = list.iterator();
                        while (object2.hasNext()) {
                            NetCircuitNode netCircuitNode2 = (NetCircuitNode)object2.next();
                            if (netCircuitNode2.getConn() != null || this.getState() == 0) continue;
                            netCircuitNode2.setConnection(object);
                            return;
                        }
                    }
                    if (list != null && list.size() == 1 && !(list.get(0) instanceof DualConnectionCircuitNode) && !((NetCircuitNode)(object2 = (NetCircuitNode)list.get(0))).getConn().equals(object) && this instanceof HoCcatCircuit && this.getPathIndexOfXm((NetCircuitNode)object2)) {
                        if (this.dbgOn()) {
                            this.debug("Adding discovered connection (same NE) to " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                        }
                        this.checkForTunnelCktPromotion(object);
                        netCircuitNode = NetCircuitNodeFactory.createDualConnectionCircuitNode((NetCircuitNode)object2, object);
                        this.completeCheck();
                    }
                    if ((netCircuitNode = this.getCircuitNodeFromConn(iNetElement, (IConnectionModel)object)) == null) {
                        if (this.dbgOn()) {
                            this.debug("Adding discovered connection to " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                        }
                        this.checkForTunnelCktPromotion(object);
                        netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this, object);
                        if (netCircuitNode != null) {
                            this.insertCktNode(netCircuitNode);
                            this.completeCheck();
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (this.dbgOn()) {
                    this.debug("Exception in NetCcatCircuit::addDiscoveredConnection");
                    this.debug("could not add discovered connection to " + this.getCircuitName() + "(" + NetCcatCircuit.prettyString(this.circuitId) + ")" + " at " + iNetElement.getName());
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.addWrongConnObj(object);
            }
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent("NCcatCkt::addDiscoveredConn : ckt: " + this.getCircuitName() + "node: " + iNetElement.getName());
        }
        this.notifyChanged();
    }

    private void checkForTunnelCktPromotion(Object object) {
        if (this.circuitInfoActive()) {
            return;
        }
        if (!(object instanceof ILoAditModel) && !(object instanceof IOchTrailAditModel)) {
            return;
        }
        IConnectionModel iConnectionModel = (IConnectionModel)object;
        ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iConnectionModel.getNodeModel()).getTdmProtocolTypeObj();
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (iCircuitType.isHoCircuitType()) {
            if (this.dbgOn()) {
                this.debug("Promoting HO circuit to LAP");
            }
            this.setCircuitType(iTdmProtocolType.getAggCircuitType());
        } else if (iCircuitType.isOchncType()) {
            if (this.dbgOn()) {
                this.debug("Promoting OCHNC circuit to OCH-Trail Tunnel");
            }
            this.setCircuitType(15);
        } else if (iCircuitType.isLAPCircuitType()) {
            if (this.dbgOn()) {
                this.debug("Promoting LAP circuit to LOT");
            }
            this.setCircuitType(iTdmProtocolType.getTunnelCircuitType());
        }
    }

    public void disposeLTN(NetCircuitNode netCircuitNode) {
        this.disposeConnection(netCircuitNode, false);
    }

    protected synchronized void disposeConnection(NetCircuitNode netCircuitNode, boolean bl) {
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("disposeConnection: circuit node not known!");
            }
            return;
        }
        INetElement iNetElement = netCircuitNode.getNetElement();
        Object var4_4 = null;
        NetCircuitNode netCircuitNode2 = null;
        DualConnectionCircuitNode dualConnectionCircuitNode = null;
        boolean bl2 = false;
        boolean bl3 = false;
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 1) {
                bl3 = true;
                netCircuitNode2 = list.get(0).equals(netCircuitNode) ? (NetCircuitNode)list.get(1) : (NetCircuitNode)list.get(0);
            } else {
                bl2 = ((NetCircuitNode)list.get(0)).hasDualConnections();
                if (bl2) {
                    dualConnectionCircuitNode = (DualConnectionCircuitNode)list.get(0);
                    netCircuitNode2 = dualConnectionCircuitNode.getOtherNode(netCircuitNode);
                    bl3 = true;
                }
            }
        }
        if (this.dbgOn()) {
            db.println("Disposing connection from " + NetCcatCircuit.prettyString(this.circuitId) + " at Node " + iNetElement.getName() + " for circuit " + this.getCircuitName());
        }
        if (netCircuitNode instanceof OchTrailTunnelNode && !bl3 && (netCircuitNode2 = this.getConnectedOchncCircuitNode(netCircuitNode)) != null) {
            bl3 = true;
        }
        netCircuitNode.destroy();
        this.removeCktNode(netCircuitNode);
        if (bl3) {
            if (bl2) {
                this.removeCktNode(dualConnectionCircuitNode);
                dualConnectionCircuitNode.parentDispose();
            }
            if (netCircuitNode2 != null) {
                if (netCircuitNode2 instanceof OchTrailTunnelNode) {
                    OchTrailTunnelNode ochTrailTunnelNode = (OchTrailTunnelNode)netCircuitNode2;
                    NetCircuitNode netCircuitNode3 = (NetCircuitNode)ochTrailTunnelNode.getOchccConnection();
                    if (netCircuitNode3 != null) {
                        if (db.on()) {
                            db.println("re-creating splice listener on OCHCC.");
                        }
                        netCircuitNode3.createSpliceListener(ochTrailTunnelNode.getConnectionPathEnd(0));
                    }
                } else if (bl2) {
                    netCircuitNode2.disposeActiveInternalSpliceLink(dualConnectionCircuitNode);
                    this.insertCktNode(netCircuitNode2);
                } else {
                    netCircuitNode2.disposeActiveInternalSpliceLink();
                }
            }
        }
        if (bl) {
            if (!this.circuitInfoActive()) {
                if (!this.tl1CircuitCompleteCheck()) {
                    this.checkAndUpdateCircuit();
                }
            } else if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    private NetCircuitNode getConnectedOchncCircuitNode(NetCircuitNode netCircuitNode) {
        NetCircuitNode netCircuitNode2 = null;
        if (netCircuitNode.isOchTrailTunnelNode()) {
            for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
                NetCircuitNode netCircuitNode3 = (NetCircuitNode)netCircuitSpan.getSrcNCN();
                NetCircuitNode netCircuitNode4 = (NetCircuitNode)netCircuitSpan.getDstNCN();
                if (netCircuitNode3 != null && netCircuitNode3.equals(netCircuitNode) && netCircuitNode4 != null && netCircuitNode4.isOchncCircuitNode()) {
                    netCircuitNode2 = netCircuitNode4;
                    break;
                }
                if (netCircuitNode4 == null || !netCircuitNode4.equals(netCircuitNode) || netCircuitNode3 == null || !netCircuitNode3.isOchncCircuitNode()) continue;
                netCircuitNode2 = netCircuitNode3;
                break;
            }
        }
        return netCircuitNode2;
    }

    private synchronized boolean allNodesInactive() {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (netCircuitNode.getState() == 0) continue;
            return false;
        }
        return this.getCktNodeListSize() > 0;
    }

    @Override
    protected synchronized void checkAndUpdateCircuit() {
        if (this.dbgOn()) {
            this.debug("calling checkAndUpdateCircuit on " + this.getCircuitName());
        }
        if (this.getCktNodeListSize() == 0 && this.circuitModel == null) {
            this.finalDispose();
        } else if (this.allNodesInactive() && this.circuitModel == null) {
            this.dispose();
            this.finalDispose();
        } else {
            if (!this.circuitInfoActive()) {
                this.initSourcesAndDrops();
            }
            if (this.inRoll()) {
                this.setState(8);
            } else if (this.inConversion()) {
                this.setState(11);
            } else if (this.getState() == 8) {
                if (this.circuitInfoActive()) {
                    this.setState(4);
                } else {
                    this.setState(6);
                }
            } else if (this.getState() == 5 || this.getState() == 6) {
                this.setState(6);
            } else if (this.getState() != 2 && this.getState() != 0) {
                this.setState(4);
            }
        }
    }

    protected boolean validateCircuitTopology() {
        int[] nArray;
        if (this.dbgOn()) {
            db.println("validateCircuitTopology()");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (netCircuitNode.getSources().size() != 0) {
                ++n;
                ++n3;
                bl = true;
            }
            if (netCircuitNode.getDrops().size() != 0) {
                ++n2;
                if (!bl) {
                    ++n3;
                }
            }
            bl = false;
        }
        if (this.getCktNodeListSize() != 0 && (this.isBidirectional() ? this.validateBidirSrcDropCombo(nArray = new int[]{this.getSourcesSize(), this.getDropsSize(), n, n2, n3}) : this.getSourcesSize() != 0 && this.getSourcesSize() < 3 && n < 3)) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("validateCircuitTopology: Circuit " + this.getCircuitName() + " has invalid nodes/drops/sources");
            db.println("Number of nodes = " + this.getCktNodeListSize());
            db.println("Number of sources = " + this.getSourcesSize());
            db.println("Number of sourceNodes = " + n);
            db.println("Number of drops = " + this.getDropsSize());
            db.println("Number of dropNodes = " + n2);
            db.println("src plus drop nodes = " + n3);
        }
        return false;
    }

    private boolean validateCircuitEndsInTopology() {
        List list;
        NetCircuitNode netCircuitNode;
        INetElement iNetElement;
        if (!this.circuitInfoActive()) {
            return true;
        }
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            iNetElement = netCircuitEnd.getNetElement();
            if (iNetElement == null) {
                if (this.dbgOn()) {
                    db.println("Circuit source " + netCircuitEnd.prettyString() + " is on a non-existing NE");
                }
                return false;
            }
            netCircuitNode = null;
            list = this.getCircuitNodeFromNE(iNetElement);
            if (list != null) {
                netCircuitNode = list.size() > 1 ? this.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
            }
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("The corresponding circuit node on circuit source " + netCircuitEnd.prettyString() + " does not exist");
                }
                return false;
            }
            if (netCircuitEnd.isNodeDrop() || netCircuitEnd.isEtherP2PCircuitEnd() || netCircuitNode.getConnectionPathEnd(netCircuitEnd) != null) continue;
            if (this.dbgOn()) {
                db.println("Circuit source " + netCircuitEnd.prettyString() + " does not have path on the circuit node " + iNetElement.getName());
            }
            return false;
        }
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd;
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            iNetElement = netCircuitEnd.getNetElement();
            if (iNetElement == null) {
                if (this.dbgOn()) {
                    db.println("Circuit drop " + netCircuitEnd.prettyString() + " is on a non-existing NE");
                }
                return false;
            }
            netCircuitNode = null;
            list = this.getCircuitNodeFromNE(iNetElement);
            if (list != null) {
                netCircuitNode = list.size() > 1 ? this.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
            }
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("The corresponding circuit node on circuit drop " + netCircuitEnd.prettyString() + " does not exist");
                }
                return false;
            }
            if (netCircuitEnd.isNodeDrop() || netCircuitEnd.isEtherP2PCircuitEnd() || netCircuitNode.getConnectionPathEnd(netCircuitEnd) != null) continue;
            if (this.dbgOn()) {
                db.println("Circuit drop " + netCircuitEnd.prettyString() + " does not have path on the circuit node " + iNetElement.getName());
            }
            return false;
        }
        return true;
    }

    private boolean validateBidirSrcDropCombo(int[] nArray) {
        for (int i = 0; i < bidirTable.length; ++i) {
            if (!Arrays.equals(nArray, bidirTable[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    synchronized boolean completeCheck() {
        if (this.dbgOn()) {
            db.println("completeCheck() for " + this.getCircuitName() + "; Number of cktNodes = " + this.getCktNodeListSize());
        }
        if (this.inRoll()) {
            this.setState(8);
        }
        if (this.inConversion()) {
            this.setState(11);
        }
        boolean bl = this.setCircuitRoutingDirection();
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("Completeness check failed because Circuit Info is not active");
            }
            this.initSourcesAndDrops();
            return false;
        }
        if (!this.setSrcCircuitNode()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        this.marker.markUpsr();
        this.marker.markDri();
        if (!this.validateCircuitEndsInTopology()) {
            if (this.dbgOn()) {
                db.println("The source and drop info in the circuit model can not completely show up in the circuit path");
            }
            return false;
        }
        if (!this.isNodesStructureComplete()) {
            return false;
        }
        if (this.state == 4) {
            this.cleanupSpliceListeners();
        }
        if (this.dbgOn()) {
            db.println("completeCheck passed. Setting the appropriate state");
        }
        if (this.inRoll() || this.inConversion()) {
            return true;
        }
        this.setState(1);
        if (this.getCircuitTypeObj().isLoCircuitType()) {
            ((LoCcatCircuit)this).setLap();
        }
        if (this.getCircuitTypeObj().isLAPCircuitType()) {
            this.connectLoCircuitsToLAP();
        }
        return true;
    }

    protected synchronized boolean tl1CircuitCompleteCheck() {
        if (this.dbgOn()) {
            db.println("tl1CircuitCompleteCheck() for " + this.getCircuitName() + "; Number of cktNodes = " + this.getCktNodeListSize());
        }
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("circuit Info is Active : CTC ckt.");
            }
            return false;
        }
        boolean bl = this.setCircuitRoutingDirection();
        if (!this.initSourcesAndDrops()) {
            return false;
        }
        if (!bl) {
            return false;
        }
        this.marker.markUpsr();
        this.marker.markDri();
        if (!this.isNodesStructureComplete()) {
            return false;
        }
        if (this.inRoll()) {
            this.setState(8);
        } else if (this.inConversion()) {
            this.setState(11);
        } else {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(5);
                } else {
                    this.setState(4);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isValidConnDir() {
        int n;
        if (this.dbgOn()) {
            db.println("isValidConnDir()");
        }
        NetCircuitNode netCircuitNode2 = null;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = n = this.getCircuitDir();
        for (NetCircuitNode netCircuitNode2 : this.getCircuitNodes()) {
            if (bl) {
                bl = false;
                n2 = n = netCircuitNode2.getConnDir();
                continue;
            }
            n = netCircuitNode2.getConnDir();
            if (n == n2) continue;
            bl2 = false;
        }
        if (bl2) {
            if (this.getCircuitDir() != n) {
                this.setCircuitDir(n);
                this.setChanged();
            }
            return true;
        }
        if (!this.circuitInfoActive() && this.getCircuitDir() == 1) {
            this.setCircuitDir(0);
            this.setChanged();
        }
        if (this.getCircuitDir() == 0 && this.isUpsrCircuit()) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("isValidConnDir() failed");
        }
        return false;
    }

    public boolean isUpsrCircuit() {
        NetCircuitNode netCircuitNode2 = null;
        for (NetCircuitNode netCircuitNode2 : this.getCircuitNodes()) {
            if (!netCircuitNode2.upsrBridgeOrSelector()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUpsrConnection() {
        NetCircuitNode netCircuitNode2 = null;
        for (NetCircuitNode netCircuitNode2 : this.getCircuitNodes()) {
            if (!netCircuitNode2.isUpsrSelectorConn() && !netCircuitNode2.isUpsrBridgeConn()) continue;
            return true;
        }
        return false;
    }

    protected NetCircuitSpan changeNetLinkDir(NetCircuitSpan netCircuitSpan) {
        Object object;
        NetLinkSpan netLinkSpan = (NetLinkSpan)netCircuitSpan.getNetLinkSpan();
        NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuitSpan.getSrcNCN();
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCircuitSpan.getDstNCN();
        eSpanDirection eSpanDirection2 = null;
        eSpanDirection eSpanDirection3 = null;
        if (netCircuitNode != null) {
            eSpanDirection2 = netCircuitNode.findDir(netCircuitSpan);
        }
        if (netCircuitNode2 != null) {
            eSpanDirection3 = netCircuitNode2.findDir(netCircuitSpan);
        }
        if (eSpanDirection2 == null || eSpanDirection3 == null) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: oldSpan has no src or dst NE");
            }
            netCircuitSpan.dispose(false);
            return null;
        }
        INetLink iNetLink = netLinkSpan.getReverseLink();
        if (iNetLink == null || !iNetLink.isValidSrcHoNumber(netCircuitSpan.getDstHoNum()) || !iNetLink.isValidDstHoNumber(netCircuitSpan.getSrcHoNum())) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: oldSpan has invalid reverse link");
            }
            netCircuitSpan.dispose(false);
            return null;
        }
        NetLinkSpan netLinkSpan2 = new NetLinkSpan(netLinkSpan.getReverseLink(), netLinkSpan.getLink(), netLinkSpan.getDstHoNum(), netLinkSpan.getSrcHoNum(), netLinkSpan.getLoNum());
        netLinkSpan2.setOmni(netLinkSpan.getOmni());
        NetCircuitSpan netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan2, null, null);
        netCircuitSpan2.setUpsrLink(netCircuitSpan.getUpsrLink());
        netCircuitSpan2.setSrcState(netCircuitSpan.getDstState());
        netCircuitSpan2.setDstState(netCircuitSpan.getSrcState());
        if (this.dbgOn()) {
            this.debug("changeNetLinkDir:");
            this.debug("  oldSpan: " + netCircuitSpan.prettyString());
            this.debug("  newSpan: " + netCircuitSpan2.prettyString());
        }
        netCircuitSpan.dispose(true);
        if (netCircuitSpan2.getLink().isDeleted()) {
            if (this.dbgOn()) {
                this.debug("changeNetLinkDir: Link is deleted; ");
            }
            return null;
        }
        NetCircuitNode netCircuitNode3 = netCircuitNode2;
        NetCircuitNode netCircuitNode4 = netCircuitNode;
        if (netCircuitNode3 instanceof LoYCircuitNode) {
            ((LoCircuitSpan)netCircuitSpan2).setSrcFabricated();
        }
        if (netCircuitNode4 instanceof LoYCircuitNode) {
            ((LoCircuitSpan)netCircuitSpan2).setDstFabricated();
        }
        boolean bl = false;
        if (netCircuitSpan.getLink().isLAP()) {
            netCircuitNode3 = null;
            netCircuitNode4 = null;
            object = this.getCircuitNodeFromNE(netLinkSpan2.getLink().getSrc());
            if (object != null) {
                if (object.size() > 1 && this.dbgOn()) {
                    this.debug("changeNetLinkDir: LAP has MXPN !!!");
                }
                netCircuitNode3 = (NetCircuitNode)object.get(0);
            }
            if ((object = this.getCircuitNodeFromNE(netLinkSpan2.getLink().getDst())) != null) {
                if (object.size() > 1 && this.dbgOn()) {
                    this.debug("changeNetLinkDir: LAP has MXPN !!!");
                }
                netCircuitNode4 = (NetCircuitNode)object.get(0);
            }
            this.restoreLapHoNode(netCircuitNode3, netCircuitNode4, netLinkSpan2);
            bl = true;
            object = this.getCircuitNodeFromNE(netLinkSpan2.getLink().getSrc());
            if (object != null) {
                if (object.size() > 1 && this.dbgOn()) {
                    this.debug("changeNetLinkDir: LAP has MXPN !!!");
                }
                netCircuitNode3 = (NetCircuitNode)object.get(0);
            }
            if ((object = this.getCircuitNodeFromNE(netLinkSpan2.getLink().getDst())) != null) {
                if (object.size() > 1 && this.dbgOn()) {
                    this.debug("changeNetLinkDir: LAP has MXPN !!!");
                }
                netCircuitNode4 = (NetCircuitNode)object.get(0);
            }
        }
        netCircuitSpan2.setSrcNCN(netCircuitNode3);
        netCircuitSpan2.setDstNCN(netCircuitNode4);
        if (netCircuitNode3 != null) {
            netCircuitNode3.addActiveSpan(netCircuitSpan2, eSpanDirection.reverse(eSpanDirection3));
        }
        if (netCircuitNode4 != null) {
            netCircuitNode4.addActiveSpan(netCircuitSpan2, eSpanDirection.reverse(eSpanDirection2));
        }
        if (this.inCircuitMerge && bl) {
            Object object2 = object = netCircuitNode3 != null ? netCircuitNode3 : netCircuitNode4;
            if (object != null) {
                this.lapNodeCreated((NetCircuitNode)object);
            }
        }
        return netCircuitSpan2;
    }

    protected void restoreLapHoNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, NetLinkSpan netLinkSpan) {
    }

    protected void cleanupSpliceListeners() {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            netCircuitNode.cleanupSpliceListeners();
        }
    }

    protected synchronized boolean isNodesStructureComplete() {
        if (this.dbgOn()) {
            db.println("Node structure complete check");
        }
        if (!this.validateCircuitTopology()) {
            return false;
        }
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            try {
                if (netCircuitNode.completeCheck()) continue;
                if (this.dbgOn()) {
                    db.println("Completeness check failed at node " + netCircuitNode.getNetElement().getName());
                }
                return false;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("AbstractCmsIOException during NodesStructureComplete check");
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                return false;
            }
        }
        if (!this.isValidConnDir()) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("Node structure complete check passed");
        }
        return true;
    }

    protected boolean isStitchedEthernet() {
        return false;
    }

    protected boolean isEthernet() {
        return false;
    }

    @Override
    public void setMemberPrefs(MemberPrefs memberPrefs) {
        this.memberPrefs = memberPrefs;
    }

    public MemberPrefs getMemberPrefs() {
        return this.memberPrefs;
    }

    protected boolean isDriMemberPref() {
        return this.memberPrefs.getPathProtection() == 5;
    }

    public void setInRoll(boolean bl) {
        block8: {
            if (bl) {
                this.setCktOperation(4);
            } else {
                this.setCktOperation(0);
            }
            try {
                if (!this.circuitInfoActive()) {
                    if (!this.tl1CircuitCompleteCheck()) {
                        this.checkAndUpdateCircuit();
                    }
                } else if (!this.completeCheck()) {
                    this.checkAndUpdateCircuit();
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "changed");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!db.on()) break block8;
                db.println("Error setting roll flag");
            }
        }
    }

    public boolean inRoll() {
        if (this.getCktOperation() == 4) {
            return true;
        }
        return this.anyNodeInRoll();
    }

    private boolean anyNodeInRoll() {
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                boolean bl = netCircuitNode.inRoll();
                netCircuitNode.setCurrRollStatus(bl);
                if (!bl) continue;
                return true;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        return false;
    }

    public boolean inConversion() {
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.inConnectionConversion()) continue;
                if (db.on()) {
                    db.println("In conversion on connection is true " + netCircuitNode.getName());
                }
                return true;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return false;
        }
        return false;
    }

    public int getConversionOperation() {
        if (!this.inConversion()) {
            return -1;
        }
        int n = -1;
        try {
            Iterator iterator = this.getCircuitNodes().iterator();
            NetCircuitNode netCircuitNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.inConnectionConversion()) continue;
                n = netCircuitNode.getConversionOp();
                break;
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return -1;
        }
        return n;
    }

    protected void setInConnectionConversion(boolean bl) {
        if (db.on()) {
            db.println("setInConnectionConversion: flag => " + bl);
        }
        if (bl && (this.state == 1 || this.state == 5)) {
            this.setCktOperation(5);
            if (db.on()) {
                db.println("setInConnectionConversion: state => " + EnumStrings.getString(INetCircuitOperation.class, (int)this.getCktOperation()));
            }
            this.setState(11);
        } else if (!bl && this.state == 11) {
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                if (netCircuitNode.getState() != 4) continue;
                if (db.on()) {
                    db.println("setInConnectionConversion: found NCN " + netCircuitNode.getName() + " still in CONN_PEND");
                }
                return;
            }
            if (!this.completeCheck()) {
                this.checkAndUpdateCircuit();
            }
        }
    }

    protected void addActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.insertCktSpan(netCircuitSpan);
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.removeCktSpan(netCircuitSpan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCktSpan(NetCircuitSpan netCircuitSpan) {
        Map map = this.cktSpanList;
        synchronized (map) {
            if (this.cktSpanList.containsKey(netCircuitSpan.getLink())) {
                if (this.dbgOn()) {
                    db.println("insertCktSpan: span already in list; ignored");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("cktSpanList.put(" + netCircuitSpan.getLink().prettyString() + ") to circuit " + NetCcatCircuit.prettyString(this.circuitId));
            }
            this.cktSpanList.put(netCircuitSpan.getLink(), netCircuitSpan);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCktSpan(NetCircuitSpan netCircuitSpan) {
        Map map = this.cktSpanList;
        synchronized (map) {
            if (!this.cktSpanList.containsKey(netCircuitSpan.getLink())) {
                if (this.dbgOn()) {
                    db.println("removeCktSpan: span not found!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("cktSpanList.remove(" + netCircuitSpan.getLink().prettyString() + ") from circuit " + NetCcatCircuit.prettyString(this.circuitId));
            }
            this.cktSpanList.remove(netCircuitSpan.getLink());
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCktNode(NetCircuitNode netCircuitNode) {
        List list = this.getCircuitSpans();
        Map map = this.cktNodeList;
        synchronized (map) {
            Object v;
            if (this.dbgOn()) {
                db.println("insertCktNode(): " + netCircuitNode.getNameAndClass());
            }
            if ((v = this.cktNodeList.get(netCircuitNode.getNetElement())) == null) {
                List<NetCircuitNode> list2 = Collections.synchronizedList(new LinkedList());
                list2.add(netCircuitNode);
                this.cktNodeList.put(netCircuitNode.getNetElement(), list2);
                if (netCircuitNode.hasDualConnections()) {
                    this.updateSpansWithDcn(netCircuitNode, list);
                }
            } else {
                if (this.dbgOn()) {
                    db.println("insertCktNode(): Inserting node to already present List");
                }
                List list3 = (List)v;
                Iterator iterator = list3.iterator();
                boolean bl = false;
                while (iterator.hasNext()) {
                    NetCircuitNode netCircuitNode2 = (NetCircuitNode)iterator.next();
                    if (!netCircuitNode2.equals(netCircuitNode)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    list3.add(netCircuitNode);
                    this.cktNodeList.put(netCircuitNode.getNetElement(), list3);
                    if (netCircuitNode.hasDualConnections()) {
                        this.updateSpansWithDcn(netCircuitNode, list);
                    }
                }
            }
        }
        this.setChanged();
    }

    private void updateSpansWithDcn(NetCircuitNode netCircuitNode, List list) {
        if (!netCircuitNode.hasDualConnections() || list.isEmpty()) {
            return;
        }
        DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode;
        NetCircuitNode netCircuitNode2 = dualConnectionCircuitNode.getFstCircuitNode();
        NetCircuitNode netCircuitNode3 = dualConnectionCircuitNode.getSecCircuitNode();
        for (NetCircuitSpan netCircuitSpan : list) {
            NetCircuitNode netCircuitNode4 = (NetCircuitNode)netCircuitSpan.getSrcNCN();
            NetCircuitNode netCircuitNode5 = (NetCircuitNode)netCircuitSpan.getDstNCN();
            if (netCircuitNode4 != null && (netCircuitNode4 == netCircuitNode2 || netCircuitNode4 == netCircuitNode3)) {
                netCircuitSpan.setSrcNCN(dualConnectionCircuitNode);
            }
            if (netCircuitNode5 == null || netCircuitNode5 != netCircuitNode2 && netCircuitNode5 != netCircuitNode3) continue;
            netCircuitSpan.setDstNCN(dualConnectionCircuitNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCktNode(NetCircuitNode netCircuitNode, boolean bl) {
        List list = this.getCircuitSpans();
        Map map = this.cktNodeList;
        synchronized (map) {
            Object v;
            if (this.dbgOn()) {
                db.println("insertCktNode(): " + netCircuitNode.getNameAndClass());
            }
            if ((v = this.cktNodeList.get(netCircuitNode.getNetElement())) == null) {
                List<NetCircuitNode> list2 = Collections.synchronizedList(new LinkedList());
                list2.add(netCircuitNode);
                this.cktNodeList.put(netCircuitNode.getNetElement(), list2);
                if (netCircuitNode.hasDualConnections()) {
                    this.updateSpansWithDcn(netCircuitNode, list);
                }
            } else {
                if (this.dbgOn()) {
                    db.println("insertCktNode(): Inserting node to already present List");
                }
                List list3 = (List)v;
                Iterator iterator = list3.iterator();
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    NetCircuitNode netCircuitNode2 = (NetCircuitNode)iterator.next();
                    if (!netCircuitNode2.equals(netCircuitNode)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    if (!bl) {
                        list3.clear();
                    }
                    list3.add(netCircuitNode);
                    this.cktNodeList.put(netCircuitNode.getNetElement(), list3);
                    if (netCircuitNode.hasDualConnections()) {
                        this.updateSpansWithDcn(netCircuitNode, list);
                    }
                }
            }
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCktNode(NetCircuitNode netCircuitNode) {
        if (this.srcCircuitNode == netCircuitNode) {
            this.srcCircuitNode = null;
        }
        if (this.secSrcCircuitNode == netCircuitNode) {
            this.secSrcCircuitNode = null;
        }
        Map map = this.cktNodeList;
        synchronized (map) {
            List list;
            if (this.dbgOn()) {
                db.println("removeCktNode(): " + netCircuitNode.getNameAndClass());
            }
            if ((list = (List)this.cktNodeList.get(netCircuitNode.getNetElement())) != null) {
                list.remove(netCircuitNode);
                if (list.isEmpty()) {
                    this.cktNodeList.remove(netCircuitNode.getNetElement());
                }
            }
        }
        this.setChanged();
    }

    @Override
    public LinkedList getRequiredSpans() {
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
            if (netCircuitSpan.getSrcState() != 4) continue;
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    public LinkedList getRequiredSpans(INetElement iNetElement) {
        LinkedList<INetLinkSpan> linkedList = new LinkedList<INetLinkSpan>();
        for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
            INetLink iNetLink;
            if (netCircuitSpan.getSrcState() != 4 || (iNetLink = netCircuitSpan.getNetLinkSpan().getLink()).getSrc() != iNetElement && iNetLink.getDst() != iNetElement) continue;
            linkedList.add(netCircuitSpan.getNetLinkSpan());
        }
        return linkedList;
    }

    protected void removeRoutedSpans() {
        if (this.dbgOn()) {
            db.println("removeRoutedSpans");
        }
        for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
            if (netCircuitSpan.getSrcState() != 2) continue;
            if (netCircuitSpan.getDstState() != 2) {
                if (!this.dbgOn()) continue;
                db.println("span src. is routed, but dst. is not");
                continue;
            }
            if (this.dbgOn()) {
                db.println("removing ROUTED span: " + netCircuitSpan.prettyString());
            }
            this.removeCktSpan(netCircuitSpan);
            this.setChanged();
            NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuitSpan.getSrcNCN();
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCircuitSpan.getDstNCN();
            eSpanDirection eSpanDirection2 = null;
            if (!this.getCircuitTypeObj().isOchncType() && !this.getCircuitTypeObj().isOchTrailTunnelCircuitType() && (this.isBidirectional() || netCircuitSpan.getNetLinkSpan().getOmni())) {
                eSpanDirection2 = eSpanDirection.BIDIRECTIONAL;
            }
            if (netCircuitNode == null) {
                if (this.dbgOn()) {
                    db.println("src circuit node not found");
                }
            } else {
                if (eSpanDirection2 != eSpanDirection.BIDIRECTIONAL) {
                    eSpanDirection2 = eSpanDirection.ORIGINATING;
                }
                netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
            }
            if (netCircuitNode2 == null) {
                if (!this.dbgOn()) continue;
                db.println("dst circuit node not found");
                continue;
            }
            if (eSpanDirection2 != eSpanDirection.BIDIRECTIONAL) {
                eSpanDirection2 = eSpanDirection.TERMINATING;
            }
            netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
        }
    }

    protected void tentative2Routed() throws DeletionError, IncorrectCircuitState {
        this.operator.tentative2Routed();
    }

    protected void tentative2Active() {
        this.operator.tentative2Active();
    }

    protected void setTL1DropPathUnprot() {
        for (NetCircuitDropInfo netCircuitDropInfo : this.getDrops()) {
            netCircuitDropInfo.setPathProt(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revertAdminState() throws AdminStateProvisioningError {
        boolean bl = false;
        Iterator iterator = this.getCircuitNodes().iterator();
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode.getState() != 3) continue;
                try {
                    netCircuitNode.revertAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (this.dbgOn()) {
                        db.println("Unable to revert admin state on " + netCircuitNode.getName() + " " + exception);
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            throw new AdminStateProvisioningError("The circuit could not be reverted to its previous state.");
        }
    }

    @Override
    public void addSource(INetCircuitEnd iNetCircuitEnd) throws SanityCheckFailed {
        if (iNetCircuitEnd != null) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.circuitInfo.getCircuitType(), iNetCircuitEnd);
            if (netCircuitEnd != null) {
                this.circuitInfo.addSrcPoint(netCircuitEnd.getCircuitEnd());
                this.insertSource(netCircuitEnd);
                if (this.srcCircuitNode != null && this.srcCircuitNode.getNetElement() == netCircuitEnd.getNetElement()) {
                    this.srcCircuitNode.addSource(netCircuitEnd);
                } else if (this.secSrcCircuitNode != null && this.secSrcCircuitNode.getNetElement() == netCircuitEnd.getNetElement()) {
                    this.secSrcCircuitNode.addSource(netCircuitEnd);
                }
            } else {
                throw new SanityCheckFailed("Cannot find cktend" + iNetCircuitEnd);
            }
        }
    }

    @Override
    public synchronized void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        this.operator.addDrop(iNetCircuitEnd, routePrefs);
    }

    @Override
    public void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        this.operator.deleteDrop(iNetCircuitEnd);
        if (this.getCktOperation() != 1) {
            this.notifyChanged(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCircuitSpans() {
        LinkedList linkedList;
        Map map = this.cktSpanList;
        synchronized (map) {
            linkedList = new LinkedList(this.cktSpanList.values());
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getCircuitSpanMap() {
        TreeMap treeMap = new TreeMap(new NetLinkComparator());
        Map map = this.cktSpanList;
        synchronized (map) {
            treeMap.putAll(this.cktSpanList);
        }
        return this.cktSpanList;
    }

    @Override
    public List getActiveCircuitSpans() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            if (iNetCircuitSpan.getSrcState() == 4 || iNetCircuitSpan.getDstState() == 4) continue;
            iterator.remove();
        }
        if (this.dbgOn()) {
            db.println("getActiveCircuitSpans: returning " + list.size() + " spans");
        }
        return list;
    }

    @Override
    public List getRoutedCircuitSpans() {
        List list = this.getCircuitSpans();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator.next();
            if (iNetCircuitSpan.getSrcState() == 2 || iNetCircuitSpan.getDstState() == 2) continue;
            iterator.remove();
        }
        if (this.dbgOn()) {
            db.println("getRoutedCircuitSpans: returning " + list.size() + " spans");
        }
        return list;
    }

    @Override
    public int getCircuitSpanNum() {
        return this.cktSpanList.size();
    }

    @Override
    public INetCircuitNode getSrcCircuitNode() {
        return this.srcCircuitNode;
    }

    protected INetCircuitNode getSecSrcCircuitNode() {
        return this.secSrcCircuitNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCircuitNodes() {
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        Map map = this.cktNodeList;
        synchronized (map) {
            LinkedList linkedList2 = new LinkedList(this.cktNodeList.values());
            for (List list : linkedList2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    linkedList.add((NetCircuitNode)iterator.next());
                }
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCircuitNodesMap() {
        TreeMap treeMap = new TreeMap(new NetElemComparator());
        Map map = this.cktNodeList;
        synchronized (map) {
            treeMap.putAll(this.cktNodeList);
        }
        return treeMap;
    }

    protected int getCktNodeListSize() {
        return this.cktNodeList.size();
    }

    @Override
    protected boolean usesNetElement(INetElement iNetElement) {
        return this.doesCircuitUseNetElem(iNetElement) || this.hasSourceWithNetElement(iNetElement);
    }

    @Override
    public boolean doesCircuitUseNetElem(INetElement iNetElement) {
        return this.getCircuitNodeFromNE(iNetElement) != null;
    }

    @Override
    protected boolean doesCircuitUseConn(INetElement iNetElement, IConnectionModel iConnectionModel) {
        NetCircuitNode netCircuitNode = this.getCircuitNodeFromConn(iNetElement, iConnectionModel);
        return netCircuitNode != null;
    }

    @Override
    public List getCircuitNodeFromNE(INetElement iNetElement) {
        List list = null;
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("getCircuitNodeFromNE: null value passed");
            }
        } else {
            list = (List)this.cktNodeList.get(iNetElement);
        }
        return list;
    }

    public NetCircuitNode getDualConnectionCircuitNode(NetCircuitNode netCircuitNode) {
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("getDualConnectionCircuitNode: null value passed");
            }
        } else {
            List list = this.getCircuitNodeFromNE(netCircuitNode.getNetElement());
            if (list != null) {
                for (NetCircuitNode netCircuitNode2 : list) {
                    DualConnectionCircuitNode dualConnectionCircuitNode;
                    if (!(netCircuitNode2 instanceof DualConnectionCircuitNode) || !(dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode2).getFstCircuitNode().equals(netCircuitNode) && !dualConnectionCircuitNode.getSecCircuitNode().equals(netCircuitNode)) continue;
                    return dualConnectionCircuitNode;
                }
            }
        }
        return null;
    }

    @Override
    public NetCircuitNode getCircuitNodeFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        NetCircuitNode netCircuitNode = null;
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("getCircuitNodeFromCktEnd: NE not found for cktEnd");
            }
            return null;
        }
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            for (NetCircuitNode netCircuitNode2 : list) {
                if (netCircuitNode2.containsCktEndInSourcesOrDrops((NetCircuitEnd)iNetCircuitEnd) || netCircuitNode2.containsCktEnd((NetCircuitEnd)iNetCircuitEnd)) {
                    netCircuitNode = netCircuitNode2;
                    break;
                }
                if (!this.getCircuitTypeObj().isOchTrailTunnelCircuitType() || !iNetCircuitEnd.isNodeDrop() || !netCircuitNode2.isOchTrailTunnelNode()) continue;
                netCircuitNode = netCircuitNode2;
                break;
            }
        }
        return netCircuitNode;
    }

    public NetCircuitNode getCircuitNodeFromConn(INetElement iNetElement, IConnectionModel iConnectionModel) {
        NetCircuitNode netCircuitNode = null;
        if (iNetElement == null || iConnectionModel == null) {
            if (this.dbgOn()) {
                db.println("getCircuitNodeFromConn: ne or conn passed null");
            }
            return null;
        }
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            for (NetCircuitNode netCircuitNode2 : list) {
                if (!netCircuitNode2.doesCircuitNodeUseConn(iConnectionModel)) continue;
                netCircuitNode = netCircuitNode2;
                break;
            }
        }
        return netCircuitNode;
    }

    public NetCircuitNode getCircuitNodeWithDropFromNE(INetElement iNetElement) {
        if (iNetElement == null && this.dbgOn()) {
            db.println("getCircuitNodeWithDropFromNE: null value passed");
        }
        NetCircuitNode netCircuitNode2 = null;
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            for (NetCircuitNode netCircuitNode2 : list) {
                if (netCircuitNode2.getDrops().size() == 0) continue;
                return netCircuitNode2;
            }
        }
        return null;
    }

    @Override
    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        return this.getCircuitSpanFromNetLink(iNetLink) != null;
    }

    @Override
    public INetCircuitSpan getCircuitSpanFromNetLink(INetLink iNetLink) {
        return (INetCircuitSpan)this.cktSpanList.get(iNetLink);
    }

    public NetCircuitSpan getCircuitSpanFromSrcCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.net.findNetLinkFromSourceCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        if (iNetLink == null) {
            if (this.dbgOn()) {
                db.println("getCircuitSpanFromCktEnd: link not found for cktEnd");
            }
            return null;
        }
        return (NetCircuitSpan)this.getCircuitSpanFromNetLink(iNetLink);
    }

    public NetCircuitSpan getCircuitSpanFromDstCktEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.net.findNetLinkFromDestinationCktEnd(this.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        if (iNetLink == null) {
            if (this.dbgOn()) {
                db.println("getCircuitSpanFromCktEnd: link not found for cktEnd");
            }
            return null;
        }
        return (NetCircuitSpan)this.getCircuitSpanFromNetLink(iNetLink);
    }

    @Override
    protected List getLinkEndpoints(INetLink iNetLink) {
        NetCircuitEnd netCircuitEnd;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        if ((iNetLink.isLOTunnel() || iNetLink.isLAP()) && !this.getCircuitTypeObj().isLoCircuitType()) {
            return linkedList;
        }
        if (iNetLink.isOchTrailTunnel() && !this.getCircuitTypeObj().isOchccCircuitType()) {
            return linkedList;
        }
        if (iNetLink.isVirtual() && !this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return linkedList;
        }
        Iterator iterator = this.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if ((netCircuitEnd.getEntityIndex() != iNetLink.getSrcEntityIndex() || netCircuitEnd.getNodeId() != iNetLink.getSrc().getNodeId() || !iNetLink.isValidSrcHoNumber(netCircuitEnd.getHoLoNum().getHoNum())) && (netCircuitEnd.getEntityIndex() != iNetLink.getDstEntityIndex() || netCircuitEnd.getNodeId() != iNetLink.getDst().getNodeId() || !iNetLink.isValidDstHoNumber(netCircuitEnd.getHoLoNum().getHoNum()))) continue;
                linkedList.add(netCircuitEnd);
            }
            iterator = this.getDropCktEnds().iterator();
        }
        if (this.getState() == 4) {
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                netCircuitEnd = netCircuitNode.getLinkEndpoint(iNetLink);
                if (netCircuitEnd == null) continue;
                linkedList.add(netCircuitEnd);
            }
        }
        if (this.getState() == 8) {
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                INetLink iNetLink2;
                netCircuitEnd = NetCircuitRollOperator.getRollToCktEnd(netCircuitNode);
                if (netCircuitEnd != null && ((iNetLink2 = this.net.findNetLinkFromSource(false, netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum())) == iNetLink || iNetLink2 == iNetLink.getReverseLink())) {
                    linkedList.add(netCircuitEnd);
                }
                if ((netCircuitEnd = NetCircuitRollOperator.getRollFromCktEnd(netCircuitNode)) == null || netCircuitNode.getSpanFromCktEnd(netCircuitEnd) != null || (iNetLink2 = this.net.findNetLinkFromSource(false, netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum())) != iNetLink && iNetLink2 != iNetLink.getReverseLink()) continue;
                linkedList.add(netCircuitEnd);
            }
        }
        return linkedList;
    }

    @Override
    public synchronized void addCircuitSpan(INetLinkSpan iNetLinkSpan) throws NoRoute {
        this.operator.addCircuitSpan(iNetLinkSpan, null);
    }

    protected synchronized void addCircuitSpan(INetLinkSpan iNetLinkSpan, RoutePrefs routePrefs) throws NoRoute {
        this.operator.addCircuitSpan(iNetLinkSpan, routePrefs);
    }

    @Override
    public synchronized void deleteCircuitSpan(INetLinkSpan iNetLinkSpan) {
        this.operator.removeRoutedCircuitSpan(iNetLinkSpan);
    }

    protected synchronized void addCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        this.operator.addCircuitSpan(netLinkSpan, netCircuitNode, eSpanDirection2);
    }

    public synchronized void deleteCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        this.operator.deleteCircuitSpan(netLinkSpan, netCircuitNode, eSpanDirection2);
    }

    @Override
    public synchronized void destroySanityCheck() throws SanityCheckFailed {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            netCircuitNode.destroySanityCheck();
        }
    }

    @Override
    public synchronized boolean hasMonitor() {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (!netCircuitNode.hasMonitor()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMxpn() {
        for (List list : this.getCircuitNodesMap().values()) {
            if (list.size() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMxpnOnIntermediateNEs() {
        for (List list : this.getCircuitNodesMap().values()) {
            INetCircuitNode iNetCircuitNode;
            INetElement iNetElement;
            if (list.size() <= 1 || (iNetElement = (iNetCircuitNode = (INetCircuitNode)list.get(0)).getNetElement()).equals(this.getPrimarySource().getNetElement())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            this.operator.destroyCircuit();
        }
        this.notifyDeleted(false);
    }

    @Override
    protected synchronized void dispose() {
        if (this.dbgOn()) {
            db.println("dispose circuit: " + this.getCircuitName());
        }
        super.destroy();
        this.deleteCircuitInfoObserver();
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            netCircuitNode.destroy();
            this.removeCktNode(netCircuitNode);
        }
    }

    protected void sanityCheckBlsrDri(Map map) throws SanityCheckFailed {
        this.operator.sanityCheckBlsrDri(map);
    }

    @Override
    public synchronized LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        return this.operator.sanityCheckSRGs();
    }

    @Override
    public synchronized void sanityCheckManualRouting() throws SanityCheckFailed {
        this.operator.sanityCheckManualRouting();
    }

    @Override
    public synchronized void sanityCheck() throws SanityCheckFailed {
        this.operator.sanityCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl = false;
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            bl = this.operator.provision();
        }
        if (bl) {
            this.clearChanged();
            if (!this.isMemberOfVcat()) {
                this.ncMgr.notifyChanged(this);
            }
        } else {
            this.notifyChanged(false);
        }
    }

    protected boolean setSrcCircuitNode() {
        if (this.dbgOn()) {
            db.println("setSrcCircuitNode()");
        }
        if (this.getSourcesSize() == 0) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: source list is empty!");
            }
            this.srcCircuitNode = null;
            return false;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
        INetElement iNetElement = netCircuitEnd.getNetElement();
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find NE in the network");
            }
            this.srcCircuitNode = null;
            return false;
        }
        this.srcNodeModel = iNetElement.getNodeModel();
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            this.srcCircuitNode = list.size() > 1 ? this.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
        }
        if (this.srcCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode: Unable to find srcCircuitNode => " + iNetElement.getActualAddressDisplay());
            }
            return false;
        }
        String string = this.getCircuitNameFromSrcNode();
        this.updateCircuitName(string);
        return true;
    }

    protected boolean setSrcCircuitNode(NetCircuitNode netCircuitNode) {
        if (this.dbgOn()) {
            db.println("setSrcCircuitNode(ncn)");
        }
        this.srcCircuitNode = netCircuitNode;
        if (netCircuitNode != null) {
            this.srcNodeModel = netCircuitNode.getNodeModel();
        } else {
            if (this.dbgOn()) {
                db.println("setSrcCircuitNode(ncn): ncn is NULL");
            }
            this.srcNodeModel = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List createNewCircuitModel(String string) throws CircuitProvError, SanityCheckFailed {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            if (!this.setSrcCircuitNode()) {
                throw new SanityCheckFailed("The source of the circuit is unknown.");
            }
            int n = this.isCircuitProtected() ? 0 : 2;
            for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
                netCircuitDropInfo.setPathProt(n);
            }
            this.updateCircuitDropInfo();
            if (string != null) {
                this.setCircuitName(string);
            }
            this.operator.createCircuitInfo(this.srcNodeModel, this.circuitInfo);
            if (this.dbgOn()) {
                this.debug("upgrade(): Allocated circuitID: " + NetCcatCircuit.prettyString(this.circuitId));
            }
            LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
            Iterator iterator = this.getCircuitNodes().iterator();
            HashMap<NetCircuitNode, Object[]> hashMap = new HashMap<NetCircuitNode, Object[]>();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                Object[] objectArray = new Object[2];
                objectArray[0] = NetCircuitNode.getConnCircuitId(netCircuitNode.getConn());
                objectArray[1] = netCircuitNode.getConnName();
                hashMap.put(netCircuitNode, objectArray);
                try {
                    netCircuitNode.setConnectionCircuitId(this.circuitId);
                    netCircuitNode.cleanupSpliceListeners();
                    if (string == null) continue;
                    netCircuitNode.setConnName(string);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    linkedList.add(netCircuitNode);
                    for (NetCircuitNode netCircuitNode2 : hashMap.keySet()) {
                        if (netCircuitNode2 == netCircuitNode) continue;
                        Object[] objectArray2 = (Object[])hashMap.get(netCircuitNode2);
                        netCircuitNode2.setConnectionCircuitId((ICircuitId)objectArray2[0]);
                        netCircuitNode2.setConnName((String)objectArray2[1]);
                    }
                    return linkedList;
                }
            }
            if (linkedList.size() != 0) {
                return linkedList;
            }
            this.setState(1);
            this.setCktOperation(0);
            this.completeCheck();
            if (this.dbgOn()) {
                this.debug("createNewCircuitModel() successful for " + this.getCircuitName());
            }
        }
        this.notifyChanged();
        return new LinkedList();
    }

    protected boolean isBiDirSpanKnown(NetCircuitSpan netCircuitSpan) {
        return this.cktSpanList.containsKey(netCircuitSpan.getLink()) || this.cktSpanList.containsKey(netCircuitSpan.getReverseLink());
    }

    protected synchronized void updateCircuitNodeConnectionPaths() {
        Iterator iterator = this.getCircuitNodes().iterator();
        if (this.dbgOn()) {
            db.println("updateCircuitNodeConnectionPaths: updating NCN Connection Paths");
        }
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            netCircuitNode.updateConnectionPathEnds();
        }
    }

    private boolean getPathIndexOfXm(NetCircuitNode netCircuitNode) {
        if (netCircuitNode.getConn() == null) {
            return false;
        }
        for (NetCircuitEnd netCircuitEnd : netCircuitNode.getPathEndsFromPathDefs(netCircuitNode.getConnectionPathDefs())) {
            if (!netCircuitEnd.onXm()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected synchronized boolean unify(NetCcatCircuit netCcatCircuit) {
        Object object2;
        void var4_8;
        block49: {
            block50: {
                NetCcatCircuit netCcatCircuit2 = netCcatCircuit;
                // MONITORENTER : netCcatCircuit2
                boolean bl = false;
                if (!this.isYCircuit() && !netCcatCircuit.isYCircuit()) {
                    bl = this.checkForRefreshCircuit(netCcatCircuit);
                }
                if (bl) {
                    NetCircuitManager.instance().refreshCircuit(this);
                    NetCircuitManager.instance().refreshCircuit(netCcatCircuit);
                    // MONITOREXIT : netCcatCircuit2
                    return false;
                }
                if (this.dbgOn()) {
                    db.println("Unify method called for two CCAT circuits");
                }
                if (!(NetCcatCircuit.isNullCircuitId(this.circuitId) || NetCcatCircuit.isNullCircuitId(netCcatCircuit.circuitId) || this.circuitId.equals(netCcatCircuit.circuitId))) {
                    if (this.dbgOn()) {
                        db.println("Cannot Unify two circuits with different circuit Ids");
                    }
                    // MONITOREXIT : netCcatCircuit2
                    return false;
                }
                if (!this.circuitInfoActive()) {
                    ITdmProtocolType iTdmProtocolType = this.getSrcNetElement().getTdmProtocolTypeObj();
                    if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                        if (this.getCircuitTypeObj().isLAPCircuitType()) {
                            this.setCircuitType(iTdmProtocolType.getTunnelCircuitType());
                        } else {
                            this.setCircuitType(netCcatCircuit.getCircuitType());
                        }
                    } else if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                        this.setCircuitType(netCcatCircuit.getCircuitType());
                    }
                }
                if (!this.isMemberOfVcat()) break block50;
                if (netCcatCircuit.isMemberOfVcat()) {
                    if (this.getVcatGroup() != netCcatCircuit.getVcatGroup()) {
                        if (this.dbgOn()) {
                            db.println("Two circuits belong to two different VCAT circuits");
                            db.println("copy the content of the other vcat group to this circuit");
                            db.println("destroy the other vcat circuit");
                        }
                        if (!this.getVcatGroup().unify(netCcatCircuit.getVcatGroup(), false)) {
                            // MONITOREXIT : netCcatCircuit2
                            return false;
                        }
                        this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                        break block49;
                    } else {
                        if (this.dbgOn()) {
                            db.println("Two circuits belong to the same VCAT circuit");
                            db.println("remove the other circuit from the vcat group");
                        }
                        this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                    }
                    break block49;
                } else if (this.dbgOn()) {
                    db.println("This circuit is part of a VCAT circuit, but the other circuit is not");
                    db.println("just unify the two member circuits");
                }
                break block49;
            }
            if (netCcatCircuit.isMemberOfVcat()) {
                if (this.dbgOn()) {
                    db.println("The other circuit is part of a VCAT circuit, but this circuit is not");
                    db.println("add this circuit to the vcat group and remove the other circuit from the vcat group");
                }
                this.initVcatGroup(netCcatCircuit.getVcatGroup());
                this.getVcatGroup().insertMemberCircuit(this);
                this.memberStatusMap.putAll(netCcatCircuit.memberStatusMap);
                this.ncMgr.convertCcatToMember(this);
            } else if (this.dbgOn()) {
                db.println("Neither circuit is part of a VCAT circuit");
            }
        }
        Object var4_6 = null;
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        for (NetCircuitNode netCircuitNode3 : netCcatCircuit.getCircuitNodes()) {
            if (this.getCircuitNodeFromNE(netCircuitNode3.getNetElement()) == null) continue;
            INetElement iNetElement = netCircuitNode3.getNetElement();
            break;
        }
        boolean bl = false;
        if (var4_8 != null) {
            object2 = this.getCircuitNodeFromNE((INetElement)var4_8);
            if (object2 != null) {
                if (object2.size() > 1) {
                    netCircuitNode = null;
                } else {
                    netCircuitNode = (NetCircuitNode)object2.get(0);
                    if (netCircuitNode instanceof DualConnectionCircuitNode) {
                        netCircuitNode = null;
                    }
                }
            }
            if ((object2 = netCcatCircuit.getCircuitNodeFromNE((INetElement)var4_8)) != null) {
                if (object2.size() > 1) {
                    netCircuitNode2 = null;
                } else {
                    netCircuitNode2 = (NetCircuitNode)object2.get(0);
                    if (netCircuitNode2 instanceof DualConnectionCircuitNode) {
                        netCircuitNode2 = null;
                    }
                }
            }
            bl = netCircuitNode == null || netCircuitNode2 == null || this.getCircuitTypeObj().isSVLANType() ? false : this.sameNEUnifyAllowed(netCircuitNode, netCircuitNode2);
        }
        if (bl) {
            object2 = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode, netCircuitNode2);
            netCircuitNode2.setCircuit(this);
            this.removeCktNode(netCircuitNode);
            this.insertCktNode((NetCircuitNode)object2);
            for (NetCircuitNode netCircuitNode4 : netCcatCircuit.getCircuitNodes()) {
                if (netCircuitNode4 == netCircuitNode2) continue;
                this.insertCktNode(netCircuitNode4);
            }
        } else {
            for (Object object2 : netCcatCircuit.getCircuitNodes()) {
                this.insertCktNode((NetCircuitNode)object2);
            }
        }
        if (this instanceof LoCcatCircuit) {
            ((LoCcatCircuit)this).isYCircuit = ((LoCcatCircuit)this).isYCircuit || ((LoCcatCircuit)netCcatCircuit).isYCircuit;
        }
        netCcatCircuit.cktNodeList.clear();
        this.cktSpanList.putAll(netCcatCircuit.cktSpanList);
        netCcatCircuit.cktSpanList.clear();
        this.setChanged();
        if (this.dbgOn()) {
            db.println("Unified ckt has " + this.getCircuitNodes().size() + " nodes, and " + this.cktSpanList.values().size() + " spans");
        }
        for (NetCircuitNode netCircuitNode4 : this.getCircuitNodes()) {
            netCircuitNode4.setCircuit(this);
            netCircuitNode4.setInternalSpliceLinkEnds();
        }
        this.conformToCircuitInfo();
        netCcatCircuit.finalDispose();
        // MONITOREXIT : netCcatCircuit2
        if (!this.circuitInfoActive()) {
            if (this.tl1CircuitCompleteCheck()) return true;
            try {
                if (this.inRoll()) {
                    this.setState(8);
                    return true;
                }
                if (this.isTl1Ckt()) {
                    this.setState(6);
                    return true;
                }
                this.setState(4);
                return true;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                return true;
            }
        }
        if (this.completeCheck()) return true;
        if (this.inRoll()) {
            this.setState(8);
            return true;
        }
        this.setState(4);
        return true;
    }

    boolean sameNEUnifyAllowed(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        if (netCircuitNode.hasDualConnections() || netCircuitNode2.hasDualConnections()) {
            if (this.dbgOn()) {
                db.println("Can not unify: more than 2 conns on same NE");
            }
            return false;
        }
        if (!((netCircuitNode instanceof HoCircuitNode && this.getPathIndexOfXm(netCircuitNode) || netCircuitNode instanceof LoTunnelNode) && (netCircuitNode2 instanceof HoCircuitNode && this.getPathIndexOfXm(netCircuitNode2) || netCircuitNode2 instanceof LoTunnelNode))) {
            if (this.dbgOn()) {
                db.println("Can not unify: xconn type does not support 2 conns on same NE");
            }
            return false;
        }
        if (netCircuitNode instanceof HoCircuitNode && netCircuitNode2 instanceof HoCircuitNode) {
            if (netCircuitNode.getTotalInOuts() != 2) {
                return false;
            }
            if (netCircuitNode.getSources().isEmpty() && netCircuitNode.getDrops().isEmpty()) {
                return false;
            }
            if (netCircuitNode2.getTotalInOuts() != 2) {
                return false;
            }
            if (netCircuitNode2.getSources().isEmpty() && netCircuitNode2.getDrops().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void reloadTl1Objects() {
        if (!this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                db.println("Calling reloadTl1Objects() for ckt : " + this.getCircuitName());
            }
            LinkedList linkedList = this.getCktInfoEndPoints();
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                if (!NetCcatCircuit.isNullCircuitId(netCircuitNode.getCircuitId()) || netCircuitNode.connEndsPartOfCktEnd(linkedList)) continue;
                if (this.dbgOn()) {
                    db.println("Reloading TL1 connection on node : " + netCircuitNode.getName());
                }
                this.disposeConnection(netCircuitNode, false);
                NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
            }
        }
    }

    @Override
    protected void disposeCircuitInfoAtNodes() {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("disposeCircuitInfoAtNodes: FAILURE! circuitInfo is active");
            }
            return;
        }
        if (!this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                this.debug("disposeCircuitInfoAtNodes() called for " + this.getCircuitName());
            }
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                netCircuitNode.disposeCircuitInfo();
            }
        }
    }

    @Override
    protected boolean isTl1Ckt() throws IncorrectCircuitState {
        if (this.circuitInfoActive()) {
            if (this.dbgOn()) {
                this.debug("isTl1Ckt: " + this.getCircuitName() + ": CircuitInfo is ACTIVE !!");
            }
            throw new IncorrectCircuitState("The circuit information has been discovered.");
        }
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (netCircuitNode instanceof DualConnectionCircuitNode) {
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode;
                arrayList.add(dualConnectionCircuitNode.getFstCircuitNode());
                arrayList.add(dualConnectionCircuitNode.getSecCircuitNode());
                continue;
            }
            arrayList.add(netCircuitNode);
        }
        CircuitId circuitId = new CircuitId(0, 0);
        CircuitId circuitId2 = new CircuitId(0, 0);
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        for (NetCircuitNode netCircuitNode : arrayList) {
            if (netCircuitNode == null || netCircuitNode.getConn() == null) continue;
            bl2 = false;
            circuitId = netCircuitNode.getCircuitId();
            if ((netCircuitNode instanceof LoTunnelNode || netCircuitNode instanceof OchTrailTunnelNode) && circuitId.getUniquePart().getUniqueId() == 0) {
                circuitId = new CircuitId(0, 0);
            }
            if (NetCcatCircuit.isNullCircuitId(circuitId)) {
                bl3 = true;
                continue;
            }
            if (bl) {
                if (((Object)circuitId).equals(circuitId2)) continue;
                if (this.dbgOn()) {
                    this.debug("isTl1Ckt: " + this.getCircuitName() + " failed:Found two circuitIds " + circuitId2 + " and " + circuitId);
                }
                throw new IncorrectCircuitState("The circuit has multiple circuit IDs.");
            }
            bl = true;
            circuitId2 = circuitId;
        }
        if (bl2) {
            if (this.dbgOn()) {
                this.debug("All nodes were skipped.");
            }
            return bl3;
        }
        if (this.dbgOn()) {
            this.debug("isTl1Ckt: " + bl3 + " for " + this.getCircuitName() + ", cktId = " + NetCcatCircuit.prettyString(circuitId2));
        }
        if (NetCcatCircuit.isNullCircuitId(this.circuitId) ^ NetCcatCircuit.isNullCircuitId(circuitId2)) {
            this.ncMgr.removeCircuit(this);
            this.updateCircuitId(circuitId2);
            this.ncMgr.insertCircuit(this, false);
        }
        return bl3;
    }

    protected boolean initSourcesAndDrops() {
        INetCircuitEnd iNetCircuitEnd2;
        if (this.circuitInfoActive()) {
            return false;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = this.setCircuitLevelSourcesAndDrops(arrayList, arrayList2);
        if (this.dbgOn()) {
            db.println("initSourcesAndDrops():");
            db.println(" Node-level sources: ");
            for (INetCircuitEnd iNetCircuitEnd2 : arrayList) {
                db.println("   " + ((NetCircuitEnd)iNetCircuitEnd2).prettyString());
            }
            db.println(" Node-level drops: ");
            for (INetCircuitEnd iNetCircuitEnd2 : arrayList2) {
                db.println("   " + ((NetCircuitEnd)iNetCircuitEnd2).prettyString());
            }
        }
        boolean bl2 = false;
        if (arrayList.size() == 0 && arrayList2.size() != 0 && this.isBidirectional()) {
            bl2 = true;
        } else if (this.getCircuitTypeObj().isLAPCircuitType() && arrayList.size() > 0 && (iNetCircuitEnd2 = (INetCircuitEnd)arrayList.get(0)) != null && iNetCircuitEnd2.isNodeDrop()) {
            bl2 = true;
        }
        if (bl2) {
            try {
                bl = this.reverseRoutingDir();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (this.dbgOn()) {
                    this.debug("InitSourcesDrops: Error during circuit reversal");
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean setCircuitLevelSourcesAndDrops() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        return this.setCircuitLevelSourcesAndDrops(arrayList, arrayList2);
    }

    public boolean setCircuitLevelSourcesAndDrops(List list, List list2) {
        NetCircuitEnd netCircuitEnd;
        this.setSources(null);
        this.setDrops(null);
        this.setChanged();
        this.getNodeLevelSourcesAndDrops(list, list2);
        if (list.size() == 0) {
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                netCircuitEnd = netCircuitNode.convertSpliceListenerToSourceOrDrop(eSpanDirection.TERMINATING);
                if (netCircuitEnd == null) continue;
                list.add(netCircuitEnd);
                break;
            }
        }
        if (list2.size() == 0) {
            for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
                netCircuitEnd = netCircuitNode.convertSpliceListenerToSourceOrDrop(eSpanDirection.ORIGINATING);
                if (netCircuitEnd == null) continue;
                list2.add(netCircuitEnd);
                break;
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.insertSource((NetCircuitEnd)iterator.next());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.insertDrop(new NetCircuitDropInfo((NetCircuitEnd)iterator.next(), 2));
        }
        this.updateCircuitSourceInfo();
        this.updateCircuitDropInfo();
        return this.setSrcCircuitNode();
    }

    protected void tl1RemoveLapNode() {
    }

    protected void setPathProtForDrops(boolean bl) {
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            if (bl) {
                netCircuitDropInfo.setPathProt(0);
                continue;
            }
            netCircuitDropInfo.setPathProt(2);
        }
        this.updateCircuitDropInfo();
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            list.addAll(netCircuitNode.getSources());
            list2.addAll(netCircuitNode.getDrops());
        }
    }

    protected NetCircuitEnd getNodeDrop() {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (!netCircuitNode.isNodeDrop()) continue;
            return netCircuitNode.getNodeDrop();
        }
        return null;
    }

    @Override
    protected void conformToCircuitInfo() {
        if (!this.circuitInfoActive()) {
            return;
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitNode)iterator.next()).conformToCircuitInfo();
        }
    }

    @Override
    protected void runChildUpdate() {
        List list = this.getCircuitNodes();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetCircuitNode)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during node update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
        list = this.getCircuitSpans();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((NetCircuitSpan)iterator.next()).runUpdate();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("AbstractCmsIOException during span update");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    protected Connection findBlsrDriPrimary(Connection connection) {
        Iterator iterator = this.getCircuitNodes().iterator();
        if (this.dbgOn()) {
            db.println("findBlsrDriPrimary: starting search for the primary handoff connection that feeds " + connection.getName() + " on node " + connection.getNodeName());
        }
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!NetCircuitNodeUtil.isBlsrDriPrimary(netCircuitNode.getDriNodeType())) continue;
            for (Connection connection2 : netCircuitNode.connections) {
                if (!connection.isFedBy(connection2)) continue;
                return connection2;
            }
        }
        return null;
    }

    protected boolean getOrderedNodeAndSpanList(INetLink iNetLink, INetLink iNetLink2, List list, List list2) {
        Object object;
        Object object22;
        Object object32;
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        if (this.dbgOn()) {
            db.println("getOrderedNodeAndSpanList: ");
        }
        for (Object object32 : this.getCircuitSpans()) {
            linkedList.add(((NetCircuitSpan)object32).getLink());
        }
        if (this.dbgOn()) {
            db.println("Spt.getLinksBtwTwoLinks fromLink  " + (iNetLink == null ? " " : iNetLink.prettyString()) + " toLink " + (iNetLink2 == null ? " " : iNetLink2.prettyString()) + " starting from node " + this.srcCircuitNode.getName());
        }
        object32 = null;
        if (this.getSecondarySource() != null && this.getSecondarySource().getNetElement() != this.srcCircuitNode.getNetElement()) {
            object32 = this.getSecondarySource().getNetElement();
        }
        List list3 = Spt.getLinksBtwTwoLinks(this.srcCircuitNode.getNetElement(), (INetElement)object32, linkedList, iNetLink, iNetLink2);
        Iterator iterator = list3.iterator();
        for (Object object22 : list3) {
            Object object4;
            object = this.getCircuitSpanFromNetLink((INetLink)object22);
            if (!list2.contains(object)) {
                list2.add(object);
            }
            if (!list.contains(object4 = object.getSrcNCN())) {
                list.add(object4);
            }
            if (list.contains(object4 = object.getDstNCN())) continue;
            list.add(object4);
        }
        if (!list2.isEmpty() && (object22 = ((NetCircuitSpan)list2.get(0)).getLink()) != (object = ((NetCircuitSpan)list2.get(list2.size() - 1)).getLink()) && object22.getSrc() == this.getPrimarySource().getNetElement() && object.getDst() == this.getPrimaryDrop().getNetElement() && object22.inBLSR() && object.inBLSR() && this.isDri()) {
            for (Object object4 : this.getCircuitSpans()) {
                if (list2.contains(object4)) continue;
                list2.add(list2.size() - 1, object4);
                INetCircuitNode iNetCircuitNode = ((NetCircuitSpan)object4).getSrcNCN();
                if (!list.contains(iNetCircuitNode)) {
                    list.add(list.size() - 1, iNetCircuitNode);
                }
                if (list.contains(iNetCircuitNode = ((NetCircuitSpan)object4).getDstNCN())) continue;
                list.add(list.size() - 1, iNetCircuitNode);
            }
        }
        if (this.dbgOn()) {
            db.println("getOrderedNodeAndSpanList find " + list.size() + " nodes and " + list2.size() + " spans");
            object22 = list.iterator();
            db.print("found: source --> ");
            while (object22.hasNext()) {
                db.print(((NetCircuitNode)object22.next()).getName() + " --> ");
            }
            db.println(" destination");
        }
        return list3.size() > 0;
    }

    public synchronized boolean containsCktEnd(INetCircuitEnd iNetCircuitEnd) {
        for (Object object : this.getCircuitNodes()) {
            if (!((NetCircuitNode)object).containsCktEnd((NetCircuitEnd)iNetCircuitEnd)) continue;
            return true;
        }
        for (Object object : this.getSources()) {
            if (!((NetCircuitEnd)object).equals(iNetCircuitEnd)) continue;
            return true;
        }
        Iterator iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            Object object;
            object = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (!((NetCircuitEnd)object).equals(iNetCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean createWithStpEnabled() {
        return true;
    }

    @Override
    public boolean hasLoopback() {
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            if (!netCircuitNode.hasLoopback()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOmniSpans() {
        for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
            if (!netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasXcLoopback() {
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            if (!netCircuitNode.hasXcLoopback()) continue;
            return true;
        }
        return false;
    }

    public INetCircuitNode getUpsrSrcNode(List list, INetElement iNetElement) {
        NetCircuitNode netCircuitNode = null;
        List list2 = this.getCircuitNodeFromNE(iNetElement);
        if (list2 != null) {
            if (list2.size() > 1) {
                for (NetCircuitNode netCircuitNode2 : list2) {
                    if (!list.contains(netCircuitNode2)) continue;
                    netCircuitNode = netCircuitNode2;
                    break;
                }
            } else {
                netCircuitNode = (NetCircuitNode)list2.get(0);
            }
        }
        int n = list.indexOf(netCircuitNode);
        for (int i = n - 1; i >= 0; --i) {
            NetCircuitNode netCircuitNode3 = (NetCircuitNode)list.get(i);
            if (!netCircuitNode3.isUpsrBridge()) continue;
            return netCircuitNode3;
        }
        return null;
    }

    public INetCircuitNode getUpsrDstNode(List list, INetElement iNetElement) {
        NetCircuitNode netCircuitNode = null;
        List list2 = this.getCircuitNodeFromNE(iNetElement);
        if (list2 != null) {
            if (list2.size() > 1) {
                for (NetCircuitNode netCircuitNode2 : list2) {
                    if (!list.contains(netCircuitNode2)) continue;
                    netCircuitNode = netCircuitNode2;
                    break;
                }
            } else {
                netCircuitNode = (NetCircuitNode)list2.get(0);
            }
        }
        int n = list.indexOf(netCircuitNode);
        for (int i = n + 1; i < list.size(); ++i) {
            NetCircuitNode netCircuitNode3 = (NetCircuitNode)list.get(i);
            if (!netCircuitNode3.isUpsrSelector()) continue;
            return netCircuitNode3;
        }
        return null;
    }

    public INetCircuitNode getDropNode(List list, INetElement iNetElement) {
        NetCircuitNode netCircuitNode = null;
        List list2 = this.getCircuitNodeFromNE(iNetElement);
        if (list2 != null) {
            if (list2.size() > 1) {
                for (NetCircuitNode netCircuitNode2 : list2) {
                    if (!list.contains(netCircuitNode2)) continue;
                    netCircuitNode = netCircuitNode2;
                    break;
                }
            } else {
                netCircuitNode = (NetCircuitNode)list2.get(0);
            }
        }
        int n = list.indexOf(netCircuitNode);
        for (int i = n + 1; i < list.size(); ++i) {
            NetCircuitNode netCircuitNode3 = (NetCircuitNode)list.get(i);
            if (netCircuitNode3.getDrops().isEmpty() && !netCircuitNode3.isNodeDrop()) continue;
            return netCircuitNode3;
        }
        return null;
    }

    @Override
    public void setUpsrSelectorAttributes(IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl) {
        if (this.dbgOn()) {
            db.println("setUpsrSelectorAttributes " + this.getCircuitName());
        }
        this.upsrReversion = iRevertiveBehavior;
        this.upsrSfBerLevel = s;
        this.upsrSdBerLevel = s2;
        this.upsrSwitchOnPdip = bl;
    }

    @Override
    public IHoUpsrAttributes getUpsrAttributes() {
        if (this.upsrReversion == null) {
            return null;
        }
        HoUpsrAttributes hoUpsrAttributes = new HoUpsrAttributes(this.upsrSfBerLevel, this.upsrSdBerLevel, this.upsrReversion, this.upsrSwitchOnPdip);
        return hoUpsrAttributes;
    }

    protected IRevertiveBehavior getRevertiveBehavior() {
        return this.upsrReversion;
    }

    protected boolean getTrafficDir() {
        return this.go_return_routing;
    }

    protected boolean isInStsUpperHalf(NetCircuitSpan netCircuitSpan) {
        NetCircuit netCircuit;
        INetLink iNetLink = netCircuitSpan.getLink();
        if (iNetLink.isPhysical()) {
            int n = iNetLink.getPhysicalTypeObj().getStsCapacity();
            int n2 = n / 2 + 1;
            int n3 = netCircuitSpan.getSrcHoNum().getFramingType();
            return holoComp.compare(netCircuitSpan.getSrcHoNum(), HoLoFactory.idlSts2HoNum(n3, n2)) >= 0;
        }
        if (iNetLink.isLOTunnel() && (netCircuit = this.ncMgr.findLoTunnel(iNetLink, netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) != null) {
            for (NetCircuitSpan netCircuitSpan2 : netCircuit.getCircuitSpans()) {
                INetLink iNetLink2 = netCircuitSpan2.getLink();
                int n = iNetLink2.getPhysicalTypeObj().getStsCapacity();
                int n4 = n / 2 + 1;
                int n5 = netCircuitSpan2.getSrcHoNum().getFramingType();
                if (holoComp.compare(netCircuitSpan2.getSrcHoNum(), HoLoFactory.idlSts2HoNum(n5, n4)) < 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void connectLoCircuitsToLAP() {
        this.ncMgr.getCircuitsUseLAP(this);
    }

    protected synchronized void lotReuseLoAdits(boolean bl) {
    }

    @Override
    public synchronized void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
        this.operator.addNetElement(iNetElement, routePrefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            this.operator.deleteNetElement(iNetElement);
        }
        this.notifyChanged();
    }

    @Override
    public synchronized void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        this.operator.routeNetElement(iNetElement, routePrefs);
    }

    @Override
    public synchronized void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        this.operator.routeNetElement(iNetElement, iNetElement2, routePrefs);
    }

    @Override
    public INetLink getLotLink() {
        return null;
    }

    @Override
    public INetLink getReverseLotLink() {
        return null;
    }

    @Override
    public INetLink getLapLink() {
        return null;
    }

    @Override
    public INetLink getReverseLapLink() {
        return null;
    }

    @Override
    public boolean isVlanCapable() throws IncorrectCircuitState {
        return false;
    }

    @Override
    public boolean mustDisableStp() throws IncorrectCircuitState {
        return false;
    }

    @Override
    public IVlanModel[] getVlans() {
        return new IVlanModel[0];
    }

    @Override
    public NetVlanInfo[] getNetVlans() {
        return new NetVlanInfo[0];
    }

    @Override
    public void assignVlanSet(IVlanModel[] iVlanModelArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    @Override
    public void assignVlanSet(NetVlanInfo[] netVlanInfoArray) throws IncorrectCircuitState, SanityCheckFailed {
    }

    @Override
    public INetCircuit useLAP() {
        return null;
    }

    protected void destroyLapNode(NetCircuitNode netCircuitNode) {
    }

    protected void lapNodeCreated(NetCircuitNode netCircuitNode) {
    }

    @Override
    public List getLoTunnelNodes() {
        return new LinkedList();
    }

    @Override
    public ILoNum getLoOverHo() {
        return null;
    }

    @Override
    public void createWithStpEnabled(boolean bl) {
    }

    @Override
    public boolean isStpEnabled() {
        return false;
    }

    @Override
    public List getXmCircuitEnds() {
        return new LinkedList();
    }

    public List getSrcInternalSpliceLinkEnds() {
        return new LinkedList();
    }

    public List getDstInternalSpliceLinkEnds() {
        return new LinkedList();
    }

    @Override
    public void setXmCircuitEnds(INetCircuitEnd[] iNetCircuitEndArray) {
    }

    @Override
    public void setXmCircuitEnds(IEntityModel[] iEntityModelArray) {
    }

    @Override
    protected boolean circuitInfoActive() {
        return !this.inCircuitMerge && this.circuitInfoActive;
    }

    public void setInCircuitMerge(boolean bl) {
        this.inCircuitMerge = bl;
    }

    @Override
    public boolean supportsISTU() {
        return true;
    }

    @Override
    public boolean isUpsr1wayTl1() {
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (!netCircuitNode.is1wayUpsrConnType()) continue;
            if (this.dbgOn()) {
                db.println("isUpsr1wayTl1: found true on node " + netCircuitNode.getName());
            }
            return true;
        }
        return false;
    }

    private List<NetCircuitNode> getExtendedNodeList() {
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (netCircuitNode instanceof DualConnectionCircuitNode) {
                arrayList.add(((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode());
                arrayList.add(((DualConnectionCircuitNode)netCircuitNode).getSecCircuitNode());
                continue;
            }
            arrayList.add(netCircuitNode);
        }
        return arrayList;
    }

    protected boolean isPartial() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int deriveServiceState() {
        if (this.dbgOn()) {
            this.debug("deriveServiceState(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = false;
        int n = 0;
        boolean bl6 = false;
        boolean bl7 = false;
        NetCcatCircuit netCcatCircuit = this;
        synchronized (netCcatCircuit) {
            INodeModel iNodeModel = null;
            NetCircuitEnd netCircuitEnd = null;
            NetVcatTermination netVcatTermination = null;
            List<NetCircuitNode> list = this.getExtendedNodeList();
            for (NetCircuitNode netCircuitNode : list) {
                int n2;
                iNodeModel = netCircuitNode.getNodeModel();
                if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.EXTENDED_ESM)) {
                    n2 = netCircuitNode.getServiceState();
                    if (n2 < 0) {
                        bl = false;
                        continue;
                    }
                    ++n;
                    if (!NetServiceState.isFormOfIS(n2)) {
                        bl = false;
                    }
                    if (!NetServiceState.isFormOfOOS(n2)) {
                        bl2 = false;
                    }
                    if (NetServiceState.isFormOfOOS_AU(n2)) {
                        bl5 = true;
                    } else {
                        bl3 = false;
                    }
                    if (NetServiceState.isFormOfOOS_Non_AU(n2)) {
                        bl4 = false;
                    }
                    if (!this.isMemberOfVcat()) continue;
                    netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
                    netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                    if (netVcatTermination != null && netVcatTermination.getNodeModel() == iNodeModel && !NetServiceState.isFormOfOOSOOG(n2)) {
                        bl6 = true;
                    }
                    netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
                    netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                    if (netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel || NetServiceState.isFormOfOOSOOG(n2)) continue;
                    bl7 = true;
                    continue;
                }
                n2 = netCircuitNode.getAdminState();
                if (n2 < 0) {
                    bl = false;
                    continue;
                }
                ++n;
                if (!NetAdminState.isFormOfIS(n2)) {
                    bl = false;
                }
                if (!NetAdminState.isFormOfOOS(n2)) {
                    bl2 = false;
                }
                if (!this.isMemberOfVcat()) continue;
                netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
                netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                if (netVcatTermination != null && netVcatTermination.getNodeModel() == iNodeModel) {
                    bl6 = true;
                }
                netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
                netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
                if (netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel) continue;
                bl7 = true;
            }
        }
        this.isInGroup = bl6 || bl7;
        if (this.getState() == 4 || this.getState() == 6) {
            return -1;
        }
        if (n == 0) {
            return -1;
        }
        if (bl) {
            return 0;
        }
        boolean bl8 = this.isPartial();
        if (bl3) {
            return bl8 ? 6 : 5;
        }
        if (bl4) {
            return 6;
        }
        if (bl2) {
            if (NetworkModel.instance().getCmsHostModel().getTdmProtocolTypeObj().isSdh() && bl5) {
                return 2;
            }
            return bl8 ? 2 : 1;
        }
        return 2;
    }

    @Override
    protected void notifyChanged() {
        this.notifyChanged(true);
    }

    protected void notifyChanged(boolean bl) {
        if (!this.isCircuitRefValid()) {
            return;
        }
        if (this.hasChanged()) {
            if (this.dbgOn()) {
                this.debug("notifyChanged(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")" + ", notifyParent flag is " + bl);
            }
            int n = this.serviceState;
            this.serviceState = this.deriveServiceState();
            if (this.serviceState != n && this.dbgOn()) {
                this.debug("notifyChanged(): serviceState changed from " + this.translateServiceState(n) + " to " + this.translateServiceState(this.serviceState));
            }
            this.deriveAdminState();
            this.marker.markUpsr();
            this.marker.markDri();
            this.setProtType();
            if (this.isMemberOfVcat() && bl) {
                if (this.dbgOn()) {
                    this.debug("notifyChanged: notify VCAT circuit about the change");
                }
                this.getVcatGroup().memberChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    @Override
    protected void notifyDeleted() {
        this.notifyDeleted(true);
    }

    protected void notifyDeleted(boolean bl) {
        if (this.dbgOn()) {
            this.debug("notifyDeleted(" + this.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.circuitId) + ")" + ", notifyParent flag is " + bl);
        }
        this.setChanged();
        if (this.isMemberOfVcat()) {
            if (this.dbgOn()) {
                this.debug("notifyDeleted: remove the circuit from VCAT circuit group");
            }
            this.getVcatGroup().removeMemberCircuit(this);
            if (bl) {
                if (this.dbgOn()) {
                    this.debug("notify VCAT circuit about the deletion");
                }
                this.getVcatGroup().memberChanged();
            }
            this.deleteVcatGroup();
        }
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    protected boolean setCircuitRoutingDirection() {
        ArrayList arrayList = new ArrayList();
        if (this.dbgOn()) {
            this.debug("setCircuitRoutingDirection() for " + this.getCircuitName());
        }
        this.alignSpansToRoutingDirection();
        boolean bl = this.validateRoutingDirection(arrayList);
        if (bl && arrayList.size() != 0) {
            this.realignOmniSpans(arrayList);
        }
        return bl;
    }

    private void alignSpansToRoutingDirection() {
        NodeRoutingDirection nodeRoutingDirection;
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            nodeRoutingDirection.start();
        }
        int n = 1;
        block7: while (list.size() != 0) {
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode;
                netCircuitNode = (NetCircuitNode)iterator.next();
                nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
                if (n == 1) {
                    if (nodeRoutingDirection.connectionlessLapLinkNode()) {
                        nodeRoutingDirection.finish();
                        iterator.remove();
                        continue;
                    }
                    if (!nodeRoutingDirection.hasCiLockedSource() && !nodeRoutingDirection.hasCiLockedDrop() && !nodeRoutingDirection.hasLockedConn()) continue;
                    if (!nodeRoutingDirection.hasLockedConn()) {
                        if (nodeRoutingDirection.hasCiLockedSource()) {
                            nodeRoutingDirection.setNodeRoutingDirToCiSource();
                        } else if (nodeRoutingDirection.hasCiLockedDrop()) {
                            nodeRoutingDirection.setNodeRoutingDirToCiDrop();
                        }
                        nodeRoutingDirection.setEndpointsToRoutingDir();
                        nodeRoutingDirection.setSpansToRoutingDir();
                    }
                    nodeRoutingDirection.lockSpansAtPeerNodes();
                    nodeRoutingDirection.finish();
                    iterator.remove();
                    continue;
                }
                if (n == 2) {
                    if (!nodeRoutingDirection.hasLockedSpan()) continue;
                    ++n2;
                    nodeRoutingDirection.setNodeRoutingDirToLockedSpan();
                    nodeRoutingDirection.setEndpointsToRoutingDir();
                    nodeRoutingDirection.setSpansToRoutingDir();
                    nodeRoutingDirection.lockSpansAtPeerNodes();
                    nodeRoutingDirection.finish();
                    iterator.remove();
                    continue;
                }
                if (n != 3 && n != 4 || n == 3 && (netCircuitNode.getConnectionType() != 1 && netCircuitNode.getConnectionType() != 3 && netCircuitNode.getConnectionType() != 11 && netCircuitNode.getConnectionType() != 13 || netCircuitNode instanceof LoTunnelNode)) continue;
                ++n2;
                nodeRoutingDirection.setEndpointsToRoutingDir();
                nodeRoutingDirection.setSpansToRoutingDir();
                nodeRoutingDirection.lockSpansAtPeerNodes();
                nodeRoutingDirection.finish();
                iterator.remove();
                break;
            }
            switch (n) {
                case 1: {
                    n = 2;
                    continue block7;
                }
                case 2: {
                    if (n2 != 0) continue block7;
                    n = 3;
                    continue block7;
                }
                case 3: {
                    if (n2 != 0) {
                        n = 2;
                        continue block7;
                    }
                    n = 4;
                    continue block7;
                }
                case 4: {
                    n = 2;
                    continue block7;
                }
            }
        }
    }

    private void realignOmniSpans(ArrayList arrayList) {
        if (this.dbgOn()) {
            this.debug("realignOmniSpans: " + arrayList.size() + " invalid UPSR_DC nodes for " + this.getCircuitName());
        }
        while (arrayList.size() != 0) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)arrayList.remove(0);
            NodeRoutingDirection nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            nodeRoutingDirection.realignUpsrDcNode();
        }
    }

    private boolean validateRoutingDirection(ArrayList arrayList) {
        boolean bl = true;
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            NodeRoutingDirection nodeRoutingDirection = netCircuitNode.nodeRoutingDir;
            if (nodeRoutingDirection.illegalUpsrDcNode()) {
                arrayList.add(netCircuitNode);
            }
            if (nodeRoutingDirection.allSpansAreValid()) continue;
            bl = false;
        }
        return bl;
    }

    protected synchronized boolean reverseRoutingDir() throws IncorrectCircuitState {
        if (this.dbgOn()) {
            this.debug("Reversing routing direction for circuit " + this.getCircuitName());
        }
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode : list) {
            netCircuitNode.nodeRoutingDir.reverseRoutingDir();
        }
        return this.setCircuitLevelSourcesAndDrops();
    }

    private NetCircuitRollOperator getRollOperator() {
        if (this.rollOperator == null) {
            this.rollOperator = new NetCircuitRollOperator(this);
            if (this.dbgOn()) {
                this.debug("RollOperator instantiated for circuit " + this.getCircuitName());
            }
        }
        return this.rollOperator;
    }

    public void getNodeAndSpanListWithCktEnd(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, List list, List list2) {
        this.getRollOperator().getNodeAndSpanListWithCktEnd(iNetCircuitEnd, iNetCircuitEnd2, list, list2);
    }

    public synchronized void getNewSpanAndNodeList(List list, List list2, List list3, List list4) {
        this.getRollOperator().getNewSpanAndNodeList(list, list2, list3, list4);
    }

    public synchronized List findRouteForBridgeRoll(RoutePrefs routePrefs, boolean bl) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        return this.getRollOperator().findRouteForBridgeRoll(routePrefs, bl);
    }

    public synchronized LinkedList sanityCheckBridgeRollSRGs(List list) throws SanityCheckFailed {
        return this.getRollOperator().sanityCheckBridgeRollSRGs(list);
    }

    public synchronized void sanityCheckBridgeRollRouting(List list, List list2, List list3, RoutePrefs routePrefs) throws SanityCheckFailed {
        this.getRollOperator().sanityCheckBridgeRollRouting(list, list2, list3, routePrefs);
    }

    public boolean isOldRouteUPSR(List list) {
        return NetCircuitRollOperator.isOldRouteUPSR(list);
    }

    public List getDriNodes() {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.getOrderedNodeAndSpanList(null, null, linkedList, linkedList2);
        return this.getRollOperator().getDriNodes(linkedList, linkedList2);
    }

    public List getRingNames() {
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.getOrderedNodeAndSpanList(null, null, linkedList, linkedList2);
        return this.getRollOperator().getRingNames(linkedList, linkedList2);
    }

    public boolean routeEqual(List list) {
        if (list.size() != this.getCircuitSpans().size()) {
            return false;
        }
        return NetCircuitRollOperator.routeEqual(this.cktSpanList, list);
    }

    public void addSpansAndNodes(List list, Map map) {
        this.getRollOperator().addSpansAndNodes(list, map);
    }

    protected void disposeRollOperator() {
        if (this.dbgOn()) {
            this.debug("dispose rollOperator");
        }
        this.rollOperator = null;
    }

    protected NetCircuitPathMarker getMarker() {
        return this.marker;
    }

    @Override
    protected NetCircuitOperator getOperator() {
        return this.operator;
    }

    protected List getPrevDropList() {
        return this.prevDropList;
    }

    protected void initVcatGroup(NetVcatGroup netVcatGroup) {
        this.setVcatGroup(netVcatGroup);
        this.memberStatusMap = Collections.synchronizedMap(new HashMap());
        this.prevDropList = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteVcatGroup() {
        this.setVcatGroup(null);
        Object object = this.memberStatusMap;
        synchronized (object) {
            if (this.memberStatusMap != null) {
                this.memberStatusMap.clear();
            }
            this.memberStatusMap = null;
        }
        object = this.prevDropList;
        synchronized (object) {
            if (this.prevDropList != null) {
                this.prevDropList.clear();
            }
            this.prevDropList = null;
        }
    }

    protected void setVcatGroup(NetVcatGroup netVcatGroup) {
        this.vcatGroup = netVcatGroup;
        this.setChanged();
    }

    protected NetVcatGroup getVcatGroup() {
        return this.vcatGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            Integer n = (Integer)this.memberStatusMap.get(iNetCircuitEnd);
            if (n != null) {
                return n;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemberStatus(INetCircuitEnd iNetCircuitEnd, int n) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            this.memberStatusMap.put(iNetCircuitEnd, new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberStatus(INetCircuitEnd iNetCircuitEnd) {
        Map map = this.memberStatusMap;
        synchronized (map) {
            this.memberStatusMap.remove(iNetCircuitEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMemberStatusMap() {
        HashMap hashMap;
        Map map = this.memberStatusMap;
        synchronized (map) {
            hashMap = new HashMap(this.memberStatusMap);
        }
        return hashMap;
    }

    @Override
    public boolean isMemberOfVcat() {
        return this.vcatGroup != null;
    }

    @Override
    public int getMemberNumber() {
        int n = this.getPrimarySource().getPathIdentifier();
        if (n != 0) {
            return n;
        }
        n = this.getPrimaryDrop().getPathIdentifier();
        return n;
    }

    @Override
    public void setMemberNumber(int n) {
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitEnd)iterator.next()).setPathIdentifier(n);
        }
        iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitDropInfo)iterator.next()).setPathIdentifier(n);
        }
    }

    public void setMemberSrcDropHoLoNums(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        if (!this.isMemberOfVcat()) {
            throw new IllegalStateException("Circuit is not a VCAT circuit");
        }
        if (this.dbgOn()) {
            db.println("setEndpointHoLo: srcHo = " + (iHoLoNum == null ? null : iHoLoNum.getHoNum() + "-" + iHoLoNum.getLoNum()) + "dropHo = " + (iHoLoNum2 == null ? null : iHoLoNum2.getHoNum() + "-" + iHoLoNum2.getLoNum()));
        }
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitDropInfo netCircuitDropInfo = null;
        if (this.getCktSources().iterator().hasNext()) {
            netCircuitEnd = (NetCircuitEnd)this.getCktSources().iterator().next();
        }
        if (this.getCktDrops().iterator().hasNext()) {
            netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().iterator().next();
        }
        try {
            if (netCircuitEnd != null && Endpoints.isCe2Port(netCircuitEnd.getEntityModel()) && iHoLoNum != null) {
                this.memberSrcHoLo = iHoLoNum;
                netCircuitEnd.setHoLoNum(iHoLoNum);
            }
            if (netCircuitDropInfo != null && Endpoints.isCe2Port(netCircuitDropInfo.getEntityModel()) && iHoLoNum2 != null) {
                this.memberDropHoLo = iHoLoNum2;
                netCircuitDropInfo.setHoLoNum(iHoLoNum2);
            }
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
    }

    public void setMemberSecSrcDropHoLoNums(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2) {
        if (!this.isMemberOfVcat()) {
            throw new IllegalStateException("Circuit is not a VCAT circuit");
        }
        if (this.dbgOn()) {
            db.println("setEndpointHoLo: SecsrcHo = " + (iHoLoNum == null ? null : iHoLoNum.getHoNum() + "-" + iHoLoNum.getLoNum()) + "SecdropHo = " + (iHoLoNum2 == null ? null : iHoLoNum2.getHoNum() + "-" + iHoLoNum2.getLoNum()));
        }
        INetCircuitEnd iNetCircuitEnd = null;
        INetCircuitEnd iNetCircuitEnd2 = null;
        iNetCircuitEnd = this.getSecondarySource();
        iNetCircuitEnd2 = this.getSecondaryDrop();
        try {
            if (iNetCircuitEnd != null && Endpoints.isCe2Port(iNetCircuitEnd.getEntityModel()) && iHoLoNum != null) {
                this.memberSecSrcHoLo = iHoLoNum;
                iNetCircuitEnd.setHoLoNum(iHoLoNum);
            }
            if (iNetCircuitEnd2 != null && Endpoints.isCe2Port(iNetCircuitEnd2.getEntityModel()) && iHoLoNum2 != null) {
                this.memberSecDropHoLo = iHoLoNum2;
                iNetCircuitEnd2.setHoLoNum(iHoLoNum2);
            }
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
    }

    @Override
    public String getFullCircuitName() {
        if (this.isMemberOfVcat()) {
            return this.getVcatGroup().getCircuitName() + " (" + this.getCircuitName() + ")";
        }
        return this.getCircuitName();
    }

    protected NetCircuitEnd getCktEndFromTermEnd(INetCircuitEnd iNetCircuitEnd) {
        for (NetCircuitEnd netCircuitEnd : this.getSources()) {
            if (netCircuitEnd.getNetElement() != iNetCircuitEnd.getNetElement() || netCircuitEnd.getEntityIndex() != iNetCircuitEnd.getEntityIndex()) continue;
            return NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        }
        Iterator iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd;
            netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (netCircuitEnd.getNetElement() != iNetCircuitEnd.getNetElement() || netCircuitEnd.getEntityIndex() != iNetCircuitEnd.getEntityIndex()) continue;
            return NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), netCircuitEnd);
        }
        return null;
    }

    protected NetCircuitEnd getTermEndFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.getCircuitType(), iNetCircuitEnd);
        if (netCircuitEnd != null) {
            netCircuitEnd.setPathIdentifier(0);
        }
        return netCircuitEnd;
    }

    protected void initSourcesAndDrops(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) {
        block11: {
            if (this.circuitInfoActive()) {
                return;
            }
            if (this.dbgOn()) {
                db.println("initSourcesAndDrops(srcTerm, dstTerm) called");
            }
            if (netCircuitEnd != null) {
                for (NetCircuitEnd netCircuitEnd3 : this.getCktSources()) {
                    if (netCircuitEnd3.getNetElement() != netCircuitEnd.getNetElement() || netCircuitEnd3.getEntityIndex() != netCircuitEnd.getEntityIndex()) continue;
                    if (this.dbgOn()) {
                        db.println("this member ckt (" + this.getCircuitName() + ") already matches src vcat term, no need to swap");
                    }
                    return;
                }
            }
            if (netCircuitEnd2 != null) {
                Iterator iterator = this.getCktDrops().iterator();
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd3;
                    netCircuitEnd3 = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                    if (netCircuitEnd3.getNetElement() != netCircuitEnd2.getNetElement() || netCircuitEnd3.getEntityIndex() != netCircuitEnd2.getEntityIndex()) continue;
                    if (this.dbgOn()) {
                        db.println("this member (" + this.getCircuitName() + ") ckt already matches dst vcat term, no need to swap");
                    }
                    return;
                }
            }
            if (this.dbgOn()) {
                db.println("this member ckt (" + this.getCircuitName() + ") didn't match for either src or dst vcat term, need to swap sources and drops");
            }
            try {
                this.reverseRoutingDir();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (!this.dbgOn()) break block11;
                db.println("NodeRoutingDirection doesn't allow to reverse the routing dir");
            }
        }
    }

    protected void deleteSpliceListener(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitNode netCircuitNode = null;
        List list = this.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
        if (list != null) {
            if (list.size() > 1) {
                if (this.dbgOn()) {
                    this.debug("deleteSpliceListener(): Error !! MXPN in VCAT term end ");
                }
            } else {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                this.debug("deleteSpliceListener(): WARNING: cannot find cktNode for termEnd");
            }
            return;
        }
        NetCircuitEnd netCircuitEnd = this.getCktEndFromTermEnd(iNetCircuitEnd);
        if (netCircuitEnd == null) {
            if (this.dbgOn()) {
                this.debug("deleteSpliceListener(): WARNING: cannot find cktEnd for termEnd");
            }
            return;
        }
        SpliceListenerEntry spliceListenerEntry = netCircuitNode.getSpliceListener(netCircuitEnd, false);
        if (spliceListenerEntry != null) {
            netCircuitNode.deleteSpliceListener(spliceListenerEntry);
        }
        if (netCircuitEnd.getLoNum() != null && (spliceListenerEntry = netCircuitNode.getSpliceListener(netCircuitEnd, true)) != null) {
            netCircuitNode.deleteSpliceListener(spliceListenerEntry);
        }
    }

    protected boolean requireForceDeletion() {
        if (!this.isMemberOfVcat()) {
            return false;
        }
        INodeModel iNodeModel = null;
        NetCircuitEnd netCircuitEnd = null;
        NetVcatTermination netVcatTermination = null;
        NetVcatTermination netVcatTermination2 = null;
        NetCircuitNode netCircuitNode2 = null;
        List list = this.getCircuitNodes();
        for (NetCircuitNode netCircuitNode2 : list) {
            int n;
            iNodeModel = netCircuitNode2.getNodeModel();
            if (!Feature.provides((INodeModel)iNodeModel.getNodeModel(), (Feature)Feature.EXTENDED_ESM) || (n = netCircuitNode2.getServiceState()) < 0) continue;
            netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimarySource());
            netVcatTermination = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
            netCircuitEnd = this.getTermEndFromCktEnd(this.getPrimaryDrop());
            netVcatTermination2 = this.getVcatGroup().getVcatTermFromCktEnd(netCircuitEnd);
            if ((netVcatTermination == null || netVcatTermination.getNodeModel() != iNodeModel) && (netVcatTermination2 == null || netVcatTermination2.getNodeModel() != iNodeModel) || !NetServiceState.isFormOfIS(n) && !NetServiceState.isFormOfAINS(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMemberInGroup() {
        return this.isInGroup;
    }

    @Override
    public boolean isOpenEndedVcatCircuit() {
        if (this.vcatGroup != null) {
            return this.vcatGroup.getVcatTermsSize() == 1 || this.vcatGroup.getVcatTermsSize() == 2 && NetCircuit.isMemberOfBackHaulCircuit(this);
        }
        return false;
    }

    @Override
    protected void printChild(SDebug sDebug) {
        Object object;
        Object object2;
        Iterator<Object> iterator;
        Object object32;
        if (this.isMemberOfVcat()) {
            sDebug.println("");
            sDebug.println("Member Status Map :");
            for (Object object4 : this.getMemberStatusMap().keySet()) {
                sDebug.println(" " + ((NetCircuitEnd)object4).prettyString());
            }
        }
        sDebug.println("");
        sDebug.println("Circuit Span(s) :");
        for (Object object4 : this.getCircuitSpans()) {
            sDebug.println(" " + ((NetCircuitSpan)object4).prettyString());
            sDebug.println(" " + ((NetCircuitSpan)object4).prettyStringSpanState());
        }
        List list = this.getXmCircuitEnds();
        if (!list.isEmpty()) {
            sDebug.println("");
            sDebug.println("XmCircuitEnds :");
            for (Object object32 : list) {
                sDebug.println("   " + ((NetCircuitEnd)object32).prettyString());
            }
        }
        if (!(object32 = this.getSrcInternalSpliceLinkEnds()).isEmpty()) {
            sDebug.println("");
            sDebug.println("Source OTT internal splice link endpoints:");
            iterator = object32.iterator();
            while (iterator.hasNext()) {
                object2 = (NetCircuitEnd)iterator.next();
                sDebug.println("   " + ((NetCircuitEnd)object2).prettyString());
            }
        }
        object2 = this.getDstInternalSpliceLinkEnds();
        if (!object32.isEmpty()) {
            sDebug.println("");
            sDebug.println("Destination OTT internal splice link endpoints:");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitEnd)iterator.next();
                sDebug.println("   " + ((NetCircuitEnd)object).prettyString());
            }
        }
        sDebug.println("");
        sDebug.println("Circuit Node(s) :");
        iterator = this.getCircuitNodes().iterator();
        if (iterator.hasNext()) {
            object = new TreeSet(NetCircuitNode.NetCircuitNodeByNodeNameComparator.instance());
            while (iterator.hasNext()) {
                ((TreeSet)object).add(iterator.next());
            }
            iterator = ((TreeSet)object).iterator();
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode2 = (NetCircuitNode)iterator.next();
                List list2 = this.getCircuitNodeFromNE(netCircuitNode2.getNetElement());
                if (list2 == null) continue;
                for (NetCircuitNode netCircuitNode2 : list2) {
                    netCircuitNode2.prettyPrint(sDebug);
                    sDebug.println("");
                }
            }
        }
    }

    @Override
    public void printDeconstructedConnections(SDebug sDebug) {
        sDebug.println("");
        Iterator iterator = this.getCircuitNodes().iterator();
        if (iterator.hasNext()) {
            TreeSet treeSet = new TreeSet(NetCircuitNode.NetCircuitNodeByNodeNameComparator.instance());
            while (iterator.hasNext()) {
                treeSet.add(iterator.next());
            }
            for (NetCircuitNode netCircuitNode : treeSet) {
                ConnectionsFactory.prettyPrintConnectionList(sDebug, netCircuitNode.connType, netCircuitNode.connections, netCircuitNode.getName());
                sDebug.println("");
            }
        }
    }

    @Override
    public INetVcatGroup getForwardVcatGroup() {
        return null;
    }

    @Override
    public INetVcatGroup getReverseVcatGroup() {
        return null;
    }

    @Override
    public INetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return null;
    }

    @Override
    public int getConfiguredForwardMemberSize() {
        return 0;
    }

    @Override
    public int getConfiguredReverseMemberSize() {
        return 0;
    }

    @Override
    public boolean isSplitRoutingAllowed() {
        return false;
    }

    @Override
    public boolean useLink(INetLink iNetLink) {
        if (this.getCircuitSpanFromNetLink(iNetLink) != null) {
            return true;
        }
        if (!this.getLinkEndpoints(iNetLink).isEmpty()) {
            return true;
        }
        if (this.getCircuitTypeObj().isLoCircuitType()) {
            INetCircuit iNetCircuit = this.useLAP();
            if (iNetCircuit != null && iNetCircuit.useLink(iNetLink)) {
                return true;
            }
            for (INetCircuitSpan iNetCircuitSpan : this.getCircuitSpans()) {
                INetCircuit iNetCircuit2;
                INetLink iNetLink2 = iNetCircuitSpan.getLink();
                if (!iNetLink2.isLOTunnel() || (iNetCircuit2 = ((NetLink)iNetLink2).getLotCircuit()) == null || !iNetCircuit2.useLink(iNetLink)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDualConnectionNode(INetElement iNetElement) {
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            for (NetCircuitNode netCircuitNode : list) {
                if (!netCircuitNode.hasDualConnections()) continue;
                return true;
            }
        }
        return false;
    }

    public void preserveDeletedConnectionPathEnds(INetElement iNetElement, List list) {
        if (this.hasNullCircuitId()) {
            if (this.preservedConnPathEnds == null) {
                this.preservedConnPathEnds = new HashMap();
            }
            this.preservedConnPathEnds.put(iNetElement, new LinkedList(list));
        }
    }

    public Map getPreservedConnectionPathEnds() {
        return this.preservedConnPathEnds;
    }

    protected boolean checkForRefreshCircuit(NetCcatCircuit netCcatCircuit) {
        NetCcatCircuit netCcatCircuit2;
        NetCcatCircuit netCcatCircuit3;
        if (this.dbgOn()) {
            db.println("checkAndRefreshCircuit method called for two CCAT circuits");
        }
        if (!NetCcatCircuit.isNullCircuitId(this.circuitId) && !NetCcatCircuit.isNullCircuitId(netCcatCircuit.getCircuitId())) {
            return false;
        }
        if (this.getPreservedConnectionPathEnds() == null && netCcatCircuit.getPreservedConnectionPathEnds() == null) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("checkAndRefreshCircuit : start processing and evaluating");
        }
        if (this.getPreservedConnectionPathEnds() != null && this.getPreservedConnectionPathEnds().size() > 0) {
            netCcatCircuit3 = this;
            netCcatCircuit2 = netCcatCircuit;
        } else {
            netCcatCircuit3 = netCcatCircuit;
            netCcatCircuit2 = this;
        }
        Map map = netCcatCircuit3.getPreservedConnectionPathEnds();
        if (map == null) {
            return false;
        }
        HashMap<INetElement, List> hashMap = new HashMap<INetElement, List>();
        for (NetCircuitNode netCircuitNode : netCcatCircuit2.getCircuitNodes()) {
            hashMap.put(netCircuitNode.getNetElement(), netCircuitNode.getConnectionPathEnds());
        }
        for (INetElement iNetElement : map.keySet()) {
            List list;
            List list2 = (List)map.get(iNetElement);
            boolean bl = this.compareCktEndLists(list2, list = (List)hashMap.get(iNetElement));
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean compareCktEndLists(List list, List list2) {
        if (list == null || list2 == null) {
            return false;
        }
        int n = 0;
        for (Object e : list) {
            for (Object e2 : list2) {
                if (!e.equals(e2)) continue;
                ++n;
            }
        }
        return n != 0;
    }

    @Override
    public void setMemberNumberOvcat(int n) {
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitEnd)iterator.next()).setPathIdentifier(n);
        }
    }

    public LinkedList getPathSegments() {
        LinkedList<PathSegment> linkedList = new LinkedList<PathSegment>();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        if (this.getOrderedNodeAndSpanList(null, null, linkedList2, linkedList3)) {
            ListIterator listIterator = (ListIterator)linkedList3.iterator();
            if (this.dbgOn()) {
                db.println("Here goes the list of ordered nodes");
                for (CmsObservable cmsObservable : linkedList2) {
                    db.println(((NetCircuitNode)cmsObservable).getName());
                }
                db.println("Here goes the list of ordered Spans");
                while (listIterator.hasNext()) {
                    CmsObservable cmsObservable;
                    cmsObservable = (NetCircuitSpan)listIterator.next();
                    db.println(((NetCircuitSpan)cmsObservable).prettyString());
                }
            }
            boolean bl = true;
            int n = 2;
            PathSegment pathSegment = null;
            INetElement iNetElement = this.getDropNE();
            LinkedList<INetLinkSpan> linkedList4 = null;
            listIterator = (ListIterator)linkedList3.iterator();
            while (listIterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)listIterator.next();
                if (bl) {
                    pathSegment = new PathSegment();
                    linkedList4 = new LinkedList<INetLinkSpan>();
                    n = netCircuitSpan.getProtectionType();
                    pathSegment.setSrc(netCircuitSpan.getNetLinkSpan().getSrc());
                    pathSegment.setDst(netCircuitSpan.getNetLinkSpan().getDst());
                    bl = false;
                }
                if (n == netCircuitSpan.getProtectionType()) {
                    linkedList4.add(netCircuitSpan.getNetLinkSpan());
                    pathSegment.setDst(netCircuitSpan.getNetLinkSpan().getDst());
                } else {
                    pathSegment.setPrimary(linkedList4);
                    linkedList.add(pathSegment);
                    pathSegment = new PathSegment();
                    linkedList4 = new LinkedList();
                    linkedList4.add(netCircuitSpan.getNetLinkSpan());
                    n = netCircuitSpan.getProtectionType();
                    pathSegment.setSrc(netCircuitSpan.getNetLinkSpan().getSrc());
                    pathSegment.setDst(netCircuitSpan.getNetLinkSpan().getDst());
                }
                if (netCircuitSpan.getNetLinkSpan().getDst() != iNetElement) continue;
                pathSegment.setPrimary(linkedList4);
                linkedList.add(pathSegment);
                break;
            }
            boolean bl2 = true;
            PathSegment pathSegment2 = null;
            LinkedList<INetLinkSpan> linkedList5 = null;
            while (listIterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)listIterator.next();
                INetElement iNetElement2 = netCircuitSpan.getNetLinkSpan().getSrc();
                INetElement iNetElement3 = netCircuitSpan.getNetLinkSpan().getDst();
                if (bl2) {
                    pathSegment2 = this.findSegment(linkedList, iNetElement2);
                    if (pathSegment2 == null) {
                        if (this.dbgOn()) {
                            db.println("CRITICAL ERROR: GetPathSegment, processing  a circuit in wrong state !");
                        }
                        return null;
                    }
                    bl2 = false;
                    linkedList5 = new LinkedList<INetLinkSpan>();
                }
                linkedList5.add(netCircuitSpan.getNetLinkSpan());
                if (netCircuitSpan.getNetLinkSpan().getDst() != pathSegment2.getDst()) continue;
                pathSegment2.setAlternate(linkedList5);
                bl2 = true;
            }
        }
        return linkedList;
    }

    private PathSegment findSegment(LinkedList linkedList, INetElement iNetElement) {
        for (PathSegment pathSegment : linkedList) {
            if (pathSegment.getSrc() != iNetElement) continue;
            return pathSegment;
        }
        return null;
    }

    public INetCircuitEnd[] fillInternalSpliceLinks(INetElement iNetElement, int n, int n2) {
        return null;
    }

    public INetCircuitEnd[] fillInternalSpliceLinks(INetElement iNetElement, int n, int n2, boolean bl) {
        return null;
    }

    public boolean aditToAditSpanExists(NetCircuitNode netCircuitNode) {
        if (!netCircuitNode.isOchTrailTunnelNode()) {
            return false;
        }
        List list = this.getCircuitSpans();
        for (NetCircuitSpan netCircuitSpan : list) {
            INetCircuitNode iNetCircuitNode = netCircuitSpan.getSrcNCN();
            INetCircuitNode iNetCircuitNode2 = netCircuitSpan.getDstNCN();
            if (iNetCircuitNode == null || !iNetCircuitNode.isOchTrailTunnelNode() || iNetCircuitNode2 == null || !iNetCircuitNode2.isOchTrailTunnelNode() || !iNetCircuitNode.equals(netCircuitNode) && !iNetCircuitNode2.equals(netCircuitNode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getTimeSlotViolations() {
        return this.tsViolations;
    }
}

