/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CktInfo;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IPathProtection;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVcatRoutePreference;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnectionValidator;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitCreatStage;
import cerent.cms.ncp.INetCircuitDropInfo;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitOperation;
import cerent.cms.ncp.INetCircuitServiceState;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitOperator;
import cerent.cms.ncp.NetCircuitProtType;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.IHoLoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NetCircuit
extends CmsObservable
implements INetCircuit,
IObserver {
    protected Network net = Network.instance();
    protected NetCircuitManager ncMgr = NetCircuitManager.instance();
    protected ICircuitId circuitId;
    protected ICircuitId previousCircuitId;
    protected ICircuitInfo circuitInfo;
    protected ICircuitModel circuitModel;
    protected boolean isCircuitRefValid;
    protected boolean circuitInfoActive;
    protected boolean tl1InfoActive;
    protected boolean tl1Compatible;
    protected int state;
    protected int cktOperation;
    protected int adminState;
    protected int serviceState;
    protected INodeModel srcNodeModel;
    protected NetCircuitProtType protType;
    protected LinkedList pathCosts;
    protected List tsViolations;
    boolean isDiag = false;
    protected boolean isOverlayRing = false;
    private List sources;
    private List drops;
    protected IdentityHashMap wrongConnObjs;
    protected UpdateEvent updateEvent;
    protected boolean updateEventQueued;
    private static final SDebug db = new SDebug("NetCircuit");

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected NetCircuit(CircuitCreatInfo circuitCreatInfo) {
        this.adminState = circuitCreatInfo.adminState();
        this.serviceState = -1;
        this.circuitId = null;
        this.previousCircuitId = null;
        this.circuitInfo = new CktInfo();
        this.circuitModel = null;
        this.pathCosts = new LinkedList();
        this.circuitInfoActive = false;
        this.tl1InfoActive = false;
        this.tl1Compatible = circuitCreatInfo.tl1Compatible();
        this.cktOperation = 0;
        ICircuitEnd[] iCircuitEndArray = new ICircuitEnd[]{NetCircuit.createNullCircuitEnd(), NetCircuit.createNullCircuitEnd()};
        this.circuitInfo.setSrcInfo(iCircuitEndArray);
        this.circuitInfo.setDropInfo(new ICircuitDropInfo[0]);
        this.circuitInfo.setVlans(new IVlanInfo[0]);
        this.circuitInfo.setMonitor(circuitCreatInfo.monitor());
        this.circuitInfo.setCircuitSize(circuitCreatInfo.size());
        this.circuitInfo.setCircuitType(circuitCreatInfo.type());
        this.circuitInfo.setDir(circuitCreatInfo.dir());
        this.circuitInfo.setSla(circuitCreatInfo.sla());
        this.circuitInfo.setCircuitName(circuitCreatInfo.name());
        this.circuitInfo.setVcatRoutingPref(0);
        this.protType = new NetCircuitProtType(this);
        this.sources = Collections.synchronizedList(new LinkedList());
        this.drops = Collections.synchronizedList(new LinkedList());
        this.wrongConnObjs = new IdentityHashMap();
        this.initState(0);
        this.isCircuitRefValid = true;
        this.updateEvent = new UpdateEvent();
        this.updateEventQueued = false;
        this.circuitInfo.setCktOptDir(circuitCreatInfo.getCktOptDir());
        this.circuitInfo.setCktOptChannel(circuitCreatInfo.cktOptChannel());
        this.isDiag = circuitCreatInfo.isDiag();
        if (this.dbgOn()) {
            this.debug("Creating " + (this.tl1Compatible() ? "TL1-like " : "") + (this.isBidirectional() ? "bidirectional " : "unidirectional ") + (this.isMonitorCircuit() ? "monitor " : "") + EnumStrings.getString(ICircuitType.class, (int)circuitCreatInfo.type()) + ", " + EnumStrings.getString(ICircuitSize.class, (int)circuitCreatInfo.size()) + ", " + "adminState=" + this.translateAdminState(circuitCreatInfo.adminState()) + ", " + "SLA " + circuitCreatInfo.sla() + ", " + "OpenVcat=" + circuitCreatInfo.isOVcat());
        }
    }

    @Override
    public boolean tl1Compatible() {
        return this.tl1Compatible;
    }

    protected void setTl1Compatible(boolean bl) {
        this.tl1Compatible = bl;
    }

    @Override
    public boolean isDiag() {
        return this.isDiag;
    }

    protected void isDiag(boolean bl) {
        this.isDiag = bl;
    }

    @Override
    public int getState() {
        return this.state;
    }

    protected void initState(int n) {
        if (this.dbgOn()) {
            db.println("Circuit state init: " + EnumStrings.getString(INetCircuitState.class, (int)n));
        }
        this.state = n;
    }

    @Override
    public void setState(int n) {
        if (this.state != n) {
            if (this.dbgOn()) {
                db.println("Circuit state change: old = " + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "; new = " + EnumStrings.getString(INetCircuitState.class, (int)n));
            }
            this.state = n;
            this.setChanged();
        }
    }

    @Override
    public void setDeletionFailureState() {
        if (this.dbgOn()) {
            this.debug("Setting deletion failure state for " + this.getCircuitName() + "(" + NetCircuit.prettyString(this.circuitId) + ")");
        }
        if (!this.circuitInfoActive()) {
            try {
                if (this.isTl1Ckt()) {
                    this.setState(6);
                }
            }
            catch (IncorrectCircuitState incorrectCircuitState) {}
        } else {
            this.setState(4);
        }
    }

    @Override
    public int getAdminState() {
        return this.adminState;
    }

    @Override
    public int getServiceState() {
        return this.serviceState;
    }

    protected void setServiceState(int n) {
        this.serviceState = n;
    }

    @Override
    public boolean isOverlayRing() {
        return this.isOverlayRing || this.hasMxpn();
    }

    @Override
    public void setOverlayRing(boolean bl) {
        this.isOverlayRing = bl;
    }

    protected void setCktOperation(int n) {
        int n2 = this.cktOperation;
        this.cktOperation = n;
        if (this.dbgOn()) {
            db.println("setCktOperation: " + this.getCircuitName() + " old cktOp => " + EnumStrings.getString(INetCircuitOperation.class, (int)n2) + " new cktOp => " + EnumStrings.getString(INetCircuitOperation.class, (int)this.cktOperation));
        }
    }

    protected int getCktOperation() {
        return this.cktOperation;
    }

    @Override
    public int getProtType() {
        return this.protType.getProtectionType();
    }

    protected boolean setProtType() {
        return this.protType.setProtectionType();
    }

    public int getProtType(List list, List list2) {
        return this.protType.getProtectionType(list, list2);
    }

    @Override
    public boolean isCircuitProtected() {
        return this.protType.isProtected();
    }

    @Override
    public boolean isPca() {
        return this.protType.isPca();
    }

    @Override
    public boolean hasBlsrDri() {
        List list = this.getCircuitNodes();
        for (INetCircuitNode iNetCircuitNode : list) {
            if (iNetCircuitNode.getDriNodeType() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isNonRevertivePca() {
        return this.protType.isNonRevertivePca(this.getState() == 0);
    }

    @Override
    public boolean isDri() {
        return this.protType.isDri();
    }

    @Override
    public int getDropPathProtection() {
        if (this.getDropsSize() == 0) {
            return 2;
        }
        NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
        int n = netCircuitDropInfo.getPathProt();
        return n;
    }

    @Override
    public boolean dropsArePathFullyProtected() {
        return this.getDropPathProtection() == 0;
    }

    protected boolean hasOpenEndedSelector() {
        return this.isBidirectional() && this.getDropsSize() == 2 || this.getSourcesSize() == 2;
    }

    @Override
    public boolean isCircuitRefValid() {
        return this.isCircuitRefValid;
    }

    protected boolean tl1InfoActive() {
        return this.tl1InfoActive;
    }

    protected void setTl1InfoActive() {
        this.tl1InfoActive = true;
    }

    protected synchronized void updateCircuitInfo(ICircuitModel iCircuitModel, boolean bl) {
        LinkedList linkedList;
        LinkedList linkedList2;
        if (iCircuitModel == null) {
            return;
        }
        this.circuitModel = iCircuitModel;
        this.circuitInfoActive = true;
        if (this.dbgOn()) {
            this.debug("updateCircuitInfo(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")");
        }
        if (bl) {
            this.addCircuitInfoObserver();
        }
        try {
            if (this.dbgOn()) {
                this.debug("updateCircuitInfo(" + this.getCircuitName() + ", Old Circuit ID " + NetCircuit.prettyString(this.circuitId) + "New Circuit ID " + NetCircuit.prettyString(this.circuitModel.getId()) + "):");
            }
            if (this.circuitId != null && !this.circuitId.equals(this.circuitModel.getId())) {
                INetElement iNetElement;
                if (this.dbgOn()) {
                    this.debug("updateCircuitInfo(" + this.getCircuitName() + ", Old Circuit ID " + NetCircuit.prettyString(this.circuitId) + "New Circuit ID " + NetCircuit.prettyString(this.circuitModel.getId()) + "): Circuit ID Changed. Reloading Circuit Infos");
                }
                if ((iNetElement = this.getSrcNetElement()) == null) {
                    if (this.dbgOn()) {
                        db.println("i/o exception in updating circuit id");
                    }
                    return;
                }
                this.disposeCircuitInfo(true);
                NetCircuitWatchDog.instance().reloadCircuitInfos(iNetElement);
                return;
            }
            this.updateCircuitId(this.circuitModel.getId());
            this.updateCircuitName(this.circuitModel.getName());
            this.circuitInfo.setMonitor(this.circuitModel.getMonitor());
            this.circuitInfo.setCircuitSize(this.circuitModel.getSize());
            ICircuitType iCircuitType = this.getCircuitTypeObj();
            Object object = CircuitType.getCircuitType((int)this.circuitModel.getType());
            if (iCircuitType.isLAPCircuitType() && !object.isLAPCircuitType()) {
                this.deleteLAPLink((ICircuitType)object);
            }
            this.circuitInfo.setCircuitType(this.circuitModel.getType());
            if (object.isLAPCircuitType() && !iCircuitType.isLAPCircuitType()) {
                this.insertLAPLink(iCircuitType);
            }
            this.circuitInfo.setDir(this.circuitModel.getDirection());
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.UCP_UNIC)) {
                this.circuitInfo.setSla(this.circuitModel.getSla());
            } else {
                this.circuitInfo.setSla((short)0);
            }
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.OCHNC_PROVISIONING)) {
                this.circuitInfo.setCktOptChannel(this.circuitModel.getCktOptChannel());
                if (!this.srcNodeModel.provides(Feature.OPTICAL_SIDE)) {
                    if (this.dbgOn()) {
                        db.println("Setting opt dir: " + DwdmNetLink.cktOptDirString(this.circuitModel.getCktOptDir()));
                    }
                    this.circuitInfo.setCktOptDir(this.circuitModel.getCktOptDir());
                }
            }
            if (this.srcNodeModel != null && this.srcNodeModel.provides(Feature.VCAT)) {
                this.circuitInfo.setVcatRoutingPref(this.circuitModel.getVcatRoutingPref());
            }
            linkedList2 = new LinkedList();
            linkedList = new LinkedList();
            this.fetchSourcesAndDropsFromCircuitModel(this.circuitModel, linkedList2, linkedList);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.dbgOn()) {
                db.println("updateCircuitInfo: circuitModel object does not exist");
            }
            this.disposeCircuitInfo(true);
            throw abstractCmsObjectNotExistException;
        }
        boolean bl2 = false;
        if (linkedList2.size() == this.getSourcesSize() && linkedList.size() == this.getDropsSize()) {
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                if (this.isSource((NetCircuitEnd)iterator.next())) continue;
                bl2 = true;
                break;
            }
            for (Object object : linkedList) {
                if (this.isDrop((NetCircuitDropInfo)object)) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = true;
        }
        if (bl2) {
            if (this.dbgOn()) {
                db.println("updateCircuitInfo: source/drop change:");
                db.println(" sources: old = " + this.getSourcesSize() + ", new = " + linkedList2.size());
                db.println(" drops  : old = " + this.getDropsSize() + ", new = " + linkedList.size());
            }
            this.setSources(linkedList2);
            this.setDrops(linkedList);
            this.updateCircuitSourceInfo();
            this.updateCircuitDropInfo();
            this.conformToCircuitInfo();
        }
        this.completeCheck();
        this.setChanged();
    }

    protected void updateCircuitId(ICircuitId iCircuitId) {
        if (!iCircuitId.equals(this.circuitId)) {
            if (this.dbgOn()) {
                this.debug("updateCircuitId(" + NetCircuit.prettyString(this.circuitId) + "->" + NetCircuit.prettyString(iCircuitId) + ") for " + this.getCircuitName());
            }
            this.previousCircuitId = this.circuitId;
            this.circuitId = iCircuitId;
            this.setChanged();
        }
    }

    protected void deleteLAPLink(ICircuitType iCircuitType) {
    }

    protected void insertLAPLink(ICircuitType iCircuitType) {
    }

    protected void fetchSourcesAndDropsFromCircuitModel(ICircuitModel iCircuitModel, List list, List list2) throws AbstractCmsObjectNotExistException {
        NetCircuitEnd netCircuitEnd;
        if (iCircuitModel == null) {
            return;
        }
        if (iCircuitModel.getNodeModel().provides(Feature.OCHNC_SPLITTER_CIRCUIT)) {
            for (ICircuitEnd iCircuitEnd : Arrays.asList(iCircuitModel.getSrcInfo())) {
                if (iCircuitEnd.getNodeId() == 0 || (netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitEnd)) == null) continue;
                netCircuitEnd.setStage(4);
                list.add(netCircuitEnd);
            }
        } else {
            if (iCircuitModel.getSrcPoint().getNodeId() != 0 && (netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitModel.getSrcPoint())) != null) {
                netCircuitEnd.setStage(4);
                list.add(netCircuitEnd);
            }
            if (iCircuitModel.getSecSrcPoint().getNodeId() != 0 && (netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitModel.getSecSrcPoint())) != null) {
                netCircuitEnd.setStage(4);
                list.add(netCircuitEnd);
            }
        }
        for (ICircuitDropInfo iCircuitDropInfo : Arrays.asList(iCircuitModel.getDropInfo())) {
            netCircuitEnd = !this.getCircuitTypeObj().isLAPCircuitType() ? NetCircuitEndFactory.createCircuitEnd(iCircuitModel, iCircuitDropInfo.getDropPoint()) : NetCircuitEndFactory.createLoTunnelCircuitEnd(iCircuitModel, iCircuitDropInfo.getDropPoint());
            if (netCircuitEnd == null) continue;
            netCircuitEnd.setStage(4);
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, iCircuitDropInfo.getPathProt());
            list2.add(netCircuitDropInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiscoveredCircuitInfo(INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsIOException {
        NetCircuit netCircuit = this;
        synchronized (netCircuit) {
            if (!this.isCircuitRefValid()) {
                return;
            }
            if (this.circuitInfoActive()) {
                if (this.deletedEventPending()) {
                    if (this.dbgOn()) {
                        this.debug("Processing circuitInfo delete event for (Id = " + NetCircuit.prettyString(this.circuitId) + ") at " + iNodeModel.getName());
                    }
                    this.disposeCircuitInfo(false);
                } else {
                    return;
                }
            }
            if (this.dbgOn()) {
                this.debug("Adding discovered circuitinfo to circuit (Id = " + NetCircuit.prettyString(this.circuitId) + ") at " + iNodeModel.getName());
            }
            this.srcNodeModel = iNodeModel;
            if (this.getState() == 5 || this.getState() == 6) {
                this.setState(4);
            }
            try {
                this.updateCircuitInfo(iCircuitModel, true);
                this.reloadTl1Objects();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                this.disposeCircuitInfo(true);
                throw abstractCmsIOException;
            }
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent("NCkt::addDiscoveredCktInfo : cktId: " + NetCircuit.prettyString(this.circuitId) + " node: " + iNodeModel.getName());
        }
        this.notifyChanged();
    }

    protected synchronized void disposeCircuitInfo(boolean bl) {
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("disposeCircuitInfo: ERROR-Attempt to dispose inactive or deleted circuitInfo. circuit ID = " + NetCircuit.prettyString(this.circuitId));
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("disposeCircuitInfo for circuit " + NetCircuit.prettyString(this.circuitId));
        }
        this.circuitInfoActive = false;
        if (this.getCktOperation() != 1) {
            this.disposeCircuitInfoAtNodes();
            this.srcNodeModel = null;
            this.setSources(null);
            this.setDrops(null);
        }
        this.deleteCircuitInfoObserver();
        this.circuitModel = null;
        this.setChanged();
        if (this.getCktOperation() != 1 && bl) {
            this.checkAndUpdateCircuit();
        }
    }

    @Override
    public ICircuitId getCircuitId() {
        return this.circuitId;
    }

    @Override
    public ICircuitId getPreviousCircuitId() {
        return this.previousCircuitId;
    }

    @Override
    public String getCircuitName() {
        return this.circuitInfo.getCircuitName();
    }

    @Override
    public void setCircuitName(String string) {
        this.circuitInfo.setCircuitName(string);
    }

    public void updateCircuitName(String string) {
        this.setCircuitName(string);
        this.ncMgr.updateCircuitNameMap(this.circuitId, string);
    }

    @Override
    public int getCircuitDir() {
        return this.circuitInfo.getDir();
    }

    public void setCircuitDir(int n) {
        if (this.dbgOn()) {
            db.println("setCircuitDir: " + this.getCircuitName());
        }
        this.circuitInfo.setDir(n);
    }

    @Override
    public int getCircuitOptChannel() {
        return this.circuitInfo.getCktOptChannel();
    }

    @Override
    public int getCircuitType() {
        return this.circuitInfo.getCircuitType();
    }

    @Override
    public void setCircuitType(int n) {
        this.circuitInfo.setCircuitType(n);
    }

    @Override
    public int getCircuitOptDirection() {
        return this.circuitInfo.getCktOptDir();
    }

    @Override
    public ICircuitType getCircuitTypeObj() {
        return CircuitType.getCircuitType((int)this.getCircuitType());
    }

    @Override
    public int getCircuitSize() {
        return this.circuitInfo.getCircuitSize();
    }

    @Override
    public ICircuitSize getCircuitSizeObj() {
        return CircuitSize.getCircuitSize((int)this.getCircuitSize());
    }

    @Override
    public boolean isMonitorCircuit() {
        return this.circuitInfo.getMonitor();
    }

    @Override
    public short getSla() {
        return this.circuitInfo.getSla();
    }

    @Override
    public int getVcatRoutingPref() {
        return this.circuitInfo.getVcatRoutingPref();
    }

    @Override
    public boolean isBidirectional() {
        return this.getCircuitDir() == 1;
    }

    @Override
    public boolean supportsISTU() {
        return false;
    }

    @Override
    public List getAvailDropPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl) {
        List list = Endpoints.instance().getAvailDropPorts(iNodeModel, circuitCreatInfo, this, bl);
        ICircuitType iCircuitType = this.getCircuitTypeObj();
        if (this.getCircuitTypeObj().isLoCircuitType() && this.useLAP() == null && this.getSrcNetElement().getNodeId() != iNodeModel.getNodeId()) {
            List list2 = this.ncMgr.getAvailLAPEntities(iNodeModel, this.getCircuitSize(), bl, this);
            list.addAll(list2);
        }
        return list;
    }

    @Override
    public List getAvailDropPoints(INodeModel iNodeModel, IEntityModel iEntityModel) {
        List list = Endpoints.instance().getAvailDropPoints(iNodeModel, iEntityModel, this);
        if (this.getCircuitTypeObj().isLoCircuitType() && this.useLAP() == null && this.getSrcNetElement().getNodeId() != iNodeModel.getNodeId()) {
            List list2 = this.ncMgr.getAvailLAPPaths(iNodeModel, iEntityModel, this.getCircuitSize(), this);
            list.addAll(list2);
        }
        return list;
    }

    @Override
    public int validateML2CircuitSize() throws CircuitProvError {
        IEntityModel iEntityModel = null;
        IPortModel iPortModel = null;
        Object var6_3 = null;
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        if (!Feature.provides((INodeModel)iNetCircuitEnd.getNodeModel(), (Feature)Feature.RPR_802_17)) {
            if (this.dbgOn()) {
                this.debug("Circuit Size validation for ML ports is not supported for NE version:" + iNetCircuitEnd.getNodeModel().getSwVersion());
            }
            return 0;
        }
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        int n = iEntityModel.getModuleModel().getEqType();
        if (this.dbgOn()) {
            this.debug("getAvailDropPorts() ML-ML check for srcEqType " + n);
        }
        if (n == 102 || n == 103 || n == 285 || n == 221) {
            NetCircuitEnd netCircuitEnd;
            NetCircuit netCircuit;
            if (n == 285) {
                int n2 = 165;
            } else {
                int n3 = 105;
            }
            if (!iEntityModel.inRPRMode()) {
                return 0;
            }
            int n4 = iEntityModel.getPort();
            iPortModel = ((NetCircuitEnd)iNetCircuitEnd).getOtherPosPortModelFromPair();
            IHoLoNum iHoLoNum = null;
            if (iNetCircuitEnd.getHoNum() != null) {
                iHoLoNum = this.ncMgr.getHoLoNumfromEntity((IEntityModel)iPortModel);
            }
            if (iHoLoNum == null) {
                iHoLoNum = iNetCircuitEnd.getHoLoNum();
            }
            if ((netCircuit = (NetCircuit)this.ncMgr.getCircuitFromCircuitEnd(netCircuitEnd = new NetCircuitEnd(iNetCircuitEnd.getNodeModel(), (IEntityModel)iPortModel, iHoLoNum, false))) == null) {
                return this.getCircuitSize();
            }
            if (this.getCircuitSize() == netCircuit.getCircuitSize()) {
                return this.getCircuitSize();
            }
            return netCircuit.getCircuitSize();
        }
        return 0;
    }

    @Override
    public INetCircuitEnd getPrimarySource() {
        if (this.sources.size() < 1) {
            return null;
        }
        return (INetCircuitEnd)this.getCktSources().get(0);
    }

    @Override
    public INetCircuitEnd getSecondarySource() {
        if (this.sources.size() < 2) {
            return null;
        }
        return (INetCircuitEnd)this.getCktSources().get(1);
    }

    public INetCircuitEnd getPrimaryDrop() {
        if (this.drops.size() < 1) {
            return null;
        }
        return (INetCircuitEnd)this.getDropCktEnds().get(0);
    }

    public INetCircuitEnd getSecondaryDrop() {
        if (this.drops.size() < 2) {
            return null;
        }
        return (INetCircuitEnd)this.getDropCktEnds().get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCktSources() {
        LinkedList linkedList;
        List list = this.sources;
        synchronized (list) {
            linkedList = new LinkedList(this.sources);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWrongConnObjs() {
        ArrayList arrayList;
        NetCircuit netCircuit = this;
        synchronized (netCircuit) {
            arrayList = new ArrayList(this.wrongConnObjs.values());
        }
        return arrayList;
    }

    @Override
    public List getSources() {
        return this.getCktSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCktDrops() {
        LinkedList linkedList;
        List list = this.drops;
        synchronized (list) {
            linkedList = new LinkedList(this.drops);
        }
        return linkedList;
    }

    @Override
    public List getDrops() {
        return this.getCktDrops();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSources(List list) {
        List list2 = this.sources;
        synchronized (list2) {
            this.sources.clear();
            if (list != null) {
                this.sources.addAll(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDrops(List list) {
        List list2 = this.drops;
        synchronized (list2) {
            this.drops.clear();
            if (list != null) {
                this.drops.addAll(list);
            }
        }
    }

    protected int getSourcesSize() {
        return this.sources.size();
    }

    protected int getDropsSize() {
        return this.drops.size();
    }

    public List getDropCktEnds() {
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            linkedList.add(netCircuitDropInfo.getNetCktEnd());
        }
        return linkedList;
    }

    protected LinkedList getCktInfoEndPoints() {
        LinkedList linkedList = new LinkedList(this.getSources());
        linkedList.addAll((LinkedList)this.getDropCktEnds());
        return linkedList;
    }

    protected int getUniqueNumSrcDstNodes() {
        HashSet<INodeModel> hashSet = new HashSet<INodeModel>();
        Iterator iterator = this.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                hashSet.add(netCircuitEnd.getNodeModel());
            }
            iterator = this.getDropCktEnds().iterator();
        }
        return hashSet.size();
    }

    public boolean isSource(NetCircuitEnd netCircuitEnd) {
        for (NetCircuitEnd netCircuitEnd2 : this.getCktSources()) {
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean isDrop(NetCircuitDropInfo netCircuitDropInfo) {
        NetCircuitDropInfo netCircuitDropInfo2 = this.getDrop(netCircuitDropInfo.getNetCktEnd());
        return netCircuitDropInfo2 != null && netCircuitDropInfo2.equals(netCircuitDropInfo);
    }

    public boolean isDrop(NetCircuitEnd netCircuitEnd) {
        return this.getDrop(netCircuitEnd) != null;
    }

    protected NetCircuitDropInfo getDrop(NetCircuitEnd netCircuitEnd) {
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            if (!netCircuitDropInfo.getNetCktEnd().equals(netCircuitEnd)) continue;
            return netCircuitDropInfo;
        }
        return null;
    }

    public boolean isEndPoint(INetElement iNetElement) {
        return this.isSource(iNetElement) || this.isDrop(iNetElement);
    }

    public boolean isSource(INetElement iNetElement) {
        if (!this.circuitInfoActive()) {
            return false;
        }
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            if (!iNetElement.equals(netCircuitEnd.getNetElement())) continue;
            return true;
        }
        return false;
    }

    public boolean isDrop(INetElement iNetElement) {
        for (NetCircuitEnd netCircuitEnd : this.getDropCktEnds()) {
            if (!iNetElement.equals(netCircuitEnd.getNetElement())) continue;
            return true;
        }
        return false;
    }

    public INetElement getSourceNE() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
        if (iNetCircuitEnd != null) {
            return iNetCircuitEnd.getNetElement();
        }
        return null;
    }

    public INetElement getDropNE() {
        INetCircuitEnd iNetCircuitEnd = this.getPrimaryDrop();
        if (iNetCircuitEnd != null) {
            return iNetCircuitEnd.getNetElement();
        }
        return null;
    }

    protected void updateCircuitSourceInfo() {
        ICircuitEnd[] iCircuitEndArray = new ICircuitEnd[this.getSourcesSize()];
        Iterator iterator = this.getCktSources().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            iCircuitEndArray[n++] = netCircuitEnd.getCircuitEnd();
        }
        this.circuitInfo.setSrcInfo(iCircuitEndArray);
    }

    protected void updateCircuitDropInfo() {
        ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[this.getDropsSize()];
        int n = 0;
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            iCircuitDropInfoArray[n++] = netCircuitDropInfo.getCircuitDropInfo();
        }
        this.circuitInfo.setDropInfo(iCircuitDropInfoArray);
    }

    @Override
    public void addSource(INetCircuitEnd iNetCircuitEnd) throws SanityCheckFailed {
        throw new SanityCheckFailed("Feature not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertSource(NetCircuitEnd netCircuitEnd) {
        List list = this.sources;
        synchronized (list) {
            if (this.sources.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("insertSource: source already in list!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("sources.add(" + netCircuitEnd.prettyString() + ")");
            }
            this.sources.add(netCircuitEnd);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDrop(NetCircuitDropInfo netCircuitDropInfo) {
        List list = this.drops;
        synchronized (list) {
            if (this.drops.contains(netCircuitDropInfo)) {
                if (this.dbgOn()) {
                    db.println("insertDrop: drop already in list!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("drops.add(" + netCircuitDropInfo.getNetCktEnd().prettyString() + ")");
            }
            this.drops.add(netCircuitDropInfo);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDrop(NetCircuitDropInfo netCircuitDropInfo) {
        List list = this.drops;
        synchronized (list) {
            if (!this.drops.contains(netCircuitDropInfo)) {
                if (this.dbgOn()) {
                    db.println("removeDrop: drop not found!");
                }
                return;
            }
            if (this.dbgOn()) {
                db.println("drops.remove(" + netCircuitDropInfo.getNetCktEnd().prettyString() + ")");
            }
            this.drops.remove(netCircuitDropInfo);
        }
        this.setChanged();
    }

    protected void addCircuitInfoObserver() {
        if (this.srcNodeModel == null || this.circuitModel == null) {
            if (this.dbgOn()) {
                db.println("Warning! addCircuitInfoObserver: srcNode or circuitModel null");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("addCircuitInfoObserver for " + this.getCircuitName());
        }
        this.updateEvent.init();
        ModelIndirectObservable.instance().addObserver((IObservable)this.circuitModel, this);
    }

    protected void deleteCircuitInfoObserver() {
        if (this.circuitModel != null) {
            if (this.dbgOn()) {
                db.println("deleteCircuitInfoObserver for " + this.getCircuitName());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.circuitModel, this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            this.updateEvent.init();
        }
    }

    @Override
    public synchronized void routeDrop(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.getOperator().routeDrop(iNetCircuitEnd, iNetCircuitEnd2, routePrefs);
    }

    @Override
    public synchronized void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.getOperator().routeDrop(iNetCircuitEnd, routePrefs);
    }

    @Override
    public void deleteDrop(INetCircuitDropInfo iNetCircuitDropInfo) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        this.getOperator().deleteDrop(((NetCircuitDropInfo)iNetCircuitDropInfo).getNetCktEnd());
    }

    @Override
    public List getEtherCircuitNodes() throws IncorrectCircuitState {
        return new LinkedList();
    }

    @Override
    public List getEtherAddDropCircuitNodes() throws IncorrectCircuitState {
        return new LinkedList();
    }

    protected boolean hasSourceWithNetElement(INetElement iNetElement) {
        Iterator iterator = this.getCktSources().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            bl = netCircuitEnd.usesNetElement(iNetElement);
        }
        return bl;
    }

    @Override
    public void circuitDeleteCheck() throws IncorrectCircuitState {
        if (this.state == 4 || this.state == 0 || this.state == 8 || this.state == 11) {
            throw new IncorrectCircuitState("A circuit in a transitory state cannot be destroyed.");
        }
    }

    protected synchronized void destroyCircuitInfo() throws IncorrectCircuitState, DeletionError {
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (!this.circuitInfoActive()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("destroyCircuitInfo(" + this.getCircuitName() + "): Id = " + NetCircuit.prettyString(this.getCircuitId()));
        }
        this.deleteCircuitModel();
        this.disposeCircuitInfo(true);
    }

    protected synchronized void finalDispose() {
        if (this.dbgOn()) {
            this.debug("finalDispose(" + this.getCircuitName() + ", " + NetCircuit.prettyString(this.circuitId) + ")");
        }
        this.protType.dispose();
        this.ncMgr.updateCircuitNameMap(this.circuitId, null);
        this.isCircuitRefValid = false;
        this.ncMgr.removeCircuit(this);
    }

    protected synchronized boolean isTL1Convertible() {
        boolean bl = false;
        try {
            bl = this.isCircuitRefValid() && !this.hasNullCircuitId() && this.state != 8 && !this.getCircuitTypeObj().isTunnelCircuitType() && !this.getCircuitTypeObj().isLAPCircuitType() && !this.isVlanCapable() && !this.isUcpCircuit();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            SDebug.printStackTrace((Throwable)incorrectCircuitState);
        }
        return bl;
    }

    public ICircuitModel circuitModel() {
        return this.circuitModel;
    }

    protected void setCircuitModel(ICircuitModel iCircuitModel) {
        this.circuitModel = iCircuitModel;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof ICircuitModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    this.debug("ckt.update: DELETED for " + this.getCircuitName() + " (" + NetCircuit.prettyString(this.circuitId) + ")");
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "deleted");
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    this.debug("ckt.update: CHANGED for " + this.getCircuitName() + " (" + NetCircuit.prettyString(this.circuitId) + ")");
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this, this, "changed");
            }
        }
    }

    protected void setEventChanged(boolean bl) {
        this.updateEvent.changed = bl;
    }

    private boolean deletedEventPending() {
        return this.updateEvent.deleted;
    }

    protected boolean getUpdateEventQueued() {
        return this.updateEventQueued;
    }

    protected void setUpdateEventQueued(boolean bl) {
        this.updateEventQueued = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runUpdate() {
        boolean bl = this.updateEvent.deleted;
        NetCircuit netCircuit = this;
        synchronized (netCircuit) {
            if (!this.isCircuitRefValid()) {
                return;
            }
            if (this.updateEvent.deleted) {
                this.updateEvent.deleted = false;
                if (this.dbgOn()) {
                    db.println("ckt.runUpdate: DELETED for " + this.getCircuitName());
                }
                this.updateDeleted();
            } else if (this.updateEvent.changed) {
                this.updateEvent.changed = false;
                if (this.dbgOn()) {
                    db.println("ckt.runUpdate: CHANGED for " + this.getCircuitName());
                }
                this.updateChanged();
            }
            this.runChildUpdate();
        }
        if (!this.isCircuitRefValid) {
            this.notifyDeleted();
        } else {
            this.notifyChanged();
        }
        if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
            UpdateEventCollector.instance().LogEvent(" NCkt: runUpdate " + this.getCircuitName() + (bl ? " delete" : " changed") + " event" + ", State: " + EnumStrings.getString(INetCircuitState.class, (int)this.getState()));
        }
    }

    protected void updateDeleted() {
        this.disposeCircuitInfo(true);
    }

    private void updateChanged() {
        if (!this.circuitInfoActive()) {
            return;
        }
        if (this.state != 1 && this.state != 4 && this.state != 8) {
            return;
        }
        try {
            this.updateCircuitInfo(this.circuitModel, false);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            INetElement iNetElement = this.getSrcNetElement();
            this.disposeCircuitInfo(true);
            NetCircuitWatchDog.instance().reloadCircuitInfos(iNetElement);
        }
    }

    protected int srcPayloadType() {
        return this.getPayloadType((NetCircuitEnd)this.getPrimarySource());
    }

    protected int secSrcPayloadType() {
        return this.getPayloadType((NetCircuitEnd)this.getSecondarySource());
    }

    protected int getPayloadType(NetCircuitEnd netCircuitEnd) {
        IEntityModel iEntityModel = null;
        if (netCircuitEnd != null) {
            try {
                iEntityModel = netCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                iEntityModel = null;
            }
            if (iEntityModel != null) {
                return iEntityModel.getPayloadType();
            }
        }
        return 0;
    }

    protected Network getNetwork() {
        return this.net;
    }

    @Override
    public INetElement getSrcNetElement() {
        INetElement iNetElement = null;
        if (this.srcNodeModel != null) {
            iNetElement = this.net.findNetElem(this.srcNodeModel);
        }
        return iNetElement;
    }

    public INodeModel getSrcNodeModel() {
        return this.srcNodeModel;
    }

    public void setSrcNodeModel(INodeModel iNodeModel) {
        this.srcNodeModel = iNodeModel;
    }

    public void deleteCircuitModel() throws DeletionError {
        try {
            if (this.circuitModel != null) {
                this.circuitModel.delete();
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (db.on()) {
                db.println("Circuit model has already been deleted.");
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error deleting circuit model of " + this.getCircuitName());
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new DeletionError("An error occurred while deleting the circuit model of " + this.getCircuitName() + ".");
        }
    }

    @Override
    public boolean hasLoopback() {
        return false;
    }

    @Override
    public boolean hasMonitor() {
        return false;
    }

    @Override
    public boolean hasMxpn() {
        return false;
    }

    @Override
    public boolean hasMxpnOnIntermediateNEs() {
        return false;
    }

    @Override
    public boolean hasXcLoopback() {
        return false;
    }

    @Override
    public boolean supportsMonitorCircuits() {
        boolean bl = true;
        LinkedList linkedList = (LinkedList)this.getCktSources();
        for (int i = 0; bl && i < linkedList.size(); ++i) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)linkedList.get(i);
            if (netCircuitEnd == null || this.supportsMonitorCircuits(netCircuitEnd)) continue;
            bl = false;
        }
        LinkedList linkedList2 = (LinkedList)this.getCktDrops();
        for (int i = 0; bl && i < linkedList2.size(); ++i) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)linkedList2.get(i);
            if (netCircuitDropInfo == null || this.supportsMonitorCircuits(netCircuitDropInfo)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean supportsMonitorCircuits(INetCircuitEnd iNetCircuitEnd) {
        INodeModel iNodeModel;
        boolean bl = true;
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            iEntityModel = null;
        }
        if (iEntityModel != null && iEntityModel instanceof IPortModel && (iNodeModel = iNetCircuitEnd.getNodeModel()) != null && iNodeModel.provides(Feature.MONITOR_CKTS)) {
            bl = ((IPortModel)iEntityModel).supportsMonitorCircuits();
        }
        return bl;
    }

    @Override
    public boolean needRoute(INetCircuitEnd iNetCircuitEnd) {
        return true;
    }

    public ICircuitInfo getCircuitInfo() {
        return this.circuitInfo;
    }

    public void setCircuitInfo(ICircuitInfo iCircuitInfo) {
        this.circuitInfo = iCircuitInfo;
    }

    protected static boolean isPathFullyProtected(int n) {
        return n == 0 || n == 6 || n == 7 || n == 5;
    }

    protected static CircuitEnd createNullCircuitEnd() {
        return new CircuitEnd(0, 0, null, null, false, 0);
    }

    public static boolean isNullCircuitId(ICircuitId iCircuitId) {
        if (iCircuitId == null) {
            return true;
        }
        return iCircuitId.getNodeId() == 0 && iCircuitId.getUniquePart().getUniqueId() == 0;
    }

    @Override
    public boolean hasNullCircuitId() {
        return NetCircuit.isNullCircuitId(this.getCircuitId());
    }

    public static boolean cktEndIsNodeDrop(INetCircuitEnd iNetCircuitEnd) {
        return iNetCircuitEnd.getEntityIndex() == 0;
    }

    public static boolean cktEndIsNodeDrop(ICircuitEnd iCircuitEnd) {
        return iCircuitEnd.getPortNum() == 0;
    }

    @Override
    public LinkedList getCircuitCosts() {
        LinkedList linkedList = new LinkedList(this.pathCosts);
        return linkedList;
    }

    protected void setCircuitCosts(LinkedList linkedList) {
        this.pathCosts.clear();
        this.pathCosts.addAll(linkedList);
    }

    protected static String prettyString(ICircuitId iCircuitId) {
        if (iCircuitId == null || iCircuitId.getUniquePart() == null) {
            return "<null>";
        }
        return Integer.toHexString(iCircuitId.getNodeId()) + "::" + iCircuitId.getUniquePart().getUniqueId();
    }

    @Override
    public void prettyPrintDeconstruction(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        this.printDeconstructedConnections(sDebug);
    }

    public void prettyPrintHdr(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        NetCircuit netCircuit2 = this;
        netCircuit2.ncMgr.permitPkgDbg();
    }

    public void prettyPrintWrongConnObjs(SDebug sDebug) {
        if (!sDebug.on() || this.getWrongConnObjs().size() == 0) {
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        sDebug.println("");
        sDebug.println("srcNode: " + (this.srcNodeModel == null ? "null" : this.srcNodeModel.getName()));
        sDebug.println("");
        sDebug.println("Wrong Connection Objects :");
        Iterator iterator = this.getWrongConnObjs().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            try {
                IConnectionModel iConnectionModel = (IConnectionModel)iterator.next();
                String string = "unknown";
                if (iConnectionModel instanceof IHoConnectionModel) {
                    string = "Ho";
                } else if (iConnectionModel instanceof ILoAditModel) {
                    string = "LoAdit";
                } else if (iConnectionModel instanceof ILoConnectionModel) {
                    string = "Lo";
                } else if (iConnectionModel instanceof IOchncConnectionModel) {
                    string = "Ochnc";
                } else if (iConnectionModel instanceof IOchTrailAditModel) {
                    string = "OchTrailAdit";
                } else if (iConnectionModel instanceof IOchccConnectionModel) {
                    string = "Ochcc";
                }
                String string2 = iConnectionModel.getNodeModel().getName();
                sDebug.println("Node: " + string2 + " Connection Name: " + iConnectionModel.getConnectionName() + " CircuitId: " + NetCircuit.prettyString(iConnectionModel.getCircuitId()) + " Index: " + n + " Connection Type: " + string + " Node: " + (iConnectionModel.getNodeModel() == null ? "null" : iConnectionModel.getNodeModel().getName()));
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            ++n;
        }
        sDebug.println("==========================================================");
        NetCircuit netCircuit2 = this;
        netCircuit2.ncMgr.permitPkgDbg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWrongConnObjs(SDebug sDebug) {
        if (!sDebug.on() || this.getWrongConnObjs().size() == 0) {
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        NetCircuit netCircuit2 = this;
        synchronized (netCircuit2) {
            this.wrongConnObjs.clear();
        }
        sDebug.println("");
        sDebug.println("Wrong connections cleared");
        NetCircuit netCircuit3 = this;
        netCircuit3.ncMgr.permitPkgDbg();
    }

    public void fixWrongConnection(SDebug sDebug, int n, String string, int n2) {
        if (!sDebug.on()) {
            return;
        }
        List list = this.getWrongConnObjs();
        if (list.size() <= n) {
            sDebug.println("Wrong Connection Index mentioned");
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        IConnectionModel iConnectionModel = (IConnectionModel)list.get(n);
        sDebug.println("");
        sDebug.println("Fixing wrong connection object : " + n);
        sDebug.println("Connection Name: " + iConnectionModel.getConnectionName() + " CircuitId: " + NetCircuit.prettyString(iConnectionModel.getCircuitId()) + " Index: " + iConnectionModel.getIndex() + " Node: " + (iConnectionModel.getNodeModel() == null ? "null" : iConnectionModel.getNodeModel().getName()));
        int n3 = Network.instance().findNetElemByIp(string).getNodeId();
        CircuitId circuitId = new CircuitId(n3, n2);
        try {
            iConnectionModel.setCircuitId((ICircuitId)circuitId);
        }
        catch (Exception exception) {
            sDebug.println("Exception hit in setting the ckt Id");
            SDebug.printStackTrace((Throwable)exception);
        }
        sDebug.println("ckt id set successfully");
        NetCircuit netCircuit2 = this;
        netCircuit2.ncMgr.permitPkgDbg();
    }

    @Override
    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        NetCircuit netCircuit = this;
        netCircuit.ncMgr.suppressPkgDbg();
        sDebug.println("CIRCUIT Name=\"" + this.getCircuitName() + "\"" + "  Id=" + NetCircuit.prettyString(this.circuitId) + "  State=" + EnumStrings.getString(INetCircuitState.class, (int)this.state) + "  circuitInfo=" + (this.circuitInfoActive() ? "active" : "inactive"));
        sDebug.println("        " + EnumStrings.getString(ICircuitType.class, (int)this.getCircuitType()) + "  " + EnumStrings.getString(ICircuitSize.class, (int)this.getCircuitSize()) + "  " + EnumStrings.getString(ICircuitDirection.class, (int)this.getCircuitDir()) + (this.isMonitorCircuit() ? "  MONITOR" : "") + "  " + " SLA = " + this.getSla());
        sDebug.println("        serviceState=" + this.translateServiceState(this.getServiceState()) + "  adminState=" + this.translateAdminState(this.getAdminState()));
        sDebug.println("        pathProt=" + EnumStrings.getString(IPathProtection.class, (int)this.getDropPathProtection()) + "  protType=" + this.protType.getProtectionTypeString());
        if (!this.getCircuitTypeObj().isVcatCircuitType()) {
            sDebug.println("        isMemberOfVcat=" + this.isMemberOfVcat());
        } else {
            sDebug.println("        vcatRoutingPref=" + EnumStrings.getString(IVcatRoutePreference.class, (int)this.getVcatRoutingPref()));
        }
        sDebug.println("");
        sDebug.println("srcNode: " + (this.srcNodeModel == null ? "null" : this.srcNodeModel.getName()));
        sDebug.println("");
        sDebug.println("Source(s) :");
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            sDebug.println(" " + netCircuitEnd.prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitEnd.getStage()));
        }
        sDebug.println("");
        sDebug.println("Drop(s) :");
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCktDrops()) {
            sDebug.println(" " + netCircuitDropInfo.getNetCktEnd().prettyString() + " " + EnumStrings.getString(INetCircuitCreatStage.class, (int)netCircuitDropInfo.getNetCktEnd().getStage()) + " " + EnumStrings.getString(IPathProtection.class, (int)netCircuitDropInfo.getPathProt()));
        }
        if (this.getWrongConnObjs().size() != 0) {
            sDebug.println("");
            sDebug.println("Wrong Connection Objects :");
            Iterator iterator = this.getWrongConnObjs().iterator();
            while (iterator.hasNext()) {
                try {
                    IConnectionModel iConnectionModel = (IConnectionModel)iterator.next();
                    String string = "unknown";
                    if (iConnectionModel instanceof IHoConnectionModel) {
                        string = "Ho";
                    } else if (iConnectionModel instanceof ILoAditModel) {
                        string = "LoAdit";
                    } else if (iConnectionModel instanceof ILoConnectionModel) {
                        string = "Lo";
                    } else if (iConnectionModel instanceof IOchncConnectionModel) {
                        string = "Ochnc";
                    } else if (iConnectionModel instanceof IOchTrailAditModel) {
                        string = "OchTrailAdit";
                    } else if (iConnectionModel instanceof IOchccConnectionModel) {
                        string = "Ochcc";
                    }
                    sDebug.println("Connection Name: " + iConnectionModel.getConnectionName() + " CircuitId: " + NetCircuit.prettyString(iConnectionModel.getCircuitId()) + " Connection Type: " + string + " Node: " + (iConnectionModel.getNodeModel() == null ? "null" : iConnectionModel.getNodeModel().getName()));
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        this.printChild(sDebug);
        NetCircuit netCircuit2 = this;
        netCircuit2.ncMgr.permitPkgDbg();
    }

    protected String translateAdminState(int n) {
        return EnumStrings.getString(IAdminState.class, (int)(n + 1));
    }

    protected String translateServiceState(int n) {
        return EnumStrings.getString(INetCircuitServiceState.class, (int)(n + 1));
    }

    protected abstract void checkAndUpdateCircuit();

    protected abstract void runChildUpdate();

    abstract boolean completeCheck();

    protected abstract int deriveServiceState();

    protected abstract void printChild(SDebug var1);

    protected abstract void printDeconstructedConnections(SDebug var1);

    protected abstract void notifyChanged();

    protected abstract void notifyDeleted();

    protected abstract void dispose();

    protected abstract List getLinkEndpoints(INetLink var1);

    protected abstract boolean doesCircuitUseConn(INetElement var1, IConnectionModel var2);

    protected abstract String getCircuitNameFromSrcNode();

    protected abstract boolean isTl1Ckt() throws IncorrectCircuitState;

    protected abstract boolean circuitInfoActive();

    protected void setCircuitInfoActive() {
        this.circuitInfoActive = true;
    }

    protected abstract boolean usesNetElement(INetElement var1);

    protected abstract NetCircuitOperator getOperator();

    protected boolean isUcpCircuit() {
        return false;
    }

    protected void conformToCircuitInfo() {
    }

    protected void reloadTl1Objects() {
    }

    protected void disposeCircuitInfoAtNodes() {
    }

    @Override
    public boolean upsrBerThresholdsSettable() {
        return true;
    }

    protected List getUpsrSelectors() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            try {
                arrayList.addAll(((INetCircuitNode)iterator.next()).getUpsrConns());
            }
            catch (Exception exception) {
                db.println("Caught exception in getUpsrSelectors");
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return arrayList;
    }

    @Override
    public boolean validateBLSRTimeSlots(Map<INetLink, Integer> map) throws SanityCheckFailed {
        Iterator iterator = this.getCircuitNodes().iterator();
        ConnectionValidator connectionValidator = ConnectionValidator.instance();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (connectionValidator.validateBLSRTimeSlots(netCircuitNode, map)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCircuitNodeInVersionUp() {
        Iterator iterator = this.getCircuitNodes().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            INodeModel iNodeModel = netCircuitNode.getNodeModel();
            if (!iNodeModel.isVersionUpStateEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean isYCircuit() {
        return false;
    }

    @Override
    public void addOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
    }

    @Override
    public void deleteOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
    }

    @Override
    public synchronized void routeDrop(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.getOperator().routeDrop(iNetCircuitEndArray, routePrefs);
    }

    @Override
    public synchronized void routeDrop(INetCircuitEnd[] iNetCircuitEndArray, INetCircuitEnd[] iNetCircuitEndArray2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        this.getOperator().routeDrop(iNetCircuitEndArray, iNetCircuitEndArray2, routePrefs);
    }

    @Override
    public void setMemberNumberOvcat(int n) {
    }

    @Override
    public List getOpenVcatDrops() {
        List list = null;
        return list;
    }

    @Override
    public boolean backHaulVcatCircuit(INetCircuit iNetCircuit) {
        return NetCircuit.isBackHaulVcatCircuit(iNetCircuit);
    }

    public static boolean isBackHaulVcatCircuit(INetCircuit iNetCircuit) {
        NetVcatCircuit netVcatCircuit = null;
        if (iNetCircuit instanceof NetVcatCircuit) {
            netVcatCircuit = (NetVcatCircuit)iNetCircuit;
            if (netVcatCircuit.getForwardVcatGroup().getAllMemberCircuits().size() != 0) {
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netVcatCircuit.getForwardVcatGroup().getAllMemberCircuits().get(0);
                if (NetCircuit.isMemberOfBackHaulCircuit(netCcatCircuit)) {
                    return true;
                }
            } else if (netVcatCircuit.getCktSources().size() == 2) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)netVcatCircuit.getCktSources().get(0);
                INetCircuitEnd iNetCircuitEnd2 = (INetCircuitEnd)netVcatCircuit.getCktSources().get(1);
                IEntityModel iEntityModel = null;
                IEntityModel iEntityModel2 = null;
                try {
                    iEntityModel = iNetCircuitEnd.getEntityModel();
                    iEntityModel2 = iNetCircuitEnd2.getEntityModel();
                    if (NetCircuit.isMLMRPair(iEntityModel, iEntityModel2)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public boolean memberOfBackHaulCircuit(INetCircuit iNetCircuit) {
        return NetCircuit.isMemberOfBackHaulCircuit(iNetCircuit);
    }

    public static boolean isMemberOfBackHaulCircuit(INetCircuit iNetCircuit) {
        if (iNetCircuit instanceof NetCcatCircuit) {
            IEntityModel iEntityModel;
            IEntityModel iEntityModel2;
            INetCircuitEnd iNetCircuitEnd;
            INetCircuitEnd iNetCircuitEnd2;
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
            if (netCcatCircuit.getSrcNodeModel() != null && netCcatCircuit.getSrcNodeModel().provides(Feature.BACKHAUL_CIRCUITS) && netCcatCircuit.getSources().size() == 2) {
                iNetCircuitEnd2 = netCcatCircuit.getPrimarySource();
                iNetCircuitEnd = netCcatCircuit.getSecondarySource();
                iEntityModel2 = null;
                iEntityModel = null;
                try {
                    iEntityModel2 = iNetCircuitEnd2.getEntityModel();
                    iEntityModel = iNetCircuitEnd.getEntityModel();
                    if (NetCircuit.isMLMRPair(iEntityModel2, iEntityModel)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (netCcatCircuit.getPrimaryDrop() != null && netCcatCircuit.getPrimaryDrop().getNodeModel() != null && netCcatCircuit.getPrimaryDrop().getNodeModel().provides(Feature.BACKHAUL_CIRCUITS) && netCcatCircuit.getDrops().size() == 2) {
                iNetCircuitEnd2 = netCcatCircuit.getPrimaryDrop();
                iNetCircuitEnd = netCcatCircuit.getSecondaryDrop();
                iEntityModel2 = null;
                iEntityModel = null;
                try {
                    iEntityModel2 = iNetCircuitEnd2.getEntityModel();
                    iEntityModel = iNetCircuitEnd.getEntityModel();
                    if (NetCircuit.isMLMRPair(iEntityModel2, iEntityModel)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public List getTimeSlotViolations() {
        this.tsViolations = null;
        return this.tsViolations;
    }

    public void setTimeSlotViolations(List list) {
        this.tsViolations = list;
    }

    static boolean isMLMRPair(IEntityModel iEntityModel, IEntityModel iEntityModel2) {
        return iEntityModel.getModuleModel().getEqType() == 285 && iEntityModel2.getModuleModel().getEqType() == 285;
    }

    @Override
    public void addWrongConnObj(Object object) {
        if (object != null && object instanceof IConnectionModel) {
            this.wrongConnObjs.put(object, object);
        }
    }

    protected class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }
}

