/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CoreNodeModel;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPathStateInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCounterThread;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DataNetworkManager;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DeletionWarning;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitManager;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InvalidArgument;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.MissingLinks;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCcatCircuitRepairer;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDeleteWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitHealOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitProtectionSwitchWorker;
import cerent.cms.ncp.NetCircuitRepairer;
import cerent.cms.ncp.NetCircuitRollOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetModelMemorySizer;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatCircuitRepairer;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.OptionalTunnel;
import cerent.cms.ncp.ProtectionSwitchError;
import cerent.cms.ncp.ProtectionSwitchHelper;
import cerent.cms.ncp.RPRInfo;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetwork;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IAsyncObserver;
import cerent.util.IDebugDiag;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IMetrics;
import cerent.util.IPoDWDMUtility;
import cerent.util.LogLevel;
import cerent.util.NEMC;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.SvlanRange;
import cerent.util.WID;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetCircuitManager
extends CmsObservable
implements INetCircuitManager,
IJobGroupListener {
    private static final SDebug db = new SDebug("NetCircuitManager");
    private static final SDebug pkgDb = new SDebug("NcpPackage");
    private static boolean pkgDbgSuppressed = false;
    public DumpDebug dumpDb;
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    private static NetCircuitManager manager;
    private Map cktList;
    private Set nullIdCktList;
    private Map vcatMemCktList;
    private Set nullIdVcatMemCktList;
    private Map lapCktList;
    private Set nullIdLapCktList;
    private Object masterCktListLock;
    private Network net;
    private VlanSetManager vlanSetManager;
    private NetCircuitWatchDog watchDog;
    private HashMap circuitNameMap;
    private JobController createJobController;
    private JobGroup deleteJobGroup;
    private JobController deleteJobController;
    private JobGroup protectionSwitchJobGroup;
    private JobController protectionSwitchJobController;
    private JobGroup provAdminStateJobGroup;
    private int targetUnusedPortsState;
    private Thread protectionSwitchThread = null;
    private boolean allNodesOnCktRepair = false;
    private ArrayList<String> wavelengthsOfCktNotFixed = null;

    public static synchronized NetCircuitManager instance() {
        if (manager == null) {
            VlanSetManager vlanSetManager;
            Network network = Network.instance();
            if (network == null) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("Unable to instantiate Circuit Manager- null network");
                }
                return null;
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Obtained ref. to network. creating circuit manager");
            }
            if ((vlanSetManager = VlanSetManager.instance()) == null) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("Unable to get VLAN set manager instance");
                }
                return null;
            }
            manager = new NetCircuitManager(network, vlanSetManager);
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Network Circuit Manager created ");
            }
        }
        return manager;
    }

    @Override
    public void init() {
        this.dumpDb = new DumpDebug("Circuits");
        if (IMetrics.circuitDb.on()) {
            this.dumpDb.enableCircuitCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.dumpDb.dispose();
        Object object = this.masterCktListLock;
        synchronized (object) {
            NetCircuit netCircuit;
            Iterator<Object> iterator = this.cktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.lapCktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdLapCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.vcatMemCktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdVcatMemCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
        }
    }

    private NetCircuitManager(Network network, VlanSetManager vlanSetManager) {
        this.init();
        this.net = network;
        this.vlanSetManager = vlanSetManager;
        this.createJobController = null;
        this.deleteJobGroup = null;
        this.deleteJobController = null;
        this.provAdminStateJobGroup = null;
        this.cktList = new TreeMap(new CircuitIdComparator());
        this.nullIdCktList = new HashSet();
        this.lapCktList = new TreeMap(new CircuitIdComparator());
        this.nullIdLapCktList = new HashSet();
        this.vcatMemCktList = new TreeMap(new CircuitIdComparator());
        this.nullIdVcatMemCktList = new HashSet();
        this.masterCktListLock = new Object();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Circuit Manager- Creating Splicer object");
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Circuit Manager- Creating WatchDog object");
        }
        this.watchDog = NetCircuitWatchDog.instance();
        this.circuitNameMap = new HashMap();
    }

    public void dumpCircuitCount() {
        this.dumpDb.circuitCount();
    }

    protected int connCircuitSize(Object object) {
        if (object instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
            IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModel.getPaths();
            if (iHoPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return CircuitSize.width2sizeOfHoCircuit((int)iHoPathDefModelArray[0].getPathWidth(), (int)iHoPathDefModelArray[0].getStartingHo().getFramingType()).getEnum();
        }
        if (object instanceof ILoAditModel) {
            ILoAditModel iLoAditModel = (ILoAditModel)object;
            int n = iLoAditModel.getHo().getStartingHo().getFramingType();
            return CircuitSize.getLoTunnelSize((int)n).getEnum();
        }
        if (object instanceof ILoConnectionModel) {
            ILoConnectionModel iLoConnectionModel = (ILoConnectionModel)object;
            ILoDefModel[] iLoDefModelArray = iLoConnectionModel.getPaths();
            ILoNum iLoNum = iLoDefModelArray[0].getLoNum();
            if (iLoDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return CircuitSize.width2sizeOfLoCircuit((int)iLoNum.getLoPathWidth()).getEnum();
        }
        if (object instanceof IOchncConnectionModel) {
            IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)object;
            IOchncPathDefModel[] iOchncPathDefModelArray = iOchncConnectionModel.getPaths();
            if (iOchncPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchncPathDefModelArray[0].getCircuitSize();
        }
        if (object instanceof IOchccConnectionModel) {
            IOchccConnectionModel iOchccConnectionModel = (IOchccConnectionModel)object;
            IOchccPathDefModel[] iOchccPathDefModelArray = iOchccConnectionModel.getPaths();
            if (iOchccPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchccPathDefModelArray[0].getService();
        }
        if (object instanceof IOchTrailAditModel) {
            IOchTrailAditModel iOchTrailAditModel = (IOchTrailAditModel)object;
            IOchncPathDefModel[] iOchncPathDefModelArray = iOchTrailAditModel.getPaths();
            if (iOchncPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchncPathDefModelArray[0].getCircuitSize();
        }
        if (object instanceof ISvlanConnectionModel) {
            ISvlanConnectionModel iSvlanConnectionModel = (ISvlanConnectionModel)object;
            ISvlanPathDefModel[] iSvlanPathDefModelArray = iSvlanConnectionModel.getPaths();
            if (iSvlanPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iSvlanPathDefModelArray[0].getCircuitSize();
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Warning! connCircuitSize: unknown connection type");
        }
        return -1;
    }

    protected int connCircuitType(Object object) {
        int n = -1;
        if (object instanceof IModel) {
            INodeModel iNodeModel = ((IModel)object).getNodeModel();
            ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iNodeModel).getTdmProtocolTypeObj();
            if (object instanceof IHoConnectionModel) {
                IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
                n = iHoConnectionModel.getIntendedType() == 8 ? 0 : iTdmProtocolType.getHoCircuitType();
            } else if (object instanceof ILoConnectionModel) {
                n = iTdmProtocolType.getLoCircuitType();
            } else if (object instanceof ILoAditModel) {
                n = iTdmProtocolType.getAggCircuitType();
            } else if (object instanceof IOchncConnectionModel) {
                n = 9;
            } else if (object instanceof IOchTrailAditModel) {
                n = 15;
            } else if (object instanceof IOchccConnectionModel) {
                n = 14;
            } else if (object instanceof ISvlanConnectionModel) {
                n = 16;
            } else if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitType: unknown connection type");
            }
        }
        return n;
    }

    protected int connCircuitDir(Object object) {
        int n = -1;
        if (object instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
            n = iHoConnectionModel.getIntendedType();
        } else if (object instanceof ILoConnectionModel) {
            ILoConnectionModel iLoConnectionModel = (ILoConnectionModel)object;
            n = iLoConnectionModel.getConnectionType();
        } else {
            if (object instanceof ILoAditModel) {
                return 1;
            }
            if (object instanceof IOchTrailAditModel) {
                return 1;
            }
            if (object instanceof IOchccConnectionModel) {
                return 1;
            }
            if (object instanceof ISvlanConnectionModel) {
                return 1;
            }
            if (object instanceof IOchncConnectionModel) {
                IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)object;
                n = iOchncConnectionModel.getConnectionType();
            } else if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitDir: unknown connection type");
            }
        }
        return NetCircuitNode.getConnDir(n);
    }

    protected int connCircuitAdminState(Object object) {
        block3: {
            IConnectionModel iConnectionModel;
            INodeModel iNodeModel;
            if (object instanceof IConnectionModel && Feature.provides((INodeModel)(iNodeModel = (iConnectionModel = (IConnectionModel)object).getNodeModel()), (Feature)Feature.ENHANCED_STATE_MODEL)) {
                try {
                    return iConnectionModel.getAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("unknown admin state" + exception.getMessage());
                }
            }
        }
        return -1;
    }

    protected String connCircuitName(Object object) {
        block3: {
            IConnectionModel iConnectionModel;
            INodeModel iNodeModel;
            if (object instanceof IConnectionModel && Feature.provides((INodeModel)(iNodeModel = (iConnectionModel = (IConnectionModel)object).getNodeModel()), (Feature)Feature.TCCU)) {
                try {
                    return iConnectionModel.getConnectionName();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("Problem getting connection name" + exception.getMessage());
                }
            }
        }
        return "";
    }

    protected int vcatTermCircuitSize(Object object) {
        if (object instanceof IHoVcatTermModel) {
            IHoVcatTermModel iHoVcatTermModel = (IHoVcatTermModel)object;
            ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(iHoVcatTermModel.getNodeModel()).getTdmProtocolTypeObj();
            return CircuitSize.width2sizeOfHoCircuit((int)iHoVcatTermModel.getHoPathWidth(), (ITdmProtocolType)iTdmProtocolType).getEnum();
        }
        if (object instanceof ILoVcatTermModel) {
            ILoVcatTermModel iLoVcatTermModel = (ILoVcatTermModel)object;
            return CircuitSize.width2sizeOfLoCircuit((int)iLoVcatTermModel.getLoPathWidth()).getEnum();
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Warning! connCircuitSize: unknown connection type");
        }
        return -1;
    }

    protected int vcatTermCircuitType(Object object) {
        if (object instanceof IModel) {
            ITdmProtocolType iTdmProtocolType = Network.instance().findNetElem(((IModel)object).getNodeModel()).getTdmProtocolTypeObj();
            if (object instanceof IHoVcatTermModel) {
                return iTdmProtocolType.getHoVcatCircuitType();
            }
            if (object instanceof ILoVcatTermModel) {
                return iTdmProtocolType.getLoVcatCircuitType();
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitType: unknown connection type");
            }
        }
        return -1;
    }

    protected int vcatTermCircuitDir(Object object) {
        if (object instanceof IVcatTermModel) {
            return ((IVcatTermModel)object).getDirection();
        }
        return -1;
    }

    protected int vcatTermCircuitAdminState(Object object) {
        block3: {
            IVcatTermModel iVcatTermModel;
            INodeModel iNodeModel;
            if (object instanceof IVcatTermModel && Feature.provides((INodeModel)(iNodeModel = (iVcatTermModel = (IVcatTermModel)object).getNodeModel()), (Feature)Feature.ENHANCED_STATE_MODEL)) {
                try {
                    return iVcatTermModel.getAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("unknown admin state" + exception.getMessage());
                }
            }
        }
        return -1;
    }

    protected String vcatTermCircuitName(Object object) {
        block3: {
            IVcatTermModel iVcatTermModel;
            INodeModel iNodeModel;
            if (object instanceof IVcatTermModel && Feature.provides((INodeModel)(iNodeModel = (iVcatTermModel = (IVcatTermModel)object).getNodeModel()), (Feature)Feature.TCCU)) {
                try {
                    return iVcatTermModel.getVcatName();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("Problem getting vcat term name" + exception.getMessage());
                }
            }
        }
        return "";
    }

    @Override
    public int[] deleteCheck(INetCircuit[] iNetCircuitArray) {
        int[] nArray = null;
        int[] nArray2 = new int[iNetCircuitArray.length];
        int n = 0;
        int n2 = 0;
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: deleteCheck entered......");
        }
        for (n2 = 0; n2 < iNetCircuitArray.length; ++n2) {
            try {
                iNetCircuitArray[n2].circuitDeleteCheck();
                continue;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("DEL: invalid index " + n2);
                }
                nArray2[n++] = n2;
            }
        }
        if (n > 0) {
            nArray = new int[n];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("DEL: invalid count is " + n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = nArray2[n2];
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("DEL: invalid index " + nArray[n2]);
            }
        }
        return nArray;
    }

    public INetCircuit[] getOchccsForTunnel(INetCircuit iNetCircuit) {
        Object object;
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Retrieving OCHCC's for circuit " + iNetCircuit.getCircuitName());
        }
        if (iNetCircuit.getState() == 1 || iNetCircuit.getState() == 5) {
            object = this.getCircuits(iNetCircuit.getSrcCircuitNode().getNodeModel());
            List list = this.getCircuits(((NetCircuitDropInfo)iNetCircuit.getDrops().get(0)).getNodeModel());
            LinkedList<INetCircuit> object2 = new LinkedList<INetCircuit>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit2 = (INetCircuit)iterator.next();
                if (!iNetCircuit2.getCircuitTypeObj().isOchccCircuitType() || !list.contains(iNetCircuit2)) continue;
                object2.add(iNetCircuit2);
            }
            block1: for (INetCircuit iNetCircuit2 : object2) {
                List list2 = iNetCircuit2.getCircuitSpans();
                for (INetCircuitSpan iNetCircuitSpan : list2) {
                    OchTrailTunnelNetLink ochTrailTunnelNetLink;
                    INetCircuit iNetCircuit3;
                    INetLink iNetLink = iNetCircuitSpan.getLink();
                    if (iNetLink == null || !(iNetLink instanceof OchTrailTunnelNetLink) || (iNetCircuit3 = (ochTrailTunnelNetLink = (OchTrailTunnelNetLink)iNetLink).getLotCircuit()) == null || !iNetCircuit3.equals(iNetCircuit)) continue;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("OCHCC added: " + iNetCircuit2.getCircuitName());
                    }
                    linkedList.add(iNetCircuit2);
                    continue block1;
                }
            }
        }
        if (NetCircuitManager.dbgOn()) {
            object = new StringBuffer("OCHCC's for circuit " + iNetCircuit.getCircuitName() + ": ");
            for (INetCircuit iNetCircuit4 : linkedList) {
                ((StringBuffer)object).append(" " + iNetCircuit4.getCircuitName());
            }
            NetCircuitManager.debug(((StringBuffer)object).toString());
        }
        return linkedList.toArray(new INetCircuit[0]);
    }

    private INetCircuit[] adjustedCircuitsToDelete(INetCircuit[] iNetCircuitArray) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Starting adjustedCircuitsToDelete (" + iNetCircuitArray.length + " circuits)");
        }
        List<INetCircuit> list = Arrays.asList(iNetCircuitArray);
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        for (INetCircuit iNetCircuit : list) {
            if (iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                INetCircuit[] iNetCircuitArray2 = this.getOchccsForTunnel(iNetCircuit);
                boolean bl = true;
                for (int i = 0; bl && i < iNetCircuitArray2.length; ++i) {
                    if (list.contains(iNetCircuitArray2[i])) continue;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Cannot find OCHCC " + iNetCircuitArray2[i].getCircuitName() + " - OTT not removed");
                    }
                    bl = false;
                }
                if (iNetCircuitArray2.length == 0 || !bl) {
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("OTT " + iNetCircuit.getCircuitName() + " added to adjusted list");
                    }
                    linkedList.add(iNetCircuit);
                    continue;
                }
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("OTT " + iNetCircuit.getCircuitName() + " removed since all its OCHCCs are already in");
                continue;
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Adding non OTT circuit " + iNetCircuit.getCircuitName());
            }
            linkedList.add(iNetCircuit);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Exiting adjustedCircuitsToDelete (" + linkedList.size() + " circuits)");
        }
        return linkedList.toArray(new INetCircuit[0]);
    }

    @Override
    public boolean deleteSelectedCircuits(INetCircuit[] iNetCircuitArray, int n, IAsyncObserver iAsyncObserver) throws DeletionError {
        iNetCircuitArray = this.adjustedCircuitsToDelete(iNetCircuitArray);
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        String string = null;
        String string2 = null;
        int n2 = iNetCircuitArray.length;
        if (n2 < 1) {
            return false;
        }
        if (this.deleteJobGroup != null) {
            throw new DeletionError("Another delete job is already in progress.\nPlease wait until that job completes.");
        }
        if (this.deleteJobController == null) {
            this.deleteJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.deleteJobController == null) {
            throw new DeletionError("Circuit deletion jobs could not be created.");
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            if (iNetCircuitArray[i].getState() == 2) continue;
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("DEL: sanity check......");
            }
            try {
                iNetCircuitArray[i].destroySanityCheck();
                this.deleteSRLG((NetCircuit)iNetCircuitArray[i]);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                bl = true;
                string2 = sanityCheckFailed.getMessage();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                bl = true;
                string2 = abstractCmsIOException.getMessage();
            }
            if (bl) {
                if (string == null) {
                    string = "The following circuits could not be scheduled for deletion.\n";
                }
                string = string + "An error occurred while deleting the circuit " + iNetCircuitArray[i].getCircuitName() + ".\n ";
                string = string + string2 + "\n";
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("deleteSelectedCircuits: " + string);
                continue;
            }
            linkedList.add(iNetCircuitArray[i]);
        }
        INetCircuit[] iNetCircuitArray2 = new INetCircuit[linkedList.size()];
        iNetCircuitArray2 = linkedList.toArray(iNetCircuitArray2);
        n2 = iNetCircuitArray2.length;
        StringBuffer stringBuffer = new StringBuffer();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("NCP said delete " + n2 + " circuits");
        }
        if (n2 < 1) {
            if (string != null) {
                throw new DeletionError(string);
            }
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            iNetCircuitArray2[i].setState(2);
        }
        IJobControl[] iJobControlArray = new IJobControl[n2];
        for (int i = 0; i < n2; ++i) {
            iJobControlArray[i] = new NetCircuitDeleteWorker(iNetCircuitArray2[i], n);
        }
        this.targetUnusedPortsState = n;
        this.deleteJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, (Object)iAsyncObserver);
        this.deleteJobController.submitJob(this.deleteJobGroup);
        if (string != null) {
            throw new DeletionError(string);
        }
        return true;
    }

    private boolean deleteSRLG(NetCircuit netCircuit) {
        try {
            IPoDWDMUtility iPoDWDMUtility = IPoDWDMUtility.instance();
            INodeModel iNodeModel = iPoDWDMUtility.getSourceCRS(netCircuit);
            INodeModel iNodeModel2 = iPoDWDMUtility.getDestCRS(netCircuit);
            if (iNodeModel != null && iNodeModel2 != null) {
                iPoDWDMUtility.deleteSRLG(iNodeModel, netCircuit, iPoDWDMUtility.getSourceIndex(netCircuit));
                iPoDWDMUtility.deleteSRLG(iNodeModel2, netCircuit, iPoDWDMUtility.getDestIndex(netCircuit));
            }
        }
        catch (Exception exception) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Unable to delete the SRLG: " + exception);
            }
            ErrorMsg.displayWarning(null, (WID)NEMC.WID_NO_SRLG_DELETION);
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteSelectedCircuits(INetCircuit[] iNetCircuitArray, IAsyncObserver iAsyncObserver) throws DeletionError {
        return this.deleteSelectedCircuits(iNetCircuitArray, -1, iAsyncObserver);
    }

    protected JobController getCreateJc() {
        if (this.createJobController == null) {
            this.createJobController = JobControllerFactory.createJC((int)5);
        }
        return this.createJobController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCircuit(INetCircuit iNetCircuit, boolean bl) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("insertCircuit(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.isMemberOfVcat()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdVcatMemCktList.add(iNetCircuit);
                } else {
                    this.nullIdVcatMemCktList.remove(iNetCircuit);
                    this.vcatMemCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                }
            } else if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.add(iNetCircuit);
                this.insertCircuitIfLAP(iNetCircuit);
            } else {
                this.nullIdCktList.remove(iNetCircuit);
                this.cktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                this.insertCircuitIfLAP(iNetCircuit);
            }
        }
        if (bl) {
            this.notifyChanged(iNetCircuit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCircuitIfLAP(INetCircuit iNetCircuit) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("insertCircuitIfLAP(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdLapCktList.add(iNetCircuit);
                } else {
                    this.lapCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCircuitIfLAP(INetCircuit iNetCircuit) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("removeCircuitIfLAP(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdLapCktList.remove(iNetCircuit);
                } else {
                    this.lapCktList.remove(iNetCircuit.getCircuitId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCircuit(INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("removeCircuit(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.isMemberOfVcat()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdVcatMemCktList.remove(iNetCircuit);
                } else {
                    this.vcatMemCktList.remove(iNetCircuit.getCircuitId());
                }
            } else if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.remove(iNetCircuit);
                this.removeCircuitIfLAP(iNetCircuit);
            } else {
                this.cktList.remove(iNetCircuit.getCircuitId());
                this.removeCircuitIfLAP(iNetCircuit);
            }
        }
        this.notifyChanged(iNetCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertCcatToMember(INetCircuit iNetCircuit) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("convertCcatToMember(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.remove(iNetCircuit);
                this.nullIdVcatMemCktList.add(iNetCircuit);
            } else {
                this.cktList.remove(iNetCircuit.getCircuitId());
                this.vcatMemCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertMemberToCcat(INetCircuit iNetCircuit) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("convertMemberToCcat(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdVcatMemCktList.remove(iNetCircuit);
                this.nullIdCktList.add(iNetCircuit);
            } else {
                this.vcatMemCktList.remove(iNetCircuit.getCircuitId());
                this.cktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
            }
        }
    }

    protected NetCircuitRepairer getCircuitRepairer(NetCircuit netCircuit) {
        NetCircuitRepairer netCircuitRepairer = null;
        if (netCircuit instanceof NetCcatCircuit) {
            netCircuitRepairer = new NetCcatCircuitRepairer(netCircuit);
        } else if (netCircuit instanceof NetVcatCircuit) {
            netCircuitRepairer = new NetVcatCircuitRepairer(netCircuit);
        }
        return netCircuitRepairer;
    }

    public Set getAffectedNodes(int n, int n2) {
        HashSet hashSet = new HashSet();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAffectedNodes: oldNodeId = " + n + "New NodeID = " + n2);
            NetCircuitManager.debug("Examining each Circuit ... ");
        }
        if (this.allNodesOnCktRepair) {
            HashSet<INodeModel> hashSet2 = new HashSet<INodeModel>();
            Collection collection = Network.instance().getAllElements();
            for (Object e : collection) {
                INetElement iNetElement = (INetElement)e;
                INodeModel iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) continue;
                hashSet2.add(iNodeModel);
            }
            return hashSet2;
        }
        LinkedList linkedList = this.getAllCTCCircuits(n2);
        for (NetCircuit netCircuit : linkedList) {
            Set set = new HashSet();
            NetCircuitRepairer netCircuitRepairer = this.getCircuitRepairer(netCircuit);
            set = netCircuitRepairer.getAffectedNodes(n, n2);
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAffectedNodes for Circuit: " + NetCircuit.prettyString(netCircuit.getCircuitId()));
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    NetCircuitManager.debug("getAffectedNodes: Node " + ((INodeModel)iterator.next()).getName());
                }
            }
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public int repairCircuits(int n, int n2) throws CircuitProvError {
        int n3 = 0;
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("repairCircuits: oldNodeId = " + n + " newNodeId = " + n2);
            NetCircuitManager.debug("Examining each Circuit ... ");
        }
        LinkedList linkedList = this.getAllCTCCircuits(n2);
        for (NetCircuit netCircuit : linkedList) {
            if (netCircuit.isMemberOfVcat()) continue;
            NetCircuitRepairer netCircuitRepairer = this.getCircuitRepairer(netCircuit);
            netCircuitRepairer.repairCircuit(n, n2);
            ++n3;
        }
        return n3;
    }

    @Override
    public List getAvailSourcePorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl) {
        Endpoints endpoints = Endpoints.instance();
        List list = endpoints.getAvailSourcePorts(iNodeModel, circuitCreatInfo, bl);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAvailSourcePorts: looking for LAP circuit");
            }
            List list2 = this.getAvailLAPEntities(iNodeModel, circuitCreatInfo.size(), bl, null);
            list.addAll(list2);
        }
        return list;
    }

    protected List getAvailSourcePorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl, IEntityModel iEntityModel) {
        List list = this.getAvailSourcePorts(iNodeModel, circuitCreatInfo, bl);
        if (iEntityModel == null) {
            return list;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            if (iEntityModel2.getPayloadType() == iEntityModel.getPayloadType()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getFirstAvailPairPPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        return Endpoints.instance().getFirstAvailPairPPorts(iNodeModel, circuitCreatInfo);
    }

    @Override
    public List getAvailSourcePoints(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) {
        List list = Endpoints.instance().getAvailSourcePoints(iNodeModel, iEntityModel, circuitCreatInfo);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            List list2 = this.getAvailLAPPaths(iNodeModel, iEntityModel, circuitCreatInfo.size(), null);
            list.addAll(list2);
        }
        return list;
    }

    protected List getAvailLAPEntities(INodeModel iNodeModel, int n, boolean bl, NetCircuit netCircuit) {
        Object object;
        ILoAditModel iLoAditModel;
        Object object22;
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        List list = this.getLAPHoNode(iNodeModel);
        for (Object object22 : list) {
            ICircuitSize iCircuitSize;
            short s;
            ILoPathInfo[] iLoPathInfoArray;
            if (netCircuit != null && netCircuit.getState() == 1 && netCircuit.isCircuitProtected() && !((NetCircuit)object22).isCircuitProtected() || (iLoPathInfoArray = (iLoAditModel = (ILoAditModel)((LoTunnelNode)(object = (LoTunnelNode)((HoCcatCircuit)object22).getLoTunnelNodes().get(0))).getConn()).getAvailableLos((int)(s = (iCircuitSize = CircuitSize.getCircuitSize((int)n)).size2widthOfLoCircuit()))).length == 0) continue;
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAvailLAPEntities find available path " + ((NetCircuit)object22).getCircuitName());
            }
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)((NetCircuit)object22).getCktSources().get(0);
            try {
                IEntityModel iEntityModel = netCircuitEnd.getEntityModel();
                linkedList.add(iEntityModel);
            }
            catch (ObjNotFound objNotFound) {
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("getAvailLAPEntities hit exception with LAP " + ((NetCircuit)object22).getCircuitName());
            }
        }
        object22 = iNodeModel.getEntityTable();
        object = linkedList.toArray();
        iLoAditModel = new IEntityModel[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            iLoAditModel[i] = (IEntityModel)object[i];
        }
        LinkedList linkedList2 = new LinkedList();
        if (iNodeModel.provides(Feature.SCREEN_ENTITIES)) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("entityModel.screenAvailEntities called");
            }
            object22.screenAvailEntities((IEntityModel[])iLoAditModel, linkedList2, bl);
            return linkedList2;
        }
        return linkedList;
    }

    protected List getAvailLAPPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, NetCircuit netCircuit) {
        LinkedList<LoCircuitEnd> linkedList = new LinkedList<LoCircuitEnd>();
        List list = this.getLAPHoEntity(iNodeModel, iEntityModel);
        for (HoCcatCircuit hoCcatCircuit : list) {
            if (netCircuit != null && netCircuit.getState() == 1 && netCircuit.isCircuitProtected() && !hoCcatCircuit.isCircuitProtected()) continue;
            LoTunnelNode loTunnelNode = (LoTunnelNode)hoCcatCircuit.getLoTunnelNodes().get(0);
            ILoAditModel iLoAditModel = (ILoAditModel)loTunnelNode.getConn();
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n);
            short s = iCircuitSize.size2widthOfLoCircuit();
            ILoPathInfo[] iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
            IHoNum iHoNum = ((NetCircuitEnd)hoCcatCircuit.getCktSources().get(0)).getHoNum();
            if (iLoPathInfoArray.length == 0) continue;
            for (ILoPathInfo iLoPathInfo : Arrays.asList(iLoPathInfoArray)) {
                LoCircuitEnd loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoPathInfo.getLoNum(), false);
                linkedList.add(loCircuitEnd);
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailLAPPaths: return " + linkedList.size() + " paths");
        }
        return linkedList;
    }

    public boolean canCreateStitchedCircuit(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        boolean bl = false;
        if (iNodeModel instanceof CoreNodeModel) {
            return false;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if ((iCircuitType.isEthernetCircuitType() || iCircuitType.isHoCircuitType()) && circuitCreatInfo.dir() == 1) {
            short s = circuitCreatInfo.sizeObj().size2widthOfHoCircuit();
            IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
            bl = iConnectionModels.getBiggestEtherpathAvailable() >= s;
        }
        return bl;
    }

    public boolean isLoTunnelNeeded(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        return OptionalTunnel.instance().isLoTunnelNeeded(iNetCircuit, list, routePrefs);
    }

    public boolean canHaveOptionalLot(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        return OptionalTunnel.instance().canHaveOptionalLot(iNetCircuit, list, routePrefs);
    }

    public List createLoTunnels(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        return OptionalTunnel.instance().createLoTunnels(iNetCircuit, iNetCircuitEnd, routePrefs);
    }

    public List createLoTunnels(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        return OptionalTunnel.instance().createLoTunnels(iNetCircuit, list, routePrefs);
    }

    public List createLoTunnel(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs, boolean bl) throws Exception {
        return OptionalTunnel.instance().createLoTunnel(iNetCircuit, iNetCircuitEnd, routePrefs, bl);
    }

    public List createLoTunnel(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs, boolean bl) throws Exception {
        return OptionalTunnel.instance().createLoTunnel(iNetCircuit, list, routePrefs, bl);
    }

    public List findLoTunnels(INetElement iNetElement, INetElement iNetElement2) {
        return this.findLoTunnels(iNetElement, iNetElement2, true);
    }

    public List findLoTunnels(INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        List list = this.net.findAllLoTunnelNetLinks(iNetElement, iNetElement2, bl);
        for (NetLink netLink : list) {
            NetCircuit netCircuit = (NetCircuit)netLink.getLotCircuit();
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    protected NetCircuit findLoTunnel(INetLink iNetLink, IHoNum iHoNum, IHoNum iHoNum2) {
        INetElement iNetElement = iNetLink.getSrc();
        INetElement iNetElement2 = iNetLink.getDst();
        if (NetCircuitManager.dbgOn()) {
            db.println("findLoTunnel: on " + iNetLink.prettyString());
        }
        for (NetCircuit netCircuit : this.findLoTunnels(iNetElement, iNetElement2, true)) {
            List list = netCircuit.getCircuitNodeFromNE(iNetElement);
            NetCircuitNode netCircuitNode = null;
            if (list != null) {
                if (list.size() > 1) {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("Error !! MXPN in a circuit using tunnel");
                    }
                } else {
                    netCircuitNode = (NetCircuitNode)list.get(0);
                }
            }
            list = netCircuit.getCircuitNodeFromNE(iNetElement2);
            NetCircuitNode netCircuitNode2 = null;
            if (list != null) {
                if (list.size() > 1) {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("Error !! MXPN in a circuit using tunnel");
                    }
                } else {
                    netCircuitNode2 = (NetCircuitNode)list.get(0);
                }
            }
            if (netCircuitNode == null || netCircuitNode2 == null) continue;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)netCircuitNode.getBiSpans().get(0);
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)netCircuitNode2.getBiSpans().get(0);
            if (netCircuitSpan.getEntityIndex(iNetElement) != iNetLink.getSrcEntityIndex() || netCircuitSpan2.getEntityIndex(iNetElement2) != iNetLink.getDstEntityIndex() || !holoComp.isEqual(netCircuitSpan.getSrcHoNum(), iHoNum) || !holoComp.isEqual(netCircuitSpan2.getDstHoNum(), iHoNum2)) continue;
            if (NetCircuitManager.dbgOn()) {
                db.println("findLoTunnel: on " + iNetLink.prettyString() + " with srcHo " + iHoNum.getHoNum() + " with dstHo " + iHoNum2.getHoNum());
            }
            return netCircuit;
        }
        return null;
    }

    public List createOchTrailTunnel(INetCircuit iNetCircuit, RoutePrefs routePrefs, int n) throws NoRoute, AllocFailed, Exception {
        Object object;
        Object object2;
        Object object3;
        IEntityModel[] iEntityModelArray;
        IEntityModel[] iEntityModelArray2;
        LinkedList<INetCircuit> linkedList;
        block25: {
            linkedList = new LinkedList<INetCircuit>();
            if (NetCircuitManager.dbgOn()) {
                db.println("createOchTrailTunnel using Channel " + iNetCircuit.getCircuitOptChannel());
            }
            iEntityModelArray2 = new IEntityModel[]{};
            iEntityModelArray = new IEntityModel[]{};
            try {
                iEntityModelArray2 = OchTrailHelper.getTrunkPorts(routePrefs.getSrc().getNodeModel(), routePrefs.getcktSrcEntityIndex());
                iEntityModelArray = OchTrailHelper.getTrunkPorts(routePrefs.getDst().getNodeModel(), routePrefs.getcktDstEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("Exception getting trunk ports " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!NetCircuitManager.dbgOn()) break block25;
                db.println("Exception getting trunk ports " + (Object)((Object)noSuchEquipment));
            }
        }
        if (iEntityModelArray2.length != 0 || iEntityModelArray.length != 0) {
            object3 = this.findOchTrailTunnel(routePrefs.getSrc(), iEntityModelArray2[0].getEntityIndex());
            if (object3 != null) {
                if (n == 3) {
                    int n2;
                    INetCircuit iNetCircuit2 = ((NetLink)object3).getLotCircuit();
                    if (NetCircuitManager.dbgOn()) {
                        db.println("OTT ckt for link " + object3 + " is " + (iNetCircuit2 == null ? "null" : iNetCircuit2.getCircuitName()));
                    }
                    if (iNetCircuit2 != null && (n2 = iNetCircuit2.getAdminState()) != 0 && n2 != 3) {
                        if (NetCircuitManager.dbgOn()) {
                            db.println("Forcing OTT circuit " + iNetCircuit2.getCircuitName() + " to IS, AINS");
                        }
                        iNetCircuit2.setAdminState(n);
                    }
                }
                return linkedList;
            }
        } else {
            throw new NoRoute("The OCH trail circuit cannot be routed because trunk ports are not available.");
        }
        List list = this.getCircuitPathForOchTrailTunnel(routePrefs, iEntityModelArray2, iEntityModelArray);
        object3 = list.iterator();
        while (object3.hasNext()) {
            try {
                object2 = (NetCircuitPath)object3.next();
                object = ((NetCircuitPath)object2).getOchTrailTunnel(n);
                if (object == null) continue;
                linkedList.add((INetCircuit)object);
            }
            catch (NoRoute noRoute) {
                if (!linkedList.isEmpty()) {
                    object = (INetCircuit)linkedList.get(0);
                    object.destroyCircuit();
                }
                throw new NoRoute("The OCH trail circuit cannot be routed.");
            }
        }
        if (!linkedList.isEmpty()) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("OchTrail Tunnel Circuit Provisioning");
                }
                object = null;
                boolean bl = true;
                INetCircuit iNetCircuit3 = (INetCircuit)object2.next();
                try {
                    iNetCircuit3.provision();
                    bl = false;
                }
                catch (Exception exception) {
                    object = new AnnotatedException("Unable to create required OchTrail tunnel", exception);
                }
                if (!bl) continue;
                try {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("createOchTrailTunnel: destroying OchTrail tunnel");
                    }
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        iNetCircuit3 = (INetCircuit)object2.next();
                        iNetCircuit3.destroyCircuit();
                    }
                }
                catch (Exception exception) {
                    throw new AnnotatedException("The OCH trail tunnel cannot be destroyed.", exception);
                }
                if (object == null) continue;
                throw object;
            }
        }
        return linkedList;
    }

    private List getCircuitPathForOchTrailTunnel(RoutePrefs routePrefs, IEntityModel[] iEntityModelArray, IEntityModel[] iEntityModelArray2) throws AllocFailed {
        LinkedList<NetCircuitPath> linkedList;
        block6: {
            RoutePrefs routePrefs2;
            NetCircuitPath netCircuitPath;
            block5: {
                linkedList = new LinkedList<NetCircuitPath>();
                NetCircuitPath netCircuitPath2 = null;
                netCircuitPath = null;
                routePrefs2 = new RoutePrefs(routePrefs);
                routePrefs2.setCircuitSize(CircuitSize.SIZE_OCHNC_ENS.getEnum());
                routePrefs2.setCircuitType(15);
                routePrefs2.setDirectionality(3);
                routePrefs2.setTunnel(true);
                routePrefs2.setcktSrcEntityIndex(iEntityModelArray[0].getEntityIndex());
                routePrefs2.setcktDstEntityIndex(iEntityModelArray2[0].getEntityIndex());
                netCircuitPath2 = new NetCircuitPath(routePrefs2, null);
                try {
                    netCircuitPath2.computeCircuitPath();
                    linkedList.add(netCircuitPath2);
                }
                catch (NoRoute noRoute) {
                    if (!NetCircuitManager.dbgOn()) break block5;
                    db.println("Cannot create primary OchTrail tunnel circuit: " + noRoute.getMessage());
                }
            }
            if (iEntityModelArray.length == 2 && iEntityModelArray2.length == 2) {
                RoutePrefs routePrefs3 = new RoutePrefs(routePrefs2);
                routePrefs3.setcktSrcEntityIndex(iEntityModelArray[1].getEntityIndex());
                routePrefs3.setcktDstEntityIndex(iEntityModelArray2[1].getEntityIndex());
                netCircuitPath = new NetCircuitPath(routePrefs3, null);
                try {
                    netCircuitPath.computeCircuitPath();
                    linkedList.add(netCircuitPath);
                }
                catch (NoRoute noRoute) {
                    if (!NetCircuitManager.dbgOn()) break block6;
                    db.println("Cannot create secondary OchTrail tunnel circuit: " + noRoute.getMessage());
                }
            }
        }
        return linkedList;
    }

    public INetLink findOchTrailTunnel(INetElement iNetElement, int n) {
        INetLink iNetLink = this.net.findOchTrailTunnelNetLinkFromSrc(iNetElement, n);
        if (iNetLink != null) {
            if (NetCircuitManager.dbgOn()) {
                db.println("OchTrail tunnel already exists " + iNetLink.prettyString());
            }
        } else if (NetCircuitManager.dbgOn()) {
            db.println("No OchTrail tunnels for given requirements");
        }
        return iNetLink;
    }

    protected Object getMasterCktListLock() {
        return this.masterCktListLock;
    }

    public LinkedList getAllCTCCircuits(int n) {
        INetCircuit iNetCircuit;
        INetCircuit iNetCircuit2;
        INetCircuit iNetCircuit3;
        INetCircuit iNetCircuit4;
        INetCircuit iNetCircuit5;
        INetCircuit iNetCircuit6;
        INetCircuit iNetCircuit7;
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        INetElement iNetElement = this.net.findNetElem(n);
        if (iNetElement == null) {
            return linkedList;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return linkedList;
        }
        IHoConnectionModel[] iHoConnectionModelArray = iNodeModel.getConnectionModels().getHoConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Ho Connections: " + iHoConnectionModelArray.length);
        }
        for (int i = 0; i < iHoConnectionModelArray.length; ++i) {
            IHoConnectionModel iHoConnectionModel = iHoConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iHoConnectionModel.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iHoConnectionModel.getCircuitId())) continue;
            iNetCircuit7 = this.getCircuitFromId(iHoConnectionModel.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit7.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit7.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit7);
        }
        IOchncConnectionModel[] iOchncConnectionModelArray = iNodeModel.getConnectionModels().getOchncConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OCHNC Connections: " + iOchncConnectionModelArray.length);
        }
        for (int i = 0; i < iOchncConnectionModelArray.length; ++i) {
            iNetCircuit7 = iOchncConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit7.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit7.getCircuitId())) continue;
            iNetCircuit6 = this.getCircuitFromId(iNetCircuit7.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit6.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit6.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit6);
        }
        IOchTrailAditModel[] iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OchTrail Adits: " + iOchTrailAditModelArray.length);
        }
        for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
            iNetCircuit6 = iOchTrailAditModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit6.getCircuitId()) + ")");
            }
            if (iNetCircuit6.getCircuitId().getUniquePart().getUniqueId() == 0) continue;
            iNetCircuit5 = this.getCircuitFromId(iNetCircuit6.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit5.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit5.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit5);
        }
        IOchccConnectionModel[] iOchccConnectionModelArray = iNodeModel.getConnectionModels().getOchccConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OCHCC Connections: " + iOchccConnectionModelArray.length);
        }
        for (int i = 0; i < iOchccConnectionModelArray.length; ++i) {
            iNetCircuit5 = iOchccConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit5.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit5.getCircuitId())) continue;
            iNetCircuit4 = this.getCircuitFromId(iNetCircuit5.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit4.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit4.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit4);
        }
        ILoConnectionModel[] iLoConnectionModelArray = iNodeModel.getConnectionModels().getLoConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Lo Connections: " + iLoConnectionModelArray.length);
        }
        for (int i = 0; i < iLoConnectionModelArray.length; ++i) {
            iNetCircuit4 = iLoConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit4.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit4.getCircuitId())) continue;
            iNetCircuit3 = this.getCircuitFromId(iNetCircuit4.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit3.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit3.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit3);
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Lo Adits: " + iLoAditModelArray.length);
        }
        for (int i = 0; i < iLoAditModelArray.length; ++i) {
            iNetCircuit3 = iLoAditModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit3.getCircuitId()) + ")");
            }
            if (iNetCircuit3.getCircuitId().getUniquePart().getUniqueId() == 0) continue;
            iNetCircuit2 = this.getCircuitFromId(iNetCircuit3.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit2.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit2.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit2);
        }
        IHoVcatTermModel[] iHoVcatTermModelArray = iNodeModel.getVcatTermModels().getHoVcatTermModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of vcat terms: " + iHoVcatTermModelArray.length);
        }
        for (int i = 0; i < iHoVcatTermModelArray.length; ++i) {
            iNetCircuit2 = iHoVcatTermModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetVcatCircuit.prettyString(iNetCircuit2.getCircuitId()) + ")");
            }
            if (NetVcatCircuit.isNullCircuitId(iNetCircuit2.getCircuitId())) continue;
            iNetCircuit = this.getCircuitFromId(iNetCircuit2.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit.getCircuitName() + ", " + NetVcatCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit);
        }
        ILoVcatTermModel[] iLoVcatTermModelArray = iNodeModel.getVcatTermModels().getLoVcatTermModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of vcat terms: " + iLoVcatTermModelArray.length);
        }
        for (int i = 0; i < iLoVcatTermModelArray.length; ++i) {
            iNetCircuit = iLoVcatTermModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetVcatCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            if (NetVcatCircuit.isNullCircuitId(iNetCircuit.getCircuitId())) continue;
            INetCircuit iNetCircuit8 = this.getCircuitFromId(iNetCircuit.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit8.getCircuitName() + ", " + NetVcatCircuit.prettyString(iNetCircuit8.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit8);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.cktList.values());
            linkedList.addAll(this.filterYCircuits(this.nullIdCktList));
            linkedList.removeAll(this.getSvlanCircuits());
        }
        return linkedList;
    }

    public Set filterYCircuits(Set set) {
        HashSet hashSet = new HashSet(set);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (!(netCircuit instanceof LoCcatCircuit) || !((LoCcatCircuit)netCircuit).isYCircuit || ((LoCcatCircuit)netCircuit).isYActive()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<SvlanCircuit> getSvlanCircuits() {
        HashSet<SvlanCircuit> hashSet = new HashSet<SvlanCircuit>();
        Object object = this.masterCktListLock;
        synchronized (object) {
            for (NetCircuit netCircuit : this.nullIdCktList) {
                if (!netCircuit.getCircuitTypeObj().isSVLANType()) continue;
                hashSet.add((SvlanCircuit)netCircuit);
            }
        }
        return hashSet;
    }

    public void discoverSvlanCircuits(SvlanRange[] svlanRangeArray) {
        NetCircuitWatchDog netCircuitWatchDog = NetCircuitWatchDog.instance();
        LinkedList linkedList = new LinkedList();
        linkedList = (LinkedList)Network.instance().getElements();
        netCircuitWatchDog.loadSvlanConnections(linkedList, svlanRangeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeSvlanCircuits() {
        if (db.on()) {
            db.println("disposeSvlanCircuits() entered.");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            Iterator iterator = this.nullIdCktList.iterator();
            NetCircuit netCircuit = null;
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                if (db.on()) {
                    db.println("disposing: " + netCircuit.getCircuitName());
                }
                if (!netCircuit.getCircuitTypeObj().isSVLANType()) continue;
                netCircuit.notifyDeleted();
                iterator.remove();
                netCircuit.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(netCircuit, netCircuit, "deleted");
            }
        }
    }

    public HashSet<SvlanCircuit> getSvlanCircuits(INodeModel iNodeModel) {
        HashSet<SvlanCircuit> hashSet = new HashSet<SvlanCircuit>();
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            hashSet = this.getSvlanCircuits();
            Iterator<SvlanCircuit> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = iterator.next();
                if (netCircuit.usesNetElement(iNetElement)) continue;
                iterator.remove();
            }
        }
        return hashSet;
    }

    public HashSet<SvlanCircuit> getSvlanCircuits(INodeModel iNodeModel, int n) {
        Object netCircuit2 = null;
        INetElement iNetElement = null;
        HashSet<SvlanCircuit> hashSet = this.getSvlanCircuits(iNodeModel);
        HashSet<SvlanCircuit> hashSet2 = new HashSet<SvlanCircuit>();
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        for (NetCircuit netCircuit : hashSet) {
            List list = netCircuit.getCircuitNodeFromNE(iNetElement);
            if (list == null) continue;
            INetCircuitNode iNetCircuitNode2 = null;
            block3: for (INetCircuitNode iNetCircuitNode2 : list) {
                List list2 = iNetCircuitNode2.getPathList();
                for (IPathDefModel iPathDefModel : list2) {
                    try {
                        IEntityModel iEntityModel;
                        ISvlanPathDefModel iSvlanPathDefModel;
                        if (!(iPathDefModel instanceof ISvlanPathDefModel) || !(iSvlanPathDefModel = (ISvlanPathDefModel)iPathDefModel).getNodeModel().equals(iNodeModel) || (iEntityModel = iSvlanPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iSvlanPathDefModel.getPortEntityIdx())).getShelfId() != n) continue;
                        hashSet2.add((SvlanCircuit)netCircuit);
                        continue block3;
                    }
                    catch (Exception exception) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        db.println("getCircuits path error: " + iPathDefModel);
                    }
                }
            }
        }
        return hashSet2;
    }

    public HashSet<SvlanCircuit> getSvlanCircuits(List list) {
        INodeModel iNodeModel = null;
        IConnectionModel iConnectionModel = null;
        INetElement iNetElement = null;
        HashSet<SvlanCircuit> hashSet = new HashSet<SvlanCircuit>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            iConnectionModel = null;
            iNodeModel = null;
            iNetElement = null;
            iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel != null) {
                iNodeModel = iConnectionModel.getNodeModel();
            }
            if (iNodeModel != null) {
                iNetElement = this.net.findNetElem(iNodeModel);
            }
            if (iNetElement == null) continue;
            for (NetCircuit netCircuit : this.getSvlanCircuits(iNodeModel)) {
                if (!netCircuit.doesCircuitUseConn(iNetElement, iConnectionModel)) continue;
                hashSet.add((SvlanCircuit)netCircuit);
                continue block0;
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLAPCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.lapCktList.values());
            linkedList.addAll(this.nullIdLapCktList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMemberCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.vcatMemCktList.values());
            linkedList.addAll(this.nullIdVcatMemCktList);
        }
        return linkedList;
    }

    public INetCircuit getCircuitFromCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.getNetLinkFromEndpoint(iNetCircuitEnd, false);
        for (NetCircuit netCircuit : this.getCircuits()) {
            Iterator iterator = netCircuit.getCktSources().iterator();
            for (int i = 0; i < 2; ++i) {
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                    if (!netCircuitEnd.equals(iNetCircuitEnd)) continue;
                    return netCircuit;
                }
                iterator = netCircuit.getDropCktEnds().iterator();
            }
            NetCircuitNode netCircuitNode2 = null;
            List list = netCircuit.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
            if (list == null) continue;
            for (NetCircuitNode netCircuitNode2 : list) {
                if (netCircuitNode2 == null || iNetLink == null) continue;
                if (netCircuitNode2.getSpliceListener(iNetCircuitEnd, false) != null) {
                    return netCircuit;
                }
                if (!NetCircuitRollOperator.isRollToCktEnd(netCircuitNode2, (NetCircuitEnd)iNetCircuitEnd)) continue;
                return netCircuit;
            }
        }
        return null;
    }

    @Override
    public List getCircuits(INodeModel iNodeModel) {
        List list = new LinkedList();
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            list = this.getCircuits();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                if (netCircuit.usesNetElement(iNetElement)) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public List getCircuits(INodeModel iNodeModel, int n) {
        NetCircuit netCircuit2 = null;
        INetElement iNetElement = null;
        List list = this.getCircuits(iNodeModel);
        ArrayList<NetCircuit> arrayList = new ArrayList<NetCircuit>();
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        for (NetCircuit netCircuit2 : list) {
            List list2 = netCircuit2.getCircuitNodeFromNE(iNetElement);
            if (list2 == null) continue;
            INetCircuitNode iNetCircuitNode2 = null;
            block3: for (INetCircuitNode iNetCircuitNode2 : list2) {
                List list3 = iNetCircuitNode2.getPathList();
                for (IPathDefModel iPathDefModel : list3) {
                    try {
                        IEntityModel iEntityModel;
                        IOchccPathDefModel iOchccPathDefModel;
                        if (iPathDefModel instanceof IOchccPathDefModel) {
                            iOchccPathDefModel = (IOchccPathDefModel)iPathDefModel;
                            if (!iOchccPathDefModel.getNodeModel().equals(iNodeModel) || (iEntityModel = iOchccPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPortEntityIdx())).getShelfId() != n) continue;
                            arrayList.add(netCircuit2);
                            continue block3;
                        }
                        if (iPathDefModel instanceof IOchncPathDefModel) {
                            iOchccPathDefModel = (IOchncPathDefModel)iPathDefModel;
                            if (!iOchccPathDefModel.getNodeModel().equals(iNodeModel) || (iEntityModel = iOchccPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPortEntityIdx())).getShelfId() != n) continue;
                            arrayList.add(netCircuit2);
                            continue block3;
                        }
                        if (!(iPathDefModel instanceof IHoPathDefModel) || !(iOchccPathDefModel = (IHoPathDefModel)iPathDefModel).getNodeModel().equals(iNodeModel) || (iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPool().getEntityIndex())).getShelfId() != n) continue;
                        arrayList.add(netCircuit2);
                        continue block3;
                    }
                    catch (Exception exception) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        db.println("getCircuits path error: " + iPathDefModel);
                    }
                }
            }
        }
        return arrayList;
    }

    @Override
    public List getCircuits(List list) {
        INodeModel iNodeModel = null;
        IConnectionModel iConnectionModel = null;
        INetElement iNetElement = null;
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            iConnectionModel = null;
            iNodeModel = null;
            iNetElement = null;
            iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel != null) {
                iNodeModel = iConnectionModel.getNodeModel();
            }
            if (iNodeModel != null) {
                iNetElement = this.net.findNetElem(iNodeModel);
            }
            if (iNetElement == null) continue;
            for (NetCircuit netCircuit : this.getCircuits(iNodeModel)) {
                if (!netCircuit.doesCircuitUseConn(iNetElement, iConnectionModel)) continue;
                linkedList.add(netCircuit);
                if (!netCircuit.getCircuitTypeObj().isLAPCircuitType()) continue block0;
                linkedList.addAll(this.getCircuitsUseLAP(netCircuit));
                continue block0;
            }
        }
        return linkedList;
    }

    @Override
    public void provisionLoTunnels(List list) throws CircuitProvError, NoRoute, SanityCheckFailed, ConnTypeUnsupported, IncorrectCircuitState, DeletionError, AnnotatedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LoTunnelInfo loTunnelInfo2 = (LoTunnelInfo)iterator.next();
            INetCircuit iNetCircuit = loTunnelInfo2.tunnel();
            try {
                iNetCircuit.provision();
            }
            catch (CircuitProvError circuitProvError) {
                for (LoTunnelInfo loTunnelInfo2 : list) {
                    iNetCircuit = loTunnelInfo2.tunnel();
                    iNetCircuit.destroyCircuit();
                }
                throw circuitProvError;
            }
        }
    }

    protected INetCircuit[] generateTable() {
        return null;
    }

    @Override
    public List getCircuitSpans(INetLink iNetLink) {
        return this.getCircuitSpans(this.getCircuits(), iNetLink);
    }

    private List getCircuitSpans(List list, INetLink iNetLink) {
        LinkedList<INetCircuitSpan> linkedList = new LinkedList<INetCircuitSpan>();
        for (INetCircuit iNetCircuit : list) {
            if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                linkedList.addAll(this.getCircuitSpans(((NetVcatCircuit)iNetCircuit).getAllMemberCircuits(), iNetLink));
                continue;
            }
            INetCircuitSpan iNetCircuitSpan = iNetCircuit.getCircuitSpanFromNetLink(iNetLink);
            if (iNetCircuitSpan == null) continue;
            linkedList.add(iNetCircuitSpan);
        }
        return linkedList;
    }

    public List getCircuits(INetLink iNetLink) {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        for (INetCircuit iNetCircuit : this.getCircuits()) {
            if (!iNetCircuit.doesCircuitUseNetLink(iNetLink)) continue;
            linkedList.add(iNetCircuit);
        }
        return linkedList;
    }

    public List getCircuitsNotUsingLap(INetLink iNetLink) {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        for (INetCircuit iNetCircuit : this.getCircuits()) {
            LoCcatCircuit loCcatCircuit;
            if (iNetCircuit.getCircuitTypeObj().isLoCircuitType() && (loCcatCircuit = (LoCcatCircuit)iNetCircuit).useLAP() != null || !iNetCircuit.doesCircuitUseNetLink(iNetLink)) continue;
            linkedList.add(iNetCircuit);
        }
        return linkedList;
    }

    @Override
    public INetwork getNetwork() {
        return this.net;
    }

    public IHoLoNum getHoLoNumfromEntity(IEntityModel iEntityModel) {
        IHoLoNum iHoLoNum = null;
        List list = iEntityModel.getConnectionsList();
        IConnectionModel iConnectionModel = null;
        if (!list.isEmpty()) {
            iConnectionModel = (IConnectionModel)list.get(0);
            if (iConnectionModel instanceof IHoConnectionModel) {
                IHoPathDefModel[] iHoPathDefModelArray = ((IHoConnectionModel)iConnectionModel).getActivePaths();
                iHoLoNum = HoLoFactory.createHoLoNum(iHoPathDefModelArray[0].getStartingHo(), null);
            } else {
                ILoDefModel[] iLoDefModelArray = ((ILoConnectionModel)iConnectionModel).getActivePaths();
                iHoLoNum = HoLoFactory.createHoLoNum(iLoDefModelArray[0].getLoAdit().getHo().getStartingHo(), null);
            }
        }
        return iHoLoNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INetCircuit getCircuitFromId(ICircuitId iCircuitId) {
        if (NetCircuit.isNullCircuitId(iCircuitId)) {
            return null;
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            INetCircuit iNetCircuit = (INetCircuit)this.cktList.get(iCircuitId);
            if (iNetCircuit == null) {
                iNetCircuit = (INetCircuit)this.vcatMemCktList.get(iCircuitId);
            }
            return iNetCircuit;
        }
    }

    public INetCircuit getCircuitFromConn(INetElement iNetElement, Object object) {
        ICircuitId iCircuitId = NetCircuitNode.getConnCircuitId(object);
        if (!NetCircuit.isNullCircuitId(iCircuitId)) {
            return null;
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)TL1ObjectManager.instance().getTL1Object(iNetElement, object);
        if (netCircuitNode != null) {
            return netCircuitNode.getCircuit();
        }
        return null;
    }

    protected void insertPrepElement(INetLink iNetLink, INetElement iNetElement, int n, int n2) {
    }

    protected void notifyChanged(INetCircuit iNetCircuit) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("notifyChanged(ncMgr)");
        }
        this.setChanged();
        this.notifyObservers(iNetCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCircuitNameMap(ICircuitId iCircuitId, String string) {
        String string2;
        if (NetCircuit.isNullCircuitId(iCircuitId)) {
            return;
        }
        HashMap hashMap = this.circuitNameMap;
        synchronized (hashMap) {
            string2 = string == null ? (String)this.circuitNameMap.remove(new Long(iCircuitId.longValue())) : this.circuitNameMap.put(new Long(iCircuitId.longValue()), string);
        }
        if (string2 == null || string2 != null && !string2.equals(string)) {
            this.watchDog.queueCircuitNameMapUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setNodeCircuitNameMap(INodeModel iNodeModel) {
        HashMap hashMap;
        HashMap hashMap2 = this.circuitNameMap;
        synchronized (hashMap2) {
            hashMap = new HashMap(this.circuitNameMap);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("setNodeCircuitNameMap(" + iNodeModel.getName() + "): numCkts=" + this.circuitNameMap.size());
        }
        try {
            IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
            if (iConnectionModels != null) {
                iConnectionModels.setCircuitNameMap(hashMap);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("IO Exception in setNodeCircuitNameMap " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
        return true;
    }

    @Override
    public int addNodeToNetwork(INetElement iNetElement, Observer observer) throws InvalidArgument, MissingLinks, AnnotatedException {
        if (iNetElement == null) {
            throw new InvalidArgument("The network element is invalid.");
        }
        NetCircuitHealOperator netCircuitHealOperator = new NetCircuitHealOperator();
        int n = netCircuitHealOperator.addNeToRing(iNetElement, observer);
        this.wavelengthsOfCktNotFixed = netCircuitHealOperator.getWavelengthNotFixed();
        return n;
    }

    @Override
    public int addNodeToNetwork(INetElement iNetElement) throws InvalidArgument, MissingLinks, AnnotatedException {
        return this.addNodeToNetwork(iNetElement, null);
    }

    private String makePortString(IPortModel iPortModel) {
        return iPortModel.getNodeModel().getName() + ", Slot " + iPortModel.getSlot() + ", Port " + PortHelper.getPortNumString((IPortModel)iPortModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCircuitDeleteJobGroup(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: delete JobGroup finished");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        HashSet hashSet = new HashSet();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        if (jobGroup == this.deleteJobGroup) {
            Object object;
            IPortModel iPortModel2;
            HashMap<IPortModel, String> hashMap22;
            try {
                try {
                    JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                    for (int i = 0; i < jobStatusArray.length; ++i) {
                        hashMap22 = jobStatusArray[i].getResult();
                        if (jobStatusArray[i].value() == 2) {
                            Iterator<Object> iterator;
                            if (hashMap22 == null) {
                                db.fine("DEL: Unexplained Circuit deletion error");
                                ++n3;
                                continue;
                            }
                            if (hashMap22 instanceof DeletionError) {
                                db.fine("DEL: Circuit deletion error");
                                ++n3;
                                iterator = (DeletionError)((Object)hashMap22);
                                string = string + ((Throwable)((Object)iterator)).getMessage();
                                continue;
                            }
                            if (hashMap22 instanceof DeletionWarning) {
                                db.fine("DEL: Circuit deletion warning");
                                ++n;
                                iterator = (DeletionWarning)((Object)hashMap22);
                                String object22 = ((Throwable)((Object)iterator)).getMessage();
                                if (object22.length() > 0) {
                                    stringBuffer.append(((Throwable)((Object)iterator)).getMessage()).append("\n");
                                }
                                hashSet.addAll(((DeletionWarning)((Object)iterator)).getPortSuccesses());
                                arrayList.add(((DeletionWarning)((Object)iterator)).getPortFailures());
                                continue;
                            }
                            db.severe("handleCircuitDeleteJobGroup(): unexpected resultObj " + hashMap22);
                            if (!(hashMap22 instanceof Exception)) continue;
                            SDebug.printStackTrace((Throwable)((Exception)((Object)hashMap22)));
                            continue;
                        }
                        db.fine("DEL: Circuit deletion full success");
                        ++n;
                        if (hashMap22 instanceof Set) {
                            hashSet.addAll((Set)((Object)hashMap22));
                        } else {
                            db.severe("Unexpected result object: " + hashMap22);
                        }
                        if (jobStatusArray[i].value() == 4) continue;
                        db.severe("handleCircuitDeleteJobGroup(): unexpected status");
                    }
                    iPortModel2 = null;
                    this.deleteJobGroup = null;
                }
                catch (Exception exception) {
                    db.severe("handleCircuitDeleteJobGroup(): ");
                    SDebug.printStackTrace((Throwable)exception);
                    iPortModel2 = null;
                    this.deleteJobGroup = null;
                }
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                this.deleteJobGroup = null;
                throw throwable;
            }
            int n4 = hashSet.size();
            for (HashMap<IPortModel, String> hashMap22 : hashSet) {
                db.info("Success: " + this.makePortString((IPortModel)hashMap22));
                for (Map map : arrayList) {
                    map.remove(hashMap22);
                }
            }
            hashMap22 = new HashMap<IPortModel, String>();
            for (Map map : arrayList) {
                for (IPortModel iPortModel2 : map.keySet()) {
                    String string2 = (String)map.get(iPortModel2);
                    String string3 = (String)hashMap22.get(iPortModel2);
                    if (string3 == null) {
                        hashMap22.put(iPortModel2, string2);
                        continue;
                    }
                    if (string3.indexOf(string2) >= 0) continue;
                    hashMap22.put(iPortModel2, string3 + ";\n" + string2);
                }
            }
            n2 = hashMap22.size();
            for (IPortModel iPortModel3 : hashMap22.keySet()) {
                object = this.makePortString(iPortModel3);
                stringBuffer2.append((String)object).append(": ").append(hashMap22.get(iPortModel3)).append("\n\n");
            }
            db.info("Circuit failures " + n3 + "; circuit successes " + n + "; port warnings " + n2);
            String string4 = NetAdminState.getAdminStateStringFromAdminState(this.targetUnusedPortsState);
            string = string + (n3 > 0 ? n3 + " " + PluralisationUtil.s("circuit", n3) + " " + PluralisationUtil.s("was", n3) + " not deleted.\n" : "") + (n > 0 ? n + " " + PluralisationUtil.s("circuit", n) + " " + PluralisationUtil.s("was", n) + " successfully deleted.\n" : "") + (n2 > 0 ? "\nCircuit state " + string4 + " cannot be applied to " + n2 + " " + PluralisationUtil.s("port", n2) + ".\n\n" + stringBuffer2.toString() + "\n" : "") + (stringBuffer.length() > 0 ? stringBuffer.toString() + "\n" : "");
            object = new JobStatus(4);
            if (n3 > 0) {
                object.setResult((Object)new DeletionError(string));
            } else if (n2 > 0) {
                object.setResult((Object)new DeletionWarning(string, string4, hashSet, hashMap22));
            } else {
                object.setResult((Object)string);
            }
            iPortModel2 = (IAsyncObserver)jobGroup.getUserObject();
            if (iPortModel2 != null) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("Circuit Deletion results displayed by " + iPortModel2.getClass().getName());
                }
                iPortModel2.asyncUpdate(null, (JobStatus)object);
            }
            db.info("DEL: End Circuit Deletion Job Group");
        }
    }

    @Override
    public int addNodeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4, Observer observer) throws InvalidArgument, MissingLinks, AnnotatedException {
        if (iNetElement == null || iEntityModel == null || iEntityModel2 == null || iNetElement2 == null || iEntityModel3 == null || iNetElement3 == null || iEntityModel4 == null) {
            throw new InvalidArgument("The network element or entity model is invalid.");
        }
        NetCircuitHealOperator netCircuitHealOperator = new NetCircuitHealOperator();
        return netCircuitHealOperator.addNeToOnePlusOne(iNetElement, iEntityModel, iEntityModel2, iNetElement2, iEntityModel3, iNetElement3, iEntityModel4, observer);
    }

    @Override
    public int addNodeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4) throws InvalidArgument, MissingLinks, AnnotatedException {
        return this.addNodeToOnePlusOne(iNetElement, iEntityModel, iEntityModel2, iNetElement2, iEntityModel3, iNetElement3, iEntityModel4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProvAdminStateJobGroup(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("provAdminState JobGroup finished");
        }
        try {
            block6: {
                try {
                    String string = "provisioning admin state completed\n";
                    JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                    for (int i = 0; i < jobStatusArray.length; ++i) {
                        if (jobStatusArray[i].value() != 2) continue;
                        string = "Provisioning admin state failed\n";
                        AdminStateProvisioningError adminStateProvisioningError = (AdminStateProvisioningError)jobStatusArray[i].getResult();
                        if (adminStateProvisioningError == null) continue;
                        string = string + adminStateProvisioningError.toString();
                    }
                    JobStatus jobStatus = new JobStatus(4);
                    jobStatus.setResult((Object)string);
                    IAsyncObserver iAsyncObserver = (IAsyncObserver)jobGroup.getUserObject();
                    if (iAsyncObserver == null) break block6;
                    iAsyncObserver.asyncUpdate(null, jobStatus);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    Object var8_10 = null;
                    this.provAdminStateJobGroup = null;
                }
            }
            Object var8_9 = null;
            this.provAdminStateJobGroup = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.provAdminStateJobGroup = null;
            throw throwable;
        }
    }

    public void jobGroupFinished(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: delete JobGroup finished");
        }
        if (jobGroup == this.deleteJobGroup) {
            this.handleCircuitDeleteJobGroup(jobGroup);
        } else if (jobGroup == this.provAdminStateJobGroup) {
            this.handleProvAdminStateJobGroup(jobGroup);
        } else {
            db.info("Unknown type of job group finished");
        }
    }

    public List getEndpointsUseLink(INetLink iNetLink) {
        LinkedList linkedList = new LinkedList();
        for (NetCircuit netCircuit : this.getCircuits()) {
            List list = netCircuit.getLinkEndpoints(iNetLink);
            if (list.isEmpty()) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    protected INetLink getNetLinkFromEndpoint(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        INetLink iNetLink = null;
        if (iNetCircuitEnd != null) {
            iNetLink = this.net.findNetLinkFromSource(bl, iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        }
        return iNetLink;
    }

    public void performProtectionOp(INetCircuitSpan[] iNetCircuitSpanArray, int n, String string, IAsyncObserver iAsyncObserver) throws ProtectionSwitchError {
        if (NetCircuitManager.dbgOn()) {
            db.println("performProtectionOp: No of spans = " + iNetCircuitSpanArray.length);
            db.println("performProtectionOp: Operation = " + n);
        }
        ProtectionSwitchRun protectionSwitchRun = new ProtectionSwitchRun(iNetCircuitSpanArray, n, string, iAsyncObserver);
        if (this.protectionSwitchThread != null) {
            throw new ProtectionSwitchError("Another protection switch request is already in progress.\nPlease wait until that request completes.");
        }
        this.protectionSwitchThread = new Thread(protectionSwitchRun);
        this.protectionSwitchThread.start();
    }

    private List getLAPHoNode(INodeModel iNodeModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        for (NetCircuit netCircuit : this.getLAPCircuits()) {
            NetCircuitEnd netCircuitEnd;
            if (netCircuit.getState() != 1 && netCircuit.getState() != 5 || (netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0)).getNodeModel().getDelegate() != iNodeModel.getDelegate()) continue;
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    public List getLAPHoEntity(INodeModel iNodeModel, IEntityModel iEntityModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        for (NetCircuit netCircuit : this.getLAPHoNode(iNodeModel)) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0);
            try {
                if (netCircuitEnd.getEntityModel() != iEntityModel) continue;
                linkedList.add(netCircuit);
            }
            catch (ObjNotFound objNotFound) {
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("getLAP hits exception " + netCircuit.getCircuitName());
            }
        }
        return linkedList;
    }

    public INetCircuit getLAPHo(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        for (NetCircuit netCircuit : this.getLAPHoEntity(iNodeModel, iEntityModel)) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0);
            if (!holoComp.isEqual(netCircuitEnd.getHoNum(), iHoNum)) continue;
            return netCircuit;
        }
        return null;
    }

    private List getLAPLoGrooming(INodeModel iNodeModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        for (NetCircuit netCircuit : this.getLAPCircuits()) {
            if (netCircuit.getState() != 1 && netCircuit.getState() != 5) continue;
            for (NetCircuitDropInfo netCircuitDropInfo : netCircuit.getCktDrops()) {
                if (netCircuitDropInfo.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
                linkedList.add(netCircuit);
            }
        }
        return linkedList;
    }

    public NetCcatCircuit getLAPLoGrooming(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        for (HoCcatCircuit hoCcatCircuit : this.getLAPLoGrooming(iNodeModel)) {
            for (NetCircuitNode netCircuitNode : hoCcatCircuit.getLoTunnelNodes()) {
                if (netCircuitNode.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
                if (!netCircuitNode.hasDualConnections()) {
                    try {
                        if (netCircuitNode.getTunnelEntityIndex() != iEntityModel.getEntityIndex() || !holoComp.isEqual(netCircuitNode.getLotHo(), iHoNum)) continue;
                        return hoCcatCircuit;
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        NetCircuitManager.debug("getLAPLoGrooming hits exception " + hoCcatCircuit.getCircuitName());
                        continue;
                    }
                }
                for (LoTunnelNode loTunnelNode : ((DualConnectionCircuitNode)netCircuitNode).getAggregationNodes()) {
                    try {
                        if (loTunnelNode.getTunnelEntityIndex() != iEntityModel.getEntityIndex() || !holoComp.isEqual(loTunnelNode.getLotHo(), iHoNum)) continue;
                        return hoCcatCircuit;
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        NetCircuitManager.debug("getLAPLoGrooming hits exception " + hoCcatCircuit.getCircuitName());
                    }
                }
            }
        }
        return null;
    }

    public boolean capableOfLAPHoConnection(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        if (iNodeModel == null || iEntityModel == null || iHoNum == null) {
            return false;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("capableOfLAPHoConnection called on node " + iNodeModel.getName() + " entity index " + iEntityModel.getEntityIndex() + " hoNum " + iHoNum.getHoNum());
        }
        if (!iNodeModel.provides(Feature.VT_GROOMING)) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("capableOfLAPHoConnection: node doesn't support VT_GROOMING, returns false");
            }
            return false;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        LinkedList linkedList2 = new LinkedList();
        linkedList.add(iEntityModel);
        iEntityTableModel.lapFilterEntities(linkedList, linkedList2);
        if (linkedList2.isEmpty()) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("capableOfLAPHoConnection: filteredEntities is empty, returns false");
            }
            return false;
        }
        int n = iHoNum.getFramingType();
        ICircuitSize iCircuitSize = CircuitSize.getLoAggSize((int)n);
        short s = iCircuitSize.size2widthOfHoCircuit();
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        for (IPoolModel iPoolModel : Arrays.asList(iPoolModelArray)) {
            IPathInfo[] iPathInfoArray = iPoolModel.getAvailablePaths(s);
            for (int i = 0; i < iPathInfoArray.length; ++i) {
                IHoNum iHoNum2 = Feature.provides((INodeModel)iPoolModel.getNodeModel(), (Feature)Feature.SDH_AU3) ? iPathInfoArray[i].getStartingHo(n) : iPathInfoArray[i].getStartingHo();
                IHoNum iHoNum3 = HoPathDefModel.physicalHo(iPoolModel, iHoNum2);
                if (!holoComp.isEqual(iHoNum3, iHoNum)) continue;
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("capableOfLAPHoConnection returns true");
                }
                return true;
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("capableOfLAPHoConnection returns false");
        }
        return false;
    }

    public List getCircuitsUseLAP(INetCircuit iNetCircuit) {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        for (INetCircuit iNetCircuit2 : this.getCircuits()) {
            INetCircuit iNetCircuit3;
            if (!iNetCircuit2.getCircuitTypeObj().isLoCircuitType() || (iNetCircuit3 = iNetCircuit2.useLAP()) == null || iNetCircuit3 != iNetCircuit) continue;
            linkedList.add(iNetCircuit2);
        }
        return linkedList;
    }

    public boolean canAddToNodeList(INodeModel iNodeModel, INetCircuit iNetCircuit, ICircuitType iCircuitType) {
        return iCircuitType.isLoCircuitType() && (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit == null || this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit.useLAP() == null && iNetCircuit.getState() == 0);
    }

    public boolean canAddToNodeList(INodeModel iNodeModel, INetCircuit iNetCircuit, CircuitCreatInfo circuitCreatInfo) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("canAddToNodeList on node " + iNodeModel.getName());
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        INetCircuit iNetCircuit2 = null;
        INetElement iNetElement = this.net.getNetElem(iNodeModel.getNodeId());
        if (iNetElement == null) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("ERROR: canAddToNodeList: Can't find ne");
            }
            return false;
        }
        if (iCircuitType.isLoCircuitType()) {
            if (iNetElement.canSupportCircuitSize(circuitCreatInfo.type(), circuitCreatInfo.size()) && iNetElement.loXCon()) {
                if (iNetCircuit == null) {
                    if (!circuitCreatInfo.isDiag()) {
                        return true;
                    }
                    if (iNodeModel.provides(Feature.DIAGNOSTIC_CONNECTION) && iNodeModel.provides(Feature.XCVXC) && iNodeModel.getConnectionModels().diagGeneratorAvailable()) {
                        return true;
                    }
                } else {
                    iNetCircuit2 = iNetCircuit.useLAP();
                    if (iNetCircuit2 == null) {
                        return true;
                    }
                    if (iNetCircuit2.getSrcCircuitNode().getNodeModel().getNodeId() != iNodeModel.getNodeId()) {
                        return true;
                    }
                }
            } else {
                if (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit == null) {
                    return true;
                }
                if (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit.useLAP() == null && iNetCircuit.getState() == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public INetCircuitSpan getLAPSpan(INetCircuit iNetCircuit) {
        INetLink iNetLink = null;
        NetLinkSpan netLinkSpan = null;
        NetCircuitSpan netCircuitSpan = null;
        if (iNetCircuit.getState() != 0 && iNetCircuit.getState() != 3) {
            return netCircuitSpan;
        }
        if (!(iNetCircuit instanceof LoCcatCircuit)) {
            return netCircuitSpan;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        NetCcatCircuit netCcatCircuit = ((LoCcatCircuit)iNetCircuit).useLAPOnSource();
        if (netCcatCircuit != null) {
            for (NetCircuitEnd netCircuitEnd : iNetCircuit.getSources()) {
                try {
                    if (NetCircuitManager.instance().getLAPHo(netCircuitEnd.getNodeModel(), netCircuitEnd.getEntityModel(), netCircuitEnd.getHoNum()) == null) continue;
                    iNetLink = netCcatCircuit.getLapLink();
                    netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), netCircuitEnd.getLoNum());
                    List list = netCcatCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
                    if (list != null) {
                        if (list.size() > 1) {
                            if (NetCircuitManager.dbgOn()) {
                                db.println("Error !! This LAP has MXPN");
                            }
                        } else {
                            netCircuitNode = (NetCircuitNode)list.get(0);
                        }
                    }
                    if ((list = netCcatCircuit.getCircuitNodeFromNE(iNetLink.getDst())) == null) continue;
                    if (list.size() > 1) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        db.println("Error !! This LAP has MXPN");
                        continue;
                    }
                    netCircuitNode2 = (NetCircuitNode)list.get(0);
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        } else {
            netCcatCircuit = ((LoCcatCircuit)iNetCircuit).useLAPOnDrop();
            if (netCcatCircuit != null) {
                Iterator iterator = iNetCircuit.getDrops().iterator();
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                    try {
                        if (NetCircuitManager.instance().getLAPHo(netCircuitEnd.getNodeModel(), netCircuitEnd.getEntityModel(), netCircuitEnd.getHoNum()) == null) continue;
                        iNetLink = netCcatCircuit.getReverseLapLink();
                        netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), netCircuitEnd.getLoNum());
                        List list = netCcatCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
                        if (list != null) {
                            if (list.size() > 1) {
                                if (NetCircuitManager.dbgOn()) {
                                    db.println("Error !! This LAP has MXPN");
                                }
                            } else {
                                netCircuitNode = (NetCircuitNode)list.get(0);
                            }
                        }
                        if ((list = netCcatCircuit.getCircuitNodeFromNE(iNetLink.getDst())) == null) continue;
                        if (list.size() > 1) {
                            if (!NetCircuitManager.dbgOn()) continue;
                            db.println("Error !! This LAP has MXPN");
                            continue;
                        }
                        netCircuitNode2 = (NetCircuitNode)list.get(0);
                    }
                    catch (ObjNotFound objNotFound) {
                        SDebug.printStackTrace((Throwable)objNotFound);
                    }
                }
            }
        }
        if (netLinkSpan != null) {
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(iNetCircuit, netLinkSpan, netCircuitNode, netCircuitNode2);
        }
        return netCircuitSpan;
    }

    public boolean refreshCircuit(NetCcatCircuit netCcatCircuit) {
        Object object;
        if (NetCircuitManager.dbgOn()) {
            db.println("refreshCircuit ... " + netCcatCircuit.getCircuitName());
        }
        if (!netCcatCircuit.hasNullCircuitId()) {
            if (NetCircuitManager.dbgOn()) {
                db.println("refreshCircuit : not a pure TL1 circuit, returning!!");
            }
            return false;
        }
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        LinkedList<IVcatTermModel> linkedList2 = new LinkedList<IVcatTermModel>();
        boolean bl = netCcatCircuit.isMemberOfVcat();
        NetVcatGroup netVcatGroup = null;
        List list = null;
        if (bl) {
            if (NetCircuitManager.dbgOn()) {
                db.println("refreshCircuit : Member of VCAT, additional processing.");
            }
            netVcatGroup = netCcatCircuit.getVcatGroup();
            object = netVcatGroup.getAllVcatTerms().iterator();
            while (object.hasNext()) {
                linkedList2.add(((NetVcatTermination)object.next()).getVcatTerm());
            }
            list = netVcatGroup.getAllMemberCircuits();
            object = list.iterator();
            while (object.hasNext()) {
                this.getAllConnsFromNetCircuit((NetCcatCircuit)object.next(), linkedList);
            }
        } else {
            this.getAllConnsFromNetCircuit(netCcatCircuit, linkedList);
        }
        if (bl) {
            for (NetCcatCircuit netCcatCircuit2 : list) {
                netCcatCircuit2.dispose();
                netCcatCircuit2.finalDispose();
                netCcatCircuit2.notifyDeleted();
            }
            netVcatGroup.getNetVcatCircuit().dispose();
            netVcatGroup.getNetVcatCircuit().finalDispose();
            netVcatGroup.getNetVcatCircuit().notifyDeleted();
            if (NetCircuitManager.dbgOn()) {
                db.println("refreshCircuit : disposed all vcat objects.");
            }
        } else {
            netCcatCircuit.dispose();
            netCcatCircuit.finalDispose();
            netCcatCircuit.notifyDeleted(false);
            if (NetCircuitManager.dbgOn()) {
                db.println("refreshCircuit : disposed the ccat object.");
            }
        }
        NetCircuitSplicer.instance().synchronizeSpliceListeners();
        object = NetCircuitWatchDog.instance();
        ((NetCircuitWatchDog)object).discoverCircuitFromConnectionList(linkedList);
        ((NetCircuitWatchDog)object).discoverVCATFromTermList(linkedList2);
        if (NetCircuitManager.dbgOn()) {
            db.println("refresh : successful.");
        }
        linkedList.clear();
        linkedList2.clear();
        return true;
    }

    private void getAllConnsFromNetCircuit(NetCcatCircuit netCcatCircuit, List<IConnectionModel> list) {
        if (NetCircuitManager.dbgOn()) {
            db.println("refreshCircuit : getAllConnsFromNetCircuit");
        }
        for (NetCircuitNode netCircuitNode : netCcatCircuit.getCircuitNodes()) {
            if (netCircuitNode instanceof DualConnectionCircuitNode) {
                list.add(((DualConnectionCircuitNode)netCircuitNode).getConn());
                list.add(((DualConnectionCircuitNode)netCircuitNode).getSecConn());
                continue;
            }
            list.add(netCircuitNode.getConn());
        }
    }

    public int calcFramingType(int n, int n2) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitSize.isSonetTerminationSize()) {
            return 0;
        }
        if (iCircuitType.isHoCircuitType() && iCircuitSize.getEnum() == 11) {
            return 2;
        }
        return 1;
    }

    public IHoLoNum[] getSourceAutoSelectVcatPaths(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) throws ProvisionError {
        return Endpoints.instance().getSourceAutoSelectVcatPaths(iNodeModel, iEntityModel, circuitCreatInfo);
    }

    public IPathStateInfo[] getAllPathStateInfo(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) throws ProvisionError {
        return Endpoints.instance().getAllPathStateInfo(iNodeModel, iEntityModel, circuitCreatInfo.type(), circuitCreatInfo.size());
    }

    protected static boolean pkgDbgOn() {
        return pkgDb.on();
    }

    protected static void suppressPkgDbg() {
        pkgDbgSuppressed = true;
    }

    protected static void permitPkgDbg() {
        pkgDbgSuppressed = false;
    }

    protected static boolean pkgDbgSuppressed() {
        return pkgDbgSuppressed;
    }

    protected static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected static void debug(String string) {
        db.println(string);
    }

    protected static void debug(Exception exception) {
        SDebug.printStackTrace((Throwable)exception);
    }

    public ArrayList<String> getWavelengthsOfCktNotFixed() {
        return this.wavelengthsOfCktNotFixed;
    }

    class ProtectionSwitchRun
    implements Runnable,
    IJobGroupListener {
        private INetCircuitSpan[] spansToSwitch;
        private int op;
        private String opStr;
        private IAsyncObserver actionObserver;
        private String errorMessage = null;
        private LinkedList invalidCircuitList;

        public ProtectionSwitchRun(INetCircuitSpan[] iNetCircuitSpanArray, int n, String string, IAsyncObserver iAsyncObserver) {
            this.spansToSwitch = new INetCircuitSpan[iNetCircuitSpanArray.length];
            System.arraycopy(iNetCircuitSpanArray, 0, this.spansToSwitch, 0, iNetCircuitSpanArray.length);
            this.op = n;
            this.opStr = string;
            this.actionObserver = iAsyncObserver;
            this.invalidCircuitList = new LinkedList();
        }

        public void run() {
            if (NetCircuitManager.dbgOn()) {
                db.println("ProtectionSwitchRun thread started");
            }
            try {
                this.executeProtectionSwitch();
            }
            catch (ProtectionSwitchError protectionSwitchError) {
                this.errorMessage = protectionSwitchError.getMessage();
                this.jobGroupFinished(NetCircuitManager.this.protectionSwitchJobGroup);
            }
            catch (Exception exception) {
                this.errorMessage = exception.getMessage();
                this.jobGroupFinished(NetCircuitManager.this.protectionSwitchJobGroup);
                db.println("Unknown Exception caught in ProtectionSwitchRun thread");
                SDebug.printStackTrace((Throwable)exception);
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("ProtectionSwitchRun thread completed");
            }
        }

        private void interleavedSort(ProtectionSwitchHelper[] protectionSwitchHelperArray) throws ProtectionSwitchError {
            int n;
            if (protectionSwitchHelperArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("interleavedSort: called with 0 items, returning");
                }
                throw new ProtectionSwitchError("An error occurred during a protection switch.");
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("interleavedSort called containing " + protectionSwitchHelperArray.length + " items");
                db.println("BEFORE: ");
                for (n = 0; n < protectionSwitchHelperArray.length; ++n) {
                    db.println(protectionSwitchHelperArray[n].getNode().getName());
                }
            }
            n = protectionSwitchHelperArray.length;
            Arrays.sort(protectionSwitchHelperArray);
            LinkedList<ProtectionSwitchHelper> linkedList = new LinkedList<ProtectionSwitchHelper>(Arrays.asList(protectionSwitchHelperArray));
            int n2 = 0;
            ProtectionSwitchHelper[] protectionSwitchHelperArray2 = new ProtectionSwitchHelper[n];
            protectionSwitchHelperArray2[n2] = linkedList.removeFirst();
            while (!linkedList.isEmpty()) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    ProtectionSwitchHelper protectionSwitchHelper = (ProtectionSwitchHelper)iterator.next();
                    String string = protectionSwitchHelper.getNode().getName();
                    String string2 = protectionSwitchHelperArray2[n2].getNode().getName();
                    if (string2.compareTo(string) >= 0) continue;
                    protectionSwitchHelperArray2[++n2] = protectionSwitchHelper;
                    iterator.remove();
                }
                if (linkedList.isEmpty()) continue;
                protectionSwitchHelperArray2[++n2] = linkedList.removeFirst();
            }
            System.arraycopy(protectionSwitchHelperArray2, 0, protectionSwitchHelperArray, 0, protectionSwitchHelperArray2.length);
            if (NetCircuitManager.dbgOn()) {
                db.println("\nAFTER: ");
                for (int i = 0; i < protectionSwitchHelperArray.length; ++i) {
                    db.println(protectionSwitchHelperArray[i].getNode().getName());
                }
            }
        }

        private void executeProtectionSwitch() throws ProtectionSwitchError {
            Object object;
            LinkedList linkedList = new LinkedList();
            if (NetCircuitManager.this.protectionSwitchJobGroup != null) {
                throw new ProtectionSwitchError("Another protection switch request already in progress.\nPlease wait until that request completes.");
            }
            if (NetCircuitManager.this.protectionSwitchJobController == null) {
                NetCircuitManager.this.protectionSwitchJobController = JobControllerFactory.createJC((int)5);
            }
            if (NetCircuitManager.this.protectionSwitchJobController == null) {
                throw new ProtectionSwitchError("Protection switching jobs cannot be created.");
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("executeProtSwtch: spansToSwitch loop" + this.spansToSwitch.length);
            }
            for (int i = 0; i < this.spansToSwitch.length; ++i) {
                INetCircuit iNetCircuit;
                Object object2;
                try {
                    INetElement iNetElement = this.spansToSwitch[i].getLink().getSrc();
                    object = this.spansToSwitch[i].findSelectorNodeForNe(iNetElement, this.op);
                    linkedList.addAll(object);
                    object2 = this.spansToSwitch[i].getLink().getDst();
                    object = this.spansToSwitch[i].findSelectorNodeForNe((INetElement)object2, this.op);
                    linkedList.addAll(object);
                    continue;
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    iNetCircuit = this.spansToSwitch[i].getCircuit();
                    object2 = iNetCircuit.getCircuitName() + " (" + incorrectCircuitState.getMessage() + ")\n";
                    this.invalidCircuitList.add(object2);
                    if (!NetCircuitManager.dbgOn()) continue;
                    db.println("executeProtectionSwitch: caught IncorrectCircuitState exception: " + incorrectCircuitState.getMessage());
                    continue;
                }
                catch (ConnectionPathNotFound connectionPathNotFound) {
                    iNetCircuit = this.spansToSwitch[i].getCircuit();
                    object2 = iNetCircuit.getCircuitName() + " (" + connectionPathNotFound.getMessage() + ")\n";
                    this.invalidCircuitList.add(object2);
                    if (!NetCircuitManager.dbgOn()) continue;
                    db.println("executeProtectionSwitch: caught ConnectionPathNotFound exception: " + connectionPathNotFound.getMessage());
                }
            }
            ProtectionSwitchHelper[] protectionSwitchHelperArray = linkedList.toArray(new ProtectionSwitchHelper[0]);
            this.interleavedSort(protectionSwitchHelperArray);
            object = new IJobControl[protectionSwitchHelperArray.length];
            if (NetCircuitManager.dbgOn()) {
                db.println("executeProtSwtch: protSwitchHelpers loop" + protectionSwitchHelperArray.length);
            }
            for (int i = 0; i < protectionSwitchHelperArray.length; ++i) {
                object[i] = new NetCircuitProtectionSwitchWorker(protectionSwitchHelperArray[i]);
            }
            NetCircuitManager.this.protectionSwitchJobGroup = new JobGroup(object, (IJobGroupListener)this, (Object)this.actionObserver);
            NetCircuitManager.this.protectionSwitchJobController.submitJob(NetCircuitManager.this.protectionSwitchJobGroup);
        }

        public void jobGroupFinished(JobGroup jobGroup) {
            JobStatus jobStatus = new JobStatus(4);
            if (jobGroup == NetCircuitManager.this.protectionSwitchJobGroup) {
                if (this.errorMessage != null) {
                    String string = "The " + this.opStr + " request could not be performed because:\n";
                    string = string + this.errorMessage;
                    if (this.invalidCircuitList.size() > 0) {
                        string = string + "\n";
                        Iterator iterator = this.invalidCircuitList.iterator();
                        while (iterator.hasNext()) {
                            string = string + (String)iterator.next();
                        }
                    }
                    jobStatus.setResult((Object)string);
                    this.actionObserver.asyncUpdate((Object)("Protection Switch operation " + this.opStr + " failed"), jobStatus);
                } else {
                    Object object;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Protection Switch JobGroup finished");
                    }
                    String string = "";
                    NetCircuitNode netCircuitNode = null;
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    IJobControl[] iJobControlArray = jobGroup.getJobList();
                    JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                    if (iJobControlArray != null || jobStatusArray != null) {
                        object = new LinkedList();
                        for (int i = 0; i < jobStatusArray.length; ++i) {
                            ProtectionSwitchError protectionSwitchError;
                            NetCircuitProtectionSwitchWorker netCircuitProtectionSwitchWorker = (NetCircuitProtectionSwitchWorker)iJobControlArray[i];
                            netCircuitNode = netCircuitProtectionSwitchWorker.getNode();
                            string2 = netCircuitNode.getCircuit().getCircuitName();
                            if (((LinkedList)object).contains(string2)) continue;
                            boolean bl = false;
                            boolean bl2 = false;
                            String string6 = "        ";
                            if (jobStatusArray[i].value() == 2) {
                                if (NetCircuitManager.dbgOn()) {
                                    db.println("jobGroupFinished: Failed span switch for circuit: " + string2);
                                }
                                if ((protectionSwitchError = (ProtectionSwitchError)jobStatusArray[i].getResult()) != null) {
                                    string5 = string5 + string2 + ": \n";
                                    string5 = string5 + string6 + "at node " + netCircuitNode.getName() + "\n";
                                    bl2 = true;
                                }
                            } else {
                                if (NetCircuitManager.dbgOn()) {
                                    db.println("jobGroupFinished: Passed span switch for circuit: " + string2);
                                }
                                string4 = string4 + string2 + ": \n";
                                string4 = string4 + string6 + "at node " + netCircuitNode.getName() + "\n";
                                bl = true;
                            }
                            LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
                            linkedList.add(netCircuitNode);
                            for (int j = i; j < jobStatusArray.length; ++j) {
                                NetCircuitProtectionSwitchWorker netCircuitProtectionSwitchWorker2 = (NetCircuitProtectionSwitchWorker)iJobControlArray[j];
                                NetCircuitNode netCircuitNode2 = netCircuitProtectionSwitchWorker2.getNode();
                                String string7 = netCircuitNode2.getCircuit().getCircuitName();
                                if (!string2.equals(string7) || linkedList.contains(netCircuitNode2)) continue;
                                if (jobStatusArray[j].value() == 2) {
                                    if (NetCircuitManager.dbgOn()) {
                                        db.println("jobGroupFinished: Failed span switch for circuit: " + string2);
                                    }
                                    if ((protectionSwitchError = (ProtectionSwitchError)jobStatusArray[j].getResult()) != null) {
                                        if (!bl2) {
                                            bl2 = true;
                                            string5 = string5 + string2 + ": \n";
                                        }
                                        string5 = string5 + string6 + "at node " + netCircuitNode2.getName() + "\n";
                                    }
                                } else {
                                    if (NetCircuitManager.dbgOn()) {
                                        db.println("jobGroupFinished: Passed span switch for circuit: " + string2);
                                    }
                                    if (!bl) {
                                        bl = true;
                                        string4 = string4 + string2 + ": \n";
                                    }
                                    string4 = string4 + string6 + "at node " + netCircuitNode2.getName() + "\n";
                                }
                                linkedList.add(netCircuitNode2);
                            }
                            ((LinkedList)object).add(string2);
                        }
                    }
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Protection Switch completed");
                    }
                    if (!string4.equals("")) {
                        string = "The " + this.opStr + " request was successfully" + " applied to these circuits:\n";
                        string = string + string4 + "\n";
                        string3 = "The protection switch " + this.opStr + " request completed successfully with no errors.";
                    }
                    if (!string5.equals("")) {
                        string = string + "\nThe " + this.opStr + " request failed on " + "these circuits:\n";
                        string = string + string5;
                        string3 = "The protection switch " + this.opStr + " request completed with some errors.";
                    }
                    if (this.invalidCircuitList.size() > 0) {
                        string = string + "\n";
                        object = this.invalidCircuitList.iterator();
                        while (object.hasNext()) {
                            string = string + (String)object.next();
                        }
                    }
                    jobStatus.setResult((Object)string);
                    object = (IAsyncObserver)jobGroup.getUserObject();
                    if (object != null) {
                        object.asyncUpdate((Object)string3, jobStatus);
                    }
                    if (NetCircuitManager.dbgOn()) {
                        db.println("\n" + string3);
                        db.println((String)jobStatus.getResult());
                    }
                }
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("resetting protectionSwtichJobGroup to null");
                }
                NetCircuitManager.this.protectionSwitchJobGroup = null;
                NetCircuitManager.this.protectionSwitchThread = null;
            }
        }
    }

    public class CircuitIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ICircuitId iCircuitId = (ICircuitId)object;
            ICircuitId iCircuitId2 = (ICircuitId)object2;
            return ComparisonUtil.compare((long)iCircuitId.longValue(), (long)iCircuitId2.longValue());
        }
    }

    public class DumpDebug
    extends SDebug
    implements IDebugDiag {
        boolean circuitCounterEnabled;
        int circuitCounterSleepTime;
        CircuitCounterThread circuitCounterThread;

        public DumpDebug(String string) {
            super(string);
            this.circuitCounterEnabled = false;
            this.circuitCounterSleepTime = 10000;
            this.circuitCounterThread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                }
                if (!this.on()) {
                    this.set();
                }
                for (NetCircuit netCircuit : hashSet) {
                    netCircuit.prettyPrint(this);
                    this.println("==========================================================");
                }
            }
        }

        public final void dumpById(String string) {
            long l;
            if (!this.on()) {
                this.set();
            }
            try {
                l = Long.parseLong(string, 16);
            }
            catch (Exception exception) {
                this.println("Invalid Node ID " + string);
                return;
            }
            int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
            INetElement iNetElement = Network.instance().findNetElem(n);
            if (iNetElement == null) {
                this.println("No network element found with Node ID " + string);
                return;
            }
            for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits(iNetElement.getNodeModel())) {
                iNetCircuit.prettyPrint(this);
                this.println("==========================================================");
            }
        }

        public final void dumpByIp(String string) {
            INetElement iNetElement = Network.instance().findNetElemByIp(string);
            if (!this.on()) {
                this.set();
            }
            if (iNetElement == null) {
                this.println("No network element found with IP " + string);
                return;
            }
            for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits(iNetElement.getNodeModel())) {
                iNetCircuit.prettyPrint(this);
                this.println("==========================================================");
            }
        }

        private boolean refreshCircuit(NetCcatCircuit netCcatCircuit) {
            Object object;
            if (NetCircuitManager.dbgOn()) {
                db.println("refreshCircuit ... " + netCcatCircuit.getCircuitName());
            }
            LinkedList linkedList = new LinkedList();
            LinkedList<IVcatTermModel> linkedList2 = new LinkedList<IVcatTermModel>();
            boolean bl = netCcatCircuit.isMemberOfVcat();
            NetVcatGroup netVcatGroup = null;
            List list = null;
            INetElement iNetElement = null;
            iNetElement = netCcatCircuit.getSourceNE();
            if (bl) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("refreshCircuit : Member of VCAT, additional processing.");
                }
                netVcatGroup = netCcatCircuit.getVcatGroup();
                object = netVcatGroup.getAllVcatTerms().iterator();
                while (object.hasNext()) {
                    linkedList2.add(((NetVcatTermination)object.next()).getVcatTerm());
                }
                list = netVcatGroup.getAllMemberCircuits();
                object = list.iterator();
                while (object.hasNext()) {
                    NetCircuitManager.this.getAllConnsFromNetCircuit((NetCcatCircuit)object.next(), linkedList);
                }
            } else {
                NetCircuitManager.this.getAllConnsFromNetCircuit(netCcatCircuit, linkedList);
            }
            if (bl) {
                for (NetCcatCircuit netCcatCircuit2 : list) {
                    netCcatCircuit2.dispose();
                    netCcatCircuit2.finalDispose();
                    netCcatCircuit2.notifyDeleted();
                }
                netVcatGroup.getNetVcatCircuit().dispose();
                netVcatGroup.getNetVcatCircuit().finalDispose();
                netVcatGroup.getNetVcatCircuit().notifyDeleted();
                if (NetCircuitManager.dbgOn()) {
                    db.println("refreshCircuit : disposed all vcat objects.");
                }
            } else {
                netCcatCircuit.dispose();
                netCcatCircuit.finalDispose();
                netCcatCircuit.notifyDeleted(false);
                if (NetCircuitManager.dbgOn()) {
                    db.println("refreshCircuit : disposed the ccat object.");
                }
            }
            NetCircuitSplicer.instance().synchronizeSpliceListeners();
            object = NetCircuitWatchDog.instance();
            ((NetCircuitWatchDog)object).reloadCircuitInfos(iNetElement);
            ((NetCircuitWatchDog)object).discoverCircuitFromConnectionList(linkedList);
            ((NetCircuitWatchDog)object).discoverVCATFromTermList(linkedList2);
            if (NetCircuitManager.dbgOn()) {
                db.println("refresh : successful.");
            }
            linkedList.clear();
            linkedList2.clear();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpSvlan() {
            HashSet<SvlanCircuit> hashSet = new HashSet<SvlanCircuit>();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getSvlanCircuits());
                }
                if (!this.on()) {
                    this.set();
                }
                for (SvlanCircuit svlanCircuit : hashSet) {
                    svlanCircuit.prettyPrint(this);
                    this.println("==========================================================");
                }
            }
        }

        public final void deconstructionDump() {
            this.deconstructionDump(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void deconstructionDump(String string) {
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                }
                if (!this.on()) {
                    this.set();
                    this.println("");
                }
                this.println("Circuit Connection Deconstruction Dump");
                this.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                this.println("");
                for (NetCircuit netCircuit : hashSet) {
                    if (string != null && (string == null || !netCircuit.getCircuitName().equals(string))) continue;
                    netCircuit.prettyPrintDeconstruction(this);
                    this.println("==========================================================");
                    this.println("");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpMember() {
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                if (!this.on()) {
                    this.set();
                }
                for (NetCircuit netCircuit : hashSet) {
                    netCircuit.prettyPrint(this);
                    this.println("==========================================================");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpCkt(String string) {
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                }
                if (!this.on()) {
                    this.set();
                }
                for (NetCircuit netCircuit : hashSet) {
                    if (!netCircuit.getCircuitName().equals(string)) continue;
                    netCircuit.prettyPrint(this);
                    this.println("==========================================================");
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpPartialCircuits() {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits()) {
                        if (iNetCircuit.getState() != 4 && iNetCircuit.getState() != 6) continue;
                        iNetCircuit.prettyPrint(this);
                        this.println("==========================================================");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpPartialCktHdrs() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits()) {
                        if (iNetCircuit.getState() != 4 && iNetCircuit.getState() != 6) continue;
                        switch (iNetCircuit.getCircuitType()) {
                            case 1: {
                                ++n;
                                break;
                            }
                            case 2: {
                                ++n2;
                                break;
                            }
                            case 3: {
                                ++n3;
                                break;
                            }
                            case 7: {
                                ++n4;
                                break;
                            }
                            case 10: {
                                ++n5;
                                break;
                            }
                            case 11: {
                                ++n6;
                                break;
                            }
                            default: {
                                ++n7;
                            }
                        }
                        ((NetCircuit)iNetCircuit).prettyPrintHdr(this);
                    }
                }
                n8 = n + n2 + n3 + n4 + n5 + n6 + n7;
                if (n8 > 0) {
                    this.println(" ");
                    this.println("Partial Circuit Metrics: Total( " + n8 + " )");
                    this.println("STS : " + n);
                    this.println("VT : " + n2);
                    this.println("Tunnel : " + n3);
                    this.println("VAP : " + n4);
                    this.println("STS-V : " + n5);
                    this.println("VT-V : " + n6);
                    this.println("Others : " + n7);
                    this.println("==========================================================");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void fixCircuitWithName(String string) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        this.fixCircuit(netCircuit2);
                        break;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    this.fixCircuit(netCircuit2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void fixCircuit(NetCircuit netCircuit) {
            NetCircuitRepairer netCircuitRepairer = NetCircuitManager.this.getCircuitRepairer(netCircuit);
            try {
                try {
                    this.set();
                    this.println("==============fixCircuit==================");
                    if (netCircuit instanceof NetCcatCircuit) {
                        netCircuitRepairer.fixCircuit();
                    } else if (netCircuit instanceof NetVcatCircuit) {
                        Iterator iterator = ((NetVcatCircuit)netCircuit).getAllMemberCircuits().iterator();
                        NetCcatCircuit netCcatCircuit = null;
                        while (iterator.hasNext()) {
                            netCcatCircuit = (NetCcatCircuit)iterator.next();
                            NetCircuitRepairer netCircuitRepairer2 = NetCircuitManager.this.getCircuitRepairer(netCcatCircuit);
                            try {
                                netCircuitRepairer2.fixCircuit();
                            }
                            catch (Exception exception) {
                                this.println("**********exception while fixing = " + netCcatCircuit.getCircuitName() + exception.getMessage());
                                DumpDebug.printStackTrace((Throwable)exception);
                            }
                        }
                        netCircuitRepairer.fixCircuit();
                    }
                    this.println("==============fixCircuit==================");
                }
                catch (Exception exception) {
                    this.println("**********exception = " + exception.getMessage());
                    DumpDebug.printStackTrace((Throwable)exception);
                    Object var8_9 = null;
                    this.unset();
                    return;
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.unset();
                throw throwable;
            }
            this.unset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void fixTunnelWithName(String string, String string2, int n) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        this.fixTunnel(netCircuit2, string2, n);
                        break;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    this.fixTunnel(netCircuit2, string2, n);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void fixTunnel(NetCircuit netCircuit, String string, int n) {
            NetCircuitRepairer netCircuitRepairer = NetCircuitManager.this.getCircuitRepairer(netCircuit);
            try {
                try {
                    this.set();
                    this.println("==============fixTunnelCircuit==================");
                    netCircuitRepairer.fixTunnelCircuit(string, n);
                    this.println("==============fixTunnelCircuit==================");
                }
                catch (Exception exception) {
                    this.println("**********exception = " + exception.getMessage());
                    Object var7_6 = null;
                    this.unset();
                    return;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.unset();
                throw throwable;
            }
            this.unset();
        }

        private ICircuitId determineIfCircuitId(String string) {
            CircuitId circuitId = null;
            if (string != null && string.matches("^[0-9a-fA-F]+::[0-9]+$")) {
                int n = string.indexOf("::");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 2);
                try {
                    long l = Long.parseLong(string2, 16);
                    int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                    int n3 = Integer.parseInt(string3);
                    circuitId = new CircuitId(n2, n3);
                    this.println("Name will be considered a circuit ID");
                }
                catch (NumberFormatException numberFormatException) {
                    if (NetCircuitManager.dbgOn()) {
                        this.println("Invalid ckt id: " + string + " will treat like a ckt name");
                    }
                    db;
                    SDebug.printStackTrace((Throwable)numberFormatException);
                }
            }
            return circuitId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void downgradeCircuitWithName(String string) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        this.downgradeCircuit(netCircuit2);
                        break;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    this.downgradeCircuit(netCircuit2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void downgradeCircuit(NetCircuit netCircuit) {
            if (manager != null) {
                NetCircuitRepairer netCircuitRepairer = NetCircuitManager.this.getCircuitRepairer(netCircuit);
                if (netCircuit != null && netCircuit.isCircuitRefValid()) {
                    this.set();
                    this.println("=====================downgradeCircuit=====================");
                    netCircuit.prettyPrint(this);
                    this.println("=====================downgradeCircuit=====================");
                    NetCircuit netCircuit2 = netCircuit;
                    synchronized (netCircuit2) {
                        if (netCircuit instanceof NetCcatCircuit) {
                            try {
                                netCircuit.deleteCircuitModel();
                                this.println("Deleted circuit model");
                            }
                            catch (Exception exception) {
                                DumpDebug.printStackTrace((Throwable)exception);
                            }
                            netCircuitRepairer.changeCircuitId(new CircuitId(0, 0));
                            this.println("Changed circuitId to 0:0");
                            this.refreshCircuit((NetCcatCircuit)netCircuit);
                        } else if (netCircuit instanceof NetVcatCircuit) {
                            Iterator iterator = ((NetVcatCircuit)netCircuit).getAllMemberCircuits().iterator();
                            try {
                                netCircuit.deleteCircuitModel();
                            }
                            catch (DeletionError deletionError) {
                                DumpDebug.printStackTrace((Throwable)deletionError);
                            }
                            netCircuitRepairer.changeCircuitId(new CircuitId(0, 0));
                            this.println("Changed circuitId to 0:0");
                            NetCcatCircuit netCcatCircuit = null;
                            while (iterator.hasNext()) {
                                netCcatCircuit = (NetCcatCircuit)iterator.next();
                                try {
                                    netCcatCircuit.deleteCircuitModel();
                                }
                                catch (DeletionError deletionError) {
                                    DumpDebug.printStackTrace((Throwable)deletionError);
                                }
                                NetCircuitRepairer netCircuitRepairer2 = NetCircuitManager.this.getCircuitRepairer(netCcatCircuit);
                                netCircuitRepairer2.changeCircuitId(new CircuitId(0, 0));
                            }
                            if (netCcatCircuit != null) {
                                this.refreshCircuit(netCcatCircuit);
                            }
                        }
                    }
                }
                this.unset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearWrongConnections() {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits()) {
                        ((NetCircuit)iNetCircuit).clearWrongConnObjs(this);
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getMemberCircuits()) {
                        ((NetCircuit)iNetCircuit).clearWrongConnObjs(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpWrongConnObjs() {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getCircuits()) {
                        ((NetCircuit)iNetCircuit).prettyPrintWrongConnObjs(this);
                    }
                    for (INetCircuit iNetCircuit : NetCircuitManager.this.getMemberCircuits()) {
                        ((NetCircuit)iNetCircuit).prettyPrintWrongConnObjs(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearWrongConnections(String string) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                this.set();
                for (NetCircuit netCircuit2 : hashSet) {
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    netCircuit2.clearWrongConnObjs(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void refreshCircuit(String string) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        if (netCircuit2 instanceof NetVcatCircuit) {
                            this.println("Cannot refresh Vcat Ckt");
                            return;
                        }
                        this.refreshCircuit((NetCcatCircuit)netCircuit2);
                        break;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    if (netCircuit2 instanceof NetVcatCircuit) {
                        this.println("Cannot refresh Vcat Ckt");
                        return;
                    }
                    this.refreshCircuit((NetCcatCircuit)netCircuit2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void fixWrongConnection(String string, int n, String string2, int n2) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        netCircuit2.fixWrongConnection(this, n, string2, n2);
                        break;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    netCircuit2.fixWrongConnection(this, n, string2, n2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setCktIdOnNCN(String string, String string2, int n, String string3) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                this.set();
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        this.setCktIdOnNCN(netCircuit2, string2, n, string3);
                        continue;
                    }
                    if (!netCircuit2.getCircuitName().equals(string)) continue;
                    this.setCktIdOnNCN(netCircuit2, string2, n, string3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setCktIdOnNCN(NetCircuit netCircuit, String string, int n, String string2) {
            NetCircuitRepairer netCircuitRepairer = NetCircuitManager.this.getCircuitRepairer(netCircuit);
            try {
                try {
                    this.set();
                    this.println("==============setCktIdOnNCN==================");
                    netCircuitRepairer.setCktIdOnNCN(string, n, string2);
                    this.println("==============setCktIdOnNCN==================");
                }
                catch (Exception exception) {
                    this.println("**********exception = " + exception.getMessage());
                    Object var8_7 = null;
                    this.unset();
                    return;
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.unset();
                throw throwable;
            }
            this.unset();
        }

        public final void getAllNodesOnCktRepair() {
            this.println("allNodesOnCktRepair: " + NetCircuitManager.this.allNodesOnCktRepair);
        }

        public final void setAllNodesOnCktRepair(boolean bl) {
            NetCircuitManager.this.allNodesOnCktRepair = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void completeCheckCircuitWithName(String string) {
            NetCircuit netCircuit2 = null;
            HashSet hashSet = new HashSet();
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    hashSet.addAll(NetCircuitManager.this.getCircuits());
                    hashSet.addAll(NetCircuitManager.this.getMemberCircuits());
                }
                netCircuitManager = this.determineIfCircuitId(string);
                for (NetCircuit netCircuit2 : hashSet) {
                    if (netCircuitManager != null) {
                        if (!netCircuit2.getCircuitId().equals(netCircuitManager)) continue;
                        this.completeCheck(netCircuit2);
                        continue;
                    }
                    if (!netCircuit2.getCircuitName().equals(string) && !string.equals("*")) continue;
                    this.completeCheck(netCircuit2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void completeCheck(NetCircuit netCircuit) {
            LogLevel logLevel;
            block8: {
                logLevel = pkgDb.getLogLevel();
                int n = netCircuit.getState();
                boolean bl = n == 4;
                try {
                    try {
                        pkgDb.setLogLevel(LogLevel.FINE);
                        pkgDb.println("*** Circuit " + netCircuit + " current status: " + EnumStrings.getString(INetCircuitState.class, (int)n));
                        if (bl) {
                            pkgDb.println("*** completeCheck() enter");
                            netCircuit.completeCheck();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        pkgDb;
                        SDebug.printStackTrace((Throwable)runtimeException);
                        Object var7_6 = null;
                        if (bl) {
                            pkgDb.println("*** completeCheck() done");
                        }
                        pkgDb.setLogLevel(logLevel);
                        return;
                    }
                    Object var7_5 = null;
                    if (!bl) break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (bl) {
                        pkgDb.println("*** completeCheck() done");
                    }
                    pkgDb.setLogLevel(logLevel);
                    throw throwable;
                }
                pkgDb.println("*** completeCheck() done");
            }
            pkgDb.setLogLevel(logLevel);
        }

        public final void resetAllPartialCircuits() {
            List list = NetCircuitManager.this.getCircuits();
            Iterator iterator = list.iterator();
            LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                if (netCircuit.getState() != 4 && netCircuit.getState() != 6) continue;
                linkedList.add(netCircuit);
            }
            for (NetCircuit netCircuit : linkedList) {
                this.downgradeCircuit(netCircuit);
            }
        }

        public final void circuitCount() {
            List list = NetCircuitManager.this.getCircuits();
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (NetCircuit netCircuit : list) {
                if (netCircuit.getState() == 1) {
                    ++n2;
                    continue;
                }
                if (netCircuit.getState() == 5) {
                    ++n3;
                    continue;
                }
                if (netCircuit.getState() == 0) {
                    ++n4;
                    continue;
                }
                if (netCircuit.getState() == 4) {
                    ++n5;
                    continue;
                }
                ++n6;
            }
            IMetrics.circuitDb.println("Total circuit count : " + n);
            IMetrics.circuitDb.println("Active : " + n2);
            IMetrics.circuitDb.println("TL1-Active : " + n3);
            IMetrics.circuitDb.println("Creating : " + n4);
            IMetrics.circuitDb.println("Incomplete : " + n5);
            IMetrics.circuitDb.println("Other : " + n6);
        }

        public final void setCircuitCounterTimer(int n) {
            this.circuitCounterSleepTime = n;
            if (this.circuitCounterThread != null) {
                this.circuitCounterThread.setTimer(this.circuitCounterSleepTime);
            }
        }

        public final void enableCircuitCounter() {
            if (this.circuitCounterThread == null) {
                this.circuitCounterThread = new CircuitCounterThread(this.circuitCounterSleepTime);
                this.circuitCounterThread.start();
                IMetrics.circuitDb.println("Circuit Counter Monitor started");
            }
        }

        public final void disableCircuitCounter() {
            if (this.circuitCounterThread != null) {
                this.circuitCounterThread.cancel();
                IMetrics.circuitDb.println("Circuit Counter Monitor stopped");
            }
            this.circuitCounterThread = null;
        }

        public void dumpDiag() {
            this.dump();
        }

        public final void reportMemorySize(boolean bl, boolean bl2) {
            db.display("It may take a few minutes for this operation to complete. Please be patient");
            NetModelMemorySizer netModelMemorySizer = new NetModelMemorySizer(this, bl2 ? 8 : 4, false, bl);
            netModelMemorySizer.enableCleanupState(false);
            NetCircuitManager netCircuitManager = NetCircuitManager.instance();
            int n = netModelMemorySizer.sizeOf(netCircuitManager);
            Network network = Network.instance();
            netModelMemorySizer.reportClassCount(bl);
            netModelMemorySizer.cleanupState(true);
            this.println("*** total size: " + (n += netModelMemorySizer.sizeOf(network)));
        }

        public final void reportMemorySize() {
            this.reportMemorySize(true, false);
        }

        public final void reverseRoutingDir(String string) {
            NetCircuit netCircuit = this.getCircuit(string);
            if (netCircuit != null && netCircuit instanceof NetCcatCircuit) {
                try {
                    ((NetCcatCircuit)netCircuit).reverseRoutingDir();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    this.println("Invalid ckt operation, incorrect circuit state");
                }
            }
        }

        public NetCircuit getCircuit(String string) {
            NetCircuit netCircuit = null;
            Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
            while (iterator.hasNext() && !(netCircuit = (NetCircuit)iterator.next()).getCircuitName().equals(string)) {
            }
            return netCircuit;
        }

        public final void traceRPR(String string) throws Exception {
            NetCircuit netCircuit = null;
            Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
            while (iterator.hasNext() && !(netCircuit = (NetCircuit)iterator.next()).getCircuitName().equals(string)) {
            }
            DataNetworkManager dataNetworkManager = new DataNetworkManager();
            LinkedList linkedList = dataNetworkManager.getRPRRing(netCircuit);
            Iterator iterator2 = linkedList.iterator();
            NetCircuitManager.debug("================RPR Trace================");
            NetCircuitManager.debug("RPRInfo List Size : " + linkedList.size());
            NetCircuitManager.debug("================================");
            while (iterator2.hasNext()) {
                RPRInfo rPRInfo = (RPRInfo)iterator2.next();
                NetCircuitManager.debug(rPRInfo.toString());
                NetCircuitManager.debug("================================");
            }
            NetCircuitManager.debug("================RPR Trace Done================");
            dataNetworkManager.dispose();
        }
    }
}

