/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.Connection;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NetCircuitPathMarker {
    private NetCcatCircuit circuit;
    private static final SDebug db = new SDebug("NetCircuitPathMarker");
    private boolean termsInited = false;
    private String LINE_TERM;
    private String BLSR_TERM;
    private String BLSRDRI_TERM;
    private String UPSR_TERM;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private static void debug(String string) {
        db.println(string);
    }

    protected NetCircuitPathMarker(NetCcatCircuit netCcatCircuit) {
        this.circuit = netCcatCircuit;
    }

    private void initTerms() {
        if (this.termsInited) {
            return;
        }
        this.termsInited = true;
        this.LINE_TERM = CircuitMapUtil.getTDMTerminology(this.circuit).getGeneralTerms(2);
        this.BLSR_TERM = CircuitMapUtil.getTDMTerminology(this.circuit).getRingTerms(1);
        this.BLSRDRI_TERM = this.BLSR_TERM + "-DRI";
        this.UPSR_TERM = CircuitMapUtil.getTDMTerminology(this.circuit).getRingTerms(0);
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("LINE_TERM = " + this.LINE_TERM);
            NetCircuitPathMarker.debug("BLSR_TERM = " + this.BLSR_TERM);
            NetCircuitPathMarker.debug("BLSRDRI_TERM = " + this.BLSRDRI_TERM);
            NetCircuitPathMarker.debug("UPSR_TERM = " + this.UPSR_TERM);
        }
    }

    protected void markUpsr() {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markUpsr: marking circuit " + this.circuit.getCircuitName());
        }
        Iterator iterator = this.circuit.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).setUpsrLink(false);
        }
        for (NetCircuitNode netCircuitNode : this.circuit.getCircuitNodes()) {
            this.markSelectorInputPaths(netCircuitNode);
            int n = netCircuitNode.getConnectionType();
            if (NetCircuitNodeUtil.isUpsrSelectorConnType(n)) continue;
            netCircuitNode.setUpsrOps(null);
            netCircuitNode.cleanupUpsrEntities();
        }
    }

    protected void markDri() {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markDri: marking circuit " + this.circuit.getCircuitName());
        }
        this.circuit.driConfigurationError = false;
        for (NetCircuitSpan netCircuitSpan : this.circuit.getCircuitSpans()) {
            netCircuitSpan.setDri(false);
            netCircuitSpan.setBlsrDriInterConnect(false);
            if (this.circuit.getState() == 0) continue;
            netCircuitSpan.getNetLinkSpan().setSecondaryCircuit(false);
        }
        this.markDriNodes();
        for (NetCircuitNode netCircuitNode : this.circuit.getCircuitNodes()) {
            this.markSpansDri(netCircuitNode);
        }
    }

    private void markDriNodes() {
        NetCircuitNode[] netCircuitNodeArray = new NetCircuitNode[2];
        int n = 0;
        List list = this.circuit.getCircuitNodes();
        Connection[] connectionArray = new Connection[2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markDriNodes: marking circuit " + this.circuit.getCircuitName());
        }
        for (NetCircuitNode netCircuitNode : list) {
            netCircuitNode.setDri(false);
            n3 += NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNode.getDriNodeType()) ? 1 : 0;
        }
        for (NetCircuitNode netCircuitNode : list) {
            n += this.markBlsrDriHandoffs(netCircuitNode);
            for (SelectorConnection selectorConnection : netCircuitNode.getSelectors()) {
                int n5;
                if (selectorConnection.handoffs.size() != 2) continue;
                for (n5 = 0; n5 < 2; ++n5) {
                    connectionArray[n5] = (Connection)selectorConnection.handoffs.get(n5);
                    netCircuitNodeArray[n5] = connectionArray[n5].getNode();
                    if (netCircuitNodeArray[n5] == null || netCircuitNodeArray[n5].getDri() || NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNodeArray[n5].getDriNodeType())) continue;
                    ++n2;
                }
                if (!connectionArray[0].hasValidUpsrDriHandoffInterconnect(connectionArray[1]) || !connectionArray[1].hasValidUpsrDriHandoffInterconnect(connectionArray[0])) continue;
                for (n5 = 0; n5 < 2; ++n5) {
                    if (netCircuitNodeArray[n5] == null || netCircuitNodeArray[n5].getDri() || NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNodeArray[n5].getDriNodeType())) continue;
                    arrayList.add(netCircuitNodeArray[n5]);
                }
            }
        }
        this.circuit.driConfigurationError = n3 != n;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && !this.circuit.driConfigurationError) {
            ((NetCircuitNode)iterator.next()).setDri(true);
            ++n;
        }
        if (NetCircuitPathMarker.dbgOn()) {
            n4 = n2 + n3;
            db.println("markDriNodes: marked " + n + " of " + n4 + " DRI handoff nodes");
        }
    }

    protected int markBlsrDriHandoffs(NetCircuitNode netCircuitNode) {
        int n = 0;
        if (netCircuitNode.getDri()) {
            return 0;
        }
        for (Connection connection : netCircuitNode.connections) {
            List list;
            OnewayConnection onewayConnection;
            Connection connection2;
            if (connection.isValidBlsrDriSelector()) {
                n += ((SelectorConnection)connection).markBlsrDriHandoffs();
                continue;
            }
            if (!connection.isValidOpenEndedOnewayBlsrDriSecondaryDrop() || (connection2 = this.circuit.findBlsrDriPrimary(onewayConnection = (OnewayConnection)connection)) == null || (list = onewayConnection.getInSpans()).size() != 1) continue;
            n += onewayConnection.markBlsrDriHandoffs(null, connection2, (NetCircuitSpan)list.get(0));
        }
        return n;
    }

    protected void markSelectorInputPaths(NetCircuitNode netCircuitNode) {
        if (!netCircuitNode.hasSelector()) {
            return;
        }
        if (netCircuitNode.getUpsrOps() == null) {
            NetCircuitPathMarker.createUpsrOps(netCircuitNode);
        }
        Iterator iterator = netCircuitNode.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (NetCircuitPathMarker.dbgOn()) {
                db.println("markSelectorInputPaths: marking selectors on node " + netCircuitNode.getName());
            }
            SelectorConnection selectorConnection = (SelectorConnection)iterator.next();
            selectorConnection.findUpsrHead();
            selectorConnection.isProtected = true;
            for (NetCircuitSpan netCircuitSpan : selectorConnection.getInSpans()) {
                boolean bl = selectorConnection.markSelectorInputSpans(selectorConnection, netCircuitSpan);
                boolean bl2 = selectorConnection.isProtected = selectorConnection.isProtected && bl;
                if (!NetCircuitPathMarker.dbgOn() || bl) continue;
                db.println("markSelectorInputPaths: ERROR - unprotected selector detected validating inSpan " + netCircuitSpan.prettyString());
            }
        }
    }

    protected void markSpansDri(NetCircuitNode netCircuitNode) {
        for (Connection connection : netCircuitNode.connections) {
            connection.markSpansDri();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void markBlsrDriInterConnectSpans(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, int n) throws SanityCheckFailed {
        Object object;
        this.initTerms();
        LinkedList linkedList = new LinkedList();
        NetCircuitNode netCircuitNode3 = null;
        if (n == 1 || netCircuitNode.getTotalInOuts() == 3) {
            if (netCircuitNode.countNumInputs() == 2) {
                linkedList = netCircuitNode2.getOrigSpans();
                netCircuitNode3 = netCircuitNode2;
            } else if (netCircuitNode.countNumOutputs() == 2) {
                linkedList = netCircuitNode2.getTermSpans();
                netCircuitNode3 = netCircuitNode2;
            } else {
                if (netCircuitNode.countNumOmniSpans() != 1) throw new SanityCheckFailed("The traditional handoff " + netCircuitNode.getName() + " has an invalid span combination.");
                if (netCircuitNode.getOrigSpans().size() == 1 && netCircuitNode.getTermSpans().size() == 1) {
                    if (((NetCircuitSpan)netCircuitNode.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode.getOrigSpans().get(0));
                    }
                }
                netCircuitNode3 = netCircuitNode;
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)object.next();
                if (netCircuitSpan.getLink().inBLSR()) continue;
                object.remove();
            }
        } else {
            if (n != 2 || netCircuitNode.getTotalInOuts() != 4) throw new SanityCheckFailed("The " + this.BLSRDRI_TERM + " handoff " + netCircuitNode.getName() + " has an invalid span combination.");
            if (netCircuitNode2.getOmniSpans().size() == 1) {
                if (netCircuitNode2.getOrigSpans().size() == 2) {
                    if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(1)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(1));
                    }
                } else if (netCircuitNode2.getTermSpans().size() == 2) {
                    if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(1)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(1));
                    }
                } else {
                    if (netCircuitNode2.getOrigSpans().size() != 1 || netCircuitNode2.getTermSpans().size() != 1) throw new SanityCheckFailed("The integrated handoff " + netCircuitNode2.getName() + " requires three spans.");
                    if (((NetCircuitSpan)netCircuitNode2.getTermSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getTermSpans().get(0));
                    } else if (((NetCircuitSpan)netCircuitNode2.getOrigSpans().get(0)).getLink().inBLSR()) {
                        linkedList.add(netCircuitNode2.getOrigSpans().get(0));
                    }
                }
            } else {
                if (netCircuitNode2.getTotalInOuts() != 2 || netCircuitNode2.getOmniSpans().size() != 0) throw new SanityCheckFailed("The integrated handoff " + netCircuitNode.getName() + " has an invalid span combination.");
                linkedList.addAll(netCircuitNode2.getAllSpansList());
            }
            netCircuitNode3 = netCircuitNode2;
        }
        if (netCircuitNode3.getNetElement().equals(netCircuitNode.getNetElement())) {
            object = netCircuitNode2;
            ((NetCircuitNode)object).driNodeType = 2;
            netCircuitNode3.driNodeType = 1;
        } else {
            object = netCircuitNode;
            ((NetCircuitNode)object).driNodeType = 1;
            netCircuitNode3.driNodeType = 2;
        }
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            NetCircuitNode netCircuitNode4 = netCircuitNode3;
            while (!((NetCircuitNode)object).getNetElement().equals(netCircuitNode4.getNetElement())) {
                if (NetCircuitPathMarker.dbgOn()) {
                    db.println("markBlsrDriInterConnectSpans: node " + netCircuitNode4.getName() + " span " + netCircuitSpan.prettyString());
                }
                netCircuitSpan.setBlsrDriInterConnect(true);
                NetCircuitNode netCircuitNode5 = netCircuitNode4.spanGetPeer(netCircuitSpan);
                if (netCircuitNode5 == null) {
                    throw new SanityCheckFailed("The DRI node " + netCircuitNode4.getName() + " has no peer.");
                }
                netCircuitNode4 = netCircuitNode5;
                List list = netCircuitNode4.getAllSpansList();
                if (((NetCircuitNode)object).getNetElement().equals(netCircuitNode4.getNetElement())) continue;
                netCircuitNode4.driNodeType = 3;
                if (list.size() < 2) {
                    throw new SanityCheckFailed("The intermediate handoff interconnect " + netCircuitNode4.getName() + " must have two spans.");
                }
                if (netCircuitSpan.equals((NetCircuitSpan)list.get(0))) {
                    netCircuitSpan = (NetCircuitSpan)list.get(1);
                    continue;
                }
                netCircuitSpan = (NetCircuitSpan)list.get(0);
            }
        }
    }

    protected static void createUpsrOps(NetCircuitNode netCircuitNode) {
        netCircuitNode.createUpsrOps();
    }

    protected void markRoutedUpsrRing(NetCircuitNode netCircuitNode) throws SanityCheckFailed {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = netCircuitNode.findConnType() != 15;
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        int n = this.circuit.getCktOperation();
        INetElement iNetElement = netCircuitNode.getNetElement();
        int n2 = netCircuitNode.countNumInputs();
        boolean bl5 = bl = netCircuitNode.countNumOmniSpans() > 0;
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedUpsrRing(" + netCircuitNode.getName() + ")");
        }
        NetCircuitPathMarker.createUpsrOps(netCircuitNode);
        if (n2 < 2 && !bl) {
            return;
        }
        LinkedList linkedList = netCircuitNode.getTermSpans();
        if (memberPrefs != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(iNetElement)) {
            linkedList = new LinkedList(this.getTermSpansForBlsrDriHandoffNodes(netCircuitNode));
        }
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            if (NetCircuitPathMarker.dbgOn()) {
                NetCircuitPathMarker.debug("markRoutedUpsrRing: trying span " + netCircuitSpan.prettyString());
            }
            if (netCircuitSpan.getDstState() != 2 && n != 5) continue;
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan);
            if (netCircuitNode2 != null) {
                this.markRoutedUpsrSpan(netCircuitNode2, netCircuitSpan, bl4);
                if (bl && !bl3) {
                    bl2 = this.isSourceRing(netCircuitNode2, netCircuitSpan);
                    if (NetCircuitPathMarker.dbgOn()) {
                        NetCircuitPathMarker.debug(netCircuitNode.getName() + " determined to be on " + (bl2 ? "source " : "dest ") + "ring");
                    }
                }
            }
            if (!bl4 || !netCircuitNode.inSpans.contains(netCircuitSpan)) continue;
            netCircuitNode.inSpans.remove(netCircuitSpan);
            netCircuitNode.biSpans.add(netCircuitSpan);
        }
        if (bl) {
            this.markRoutedOmniSpans(netCircuitNode, bl2);
        }
    }

    private boolean isSourceRing(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan) {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("isSourceRing: node= " + netCircuitNode.getName() + ". span= " + netCircuitSpan.prettyString());
        }
        boolean bl = true;
        INetElement iNetElement = netCircuitNode.getNetElement();
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        if (memberPrefs.isBlsrDriNode(iNetElement)) {
            return false;
        }
        int n = netCircuitNode.countRoutedOutputs();
        if (n > 1) {
            return true;
        }
        LinkedList linkedList = netCircuitNode.getTermSpans();
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        if (linkedList.isEmpty()) {
            NetCircuitPathMarker.debug("Warning! No terminating Spans found on UPSR nodewhile trying to determine DRI source ring attibute.");
            NetCircuitPathMarker.debug("This possible for circuits with 2 sources and interm. nodes");
            return true;
        }
        for (NetCircuitSpan netCircuitSpan2 : linkedList) {
            if (netCircuitSpan2.getDstState() != 2) continue;
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
            bl = this.isSourceRing(netCircuitNode2, netCircuitSpan2);
            LinkedList linkedList2 = netCircuitNode.getOmniSpans();
            if (linkedList2.size() == 1) {
                return !bl;
            }
            return bl;
        }
        return bl;
    }

    private void markRoutedUpsrSpan(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan, boolean bl) throws SanityCheckFailed {
        LinkedList linkedList;
        int n;
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedUpsrSpan: node " + netCircuitNode.getName() + " span " + netCircuitSpan.prettyString());
        }
        this.initTerms();
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        netCircuitSpan.setUpsrLink(true);
        if (netCircuitSpan.getBlsrDriInterConnect()) {
            if (!netCircuitSpan.getLink().inBLSR()) {
                throw new SanityCheckFailed("The span is not on the " + this.BLSR_TERM + ".");
            }
        } else if (netCircuitSpan.getLink().getProtectionType() != 3) {
            if (netCircuitNode.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() != 1) {
                    throw new SanityCheckFailed("The " + this.UPSR_TERM + " span is neither unprotected nor 1+1 protected");
                }
            } else if (!netCircuitNode.getCircuit().isOverlayRing()) {
                netCircuitSpan.setUpsrLink(false);
                throw new SanityCheckFailed("The " + this.UPSR_TERM + " span is " + this.LINE_TERM + " protected.");
            }
        }
        int n2 = netCircuitNode.findConnType();
        if (!(this.circuit.getXmCircuitEnds().isEmpty() || ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() != netCircuitNode.getNodeModel().getNodeId() || n2 != 1 && netCircuitNode.countNumOmniSpans() == 0)) {
            throw new SanityCheckFailed("The circuit has a primary path through a pair of DS3XM-12 portless ports, but not an alternate path.");
        }
        if (netCircuitNode.isUpsrSelectorConn() && netCircuitNode.getUpsrOps() == null) {
            NetCircuitPathMarker.createUpsrOps(netCircuitNode);
        }
        if ((n = netCircuitNode.countRoutedOutputs()) > 1) {
            return;
        }
        if (n == 1 && netCircuitNode.countRoutedSources() == 1) {
            return;
        }
        if (n2 == 10 || n2 == 11) {
            this.circuit.setDri(true);
        }
        if ((linkedList = netCircuitNode.getTermSpans()).contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        for (NetCircuitSpan netCircuitSpan2 : linkedList) {
            if (netCircuitSpan2.getDstState() != 2) continue;
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
            this.markRoutedUpsrSpan(netCircuitNode2, netCircuitSpan2, bl);
            if (n2 != 6 && bl && netCircuitNode.outSpans.contains(netCircuitSpan)) {
                netCircuitNode.outSpans.remove(netCircuitSpan);
                netCircuitNode.biSpans.add(netCircuitSpan);
            }
            if (!bl || !netCircuitNode.inSpans.contains(netCircuitSpan2)) continue;
            netCircuitNode.inSpans.remove(netCircuitSpan2);
            netCircuitNode.biSpans.add(netCircuitSpan2);
        }
    }

    protected void markRoutedUpsrRingFromBridge(NetCircuitNode netCircuitNode) throws SanityCheckFailed {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedUpsrRingFromBridge " + netCircuitNode.getName());
        }
        if (!netCircuitNode.isUpsrSelectorConn() && netCircuitNode.findConnType() != 4) {
            return;
        }
        if (this.circuit.isBidirectional()) {
            NetCircuitPathMarker.createUpsrOps(netCircuitNode);
        }
        LinkedList linkedList = netCircuitNode.getOrigSpans();
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            NetCircuitNode netCircuitNode2;
            if (netCircuitSpan.getSrcState() != 2 || (netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan)) == null) continue;
            this.markRoutedUpsrSpanOffBridge(netCircuitNode2, netCircuitSpan);
        }
    }

    private void markRoutedUpsrSpanOffBridge(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan) throws SanityCheckFailed {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedUpsrSpanOffBridge: node= " + netCircuitNode.getName() + ". span= " + netCircuitSpan.prettyString());
        }
        this.initTerms();
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        netCircuitSpan.setUpsrLink(true);
        if (netCircuitSpan.getLink().getProtectionType() != 3) {
            if (netCircuitNode.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() != 1) {
                    throw new SanityCheckFailed("The " + this.UPSR_TERM + " span is neither unprotected nor " + this.LINE_TERM + " protected");
                }
            } else {
                throw new SanityCheckFailed("The " + this.UPSR_TERM + " span is " + this.LINE_TERM + " protected");
            }
        }
        if (netCircuitNode.isUpsrSelectorConn() && netCircuitNode.getUpsrOps() == null) {
            NetCircuitPathMarker.createUpsrOps(netCircuitNode);
        }
        int n = netCircuitNode.countRoutedInputs();
        int n2 = netCircuitNode.countRoutedDrops();
        if (n == 1 && n2 == 1) {
            if (netCircuitNode.inSpans.contains(netCircuitSpan)) {
                netCircuitNode.inSpans.remove(netCircuitSpan);
                netCircuitNode.biSpans.add(netCircuitSpan);
            }
            return;
        }
        LinkedList linkedList = netCircuitNode.getOrigSpans();
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        for (NetCircuitSpan netCircuitSpan2 : linkedList) {
            if (netCircuitSpan2.getSrcState() != 2) continue;
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
            this.markRoutedUpsrSpanOffBridge(netCircuitNode2, netCircuitSpan2);
            if (netCircuitNode.inSpans.contains(netCircuitSpan)) {
                netCircuitNode.inSpans.remove(netCircuitSpan);
                netCircuitNode.biSpans.add(netCircuitSpan);
            }
            if (!netCircuitNode.outSpans.contains(netCircuitSpan2)) continue;
            netCircuitNode.outSpans.remove(netCircuitSpan2);
            netCircuitNode.biSpans.add(netCircuitSpan2);
        }
    }

    private void markRoutedOmniSpans(NetCircuitNode netCircuitNode, boolean bl) {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedOmniSpans(" + netCircuitNode.getName() + ")" + (bl ? "(Src Ring)" : ""));
        }
        LinkedList linkedList = netCircuitNode.getOmniSpans();
        int n = netCircuitNode.countNumTermSpans();
        if (linkedList.size() == 2 && n == 0) {
            if (NetCircuitPathMarker.dbgOn()) {
                NetCircuitPathMarker.debug("Not marking routed omni spans starting at interm. node");
            }
            return;
        }
        boolean bl2 = bl;
        for (NetCircuitSpan netCircuitSpan : linkedList) {
            NetCircuitNode netCircuitNode2;
            if (netCircuitSpan.getDstState() != 2 || (netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan)) == null) continue;
            this.markRoutedOmniSpans(netCircuitNode2, netCircuitSpan, bl2);
            bl2 = !bl2;
        }
    }

    private void markRoutedOmniSpans(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan, boolean bl) {
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedOmniSpans: node= " + netCircuitNode.getName() + ". span= " + netCircuitSpan.prettyString() + (bl ? "(Src Ring)" : ""));
        }
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        if (NetCircuitPathMarker.dbgOn()) {
            NetCircuitPathMarker.debug("markRoutedOmniSpans: span is UPSR");
        }
        netCircuitSpan.setUpsrLink(true);
        int n = netCircuitNode.getTotalInOuts();
        int n2 = netCircuitNode.getSources().size();
        if (n >= 3) {
            netCircuitNode.setDri(true);
            if (n == 3 && n2 == 1 && !this.circuit.isBidirectional()) {
                bl = false;
            }
        }
        netCircuitSpan.getNetLinkSpan().setSourceRing(bl);
        LinkedList linkedList = netCircuitNode.getOmniSpans();
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        if (netCircuitNode.isUpsrSelectorConn()) {
            if (NetCircuitPathMarker.dbgOn()) {
                NetCircuitPathMarker.debug("reached selector node- stopping");
            }
            return;
        }
        NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)linkedList.getFirst();
        if (netCircuitSpan2 != null) {
            NetCircuitNode netCircuitNode2 = netCircuitNode.spanGetPeer(netCircuitSpan2);
            this.markRoutedOmniSpans(netCircuitNode2, netCircuitSpan2, bl);
        } else {
            NetCircuitPathMarker.debug("Warning! unable to find connected span in intermediate DRI node");
        }
    }

    private List getTermSpansForBlsrDriHandoffNodes(NetCircuitNode netCircuitNode) {
        NetCircuitNode netCircuitNode2 = null;
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        INetElement iNetElement = netCircuitNode.getNetElement();
        int n = netCircuitNode.findConnType();
        LinkedList linkedList = new LinkedList();
        if (memberPrefs.getDriNodePrefs().size() != 0) {
            int n2;
            if (memberPrefs.isBlsrDriNode(iNetElement) && (n2 = memberPrefs.getDriType(iNetElement)) == 2) {
                switch (n) {
                    case 13: 
                    case 15: {
                        List list = this.circuit.getCircuitNodeFromNE(memberPrefs.findDriPeer(iNetElement));
                        if (list != null) {
                            if (list.size() > 1) {
                                if (NetCircuitPathMarker.dbgOn()) {
                                    NetCircuitPathMarker.debug("Error !! MXPN in BLSR_IDRI");
                                }
                            } else {
                                netCircuitNode2 = (NetCircuitNode)list.get(0);
                            }
                        }
                        while (!netCircuitNode2.getNetElement().equals(iNetElement)) {
                            linkedList.clear();
                            linkedList.addAll(netCircuitNode2.getOrigSpans());
                            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)linkedList.get(0);
                            netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan);
                        }
                        return linkedList;
                    }
                    case 14: {
                        if (netCircuitNode.getTermSpans().size() == 2) {
                            linkedList.addAll(netCircuitNode.getTermSpans());
                            break;
                        }
                        if (netCircuitNode.getOrigSpans().size() != 2) break;
                        linkedList.addAll(netCircuitNode.getOrigSpans());
                        break;
                    }
                    default: {
                        return linkedList;
                    }
                }
            }
            return linkedList;
        }
        return linkedList;
    }
}

