/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDeleteWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitOperator;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPath;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NetVcatCircuitOperator
extends NetCircuitOperator
implements IJobGroupListener {
    private NetVcatCircuit vcatCircuit;
    private boolean deleteDone;
    private Object threadWaitObject;
    private static final SDebug db = new SDebug("NetVcatCircuitOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected NetVcatCircuitOperator(NetVcatCircuit netVcatCircuit) {
        this.vcatCircuit = netVcatCircuit;
        this.deleteDone = false;
        this.threadWaitObject = new Object();
    }

    protected NetCircuit getCircuit() {
        return this.vcatCircuit;
    }

    protected void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.vcatCircuit.getCircuitType(), iNetCircuitEnd);
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("addDrop called. Drop = " + netCircuitEnd.prettyString());
        }
        this.vcatCircuit.setRoutePrefs(routePrefs);
        this.vcatCircuit.getCircuitInfo().setVcatRoutingPref(routePrefs.getFwdDropPrefs().isCommonFiber() ? 1 : 2);
        this.addDropCheck(netCircuitEnd, 9);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 9);
        if (this.vcatCircuit.getCktDrops().contains(netCircuitDropInfo)) {
            throw new SanityCheckFailed("An attempt was made to add a duplicate drop to the circuit.");
        }
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.vcatCircuit.getVcatTermFromCktEnd(this.vcatCircuit.getPrimarySource());
        NetVcatTermination netVcatTermination2 = new NetVcatTermination(this.vcatCircuit, netCircuitEnd, netVcatTermination);
        ((NetVcatGroup)this.vcatCircuit.getForwardVcatGroup()).insertVcatTermination(netVcatTermination2);
        ((NetVcatGroup)this.vcatCircuit.getForwardVcatGroup()).addDrop(iNetCircuitEnd, routePrefs);
        netCircuitEnd.setStage(2);
        this.vcatCircuit.insertDrop(netCircuitDropInfo);
        if (this.vcatCircuit.getState() != 0) {
            this.vcatCircuit.setState(3);
        }
    }

    protected void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        this.routeCurrentDrop(iNetElement, routePrefs, bl, this.vcatCircuit.getAllMemberCircuits());
    }

    private void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl, List list) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs, this.vcatCircuit);
        if (bl) {
            LinkedList linkedList = netCircuitPath.computeCircuitPath().getDropPath().getMemberPaths();
            Iterator iterator = linkedList.iterator();
            this.vcatCircuit.setCircuitCosts(netCircuitPath.computePathCosts());
            while (iterator.hasNext()) {
                MemberPath memberPath = (MemberPath)iterator.next();
                MemberPrefs memberPrefs = memberPath.getMemberPrefs();
                boolean bl2 = false;
                NetCcatCircuit netCcatCircuit = null;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    netCcatCircuit = (NetCcatCircuit)iterator2.next();
                    if (netCcatCircuit.getMemberPrefs().getMemberId() != memberPrefs.getMemberId()) continue;
                    bl2 = true;
                    iterator2.remove();
                    break;
                }
                if (bl2) {
                    if (NetVcatCircuitOperator.dbgOn()) {
                        db.println("found a member circuit to addCircuitSpan (" + netCcatCircuit.getCircuitName() + ", " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + ")");
                    }
                } else if (NetVcatCircuitOperator.dbgOn()) {
                    db.println("Warning !!! Can not found a member circuit to addCircuitSpan");
                }
                if (!bl2 || netCcatCircuit == null) continue;
                Iterator iterator3 = memberPath.getSpans().iterator();
                while (iterator3.hasNext()) {
                    netCcatCircuit.addCircuitSpan((INetLinkSpan)iterator3.next());
                }
            }
        }
    }

    protected void routeNewMemberCkts(RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        NetCcatCircuit netCcatCircuit = this.vcatCircuit.getLongestRoutedMember();
        if (netCcatCircuit != null) {
            LinkedList linkedList = routePrefs2.getFwdDropPrefs().getMemberGroupPrefs();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                MemberPrefs memberPrefs = ((MemberGroupPrefs)iterator.next()).getMemberPrefs();
                LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
                LinkedList linkedList3 = netCcatCircuit.getRequiredSpans();
                Iterator iterator2 = linkedList3.iterator();
                while (iterator2.hasNext()) {
                    INetLink iNetLink;
                    INetLink iNetLink2 = ((INetLinkSpan)iterator2.next()).getLink();
                    if (memberPrefs.getPathProtection() == 2) {
                        linkedList2.add(iNetLink2);
                        continue;
                    }
                    if (memberPrefs.getPathProtection() == 4) {
                        if (iNetLink2.isPca()) {
                            linkedList2.add(iNetLink2);
                            continue;
                        }
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    if (iNetLink2.isPca()) {
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    linkedList2.add(iNetLink2);
                }
                if (routePrefs2.getFwdDropPrefs().isCommonFiber()) {
                    memberPrefs.addRequiredLinks(linkedList2);
                    continue;
                }
                memberPrefs.addPreferredLinks(linkedList2);
            }
        }
        this.vcatCircuit.addDropForNewMemberCkts();
        try {
            this.routeCurrentDrop(this.vcatCircuit.getPrimaryDrop().getNetElement(), routePrefs2, true, this.vcatCircuit.getNewMemberCkts());
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDropForNewMemberCkts();
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDropForNewMemberCkts();
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDropForNewMemberCkts();
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDropForNewMemberCkts();
            throw sanityCheckFailed;
        }
    }

    protected void deleteDropForNewMemberCkts() throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block5: {
            try {
                List list = this.vcatCircuit.getNewMemberCkts();
                for (NetCcatCircuit netCcatCircuit : list) {
                    netCcatCircuit.deleteDrop(this.vcatCircuit.getPrimaryDrop());
                    INetCircuitEnd iNetCircuitEnd = this.vcatCircuit.getSecondaryDrop();
                    if (iNetCircuitEnd == null) continue;
                    netCcatCircuit.deleteDrop(iNetCircuitEnd);
                }
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (NetVcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!NetVcatCircuitOperator.dbgOn()) break block5;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        NetVcatCircuit netVcatCircuit = this.vcatCircuit;
        synchronized (netVcatCircuit) {
            this.deleteDropCktEnd(iNetCircuitEnd);
        }
        this.vcatCircuit.notifyChanged();
    }

    protected void deleteDropCktEnd(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        int n = this.vcatCircuit.getState();
        if (n != 0 && n != 1 && n != 3) {
            throw new IncorrectCircuitState("A circuit drop can be deleted only when its status \nis CREATING, DISCOVERED, DISCOVERED_TL1, or DROP_PENDING.");
        }
        NetCircuitDropInfo netCircuitDropInfo = null;
        Iterator iterator = this.vcatCircuit.getCktDrops().iterator();
        while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals((NetCircuitEnd)iNetCircuitEnd)) {
            netCircuitDropInfo = null;
        }
        if (netCircuitDropInfo == null) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("deleteDrop: unable to find drop");
            }
            throw new ObjNotFound("The drop to be deleted cannot be found.");
        }
        if (n == 1 && this.vcatCircuit.getDropsSize() == 1) {
            throw new CannotDeleteLastDrop("The last circuit drop cannot be deleted. \nPlease destroy the circuit instead.");
        }
        int n2 = netCircuitDropInfo.getNetCktEnd().getStage();
        if (n == 3 && n2 != 2) {
            throw new CircuitDropOutstanding("An existing drop cannot be deleted when another drop is pending.");
        }
        ((NetVcatGroup)this.vcatCircuit.getForwardVcatGroup()).deleteDrop(iNetCircuitEnd);
        if (n2 != 2) {
            try {
                this.vcatCircuit.circuitModel().delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (NetVcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw cannotDeleteLastDrop;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetVcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw abstractCmsIOException;
            }
        }
        NetVcatTermination netVcatTermination = (NetVcatTermination)this.vcatCircuit.getVcatTermFromCktEnd(netCircuitDropInfo.getNetCktEnd());
        ((NetVcatGroup)this.vcatCircuit.getForwardVcatGroup()).removeVcatTermination(netVcatTermination);
        this.vcatCircuit.removeDrop(netCircuitDropInfo);
        if (this.vcatCircuit.getDropsSize() > 0 && n == 3) {
            this.vcatCircuit.setState(1);
        }
        if (this.vcatCircuit.getCircuitInfo() != null) {
            this.vcatCircuit.getCircuitInfo().setDropInfo(new ICircuitDropInfo[0]);
        }
    }

    protected void sanityCheck() throws SanityCheckFailed {
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("The circuit was already destroyed.");
        }
        for (NetCcatCircuit netCcatCircuit : this.vcatCircuit.getAllMemberCircuits()) {
            if (netCcatCircuit.getState() != 0) continue;
            netCcatCircuit.sanityCheck();
        }
    }

    public void sanityCheckManualRouting() throws SanityCheckFailed {
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("The circuit was already destroyed.");
        }
        List list = this.vcatCircuit.getNewMemberCkts();
        NetCcatCircuit netCcatCircuit = this.vcatCircuit.getLongestRoutedMember();
        if (netCcatCircuit == null) {
            netCcatCircuit = (NetCcatCircuit)list.get(0);
        }
        List list2 = this.vcatCircuit.getRefCktLinkInfo(netCcatCircuit);
        for (NetCcatCircuit netCcatCircuit2 : list) {
            try {
                netCcatCircuit2.sanityCheckManualRouting();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckFailed("The validation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n" + sanityCheckFailed.getMessage());
            }
            if (this.vcatCircuit.getVcatRoutingPref() != 1) continue;
            if (netCcatCircuit2.hasUpsrConnection() && !NetCircuit.isMemberOfBackHaulCircuit(netCcatCircuit2)) {
                throw new SanityCheckFailed("The validation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n" + "Common fiber routing does not allow member circuits " + "to be path protected.");
            }
            if (netCcatCircuit2 == netCcatCircuit || this.vcatCircuit.shareCommonFiber(netCcatCircuit2, list2)) continue;
            throw new SanityCheckFailed("The validation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n" + "Common fiber routing requires all member circuits " + "to traverse through the same set of fibers.");
        }
    }

    protected String deriveDefaultName() {
        String string = this.vcatCircuit.getSrcNodeModel().getName();
        if (string.length() > 16) {
            string = string.substring(0, 15);
        }
        int n = this.vcatCircuit.getCircuitId().getUniquePart().getUniqueId();
        String string2 = this.vcatCircuit.getCircuitTypeObj().getProtocolIndepCktTypeShortStr() + "_" + string + (n != 0 ? "_" + n : "_TL1");
        return string2;
    }

    protected boolean provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        boolean bl = false;
        int n = this.vcatCircuit.getState();
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("provision called for " + this.vcatCircuit.getCircuitName() + ". Id = " + NetVcatCircuit.prettyString(this.vcatCircuit.getCircuitId()));
        }
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new CircuitProvError("The circuit was already destroyed.");
        }
        if (n != 0 && n != 3) {
            throw new CircuitProvError("The state is invalid for provisioning operations.");
        }
        if (this.vcatCircuit.tl1Compatible()) {
            if (!this.vcatCircuit.tl1InfoActive()) {
                this.createTl1Info();
                bl = true;
            }
        } else if (!this.vcatCircuit.circuitInfoActive()) {
            this.createCircuitInfo(this.vcatCircuit.getSrcNodeModel(), this.vcatCircuit.getCircuitInfo());
            bl = true;
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("Vcat circuitInfo creation successful");
        }
        String string = null;
        NetVcatTermination netVcatTermination2 = null;
        try {
            for (NetVcatTermination netVcatTermination2 : this.vcatCircuit.getAllVcatTerms()) {
                netVcatTermination2.activate();
            }
        }
        catch (CircuitProvError circuitProvError) {
            if (string == null) {
                string = "The VCAT group creation failed on the node " + netVcatTermination2.getNodeName() + ".\n";
            }
            string = string + circuitProvError.getMessage();
        }
        if (string != null) {
            block22: {
                try {
                    if (NetVcatCircuitOperator.dbgOn()) {
                        db.println("The VCAT termination creation failed on the node " + netVcatTermination2.getNodeName() + ".");
                    }
                    this.tentative2Routed();
                }
                catch (DeletionError deletionError) {
                    if (NetVcatCircuitOperator.dbgOn()) {
                        db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                    }
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (!NetVcatCircuitOperator.dbgOn()) break block22;
                    db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                }
            }
            throw new CircuitProvError(string);
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("VcatTerms creation successful");
        }
        this.provisionCircuits(this.vcatCircuit.getAllMemberCircuits());
        if (this.vcatCircuit.tl1Compatible()) {
            this.vcatCircuit.setState(5);
            this.vcatCircuit.setTl1Compatible(false);
        } else {
            this.vcatCircuit.setState(1);
        }
        if (bl) {
            this.vcatCircuit.setServiceState(this.vcatCircuit.deriveServiceState());
            this.vcatCircuit.setProtType();
        }
        return bl;
    }

    private void provisionCircuits(List list) throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        String string = null;
        NetCcatCircuit netCcatCircuit2 = null;
        try {
            for (NetCcatCircuit netCcatCircuit2 : list) {
                netCcatCircuit2.provision();
            }
        }
        catch (NoRoute noRoute) {
            if (string == null) {
                string = "The VCAT circuit creation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n";
            }
            string = string + noRoute.getMessage();
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            if (string == null) {
                string = "The VCAT circuit creation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n";
            }
            string = string + connTypeUnsupported.getMessage();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (string == null) {
                string = "The VCAT circuit creation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n";
            }
            string = string + sanityCheckFailed.getMessage();
        }
        catch (CircuitProvError circuitProvError) {
            if (string == null) {
                string = "The VCAT circuit creation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n";
            }
            string = string + circuitProvError.getMessage();
        }
        catch (AnnotatedException annotatedException) {
            if (string == null) {
                string = "The VCAT circuit creation failed on member circuit number " + netCcatCircuit2.getMemberNumber() + ".\n";
            }
            string = string + annotatedException.getMessage();
        }
        if (string != null) {
            block28: {
                try {
                    if (NetVcatCircuitOperator.dbgOn()) {
                        db.println("member circuit creation failure on member ckt " + netCcatCircuit2.getMemberNumber() + ", call tentative2Routed");
                    }
                    this.tentative2Routed();
                }
                catch (DeletionError deletionError) {
                    if (NetVcatCircuitOperator.dbgOn()) {
                        db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                    }
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (!NetVcatCircuitOperator.dbgOn()) break block28;
                    db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                }
            }
            throw new CircuitProvError(string);
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("all member circuits creation successful");
        }
        if (this.vcatCircuit.circuitInfoActive()) {
            try {
                this.addDropToCircuitInfo();
            }
            catch (CircuitProvError circuitProvError) {
                block29: {
                    try {
                        if (NetVcatCircuitOperator.dbgOn()) {
                            db.println("Vcat circuit add drop failed, call tentative2Routed");
                        }
                        this.tentative2Routed();
                    }
                    catch (DeletionError deletionError) {
                        if (NetVcatCircuitOperator.dbgOn()) {
                            db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!NetVcatCircuitOperator.dbgOn()) break block29;
                        db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                    }
                }
                throw circuitProvError;
            }
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("Vcat circuit add drop successful");
        }
        this.tentative2Active();
    }

    protected void tentative2Routed() throws DeletionError, IncorrectCircuitState {
        Iterator iterator = this.vcatCircuit.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).tentative2Routed();
        }
        if (this.vcatCircuit.getCktOperation() == 1 && this.vcatCircuit.circuitInfoActive()) {
            this.vcatCircuit.destroyCircuitInfo();
        }
        iterator = this.vcatCircuit.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).tentative2Routed();
        }
    }

    protected void tentative2Active() {
        Iterator iterator = this.vcatCircuit.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).tentative2Active();
        }
        iterator = this.vcatCircuit.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).tentative2Active();
        }
        this.vcatCircuit.setCktOperation(0);
    }

    public void rename(String string) throws CircuitProvError {
        if (string.trim().equals("")) {
            throw new CircuitProvError("The circuit name cannot be blank.");
        }
        this.renameCircuit(string);
        this.renameVcatTerms(string);
    }

    private void renameVcatTerms(String string) throws CircuitProvError {
        Iterator iterator = this.vcatCircuit.getAllVcatTerms().iterator();
        while (iterator.hasNext()) {
            ((NetVcatTermination)iterator.next()).setVcatName(string);
        }
    }

    protected void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("destroy(" + this.vcatCircuit.getCircuitName() + ", " + NetVcatCircuit.prettyString(this.vcatCircuit.getCircuitId()) + ")");
        }
        INetCircuit[] iNetCircuitArray = this.vcatCircuit.getAllMemberCircuits().toArray(new INetCircuit[0]);
        this.deleteCircuits(iNetCircuitArray);
        String string = null;
        NetVcatTermination netVcatTermination2 = null;
        List list = this.vcatCircuit.getAllVcatTerms();
        for (NetVcatTermination netVcatTermination2 : list) {
            try {
                netVcatTermination2.deactivate();
            }
            catch (DeletionError deletionError) {
                if (string == null) {
                    string = "The VCAT group deletion failed on the node " + netVcatTermination2.getNodeName() + ".\n";
                }
                string = string + deletionError.getMessage();
            }
        }
        if (string != null) {
            throw new DeletionError(string);
        }
        if (this.vcatCircuit.circuitInfoActive()) {
            this.vcatCircuit.destroyCircuitInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCircuits(INetCircuit[] iNetCircuitArray) throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        if (iNetCircuitArray.length > 0) {
            Object object;
            for (int i = 0; i < iNetCircuitArray.length; ++i) {
                iNetCircuitArray[i].setState(2);
            }
            IJobControl[] iJobControlArray = new IJobControl[iNetCircuitArray.length];
            for (int i = 0; i < iNetCircuitArray.length; ++i) {
                iJobControlArray[i] = new NetCircuitDeleteWorker(iNetCircuitArray[i], -1);
            }
            JobController jobController = JobControllerFactory.createJC((int)iNetCircuitArray.length);
            JobGroup jobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, (Object)jobController);
            this.deleteDone = false;
            jobController.submitJob(jobGroup);
            while (!this.deleteDone) {
                object = this.threadWaitObject;
                synchronized (object) {
                    block14: {
                        try {
                            this.threadWaitObject.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!NetVcatCircuitOperator.dbgOn()) break block14;
                            db.println("provision: InterruptedException");
                        }
                    }
                }
            }
            object = null;
            DeletionError deletionError = null;
            try {
                JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                for (int i = 0; i < jobStatusArray.length; ++i) {
                    if (jobStatusArray[i].value() != 2) continue;
                    if (object == null) {
                        object = "The member circuit deletion failed.\n";
                    }
                    if ((deletionError = (DeletionError)jobStatusArray[i].getResult()) == null) continue;
                    object = (String)object + deletionError.toString();
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
            if (object != null) {
                throw new DeletionError((String)object);
            }
        }
    }

    public void provisionNewMemberCkts() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        this.vcatCircuit.setCktOperation(6);
        List list = this.vcatCircuit.getNewMemberCkts();
        this.vcatCircuit.increaseMemberCount(list.size());
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("increase member count successful");
        }
        this.provisionCircuits(list);
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("provision new member circuits successful");
        }
        this.vcatCircuit.setCktOperation(0);
        this.vcatCircuit.setChanged();
    }

    public void deleteNewMemberCkts() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        INetCircuit[] iNetCircuitArray = this.vcatCircuit.getNewMemberCkts().toArray(new INetCircuit[0]);
        this.deleteCircuits(iNetCircuitArray);
        if (this.vcatCircuit.hasNullCircuitId()) {
            if (!this.vcatCircuit.tl1CircuitCompleteCheck()) {
                this.vcatCircuit.checkAndUpdateCircuit();
            }
        } else if (!this.vcatCircuit.completeCheck()) {
            this.vcatCircuit.checkAndUpdateCircuit();
        }
        this.vcatCircuit.setChanged();
    }

    public LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("VCAT calling sanityCheckSRGs");
        }
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("The circuit was already destroyed.");
        }
        LinkedList linkedList = new LinkedList();
        List list = this.vcatCircuit.getNewMemberCkts();
        for (NetCcatCircuit netCcatCircuit : list) {
            try {
                linkedList.addAll(netCcatCircuit.sanityCheckSRGs());
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                throw new SanityCheckFailed("The validation failed on member circuit number" + netCcatCircuit.getMemberNumber() + ".\n" + sanityCheckFailed.getMessage());
            }
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("VCAT sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobGroupFinished(JobGroup jobGroup) {
        Object object = this.threadWaitObject;
        synchronized (object) {
            this.deleteDone = true;
            this.threadWaitObject.notifyAll();
            JobController jobController = (JobController)jobGroup.getUserObject();
            if (jobController.isIdle()) {
                JobControllerFactory.disposeJC((JobController)jobController);
            }
        }
    }

    protected void addOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        List list = this.vcatCircuit.getForwardVcatGroup().getAllMemberCircuits();
        if (iNetCircuitEndArray.length != list.size()) {
            throw new SanityCheckFailed("Number of Drops not matching circuit size");
        }
        int n = 0;
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("addOpenVcatDrops for open vcat called for " + iNetCircuitEndArray.length + " destinations");
        }
        this.vcatCircuit.setRoutePrefs(routePrefs);
        this.vcatCircuit.getCircuitInfo().setVcatRoutingPref(routePrefs.getFwdDropPrefs().isCommonFiber() ? 1 : 2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iNetCircuitEndArray[n] == null) {
                ++n;
                iterator.next();
                continue;
            }
            ((NetCcatCircuit)iterator.next()).addDrop(iNetCircuitEndArray[n++], routePrefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        NetVcatCircuit netVcatCircuit = this.vcatCircuit;
        synchronized (netVcatCircuit) {
            this.deleteDropCktEnd(iNetCircuitEndArray);
        }
        this.vcatCircuit.notifyChanged();
    }

    protected void deleteDropCktEnd(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        List list = this.vcatCircuit.getForwardVcatGroup().getAllMemberCircuits();
        if (iNetCircuitEndArray.length != list.size()) {
            throw new SanityCheckFailed("Number of Drops not matching circuit size");
        }
        int n = 0;
        if (!this.vcatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (NetVcatCircuitOperator.dbgOn()) {
            db.println("deleteDropCktEnd for open vcat called for " + iNetCircuitEndArray.length + " destinations");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iNetCircuitEndArray[n] == null) {
                ++n;
                iterator.next();
                continue;
            }
            ((NetCcatCircuit)iterator.next()).deleteDrop(iNetCircuitEndArray[n++]);
        }
    }

    protected void deleteDropForNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block6: {
            try {
                List list = this.vcatCircuit.getForwardVcatGroup().getMemCkts();
                Iterator iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (iNetCircuitEndArray[n] == null) {
                        ++n;
                        iterator.next();
                        continue;
                    }
                    ((NetCcatCircuit)iterator.next()).deleteDrop(iNetCircuitEndArray[n++]);
                }
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (NetVcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!NetVcatCircuitOperator.dbgOn()) break block6;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    protected void routeNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        NetCcatCircuit netCcatCircuit = this.vcatCircuit.getLongestRoutedMember();
        if (netCcatCircuit != null) {
            LinkedList linkedList = routePrefs2.getFwdDropPrefs().getMemberGroupPrefs();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                MemberPrefs memberPrefs = ((MemberGroupPrefs)iterator.next()).getMemberPrefs();
                LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
                LinkedList linkedList3 = netCcatCircuit.getRequiredSpans();
                Iterator iterator2 = linkedList3.iterator();
                while (iterator2.hasNext()) {
                    INetLink iNetLink;
                    INetLink iNetLink2 = ((INetLinkSpan)iterator2.next()).getLink();
                    if (memberPrefs.getPathProtection() == 2) {
                        linkedList2.add(iNetLink2);
                        continue;
                    }
                    if (memberPrefs.getPathProtection() == 4) {
                        if (iNetLink2.isPca()) {
                            linkedList2.add(iNetLink2);
                            continue;
                        }
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    if (iNetLink2.isPca()) {
                        iNetLink = iNetLink2.getCounterpartLink();
                        if (iNetLink == null) continue;
                        linkedList2.add(iNetLink);
                        continue;
                    }
                    linkedList2.add(iNetLink2);
                }
                if (!routePrefs2.getFwdDropPrefs().isCommonFiber()) continue;
                memberPrefs.addRequiredLinks(linkedList2);
            }
        }
        this.vcatCircuit.addDropforNewMemberCkts(iNetCircuitEndArray);
        try {
            this.routeCurrentDrop(null, routePrefs2, true, this.vcatCircuit.getNewMemberCkts());
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDropForNewMemberCkts(iNetCircuitEndArray);
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDropForNewMemberCkts(iNetCircuitEndArray);
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDropForNewMemberCkts(iNetCircuitEndArray);
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDropForNewMemberCkts(iNetCircuitEndArray);
            throw sanityCheckFailed;
        }
    }

    public void routeNewMemberCkts(INetCircuitEnd[] iNetCircuitEndArray, INetCircuitEnd[] iNetCircuitEndArray2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        try {
            this.routeNewMemberCkts(iNetCircuitEndArray, routePrefs);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            routePrefs.setSecDst(null);
            throw sanityCheckFailed;
        }
        catch (NoRoute noRoute) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (NetVcatCircuitOperator.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            throw abstractCmsIOException;
        }
        this.vcatCircuit.addDropforNewMemberCkts(iNetCircuitEndArray2);
    }
}

