/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class OchTrailTunnelNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("OchTrailTunnelNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public OchTrailTunnelNodeOperator(OchTrailTunnelNode ochTrailTunnelNode) {
        super(ochTrailTunnelNode);
    }

    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        ICircuitType iCircuitType = netCcatCircuit.getCircuitTypeObj();
        if (OchTrailTunnelNodeOperator.dbgOn()) {
            db.println("createConnection: connection type " + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + " ckt Id: " + Integer.toHexString(iCircuitId.getNodeId()) + ":" + iCircuitId.getUniquePart().getUniqueId() + " at Node " + this.getName());
        }
        try {
            this.createConnection(iCircuitId);
        }
        catch (CTCUserException cTCUserException) {
            if (OchTrailTunnelNodeOperator.dbgOn()) {
                db.println("Exception while creating OchTrail adit at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "An OCH trail adit connection could not be created on the node " + this.getName() + ".";
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            }
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (OchTrailTunnelNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL OchTrail adit reference");
            }
            throw new CircuitProvError("An error occurred while creating a connection object on the node " + this.getName() + ".");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, InvalidState {
        LinkedList linkedList = this.node.getInSpans();
        LinkedList linkedList2 = this.node.getOutSpans();
        short s = this.node.getPathWidth();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (OchTrailTunnelNodeOperator.dbgOn()) {
            db.println("Creating new OchTrail Adit at (" + this.getName() + ") " + "inCount=" + linkedList.size() + " outCount=" + linkedList2.size() + " pathWidth " + s);
        }
        if (linkedList.size() == 0 && linkedList2.size() == 0) {
            if (this.node.isSrcCoLocatedCktNode()) {
                List list;
                if (OchTrailTunnelNodeOperator.dbgOn()) {
                    db.println("OchTrail co-located Adit on src node");
                }
                if ((list = this.node.getSrcCoLocatedCktEnds()).get(0) == null) throw new CircuitProvError("The adit path definition is invalid.");
                if (OchTrailTunnelNodeOperator.dbgOn()) {
                    db.println("adding pathDefs");
                }
                arrayList.add(((NetCircuitEnd)list.get(0)).getPathDef(s));
                arrayList.add(((NetCircuitEnd)list.get(0)).getPathDef(s));
            } else {
                List list;
                if (!this.node.isDstCoLocatedCktNode()) throw new CircuitProvError("The circuit topology is incorrect.");
                if (OchTrailTunnelNodeOperator.dbgOn()) {
                    db.println("OchTrail co-located Adit on dst node");
                }
                if ((list = this.node.getDstCoLocatedCktEnds()).get(0) == null) throw new CircuitProvError("The adit path definition is invalid.");
                if (OchTrailTunnelNodeOperator.dbgOn()) {
                    db.println("adding pathDefs");
                }
                arrayList.add(((NetCircuitEnd)list.get(0)).getPathDef(s));
                arrayList.add(((NetCircuitEnd)list.get(0)).getPathDef(s));
            }
        } else {
            if (linkedList.size() != 1) throw new CircuitProvError("The number of inward spans, " + linkedList.size() + ", is invalid.");
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)linkedList.get(0);
            if (netCircuitSpan.getNetLinkSpan().getLink().getLinkType() == 10) {
                arrayList.add(netCircuitSpan.getPathDef(this.node, s));
            } else {
                arrayList.add(netCircuitSpan.getPathDef(this.node.getNetElement(), s));
            }
            if (linkedList2.size() != 1) throw new CircuitProvError("The number of outward spans, " + linkedList2.size() + ", is invalid.");
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)linkedList2.get(0);
            if (netCircuitSpan.getNetLinkSpan().getLink().getLinkType() == 10) {
                arrayList.add(netCircuitSpan2.getPathDef(this.node, s));
            } else {
                arrayList.add(netCircuitSpan2.getPathDef(this.node.getNetElement(), s));
            }
        }
        this.createOchTrailAditOnNE(iCircuitId, arrayList);
    }

    protected void createOchTrailAditOnNE(ICircuitId iCircuitId, ArrayList arrayList) throws PathInUse, InvalidPath, InvalidState {
        IOchTrailAditModel iOchTrailAditModel = null;
        this.prettyPrint((IOchncPathDefModel)arrayList.get(0), "input");
        this.prettyPrint((IOchncPathDefModel)arrayList.get(1), "output");
        IOchncPathDefModel[] iOchncPathDefModelArray = new IOchncPathDefModel[2];
        iOchncPathDefModelArray = arrayList.toArray(new IOchncPathDefModel[0]);
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        iOchTrailAditModel = iConnectionModels.createOchTrailAdit(iCircuitId, iOchncPathDefModelArray, this.node.getAdminState());
        if (iOchTrailAditModel != null) {
            this.node.setConn((IConnectionModel)iOchTrailAditModel);
        }
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        super.destroySanityCheck();
        if (!this.node.hasConnection()) {
            return;
        }
        if (((IOchTrailAditModel)this.getConn()).inUse()) {
            throw new SanityCheckFailed("The OCH trail tunnel circuit is in use.");
        }
    }

    protected void cleanupOchTrailAdits() {
        if (OchTrailTunnelNodeOperator.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        int n = 0;
        LinkedList linkedList = this.node.getInSpans();
        while (n < 3) {
            for (NetCircuitSpan netCircuitSpan : linkedList) {
                netCircuitSpan.cleanupLoAdit(this.node.getNetElement());
            }
            linkedList = ++n == 1 ? this.node.getOutSpans() : this.node.getBiSpans();
        }
    }

    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState {
        ((IOchTrailAditModel)this.getConn()).localDestroy();
    }

    protected void prettyPrint(IOchncPathDefModel iOchncPathDefModel, String string) {
        if (OchTrailTunnelNodeOperator.dbgOn()) {
            db.println(string + " OchncPathDef in Adit  " + this.prettyString(iOchncPathDefModel));
        }
    }

    protected String prettyString(IOchncPathDefModel iOchncPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchncPathDefModel.getPortEntityIdx()) + "::" + iOchncPathDefModel.getOptChannel();
    }

    protected void modifyConnection() throws CircuitProvError {
    }
}

