/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IOchCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuitEnd;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TrkAttribOperator;
import cerent.cms.route.NoRoute;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OchccCircuit
extends NetCcatCircuit
implements IOchCircuit {
    private static final SDebug db = new SDebug("OchccCircuit");
    private int specificSize;
    private ArrayList tunnelCircuits = new ArrayList();
    private TrkAttribOperator trkAttribOperator;

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.specificSize = circuitCreatInfo.specificSize();
        this.trkAttribOperator = new TrkAttribOperator(db);
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.specificSize = circuitCreatInfo.specificSize();
        for (OchccCircuitNode ochccCircuitNode : this.getCircuitNodes()) {
            ochccCircuitNode.updateSpecificSize(this.specificSize);
        }
        this.trkAttribOperator = new TrkAttribOperator(db);
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.specificSize = circuitCreatInfo.specificSize();
        this.trkAttribOperator = new TrkAttribOperator(db);
        this.clearChanged();
    }

    public INetCircuit[] getTunnelCircuits() {
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        List list = this.getCircuitSpans();
        for (INetCircuitSpan iNetCircuitSpan : list) {
            INetLink iNetLink = iNetCircuitSpan.getLink();
            if (!(iNetLink instanceof NetLink)) continue;
            arrayList.add(((NetLink)iNetLink).getLotCircuit());
        }
        return arrayList.toArray(new INetCircuit[0]);
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected OchccCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) {
        this(circuitCreatInfo);
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(circuitCreatInfo.type(), iNetElement);
        this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
        this.insertSource(netCircuitEnd);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        this.srcCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        this.insertCktNode(this.srcCircuitNode);
        this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
    }

    public TrkAttribOperator getTrkAttribOperator() {
        return this.trkAttribOperator;
    }

    public void provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        try {
            super.provision();
        }
        catch (NoRoute noRoute) {
            throw noRoute;
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            throw connTypeUnsupported;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw sanityCheckFailed;
        }
        catch (CircuitProvError circuitProvError) {
            throw circuitProvError;
        }
        catch (AnnotatedException annotatedException) {
            throw annotatedException;
        }
    }

    public void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        super.destroyCircuit();
        if (this.dbgOn()) {
            this.debug("OCHCC destroyCircuit: tunnel ckt size " + this.tunnelCircuits.size());
        }
        for (INetCircuit iNetCircuit : this.tunnelCircuits) {
            if (this.dbgOn()) {
                this.debug("OCHCC destroyCircuit: destroying (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            try {
                List list = iNetCircuit.getCircuitNodes();
                Iterator iterator = list.iterator();
                NetCircuitNode netCircuitNode = null;
                OchTrailTunnelNode ochTrailTunnelNode = null;
                boolean bl = false;
                if (((OchncCircuit)iNetCircuit).isDCNCircuit()) {
                    bl = false;
                    if (this.dbgOn()) {
                        this.debug("OCHCC destroyCircuit: not possible to destroy a DCN circuit (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
                    }
                } else {
                    boolean bl2 = bl = list.size() > 0;
                }
                while (bl && iterator.hasNext()) {
                    netCircuitNode = (NetCircuitNode)iterator.next();
                    if (netCircuitNode instanceof OchTrailTunnelNode) {
                        ochTrailTunnelNode = (OchTrailTunnelNode)netCircuitNode;
                    } else {
                        if (!(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
                        ochTrailTunnelNode = (OchTrailTunnelNode)((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode();
                    }
                    try {
                        if (ochTrailTunnelNode == null || !ochTrailTunnelNode.inUse()) continue;
                        if (this.dbgOn()) {
                            this.debug("OCHCC destroyCircuit: ochTrailAdit is in USE " + ochTrailTunnelNode.getName());
                        }
                        bl = false;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!this.dbgOn()) continue;
                        this.debug("OCHCC destroyCircuit: the OchTrailAdit is no longer accessible.");
                    }
                }
                if (!bl) continue;
                if (this.dbgOn()) {
                    this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + " is being deleted");
                }
                iNetCircuit.destroyCircuit();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + incorrectCircuitState);
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + sanityCheckFailed);
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) continue;
                this.debug("OCHCC destroyCircuit: (" + iNetCircuit.getCircuitName() + ", " + OchccCircuit.prettyString(iNetCircuit.getCircuitId()) + deletionError);
            }
        }
    }

    public synchronized void addTunnelCircuit(INetCircuit iNetCircuit) {
        this.tunnelCircuits.add(iNetCircuit);
    }

    protected boolean validateCircuitTopology() {
        if (this.dbgOn()) {
            db.println("validateCircuitTopology: Circuit has " + this.getCktNodeListSize() + " nodes " + this.getDropsSize() + " drops " + this.getSourcesSize() + " sources");
        }
        if (this.getCircuitTypeObj().isOchccCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("Circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        return super.validateCircuitTopology();
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        super.getNodeLevelSourcesAndDrops(list, list2);
        if (this.circuitInfoActive()) {
            return;
        }
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            try {
                if (netCircuitNode.getPathList().size() != 1) continue;
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), netCircuitNode.getNetElement());
                if (list.size() == 0) {
                    if (this.dbgOn()) {
                        db.println("OCHCC ITU TL1, Added node level source");
                    }
                    list.add(netCircuitEnd);
                    continue;
                }
                if (this.dbgOn()) {
                    db.println("OCHCC ITU TL1, Added node level drop");
                }
                list2.add(netCircuitEnd);
            }
            catch (Exception exception) {
                if (!this.dbgOn()) continue;
                db.println("OchccCircuit.getNodeLevelSourcesAndDrops: circuit is being deleted");
            }
        }
    }

    public ICircuitSize getCircuitSizeObj() {
        return CircuitSize.SIZE_OCHCC;
    }

    public int getCircuitSize() {
        return CircuitSize.SIZE_OCHCC.value();
    }

    public int getSpecificSize() {
        if (this.specificSize == 0 && this.getSrcCircuitNode() != null) {
            this.specificSize = ((OchccCircuitNode)this.getCircuitNodes().get(0)).getPathWidth();
        }
        return this.specificSize;
    }

    public INetCircuitEnd getEndPointForItuOchcc(INetElement iNetElement) {
        OchccCircuitEnd ochccCircuitEnd = null;
        INetCircuitNode iNetCircuitNode = null;
        List list = this.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 1 && this.dbgOn()) {
                db.println("Error !! Ochcc MXPN not supported");
            }
            iNetCircuitNode = (INetCircuitNode)list.get(0);
        }
        IConnectionModel iConnectionModel = null;
        if (iNetCircuitNode != null) {
            iConnectionModel = iNetCircuitNode.getConn();
        }
        if (iConnectionModel != null && iConnectionModel instanceof IOchccConnectionModel) {
            Object object;
            int n;
            block7: {
                n = 0;
                try {
                    if (this.getState() != 2) {
                        object = ((IOchccConnectionModel)iConnectionModel).getPaths();
                        n = object[0].getPortEntityIdx();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block7;
                    db.println("exception while retrieving OchccConnectionModel.Paths attributesetting entity index as 0");
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            object = new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0);
            ochccCircuitEnd = new OchccCircuitEnd(iNetElement.getNodeModel(), (ICircuitEnd)object);
        }
        return ochccCircuitEnd;
    }

    public OchTrailAttrsHelper.TrunkInfo getSrcTrunkInfo() {
        return this.getTrkAttribOperator().getSrcTrunkInfo();
    }

    public OchTrailAttrsHelper.TrunkInfo getDropTrunkInfo() {
        return this.getTrkAttribOperator().getDropTrunkInfo();
    }

    public void applyTrunkPortsInfo() throws Exception {
        try {
            this.getTrkAttribOperator().applyAll();
        }
        catch (Exception exception) {
            block4: {
                try {
                    this.getTrkAttribOperator().restoreAll();
                }
                catch (Exception exception2) {
                    if (!db.on()) break block4;
                    db.println("Exception in restoreTrunkPortsInfo");
                    SDebug.printStackTrace((Throwable)exception2);
                }
            }
            throw exception;
        }
    }

    public void restoreTrunkPortsInfo() throws Exception {
        this.getTrkAttribOperator().restoreAll();
    }

    public String getTrunksInUseMsg() {
        return this.getTrkAttribOperator().getTrunksInUseMsg();
    }

    public List getRegenTrunkEntityModels() {
        LinkedList linkedList = new LinkedList();
        for (NetCircuitSpan netCircuitSpan : this.getCircuitSpans()) {
            INetCircuit iNetCircuit = this.findOchTrailTunnel(netCircuitSpan.getLink());
            if (iNetCircuit == null) continue;
            linkedList.addAll(((IOchCircuit)((Object)iNetCircuit)).getRegenTrunkEntityModels());
        }
        return linkedList;
    }

    public INetCircuit findOchTrailTunnel(INetLink iNetLink) {
        INetCircuit iNetCircuit = null;
        if (iNetLink instanceof OchTrailTunnelNetLink) {
            OchTrailTunnelNetLink ochTrailTunnelNetLink = (OchTrailTunnelNetLink)iNetLink;
            iNetCircuit = ochTrailTunnelNetLink.getLotCircuit();
        }
        return iNetCircuit;
    }
}

