/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitNodeOperator;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OchccCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchccCircuitNode");
    private IOchccConnectionModel ochccConn;
    protected OchccCircuitNodeOperator operator;

    public OchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit) {
        super(iNetElement, ochccCircuit);
        if (this.dbgOn()) {
            db.println("instantiate OchccNode");
        }
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochccCircuit.getSpecificSize();
        this.operator = new OchccCircuitNodeOperator(this);
    }

    public OchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, ochccCircuit, object);
        this.ne = iNetElement;
        this.connName = this.getConnNameFromNE();
        ochccCircuit.setChanged();
        this.pathWidth = (short)this.ochccConn.getPaths()[0].getService();
        this.operator = new OchccCircuitNodeOperator(this);
    }

    public void updateSpecificSize(int n) {
        this.pathWidth = (short)n;
    }

    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    public int getClientPortNumber() {
        int n = 0;
        List list = this.getPathList();
        INodeModel iNodeModel = this.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        for (int i = 0; i < list.size(); ++i) {
            IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)list.get(i);
            int n2 = iOchccPathDefModel.getPortEntityIdx();
            try {
                int[] nArray;
                IEntityModel iEntityModel = null;
                if (iEntityTableModel != null) {
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(n2);
                }
                if (iEntityModel == null || !(iEntityModel instanceof IDwdmPortModel) || !((IDwdmPortModel)iEntityModel).isClientPort() || (nArray = ((IDwdmPortModel)iEntityModel).getPortNum()) == null || nArray.length <= 0) continue;
                if (this.dbgOn()) {
                    this.debug("getClientPortNumber: " + Integer.toHexString(nArray[0]));
                }
                return nArray[0];
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.dbgOn()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return n;
    }

    public IEntityModel getClientPortModel() {
        IEntityModel iEntityModel = null;
        List list = this.getPathList();
        INodeModel iNodeModel = this.getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        for (int i = 0; i < list.size(); ++i) {
            IOchccPathDefModel iOchccPathDefModel = (IOchccPathDefModel)list.get(i);
            int n = iOchccPathDefModel.getPortEntityIdx();
            try {
                IEntityModel iEntityModel2 = null;
                if (iEntityTableModel != null) {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n);
                }
                if (iEntityModel2 == null || !(iEntityModel2 instanceof IDwdmPortModel) || !((IDwdmPortModel)iEntityModel2).isClientPort()) continue;
                return iEntityModel2;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.dbgOn()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return iEntityModel;
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("OchccCircuitNode conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString(IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        if (this.connType == 1) {
            if (this.numberOfPaths == 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
            } else if (this.numberOfPaths == 1) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
            } else if (this.dbgOn()) {
                db.println("OchccCircuitNode conformToPath: invalid TWOWAY");
            }
        } else if (this.connType == 19) {
            if (this.numberOfPaths == 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
            } else if (this.dbgOn()) {
                db.println("OchccCircuitNode conformToPath: invalid OCHTRAIL_SPLITTER");
            }
        } else if (this.dbgOn()) {
            db.println("OchccCircuitNode conformToPath: unsupported connection type");
        }
    }

    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("addSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        this.spliceListeners.add(spliceListenerEntry);
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.ORIGINATING);
        SpliceListener spliceListener = new SpliceListener(null, null, 0, this, true);
        SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        this.addAditListener(spliceListenerEntry2);
        spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.TERMINATING);
        spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        this.addAditListener(spliceListenerEntry2);
    }

    protected void removeSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        boolean bl;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        if (!(bl = this.spliceListeners.remove(spliceListenerEntry)) && this.dbgOn()) {
            this.debug("WARNING! spliceListener not found in list");
        }
        if (spliceListenerEntry.spliceListener.loAdit) {
            return;
        }
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.ORIGINATING);
        SpliceListener spliceListener = new SpliceListener(null, null, 0, this, true);
        SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        bl = this.spliceListeners.remove(spliceListenerEntry2);
        if (bl) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
        if (bl = this.spliceListeners.remove(spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.TERMINATING), spliceListener))) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected int findConnType() {
        int n;
        int n2;
        int n3 = this.countNumInputs();
        int n4 = n3 + (n2 = this.countNumOutputs()) + (n = this.countNumOmniSpans());
        if (n4 == 1) {
            if (n3 == 1 || n2 == 1) {
                return 1;
            }
        } else if (n4 == 2) {
            if (n3 == 1 && n2 == 1) {
                return 1;
            }
        } else if (n4 == 3 && (n3 == 2 && n2 == 1 || n3 == 1 && n2 == 2)) {
            return 19;
        }
        if (this.dbgOn()) {
            db.println("Warning! findConnType: Unknown Conn. Type, node: " + this.getName() + " total=" + n4 + " in: " + n3 + " out: " + n2 + " omni: " + n);
        }
        return 22;
    }

    protected int getConnTypeFromConnModel() {
        IOchccConnectionModel iOchccConnectionModel = this.ochccConn;
        if (iOchccConnectionModel != null) {
            return iOchccConnectionModel.getConnectionType();
        }
        return 22;
    }

    protected int getConnDir() {
        return 1;
    }

    protected Object[] getPathsFromConnModel() {
        IOchccConnectionModel iOchccConnectionModel = this.ochccConn;
        if (iOchccConnectionModel != null) {
            return iOchccConnectionModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.getConnectionCircuitId();
        if (this.ochccConn != null) {
            this.ochccConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (iCircuitId2 == null || iCircuitId2.getNodeId() == 0 && iCircuitId2.getUniquePart().getUniqueId() == 0) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.ochccConn);
            }
        }
    }

    protected void disposeSpans() {
        if (this.dbgOn()) {
            db.println("disposeSpans at node " + this.getName());
        }
        for (int i = 0; i < this.biSpans.size(); ++i) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.get(i);
            if (!(netCircuitSpan.getLink() instanceof OchTrailTunnelNetLink)) continue;
            OchTrailTunnelNetLink ochTrailTunnelNetLink = (OchTrailTunnelNetLink)netCircuitSpan.getLink();
            INetCircuit iNetCircuit = ochTrailTunnelNetLink.getLotCircuit();
            ((OchccCircuit)this.getCircuit()).addTunnelCircuit(iNetCircuit);
            if (!this.dbgOn()) continue;
            db.println("disposeSpans: saved the reference to the underneath ckt tunnel");
        }
        super.disposeSpans();
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.ochccConn != null) {
            return this.ochccConn.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    public IConnectionModel getConn() {
        return this.ochccConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochccConn = (IOchccConnectionModel)iConnectionModel;
    }

    protected String prettyString(IOchccPathDefModel iOchccPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchccPathDefModel.getPortEntityIdx());
    }

    protected void setupConnListOnDiscovery() {
        this.connections = new LinkedList();
    }

    protected void prettyPrint(IOchccPathDefModel[] iOchccPathDefModelArray, String string) {
        for (int i = 0; i < iOchccPathDefModelArray.length; ++i) {
            if (!this.dbgOn()) continue;
            db.println(string + " OchCcPath #" + i + " " + this.prettyString(iOchccPathDefModelArray[i]));
        }
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return 0;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected void modifyConnection() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> modifyConnection @ Node " + this.getName());
        }
    }

    protected boolean hasUnprotectedDrop() {
        if (this.connType == 19) {
            return false;
        }
        return super.hasUnprotectedDrop();
    }

    public boolean isOchccCircuitNode() {
        return true;
    }

    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    protected void debug(String string) {
        db.println(string);
    }
}

