/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.WrongNetworkType;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.OchccCircuitEnd;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchccCircuitSpan;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OchccCircuitNodeOperator
extends NetCircuitNodeOperator {
    private static final SDebug db = new SDebug("OchccCircuitNodeOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public OchccCircuitNodeOperator(OchccCircuitNode ochccCircuitNode) {
        super(ochccCircuitNode);
    }

    protected void createConnection() throws CircuitProvError {
        ICircuitId iCircuitId = this.node.getCircuitId();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        ICircuitType iCircuitType = netCcatCircuit.getCircuitTypeObj();
        if (OchccCircuitNodeOperator.dbgOn()) {
            db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(iCircuitId));
        }
        try {
            this.createConnection(iCircuitId);
        }
        catch (CTCUserException cTCUserException) {
            if (OchccCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "A connection cannot be created on the node " + this.getName() + ".";
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nThe path is already in use.";
            } else if (cTCUserException instanceof WrongNetworkType) {
                string = string + "\nNetwork type is \"Not-DWDM\". Can't create OCHCC";
            }
            this.cleanupOchTrailAdits();
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (OchccCircuitNodeOperator.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "A connection cannot be created on the node " + this.getName() + ".";
            string = string + "\n" + adminStateProvisioningError.getMessage();
            this.cleanupOchTrailAdits();
            throw new CircuitProvError(string);
        }
        if (this.getConn() == null) {
            if (OchccCircuitNodeOperator.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError(ErrorMsg.getString((EID)NEMC.EID_ERROR_CONNECTION_OBJECT_PARAM_1, (Object)this.getName()) + this.getName());
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths, WrongNetworkType {
        this.prettyPrint(arrayList.toArray(new IOchccPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IOchccPathDefModel[0]), "output");
        IOchccPathDefModel[][] iOchccPathDefModelArrayArray = new IOchccPathDefModel[][]{arrayList.toArray(new IOchccPathDefModel[0]), arrayList2.toArray(new IOchccPathDefModel[0])};
        this.createOchccConnOnNE(iCircuitId, iOchccPathDefModelArrayArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOchccConnOnNE(ICircuitId iCircuitId, IOchccPathDefModel[][] iOchccPathDefModelArray, int n, int n2) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths, WrongNetworkType {
        IOchccConnectionModel iOchccConnectionModel = null;
        int n3 = this.node.getConnectionType();
        NetCcatCircuit netCcatCircuit = this.getCircuit();
        IOchccPathDefModel[] iOchccPathDefModelArray2 = iOchccPathDefModelArray[0];
        IOchccPathDefModel[] iOchccPathDefModelArray3 = iOchccPathDefModelArray[1];
        IOchccPathDefModel[] iOchccPathDefModelArray4 = null;
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.node.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.node.getConnName());
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        IConnectionModels iConnectionModels = this.node.getNodeModel().getConnectionModels();
        if (OchccCircuitNodeOperator.dbgOn()) {
            db.println("createOchccConnOnNE:connType=" + EnumStrings.getString(IConnectionType.class, (int)n3));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            if (n3 == 1) {
                iOchccPathDefModelArray4 = iOchccPathDefModelArray2.length == 0 ? new IOchccPathDefModel[]{iOchccPathDefModelArray3[0]} : (iOchccPathDefModelArray3.length == 0 ? new IOchccPathDefModel[]{iOchccPathDefModelArray2[0]} : new IOchccPathDefModel[]{iOchccPathDefModelArray2[0], iOchccPathDefModelArray3[0]});
                iOchccConnectionModel = iConnectionModels.createOchccConnection(iCircuitId, n3, iOchccPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else if (n3 == 19) {
                iOchccPathDefModelArray4 = new IOchccPathDefModel[3];
                if (n == 2) {
                    iOchccPathDefModelArray4[0] = iOchccPathDefModelArray2[0];
                    iOchccPathDefModelArray4[1] = iOchccPathDefModelArray2[1];
                    iOchccPathDefModelArray4[2] = iOchccPathDefModelArray3[0];
                } else if (n2 == 2) {
                    iOchccPathDefModelArray4[0] = iOchccPathDefModelArray3[0];
                    iOchccPathDefModelArray4[1] = iOchccPathDefModelArray3[1];
                    iOchccPathDefModelArray4[2] = iOchccPathDefModelArray2[0];
                } else {
                    if (OchccCircuitNodeOperator.dbgOn()) {
                        db.println("Warning! createOchccConn: bad SPLITTER case");
                    }
                    return;
                }
                iOchccConnectionModel = iConnectionModels.createOchccConnection(iCircuitId, n3, iOchccPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else {
                if (OchccCircuitNodeOperator.dbgOn()) {
                    db.println("Circuit Node: createOchccConnOnNE Unknown connection type " + n3);
                }
                return;
            }
            if (iOchccConnectionModel != null) {
                this.node.setConn((IConnectionModel)iOchccConnectionModel);
                if (NetCcatCircuit.isNullCircuitId(iCircuitId) && iOchccConnectionModel != null) {
                    this.node.registerNullCircuitConnection(this.node.getNetElement(), iOchccConnectionModel);
                }
            }
        }
    }

    private void cleanupOchTrailAdits() {
        int n;
        if (OchccCircuitNodeOperator.dbgOn()) {
            db.println("Cleanup OchTrail Adits auto-created at " + this.getName());
        }
        List list = this.node.getSources();
        for (n = 0; n < 2; ++n) {
            for (Object object : list) {
                ((OchccCircuitEnd)object).cleanupOchTrailAdit();
            }
            list = this.node.getDrops();
        }
        n = 0;
        list = this.node.getInSpans();
        while (n < 3) {
            for (Object object : list) {
                ((OchccCircuitSpan)object).cleanupOchTrailAdit(this.node.getNetElement());
            }
            list = ++n == 1 ? this.node.getOutSpans() : this.node.getBiSpans();
        }
    }

    protected void connLocalDestroy(boolean bl) throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, VcatMemberInvalidState {
        ((IOchccConnectionModel)this.getConn()).localDestroy();
    }

    protected String prettyString(IOchccPathDefModel iOchccPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchccPathDefModel.getPortEntityIdx());
    }

    protected void prettyPrint(IOchccPathDefModel[] iOchccPathDefModelArray, String string) {
        for (int i = 0; i < iOchccPathDefModelArray.length; ++i) {
            if (!OchccCircuitNodeOperator.dbgOn()) continue;
            db.println(string + " OchccPath #" + i + " " + this.prettyString(iOchccPathDefModelArray[i]));
        }
    }
}

