/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.ITdmModuleModel;
import cerent.cms.model.NotSupportedOnEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.RollManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetLink;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.IAsyncObserver;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import cerent.util.SdhAu4HoNum;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PortGrouping
extends CmsObservable
implements IAsyncObserver {
    private static final SDebug db = new SDebug("PortGrouping");
    private static final int VC3_CIRCUIT_NUM_IN_PG = 3;
    private static final int UNINITIATED = 0;
    private static final int CREATING = 1;
    private static final int DELETING = 2;
    private static PortGrouping singleton;
    private int state = 0;
    private INodeModel srcNode;
    private INodeModel dstNode;
    private IEntityModel srcEntity;
    private IEntityModel dstEntity;
    private short srcPGNum;
    private short dstPGNum;
    private INetCircuit[] vc3Circuits;
    private List tunnelCircuits;
    SdhAu4HoNum srcHo;
    SdhAu4HoNum dstHo;
    private boolean isAsyncDeletionComplete;
    private Object isAsyncDeletionCompleteLock = new Object();

    private PortGrouping() {
    }

    public static PortGrouping getInstance() {
        if (singleton == null) {
            singleton = new PortGrouping();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClear() {
        Class<PortGrouping> clazz = PortGrouping.class;
        synchronized (PortGrouping.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInCreation() {
        Class<PortGrouping> clazz = PortGrouping.class;
        synchronized (PortGrouping.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInDeletion() {
        Class<PortGrouping> clazz = PortGrouping.class;
        synchronized (PortGrouping.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 2;
        }
    }

    private void init() throws PortGroupDuplicateAccessException {
        if (!this.isClear()) {
            throw new PortGroupDuplicateAccessException("The port grouping state is not clear. Please try again later.");
        }
        this.vc3Circuits = new INetCircuit[3];
        this.tunnelCircuits = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        this.dstNode = null;
        this.srcNode = null;
        this.dstEntity = null;
        this.srcEntity = null;
        this.dstPGNum = 0;
        this.srcPGNum = 0;
        this.vc3Circuits = null;
        this.tunnelCircuits = null;
        Class<PortGrouping> clazz = PortGrouping.class;
        synchronized (PortGrouping.class) {
            this.state = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void init(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) throws PortGroupDuplicateAccessException, ObjNotFound {
        this.init();
        this.srcNode = iNetCircuitEnd.getNodeModel();
        this.dstNode = iNetCircuitEnd2.getNodeModel();
        this.srcEntity = iNetCircuitEnd.getEntityModel();
        this.dstEntity = iNetCircuitEnd2.getEntityModel();
        this.srcHo = (SdhAu4HoNum)iNetCircuitEnd.getHoNum();
        this.dstHo = (SdhAu4HoNum)iNetCircuitEnd2.getHoNum();
        this.srcPGNum = PortGrouping.getPGNum((IHoNum)this.srcHo);
        this.dstPGNum = PortGrouping.getPGNum((IHoNum)this.dstHo);
        if (PortGrouping.dbgOn()) {
            db.println("srcNode = " + this.srcNode + "\t" + "dstNode = " + this.dstNode + "\n" + "srcEntity = " + this.srcEntity + "\t" + "dstEntity = " + this.dstEntity + "\n" + "srcPGNum = " + this.srcPGNum + "\t" + "dstPGNum = " + this.dstPGNum + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List initForCreation(String string, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, RoutePrefs routePrefs, IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl, int n, boolean bl2, boolean bl3) throws ObjNotFound, AnnotatedException {
        boolean bl4 = false;
        try {
            Object object;
            try {
                this.init(iNetCircuitEnd, iNetCircuitEnd2);
                if (PortGrouping.dbgOn()) {
                    db.println("PortGrouping: create port group for creating");
                }
                object = PortGrouping.class;
                synchronized (PortGrouping.class) {
                    this.state = 1;
                    // ** MonitorExit[var13_13] (shouldn't be in output)
                    this.createPortGroupingVc3Circuits(string, routePrefs, iRevertiveBehavior, s, s2, bl, n, bl2, bl3);
                    object = this.getCircuitsInPortGroup();
                    Object var16_15 = null;
                    if (bl4) return object;
                }
            }
            catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                bl4 = true;
                throw portGroupDuplicateAccessException;
            }
            {
                this.dispose();
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (bl4) throw throwable;
            this.dispose();
            throw throwable;
        }
    }

    private static boolean isSameHo(IHoNum iHoNum, IHoNum iHoNum2) {
        return iHoNum == null && iHoNum2 == null || iHoNum != null && iHoNum.equals(iHoNum2);
    }

    private static boolean isSameHoCktEnd(IEntityModel iEntityModel, IHoNum iHoNum, INetCircuitEnd iNetCircuitEnd) throws ObjNotFound {
        IEntityModel iEntityModel2 = iNetCircuitEnd.getEntityModel();
        IHoNum iHoNum2 = iNetCircuitEnd.getHoLoNum().getHoNum();
        return iEntityModel2.equals(iEntityModel) && PortGrouping.isSameHo(iHoNum, iHoNum2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForDeletion(INetCircuit iNetCircuit) throws ObjNotFound {
        this.init(iNetCircuit.getPrimarySource(), (INetCircuitEnd)((NetCircuit)iNetCircuit).getCktDrops().get(0));
        if (PortGrouping.dbgOn()) {
            db.println("PortGrouping: create port group for deleting");
        }
        Class<PortGrouping> clazz = PortGrouping.class;
        synchronized (PortGrouping.class) {
            this.state = 2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.findCircuitsInPortGroup(iNetCircuit);
            return;
        }
    }

    private void initForRetrieval(INetCircuit iNetCircuit) throws ObjNotFound {
        this.init(iNetCircuit.getPrimarySource(), (INetCircuitEnd)((NetCircuit)iNetCircuit).getCktDrops().get(0));
        if (PortGrouping.dbgOn()) {
            db.println("PortGrouping: create port group for retrieving");
        }
        this.findCircuitsInPortGroup(iNetCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List initForBridgeAndRoll(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, INetCircuit iNetCircuit, RoutePrefs routePrefs) throws ObjNotFound, AnnotatedException {
        boolean bl = false;
        try {
            Object object;
            try {
                this.init(iNetCircuitEnd, iNetCircuitEnd2);
                if (PortGrouping.dbgOn()) {
                    db.println("PortGrouping: create port group for creating");
                }
                object = PortGrouping.class;
                synchronized (PortGrouping.class) {
                    this.state = 1;
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    object = NetCircuitManager.instance().createLoTunnel(iNetCircuit, iNetCircuitEnd2, routePrefs, true);
                    Object var9_9 = null;
                    if (bl) return object;
                }
            }
            catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                bl = true;
                throw portGroupDuplicateAccessException;
            }
            catch (Exception exception) {
                bl = true;
                throw new AnnotatedException("An error occurred while creating an LO tunnel.", exception);
            }
            {
                this.dispose();
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (bl) throw throwable;
            this.dispose();
            throw throwable;
        }
    }

    private void findCircuitsInPortGroup(INetCircuit iNetCircuit) throws ObjNotFound {
        Object object;
        Object object22;
        List list = NetCircuitManager.instance().getCircuits();
        this.vc3Circuits[0] = iNetCircuit;
        int n = 1;
        for (Object object22 : list) {
            if (object22 == null || !((NetCircuit)object22).isCircuitRefValid() || ((NetCircuit)object22).getCircuitSize() != 11 || object22 == iNetCircuit) continue;
            try {
                INetCircuitEnd iNetCircuitEnd = ((NetCircuit)object22).getPrimarySource();
                if (((NetCircuit)object22).getCktDrops() == null || ((NetCircuit)object22).getCktDrops().isEmpty()) continue;
                object = (INetCircuitEnd)((NetCircuit)object22).getCktDrops().get(0);
                if (iNetCircuitEnd == null || object == null || this.srcNode != iNetCircuitEnd.getNodeModel() || this.dstNode != object.getNodeModel() || !PortGrouping.isSameHoCktEnd(this.srcEntity, (IHoNum)this.srcHo, iNetCircuitEnd) || !PortGrouping.isSameHoCktEnd(this.dstEntity, (IHoNum)this.dstHo, (INetCircuitEnd)object)) continue;
                if (PortGrouping.dbgOn()) {
                    db.println("found a PG vc3 circuit: " + object22);
                }
                if (n < this.vc3Circuits.length) {
                    this.vc3Circuits[n++] = object22;
                    continue;
                }
                db.severe("Severe warning: Exists more then 3 VC3 circuits for one port group - the deletion may be incomplete.");
            }
            catch (ObjNotFound objNotFound) {
                if (!PortGrouping.dbgOn()) continue;
                SDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        if (this.srcNode == this.dstNode) {
            return;
        }
        List list2 = iNetCircuit.getCircuitSpans();
        if (list2.isEmpty()) {
            return;
        }
        object22 = list2.iterator();
        block3: while (object22.hasNext()) {
            object = (INetCircuitSpan)object22.next();
            INetLink iNetLink = object.getLink();
            if (PortGrouping.dbgOn()) {
                db.println("circuit span link: " + iNetLink.prettyString());
            }
            boolean bl = false;
            for (INetCircuit iNetCircuit2 : list) {
                if (iNetCircuit2 == null || !iNetCircuit2.getCircuitTypeObj().isTunnelCircuitType()) continue;
                INetLink iNetLink2 = iNetCircuit2.getLotLink();
                INetLink iNetLink3 = iNetCircuit2.getReverseLotLink();
                if (PortGrouping.dbgOn()) {
                    db.println("lotLink: " + (iNetLink2 == null ? null : iNetLink2.prettyString()));
                    db.println("revLotLink: " + (iNetLink3 == null ? null : iNetLink3.prettyString()));
                }
                if (iNetLink.isLOTunnel()) {
                    if (iNetLink2 != null && ((Object)iNetLink2).equals(iNetLink) || iNetLink3 != null && ((Object)iNetLink3).equals(iNetLink)) {
                        bl = true;
                    }
                } else if (iNetLink2 != null && iNetLink2.getLinksList().contains(iNetLink) && iNetLink2.getSrcHo().equals(object.getSrcHoNum()) && iNetLink2.getDstHo().equals(object.getDstHoNum()) || iNetLink3 != null && iNetLink3.getLinksList().contains(iNetLink) && iNetLink3.getSrcHo().equals(object.getSrcHoNum()) && iNetLink3.getDstHo().equals(object.getDstHoNum())) {
                    bl = true;
                }
                if (!bl) continue;
                this.tunnelCircuits.add(iNetCircuit2);
                if (!PortGrouping.dbgOn()) continue block3;
                db.println("found a PG tunnel circuit: " + iNetCircuit2);
                continue block3;
            }
        }
    }

    private void createPortGroupingVc3Circuits(String string, RoutePrefs routePrefs, IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl, int n, boolean bl2, boolean bl3) throws AnnotatedException {
        Throwable throwable = null;
        try {
            this.setPortGroupState(true);
            this.createVc3Circuits(string, routePrefs, iRevertiveBehavior, s, s2, bl, n, bl2, bl3);
        }
        catch (AllocFailed allocFailed) {
            throwable = allocFailed;
        }
        catch (NoRoute noRoute) {
            throwable = noRoute;
        }
        catch (CircuitProvError circuitProvError) {
            throwable = circuitProvError;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throwable = sanityCheckFailed;
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            throwable = connTypeUnsupported;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            throwable = incorrectCircuitState;
        }
        catch (CircuitDropOutstanding circuitDropOutstanding) {
            throwable = circuitDropOutstanding;
        }
        catch (ObjNotFound objNotFound) {
            throwable = objNotFound;
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throwable = unsupportedOperation;
        }
        catch (ProvisionError provisionError) {
            throwable = provisionError;
        }
        catch (NotSupportedOnEquipment notSupportedOnEquipment) {
            throwable = notSupportedOnEquipment;
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
        }
        if (throwable != null) {
            if (PortGrouping.dbgOn()) {
                SDebug.printStackTrace((Throwable)throwable);
            }
            String string2 = "The port grouping circuits creation failed (please see the error message below).";
            try {
                this.deleteAllCircuits();
                string2 = string2 + "\nThe rollback operation (removing all partially created port grouping circuits) succeeded.\n";
            }
            catch (AnnotatedException annotatedException) {
                if (PortGrouping.dbgOn()) {
                    SDebug.printStackTrace((Throwable)annotatedException);
                }
                throwable = annotatedException;
                string2 = string2 + "\nThe rollback operation (removing all partially created port grouping circuits) also failed - " + throwable.getMessage() + " Please do the rollback manually.\n";
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AnnotatedException(string2, (Exception)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePGCkts(List list, boolean bl, int n, List list2) {
        try {
            Object object = this.isAsyncDeletionCompleteLock;
            synchronized (object) {
                this.isAsyncDeletionComplete = false;
            }
            NetCircuitManager.instance().deleteSelectedCircuits(list.toArray(new INetCircuit[0]), n, this);
            object = this.isAsyncDeletionCompleteLock;
            synchronized (object) {
                if (!this.isAsyncDeletionComplete) {
                    this.isAsyncDeletionCompleteLock.wait(20000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            list2.add(interruptedException);
        }
        catch (DeletionError deletionError) {
            list2.add(deletionError);
        }
        if (bl) {
            for (int i = 0; i < 10; ++i) {
                boolean bl2 = true;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!((INetCircuit)iterator.next()).isCircuitRefValid()) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return true;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (!db.on()) continue;
                    db.fine("InterruptedException: " + interruptedException);
                }
            }
            if (db.on()) {
                db.warning("Circuit still not fully deleted after 10 seconds.");
            }
        } else {
            return true;
        }
        return false;
    }

    private void deleteAllCircuits() throws AnnotatedException {
        this.deleteAllCircuits(-1);
    }

    private void deleteAllCircuits(int n) throws AnnotatedException {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        ArrayList<INetCircuit> arrayList2 = new ArrayList<INetCircuit>();
        for (int i = this.vc3Circuits.length - 1; i >= 0; --i) {
            if (this.vc3Circuits[i] == null) continue;
            arrayList2.add(this.vc3Circuits[i]);
        }
        if (!arrayList2.isEmpty()) {
            this.deletePGCkts(arrayList2, true, n, arrayList);
        }
        if (arrayList.isEmpty()) {
            try {
                this.setPortGroupState(false);
            }
            catch (UnsupportedOperation unsupportedOperation) {
                arrayList.add(unsupportedOperation);
            }
            catch (ProvisionError provisionError) {
                arrayList.add(provisionError);
            }
            catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                arrayList.add(notSupportedOnEquipment);
            }
            for (Object object : this.tunnelCircuits) {
                try {
                    IEntityModel iEntityModel = PortGrouping.getTunnelEndPort(object, true);
                    IEntityModel iEntityModel2 = PortGrouping.getTunnelEndPort(object, false);
                    arrayList2.clear();
                    arrayList2.add((INetCircuit)object);
                    if (!this.deletePGCkts(arrayList2, false, n, arrayList)) continue;
                    PortGrouping.setPortGroupState(iEntityModel, PortGrouping.getTunnelEndPgNum(object, true), false);
                    PortGrouping.setPortGroupState(iEntityModel2, PortGrouping.getTunnelEndPgNum(object, false), false);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    arrayList.add(abstractCmsNoSuchEntityException);
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    arrayList.add(unsupportedOperation);
                }
                catch (ProvisionError provisionError) {
                    arrayList.add(provisionError);
                }
                catch (NotSupportedOnEquipment notSupportedOnEquipment) {
                    arrayList.add(notSupportedOnEquipment);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            Object object;
            if (PortGrouping.dbgOn()) {
                db.println("Following are exceptions happend on 'deleteAllCircuits()':");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    SDebug.printStackTrace((Throwable)((Exception)iterator.next()));
                }
                db.println("Above are exceptions happened on 'deleteAllCircuits()'.\n");
            }
            Exception exception = (Exception)arrayList.iterator().next();
            object = new AnnotatedException("An exception happened when deleting a Port Grouping circuit. Please try to delete it later manually.", exception);
            throw object;
        }
    }

    private void createVc3Circuits(String string, RoutePrefs routePrefs, IRevertiveBehavior iRevertiveBehavior, short s, short s2, boolean bl, int n, boolean bl2, boolean bl3) throws AllocFailed, NoRoute, CircuitProvError, SanityCheckFailed, ConnTypeUnsupported, IncorrectCircuitState, CircuitDropOutstanding, ObjNotFound, AnnotatedException {
        Object object;
        int n2;
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[this.vc3Circuits.length];
        INetCircuitEnd[] iNetCircuitEndArray2 = new INetCircuitEnd[this.vc3Circuits.length];
        int n3 = 11;
        int n4 = 5;
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(n4, n3, 1, false, string, n);
        circuitCreatInfo.setTrafficDir(bl3);
        String string2 = string;
        LinkedList linkedList = new LinkedList();
        for (n2 = 0; n2 < this.vc3Circuits.length; ++n2) {
            object = HoLoFactory.createVc3SdhAu4LoNum(n2 + 1);
            iNetCircuitEndArray[n2] = new LoCircuitEnd(this.srcNode, this.srcEntity, (IHoNum)this.srcHo, (ILoNum)object, false);
            iNetCircuitEndArray2[n2] = new LoCircuitEnd(this.dstNode, this.dstEntity, (IHoNum)this.dstHo, (ILoNum)object, false);
            this.vc3Circuits[n2] = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEndArray[n2]);
            if (this.srcNode != this.dstNode && n2 == 0) {
                if (db.on()) {
                    db.println("routePerfs=" + routePrefs.prettyString());
                }
                List list = NetCircuitManager.instance().createLoTunnels(this.vc3Circuits[n2], iNetCircuitEndArray2[n2], routePrefs);
                if (PortGrouping.dbgOn()) {
                    db.println("Create " + list.size() + " tunnels");
                }
                this.setReqLinks(list, linkedList);
            }
            this.vc3Circuits[n2].addDrop(iNetCircuitEndArray2[n2], routePrefs);
            if (this.srcNode != this.dstNode) {
                this.addVc3CircuitSpans(this.vc3Circuits[n2], (ILoNum)object, linkedList);
            }
            this.vc3Circuits[n2].sanityCheck();
            this.vc3Circuits[n2].setUpsrSelectorAttributes(iRevertiveBehavior, s, s2, bl);
            this.vc3Circuits[n2].provision();
            if (n2 == 0 && string2.length() == 0) {
                string2 = this.vc3Circuits[n2].getCircuitName();
            }
            this.vc3Circuits[n2].rename(string2 + ":PGC" + (n2 + 1));
        }
        for (n2 = 0; n2 < this.tunnelCircuits.size(); ++n2) {
            object = (INetCircuit)this.tunnelCircuits.get(n2);
            object.rename(string2 + ":PGT" + (n2 + 1));
        }
        if (bl2) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.vc3Circuits.length; ++i) {
                NetCircuitModel.setAdminStateOnDropPorts(this.vc3Circuits[i], n, arrayList);
                db.info(arrayList.size() + " drop ports not set");
            }
        }
    }

    private void addVc3CircuitSpans(INetCircuit iNetCircuit, ILoNum iLoNum, List list) {
        for (INetLink iNetLink : list) {
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iLoNum);
            try {
                iNetCircuit.addCircuitSpan(netLinkSpan);
            }
            catch (NoRoute noRoute) {
                if (!PortGrouping.dbgOn()) continue;
                db.println("NoRoute exception");
            }
        }
    }

    public static boolean isPortGroupingCircuit(INetCircuit iNetCircuit) throws UnsupportedOperation, ProvisionError {
        if (iNetCircuit.getCircuitType() != 5 || iNetCircuit.getCircuitSize() != 11) {
            return false;
        }
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        NetCircuit netCircuit = (NetCircuit)iNetCircuit;
        try {
            if (netCircuit.getPrimarySource() != null) {
                iEntityModel = netCircuit.getPrimarySource().getEntityModel();
            }
            if (netCircuit.getCktDrops() != null && !netCircuit.getCktDrops().isEmpty()) {
                iEntityModel2 = ((INetCircuitEnd)netCircuit.getCktDrops().get(0)).getEntityModel();
            }
        }
        catch (ObjNotFound objNotFound) {
            if (PortGrouping.dbgOn()) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            return false;
        }
        if (iEntityModel == null || iEntityModel2 == null) {
            return false;
        }
        IHoNum iHoNum = netCircuit.getPrimarySource().getHoNum();
        IHoNum iHoNum2 = ((INetCircuitEnd)netCircuit.getCktDrops().get(0)).getHoNum();
        if (iHoNum == null || iHoNum2 == null) {
            return false;
        }
        short s = PortGrouping.getPGNum(iHoNum);
        short s2 = PortGrouping.getPGNum(iHoNum2);
        return PortGrouping.isValidElectricalCard(iEntityModel) && PortGrouping.isPortGroupStateClosed(iEntityModel, s) || PortGrouping.isValidElectricalCard(iEntityModel2) && PortGrouping.isPortGroupStateClosed(iEntityModel2, s2);
    }

    public static boolean containsPGCkts(INetCircuit[] iNetCircuitArray) throws UnsupportedOperation, ProvisionError {
        for (int i = 0; i < iNetCircuitArray.length; ++i) {
            if (!PortGrouping.isPortGroupingCircuit(iNetCircuitArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetRoll[] addPGRolls(NetRoll[] netRollArray) throws UnsupportedOperation, ProvisionError {
        LinkedList<NetRoll> linkedList = new LinkedList<NetRoll>();
        LinkedList<NetRoll> linkedList2 = new LinkedList<NetRoll>(Arrays.asList(netRollArray));
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object var14_15;
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            NetCcatCircuit netCcatCircuit = netRoll.getFromCircuit();
            if (!PortGrouping.isPortGroupingCircuit(netCcatCircuit)) continue;
            iterator.remove();
            if (linkedList.contains((Object)netRoll)) continue;
            linkedList.add(netRoll);
            PortGrouping portGrouping = PortGrouping.getInstance();
            boolean bl = false;
            try {
                try {
                    portGrouping.initForRetrieval(netCcatCircuit);
                    LinkedList<IConnectionModel> linkedList3 = new LinkedList<IConnectionModel>();
                    for (int i = 0; i < portGrouping.vc3Circuits.length; ++i) {
                        INetCircuit iNetCircuit = portGrouping.vc3Circuits[i];
                        if (iNetCircuit == null || iNetCircuit == netCcatCircuit) continue;
                        INetCircuitNode iNetCircuitNode = null;
                        List list = iNetCircuit.getCircuitNodeFromNE(netRoll.getNetElement());
                        if (list != null) {
                            if (list.size() > 1) {
                                if (PortGrouping.dbgOn()) {
                                    db.println("Error !! MXPN on vc3 circuit not supported");
                                }
                            } else {
                                iNetCircuitNode = (INetCircuitNode)list.get(0);
                            }
                        }
                        if (iNetCircuitNode == null) continue;
                        linkedList3.add(iNetCircuitNode.getConn());
                    }
                    linkedList.addAll(RollManager.instance().getRolls(linkedList3));
                }
                catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                    bl = true;
                    throw portGroupDuplicateAccessException;
                }
                catch (ObjNotFound objNotFound) {
                    if (PortGrouping.dbgOn()) {
                        SDebug.printStackTrace((Throwable)objNotFound);
                    }
                    var14_15 = null;
                    if (bl) continue;
                    portGrouping.dispose();
                    continue;
                }
                var14_15 = null;
                if (bl) continue;
                portGrouping.dispose();
            }
            catch (Throwable throwable) {
                var14_15 = null;
                if (!bl) {
                    portGrouping.dispose();
                }
                throw throwable;
            }
        }
        linkedList2.addAll(linkedList);
        return linkedList2.toArray(new NetRoll[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static INetCircuit[] removePGCkts(INetCircuit[] iNetCircuitArray, List list) throws UnsupportedOperation, ProvisionError {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>(Arrays.asList(iNetCircuitArray));
        Iterator iterator = linkedList.iterator();
        while (true) {
            block12: {
                Object var9_11;
                if (!iterator.hasNext()) {
                    return linkedList.toArray(new INetCircuit[0]);
                }
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                if (!PortGrouping.isPortGroupingCircuit(iNetCircuit)) continue;
                list.add(iNetCircuit);
                linkedList.remove(iNetCircuit);
                PortGrouping portGrouping = PortGrouping.getInstance();
                boolean bl = false;
                try {
                    try {
                        portGrouping.initForDeletion(iNetCircuit);
                        for (int i = 0; i < portGrouping.vc3Circuits.length; ++i) {
                            if (portGrouping.vc3Circuits[i] == null) continue;
                            linkedList.remove(portGrouping.vc3Circuits[i]);
                        }
                        Iterator iterator2 = portGrouping.tunnelCircuits.iterator();
                        while (iterator2.hasNext()) {
                            linkedList.remove(iterator2.next());
                        }
                        var9_11 = null;
                        if (bl) break block12;
                    }
                    catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                        bl = true;
                        throw portGroupDuplicateAccessException;
                    }
                    catch (ObjNotFound objNotFound) {
                        if (PortGrouping.dbgOn()) {
                            SDebug.printStackTrace((Throwable)objNotFound);
                        }
                        var9_11 = null;
                        if (!bl) {
                            portGrouping.dispose();
                        }
                        break block12;
                    }
                    portGrouping.dispose();
                }
                catch (Throwable throwable) {
                    var9_11 = null;
                    if (!bl) {
                        portGrouping.dispose();
                    }
                    throw throwable;
                }
            }
            iterator = linkedList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deletePortGroupingCircuits(List list, int n) throws AnnotatedException {
        AnnotatedException annotatedException = null;
        int n2 = 0;
        for (INetCircuit iNetCircuit : list) {
            Object var10_12;
            PortGrouping portGrouping = PortGrouping.getInstance();
            boolean bl = false;
            try {
                try {
                    portGrouping.initForDeletion(iNetCircuit);
                    n2 += portGrouping.getCircuitNumInPortGroup();
                    portGrouping.deleteAllCircuits(n);
                }
                catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                    bl = true;
                    throw portGroupDuplicateAccessException;
                }
                catch (ObjNotFound objNotFound) {
                    if (PortGrouping.dbgOn()) {
                        SDebug.printStackTrace((Throwable)objNotFound);
                    }
                    if (annotatedException == null) {
                        annotatedException = new AnnotatedException("An exception happened when deleting a Port Grouping circuit. Please try to delete it later manually.", (Exception)((Object)objNotFound));
                    }
                    var10_12 = null;
                    if (bl) continue;
                    portGrouping.dispose();
                    continue;
                }
                catch (AnnotatedException annotatedException2) {
                    if (annotatedException == null) {
                        annotatedException = annotatedException2;
                    }
                    var10_12 = null;
                    if (bl) continue;
                    portGrouping.dispose();
                    continue;
                }
                var10_12 = null;
                if (bl) continue;
                portGrouping.dispose();
            }
            catch (Throwable throwable) {
                var10_12 = null;
                if (!bl) {
                    portGrouping.dispose();
                }
                throw throwable;
            }
        }
        if (annotatedException != null) {
            throw annotatedException;
        }
        return n2;
    }

    protected static short getPGNum(IHoNum iHoNum) {
        return (short)((SdhAu4HoNum)iHoNum).getVc4Num();
    }

    public void setPortGroupState(boolean bl) throws UnsupportedOperation, ProvisionError, NotSupportedOnEquipment {
        PortGrouping.setPortGroupState(this.srcEntity, this.srcPGNum, bl);
        PortGrouping.setPortGroupState(this.dstEntity, this.dstPGNum, bl);
    }

    public static void setPortGroupState(IEntityModel iEntityModel, short s, boolean bl) throws UnsupportedOperation, ProvisionError, NotSupportedOnEquipment {
        IEntityModel iEntityModel2;
        if (iEntityModel == null) {
            if (PortGrouping.dbgOn()) {
                db.println("Can't set PG state due to the entity is null");
            }
            return;
        }
        short s2 = PortGrouping.calculateCardPGNum(iEntityModel, s);
        if (PortGrouping.dbgOn()) {
            db.println("Set port group to " + (bl ? "close" : "open") + " on port group number " + s2 + " on entity " + iEntityModel);
        }
        for (iEntityModel2 = iEntityModel; iEntityModel2 != null && !(iEntityModel2 instanceof IModuleModel); iEntityModel2 = iEntityModel2.getParent()) {
        }
        if (!(iEntityModel2 instanceof IModuleModel) || !Feature.provides((INodeModel)iEntityModel2.getNodeModel(), (Feature)Feature.PORT_GROUPING)) {
            throw new UnsupportedOperation("The entity " + iEntityModel + " does not " + "support the port grouping operation.");
        }
        ((IModuleModel)iEntityModel2).setPortGroupState(s2, bl);
    }

    public static void setPortGroupState(IEntityModel iEntityModel, IHoNum iHoNum, boolean bl) throws UnsupportedOperation, ProvisionError, NotSupportedOnEquipment {
        if (iHoNum == null) {
            db.println("Can't set port group state as ho object is null");
            return;
        }
        PortGrouping.setPortGroupState(iEntityModel, PortGrouping.getPGNum(iHoNum), bl);
    }

    public static void setPortGroupState(IHoPathDefModel iHoPathDefModel, boolean bl) throws AbstractCmsNoSuchEntityException, UnsupportedOperation, ProvisionError, NotSupportedOnEquipment {
        PortGrouping.setPortGroupState(iHoPathDefModel.getPool().getEntityModel(), HoPathDefModel.physicalHo(iHoPathDefModel), bl);
    }

    private static IEntityModel getTunnelEndPort(INetCircuit iNetCircuit, boolean bl) throws AbstractCmsNoSuchEntityException {
        INetLink iNetLink = iNetCircuit.getLotLink();
        if (bl) {
            if (iNetLink == null || iNetLink.getSrc() == null) {
                return null;
            }
            INodeModel iNodeModel = iNetLink.getSrc().getNodeModel();
            return iNodeModel.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex());
        }
        if (iNetLink == null || iNetLink.getDst() == null) {
            return null;
        }
        INodeModel iNodeModel = iNetLink.getDst().getNodeModel();
        return iNodeModel.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex());
    }

    private static IHoNum getTunnelEndPgNum(INetCircuit iNetCircuit, boolean bl) {
        INetLink iNetLink = iNetCircuit.getLotLink();
        if (iNetLink == null) {
            return null;
        }
        return bl ? iNetLink.getSrcHo() : iNetLink.getDstHo();
    }

    public static void setPortGroupState(INetCircuit iNetCircuit, boolean bl) throws AbstractCmsNoSuchEntityException, UnsupportedOperation, ProvisionError, NotSupportedOnEquipment {
        PortGrouping.setPortGroupState(PortGrouping.getTunnelEndPort(iNetCircuit, true), PortGrouping.getTunnelEndPgNum(iNetCircuit, true), bl);
        PortGrouping.setPortGroupState(PortGrouping.getTunnelEndPort(iNetCircuit, false), PortGrouping.getTunnelEndPgNum(iNetCircuit, false), bl);
    }

    public static boolean isPortGroupStateClosed(IEntityModel iEntityModel, short s) throws UnsupportedOperation, ProvisionError {
        if (iEntityModel instanceof IModuleModel && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.PORT_GROUPING)) {
            return ((IModuleModel)iEntityModel).isPortGroupStateClosed(s);
        }
        throw new UnsupportedOperation("The entity " + iEntityModel + " does not " + "support the port grouping operation.");
    }

    public static boolean isValidEntity(IEntityModel iEntityModel) {
        return PortGrouping.isValidElectricalCard(iEntityModel) || PortGrouping.isOpticalPort(iEntityModel);
    }

    public static boolean isValidElectricalCard(IEntityModel iEntityModel) {
        return iEntityModel instanceof IModuleModel && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.PORT_GROUPING) && ((IModuleModel)iEntityModel).isValidPGElectricalCard();
    }

    private static boolean isOpticalPort(IEntityModel iEntityModel) {
        return iEntityModel instanceof IPortModel && ((IPortModel)iEntityModel).isOptical();
    }

    private static short calculateCardPGNum(IEntityModel iEntityModel, short s) throws ProvisionError, NotSupportedOnEquipment {
        if (PortGrouping.isValidElectricalCard(iEntityModel)) {
            return s;
        }
        if (PortGrouping.isOpticalPort(iEntityModel) && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.PORT_GROUPING)) {
            int n = 1;
            if (Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.MRC_PORT_GROUPING)) {
                IHoNum iHoNum = HoLoFactory.ho2HoNum(n, s);
                ITdmModuleModel iTdmModuleModel = (ITdmModuleModel)iEntityModel.getModuleModel();
                return iTdmModuleModel.getPortGroupNumber((IPortModel)iEntityModel, iHoNum);
            }
            IPoolModel iPoolModel = iEntityModel.getNodeModel().getPoolModels().getPoolModel(iEntityModel.getEntityIndex());
            int n2 = iPoolModel.getStsCount();
            int n3 = iEntityModel.getPositionInParent();
            int n4 = (n3 - 1) * n2 + 1;
            IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n, n4);
            short s2 = PortGrouping.getPGNum(iHoNum);
            return (short)(s2 + s - 1);
        }
        throw new IllegalArgumentException("This entity is not valid for port grouping.");
    }

    private void setReqLinks(List list, List list2) throws SanityCheckFailed, ConnTypeUnsupported, NoRoute, CircuitProvError, AnnotatedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = ((LoTunnelInfo)iterator.next()).tunnel();
            this.tunnelCircuits.add(iNetCircuit);
            iNetCircuit.provision();
            if (iNetCircuit.getLotLink() == null) continue;
            if (PortGrouping.dbgOn()) {
                db.println("Add required link - " + iNetCircuit.getLotLink().prettyString());
            }
            list2.add(iNetCircuit.getLotLink());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncUpdate(Object object, JobStatus jobStatus) {
        if (db.on()) {
            db.fine("Get asyncUpdate message");
        }
        Object object2 = this.isAsyncDeletionCompleteLock;
        synchronized (object2) {
            this.isAsyncDeletionComplete = true;
            this.isAsyncDeletionCompleteLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getCircuitsInPortGroup(INetCircuit iNetCircuit) {
        try {
            if (!PortGrouping.isPortGroupingCircuit(iNetCircuit)) {
                db.severe("The given circuit is not a PG VC3 circuit.");
                return new ArrayList();
            }
        }
        catch (UnsupportedOperation unsupportedOperation) {
            if (!db.on()) return new ArrayList();
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            return new ArrayList();
        }
        catch (ProvisionError provisionError) {
            if (!db.on()) return new ArrayList();
            SDebug.printStackTrace((Throwable)provisionError);
            return new ArrayList();
        }
        PortGrouping portGrouping = PortGrouping.getInstance();
        boolean bl = false;
        try {
            List list;
            try {
                portGrouping.initForRetrieval(iNetCircuit);
                list = portGrouping.getCircuitsInPortGroup();
                Object var6_8 = null;
                if (bl) return list;
            }
            catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                bl = true;
                throw portGroupDuplicateAccessException;
            }
            catch (ObjNotFound objNotFound) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
                ArrayList arrayList = new ArrayList();
                Object var6_9 = null;
                if (bl) return arrayList;
                portGrouping.dispose();
                return arrayList;
            }
            portGrouping.dispose();
            return list;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (bl) throw throwable;
            portGrouping.dispose();
            throw throwable;
        }
    }

    public List getCircuitsInPortGroup() {
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        for (int i = 0; i < this.vc3Circuits.length; ++i) {
            if (this.vc3Circuits[i] == null) continue;
            arrayList.add(this.vc3Circuits[i]);
        }
        arrayList.addAll(this.tunnelCircuits);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getVc3CircuitsInPortGroup(INetCircuit iNetCircuit) {
        try {
            if (!PortGrouping.isPortGroupingCircuit(iNetCircuit)) {
                db.severe("The given circuit is not a PG VC3 circuit.");
                return new ArrayList();
            }
        }
        catch (UnsupportedOperation unsupportedOperation) {
            if (!db.on()) return new ArrayList();
            SDebug.printStackTrace((Throwable)unsupportedOperation);
            return new ArrayList();
        }
        catch (ProvisionError provisionError) {
            if (!db.on()) return new ArrayList();
            SDebug.printStackTrace((Throwable)provisionError);
            return new ArrayList();
        }
        PortGrouping portGrouping = PortGrouping.getInstance();
        boolean bl = false;
        try {
            List list;
            try {
                portGrouping.initForRetrieval(iNetCircuit);
                list = portGrouping.getVc3CircuitsInPortGroup();
                Object var6_8 = null;
                if (bl) return list;
            }
            catch (PortGroupDuplicateAccessException portGroupDuplicateAccessException) {
                bl = true;
                throw portGroupDuplicateAccessException;
            }
            catch (ObjNotFound objNotFound) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
                ArrayList arrayList = new ArrayList();
                Object var6_9 = null;
                if (bl) return arrayList;
                portGrouping.dispose();
                return arrayList;
            }
            portGrouping.dispose();
            return list;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (bl) throw throwable;
            portGrouping.dispose();
            throw throwable;
        }
    }

    public List getVc3CircuitsInPortGroup() {
        ArrayList<INetCircuit> arrayList = new ArrayList<INetCircuit>();
        for (int i = 0; i < this.vc3Circuits.length; ++i) {
            arrayList.add(this.vc3Circuits[i]);
        }
        return arrayList;
    }

    private int getCircuitNumInPortGroup() {
        return this.vc3Circuits.length + this.tunnelCircuits.size();
    }

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private class PortGroupDuplicateAccessException
    extends IllegalStateException {
        PortGroupDuplicateAccessException(String string) {
            super(string);
        }
    }
}

