/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherMacAddr;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitManager;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.RPRException;
import cerent.cms.ncp.RPRInfo;
import cerent.cms.ncp.RprTopoAdapter;
import cerent.util.IHoLoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class RPRTraceDelegate {
    private NetCircuitManager netCktMgr;
    private NetCircuit firstCkt;
    private LinkedList rprInfoList = new LinkedList();
    private ArrayList cktList = new ArrayList();
    private ArrayList selfEntList = new ArrayList();
    private SDebug dbg;
    private boolean cirRing = false;
    private int ringSize = 0;
    private boolean destOrSrc = true;

    public RPRTraceDelegate(INetCircuitManager iNetCircuitManager, INetCircuit iNetCircuit, SDebug sDebug) throws RPRException {
        this.dbg = sDebug;
        if (!this.validateCircuit((NetCircuit)iNetCircuit)) {
            throw new RPRException("The input circuit reference is invalid, or both ends of the circuit do not terminate on ML-Series cards.");
        }
        this.netCktMgr = (NetCircuitManager)iNetCircuitManager;
        this.firstCkt = (NetCircuit)iNetCircuit;
        if (this.dbgOn()) {
            this.debug("Entered RPR Trace Delegate, with Input Parameter ");
            this.debug("Circuit Name : " + iNetCircuit.getCircuitName());
            this.debug("Circuit ID : " + iNetCircuit.getCircuitId().getNodeId() + " : " + iNetCircuit.getCircuitId().getUniquePart().getUniqueId());
        }
    }

    public LinkedList getRPRTrace() throws RPRException {
        if (!this.buildRprRing()) {
            throw new RPRException("The RPR ring could not be traced.");
        }
        this.cktList.add(this.firstCkt);
        return this.rprInfoList;
    }

    private boolean buildRprRing() throws RPRException {
        boolean bl = false;
        if (this.netCktMgr == null) {
            return bl;
        }
        NetCircuit netCircuit = this.firstCkt;
        NetCircuit netCircuit2 = this.getPreviousOrNextCkt(this.firstCkt, true);
        if (netCircuit2 != null) {
            while (!this.equalsCkts(this.firstCkt, netCircuit2)) {
                netCircuit = netCircuit2;
                this.cktList.add(netCircuit2);
                if ((netCircuit2 = this.getPreviousOrNextCkt(netCircuit2, true)) != null) continue;
            }
            if (netCircuit2 != null && this.equalsCkts(this.firstCkt, netCircuit2)) {
                if (this.dbgOn()) {
                    this.debug("Circular Ring traced !!!!");
                }
                this.cirRing = true;
            } else if (this.dbgOn()) {
                this.debug("Did not find a Circular Ring !!!!");
            }
        }
        NetCircuit netCircuit3 = this.firstCkt;
        if (!this.cirRing && (netCircuit2 = this.getPreviousOrNextCkt(this.firstCkt, false)) != null) {
            while (!this.equalsCkts(netCircuit, netCircuit2)) {
                this.cktList.add(netCircuit2);
                netCircuit3 = netCircuit2;
                if ((netCircuit2 = this.getPreviousOrNextCkt(netCircuit2, false)) != null) continue;
            }
            if (netCircuit2 != null && this.equalsCkts(netCircuit, netCircuit2)) {
                if (this.dbgOn()) {
                    this.debug("Circular Ring traced (2nd go) !!!!");
                }
                this.cirRing = true;
            }
        }
        if (!this.cirRing) {
            try {
                RPRInfo rPRInfo = this.getPartialRPRInfo(netCircuit);
                this.rprInfoList.addLast(rPRInfo);
                rPRInfo = this.getPartialRPRInfo(netCircuit3);
                this.rprInfoList.addFirst(rPRInfo);
            }
            catch (ObjNotFound objNotFound) {
                throw new RPRException(objNotFound.getMessage());
            }
        }
        return true;
    }

    private NetCircuit getPreviousOrNextCkt(NetCircuit netCircuit, boolean bl) throws RPRException {
        ICircuitId iCircuitId;
        IHoLoNum iHoLoNum;
        IConnectionModel iConnectionModel;
        Object object;
        NetCircuitEnd netCircuitEnd;
        NetCircuitEnd netCircuitEnd2;
        if (this.equalsCkts(this.firstCkt, netCircuit)) {
            if (bl) {
                netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimarySource();
                netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimaryDrop();
            } else {
                netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimaryDrop();
                netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimarySource();
            }
        } else if (!this.destOrSrc) {
            netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimarySource();
            netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimaryDrop();
        } else {
            netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimaryDrop();
            netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimarySource();
        }
        if (this.dbgOn()) {
            this.debug("aEnd :: " + netCircuitEnd2.prettyString());
            this.debug("bEnd :: " + netCircuitEnd.prettyString());
            this.debug("Circuit :: " + netCircuit.getCircuitName());
        }
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        IPortModel iPortModel = null;
        NetCircuitEnd netCircuitEnd3 = null;
        NetCircuit netCircuit2 = null;
        try {
            iEntityModel = netCircuitEnd2.getEntityModel();
            iEntityModel2 = netCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            throw new RPRException("The entity model could not be found.\n" + objNotFound.getMessage());
        }
        boolean bl2 = this.validate(netCircuitEnd2);
        boolean bl3 = this.validate(netCircuitEnd);
        if (bl3) {
            iPortModel = netCircuitEnd.getOtherPosPortModelFromPair();
            object = iPortModel.getConnectionsList();
            iConnectionModel = null;
            if (!object.isEmpty()) {
                iConnectionModel = (IConnectionModel)object.get(0);
            }
            iHoLoNum = null;
            if (netCircuitEnd.getHoNum() != null) {
                iHoLoNum = this.netCktMgr.getHoLoNumfromEntity((IEntityModel)iPortModel);
            }
            if (iHoLoNum == null) {
                iHoLoNum = netCircuitEnd.getHoLoNum();
            }
            netCircuitEnd3 = new NetCircuitEnd(netCircuitEnd.getNodeModel(), (IEntityModel)iPortModel, iHoLoNum, false);
            iCircuitId = null;
            if (iConnectionModel != null) {
                iCircuitId = iConnectionModel.getCircuitId();
            }
            if (NetCircuit.isNullCircuitId(iCircuitId) || iConnectionModel instanceof ILoConnectionModel) {
                netCircuit2 = (NetCircuit)this.netCktMgr.getCircuitFromCircuitEnd(netCircuitEnd3);
            } else {
                netCircuit2 = (NetCircuit)this.netCktMgr.getCircuitFromId(iCircuitId);
                if (netCircuit2 instanceof NetCcatCircuit && ((NetCcatCircuit)netCircuit2).isMemberOfVcat()) {
                    netCircuit2 = ((NetCcatCircuit)netCircuit2).getVcatGroup().getNetVcatCircuit();
                    netCircuitEnd3.setHoLoNum(netCircuitEnd.getHoLoNum());
                }
            }
            this.destOrSrc = netCircuit2 == null || !netCircuitEnd3.equals(netCircuit2.getPrimarySource());
        }
        if (bl2 && netCircuit2 != null && this.containsCkt(netCircuit2)) {
            iPortModel = netCircuitEnd2.getOtherPosPortModelFromPair();
            object = iPortModel.getConnectionsList();
            iConnectionModel = null;
            if (!object.isEmpty()) {
                iConnectionModel = (IConnectionModel)object.get(0);
            }
            iHoLoNum = null;
            if (netCircuitEnd.getHoNum() != null) {
                iHoLoNum = this.netCktMgr.getHoLoNumfromEntity((IEntityModel)iPortModel);
            }
            if (iHoLoNum == null) {
                iHoLoNum = netCircuitEnd2.getHoLoNum();
            }
            netCircuitEnd3 = new NetCircuitEnd(netCircuitEnd2.getNodeModel(), (IEntityModel)iPortModel, iHoLoNum, false);
            iCircuitId = null;
            if (iConnectionModel != null) {
                iCircuitId = iConnectionModel.getCircuitId();
            }
            if (NetCircuit.isNullCircuitId(iCircuitId) || iConnectionModel instanceof ILoConnectionModel) {
                netCircuit2 = (NetCircuit)this.netCktMgr.getCircuitFromCircuitEnd(netCircuitEnd3);
            } else {
                netCircuit2 = (NetCircuit)this.netCktMgr.getCircuitFromId(iCircuitId);
                if (netCircuit2 instanceof NetCcatCircuit && ((NetCcatCircuit)netCircuit2).isMemberOfVcat()) {
                    netCircuit2 = ((NetCcatCircuit)netCircuit2).getVcatGroup().getNetVcatCircuit();
                    netCircuitEnd3.setHoLoNum(netCircuitEnd2.getHoLoNum());
                }
            }
            this.destOrSrc = netCircuit2 == null || !netCircuitEnd3.equals(netCircuit2.getPrimarySource());
        }
        if (netCircuit != null && netCircuit2 != null) {
            try {
                if (!this.validateCircuit(netCircuit2)) {
                    return null;
                }
                object = this.getRPRInfo(netCircuit, netCircuit2, bl);
                if (bl) {
                    this.rprInfoList.addLast(object);
                } else {
                    this.rprInfoList.addFirst(object);
                }
            }
            catch (ObjNotFound objNotFound) {
                throw new RPRException("The RPR information could not be built.\n" + objNotFound.getMessage());
            }
        }
        return netCircuit2;
    }

    private RPRInfo getRPRInfo(NetCircuit netCircuit, NetCircuit netCircuit2, boolean bl) throws RPRException, ObjNotFound {
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        IEntityModel iEntityModel3 = null;
        NetCircuit netCircuit3 = null;
        NetCircuit netCircuit4 = null;
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimarySource();
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimaryDrop();
        NetCircuitEnd netCircuitEnd3 = (NetCircuitEnd)netCircuit2.getPrimarySource();
        NetCircuitEnd netCircuitEnd4 = (NetCircuitEnd)netCircuit2.getPrimaryDrop();
        if (this.dbgOn()) {
            this.dbg.println(netCircuitEnd.prettyString());
            this.dbg.println(netCircuitEnd2.prettyString());
            this.dbg.println(netCircuitEnd3.prettyString());
            this.dbg.println(netCircuitEnd4.prettyString());
        }
        ++this.ringSize;
        if (this.ringSize > 255) {
            throw new RPRException("An IEEE 802.17 RPR ring cannot have more than 255 ML-Series cards.");
        }
        if (netCircuitEnd.getNodeId() == netCircuitEnd3.getNodeId() && netCircuitEnd.getEntityModel().getSlot() == netCircuitEnd3.getEntityModel().getSlot() && !this.checkSelfEntList(netCircuitEnd, netCircuitEnd3)) {
            if (this.checkRprPortsNum(netCircuitEnd, netCircuitEnd3)) {
                netCircuit3 = netCircuit;
                iEntityModel2 = netCircuit.getPrimaryDrop().getEntityModel();
                netCircuit4 = netCircuit2;
                iEntityModel3 = netCircuit2.getPrimaryDrop().getEntityModel();
                iEntityModel = netCircuitEnd.getEntityModel();
            } else if (this.checkRprPortsNum(netCircuitEnd3, netCircuitEnd)) {
                netCircuit3 = netCircuit2;
                iEntityModel2 = netCircuit2.getPrimaryDrop().getEntityModel();
                netCircuit4 = netCircuit;
                iEntityModel3 = netCircuit.getPrimaryDrop().getEntityModel();
                iEntityModel = netCircuitEnd3.getEntityModel();
            }
        } else if (netCircuitEnd.getNodeId() == netCircuitEnd4.getNodeId() && netCircuitEnd.getEntityModel().getSlot() == netCircuitEnd4.getEntityModel().getSlot() && !this.checkSelfEntList(netCircuitEnd, netCircuitEnd4)) {
            if (this.checkRprPortsNum(netCircuitEnd, netCircuitEnd4)) {
                netCircuit3 = netCircuit;
                iEntityModel2 = netCircuit.getPrimaryDrop().getEntityModel();
                netCircuit4 = netCircuit2;
                iEntityModel3 = netCircuit2.getPrimarySource().getEntityModel();
                iEntityModel = netCircuitEnd.getEntityModel();
            } else if (this.checkRprPortsNum(netCircuitEnd4, netCircuitEnd)) {
                netCircuit3 = netCircuit2;
                iEntityModel2 = netCircuit2.getPrimarySource().getEntityModel();
                netCircuit4 = netCircuit;
                iEntityModel3 = netCircuit.getPrimaryDrop().getEntityModel();
                iEntityModel = netCircuitEnd4.getEntityModel();
            }
        } else if (netCircuitEnd2.getNodeId() == netCircuitEnd3.getNodeId() && netCircuitEnd2.getEntityModel().getSlot() == netCircuitEnd3.getEntityModel().getSlot() && !this.checkSelfEntList(netCircuitEnd2, netCircuitEnd3)) {
            if (this.checkRprPortsNum(netCircuitEnd2, netCircuitEnd3)) {
                netCircuit3 = netCircuit;
                iEntityModel2 = netCircuit.getPrimarySource().getEntityModel();
                netCircuit4 = netCircuit2;
                iEntityModel3 = netCircuit2.getPrimaryDrop().getEntityModel();
                iEntityModel = netCircuitEnd2.getEntityModel();
            } else if (this.checkRprPortsNum(netCircuitEnd3, netCircuitEnd2)) {
                netCircuit3 = netCircuit2;
                iEntityModel2 = netCircuit2.getPrimaryDrop().getEntityModel();
                netCircuit4 = netCircuit;
                iEntityModel3 = netCircuit.getPrimarySource().getEntityModel();
                iEntityModel = netCircuitEnd3.getEntityModel();
            }
        } else if (netCircuitEnd2.getNodeId() == netCircuitEnd4.getNodeId() && netCircuitEnd2.getEntityModel().getSlot() == netCircuitEnd4.getEntityModel().getSlot() && !this.checkSelfEntList(netCircuitEnd2, netCircuitEnd4)) {
            if (this.checkRprPortsNum(netCircuitEnd2, netCircuitEnd4)) {
                netCircuit3 = netCircuit;
                iEntityModel2 = netCircuit.getPrimarySource().getEntityModel();
                netCircuit4 = netCircuit2;
                iEntityModel3 = netCircuit2.getPrimarySource().getEntityModel();
                iEntityModel = netCircuitEnd2.getEntityModel();
            } else if (this.checkRprPortsNum(netCircuitEnd4, netCircuitEnd2)) {
                netCircuit3 = netCircuit2;
                iEntityModel2 = netCircuit2.getPrimarySource().getEntityModel();
                netCircuit4 = netCircuit;
                iEntityModel3 = netCircuit.getPrimarySource().getEntityModel();
                iEntityModel = netCircuitEnd4.getEntityModel();
            }
        }
        if (this.dbgOn()) {
            this.debug(" selfEntity : " + iEntityModel.getNodeModel().getHostName() + " :: " + iEntityModel.getSlot() + " :: " + iEntityModel.getPort());
            this.debug(" eastEntity : " + iEntityModel2.getNodeModel().getHostName() + " :: " + iEntityModel2.getSlot());
            this.debug(" westEntity : " + iEntityModel3.getNodeModel().getHostName() + " :: " + iEntityModel3.getSlot());
            this.debug(" East Circuit :" + netCircuit3.getCircuitName());
            this.debug(" West Circuit :" + netCircuit4.getCircuitName());
        }
        this.selfEntList.add(iEntityModel.getModuleModel());
        IEtherMacAddr iEtherMacAddr = null;
        IEtherMacAddr iEtherMacAddr2 = null;
        IEtherMacAddr iEtherMacAddr3 = null;
        try {
            if (iEntityModel != null) {
                iEtherMacAddr = RprTopoAdapter.getRprTopoStation(iEntityModel.getEntityIndex(), iEntityModel.getNodeModel(), iEntityModel).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        try {
            if (iEntityModel2 != null) {
                iEtherMacAddr2 = RprTopoAdapter.getRprTopoStation(iEntityModel2.getEntityIndex(), iEntityModel2.getNodeModel(), iEntityModel2).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        try {
            if (iEntityModel3 != null) {
                iEtherMacAddr3 = RprTopoAdapter.getRprTopoStation(iEntityModel3.getEntityIndex(), iEntityModel3.getNodeModel(), iEntityModel3).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        return new RPRInfo((IPortModel)iEntityModel, (IPortModel)iEntityModel2, (IPortModel)iEntityModel3, iEtherMacAddr, iEtherMacAddr2, iEtherMacAddr3, netCircuit3, netCircuit4);
    }

    private RPRInfo getPartialRPRInfo(NetCircuit netCircuit) throws RPRException, ObjNotFound {
        this.validateCircuit(netCircuit);
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        IEntityModel iEntityModel3 = null;
        NetCircuit netCircuit2 = null;
        NetCircuit netCircuit3 = null;
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getPrimarySource();
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)netCircuit.getPrimaryDrop();
        IModuleModel iModuleModel = netCircuitEnd.getEntityModel().getModuleModel();
        IModuleModel iModuleModel2 = netCircuitEnd2.getEntityModel().getModuleModel();
        ++this.ringSize;
        if (this.ringSize > 255) {
            throw new RPRException("An IEEE 802.17 RPR ring cannot have more than 255 ML-Series cards.");
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (iModuleModel.getNodeModel().provides(Feature.POS_ON_MLMR) && iModuleModel.getEqType() == 285) {
            n = iModuleModel.getRPREastPort();
            n2 = iModuleModel.getRPRWestPort();
        }
        if (iModuleModel2.getNodeModel().provides(Feature.POS_ON_MLMR) && iModuleModel2.getEqType() == 285) {
            n3 = iModuleModel2.getRPREastPort();
            n4 = iModuleModel2.getRPRWestPort();
        }
        if (!this.checkSelfEntList(netCircuitEnd, netCircuitEnd2) && this.validate(netCircuitEnd)) {
            if (this.getPortNum(netCircuitEnd) == 0 || this.getPortNum(netCircuitEnd) == n) {
                netCircuit2 = netCircuit;
                iEntityModel2 = netCircuit.getPrimaryDrop().getEntityModel();
                netCircuit3 = null;
                iEntityModel3 = null;
                iEntityModel = netCircuitEnd.getEntityModel();
            } else if (this.getPortNum(netCircuitEnd) == 1 || this.getPortNum(netCircuitEnd) == n2) {
                netCircuit2 = null;
                iEntityModel2 = null;
                netCircuit3 = netCircuit;
                iEntityModel3 = netCircuit.getPrimaryDrop().getEntityModel();
                iEntityModel = netCircuitEnd.getOtherPosPortModelFromPair();
            }
        } else if (!this.checkSelfEntList(netCircuitEnd2, netCircuitEnd) && this.validate(netCircuitEnd2)) {
            if (this.getPortNum(netCircuitEnd2) == 0 || this.getPortNum(netCircuitEnd2) == n3) {
                netCircuit2 = netCircuit;
                iEntityModel2 = netCircuit.getPrimarySource().getEntityModel();
                netCircuit3 = null;
                iEntityModel3 = null;
                iEntityModel = netCircuitEnd2.getEntityModel();
            } else if (this.getPortNum(netCircuitEnd2) == 1 || this.getPortNum(netCircuitEnd2) == n4) {
                netCircuit2 = null;
                iEntityModel2 = null;
                netCircuit3 = netCircuit;
                iEntityModel3 = netCircuit.getPrimarySource().getEntityModel();
                iEntityModel = netCircuitEnd2.getOtherPosPortModelFromPair();
            }
        }
        if (this.dbgOn()) {
            this.debug(" selfEntity : " + iEntityModel.getNodeModel().getHostName() + " :: " + iEntityModel.getSlot() + " :: " + iEntityModel.getPort());
            if (iEntityModel2 != null) {
                this.debug(" eastEntity : " + iEntityModel2 == null ? "NULL" : iEntityModel2.getNodeModel().getHostName() + " :: " + iEntityModel2.getSlot());
            } else {
                this.debug(" eastEntity : NULL");
            }
            if (iEntityModel3 != null) {
                this.debug(" westEntity : " + iEntityModel3 == null ? "NULL" : iEntityModel3.getNodeModel().getHostName() + " :: " + iEntityModel3.getSlot());
            } else {
                this.debug(" westEntity : NULL");
            }
            if (netCircuit2 != null) {
                this.debug(" East Circuit :" + netCircuit2.getCircuitName());
            } else {
                this.debug(" East Circuit : NULL");
            }
            if (netCircuit3 != null) {
                this.debug(" West Circuit :" + netCircuit3.getCircuitName());
            } else {
                this.debug(" West Circuit : NULL");
            }
        }
        this.selfEntList.add(iEntityModel.getModuleModel());
        IEtherMacAddr iEtherMacAddr = null;
        IEtherMacAddr iEtherMacAddr2 = null;
        IEtherMacAddr iEtherMacAddr3 = null;
        try {
            if (iEntityModel != null) {
                iEtherMacAddr = RprTopoAdapter.getRprTopoStation(iEntityModel.getEntityIndex(), iEntityModel.getNodeModel(), iEntityModel).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        try {
            if (iEntityModel2 != null) {
                iEtherMacAddr2 = RprTopoAdapter.getRprTopoStation(iEntityModel2.getEntityIndex(), iEntityModel2.getNodeModel(), iEntityModel2).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        try {
            if (iEntityModel3 != null) {
                iEtherMacAddr3 = RprTopoAdapter.getRprTopoStation(iEntityModel3.getEntityIndex(), iEntityModel3.getNodeModel(), iEntityModel3).getMacAddr();
            }
        }
        catch (CTCUserException cTCUserException) {
            this.debug("Error in getting self MAC address: " + cTCUserException.getPrettyMessage());
        }
        return new RPRInfo((IPortModel)iEntityModel, (IPortModel)iEntityModel2, (IPortModel)iEntityModel3, iEtherMacAddr, iEtherMacAddr2, iEtherMacAddr3, netCircuit2, netCircuit3);
    }

    private boolean validateCircuit(NetCircuit netCircuit) throws RPRException {
        if (netCircuit == null) {
            return false;
        }
        if (!netCircuit.isCircuitRefValid()) {
            throw new RPRException("The circuit " + netCircuit.getCircuitName() + " does not exist.");
        }
        if (netCircuit.getState() != 1 && netCircuit.getState() != 5 && netCircuit.getState() != 8) {
            throw new RPRException("The circuit " + netCircuit.getCircuitName() + " is inactive/partial. The circuit " + "validation process cannot proceed.");
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        try {
            IEntityModel iEntityModel = netCircuit.getPrimarySource().getEntityModel();
            bl = iEntityModel.inRPRMode();
            n = iEntityModel.getModuleModel().getEqType();
        }
        catch (ObjNotFound objNotFound) {
            throw new RPRException("The entity model cannot be found.\n" + objNotFound.getMessage());
        }
        boolean bl3 = this.isMLEquipment(n);
        try {
            IEntityModel iEntityModel = netCircuit.getPrimaryDrop().getEntityModel();
            bl2 = iEntityModel.inRPRMode();
            n = -1;
            n = iEntityModel.getModuleModel().getEqType();
        }
        catch (ObjNotFound objNotFound) {
            throw new RPRException("The entity model cannot be found.\n" + objNotFound.getMessage());
        }
        boolean bl4 = this.isMLEquipment(n);
        if (!bl || !bl2) {
            throw new RPRException("Both the source and the destination ML cards need to be in RPR mode.\n");
        }
        if (!bl3 || !bl4) {
            return false;
        }
        int n2 = this.getPortNum((NetCircuitEnd)netCircuit.getPrimarySource());
        int n3 = this.getPortNum((NetCircuitEnd)netCircuit.getPrimaryDrop());
        if (bl3 && bl4 && n2 == n3) {
            if (this.dbgOn()) {
                this.debug("Circuit :" + netCircuit.getCircuitName() + " does not follow" + " the east-west or west-east convention for RPR");
            }
            return false;
        }
        return true;
    }

    private boolean validate(NetCircuitEnd netCircuitEnd) throws RPRException {
        if (this.dbgOn()) {
            this.debug("Validate NetCircuitEnd : " + netCircuitEnd.prettyString());
        }
        int n = -1;
        if (!Feature.provides((INodeModel)netCircuitEnd.getNodeModel(), (Feature)Feature.RPR)) {
            throw new RPRException("This feature is not supported for the NE version " + netCircuitEnd.getNodeModel().getSwVersion() + ".");
        }
        try {
            n = netCircuitEnd.getEntityModel().getModuleModel().getEqType();
        }
        catch (ObjNotFound objNotFound) {
            throw new RPRException("The entity model could not be found.\n" + objNotFound.getMessage());
        }
        return this.isMLEquipment(n);
    }

    private boolean isMLEquipment(int n) {
        if (this.dbgOn()) {
            this.debug("Equipment Type " + n);
        }
        switch (n) {
            case 102: 
            case 103: 
            case 221: 
            case 285: {
                return true;
            }
        }
        if (this.dbgOn()) {
            this.debug("Non-ML card type.");
        }
        return false;
    }

    private boolean dbgOn() {
        return this.dbg.on();
    }

    private void debug(String string) {
        this.dbg.println(string);
    }

    private int getPortNum(NetCircuitEnd netCircuitEnd) throws RPRException {
        int n = -1;
        try {
            n = netCircuitEnd.getEntityModel().getPort();
        }
        catch (ObjNotFound objNotFound) {
            throw new RPRException("The entity model could not be found.\n" + objNotFound.getMessage());
        }
        return n;
    }

    private boolean containsCkt(NetCircuit netCircuit) {
        NetCircuit netCircuit2;
        boolean bl = false;
        Iterator iterator = this.cktList.iterator();
        while (iterator.hasNext() && !(bl = this.equalsCkts(netCircuit, netCircuit2 = (NetCircuit)iterator.next()))) {
        }
        return bl;
    }

    private boolean equalsCkts(NetCircuit netCircuit, NetCircuit netCircuit2) {
        if (netCircuit.hasNullCircuitId() && netCircuit2.hasNullCircuitId()) {
            return netCircuit.getPrimarySource().equals(netCircuit2.getPrimarySource()) && netCircuit.getPrimaryDrop().equals(netCircuit2.getPrimaryDrop());
        }
        return netCircuit.getCircuitId().equals(netCircuit2.getCircuitId());
    }

    public ArrayList getAllCircuitsInRPR() {
        return this.cktList;
    }

    public void dispose() {
        this.firstCkt = null;
        this.cktList.clear();
        this.selfEntList.clear();
        this.rprInfoList.clear();
    }

    private boolean checkSelfEntList(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) throws ObjNotFound {
        if (this.dbgOn()) {
            this.debug("Looking for :: " + netCircuitEnd.getEntityModel().getModuleModel());
        }
        return this.selfEntList.contains(netCircuitEnd.getEntityModel().getModuleModel());
    }

    private boolean checkRprPortsNum(NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2) throws RPRException, ObjNotFound {
        IModuleModel iModuleModel = netCircuitEnd.getEntityModel().getModuleModel();
        int n = -1;
        int n2 = -1;
        if (iModuleModel.getNodeModel().provides(Feature.POS_ON_MLMR) && iModuleModel.getEqType() == 285) {
            n = iModuleModel.getRPREastPort();
            n2 = iModuleModel.getRPRWestPort();
            if (this.getPortNum(netCircuitEnd) == n && this.getPortNum(netCircuitEnd2) == n2) {
                return true;
            }
        }
        return this.getPortNum(netCircuitEnd) == 0 && this.getPortNum(netCircuitEnd2) == 1;
    }
}

