/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.BridgeAndRollNotSupported;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotCancelRoll;
import cerent.cms.model.CannotCompleteRoll;
import cerent.cms.model.CannotFinishRoll;
import cerent.cms.model.CannotForceCompleteRoll;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.FailedBulkRoll;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathRollModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathFailedRoll;
import cerent.cms.model.IHoPathRollModel;
import cerent.cms.model.IHoRollModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoPathFailedRoll;
import cerent.cms.model.ILoPathRollModel;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollError;
import cerent.cms.model.IRollModel;
import cerent.cms.model.IRollOperation;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidRollMode;
import cerent.cms.model.LoPathRollModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoRollCondition;
import cerent.cms.model.NoRollValidSignal;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathRollModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RollDestNoBandwidth;
import cerent.cms.model.RollDestNotAligned;
import cerent.cms.model.RollNotConnected;
import cerent.cms.model.SiblingRollNotComplete;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoRoll;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoRoll;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetRoll;
import cerent.cms.ncp.RollCreateInfo;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.IDebugDiag;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.TreeSet;

public class RollManager
extends CmsObservable
implements IObserver {
    private static RollManager rollManager;
    private List brNodes = Collections.synchronizedList(new ArrayList());
    private List netRolls = Collections.synchronizedList(new ArrayList());
    private RollObserver rollObserver = new RollObserver();
    private SortedSet neList;
    private SortedSet rollList;
    public DumpDebug dumpDb = new DumpDebug("Rolls");
    private static final SDebug db;
    private static final SDebug pkgDb;
    private static int HO_ROLL;
    private static int LO_ROLL;

    private RollManager() {
        NetElemComparator netElemComparator = new NetElemComparator();
        this.neList = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
        this.rollList = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
        Thread thread = new Thread("RollManager"){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            1.sleep(5000L);
                            RollManager.this.processUpdates();
                        }
                    }
                    catch (Exception exception) {
                        db.println("Roll Manager hit an exception in run() method");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CTC RollManagerThread");
        thread.start();
    }

    public static synchronized RollManager instance() {
        if (rollManager == null) {
            rollManager = new RollManager();
        }
        return rollManager;
    }

    private synchronized void discoverRollsOnNode(INodeModel iNodeModel) {
        int n;
        IHoRollModel[] iHoRollModelArray;
        if (RollManager.dbgOn()) {
            db.println("calling discoverRollsOnNode on NE (" + iNodeModel.getName() + ")");
        }
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        if (iNodeModel.provides(Feature.BRIDGE_AND_ROLL) || iNodeModel.provides(Feature.ENHANCED_BRIDGE_AND_ROLL)) {
            iHoRollModelArray = iConnectionModels.getHoRollModels();
            if (RollManager.dbgOn()) {
                db.println("Number of HO Rolls retrieved from NE is: " + iHoRollModelArray.length);
            }
            for (n = 0; n < iHoRollModelArray.length; ++n) {
                this.createNewNetRoll((IRollModel)iHoRollModelArray[n]);
            }
        }
        if (iNodeModel.provides(Feature.ENHANCED_BRIDGE_AND_ROLL)) {
            iHoRollModelArray = iConnectionModels.getLoRollModels();
            if (RollManager.dbgOn()) {
                db.println("Number of LO Rolls retrieved from NE is: " + iHoRollModelArray.length);
            }
            for (n = 0; n < iHoRollModelArray.length; ++n) {
                this.createNewNetRoll((IRollModel)iHoRollModelArray[n]);
            }
        }
    }

    public synchronized void createNewNetRoll(IRollModel iRollModel) {
        if (this.findNetRoll(iRollModel) == null) {
            if (RollManager.dbgOn()) {
                db.println("Adding roll to RollManager with connection index " + iRollModel.getConnectionIndex());
            }
            NetRoll netRoll = null;
            if (iRollModel instanceof IHoRollModel) {
                if (RollManager.dbgOn()) {
                    db.println("Creating new Ho Roll on " + iRollModel.getNodeModel().getName());
                }
                netRoll = new HoRoll(iRollModel.getNodeModel(), (IHoRollModel)iRollModel);
            } else if (iRollModel instanceof ILoRollModel) {
                if (RollManager.dbgOn()) {
                    db.println("Creating new Lo Roll on " + iRollModel.getNodeModel().getName());
                }
                netRoll = new LoRoll(iRollModel.getNodeModel(), (ILoRollModel)iRollModel);
            }
            if (netRoll.isRollRefValid()) {
                this.insertRoll(netRoll);
            }
        } else if (RollManager.dbgOn()) {
            db.println("Roll already in RollManager " + iRollModel.getConnectionIndex());
        }
    }

    public IRollModel createNewRollModel(INetElement iNetElement, RollCreateInfo[] rollCreateInfoArray, boolean bl) throws Busy, DropsExceedMax, ConnectionInRoll, ConnectionInTestAccess, ConnectionInLoopback, ConnectionTypeError, PathInUse, InvalidPath, InvalidRollMode, FailedBulkRoll, RollDestNotAligned, RollDestNoBandwidth, BlsrSpanSwitched, NoSuchConnection, LoopbackActive, ProvisionError, BridgeAndRollNotSupported, CTCUserException {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IHoRollModel iHoRollModel = null;
        if (iNodeModel.provides(Feature.ENHANCED_BRIDGE_AND_ROLL)) {
            Object object;
            if (RollManager.dbgOn()) {
                db.println("Creating bulk roll");
            }
            StringBuffer stringBuffer = new StringBuffer();
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            StringBuffer stringBuffer2 = this.getPathRollModels(rollCreateInfoArray, linkedList, linkedList2);
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("An error occurred while validating the roll.\n");
                stringBuffer.append(stringBuffer2.toString());
            }
            HoPathRollModel[] hoPathRollModelArray = linkedList.toArray(new HoPathRollModel[0]);
            LoPathRollModel[] loPathRollModelArray = linkedList2.toArray(new LoPathRollModel[0]);
            LinkedList linkedList3 = new LinkedList();
            if (hoPathRollModelArray.length > 0 || loPathRollModelArray.length > 0) {
                LinkedList linkedList4 = new LinkedList();
                ILoPathFailedRoll iLoPathFailedRoll = new LinkedList();
                object = new LinkedList();
                boolean bl2 = iNodeModel.getConnectionModels().createBulkRoll((IHoPathRollModel[])hoPathRollModelArray, (ILoPathRollModel[])loPathRollModelArray, bl, (List)linkedList4, (List)iLoPathFailedRoll, (List)object, linkedList3);
                if (!bl2) {
                    stringBuffer.append("\n");
                    stringBuffer.append(this.getBulkRollError(iNetElement, "An error occurred while creating the roll.\n", (List)object, linkedList3));
                }
                if (rollCreateInfoArray.length == 1) {
                    if (linkedList4.size() == 1) {
                        iHoRollModel = (IHoRollModel)linkedList4.get(0);
                    } else if (iLoPathFailedRoll.size() == 1) {
                        iHoRollModel = (ILoRollModel)iLoPathFailedRoll.get(0);
                    }
                }
            }
            if (stringBuffer.toString().length() > 0) {
                for (ILoPathFailedRoll iLoPathFailedRoll : linkedList3) {
                    object = NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, iLoPathFailedRoll.getRollToPath());
                    ILoAditModel iLoAditModel = iLoPathFailedRoll.getRollToPath().getLoAdit();
                    if (iLoAditModel != null && !iLoAditModel.inUse()) {
                        if (db.on()) {
                            db.println("RollTo: " + NetRoll.slashSeparatedStr((INetCircuitEnd)object) + " failed" + " and adit is not in use. so destroying the same");
                        }
                        ((NetCircuitEnd)object).cleanupLoAdit();
                        continue;
                    }
                    if (!db.on()) continue;
                    db.println("RollTo: " + NetRoll.slashSeparatedStr((INetCircuitEnd)object) + " failed." + " But Adit is in Use");
                }
                throw new FailedBulkRoll(stringBuffer.toString());
            }
        } else if (rollCreateInfoArray[0].getRollFromCircuit().getCircuitTypeObj().isHoCircuitType()) {
            if (RollManager.dbgOn()) {
                db.println("Creating single roll");
            }
            iHoRollModel = iNodeModel.getConnectionModels().createHoRoll(rollCreateInfoArray[0].getRollFromHoPath(), rollCreateInfoArray[0].getRollToHoPath(), rollCreateInfoArray[0].getRollMode(), rollCreateInfoArray[0].getRollToCircuit().getCircuitId(), rollCreateInfoArray[0].getCircuitRollNumber(), rollCreateInfoArray[0].getCircuitRollMode());
        }
        return iHoRollModel;
    }

    private synchronized List getRollsOnNode(List list, INetElement iNetElement, int n) {
        Iterator iterator = list.iterator();
        LinkedList<NetRoll> linkedList = new LinkedList<NetRoll>();
        while (iterator.hasNext()) {
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            INetElement iNetElement2 = netRoll.getNetElement();
            if (n == LO_ROLL) {
                if (!(netRoll instanceof LoRoll) || !iNetElement2.equals(iNetElement)) continue;
                linkedList.add(netRoll);
                continue;
            }
            if (n != HO_ROLL || !(netRoll instanceof HoRoll) || !iNetElement2.equals(iNetElement)) continue;
            linkedList.add(netRoll);
        }
        return linkedList;
    }

    private synchronized List getUniqueNodes(List list) {
        Iterator iterator = list.iterator();
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        while (iterator.hasNext()) {
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            INetElement iNetElement = netRoll.getNetElement();
            if (linkedList.contains(iNetElement)) continue;
            linkedList.add(iNetElement);
        }
        return linkedList;
    }

    private StringBuffer getValidRolls(NetRoll[] netRollArray, int n, LinkedList linkedList) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = netRollArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n == 2) {
                try {
                    if (!netRollArray[i].canBeCancelled()) continue;
                    netRollArray[i].setIsRollProcessingClient(true);
                    if (netRollArray[i].getRollValidSignal()) {
                        linkedList.addFirst(netRollArray[i]);
                        continue;
                    }
                    linkedList.addLast(netRollArray[i]);
                }
                catch (CannotCancelRoll cannotCancelRoll) {
                    stringBuffer.append(this.getSingleRollError(netRollArray[i], cannotCancelRoll.getMessage()));
                }
                continue;
            }
            if (n == 0) {
                try {
                    if (!netRollArray[i].canBeCompleted()) continue;
                    linkedList.add(netRollArray[i]);
                }
                catch (CannotCompleteRoll cannotCompleteRoll) {
                    stringBuffer.append(this.getSingleRollError(netRollArray[i], cannotCompleteRoll.getMessage()));
                }
                continue;
            }
            if (n == 1) {
                try {
                    if (!netRollArray[i].canBeFinished()) continue;
                    netRollArray[i].setIsRollProcessingClient(true);
                    linkedList.add(netRollArray[i]);
                }
                catch (CannotFinishRoll cannotFinishRoll) {
                    stringBuffer.append(this.getSingleRollError(netRollArray[i], cannotFinishRoll.getMessage()));
                }
                continue;
            }
            if (n != 3) continue;
            try {
                if (!netRollArray[i].canBeForceCompleted()) continue;
                linkedList.add(netRollArray[i]);
                continue;
            }
            catch (CannotForceCompleteRoll cannotForceCompleteRoll) {
                stringBuffer.append(this.getSingleRollError(netRollArray[i], cannotForceCompleteRoll.getMessage()));
            }
        }
        return stringBuffer;
    }

    public synchronized void editBulkRoll(NetRoll[] netRollArray, int n) throws FailedBulkRoll, InvalidRollMode, NoRollValidSignal, NoRollCondition, RollNotConnected, SiblingRollNotComplete, CannotCancelRoll, NoSuchConnection, CTCUserException {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList linkedList = new LinkedList();
        StringBuffer stringBuffer2 = this.getValidRolls(netRollArray, n, linkedList);
        if (stringBuffer2.length() > 0) {
            stringBuffer.append("An error occurred while validating the roll.\n");
            stringBuffer.append(stringBuffer2.toString());
        }
        List list = this.getUniqueNodes(linkedList);
        for (INetElement iNetElement : list) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            List list2 = this.getRollsOnNode(linkedList, iNetElement, HO_ROLL);
            List list3 = this.getRollsOnNode(linkedList, iNetElement, LO_ROLL);
            if (iNodeModel.provides(Feature.ENHANCED_BRIDGE_AND_ROLL)) {
                if (RollManager.dbgOn()) {
                    db.println("Editing bulk roll with operation " + EnumStrings.getString(IRollOperation.class, (int)n));
                }
                LinkedList linkedList2 = new LinkedList();
                Object object = new LinkedList();
                List list4 = this.getRollIndexes(list2);
                List list5 = this.getRollIndexes(list3);
                boolean bl = iNodeModel.getConnectionModels().editBulkRoll(list4, list5, n, (List)linkedList2, object);
                if (bl) continue;
                stringBuffer.append("\n");
                stringBuffer.append(this.getBulkRollError(iNetElement, "An error occurred while editing the roll.\n", linkedList2, (List)object));
                continue;
            }
            if (RollManager.dbgOn()) {
                db.println("Editing single roll with operation " + n);
            }
            for (Object object : list2) {
                if (object == null) continue;
                try {
                    this.performOperation((NetRoll)((Object)object), n);
                }
                catch (Exception exception) {
                    stringBuffer.append(this.getSingleRollError((NetRoll)((Object)object), exception.getMessage()));
                }
            }
        }
        if (stringBuffer.toString().length() > 0) {
            throw new FailedBulkRoll(stringBuffer.toString());
        }
    }

    private List getRollIndexes(List list) {
        Iterator iterator = list.iterator();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (iterator.hasNext()) {
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            linkedList.add(new Integer(netRoll.getConnectionIndex()));
        }
        return linkedList;
    }

    private void performOperation(NetRoll netRoll, int n) throws InvalidRollMode, NoRollValidSignal, NoRollCondition, RollNotConnected, SiblingRollNotComplete, CannotCancelRoll, Exception {
        try {
            if (n == 0) {
                netRoll.rollComplete();
            } else if (n == 2) {
                netRoll.rollCancel();
            } else if (n == 1) {
                netRoll.rollFinish();
            }
        }
        catch (InvalidRollMode invalidRollMode) {
            throw invalidRollMode;
        }
        catch (NoRollValidSignal noRollValidSignal) {
            throw noRollValidSignal;
        }
        catch (NoRollCondition noRollCondition) {
            throw noRollCondition;
        }
        catch (RollNotConnected rollNotConnected) {
            throw rollNotConnected;
        }
        catch (SiblingRollNotComplete siblingRollNotComplete) {
            throw siblingRollNotComplete;
        }
        catch (CannotCancelRoll cannotCancelRoll) {
            throw cannotCancelRoll;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private StringBuffer getPathRollModels(RollCreateInfo[] rollCreateInfoArray, List list, List list2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < rollCreateInfoArray.length; ++i) {
            PathRollModel pathRollModel;
            ICircuitType iCircuitType = rollCreateInfoArray[i].getRollFromCircuit().getCircuitTypeObj();
            if (iCircuitType.isHoCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType() || iCircuitType.isEthernetCircuitType()) {
                try {
                    pathRollModel = new HoPathRollModel(rollCreateInfoArray[i].getRollFromHoPath(), rollCreateInfoArray[i].getRollToHoPath(), rollCreateInfoArray[i].getRollMode(), rollCreateInfoArray[i].getRollToCircuit().getCircuitId(), rollCreateInfoArray[i].getCircuitRollNumber(), rollCreateInfoArray[i].getCircuitRollMode());
                    list.add(pathRollModel);
                }
                catch (Exception exception) {
                    stringBuffer.append(this.getSingleRollError(rollCreateInfoArray[i], exception.getMessage()));
                }
                continue;
            }
            if (!iCircuitType.isLoCircuitType()) continue;
            try {
                pathRollModel = new LoPathRollModel(rollCreateInfoArray[i].getRollFromLoPath(), rollCreateInfoArray[i].getRollToLoPath(), rollCreateInfoArray[i].getRollMode(), rollCreateInfoArray[i].getRollToCircuit().getCircuitId(), rollCreateInfoArray[i].getCircuitRollNumber(), rollCreateInfoArray[i].getCircuitRollMode());
                list2.add(pathRollModel);
                continue;
            }
            catch (Exception exception) {
                stringBuffer.append(this.getSingleRollError(rollCreateInfoArray[i], exception.getMessage()));
            }
        }
        return stringBuffer;
    }

    public boolean isBridgeAndRollSupported(INodeModel iNodeModel) {
        return iNodeModel.provides(Feature.BRIDGE_AND_ROLL) || iNodeModel.provides(Feature.ENHANCED_BRIDGE_AND_ROLL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRoll(NetRoll netRoll) {
        List list = this.netRolls;
        synchronized (list) {
            this.netRolls.add(netRoll);
        }
        this.setChanged();
        this.notifyObservers((Object)netRoll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRoll(NetRoll netRoll) {
        List list = this.netRolls;
        synchronized (list) {
            this.netRolls.remove((Object)netRoll);
            netRoll = null;
        }
    }

    public NetRoll findNetRoll(IRollModel iRollModel) {
        if (iRollModel == null) {
            return null;
        }
        NetRoll netRoll2 = null;
        boolean bl = false;
        IRollModel iRollModel2 = null;
        for (NetRoll netRoll2 : this.getRolls()) {
            iRollModel2 = netRoll2.getRollModel();
            if (iRollModel2 == null || iRollModel2.getNodeModel().getNodeId() != iRollModel.getNodeModel().getNodeId() || iRollModel2.getConnectionIndex() != iRollModel.getConnectionIndex() || (!(iRollModel2 instanceof IHoRollModel) || !(iRollModel instanceof IHoRollModel)) && (!(iRollModel2 instanceof ILoRollModel) || !(iRollModel instanceof ILoRollModel))) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (RollManager.dbgOn()) {
                db.println("Found roll model with connection index " + iRollModel.getConnectionIndex());
            }
            return netRoll2;
        }
        if (RollManager.dbgOn()) {
            db.println("Could not find roll model with connection index " + iRollModel.getConnectionIndex());
        }
        return null;
    }

    public NetRoll findNetRoll(IConnectionModel iConnectionModel) {
        if (iConnectionModel == null) {
            return null;
        }
        INodeModel iNodeModel = iConnectionModel.getNodeModel();
        if (iNodeModel != null) {
            IConnectionModels iConnectionModels = iNodeModel.getNodeModel().getConnectionModels();
            try {
                IHoRollModel iHoRollModel = null;
                if (iConnectionModel instanceof IHoConnectionModel) {
                    iHoRollModel = iConnectionModels.getHoRollModels(iConnectionModel.getIndex());
                } else if (iConnectionModel instanceof ILoConnectionModel) {
                    iHoRollModel = iConnectionModels.getLoRollModels(iConnectionModel.getIndex());
                }
                NetRoll netRoll = this.findNetRoll((IRollModel)iHoRollModel);
                return netRoll;
            }
            catch (NoSuchConnection noSuchConnection) {
                return null;
            }
        }
        return null;
    }

    public List getRolls(INetCircuit iNetCircuit) {
        if (RollManager.dbgOn()) {
            db.println("calling getRolls on circuit: " + iNetCircuit.getCircuitName());
        }
        List list = iNetCircuit.getCircuitNodes();
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        for (NetCircuitNode netCircuitNode : list) {
            if (netCircuitNode == null || !this.brNodes.contains(netCircuitNode.getNodeModel())) continue;
            linkedList.add(netCircuitNode.getConn());
            if (!netCircuitNode.hasDualConnections()) continue;
            linkedList.add(((DualConnectionCircuitNode)netCircuitNode).getSecConn());
        }
        return this.getRolls(linkedList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRolls() {
        LinkedList linkedList;
        List list = this.netRolls;
        synchronized (list) {
            linkedList = new LinkedList(this.netRolls);
        }
        return linkedList;
    }

    public List getRolls(INodeModel iNodeModel) {
        ArrayList<NetRoll> arrayList = new ArrayList<NetRoll>();
        INetElement iNetElement = null;
        NetRoll netRoll2 = null;
        INetElement iNetElement2 = null;
        if (iNodeModel != null) {
            iNetElement = Network.instance().findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            for (NetRoll netRoll2 : this.getRolls()) {
                iNetElement2 = netRoll2.getNetElement();
                if (iNetElement2 != iNetElement) continue;
                arrayList.add(netRoll2);
            }
        }
        return arrayList;
    }

    public List getRolls(List list) {
        INodeModel iNodeModel = null;
        IConnectionModel iConnectionModel = null;
        Object var4_4 = null;
        LinkedList<NetRoll> linkedList = new LinkedList<NetRoll>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iConnectionModel = null;
            iNodeModel = null;
            var4_4 = null;
            iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel != null) {
                iNodeModel = iConnectionModel.getNodeModel();
            }
            if (iNodeModel == null) continue;
            IConnectionModels iConnectionModels = iNodeModel.getNodeModel().getConnectionModels();
            try {
                NetRoll netRoll;
                IHoRollModel iHoRollModel = null;
                if (iConnectionModel instanceof IHoConnectionModel) {
                    iHoRollModel = iConnectionModels.getHoRollModels(iConnectionModel.getIndex());
                } else if (iConnectionModel instanceof ILoConnectionModel) {
                    iHoRollModel = iConnectionModels.getLoRollModels(iConnectionModel.getIndex());
                }
                if ((netRoll = this.findNetRoll((IRollModel)iHoRollModel)) == null) continue;
                linkedList.add(netRoll);
            }
            catch (NoSuchConnection noSuchConnection) {
                SDebug.printStackTrace((Throwable)noSuchConnection);
            }
        }
        return linkedList;
    }

    public boolean hasRollsInNetwork() {
        return this.netRolls.size() > 0;
    }

    public boolean isRollEnabledNetwork() {
        return this.brNodes.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBNRNodes() {
        LinkedList linkedList;
        List list = this.brNodes;
        synchronized (list) {
            linkedList = new LinkedList(this.brNodes);
        }
        return linkedList;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                NetElement netElement = (NetElement)object;
                if (RollManager.dbgOn()) {
                    db.println("update: received update about new NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    if (RollManager.dbgOn()) {
                        db.println("update: NE has invalid node ID, continue monitoring CHANGED event");
                    }
                    netElement.addObserver(this);
                } else {
                    if (RollManager.dbgOn()) {
                        db.println("update: NE has valid node ID, adding new NE");
                    }
                    this.newNetElement(netElement);
                }
            }
        } else if (iObservable instanceof NetElement) {
            NetElement netElement = (NetElement)iObservable;
            if (object == ModelUpdateType.CHANGED) {
                if (RollManager.dbgOn()) {
                    db.println("update: received CHANGED event from NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() != 0 && netElement.getNodeId() != -1) {
                    if (RollManager.dbgOn()) {
                        db.println("update: NE has valid node ID, adding new NE");
                    }
                    netElement.deleteObserver(this);
                    this.newNetElement(netElement);
                }
            }
        }
    }

    private void newNetElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.neList.add(iNetElement);
        }
    }

    private void newRollElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.rollList.add(iNetElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdates() {
        SequencedCollection<INetElement> sequencedCollection;
        INetElement iNetElement = null;
        INodeModel iNodeModel = null;
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        while (this.neList.size() != 0) {
            try {
                sequencedCollection = this.neList;
                synchronized (sequencedCollection) {
                    iNetElement = (INetElement)this.neList.first();
                    this.neList.remove(iNetElement);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            if (iNetElement == null || iNetElement.isDeleted()) {
                if (!RollManager.dbgOn()) continue;
                db.println("NetElement is null!");
                continue;
            }
            iNodeModel = iNetElement.getNodeModel();
            if (iNodeModel == null) {
                if (!RollManager.dbgOn()) continue;
                db.println(iNetElement.getName() + ": Node model is null");
                continue;
            }
            if (!iNodeModel.isInited()) {
                if (RollManager.dbgOn()) {
                    db.println(iNetElement.getName() + ": node not initialized");
                    db.println("putting back in queue");
                }
                linkedList.add(iNetElement);
                continue;
            }
            this.addNode(iNodeModel);
        }
        if (linkedList.size() != 0) {
            this.neList.addAll(linkedList);
        }
        sequencedCollection = new LinkedList();
        while (this.rollList.size() != 0) {
            try {
                SortedSet sortedSet = this.rollList;
                synchronized (sortedSet) {
                    iNetElement = (INetElement)this.rollList.first();
                    this.rollList.remove(iNetElement);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            if (iNetElement == null || iNetElement.isDeleted()) {
                if (!RollManager.dbgOn()) continue;
                db.println("NetElement is null!");
                continue;
            }
            iNodeModel = iNetElement.getNodeModel();
            if (iNodeModel == null) {
                if (!RollManager.dbgOn()) continue;
                db.println(iNetElement.getName() + ": Node model is null");
                continue;
            }
            if (!iNodeModel.isInited()) {
                if (RollManager.dbgOn()) {
                    db.println(iNetElement.getName() + ": node not initialized");
                    db.println("putting back in queue");
                }
                sequencedCollection.add(iNetElement);
                continue;
            }
            this.discoverRollsOnNode(iNodeModel);
        }
        if (sequencedCollection.size() != 0) {
            this.rollList.addAll(sequencedCollection);
        }
    }

    private synchronized void addNode(INodeModel iNodeModel) {
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        ModelIndirectObservable.instance().addObserver((IObservable)iConnectionModels, this.rollObserver);
        if (this.isBridgeAndRollSupported(iNodeModel) && !this.brNodes.contains(iNodeModel)) {
            if (RollManager.dbgOn()) {
                db.println("[addNode] Adding NE (" + iNodeModel.getName() + ")");
            }
            this.brNodes.add(iNodeModel);
            this.discoverRollsOnNode(iNodeModel);
        }
    }

    private synchronized void removeNode(INodeModel iNodeModel) {
        if (this.brNodes.contains(iNodeModel)) {
            if (RollManager.dbgOn()) {
                db.println("[removeNode] Removing NE (" + iNodeModel.getName() + ")");
            }
            this.brNodes.remove(iNodeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getRollsHashSet(INodeModel iNodeModel) {
        HashSet hashSet = new HashSet();
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            iNetElement = Network.instance().findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            List list = this.netRolls;
            synchronized (list) {
                hashSet = new HashSet(this.netRolls);
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getRollsHashSet() {
        HashSet hashSet;
        List list = this.netRolls;
        synchronized (list) {
            hashSet = new HashSet(this.netRolls);
        }
        return hashSet;
    }

    public HashSet getRollsHashSet(List list) {
        INodeModel iNodeModel = null;
        IConnectionModel iConnectionModel = null;
        INetElement iNetElement = null;
        HashSet<NetRoll> hashSet = new HashSet<NetRoll>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iConnectionModel = null;
            iNodeModel = null;
            iNetElement = null;
            iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel != null) {
                iNodeModel = iConnectionModel.getNodeModel();
            }
            if (iNodeModel != null) {
                iNetElement = Network.instance().findNetElem(iNodeModel);
            }
            if (iNetElement == null) continue;
            List list2 = this.getRolls(iNodeModel);
            for (NetRoll netRoll : list2) {
                hashSet.add(netRoll);
            }
        }
        return hashSet;
    }

    private String getBulkRollError(INetElement iNetElement, String string, List list, List list2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (IHoPathFailedRoll iHoPathFailedRoll : list) {
            stringBuffer.append("\nRollFrom = ");
            stringBuffer.append(iNetElement.getName());
            stringBuffer.append("/");
            stringBuffer.append(NetRoll.slashSeparatedStr(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, iHoPathFailedRoll.getRollFromPath())));
            stringBuffer.append(", RollTo = ");
            stringBuffer.append(iNetElement.getName());
            stringBuffer.append("/");
            stringBuffer.append(NetRoll.slashSeparatedStr(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, iHoPathFailedRoll.getRollToPath())));
            stringBuffer.append(", Reason = ");
            stringBuffer.append(EnumStrings.getString(IRollError.class, (int)iHoPathFailedRoll.getRollError()));
        }
        for (IHoPathFailedRoll iHoPathFailedRoll : list2) {
            stringBuffer.append("\nRollFrom = ");
            stringBuffer.append(iNetElement.getName());
            stringBuffer.append("/");
            stringBuffer.append(NetRoll.slashSeparatedStr(NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, iHoPathFailedRoll.getRollFromPath())));
            stringBuffer.append(", RollTo = ");
            stringBuffer.append(iNetElement.getName());
            stringBuffer.append("/");
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, iHoPathFailedRoll.getRollToPath());
            stringBuffer.append(NetRoll.slashSeparatedStr(netCircuitEnd));
            if (string.equals("Error creating roll:")) {
                netCircuitEnd.cleanupLoAdit();
            }
            stringBuffer.append(", Reason = ");
            stringBuffer.append(EnumStrings.getString(IRollError.class, (int)iHoPathFailedRoll.getRollError()));
        }
        return stringBuffer.toString();
    }

    private String getSingleRollError(NetRoll netRoll, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nRollFrom = ");
        stringBuffer.append(netRoll.getNetElement().getName());
        stringBuffer.append("/");
        stringBuffer.append(NetRoll.slashSeparatedStr(netRoll.getRollFromCktEnd()));
        stringBuffer.append(", RollTo = ");
        stringBuffer.append(netRoll.getNetElement().getName());
        stringBuffer.append("/");
        stringBuffer.append(NetRoll.slashSeparatedStr(netRoll.getRollToCktEnd()));
        stringBuffer.append(", Reason = ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private String getSingleRollError(RollCreateInfo rollCreateInfo, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nRollFrom = ");
        stringBuffer.append(rollCreateInfo.getRollFromNetCircuitEnd().getNetElement().getName());
        stringBuffer.append("/");
        stringBuffer.append(NetRoll.slashSeparatedStr(rollCreateInfo.getRollFromNetCircuitEnd()));
        stringBuffer.append(", RollTo = ");
        stringBuffer.append(rollCreateInfo.getRollToNetCircuitEnd().getNetElement().getName());
        stringBuffer.append("/");
        stringBuffer.append(NetRoll.slashSeparatedStr(rollCreateInfo.getRollToNetCircuitEnd()));
        stringBuffer.append(", Reason = ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected static boolean pkgDbgOn() {
        return pkgDb.on();
    }

    protected static boolean dbgOn() {
        return db.on() || RollManager.pkgDbgOn();
    }

    static {
        db = new SDebug("RollManager");
        pkgDb = new SDebug("BnrPackage");
        HO_ROLL = 1;
        LO_ROLL = 2;
    }

    public class DumpDebug
    extends SDebug
    implements IDebugDiag {
        public DumpDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            RollManager rollManager;
            RollManager rollManager2 = rollManager = RollManager.instance();
            synchronized (rollManager2) {
                if (!this.on()) {
                    this.set();
                }
                for (NetRoll netRoll : RollManager.this.getRolls()) {
                    netRoll.prettyPrint(this);
                    this.println("==========================================================");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpBNRCapableNodes() {
            RollManager rollManager;
            RollManager rollManager2 = rollManager = RollManager.instance();
            synchronized (rollManager2) {
                if (!this.on()) {
                    this.set();
                }
                for (INodeModel iNodeModel : RollManager.this.getBNRNodes()) {
                    this.println(iNodeModel.getName());
                }
            }
        }

        public void dumpDiag() {
            this.dump();
        }
    }

    class RollObserver
    implements IObserver {
        RollObserver() {
        }

        public void update(IObservable iObservable, Object object) {
            if (iObservable instanceof IConnectionModels) {
                INodeModel iNodeModel = ((IConnectionModels)iObservable).getNodeModel();
                INetElement iNetElement = Network.instance().findNetElem(iNodeModel);
                if (iNetElement == null && RollManager.dbgOn()) {
                    db.println("RollManager unable to find NetElem in update method");
                    db.println(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
                }
                if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                    if (RollManager.dbgOn()) {
                        db.println("update: received ADDED event from ConnectionModels");
                    }
                    if (!RollManager.this.brNodes.contains(iNodeModel)) {
                        RollManager.this.newNetElement(iNetElement);
                    } else {
                        RollManager.this.newRollElement(iNetElement);
                    }
                } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                    if (RollManager.dbgOn()) {
                        db.println("update: received DELETED event from ConnectionModels");
                    }
                    RollManager.this.removeNode(iNodeModel);
                }
            }
        }
    }
}

