/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.SvlanPathDefModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class SvlanCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("SvlanCircuitEnd");
    private short svlan;

    public SvlanCircuitEnd() {
    }

    public SvlanCircuitEnd(short s) {
        this.svlan = s;
        if (this.dbgOn()) {
            db.fine("SvlanCircuitEnd: svlan ctorSVLAN = " + s);
        }
    }

    public SvlanCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd, short s) {
        super(iNodeModel, iCircuitEnd);
        this.svlan = s;
        if (this.dbgOn()) {
            db.fine("SvlanCircuitEnd: port = " + Integer.toHexString(iCircuitEnd.getPortNum()) + " SVLAN = " + s);
        }
    }

    public SvlanCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        if (iNetCircuitEnd instanceof SvlanCircuitEnd) {
            SvlanCircuitEnd svlanCircuitEnd = (SvlanCircuitEnd)iNetCircuitEnd;
            this.svlan = svlanCircuitEnd.getSvlan();
            if (this.dbgOn()) {
                db.fine("SvlanCircuitEnd copy ctor: port = " + Integer.toHexString(iNetCircuitEnd.getEntityIndex()) + " SVLAN = " + this.svlan);
            }
        }
    }

    public SvlanCircuitEnd(INetElement iNetElement, Object object) {
        int n = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n2 = 0;
        if (object instanceof ISvlanPathDefModel) {
            ISvlanPathDefModel iSvlanPathDefModel = (ISvlanPathDefModel)object;
            n = iSvlanPathDefModel.getPortEntityIdx();
            this.svlan = iSvlanPathDefModel.getSvlan();
            if (this.dbgOn()) {
                db.fine("SvlanCircuitEnd ctor with path: port = " + Integer.toHexString(n) + " SVLAN = " + this.svlan);
            }
            n2 = 4;
        } else if (this.dbgOn()) {
            db.println("Warning! SvlanCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n, null, null, false, 0));
        this.setStage(n2);
    }

    public Object getPathDef(short s) throws ObjNotFound {
        SvlanPathDefModel svlanPathDefModel = new SvlanPathDefModel(this.getNodeModel(), this.svlan, this.getEntityIndex(), s);
        return svlanPathDefModel;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof SvlanCircuitEnd) {
            SvlanCircuitEnd svlanCircuitEnd = (SvlanCircuitEnd)object;
            bl = svlanCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && svlanCircuitEnd.getCircuitEnd().getPortNum() == this.getCircuitEnd().getPortNum() && svlanCircuitEnd.getSvlan() == this.getSvlan();
        }
        return bl;
    }

    public String prettyString() {
        if (this.getNodeModel() == null) {
            return "Unknown::" + this.getSvlan();
        }
        String string = this.getNodeModel().getName() + "::";
        string = string + Integer.toHexString(this.getCircuitEnd().getPortNum()) + "c";
        string = string + "::" + this.getSvlan();
        string = string + " (" + this.getClass().getName() + ")";
        return string;
    }

    public short getSvlan() {
        return this.svlan;
    }
}

