/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.SvlanPathDefModel;
import cerent.cms.ncp.INetCircuitProvState;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.SvlanCircuitEnd;
import cerent.cms.ncp.SvlanCircuitNodeOperator;
import cerent.cms.ncp.SvlanCircuitSpan;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SvlanCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("SvlanCircuitNode");
    private ISvlanConnectionModel svlanConn;
    private int internalIndex;
    protected SvlanCircuitNodeOperator operator;

    public SvlanCircuitNode(INetElement iNetElement, SvlanCircuit svlanCircuit) {
        super(iNetElement, svlanCircuit);
        this.connName = svlanCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)svlanCircuit.getCircuitSize();
        this.operator = new SvlanCircuitNodeOperator(this);
    }

    public SvlanCircuitNode(INetElement iNetElement, SvlanCircuit svlanCircuit, Object object) {
        super(iNetElement, svlanCircuit, object);
        this.ne = iNetElement;
        this.connName = this.getConnNameFromNE();
        svlanCircuit.setChanged();
        this.pathWidth = (short)svlanCircuit.getCircuitSize();
        this.operator = new SvlanCircuitNodeOperator(this);
    }

    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    protected int getConnTypeFromConnModel() {
        ISvlanConnectionModel iSvlanConnectionModel = this.svlanConn;
        if (iSvlanConnectionModel != null) {
            return iSvlanConnectionModel.getConnectionType();
        }
        return 22;
    }

    protected Object[] getPathsFromConnModel() {
        ISvlanConnectionModel iSvlanConnectionModel = this.svlanConn;
        if (iSvlanConnectionModel != null) {
            return iSvlanConnectionModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    public void setInternalEntityIdx(int n) {
        this.internalIndex = n;
    }

    public int getInternalEntityIdx() {
        return this.internalIndex;
    }

    protected IPathDefModel getInternalPathDef() throws ObjNotFound {
        if (this.getInternalEntityIdx() == 0) {
            throw new ObjNotFound("No internal entity found.");
        }
        if (this.dbgOn()) {
            db.println("getInternalPathDef for " + this.getName() + " SVLAN = " + this.getSvlan());
        }
        SvlanPathDefModel svlanPathDefModel = new SvlanPathDefModel(this.ne.getNodeModel(), this.getSvlan(), this.getInternalEntityIdx(), this.pathWidth);
        return svlanPathDefModel;
    }

    public short getSvlan() {
        if (this.svlanConn != null) {
            return this.svlanConn.getSvlan();
        }
        return ((SvlanCircuit)this.getCircuit()).getSvlan();
    }

    protected void removeActiveEndpoint(NetCircuitSpan netCircuitSpan) {
        int n = netCircuitSpan.getEntityIndex(this.ne);
        if (netCircuitSpan.isInternalSpan()) {
            n = netCircuitSpan.getInternalEntityIndex(this);
        }
        if (this.dbgOn()) {
            db.println("Removing active ckt end on " + this.getName() + "  for " + Integer.toHexString(n));
        }
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getEntityIndex() != n) continue;
                if (this.dbgOn()) {
                    db.println("Removing active ckt end " + netCircuitEnd.prettyString());
                }
                iterator.remove();
            }
            iterator = this.drops.iterator();
        }
    }

    protected int removeRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.numRoutedPaths() == 0) {
            this.setState(2);
        } else {
            List list = this.getPathList();
            ISvlanPathDefModel iSvlanPathDefModel = null;
            boolean bl = false;
            for (Object e : list) {
                iSvlanPathDefModel = (ISvlanPathDefModel)e;
                if (netCircuitSpan.isInternalSpan()) {
                    if (iSvlanPathDefModel.getPortEntityIdx() == netCircuitSpan.getInternalEntityIndex(this)) {
                        bl = true;
                    }
                } else if (iSvlanPathDefModel.getPortEntityIdx() == netCircuitSpan.getEntityIndex(this.getNetElement())) {
                    bl = true;
                }
                if (!bl) continue;
                try {
                    if (this.dbgOn()) {
                        db.println("Removing connected output from connection");
                    }
                    this.operator.removeOutput(iSvlanPathDefModel);
                }
                catch (CTCUserException cTCUserException) {
                    if (!this.dbgOn()) break;
                    db.println("Exception removing connected output from connection");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                break;
            }
        }
        this.removeSpan(netCircuitSpan, eSpanDirection2);
        return this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
    }

    protected boolean completeCheck() {
        int n = this.countNumInputs() + this.countNumOutputs();
        if (this.dbgOn()) {
            db.println("completeCheck for ckt " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at node " + this.getName() + " in = " + this.countNumInputs() + " out = " + this.countNumOutputs() + ": In+Out=" + n + ", numberOfPaths=" + this.numberOfPaths);
        }
        if (n == this.numberOfPaths && n > 1) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    protected int findConnType() {
        return 21;
    }

    protected int findUpgradedConnType() {
        return 21;
    }

    protected eSpanDirection findRoutingDir(NetCircuitSpan netCircuitSpan) {
        if (this.findDir(netCircuitSpan) == eSpanDirection.BIDIRECTIONAL) {
            if (netCircuitSpan.isInternalSpan()) {
                Object object2;
                LinkedList linkedList = this.getBiSpans();
                for (Object object2 : linkedList) {
                    if (((NetCircuitSpan)object2).isInternalSpan()) continue;
                    if (((NetCircuitSpan)object2).biSpanDir(this.ne) == eSpanDirection.ORIGINATING) {
                        if (this.dbgOn()) {
                            db.println("findRoutingDir: node " + this.getName() + " span = ORIG return TERM for internal.");
                        }
                        return eSpanDirection.TERMINATING;
                    }
                    if (this.dbgOn()) {
                        db.println("findRoutingDir: node " + this.getName() + " span = TERM return ORIG for internal.");
                    }
                    return eSpanDirection.ORIGINATING;
                }
                List list = this.getSources();
                if (list != null && list.size() > 0) {
                    if (this.dbgOn()) {
                        db.println("findRoutingDir: node " + this.getName() + " found a src return ORIG for internal.");
                    }
                    return eSpanDirection.ORIGINATING;
                }
                object2 = this.getDrops();
                if (object2 != null && object2.size() > 0) {
                    if (this.dbgOn()) {
                        db.println("findRoutingDir: node " + this.getName() + " found a drop return TERM for internal.");
                    }
                    return eSpanDirection.TERMINATING;
                }
                if (this.dbgOn()) {
                    db.println("findRoutingDir: node " + this.getName() + " WARNING!!! not found external span nor src nor drops.");
                }
                return netCircuitSpan.biSpanDir(this.ne);
            }
            return netCircuitSpan.biSpanDir(this.ne);
        }
        return this.findDir(netCircuitSpan);
    }

    protected NetCircuitNode spanGetPeer(NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                this.debug("spanGetPeer: null span");
            }
            return null;
        }
        if (netCircuitSpan.isInternalSpan()) {
            SvlanCircuitNode svlanCircuitNode = (SvlanCircuitNode)netCircuitSpan.getSrcNCN();
            if (svlanCircuitNode.getInternalEntityIdx() == this.getInternalEntityIdx()) {
                return (NetCircuitNode)netCircuitSpan.getDstNCN();
            }
            return svlanCircuitNode;
        }
        if (this.ne == netCircuitSpan.getLink().getDst()) {
            return (NetCircuitNode)netCircuitSpan.getSrcNCN();
        }
        return (NetCircuitNode)netCircuitSpan.getDstNCN();
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setConnectionCircuitId SVLAN circuit, shouldn't be called");
        }
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        CircuitEnd circuitEnd = new CircuitEnd();
        circuitEnd.setNodeId(this.ne.getNodeId());
        if (netCircuitSpan.isInternalSpan()) {
            circuitEnd.setPortNum(netCircuitSpan.getInternalEntityIndex(this));
        } else {
            circuitEnd.setPortNum(netCircuitSpan.getEntityIndex(this.ne));
        }
        circuitEnd.setDropProt(false);
        return new SvlanCircuitEnd(this.ne.getNodeModel(), circuitEnd, ((SvlanCircuitSpan)netCircuitSpan).getSvlan());
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.svlanConn != null) {
            return this.svlanConn.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.dbgOn()) {
            db.println("SVLAN addOutputToConnModel: the Drop is already set by QinQ ");
        }
        if (this.svlanConn != null) {
            if (this.dbgOn()) {
                db.println("SVLAN addOutputToConnModel: update the connection paths");
            }
            ISvlanPathDefModel iSvlanPathDefModel = (ISvlanPathDefModel)netCircuitEnd.getPathDef(this.pathWidth);
            this.operator.addPathsToConnectionModel(iSvlanPathDefModel);
        }
    }

    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.svlanConn != null) {
            if (this.dbgOn()) {
                db.println("SVLAN addOutputToConnModel: update the connection paths");
            }
            ISvlanPathDefModel iSvlanPathDefModel = netCircuitSpan.isInternalSpan() ? (ISvlanPathDefModel)netCircuitSpan.getPathDef(this, this.pathWidth) : (ISvlanPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.operator.addOutput(iSvlanPathDefModel);
        }
    }

    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.svlanConn != null) {
            if (this.dbgOn()) {
                db.println("SVLAN removeOutputFromConnModel: update the connection paths");
            }
            ISvlanPathDefModel iSvlanPathDefModel = (ISvlanPathDefModel)((SvlanCircuitEnd)netCircuitEnd).getPathDef(this.pathWidth);
            this.operator.removeOutput(iSvlanPathDefModel);
        }
    }

    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.dbgOn()) {
            db.println("SVLAN removeOutputFromConnModel(span) on node: " + this.getName());
        }
        if (this.svlanConn != null) {
            if (this.dbgOn()) {
                db.println("SVLAN removeOutputFromConnModel: update the connection paths");
            }
            ISvlanPathDefModel iSvlanPathDefModel = netCircuitSpan.isInternalSpan() ? (ISvlanPathDefModel)netCircuitSpan.getPathDef(this, this.pathWidth) : (ISvlanPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.operator.removeOutput(iSvlanPathDefModel);
        }
    }

    protected void setupConnListOnDiscovery() {
        this.connections = new LinkedList();
    }

    protected void setupConnListOnCreation(int n) {
        this.connections = new LinkedList();
    }

    public IConnectionModel getConn() {
        return this.svlanConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.svlanConn = (ISvlanConnectionModel)iConnectionModel;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }

    protected void prettyPrint(SDebug sDebug) {
        NetCircuitEnd netCircuitEnd;
        if (!sDebug.on()) {
            return;
        }
        sDebug.println(" NODE " + this.getName() + " (" + this.getClass().getName() + ")");
        sDebug.print("   State=" + EnumStrings.getString(INetCircuitProvState.class, (int)this.state));
        sDebug.print(" | CktId=" + NetCircuit.prettyString(this.cktId));
        sDebug.println(" | ConnType=" + (this.connType == 22 ? "Unknown" : EnumStrings.getString(IConnectionType.class, (int)this.connType)));
        sDebug.print("   ConnName=\"" + this.connName + "\"");
        sDebug.print(" | AdminState= " + SvlanCircuitNode.translateAdminState(this.adminState));
        sDebug.println(" | ServiceState= " + SvlanCircuitNode.translateServiceState(this.serviceState));
        sDebug.print("   Src " + this.sources.size());
        sDebug.print(" | Drp " + this.drops.size());
        if (this.nodeDrop != null) {
            sDebug.print(" (Node Drop)");
        }
        sDebug.print(" | Term " + this.inSpans.size());
        sDebug.print(" | Orig " + this.outSpans.size());
        sDebug.print(" | Bi " + this.biSpans.size());
        sDebug.print(" | Path " + this.numberOfPaths);
        sDebug.println(" | Spl " + this.spliceListeners.size());
        Iterator iterator = this.sources.iterator();
        sDebug.println(" Sources: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        iterator = this.drops.iterator();
        sDebug.println(" Drops: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        if (this.nodeDrop != null) {
            sDebug.println(" NodeDrop: ");
            sDebug.println("  " + this.nodeDrop.prettyString());
        }
        List list = this.getPathList();
        ISvlanPathDefModel[] iSvlanPathDefModelArray = list.toArray(new ISvlanPathDefModel[0]);
        sDebug.println(" ConnPaths: ");
        for (int i = 0; i < iSvlanPathDefModelArray.length; ++i) {
            sDebug.print("  Path #" + i + ": " + Integer.toHexString(iSvlanPathDefModelArray[i].getPortEntityIdx()));
            if (iSvlanPathDefModelArray[i].getPortEntityIdx() == this.getInternalEntityIdx()) {
                sDebug.println(" Internal");
                continue;
            }
            sDebug.println("");
        }
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("SvlanCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("SvlanCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("SvlanCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }
}

